//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QDomDocument;
import org.kde.qt.QtSupport;
import org.kde.qt.QDataStream;
import java.util.ArrayList;
import java.util.Date;

/**

 		@short A namespace for KIO globals.

*/
public class KIO {
	/**	
		 Identifiers for KIO informational messages.
		  		@short    Identifiers for KIO informational messages.
	*/
	public static final int INF_TOTAL_SIZE = 10;
	public static final int INF_PROCESSED_SIZE = 11;
	public static final int INF_SPEED = 12;
	public static final int INF_REDIRECTION = 20;
	public static final int INF_MIME_TYPE = 21;
	public static final int INF_ERROR_PAGE = 22;
	public static final int INF_WARNING = 23;
	public static final int INF_GETTING_FILE = 24;
	public static final int INF_NEED_PASSWD = 25;
	public static final int INF_INFOMESSAGE = 26;
	public static final int INF_META_DATA = 27;
	public static final int INF_NETWORK_STATUS = 28;
	public static final int INF_MESSAGEBOX = 29;

	/**	
		 Identifiers for KIO data messages.
		  		@short    Identifiers for KIO data messages.
	*/
	public static final int MSG_DATA = 100;
	public static final int MSG_DATA_REQ = 101;
	public static final int MSG_ERROR = 102;
	public static final int MSG_CONNECTED = 103;
	public static final int MSG_FINISHED = 104;
	public static final int MSG_STAT_ENTRY = 105;
	public static final int MSG_LIST_ENTRIES = 106;
	public static final int MSG_RENAMED = 107;
	public static final int MSG_RESUME = 108;
	public static final int MSG_SLAVE_STATUS = 109;
	public static final int MSG_SLAVE_ACK = 110;
	public static final int MSG_NET_REQUEST = 111;
	public static final int MSG_NET_DROP = 112;
	public static final int MSG_NEED_SUBURL_DATA = 113;
	public static final int MSG_CANRESUME = 114;
	public static final int MSG_AUTH_KEY = 115;
	public static final int MSG_DEL_AUTH_KEY = 116;

	/**	
		 Commands that can be invoked by a job.
		   		@short    Commands that can be invoked by a job.
	*/
	public static final int CMD_HOST = '0';
	public static final int CMD_CONNECT = '1';
	public static final int CMD_DISCONNECT = '2';
	public static final int CMD_SLAVE_STATUS = '3';
	public static final int CMD_SLAVE_CONNECT = '4';
	public static final int CMD_SLAVE_HOLD = '5';
	public static final int CMD_NONE = 'A';
	public static final int CMD_TESTDIR = 'B';
	public static final int CMD_GET = 'C';
	public static final int CMD_PUT = 'D';
	public static final int CMD_STAT = 'E';
	public static final int CMD_MIMETYPE = 'F';
	public static final int CMD_LISTDIR = 'G';
	public static final int CMD_MKDIR = 'H';
	public static final int CMD_RENAME = 'I';
	public static final int CMD_COPY = 'J';
	public static final int CMD_DEL = 'K';
	public static final int CMD_CHMOD = 'L';
	public static final int CMD_SPECIAL = 'M';
	public static final int CMD_USERPASS = 'N';
	public static final int CMD_REPARSECONFIGURATION = 'O';
	public static final int CMD_META_DATA = 'P';
	public static final int CMD_SYMLINK = 'Q';
	public static final int CMD_SUBURL = 'R';
	public static final int CMD_MESSAGEBOXANSWER = 'S';
	public static final int CMD_RESUMEANSWER = 'T';
	public static final int CMD_CONFIG = 'U';
	public static final int CMD_MULTI_GET = 'V';

	/**	
		 Error codes that can be emitted by KIO.
		   		@short    Error codes that can be emitted by KIO.
	*/
	public static final int ERR_CANNOT_OPEN_FOR_READING = 1;
	public static final int ERR_CANNOT_OPEN_FOR_WRITING = 2;
	public static final int ERR_CANNOT_LAUNCH_PROCESS = 3;
	public static final int ERR_INTERNAL = 4;
	public static final int ERR_MALFORMED_URL = 5;
	public static final int ERR_UNSUPPORTED_PROTOCOL = 6;
	public static final int ERR_NO_SOURCE_PROTOCOL = 7;
	public static final int ERR_UNSUPPORTED_ACTION = 8;
	public static final int ERR_IS_DIRECTORY = 9;
	public static final int ERR_IS_FILE = 10;
	public static final int ERR_DOES_NOT_EXIST = 11;
	public static final int ERR_FILE_ALREADY_EXIST = 12;
	public static final int ERR_DIR_ALREADY_EXIST = 13;
	public static final int ERR_UNKNOWN_HOST = 14;
	public static final int ERR_ACCESS_DENIED = 15;
	public static final int ERR_WRITE_ACCESS_DENIED = 16;
	public static final int ERR_CANNOT_ENTER_DIRECTORY = 17;
	public static final int ERR_PROTOCOL_IS_NOT_A_FILESYSTEM = 18;
	public static final int ERR_CYCLIC_LINK = 19;
	public static final int ERR_USER_CANCELED = 20;
	public static final int ERR_CYCLIC_COPY = 21;
	public static final int ERR_COULD_NOT_CREATE_SOCKET = 22;
	public static final int ERR_COULD_NOT_CONNECT = 23;
	public static final int ERR_CONNECTION_BROKEN = 24;
	public static final int ERR_NOT_FILTER_PROTOCOL = 25;
	public static final int ERR_COULD_NOT_MOUNT = 26;
	public static final int ERR_COULD_NOT_UNMOUNT = 27;
	public static final int ERR_COULD_NOT_READ = 28;
	public static final int ERR_COULD_NOT_WRITE = 29;
	public static final int ERR_COULD_NOT_BIND = 30;
	public static final int ERR_COULD_NOT_LISTEN = 31;
	public static final int ERR_COULD_NOT_ACCEPT = 32;
	public static final int ERR_COULD_NOT_LOGIN = 33;
	public static final int ERR_COULD_NOT_STAT = 34;
	public static final int ERR_COULD_NOT_CLOSEDIR = 35;
	public static final int ERR_COULD_NOT_MKDIR = 37;
	public static final int ERR_COULD_NOT_RMDIR = 38;
	public static final int ERR_CANNOT_RESUME = 39;
	public static final int ERR_CANNOT_RENAME = 40;
	public static final int ERR_CANNOT_CHMOD = 41;
	public static final int ERR_CANNOT_DELETE = 42;
	public static final int ERR_SLAVE_DIED = 43;
	public static final int ERR_OUT_OF_MEMORY = 44;
	public static final int ERR_UNKNOWN_PROXY_HOST = 45;
	public static final int ERR_COULD_NOT_AUTHENTICATE = 46;
	public static final int ERR_ABORTED = 47;
	public static final int ERR_INTERNAL_SERVER = 48;
	public static final int ERR_SERVER_TIMEOUT = 49;
	public static final int ERR_SERVICE_NOT_AVAILABLE = 50;
	public static final int ERR_UNKNOWN = 51;
	public static final int ERR_UNKNOWN_INTERRUPT = 53;
	public static final int ERR_CANNOT_DELETE_ORIGINAL = 54;
	public static final int ERR_CANNOT_DELETE_PARTIAL = 55;
	public static final int ERR_CANNOT_RENAME_ORIGINAL = 56;
	public static final int ERR_CANNOT_RENAME_PARTIAL = 57;
	public static final int ERR_NEED_PASSWD = 58;
	public static final int ERR_CANNOT_SYMLINK = 59;
	public static final int ERR_NO_CONTENT = 60;
	public static final int ERR_DISK_FULL = 61;
	public static final int ERR_IDENTICAL_FILES = 62;
	public static final int ERR_SLAVE_DEFINED = 63;
	public static final int ERR_UPGRADE_REQUIRED = 64;
	public static final int ERR_POST_DENIED = 65;

	/**	
		 Constants used to specify the type of a KUDSAtom.
		   		@short    Constants used to specify the type of a KUDSAtom.
	*/
	public static final int UDS_STRING = 1;
	public static final int UDS_LONG = 2;
	public static final int UDS_TIME = 4|UDS_LONG;
	public static final int UDS_SIZE = 8|UDS_LONG;
	public static final int UDS_SIZE_LARGE = 32768|UDS_LONG;
	public static final int UDS_USER = 16|UDS_STRING;
	public static final int UDS_ICON_NAME = 24|UDS_STRING;
	public static final int UDS_GROUP = 32|UDS_STRING;
	public static final int UDS_EXTRA = 48|UDS_STRING;
	public static final int UDS_NAME = 64|UDS_STRING;
	public static final int UDS_ACCESS = 128|UDS_LONG;
	public static final int UDS_MODIFICATION_TIME = 256|UDS_TIME;
	public static final int UDS_ACCESS_TIME = 512|UDS_TIME;
	public static final int UDS_CREATION_TIME = 1024|UDS_TIME;
	public static final int UDS_FILE_TYPE = 2048|UDS_LONG;
	public static final int UDS_LINK_DEST = 4096|UDS_STRING;
	public static final int UDS_URL = 8192|UDS_STRING;
	public static final int UDS_MIME_TYPE = 16384|UDS_STRING;
	public static final int UDS_GUESSED_MIME_TYPE = 16392|UDS_STRING;
	public static final int UDS_XML_PROPERTIES = 32768|UDS_STRING;

	/**	
		 Specifies how to use the cache.
				@short    Specifies how to use the cache.
		@see #parseCacheControl
		@see #getCacheControlString
	*/
	public static final int CC_CacheOnly = 0;
	public static final int CC_Cache = 1;
	public static final int CC_Verify = 2;
	public static final int CC_Refresh = 3;
	public static final int CC_Reload = 4;

	public static final int SupportsChmod = 0;
	public static final int SupportsChown = 1;
	public static final int SupportsUTime = 2;
	public static final int SupportsSymlinks = 3;
	public static final int CaseInsensitive = 4;

	public static final int DEFAULT = 1;
	public static final int STATUSBAR = 2;
	public static final int LIST = 3;

	public static final int M_OVERWRITE = 1;
	public static final int M_OVERWRITE_ITSELF = 2;
	public static final int M_SKIP = 4;
	public static final int M_SINGLE = 8;
	public static final int M_MULTI = 16;
	public static final int M_RESUME = 32;
	public static final int M_NORENAME = 64;

	/**	
		 The result of open_RenameDlg().
		 		@short    The result of open_RenameDlg().
	*/
	public static final int R_RESUME = 6;
	public static final int R_RESUME_ALL = 7;
	public static final int R_OVERWRITE = 4;
	public static final int R_OVERWRITE_ALL = 5;
	public static final int R_SKIP = 2;
	public static final int R_AUTO_SKIP = 3;
	public static final int R_RENAME = 1;
	public static final int R_CANCEL = 0;

	public static final int S_SKIP = 1;
	public static final int S_AUTO_SKIP = 2;
	public static final int S_CANCEL = 0;

	/**	 HTTP / DAV method *		@short   HTTP / DAV method
	*/
	public static final int HTTP_GET = 0;
	public static final int HTTP_PUT = 1;
	public static final int HTTP_POST = 2;
	public static final int HTTP_HEAD = 3;
	public static final int HTTP_DELETE = 4;
	public static final int HTTP_OPTIONS = 5;
	public static final int DAV_PROPFIND = 6;
	public static final int DAV_PROPPATCH = 7;
	public static final int DAV_MKCOL = 8;
	public static final int DAV_COPY = 9;
	public static final int DAV_MOVE = 10;
	public static final int DAV_LOCK = 11;
	public static final int DAV_UNLOCK = 12;
	public static final int DAV_SEARCH = 13;
	public static final int DAV_SUBSCRIBE = 14;
	public static final int DAV_UNSUBSCRIBE = 15;
	public static final int DAV_POLL = 16;
	public static final int DAV_NOTIFY = 17;
	public static final int HTTP_UNKNOWN = -1;

	/**	
		 Converts <code>size</code> from bytes to the string representation.
			@param size size in bytes
				@return converted size as a string - e.g. 123.4 kB , 12.0 MB
   
		@short    Converts <code>size</code> from bytes to the string representation.
	*/
	public static native String convertSize(long size);
	/**	
		 Converts a size to a string representation
		 Not unlike String.number(...)
			@param size size in bytes
				@return converted size as a string - e.g. 123456789
   
		@short    Converts a size to a string representation  Not unlike String.number(.
	*/
	public static native String number(long size);
	/**	
		 Converts size from kilo-bytes to the string representation.
			@param kbsize size in kilo-bytes
				@return converted size as a string - e.g. 123.4 kB , 12.0 MB
   
		@short    Converts size from kilo-bytes to the string representation.
	*/
	public static native String convertSizeFromKB(long kbSize);
	/**	
		 Calculates remaining time from total size, processed size and speed.
			@param totalSize total size in bytes
			@param processedSize processed size in bytes
			@param speed speed in bytes pre second
				@return calculated remaining time
   
		@short    Calculates remaining time from total size, processed size and speed.
	*/
	public static native Date calculateRemaining(long totalSize, long processedSize, long speed);
	/**	
		 Helper for showing information about a set of files and directories
			@param items the number of items (= <code>files</code> + <code>dirs</code> + number of symlinks :)
			@param files the number of files
			@param dirs the number of dirs
			@param size the sum of the size of the <code>files</code>
			@param showSize whether to show the size in the result
				@return the summary string
   
		@short    Helper for showing information about a set of files and directories
	*/
	public static native String itemsSummaryString(int items, int files, int dirs, long size, boolean showSize);
	/**	
		 Encodes (from the text displayed to the real filename)
		 This translates % into %% and / into %2f
		 Used by KIO.link, for instance.
			@param str the file name to encode
				@return the encoded file name
   
		@short    Encodes (from the text displayed to the real filename)  This translates % into %% and / into %2f  Used by KIO.link, for instance.
	*/
	public static native String encodeFileName(String str);
	/**	
		 Decodes (from the filename to the text displayed)
		 This translates %2[fF] into / and %% into %
			@param str the file name to decode
				@return the decoded file name
   
		@short    Decodes (from the filename to the text displayed)  This translates %2[fF] into / and %% into %
	*/
	public static native String decodeFileName(String str);
	/**	
		 Returns a translated error message for <code>errorCode</code> using the
		 additional error information provided by <code>errorText.</code>
			@param errorCode the error code
			@param errorText the additional error text
				@return the created error string
   
		@short    Returns a translated error message for <code>errorCode</code> using the  additional error information provided by <code>errorText.</code>
	*/
	public static native String buildErrorString(int errorCode, String errorText);
	/**	
		 Returns translated error details for <code>errorCode</code> using the
		 additional error information provided by <code>errorText</code> , <code>reqUrl</code>
		 (the request URL), and the ioslave <code>method</code> .
			@param errorCode the error code
			@param errorText the additional error text
			@param reqUrl the request URL
			@param method the ioslave method
		
			<li>
			String errorName - the name of the error
			</li>
			
			<li>
			String techName - if not null, the more technical name of the error
			</li>
			
			<li>
			String description - a description of the error
			</li>
			
			<li>
			ArrayList causes - a list of possible causes of the error
			</li>
			
			<li>
			ArrayList solutions - a liso of solutions for the error
			   
			</li>		@return the following data:

		@short    Returns translated error details for <code>errorCode</code> using the  additional error information provided by <code>errorText</code> , <code>reqUrl</code>  (the request URL), and the ioslave <code>method</code> .
	*/
	public static native byte[] rawErrorDetail(int errorCode, String errorText, KURL reqUrl, int method);
	public static native byte[] rawErrorDetail(int errorCode, String errorText, KURL reqUrl);
	public static native byte[] rawErrorDetail(int errorCode, String errorText);
	/**	
		 Returns an appropriate error message if the given command <code>cmd</code>
		 is an unsupported action (ERR_UNSUPPORTED_ACTION).
			@param protocol name of the protocol
			@param cmd given command
				@short    Returns an appropriate error message if the given command <code>cmd</code>  is an unsupported action (ERR_UNSUPPORTED_ACTION).
		@see #enum
		@see Command
	*/
	public static native String unsupportedActionErrorString(String protocol, int cmd);
	/**	
		 Parses the string representation of the cache control option.
			@param cacheControl the string representation
				@return the cache control value

		@short    Parses the string representation of the cache control option.
		@see #getCacheControlString
	*/
	public static native int parseCacheControl(String cacheControl);
	/**	
		 Returns a string representation of the given cache control method.
			@param cacheControl the cache control method
				@return the string representation

		@short    Returns a string representation of the given cache control method.
		@see #parseCacheControl
	*/
	public static native String getCacheControlString(int cacheControl);
	/**	
		 Returns the mount point where <code>device</code> is mounted
		 right now. This means, it has to be mounted, not just
		 defined in fstab.
		   		@short    Returns the mount point where <code>device</code> is mounted  right now.
	*/
	public static native String findDeviceMountPoint(String device);
	/**	
		 Returns the mount point on which resides <code>filename.</code>
		 For instance if /home is a separate partition, findPathMountPoint("/home/user/blah")
		 will return /home
			@param filename the file name to check
				@return the mount point of the given <code>filename</code>
   
		@short    Returns the mount point on which resides <code>filename.</code>
	*/
	public static native String findPathMountPoint(String filename);
	/**	
		 Checks if the path belongs to a filesystem that is probably
		 slow. It checks for NFS or for paths belonging to automounted
		 paths not yet mounted
			@param filename the file name to check
				@return true if the filesystem is probably slow
   
		@short    Checks if the path belongs to a filesystem that is probably  slow.
	*/
	public static native boolean probably_slow_mounted(String filename);
	/**	
		 Checks if the path belongs to a filesystem that is manually
		 mounted.
			@param filename the file name to check
				@return true if the filesystem is manually mounted
   
		@short    Checks if the path belongs to a filesystem that is manually  mounted.
	*/
	public static native boolean manually_mounted(String filename);
	/**	
		 Checks the capabilities of the filesystem to which a given file belongs.
		 given feature (e.g. chmod).
			@param flag the flag to check
			 The availables flags are:
		
			<li>
			SupportsChmod: returns true if the filesystem supports chmod
			 (e.g. msdos filesystems return false)
			</li>
			
			<li>
			SupportsChown: returns true if the filesystem supports chown
			 (e.g. msdos filesystems return false)
			</li>
			
			<li>
			SupportsUtime: returns true if the filesystems supports utime
			 (e.g. msdos filesystems return false)
			</li>
			
			<li>
			SupportsSymlinks: returns true if the filesystems supports symlinks
			 (e.g. msdos filesystems return false)
			</li>
			
			<li>
			CaseInsensitive: returns true if the filesystem treats
			 "foo" and "FOO" as being the same file (true for msdos systems)
			</li>
				   		@return true if the filesystem has that flag, false if not (or some error occurred)

		@short    Checks the capabilities of the filesystem to which a given file belongs.
	*/
	public static native boolean testFileSystemFlag(String filename, int flag);
	/**	
		 Creates a single directory.
			@param url The URL of the directory to create.
			@param permissions The permissions to set after creating the
		                    directory (unix-style), -1 for default permissions.
				@return A pointer to the job handling the operation.
     
		@short    Creates a single directory.
	*/
	public static native SimpleJob mkdir(KURL url, int permissions);
	public static native SimpleJob mkdir(KURL url);
	/**	
		 Removes a single directory.
			 The directory is assumed to be empty.
			@param url The URL of the directory to remove.
				@return A pointer to the job handling the operation.
     
		@short    Removes a single directory.
	*/
	public static native SimpleJob rmdir(KURL url);
	/**	
		 Changes permissions on a file or directory.
		 See the other chmod below for changing many files
		 or directories.
			@param url The URL of file or directory.
			@param permissions The permissions to set.
				@return the job handling the operation.
     
		@short    Changes permissions on a file or directory.
	*/
	public static native SimpleJob chmod(KURL url, int permissions);
	/**	
		 Rename a file or directory.
		 Warning: this operation fails if a direct renaming is not
		 possible (like with files or dirs on separate partitions)
		 Use move or file_move in this case.
			@param src The original URL
			@param dest The final URL
			@param overwrite whether to automatically overwrite if the dest exists
				@return the job handling the operation.
     
		@short    Rename a file or directory.
	*/
	public static native SimpleJob rename(KURL src, KURL dest, boolean overwrite);
	/**	
		 Create or move a symlink.
		 This is the lowlevel operation, similar to file_copy and file_move.
		 It doesn't do any check (other than those the slave does)
		 and it doesn't show rename and skip dialogs - use KIO.link for that.
			@param target The string that will become the "target" of the link (can be relative)
			@param dest The symlink to create.
			@param overwrite whether to automatically overwrite if the dest exists
			@param showProgressInfo true to show progress information
				@return the job handling the operation.
     
		@short    Create or move a symlink.
	*/
	public static native SimpleJob symlink(String target, KURL dest, boolean overwrite, boolean showProgressInfo);
	public static native SimpleJob symlink(String target, KURL dest, boolean overwrite);
	/**	
		 Execute any command that is specific to one slave (protocol).
			 Examples are : HTTP POST, mount and unmount (kio_file)
			@param url The URL isn't passed to the slave, but is used to know
		        which slave to send it to :-)
			@param data Packed data.  The meaning is completely dependent on the
		        slave, but usually starts with an int for the command number.
			@param showProgressInfo true to show progress information
				@return the job handling the operation.
     
		@short    Execute any command that is specific to one slave (protocol).
	*/
	public static native SimpleJob special(KURL url, byte[] data, boolean showProgressInfo);
	public static native SimpleJob special(KURL url, byte[] data);
	/**	
		 Mount filesystem.
			 Special job for <code>kio_file.</code>
			@param ro Mount read-only if <code>true.</code>
			@param fstype File system type (e.g. "ext2", can be null).
			@param dev Device (e.g. /dev/sda0).
			@param point Mount point, can be <code>null.</code>
			@param showProgressInfo true to show progress information
				@return the job handling the operation.
     
		@short    Mount filesystem.
	*/
	public static native SimpleJob mount(boolean ro, String fstype, String dev, String point, boolean showProgressInfo);
	public static native SimpleJob mount(boolean ro, String fstype, String dev, String point);
	/**	
		 Unmount filesystem.
			 Special job for <code>kio_file.</code>
			@param point Point to unmount.
			@param showProgressInfo true to show progress information
				@return the job handling the operation.
     
		@short    Unmount filesystem.
	*/
	public static native SimpleJob unmount(String point, boolean showProgressInfo);
	public static native SimpleJob unmount(String point);
	/**	
		 HTTP cache update
			@param url Url to update, protocol must be "http".
			@param no_cache If true, cache entry for <code>url</code> is deleted.
			@param expireDate Local machine time indicating when the entry is
		 supposed to expire.
				@return the job handling the operation.
     
		@short    HTTP cache update
	*/
	public static native SimpleJob http_update_cache(KURL url, boolean no_cache, int expireDate);
	/**	
		 Find all details for one file or directory.
			@param url the URL of the file
			@param showProgressInfo true to show progress information
				@return the job handling the operation.
     
		@short    Find all details for one file or directory.
	*/
	public static native StatJob stat(KURL url, boolean showProgressInfo);
	public static native StatJob stat(KURL url);
	/**	
		 Find all details for one file or directory.
		 This version of the call includes two additional booleaneans, <code>sideIsSource</code> and <code>details.</code>
			@param url the URL of the file
			@param sideIsSource is true when stating a source file (we will do a get on it if
		 the stat works) and false when stating a destination file (target of a copy).
		 The reason for this parameter is that in some cases the kioslave might not
		 be able to determine a file's existence (e.g. HTTP doesn't allow it, FTP
		 has issues with case-sensitivity on some systems).
		 When the slave can't reliably determine the existence of a file, it will:
		
			<li>
			be optimistic if sideIsSource=true, i.e. it will assume the file exists,
			 and if it doesn't this will appear when actually trying to download it
			</li>
			
			<li>
			be pessimistic if sideIsSource=false, i.e. it will assume the file
			 doesn't exist, to prevent showing "about to overwrite" errors to the user.
			 If you simply want to check for existence without downloading/uploading afterwards,
			 then you should use sideIsSource=false.
			</li>
				@param details selects the level of details we want.
		 By default this is 2 (all details wanted, including modification time, size, etc.),
		 setDetails(1) is used when deleting: we don't need all the information if it takes
		 too much time, no need to follow symlinks etc.
		 setDetails(0) is used for very simple probing: we'll only get the answer
		 "it's a file or a directory, or it doesn't exist". This is used by KRun.
			@param showProgressInfo true to show progress information
				@return the job handling the operation.
     
		@short    Find all details for one file or directory.
	*/
	public static native StatJob stat(KURL url, boolean sideIsSource, short details, boolean showProgressInfo);
	public static native StatJob stat(KURL url, boolean sideIsSource, short details);
	/**	
		 Get (a.k.a. read).
			 The slave emits the data through data().
			@param url the URL of the file
			@param reload true to reload the file, false if it can be taken from the cache
			@param showProgressInfo true to show progress information
				@return the job handling the operation.
     
		@short    Get (a.
	*/
	public static native TransferJob get(KURL url, boolean reload, boolean showProgressInfo);
	public static native TransferJob get(KURL url, boolean reload);
	public static native TransferJob get(KURL url);
	/**	
		 Put (a.k.a. write)
			@param url Where to write data.
			@param permissions May be -1. In this case no special permission mode is set.
			@param overwrite If true, any existing file will be overwritten.
			@param resume true to resume, false otherwise
			@param showProgressInfo true to show progress information
				@return the job handling the operation.

		@short    Put (a.
		@see #multi_get
	*/
	public static native TransferJob put(KURL url, int permissions, boolean overwrite, boolean resume, boolean showProgressInfo);
	public static native TransferJob put(KURL url, int permissions, boolean overwrite, boolean resume);
	/**	
		 HTTP POST (for form data).
			 Example:
		 <pre>
		    job = KIO.http_post( url, postData, false );
		    job.addMetaData("content-type", contentType );
		    job.addMetaData("referrer", referrerURL);
		 </pre>
			 <code>postData</code> is the data that you want to send and
		 <code>contentType</code> is the complete HTTP header line that
		 specifies the content's MIME type, for example
		 "Content-Type: text/xml".
			 You MUST specify content-type!
			 Often <code>contentType</code> is
		 "Content-Type: application/x-www-form-urlencoded" and
		 the <code>postData</code> is then an ASCII string (without null-termination!)
		 with characters like space, linefeed and percent escaped like %20,
		 %0A and %25.
			@param url Where to write the data.
			@param postData Encoded data to post.
			@param showProgressInfo true to display
				@return the job handling the operation.
     
		@short    HTTP POST (for form data).
	*/
	public static native TransferJob http_post(KURL url, byte[] postData, boolean showProgressInfo);
	public static native TransferJob http_post(KURL url, byte[] postData);
	/**	
		 Creates a new mult-get job.
			@param id the id of the get operation
			@param url the URL of the file
				@return the job handling the operation.

		@short    Creates a new mult-get job.
		@see #get
	*/
	// KIO::MultiGetJob* multi_get(long arg1,const KURL& arg2,const KIO::MetaData& arg3); >>>> NOT CONVERTED
	/**	
		 Find mimetype for one file or directory.
			@param url the URL of the file
			@param showProgressInfo true to show progress information
				@return the job handling the operation.
     
		@short    Find mimetype for one file or directory.
	*/
	public static native MimetypeJob mimetype(KURL url, boolean showProgressInfo);
	public static native MimetypeJob mimetype(KURL url);
	/**	
		 Copy a single file.
			 Uses either SlaveBase.copy() if the slave supports that
		 or get() and put() otherwise.
			@param src Where to get the file.
			@param dest Where to put the file.
			@param permissions May be -1. In this case no special permission mode is set.
			@param overwrite If true, any existing file will be overwritten.
			@param resume true to resume an operation
			@param showProgressInfo true to show progress information
				@return the job handling the operation.
     
		@short    Copy a single file.
	*/
	public static native FileCopyJob file_copy(KURL src, KURL dest, int permissions, boolean overwrite, boolean resume, boolean showProgressInfo);
	public static native FileCopyJob file_copy(KURL src, KURL dest, int permissions, boolean overwrite, boolean resume);
	public static native FileCopyJob file_copy(KURL src, KURL dest, int permissions, boolean overwrite);
	public static native FileCopyJob file_copy(KURL src, KURL dest, int permissions);
	public static native FileCopyJob file_copy(KURL src, KURL dest);
	/**	
		 Move a single file.
			 Use either SlaveBase.rename() if the slave supports that,
		 or copy() and del() otherwise, or eventually get() & put() & del()
			@param src Where to get the file.
			@param dest Where to put the file.
			@param permissions May be -1. In this case no special permission mode is set.
			@param overwrite If <code>true</code>, any existing file will be overwritten.
			@param resume true to resume an operation
			@param showProgressInfo true to show progress information
				@return the job handling the operation.
     
		@short    Move a single file.
	*/
	public static native FileCopyJob file_move(KURL src, KURL dest, int permissions, boolean overwrite, boolean resume, boolean showProgressInfo);
	public static native FileCopyJob file_move(KURL src, KURL dest, int permissions, boolean overwrite, boolean resume);
	public static native FileCopyJob file_move(KURL src, KURL dest, int permissions, boolean overwrite);
	public static native FileCopyJob file_move(KURL src, KURL dest, int permissions);
	public static native FileCopyJob file_move(KURL src, KURL dest);
	/**	
		 Delete a single file.
			@param src File to delete.
			@param showProgressInfo true to show progress information
				@return the job handling the operation.
     
		@short    Delete a single file.
	*/
	public static native SimpleJob file_delete(KURL src, boolean showProgressInfo);
	public static native SimpleJob file_delete(KURL src);
	/**	
		 List the contents of <code>url</code>, which is assumed to be a directory.
			 "." and ".." are returned, filter them out if you don't want them.
			@param url the url of the directory
			@param showProgressInfo true to show progress information
			@param includeHidden true for all files, false to cull out UNIX hidden
		                      files/dirs (whose names start with dot)
				@return the job handling the operation.
     
		@short    List the contents of <code>url</code>, which is assumed to be a directory.
	*/
	public static native ListJob listDir(KURL url, boolean showProgressInfo, boolean includeHidden);
	public static native ListJob listDir(KURL url, boolean showProgressInfo);
	public static native ListJob listDir(KURL url);
	/**	
		 The same as the previous method, but recurses subdirectories.
			 "." and ".." are returned but only for the toplevel directory.
		 Filter them out if you don't want them.
			@param url the url of the directory
			@param showProgressInfo true to show progress information
			@param includeHidden true for all files, false to cull out UNIX hidden
		                      files/dirs (whose names start with dot)
				@return the job handling the operation.
     
		@short    The same as the previous method, but recurses subdirectories.
	*/
	public static native ListJob listRecursive(KURL url, boolean showProgressInfo, boolean includeHidden);
	public static native ListJob listRecursive(KURL url, boolean showProgressInfo);
	public static native ListJob listRecursive(KURL url);
	/**	
		 Copy a file or directory <code>src</code> into the destination <code>dest</code>,
		 which can be a file (including the final filename) or a directory
		 (into which <code>src</code> will be copied).
			 This emulates the cp command completely.
			@param src the file or directory to copy
			@param dest the destination
			@param showProgressInfo true to show progress information
				@return the job handling the operation

		@short    Copy a file or directory <code>src</code> into the destination <code>dest</code>,  which can be a file (including the final filename) or a directory  (into which <code>src</code> will be copied).
		@see #copyAs
	*/
	public static native CopyJob copy(KURL src, KURL dest, boolean showProgressInfo);
	public static native CopyJob copy(KURL src, KURL dest);
	/**	
		 Copy a file or directory <code>src</code> into the destination <code>dest</code>,
		 which is the destination name in any case, even for a directory.
			 As opposed to copy(), this doesn't emulate cp, but is the only
		 way to copy a directory, giving it a new name and getting an error
		 box if a directory already exists with the same name.
			@param src the file or directory to copy
			@param dest the destination
			@param showProgressInfo true to show progress information
				@return the job handling the operation
     
		@short    Copy a file or directory <code>src</code> into the destination <code>dest</code>,  which is the destination name in any case, even for a directory.
	*/
	public static native CopyJob copyAs(KURL src, KURL dest, boolean showProgressInfo);
	public static native CopyJob copyAs(KURL src, KURL dest);
	/**	
		 Copy a list of file/dirs <code>src</code> into a destination directory <code>dest.</code>
			@param src the list of files and/or directories
			@param dest the destination
			@param showProgressInfo true to show progress information
				@return the job handling the operation
     
		@short    Copy a list of file/dirs <code>src</code> into a destination directory <code>dest.</code>
	*/
	public static native CopyJob copy(ArrayList src, KURL dest, boolean showProgressInfo);
	public static native CopyJob copy(ArrayList src, KURL dest);
	/**	
		 Moves a file or directory <code>src</code> to the given destination <code>dest.</code>
			@param src the file or directory to copy
			@param dest the destination
			@param showProgressInfo true to show progress information
				@return the job handling the operation

		@short    Moves a file or directory <code>src</code> to the given destination <code>dest.</code>
		@see #copy
		@see #moveAs
	*/
	public static native CopyJob move(KURL src, KURL dest, boolean showProgressInfo);
	public static native CopyJob move(KURL src, KURL dest);
	/**	
		 Moves a file or directory <code>src</code> to the given destination <code>dest.</code> Unlike move()
		 this operation will fail when the directory already exists.
			@param src the file or directory to copy
			@param dest the destination
			@param showProgressInfo true to show progress information
				@return the job handling the operation

		@short    Moves a file or directory <code>src</code> to the given destination <code>dest.</code>
		@see #copyAs
	*/
	public static native CopyJob moveAs(KURL src, KURL dest, boolean showProgressInfo);
	public static native CopyJob moveAs(KURL src, KURL dest);
	/**	
		 Moves a list of files or directories <code>src</code> to the given destination <code>dest.</code>
			@param src the list of files or directories to copy
			@param dest the destination
			@param showProgressInfo true to show progress information
				@return the job handling the operation

		@short    Moves a list of files or directories <code>src</code> to the given destination <code>dest.</code>
		@see #copy
	*/
	public static native CopyJob move(ArrayList src, KURL dest, boolean showProgressInfo);
	public static native CopyJob move(ArrayList src, KURL dest);
	/**	
		 Create a link.
		 If the protocols and hosts are the same, a Unix symlink will be created.
		 Otherwise, a .desktop file of Type Link and pointing to the src URL will be created.
			@param src The existing file or directory, 'target' of the link.
			@param destDir Destination directory where the link will be created.
			@param showProgressInfo true to show progress information
				@return the job handling the operation
     
		@short    Create a link.
	*/
	public static native CopyJob link(KURL src, KURL destDir, boolean showProgressInfo);
	public static native CopyJob link(KURL src, KURL destDir);
	/**	
		 Create several links
		 If the protocols and hosts are the same, a Unix symlink will be created.
		 Otherwise, a .desktop file of Type Link and pointing to the src URL will be created.
			@param src The existing files or directories, 'targets' of the link.
			@param destDir Destination directory where the links will be created.
			@param showProgressInfo true to show progress information
				@return the job handling the operation

		@short    Create several links  If the protocols and hosts are the same, a Unix symlink will be created.
		@see #link
	*/
	public static native CopyJob link(ArrayList src, KURL destDir, boolean showProgressInfo);
	public static native CopyJob link(ArrayList src, KURL destDir);
	/**	
		 Create a link. Unlike link() this operation will fail when the directory already
		 exists.
		 If the protocols and hosts are the same, a Unix symlink will be created.
		 Otherwise, a .desktop file of Type Link and pointing to the src URL will be created.
			@param src The existing file or directory, 'target' of the link.
			@param destDir Destination directory where the link will be created.
			@param showProgressInfo true to show progress information
				@return the job handling the operation

		@short    Create a link.
		@see #link
		@see #copyAs
	*/
	public static native CopyJob linkAs(KURL src, KURL dest, boolean showProgressInfo);
	public static native CopyJob linkAs(KURL src, KURL dest);
	/**	
		 Delete a file or directory.
			@param src file to delete
			@param shred If true, delete in a way that makes recovery impossible
		 (only supported for local files currently)
			@param showProgressInfo true to show progress information
				@return the job handling the operation
     
		@short    Delete a file or directory.
	*/
	public static native DeleteJob del(KURL src, boolean shred, boolean showProgressInfo);
	public static native DeleteJob del(KURL src, boolean shred);
	public static native DeleteJob del(KURL src);
	/**	
		 Deletes a list of files or directories.
			@param src the files to delete
			@param shred If true, delete in a way that makes recovery impossible
		 (only supported for local files currently)
			@param showProgressInfo true to show progress information
				@return the job handling the operation
     
		@short    Deletes a list of files or directories.
	*/
	public static native DeleteJob del(ArrayList src, boolean shred, boolean showProgressInfo);
	public static native DeleteJob del(ArrayList src, boolean shred);
	public static native DeleteJob del(ArrayList src);
	/**	
		 Pastes the content of the clipboard (e.g. URLs) to the
		 given destination URL.
			@param _dest_url the URL to receive the data
			@param move true to move the data, false to copy
				@return the job that handles the operation

		@short    Pastes the content of the clipboard (e.
		@see #pasteData
	*/
	public static native Job pasteClipboard(KURL _dest_url, boolean move);
	public static native Job pasteClipboard(KURL _dest_url);
	/**	
		 Pastes the given <code>_data</code> to the
		 given destination URL.
			@param _dest_url the URL to receive the data
			@param _data the data to copy
				@short    Pastes the given <code>_data</code> to the  given destination URL.
		@see #pasteClipboard
	*/
	public static native void pasteData(KURL _dest_url, byte[] _data);
	/**	
		 Pastes the given <code>_data</code> to the
		 given destination URL.
			@param _dest_url the URL to receive the data
			@param _data the data to copy
				@short    Pastes the given <code>_data</code> to the  given destination URL.
		@see #pasteClipboard
	*/
	public static native CopyJob pasteDataAsync(KURL _dest_url, byte[] _data);
	/**	
		 Checks whether the clipboard is empty.
				@return true if empty
   
		@short    Checks whether the clipboard is empty.
	*/
	public static native boolean isClipboardEmpty();
	public static native QDataStream op_write(QDataStream s, AuthInfo a);
	public static native QDataStream op_read(QDataStream s, AuthInfo a);
	/**	
		 Creates a PreviewJob to generate or retrieve a preview image 
		 for the given URL.
			@param items files to get previews for
			@param width the maximum width to use
			@param height the maximum height to use, if this is 0, the same
		 value as width is used.
			@param iconSize the size of the mimetype icon to overlay over the
		 preview or zero to not overlay an icon. This has no effect if the
		 preview plugin that will be used doesn't use icon overlays.
			@param iconAlpha transparency to use for the icon overlay
			@param scale if the image is to be scaled to the requested size or
		 returned in its original size
			@param save if the image should be cached for later use
			@param enabledPlugins if non-zero, this points to a list containing
		 the names of the plugins that may be used.
				@return the new PreviewJob

		@short    Creates a PreviewJob to generate or retrieve a preview image   for the given URL.
		@see PreviewJob#availablePlugins
	*/
	public static native PreviewJob filePreview(ArrayList items, int width, int height, int iconSize, int iconAlpha, boolean scale, boolean save, String[] enabledPlugins);
	public static native PreviewJob filePreview(ArrayList items, int width, int height, int iconSize, int iconAlpha, boolean scale, boolean save);
	public static native PreviewJob filePreview(ArrayList items, int width, int height, int iconSize, int iconAlpha, boolean scale);
	public static native PreviewJob filePreview(ArrayList items, int width, int height, int iconSize, int iconAlpha);
	public static native PreviewJob filePreview(ArrayList items, int width, int height, int iconSize);
	public static native PreviewJob filePreview(ArrayList items, int width, int height);
	public static native PreviewJob filePreview(ArrayList items, int width);
	/**	
		 Retrieves meta information for the given items.
			@param items files to get metainfo for
				@return the MetaInfoJob to retrieve the items
     
		@short    Retrieves meta information for the given items.
	*/
	public static native MetaInfoJob fileMetaInfo(ArrayList items);
	/**	
		 Creates a new DavJob that issues a PROPFIND command. PROPFIND retrieves
		 the properties of the resource identified by the given <code>url.</code>
			@param url the URL of the resource
			@param properties a propfind document that describes the properties that
		        should be retrieved
			@param depth the depth of the request. Can be "0", "1" or "infinity"
			@param showProgressInfo true to show progress information
				@return the new DavJob
    
		@short    Creates a new DavJob that issues a PROPFIND command.
	*/
	public static native DavJob davPropFind(KURL url, QDomDocument properties, String depth, boolean showProgressInfo);
	public static native DavJob davPropFind(KURL url, QDomDocument properties, String depth);
	/**	
		 Creates a new DavJob that issues a PROPPATCH command. PROPPATCH sets
		 the properties of the resource identified by the given <code>url.</code>
			@param url the URL of the resource
			@param properties a PROPPACTCH document that describes the properties that
		        should be modified and its new values
			@param showProgressInfo true to show progress information
				@return the new DavJob
    
		@short    Creates a new DavJob that issues a PROPPATCH command.
	*/
	public static native DavJob davPropPatch(KURL url, QDomDocument properties, boolean showProgressInfo);
	public static native DavJob davPropPatch(KURL url, QDomDocument properties);
	/**	
		 Creates a new DavJob that issues a SEARCH command.
			@param url the URL of the resource
			@param nsURI the URI of the search method's qualified name
			@param qName the local part of the search method's qualified name
			@param query the search string
			@param showProgressInfo true to show progress information
				@return the new DavJob
    
		@short    Creates a new DavJob that issues a SEARCH command.
	*/
	public static native DavJob davSearch(KURL url, String nsURI, String qName, String query, boolean showProgressInfo);
	public static native DavJob davSearch(KURL url, String nsURI, String qName, String query);
	/**	
		 <li><b>RenameDlg related Functions</b></li>
		 {@link KIO#RenameDlg}
		 Construct a modal, parent-less "rename" dialog, and return
		 a result code, as well as the new dest. Much easier to use than the
		 class RenameDlg directly.
			@param caption the caption for the dialog box
			@param src the file/dir we're trying to copy, as it's part of the text message
			@param dest the destination file/dir, i.e. the one that already exists
			@param mode parameters for the dialog (which buttons to show...),
		             see RenameDlg_Mode
			@param newDest the new destination path, valid if R_RENAME was returned.
			@param sizeSrc size of source file
			@param sizeDest size of destination file
			@param ctimeSrc creation time of source file
			@param ctimeDest creation time of destination file
			@param mtimeSrc modification time of source file
			@param mtimeDest modification time of destination file
				@return the result
   
		@short    <li><b>RenameDlg related Functions</b></li>  {@link KIO#RenameDlg}  Construct a modal, parent-less "rename" dialog, and return  a result code, as well as the new dest.
	*/
	public static native int open_RenameDlg(String caption, String src, String dest, int mode, StringBuffer newDestPath, long sizeSrc, long sizeDest, int ctimeSrc, int ctimeDest, int mtimeSrc, int mtimeDest);
	public static native int open_RenameDlg(String caption, String src, String dest, int mode, StringBuffer newDestPath, long sizeSrc, long sizeDest, int ctimeSrc, int ctimeDest, int mtimeSrc);
	public static native int open_RenameDlg(String caption, String src, String dest, int mode, StringBuffer newDestPath, long sizeSrc, long sizeDest, int ctimeSrc, int ctimeDest);
	public static native int open_RenameDlg(String caption, String src, String dest, int mode, StringBuffer newDestPath, long sizeSrc, long sizeDest, int ctimeSrc);
	public static native int open_RenameDlg(String caption, String src, String dest, int mode, StringBuffer newDestPath, long sizeSrc, long sizeDest);
	public static native int open_RenameDlg(String caption, String src, String dest, int mode, StringBuffer newDestPath, long sizeSrc);
	public static native int open_RenameDlg(String caption, String src, String dest, int mode, StringBuffer newDestPath);
	public static native int open_SkipDlg(boolean _multi, String _error_text);
	public static native int open_SkipDlg(boolean _multi);
}
