/***************************************************************************
                            KAboutApplication.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KABOUTAPPLICATION_H
#define KABOUTAPPLICATION_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/KAboutDialog.h>

/**

 This class provides the standard "About Application" dialog box that
 is used by @ref KHelpMenu. It uses the information of the global
 @ref KAboutData that is specified at the start of you program in
 -main. Normally you should not use this class directly but
 rather the @ref KHelpMenu class or even better just subclass your
 toplevel window from @ref KMainWindow. If you do the latter, the help
 menu and thereby this dialog box is available through the
 @ref -[KMainWindow helpMenu] function.

 @author Waldo Bastian (bastian@kde.org) and Espen Sand (espen@kde.org)

 @version $Id
 
 @short Standard "About Application" dialog box.

*/
@class KAboutData; 

@interface KAboutApplication : KAboutDialog 

/** 
 Constructor. Creates a fully featured "About Application" dialog box.
 Note that this dialog is made modeless in the @ref KHelpMenu class so
 the users may expect a modeless dialog.

*/
- initWithWidget: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal;
- init;

/** 
 Constructor. Mostly does the same stuff as the above constructor, except
 that it can take a custom KAboutData object instead of the one specified
 in your -main function. This is especially useful for applications
 which are implemented as (dynamically loaded) libraries, e.g. panel
 applets.

*/
- initWithAboutData: (KAboutData*)aboutData parent: (QWidget *)parent name: (NSString *)name modal: (BOOL)modal;
- initWithAboutData: (KAboutData*)aboutData ;
- buildDialog: (KAboutData*)aboutData;
@end

/** Override these methods in subclasses of KAboutApplication to customise event handling behaviour */
@protocol KAboutApplicationEventHandling

/** 
 Maps some keys to the actions buttons. F1 is mapped to the Help
 button if present and Escape to the Cancel or Close if present. The
 button action event is animated.
     
*/
- keyPressEvent:(QKeyEvent*) e;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;
- mousePressEvent:(QMouseEvent*) arg1;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;
- mouseMoveEvent:(QMouseEvent*) arg1;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;

/** 
 Emits the @ref hidden signal. You can connect to that signal to
 detect when a dialog has been closed.
     
*/
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;

/** 
 Detects when a dialog is being closed from the window manager
 controls. If the Cancel or Close button is present then the button
 is activated. Otherwise standard @ref QDialog behavior
 will take place.
     
*/
- closeEvent:(QCloseEvent*) e;
- paintEvent:(QPaintEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
