/***************************************************************************
                          KDESupport.m  -  description
                             -------------------
    begin                : Wed Aug 15 2001
    copyright            : (C) 2001 by Richard Dale
    email                : Lost_Highway@tipitina.demon.co.uk
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kdec/kde_DOMString.h>
#include <kdec/kde_QCStringList.h>
#include <kdec/kde_KMainWindowList.h>
#include <kdec/kde_KFileItemList.h>
#include <kdec/kde_KURLList.h>
#include <kdec/kde_DOMNodeList.h>
#include <kdec/kde_StyleSheetList.h>

#include <qtobjc/QtSupport.h>
#include <kdeobjc/KDESupport.h>
#include <kdeobjc/KURL.h>
#include <kdeobjc/KFileItem.h>
#include <kdeobjc/KMainWindow.h>
#include <kdeobjc/DOMNode.h>
#include <kdeobjc/StyleSheet.h>

@implementation KDESupport
@end

	/** Convert from an NSString String to DOM::DOMString */
@implementation NSString (KDESupport)

- (kde_DOMString *) toDOMString: (kde_DOMString **) domstring
{
static qt_QString *	string = 0;
	
	if (*domstring != 0) {
		kde_del_DOMString(*domstring);
	}
		
	*domstring = kde_new_DOMString3((qt_QString *) [self toQString: &string]);
	return *domstring;
}

- (NSString *) fromDOMString: (kde_DOMString *) string
{
}

@end


/** Convenience methods for converting NSArrays to KDE lists */
@implementation NSArray (KDESupport)

- (kde_KURLList *) toKURLList: (kde_KURLList **) kurlList
{
	int				index;
	KURL *			url;

	if (*kurlList == 0) {
		*kurlList = kde_new_KURLList();
	}

	kde_KURLList_clear(*kurlList);

	for (index = 0; index < [self count]; index++) {
		url = [self objectAtIndex: index];
		kde_KURLList_append(*kurlList, [url qt]);
	}

	return *kurlList;
}

- (kde_KFileItemList *) toKFileItemList: (kde_KFileItemList **) fileitemlist
{
	int				index;
	KFileItem *		fileitem;

	if (*fileitemlist == 0) {
		*fileitemlist = kde_new_KFileItemList();
	}

	kde_KFileItemList_clear(*fileitemlist);

	for (index = 0; index < [self count]; index++) {
		fileitem = [self objectAtIndex: index];
		kde_KFileItemList_append(*fileitemlist, (kde_KFileItem *) [fileitem qt]);
	}

	return *fileitemlist;
}

@end

/** Convenience methods for creating NSMutableArrays from Qt lists */
@implementation NSMutableArray (KDESupport)

+ (NSArray *) arrayWithQCStringList: (kde_QCStringList *) strlist
{
	qt_QCString *		currentString;
	NSMutableArray *	stringArray;

	stringArray = [QtSupport objectForQtKey: strlist withClass: [NSMutableArray class]];
	[stringArray removeAllObjects];

	kde_QCStringList_begin((kde_QCStringList *) strlist);
	currentString = kde_QCStringList_current((kde_QCStringList *) strlist);
	while (currentString != 0) {
		[stringArray addObject: [NSString fromQCString: currentString]];
		currentString = kde_QCStringList_next((kde_QCStringList *) strlist);
	}

	return stringArray;
}

+ (NSArray *) arrayWithOfferList: (kde_OfferList *) offerlist
{
}

+ (NSArray *) arrayWithKMainWindowList: (kde_KMainWindowList *) windowlist
{
	kde_KMainWindow *	currentWindow;
	NSMutableArray *	windowArray;

	windowArray = [QtSupport objectForQtKey: windowlist withClass: [NSMutableArray class]];
	[windowArray removeAllObjects];

	currentWindow = kde_KMainWindowList_first((kde_KMainWindowList *) windowlist);
	while (currentWindow != NULL) {
		[windowArray addObject: [QtSupport objectForQtKey: currentWindow withClass: [KMainWindow class]]];
		currentWindow = kde_KMainWindowList_next((kde_KMainWindowList *) windowlist);
	}

	return windowArray;
}

+ (NSArray *) arrayWithKFileItemList: (kde_KFileItemList *) fileitemlist
{
	kde_KFileItem *		currentFileItem;
	NSMutableArray *	fileItemArray;

	fileItemArray = [QtSupport objectForQtKey: fileitemlist withClass: [NSMutableArray class]];
	[fileItemArray removeAllObjects];

	currentFileItem = kde_KFileItemList_first((kde_KFileItemList *) fileitemlist);
	while (currentFileItem != NULL) {
		[fileItemArray addObject: [QtSupport objectForQtKey: currentFileItem withClass: [KFileItem class]]];
		currentFileItem = kde_KFileItemList_next((kde_KFileItemList *) fileitemlist);
	}

	return fileItemArray;
}

+ (NSArray *) arrayWithKURLList: (kde_KURLList *) urllist
{
	kde_KURL *			currentURL;
	NSMutableArray *	urlArray;
	unsigned int		count;
	unsigned int		index;

	urlArray = [QtSupport objectForQtKey: urllist withClass: [NSMutableArray class]];
	[urlArray removeAllObjects];

	count = kde_KURLList_count((kde_KURLList *) urllist);
	for (index = 0; index < count; index++) {
		currentURL = kde_KURLList_at((kde_KURLList *) urllist, index);
		[urlArray addObject: [QtSupport objectForQtKey: currentURL withClass: [KURL class]]];
	}

	return urlArray;
}

+ (NSArray *) arrayWithNodeList: (kde_DOMNodeList *) nodelist
{
	kde_DOMNode *		currentNode;
	NSMutableArray *	nodeArray;
	unsigned long		count;
	unsigned long		index;

	nodeArray = [QtSupport objectForQtKey: nodelist withClass: [NSMutableArray class]];
	[nodeArray removeAllObjects];
	count = kde_DOMNodeList_length((kde_DOMNodeList *) nodelist);
	for (index = 0; index < count; index++) {
		currentNode = kde_DOMNodeList_item((kde_DOMNodeList *) nodelist, index);
		[nodeArray addObject: [QtSupport objectForQtKey: currentNode withClass: [DOMNode class]]];
	}

	return nodeArray;
}

+ (NSArray *) arrayWithStyleSheetList: (kde_StyleSheetList *) stylesheetlist
{
	kde_StyleSheet *	currentStyleSheet;
	NSMutableArray *	styleSheetArray;
	unsigned long		count;
	unsigned long		index;

	styleSheetArray = [QtSupport objectForQtKey: stylesheetlist withClass: [NSMutableArray class]];
	[styleSheetArray removeAllObjects];
	count = kde_StyleSheetList_length((kde_StyleSheetList *) stylesheetlist);
	for (index = 0; index < count; index++) {
		currentStyleSheet = kde_StyleSheetList_item((kde_StyleSheetList *) stylesheetlist, index);
		[styleSheetArray addObject: [QtSupport objectForQtKey: currentStyleSheet withClass: [StyleSheet class]]];
	}

	return styleSheetArray;
}

@end
