/***************************************************************************
                            KRFCDate.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KRFCDATE_H
#define KRFCDATE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

/**

 The KRFCDate class contains functions related to the parsing of dates.

 @author Waldo Bastian <bastian@kde.org>
 
 @short 
 The KRFCDate class contains functions related to the parsing of dates.
*/
@interface  KRFCDate : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}

/** 
 This function tries to parse a string containing a date/time in any
 of the formats specified by RFC822, RFC850, RFC1036, RFC1123 and RFC2822.

 If the date/time could not be parsed, 0 is returned.  If the
 parsed date is epoch, then epoch+1 is returned so that a valid
 date will not be confused with an improper date string.

 The date/time returned is converted to UTC.

    
*/
+ (long) parseDate: (NSString *)date;

/** 
 This function tries to parse a string containing a date/time in 
 any of the formats specified by http://www.w3.org/TR/NOTE-datetime

 This is a subset of the formats specified in ISO8601.

 If the date/time could not be parsed, 0 is returned.  If the
 parsed date is epoch, then epoch+1 is returned so that a valid
 date will not be confused with an improper date string.

 The date/time returned is converted to UTC.

    
*/
+ (long) parseDateISO8601: (NSString *)date;

/** 
 Returns the local timezone offset to UTC in seconds

   
*/
+ (int) localUTCOffset;

/** 
 Returns a string representation of the given date and time formated
 in conformance to RFC2822.

   
*/
+ (NSString *) rfc2822DateString: (long)utcTime utcOffset: (int)utcOffset;

/** 
 Returns a string representation of the given date and time formated
 in conformance to RFC2822.

 Provided for convenience, the function is equivalent to
 rfc2822DateString(t, -localUTCOffset).

   
*/
+ (NSString *) rfc2822DateString: (long)utcTime;
@end

#endif
