// -*- c++ -*-

/*
 *  Copyright (C) 2001-2002, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#ifndef KJSEMBEDJSBINDING_H
#define KJSEMBEDJSBINDING_H

#include <qstring.h>
#include <qvariant.h>

#include <kjs/interpreter.h>
#include <kjs/object.h>
#include <kjs/types.h>

/**
 * Implement QString-KJS::UString conversion methods. These methods are declared
 * by KJS, but libkjs doesn't actually contain their implementations.
 *
 * @version $Id: jsbinding.h,v 1.20 2004/01/01 07:23:15 geiseri Exp $
 */
namespace KJS {

    inline UString::UString( const QString &d )
    {
	uint len = d.length();
	UChar *dat = new UChar[len];
	memcpy( dat, d.unicode(), len * sizeof(UChar) );
	rep = UString::Rep::create(dat, len);
    }

    inline QString UString::qstring() const
    {
	return QString((QChar*) data(), size());
    }

    inline QConstString UString::qconststring() const
    {
	return QConstString((QChar*) data(), size());
    }

    inline QString Identifier::qstring() const
    {
	return QString((QChar*) data(), size());
    }

}

namespace KJSEmbed {
    class JSObjectProxy;

    /** Converts a QVariant to the closest possible KJS::Value. */
    KJS::Value convertToValue( KJS::ExecState *exec, const QVariant &val);

    /** Converts a KJS::Value to the closest possible QVariant. */
    QVariant convertToVariant( KJS::ExecState *exec, const KJS::Value &v );

    /** Returns HTML that documents the specified object. */
    QString dumpObject( KJS::ExecState *exec, KJS::Object &obj );

    /** Returns HTML that documents the QObject facilities of the specified object. */
    QString dumpQObject( KJS::ExecState *exec, KJS::Object &obj );
    
    /** Returns a QStringList that contains all possible properties, 
    * methods and slots for use with a completion object 
    */
    QStringList dumpCompletion( KJS::ExecState *exec, KJS::Object &obj);
    
    QPen extractQPen(KJS::ExecState *exec, const KJS::List &args, int idx);
    QFont extractQFont(KJS::ExecState *exec, const KJS::List &args, int idx);
    QBrush extractQBrush(KJS::ExecState *exec, const KJS::List &args, int idx);
    QPixmap extractQPixmap( KJS::ExecState *exec, const KJS::List &args, int idx);
    QImage extractQImage( KJS::ExecState *exec, const KJS::List &args, int idx);
    QString extractQString( KJS::ExecState *exec, const KJS::List &args, int idx);
    int extractInt( KJS::ExecState *exec, const KJS::List &args, int idx);
    QColor extractColor(KJS::ExecState *exec, const KJS::List &args, int idx);
    QSize extractSize(KJS::ExecState *exec, const KJS::List &args, int idx);
    bool extractBool(KJS::ExecState *exec, const KJS::List &args, int idx);
    double extractDouble(KJS::ExecState *exec, const KJS::List &args, int idx);
    uint extractUInt(KJS::ExecState *exec, const KJS::List &args, int idx);

}

#endif // KJSEMBEDJSBINDING_H

// Local Variables:
// c-basic-offset: 4
// End:
