/*
 *  Copyright (C) 2001-2003, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include "kdebug.h"
#include "jseventmapper.h"

namespace KJSEmbed {

/** Used internally for the event handler table. */
struct EventType
{
    KJS::Identifier id;
    QEvent::Type type;
};

static EventType events[] = {
    { KJS::Identifier("timerEvent"), QEvent::Timer },

#ifdef ENABLE_CHILDEVENTS
    { KJS::Identifier("childInsertEvent"), QEvent::ChildInserted },
    { KJS::Identifier("childRemoveEvent"), QEvent::ChildRemoved },
#endif

    { KJS::Identifier("mouseReleaseEvent"), QEvent::MouseButtonRelease },
    { KJS::Identifier("mouseMoveEvent"), QEvent::MouseMove },
    { KJS::Identifier("mouseDoubleClickEvent"), QEvent::MouseButtonDblClick },
    { KJS::Identifier("mousePressEvent"), QEvent::MouseButtonPress },

    { KJS::Identifier("keyPressEvent"), QEvent::KeyPress },
    { KJS::Identifier("keyReleaseEvent"), QEvent::KeyRelease },

    { KJS::Identifier("paintEvent"), QEvent::Paint },

    { KJS::Identifier("moveEvent"), QEvent::Move },
    { KJS::Identifier("resizeEvent"), QEvent::Resize },

    { KJS::Identifier("closeEvent"), QEvent::Close },

    { KJS::Identifier("showEvent"), QEvent::Show },
    { KJS::Identifier("hideEvent"), QEvent::Hide },

    { KJS::Identifier(), QEvent::None }
};

JSEventMapper::JSEventMapper()
{
    int i = 0;
    do {
	addEvent( events[i].id, events[i].type );
	i++;
    } while( events[i].type != QEvent::None );
}

JSEventMapper::~JSEventMapper()
{
}

void JSEventMapper::addEvent( const KJS::Identifier &name, QEvent::Type t )
{
    handlerToEvent.insert( name.qstring(), (const uint *) t );
    eventToHandler.insert( (long) t, &name );
}

QEvent::Type JSEventMapper::findEventType( const KJS::Identifier &name ) const
{
    uint evt = (uint) handlerToEvent[ name.qstring() ];
    return static_cast<QEvent::Type>( evt );
}

} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:
