/*
 *  Copyright (C) 2003, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include "kjsembedpart.h"
#include "jsfactory.h"
#include "jsobjectproxy.h"
#include "jsopaqueproxy.h"
#include "jsbinding.h"

#include "jseventutils.h"

namespace KJSEmbed {

JSFactory *JSEventUtils::factory( const JSObjectProxy *prx )
{
    return prx->part()->factory();
}

KJS::Object JSEventUtils::convertEvent( KJS::ExecState *exec,
					const QMouseEvent *ev, const JSObjectProxy */*context*/ )
{
    KJS::Object mev( new JSOpaqueProxy(ev) );

    mev.put( exec, "pos", convertToValue( exec, QVariant(ev->pos()) ) );
    mev.put( exec, "x", KJS::Number(ev->x()) );
    mev.put( exec, "y", KJS::Number(ev->y()) );

    mev.put( exec, "globalPos", convertToValue( exec, QVariant(ev->globalPos()) ) );
    mev.put( exec, "globalX", KJS::Number(ev->globalX()) );
    mev.put( exec, "globalY", KJS::Number(ev->globalY()) );

    mev.put( exec, "button", KJS::Number(ev->button()) );
    mev.put( exec, "state", KJS::Number(ev->state()) );
    mev.put( exec, "stateAfter", KJS::Number(ev->stateAfter()) );

    return mev;
}

KJS::Object JSEventUtils::convertEvent( KJS::ExecState *exec,
					const QPaintEvent *ev, const JSObjectProxy */*context*/ )
{
    KJS::Object pev( new JSOpaqueProxy(ev) );

    pev.put( exec, "rect", convertToValue( exec, QVariant(ev->rect()) ) );
    pev.put( exec, "erased", convertToValue( exec, QVariant(ev->erased()) ) );
    return pev;
}

KJS::Object JSEventUtils::convertEvent( KJS::ExecState *exec,
					const QKeyEvent *ev, const JSObjectProxy */*context*/ )
{
    KJS::Object kev( new JSOpaqueProxy(ev) );

    kev.put( exec, "key", KJS::Number(ev->key()) );
    kev.put( exec, "ascii", KJS::Number(ev->ascii()) );
    kev.put( exec, "state", KJS::Number(ev->state()) );
    kev.put( exec, "stateAfter", KJS::Number(ev->stateAfter()) );
    kev.put( exec, "isAccepted", KJS::Boolean(ev->isAccepted()) );
    kev.put( exec, "text", KJS::String(ev->text()));
    kev.put( exec, "isAutoRepeat", KJS::Boolean(ev->isAutoRepeat()) );
    kev.put( exec, "count", KJS::Number( ev->count()) );
    //kev.put( exec, "accept", KJS::Void( exec, QVariant(ev->accept()), context ) );
    //kev.put( exec, "ignore", KJS::Void( exec, QVariant(ev->ignore()), context ) );
    return kev;
}
KJS::Object JSEventUtils::convertEvent( KJS::ExecState *exec,
					const QIMEvent *ev, const JSObjectProxy */*context*/ )
{
    KJS::Object qev( new JSOpaqueProxy(ev) );

    qev.put( exec, "text", KJS::String(ev->text()) );
    qev.put( exec, "cursorPos", KJS::Number(ev->cursorPos()) );
    qev.put( exec, "isAccepted", KJS::Boolean(ev->isAccepted()) );
    //qev.put( exec, "accept", KJS::Void( exec, QVariant(ev->accept()), context ) );
    //qev.put( exec, "ignore", KJS::Void( exec, QVariant(ev->ignore()), context ) );
    return qev;
}

KJS::Object JSEventUtils::convertEvent( KJS::ExecState *exec,
					const QResizeEvent *ev, const JSObjectProxy */*context*/ )
{
    KJS::Object rev( new JSOpaqueProxy(ev) );

    rev.put( exec, "size", convertToValue( exec, QVariant(ev->size()) ));
    rev.put( exec, "oldSize", convertToValue( exec, QVariant(ev->oldSize())  ));
    return rev;
}

KJS::Object JSEventUtils::convertEvent( KJS::ExecState *exec,
					const QFocusEvent *ev, const JSObjectProxy */*context*/ )
{
    KJS::Object fev( new JSOpaqueProxy(ev) );

    fev.put( exec, "gotFocus", KJS::Boolean(ev->gotFocus()) );
    fev.put( exec, "lostFocus", KJS::Boolean(ev->lostFocus()) );
    return fev;
}

KJS::Object JSEventUtils::convertEvent( KJS::ExecState *exec,
					const QCloseEvent *ev, const JSObjectProxy */*context*/ )
{
    KJS::Object cev( new JSOpaqueProxy(ev) );

    cev.put( exec, "isAccepted", KJS::Boolean(ev->isAccepted()) );
    //cev.put( exec, "accept", KJS::Void( exec, QVariant(ev->accept()), context ) );
    //cev.put( exec, "ignore", KJS::Void( exec, QVariant(ev->ignore()), context ) );
    return cev;
}

#ifdef ENABLE_CHILDEVENTS
KJS::Object JSEventUtils::convertEvent( KJS::ExecState *exec,
					const QChildEvent *ev, const JSObjectProxy *context )
{
    KJS::Object cev( new JSOpaqueProxy(ev) );

    cev.put( exec, "inserted", KJS::Boolean(ev->inserted()) );
    cev.put( exec, "removed", KJS::Boolean(ev->removed()) );
    cev.put( exec, "child", factory(context)->createProxy( exec, ev->child(), context ) );

    return cev;
}
#endif

KJS::Object JSEventUtils::convertEvent( KJS::ExecState *exec,
					const QMoveEvent *ev, const JSObjectProxy */*context*/ )
{
    KJS::Object mev( new JSOpaqueProxy(ev) );

    mev.put( exec, "pos", convertToValue( exec, QVariant(ev->pos()) ));
    mev.put( exec, "oldPos", convertToValue( exec, QVariant(ev->oldPos()) ));
    return mev;
}

KJS::Object JSEventUtils::convertEvent( KJS::ExecState *exec,
					const QWheelEvent *ev, const JSObjectProxy */*context*/ )
{
    KJS::Object wev( new JSOpaqueProxy(ev) );

    wev.put( exec, "delta", KJS::Number(ev->delta()) );
    wev.put( exec, "pos", convertToValue( exec, QVariant(ev->pos()) ) );
    wev.put( exec, "globalPos", convertToValue( exec, QVariant(ev->globalPos()) ) );
    wev.put( exec, "x", KJS::Number(ev->x()) );
    wev.put( exec, "y", KJS::Number(ev->y()) );
    wev.put( exec, "globalX", KJS::Number(ev->globalX()) );
    wev.put( exec, "globalY", KJS::Number(ev->globalY()) );

    wev.put( exec, "state", KJS::Number(ev->state()) );
    wev.put( exec, "orientation", KJS::Number(ev->orientation()) );
    wev.put( exec, "isAccepted", KJS::Boolean(ev->isAccepted()) );
    //wev.put( exec, "accept", KJS::Void( exec, QVariant(ev->accept()), context ) );
    //wev.put( exec, "ignore", KJS::Void( exec, QVariant(ev->ignore()), context ) );
    return wev;
}

KJS::Object JSEventUtils::convertEvent( KJS::ExecState */*exec*/,
					const QEvent *ev, const JSObjectProxy */*context*/ )
{
    return KJS::Object( new JSOpaqueProxy(ev) );
}

} // namespace KJSEmbed
