/*
 *  Copyright (C) 2001-2003, Richard J. Moore <rich@kde.org>
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 */

#include <kaction.h>
#include <kapplication.h>
#include <kdebug.h>
#include <kgenericfactory.h>
#include <kinstance.h>
#include <klocale.h>
#include <kparts/part.h>

#include <jsfactory.h>
#include <jsconsolewidget.h>
#include <kjsembedpart.h>

#include "jsconsoleplugin.h"
#include "jsconsoleplugin.moc"

typedef KGenericFactory<KJSEmbed::JSConsolePlugin> JSConsolePluginFactory;
K_EXPORT_COMPONENT_FACTORY( libjsconsoleplugin, JSConsolePluginFactory( "jsconsoleplugin" ) )

//
// KParts::Plugin Implementation
//
namespace KJSEmbed {

JSConsolePlugin::JSConsolePlugin( QObject *parent, const char *name, const QStringList & )
    : KParts::Plugin( parent, name )
{
    js = new KJSEmbedPart( 0, 0, name, 0, name );

    KJS::Interpreter *interp = js->interpreter();
    KJS::Object global( interp->globalObject() );
    js->addObject( js->view(), global, "console" );
    js->addObject( parent, global, "plugin_parent" );
    js->addObject( KApplication::kApplication(), global, "application" );

    if ( parent->inherits("KParts::Part") ) {
	KParts::Part *part = static_cast<KParts::Part *>( parent );
	js->addObject( part, "kpart" );
	if ( part->widget() ) {
	    js->addObject( part->widget(), "widget" );
	    js->addObject( part->widget()->topLevelWidget(), "window" );
	}
    }

    KActionMenu *menu;
    menu = new KActionMenu( i18n("&Javascript"), "jsconsole",
			    actionCollection(), "jsconsole" );
    menu->setDelayed( false );

    menu->insert( new KAction( i18n("&Console"), 0,
			       js->widget(), SLOT( show() ),
			       actionCollection(), "jsconsole_show") );
}

JSConsolePlugin::~JSConsolePlugin()
{
    delete js;
}

} // namespace KJSEmbed

// Local Variables:
// c-basic-offset: 4
// End:




