/***************************************************************************
                            QImage.h -  description
                             -------------------
    begin                : Wed Nov 21 12:08:37 2001
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Nov 21 12:08:37 2001, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef QIMAGE_H
#define QIMAGE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>
#include <qtobjc/QRect.h>
#include <qtobjc/QSize.h>
#include <qtobjc/QPoint.h>

@class QByteArray;

@class QWMatrix; 

@interface  QImage : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
- init;
- initWithInt: (int)width height: (int)height depth: (int)depth numColors: (int)numColors bitOrder: (int)bitOrder;
- initWithInt: (int)width height: (int)height depth: (int)depth ;
- initWithSize: (QSize *)arg1 depth: (int)depth numColors: (int)numColors bitOrder: (int)bitOrder;
- initWithSize: (QSize *)arg1 depth: (int)depth ;
- initWithFilename: (NSString *)fileName format: (NSString *)format;
- initWithFilename: (NSString *)fileName ;
- initWithXpm: (char **)xpm;
- initWithByteArray: (QByteArray*)data;
- initWithUnsigned: (unsigned char*)data w: (int)w h: (int)h depth: (int)depth colortable: (int *)colortable numColors: (int)numColors bitOrder: (int)bitOrder;
//- initWithUnsigned: (unsigned char*)data w: (int)w h: (int)h depth: (int)depth pbl: (int)pbl colortable: (int *)colortable numColors: (int)numColors bitOrder: (int)bitOrder;
- copyWithZone: (NSZone *) zone;
- (void) dealloc;
- detach;
- (QImage*) copy;
- (QImage*) copy: (int)x y: (int)y w: (int)w h: (int)h conversion_flags: (int)conversion_flags;
- (QImage*) copy: (int)x y: (int)y w: (int)w h: (int)h ;
- (QImage*) copy: (QRect*)arg1;
- (BOOL) isNull;
- (int) width;
- (int) height;
- (QSize*) size;
- (QRect*) rect;
- (int) depth;
- (int) numColors;
- (int) bitOrder;
- (unsigned int) color: (int)i;
- setColor: (int)i c: (unsigned int)c;
- setNumColors: (int)arg1;
- (BOOL) hasAlphaBuffer;
- setAlphaBuffer: (BOOL)arg1;
- (BOOL) allGray;
- (BOOL) isGrayscale;
- (unsigned char*) bits;
- (unsigned char*) scanLine: (int)arg1;
- (unsigned char**) jumpTable;
- (int*) colorTable;
- (int) numBytes;
- (int) bytesPerLine;
//- (QGfx*) graphicsContext;
- (BOOL) create: (int)width height: (int)height depth: (int)depth numColors: (int)numColors bitOrder: (int)bitOrder;
- (BOOL) create: (int)width height: (int)height depth: (int)depth ;
- (BOOL) create: (QSize *)arg1 depth: (int)depth numColors: (int)numColors bitOrder: (int)bitOrder;
- (BOOL) create: (QSize *)arg1 depth: (int)depth ;
- reset;
- fill: (unsigned int)pixel;
- invertPixels: (BOOL)invertAlpha;
- invertPixels;
- (QImage*) convertDepth: (int)arg1;
- (QImage*) convertDepthWithPalette: (int)arg1 p: (int *)p pc: (int)pc cf: (int)cf;
- (QImage*) convertDepthWithPalette: (int)arg1 p: (int *)p pc: (int)pc ;
- (QImage*) convertDepth: (int)arg1 conversion_flags: (int)conversion_flags;
- (QImage*) convertBitOrder: (int)arg1;
- (QImage*) smoothScale: (int)w h: (int)h mode: (int)mode;
- (QImage*) smoothScale: (int)w h: (int)h ;
- (QImage*) smoothScale: (QSize *)s mode: (int)mode;
- (QImage*) smoothScale: (QSize *)s ;
- (QImage*) scale: (int)w h: (int)h mode: (int)mode;
- (QImage*) scale: (int)w h: (int)h ;
- (QImage*) scale: (QSize *)s mode: (int)mode;
- (QImage*) scale: (QSize *)s ;
- (QImage*) scaleWidth: (int)w;
- (QImage*) scaleHeight: (int)h;
- (QImage*) xForm: (QWMatrix *)matrix;
- (QImage*) createAlphaMask: (int)conversion_flags;
- (QImage*) createAlphaMask;
- (QImage*) createHeuristicMask: (BOOL)clipTight;
- (QImage*) createHeuristicMask;
- (QImage*) mirror;
- (QImage*) mirror: (BOOL)horizontally vertically: (BOOL)vertically;
- (QImage*) swapRGB;
- (BOOL) load: (NSString *)fileName format: (NSString *)format;
- (BOOL) load: (NSString *)fileName ;
- (BOOL) loadFromData: (unsigned char*)buf len: (unsigned int)len format: (NSString *)format;
- (BOOL) loadFromData: (unsigned char*)buf len: (unsigned int)len ;
- (BOOL) loadFromData: (QByteArray*)data format: (NSString *)format;
- (BOOL) loadFromData: (QByteArray*)data ;
- (BOOL) save: (NSString *)fileName format: (NSString *)format quality: (int)quality;
- (BOOL) save: (NSString *)fileName format: (NSString *)format ;
- (BOOL) valid: (int)x y: (int)y;
- (int) pixelIndex: (int)x y: (int)y;
- (unsigned int) pixel: (int)x y: (int)y;
- setPixel: (int)x y: (int)y index_or_rgb: (unsigned int)index_or_rgb;
- (int) dotsPerMeterX;
- (int) dotsPerMeterY;
- setDotsPerMeterX: (int)arg1;
- setDotsPerMeterY: (int)arg1;
- (QPoint*) offset;
- setOffset: (QPoint*)arg1;
- (NSArray *) textLanguages;
- (NSArray *) textKeys;
- (NSString *) text: (NSString *)key lang: (NSString *)lang;
//- (NSString *) text: (QImageTextKeyLang*)arg1;
- setText: (NSString *)key lang: (NSString *)lang string: (NSString *)arg1;
+ (int) systemBitOrder;
+ (int) systemByteOrder;
+ (NSString *) imageFormat: (NSString *)fileName;
+ (NSArray *) inputFormats;
+ (NSArray *) outputFormats;
+ (NSArray *) inputFormatList;
+ (NSArray *) outputFormatList;
+ (int) IgnoreEndian;
+ (int) BigEndian;
+ (int) LittleEndian;
+ (int) ScaleFree;
+ (int) ScaleMin;
+ (int) ScaleMax;
@end

#endif
