namespace Binge.Bits
{
	using System;
	using System.Collections;

	public enum MemberAccess
	{
		Default,
		Private,
		Protected,
		Public,
		Internal,
		InternalProtected
	}

	public abstract class MemberBase: Binge.Bits.Object
	{
		public Class Parent;
		public ArrayList Attributes;
		public MemberAccess Access;
		public string NativeName, TargetName;
		public bool IsStatic, IsReadOnly, Throttle;

		public MemberBase (bool init)
		{
			if (! init)
				return;

			Parent = null;
			Attributes = new ArrayList ();
			Access = MemberAccess.Default;
			NativeName = TargetName = String.Empty;
			IsStatic = IsReadOnly = Throttle = false;
		}

		public MemberBase (): this (true) {}
	}
}
