// Qt-CSharp tutorial 3
// Based on the Qt tutorial
// Implemented by Marcus Urban

using System;
using Qt;

public class Example {

    public static int Main (String[] args)
    {
        QApplication a = new QApplication (args);

        QVBox box = new QVBox ();
        box.Resize (200, 120);

        QPushButton quit = new QPushButton ("Quit", box);
        quit.SetFont (new QFont ("Times", 18, QFont.Weight.Bold));
        // In C++, QFont::Bold is sufficient

        QObject.Connect ( quit, QtSupport.SIGNAL ("clicked()"), a, QtSupport.SLOT ("Quit()") );
        // SIGNAL and SLOT are static functions of QtSupport

        a.SetMainWidget (box);
        box.Show ();
        return a.Exec ();
    }
}
