<?xml version="1.0" encoding="iso-8859-1"?>
<!--
  ** Author: Marco Ladermann
  ** Date: Thu Sep 12 18:57:21 CEST 2002 @831 /Internet Time/
  ** Purpose:
  ** Changed:
  **
  ** This software is free software. It is released under the terms of the
  ** GNU Lesser General Public Licence (LGPL)
  ** see http://www.gnu.org/copyleft/lesser.html
  **
  ** These stylesheets are distributed in the hope that they will be useful,
  ** but WITHOUT ANY WARRANTY; without even the implied warranty of
  ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  -->
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:exsl="http://exslt.org/common"
    xmlns:func="http://exslt.org/functions"
    xmlns:str="http://exslt.org/strings"
    xmlns:kde="http://kde.org/functions"
    extension-element-prefixes="func"
>

    <!-- 
      ** As a constant, we define a empty node set
      -->
    <xsl:variable name="emptyNodeSet" select="/no-such-node"/>
    
    <!--
      ** A constant to contain all 8-bit characters whith highest bit set.
      ** Needed to check if strings contain utf-8 characters
      -->
    <xsl:variable name="c8" select="'&#x80;&#x81;&#x82;&#x83;&#x84;&#x85;&#x86;&#x87;&#x88;&#x89;&#x8A;&#x8B;&#x8C;&#x8D;&#x8E;&#x8F;&#x90;&#x91;&#x92;&#x93;&#x94;&#x95;&#x96;&#x97;&#x98;&#x99;&#x9A;&#x9B;&#x9C;&#x9D;&#x9E;&#x9F;&#xA0;&#xA1;&#xA2;&#xA3;&#xA4;&#xA5;&#xA6;&#xA7;&#xA8;&#xA9;&#xAA;&#xAB;&#xAC;&#xAD;&#xAE;&#xAF;&#xB0;&#xB1;&#xB2;&#xB3;&#xB4;&#xB5;&#xB6;&#xB7;&#xB8;&#xB9;&#xBA;&#xBB;&#xBC;&#xBD;&#xBE;&#xBF;&#xC0;&#xC1;&#xC2;&#xC3;&#xC4;&#xC5;&#xC6;&#xC7;&#xC8;&#xC9;&#xCA;&#xCB;&#xCC;&#xCD;&#xCE;&#xCF;&#xD0;&#xD1;&#xD2;&#xD3;&#xD4;&#xD5;&#xD6;&#xD7;&#xD8;&#xD9;&#xDA;&#xDB;&#xDC;&#xDD;&#xDE;&#xDF;&#xE0;&#xE1;&#xE2;&#xE3;&#xE4;&#xE5;&#xE6;&#xE7;&#xE8;&#xE9;&#xEA;&#xEB;&#xEC;&#xED;&#xEE;&#xEF;&#xF0;&#xF1;&#xF2;&#xF3;&#xF4;&#xF5;&#xF6;&#xF7;&#xF8;&#xF9;&#xFA;&#xFB;&#xFC;&#xFD;&#xFE;&#xFF;'"/>
    <xsl:variable name="tmp" select='"&#xA;&#xD;&apos;"'/>
    <xsl:variable name="c7" select="concat($tmp, '&#x20;&#x21;&#x22;&#x23;&#x24;&#x25;&#x26;&#x28;&#x29;&#x2A;&#x2B;&#x2C;&#x2D;&#x2E;&#x2F;&#x30;&#x31;&#x32;&#x33;&#x34;&#x35;&#x36;&#x37;&#x38;&#x39;&#x3A;&#x3B;&#x3C;&#x3D;&#x3E;&#x3F;&#x40;&#x41;&#x42;&#x43;&#x44;&#x45;&#x46;&#x47;&#x48;&#x49;&#x4A;&#x4B;&#x4C;&#x4D;&#x4E;&#x4F;&#x50;&#x51;&#x52;&#x53;&#x54;&#x55;&#x56;&#x57;&#x58;&#x59;&#x5A;&#x5B;&#x5C;&#x5D;&#x5E;&#x5F;&#x60;&#x61;&#x62;&#x63;&#x64;&#x65;&#x66;&#x67;&#x68;&#x69;&#x6A;&#x6B;&#x6C;&#x6D;&#x6E;&#x6F;&#x70;&#x71;&#x72;&#x73;&#x74;&#x75;&#x76;&#x77;&#x78;&#x79;&#x7A;&#x7B;&#x7C;&#x7D;&#x7E;&#x7F;')"/> 
    
    <!-- Function: kde:if
      ** @param bool
      ** @param trueVal
      ** @param falseVal
      ** @return ( bool ) ? trueVal : falseVal
      -->
    <func:function name="kde:if">
        <xsl:param name="bool"/>
        <xsl:param name="trueVal"/>
        <xsl:param name="falseVal"/>
        <func:result>
            <xsl:choose>
                <xsl:when test="$bool"><xsl:value-of select="$trueVal"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="$falseVal"/></xsl:otherwise>
            </xsl:choose>
        </func:result>
    </func:function>

    <!-- Function: kde:index
      ** @param string
      ** @param substring
      ** @return the index of "substring" in "string"
      -->
    <func:function name="kde:index">
        <xsl:param name="string"/>
        <xsl:param name="substring"/>
        <func:result select="string-length(substring-before($string, $substring))"/> 
    </func:function>
    
    <!--
      ** Function: replace
      ** @param string, string to search
      ** @param lookup, string to look up
      ** @param replace, string to substitute
      ** @return $string with all occurences of $lookup replaced by $replace 
      -->
    <func:function name="kde:replace">
        <xsl:param name="string"/>
        <xsl:param name="lookup"/>
        <xsl:param name="replace"/>
        <func:result>
            <xsl:choose>
                <xsl:when test="function-available('str:replace')">
                    <xsl:value-of select="str:replace($string, $lookup, $replace)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:call-template name="replace-string">
                        <xsl:with-param name="string" select="$string"/>
                        <xsl:with-param name="lookup" select="$lookup"/>
                        <xsl:with-param name="replace" select="$replace"/>
                    </xsl:call-template>
                </xsl:otherwise>
            </xsl:choose>
        </func:result>
    </func:function>
	<!-- named helper template  -->
	<xsl:template name="replace-string">
        <xsl:param name="string"/>
        <xsl:param name="lookup"/>
        <xsl:param name="replace"/>
		<xsl:variable name="first" select="substring-before($string, $lookup)"/>
		<xsl:choose>
			<xsl:when test="$first = ''">
				<xsl:value-of select="$string"/>
			</xsl:when>
			<xsl:otherwise>
				<xsl:variable name="rs">
					<xsl:call-template name="replace-string">
						<xsl:with-param name="string" select="substring-after($string, $lookup)"/>
						<xsl:with-param name="lookup" select="$lookup"/>
						<xsl:with-param name="replace" select="$replace"/>
					</xsl:call-template>
				</xsl:variable>
				<xsl:variable name="result" select="concat($first, $replace, $rs)"/>
				<xsl:value-of select="$result"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
    
    <!--
      ** Function: upper-case
      ** @param string
      ** @return string in upper case letter
      -->
    <func:function name="kde:upper-case">
        <xsl:param name="string"/>
        <func:result select="translate($string, 
                                       'abcdefghijklmnopqrstuvwxyz',
                                       'ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/> 
    </func:function>
    

    <!--
      ** Function: lower-case
      ** @param string
      ** @return string in upper case letter
      -->
    <func:function name="kde:lower-case">
        <xsl:param name="string"/>
        <func:result select="translate($string, 
                                       'ABCDEFGHIJKLMNOPQRSTUVWXYZ', 
                                       'abcdefghijklmnopqrstuvwxyz')"/>
    </func:function>
    
    <!--
      ** Function: upper-first
      ** @param string
      ** @return string with first character as upper case letter
      -->
    <func:function name="kde:upper-first">
        <xsl:param name="string"/>
        <xsl:variable name="rest" select="substring($string, 2)"/>
        <xsl:variable name="head" select="kde:upper-case(substring($string, 1, 1))"/>
        <func:result>
            <xsl:value-of select="concat($head, $rest)"/>
        </func:result>    
    </func:function>

    <!--
      ** Function: isUtf8
      ** @param string
      ** @return true if and only if string contains a character > 255
      -->
    <func:function name="kde:isUtf8">
        <xsl:param name="string"/>
        <xsl:variable name="rest" select="substring($string, 2)"/>
        <xsl:variable name="head" select="substring($string, 1, 1)"/>
        <func:result>
            <xsl:choose>
                <xsl:when test="string-length($string) = 0">
                    <xsl:value-of select="false()"/>
                </xsl:when>
                <xsl:when test="contains($c8, $head) or not(contains($c7, $head))">
                    <xsl:value-of select="true()"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="kde:isUtf8($rest)"/>
                </xsl:otherwise>
            </xsl:choose>
        </func:result>    
    </func:function>

    <!--
      ** Function: repeat
      ** @param string
      ** @param times
      ** @return 'times' copies of string
      -->
    <func:function name="kde:repeat">
        <xsl:param name="string"/>
        <xsl:param name="times"/>
        <xsl:variable name="copy" select="$string"/>
        <func:result>
            <xsl:choose>
                <xsl:when test="$times &lt;= 0"><xsl:value-of select="''"/></xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($string, kde:repeat($copy, $times - 1))"/>
                </xsl:otherwise>
            </xsl:choose>
        </func:result>
    </func:function>
    
    <!--
      ** Function: getNodeName
      ** @param node
      ** @return the (variable) name of a node 
      -->
    <func:function name="kde:getNodeName">
        <xsl:param name="node" select="."/>
        <func:result>
			<xsl:call-template name="getNodeName">
				<xsl:with-param name="node" select="$node"/>
			</xsl:call-template>
        </func:result>
    </func:function>
	<xsl:template name="getNodeName">
        <xsl:param name="node" select="."/>
		<xsl:variable name="name" select="$node/property[@name = 'name']/cstring"/>
		<xsl:choose>
			<xsl:when test="$name = 'unnamed'">
                <xsl:call-template name="getNodeName">
                    <xsl:with-param name="node" select="$node/.."/>
                </xsl:call-template>
				<xsl:value-of select="kde:upper-first(name($node))"/>
                <xsl:variable name="precedingUnnamed" select="count($node/preceding::*[name() = name($node)]/property[@name='name' and cstring = 'unnamed'])"/>
                <xsl:if test="$precedingUnnamed &gt; 0">
                    <xsl:value-of select="$precedingUnnamed + 1"/>
                </xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<xsl:value-of select="$name"/>
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

    <!--
      ** Templates to "print" xml in text output mode
    -->
    <xsl:template match="*" mode="print">
        <xsl:value-of select="concat('&lt;', name())"/>
        <xsl:apply-templates select="@*" mode="print"/>
        <xsl:value-of select="'&gt;'"/>
        <xsl:apply-templates mode="print"/> 
        <xsl:value-of select="concat('&lt;/', name(), '&gt;')"/>
    </xsl:template>
    <xsl:template match="@*" mode="print">
        <xsl:value-of select="concat(' ', name(), '=&quot;', ., '&quot;')"/>
    </xsl:template>
    
    
    <!--
      ** Print the path from the root to a given node
      -->
    <func:function name="kde:printPath">
        <xsl:param name="node"/>
        <xsl:param name="path" select="''"/>
        <func:result>
            <xsl:choose>
                <xsl:when test="$node = /UI">
                    <xsl:value-of select="concat('/UI', $path)"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="kde:printPath($node/.., 
														concat('/',
                                                               name($node), 
                                                               '[',
															   count($node/preceding-sibling::*[name() = name($node)]) + 1, 
															   ']',
                                                               $path))"/>
                </xsl:otherwise>
            </xsl:choose>
        </func:result>
    </func:function>
    
    <!--
      ** Return qt and kde classes used in signal/slot signature
      -->
    <xsl:template name="kde:classes-in-signature">
        <xsl:param name="signature"/>
        <xsl:variable name="sig" select="kde:replace(
                                            substring-before(
                                                substring-after(
                                                    translate($signature, '&amp;*,', '   '), 
                                                    '('
                                                ), 
                                                ')'
                                            ),
                                            'QString',
                                            'String')"/>
        <xsl:for-each select="str:split($sig)">
            <xsl:variable name="prefix" select="substring(., 1, 1)"/>
            <xsl:if test="$prefix = 'Q' or $prefix = 'K'">
                <xsl:element name="class">
                    <xsl:value-of select="."/>
                </xsl:element>
            </xsl:if>
        </xsl:for-each>
    </xsl:template>

</xsl:stylesheet>

