/* ****************************************************************************
  This file is part of KMathTool

  Copyright (C) 2003 by Marco Wegner <mail@marcowegner.de>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

**************************************************************************** */


#include <qlayout.h>

#include "kmtmodule.h"


KMathToolModule::KMathToolModule(QObject* parent, const char* name)
  : QObject(parent, name)
{
  mvstack = new ModuleViewStack;
}

KMathToolModule::~KMathToolModule( )
{
  delete mvstack;
}

void KMathToolModule::addView(ModuleView* view)
{
  mvstack->addWidget(view);
  _views.append(view);
}

void KMathToolModule::showView(ModuleView* view)
{
  mvstack->raiseWidget(view);
}


// *******************************
// ***** SLOT implementation *****
// *******************************
void ModuleViewStack::raiseWidget(QWidget* w)
{
  QWidget* widget = visibleWidget( );
  if (widget)
    disconnect(widget, 0, this, 0);

  ModuleView* view = static_cast<ModuleView*>(w);

  // connect the module view about to show
  connect(view, SIGNAL(signalMessage(const QString&)),
    this, SIGNAL(signalMessage(const QString&)));
  connect(view, SIGNAL(signalError(const QString&)),
    this, SIGNAL(signalError(const QString&)));
  connect(view, SIGNAL(signalNewCalculation( )),
    this, SIGNAL(signalNewCalculation( )));

  view->aboutToActivate( );

  QWidgetStack::raiseWidget(view);
}

#include "kmtmodule.moc"
