/***************************************************************************
                          stuff.h  -  description
                             -------------------
    begin                : Mon Aug 19 2002
    copyright            : (C) 2002 by Stefan Winter
    email                : mail@stefan-winter.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef STUFF_H
#define STUFF_H

#include <qstring.h>
#include <qstringlist.h>
#include <arts/iomanager.h>
#include <arts/dispatcher.h>

const int POLL_DELAY_MS = 250; // how much time between device polls
const int MAX_HISTORY = 240; // number of device states to be saved

extern "C" {
  #include <iwlib.h>
}

struct deviceinfo
  {
    int has_freq;
    float freq;
    int mode;
    int has_mode;
    int has_key;
    QString key;
    int key_size;
    int key_flags;
    QString essid;
    sockaddr ap_addr;
    QString ip_addr;
    iwparam bitrate;
    QString used_interface;
    int skfd;
    iw_quality qual;
    iwrange range;
    int has_range;
  };

struct deviceinfo_new {
    bool has_frequency;
    float frequency;
    bool has_mode;
    int mode;
    bool has_key;
    QString key;
    int key_size;
    int key_flags;
    QString essid;
    sockaddr access_point_address;
    QString ip_address;
    iwparam bitrate;
    QString interface_name;
    int socket;
    iw_quality quality;
    bool has_range;
    iwrange range;
};

struct statistical_data
{
  int sigLevel[240];
  int sigLevelMin, sigLevelMax;
  int noiseLevel[240];
  int noiseLevelMin, noiseLevelMax;
  int qual[240];
  bool valid[240];
  int current;
};

class Interface_Talker {
  public:
  Interface_Talker(QString iface="");
  virtual int open_device_socket()=0;
  virtual void poll_device_info()=0;
  virtual bool give_device_freq(float &freq)=0;
    // true: device returned valid frequency
  virtual bool give_mode(int &mode)=0;
    // true: device returned valid mode info
  virtual bool give_key(QString &key,int size,int flags)=0;
    // true: device has set up a valid crypto key
  virtual QString give_essid()=0;
  virtual bool give_AP_info(QString &mac, QString &ip)=0;
    // true: could retrieve IP, false: returned IP info invalid
  virtual double give_bitrate()=0;
  virtual QString give_interface_name()=0;
    // if no device is attached, return empty QString
  virtual bool give_current_quality(int &sig, int &noi, int &qua)=0;
    // quality info is only valid when true
  virtual ~Interface_Talker(){};
  protected:
  struct deviceinfo_new {
    bool has_frequency;
    float frequency;
    bool has_mode;
    int mode;
    bool has_key;
    QString key;
    int key_size;
    int key_flags;
    QString essid;
    QString access_point_address;
    QString ip_address;
    double bitrate;
    QString interface_name;
    int socket;
    bool has_range;
  } device_information;
  struct stats {
    int sigLevel[MAX_HISTORY];
    int noiseLevel[MAX_HISTORY];
    int qual[MAX_HISTORY];
    bool valid[MAX_HISTORY];
    int current;
  } statistical_data;
};

class Interface_Talker_wirelessextensions : public Interface_Talker {
  public:
  Interface_Talker_wirelessextensions();
  int open_device_socket();
  void poll_device_info();
  bool give_device_freq(float &freq);
  bool give_mode(int &mode);
  bool give_key(QString &key,int size,int flags);
  QString give_essid();
  bool give_AP_info(QString &mac, QString &ip);
  double give_bitrate();
  QString give_interface_name();
  bool give_current_quality(int &sig, int &noi, int &qua);
};

void sinus_wave (double frequency);

class MyTimeNotify:public
  Arts::TimeNotify
{
public:
  Arts::Dispatcher * test;
  MyTimeNotify (Arts::Dispatcher * siff)
  {
    test = siff;
  };
  void notifyTime ();
};

QString whois (char *MAC_ADR, QStringList APList);
int operator == (const deviceinfo & eins, const deviceinfo & zwei);

#endif /*  STUFF_H */
