/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */



#ifndef _AUDIOMANAGER_H
#define _AUDIOMANAGER_H

#include <qmap.h>
#include <qstring.h>
#include <qobject.h>

class KdetvMixerPlugin;
class PluginFactory;

class AudioManager : public QObject
{
	Q_OBJECT

public:
    void rescanPlugins();
    KdetvMixerPlugin *plugin();

public slots:
    int setVolume(int left, int right);
    int setMuted(bool mute);

signals:
    void mixerAvailable(bool);

protected:
    friend class Kdetv;
    AudioManager(PluginFactory *pf);
    ~AudioManager();
    void scanPlugins();

private:
    KdetvMixerPlugin *_mixer;
    QString _selectedMixer;
    PluginFactory *_pf;
};



#endif

