// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *               2004 Dirk Ziegelmeier <dziegel@gmx.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */


#ifndef __CHANNEL_H
#define __CHANNEL_H

#include <qobject.h>
#include <qstring.h>
#include <qvariant.h>
#include <qmap.h>

/**
 * Defines a TV channel.
 */
class Channel : public QObject
{
    Q_OBJECT

    Q_PROPERTY( int number READ number WRITE setNumber )
    Q_PROPERTY( QString name READ name WRITE setName )
    Q_PROPERTY( QString url READ url WRITE setURL )
    Q_PROPERTY( QString description READ description WRITE setDescription )
    Q_PROPERTY( bool enabled READ enabled WRITE setEnabled )

public:
    typedef QMap<QString, QVariant> PropertyList;

    Channel( QObject *parent, const char *name=0 );
    virtual ~Channel() {}

    int number() const { return _num; }
    bool enabled() const { return _enabled; }
    const QString& name() const { return _name; }
    const QString& url() const { return _url; }
    const QString& description() const { return _description; }

    bool hasControls(const QString& dev) const { if(_hasControls.contains(dev)) return _hasControls[dev]; else return false; }
    const QVariant& control(const QString& dev, const QString& property) const { return _controls[dev][property]; }

    const QVariant& getChannelProperty(const QString& property) const { return _channelProperties[property]; }

    const QMap<QString, PropertyList>& allControls() const { return _controls; }
    const PropertyList& controls(const QString& dev) const { return _controls[dev]; }
    const PropertyList& channelProperties() const { return _channelProperties; }

    Channel& operator=(const Channel *src);
    void updateValues( const QString& name, int num, bool enabled );

    bool compareChannelProperties(const Channel& other);

public slots:
    void setNumber( int num );
    void setEnabled( bool enabled = true );
    void setName( const QString &name );
    void setHasControls(const QString& dev, bool yesno);
    void setControl(const QString& dev, const QString& property, const QVariant& value);
    void setChannelProperty(const QString& property, const QVariant& value);
    void setURL( const QString &url );
    void setDescription( const QString &description );

signals:
    void changed(); 

private:
    QString _name;
    int     _num;
    bool    _enabled;
    QMap<QString, bool>         _hasControls;
    QMap<QString, PropertyList> _controls;
    PropertyList _channelProperties;
    QString _url;
    QString _description;
};

#endif
