/***************************************************************************
                           filtermanager.cpp
                           -----------------
    begin                : Sun Jun 13 2004
    copyright            : (C) 2004 by Dirk Ziegelmeier
    email                : dziegel@gmx.de
 ***************************************************************************/

/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <kdebug.h>

#include "filtermanager.h"
#include "kdetvfilterplugin.h"
#include "pluginfactory.h"
#include "kdetvvideo/kdetvimagefilter.h"

FilterManager::FilterManager(PluginFactory* pf)
    : QObject(),
      _pf(pf)
{
    _chain = new KdetvImageFilterChain();
    _plugs.setAutoDelete(false);
    scanPlugins();
}

FilterManager::~FilterManager()
{
    clear();
    delete _chain;
}

void FilterManager::clear()
{
    _chain->clear();

    while (KdetvFilterPlugin *p = _plugs.first()) {
        p->destroy();
        _plugs.remove(p);
    }
}

void FilterManager::scanPlugins()
{
    clear();

	QPtrList<PluginDesc>& filterPlugins(_pf->filterPlugins());
	for (PluginDesc* plug = filterPlugins.first();
			plug;
			plug = filterPlugins.next()) {
		if (plug->enabled) {
            KdetvFilterPlugin* p = _pf->getFilterPlugin(plug);
            _plugs.append(p);
            _chain->append(p->getFilter());
            break; // There must be only one enabled filter plugin
		}
	}

	QPtrList<PluginDesc>& postProcessPlugins(_pf->postProcessPlugins());
	for (PluginDesc* plug = postProcessPlugins.first();
			plug;
			plug = postProcessPlugins.next()) {
		if (plug->enabled) {
            KdetvFilterPlugin* p = _pf->getPostProcessPlugin(plug);
            _plugs.append(p);
            _chain->append(p->getFilter());
		}
	}
}

#include "filtermanager.moc"

// vim: sw=4 ts=4 noet
