// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include <klocale.h>
#include <qfile.h>
#include <qstringlist.h>
#include <qtextstream.h>

#include <kdebug.h>

#include "channel.h"
#include "channelstore.h"

#include "channeliocsv.h"

//
// CSV Format Handler
//

ChannelIOFormatCSV::ChannelIOFormatCSV(Kdetv *ktv, QObject *parent, const char *name)
    : KdetvChannelPlugin(ktv, "CSV Channels", parent, name)
{
    _fmtName  = "csv";
    _menuName = i18n("CSV");
    _flags    = FormatRead|FormatWrite;
}

bool ChannelIOFormatCSV::save( ChannelStore *store, ChannelFileMetaInfo *,
                               QIODevice *file, const QString&/*fmt*/ )
{
    kdDebug() << "IOFormatCSV::save(...)" << endl;

    kdDebug() << "IOFormatCSV::save(...) channel count=" << store->count() << endl;
    
    this->store = store;
    QTextStream ts( file );

    for ( uint i = 0; i < store->count(); i++ ) {
        Channel *j = store->channelAt(i);
        kdDebug() << "IOFormatCSV::save(...), line='" << j->number() << "(" << j->name() << ")" << endl;

        ts << j->number() << ","
           << (long)j->getChannelProperty("frequency").toULongLong() << ","
           << j->name() << ","
           << j->getChannelProperty("encoding").toString() << ","
           << j->getChannelProperty("source").toString() << endl;
    }

    kdDebug() << "IOFormatCSV::save(...) done" << endl;
    return true;
}

bool ChannelIOFormatCSV::load( ChannelStore *store, ChannelFileMetaInfo *,
                               QIODevice *file, const QString&/*fmt*/ )
{
    kdDebug() << "IOFormatCSV::load(...)" << endl;

    this->store = store;
    QString rawch( file->readAll() );
    file->close();

    QStringList lines = QStringList::split("\n", rawch);
    if ( !lines.count() )
        return false;

    bool foundOne = false;
    for ( QStringList::ConstIterator i = lines.constBegin(); i != lines.constEnd(); ++i ) {
        QStringList ch = QStringList::split( ",", *i );

        bool numok, freqok;
        int num = ch[0].toInt( &numok );
        unsigned long freq = ch[1].toULong( &freqok );
        QString name     = (ch.count() >= 3 ) ? ch[2] : QString::null;
        QString encoding = (ch.count() >= 4 ) ? ch[3] : QString::null;
        QString source   = (ch.count() >= 5 ) ? ch[4] : QString::null;

        if ( numok && freqok ) {
            Channel *x = new Channel( store );
            x->setName( name );
            x->setNumber( num );
            x->setChannelProperty("frequency", (unsigned int)freq);
            x->setChannelProperty("source", source);
            x->setChannelProperty("encoding", encoding );

            kdDebug() << "IOFormatCSV::load(...), adding '" << x->name() << "'" << endl;
            store->addChannel(x);
            foundOne = true;
        }
    }

    return foundOne;
}
    

extern "C" {
	ChannelIOFormatCSV* create_csvchannels(Kdetv *ktv)
    {
		return new ChannelIOFormatCSV(ktv, 0, "CSV Channels Plugin");
	}
}

