// File: alsa_plugin.h
// Author: Neil Macvicar (blackmogu@vfemail.net)
// Date: 14/12/2002
// Abstract: Definition of the ALSA mixer plugin for Kdetv
// Revision Control
// 0.2 : 26/03/2003 Minor changes to the constructor implemented (Neil Macvicar)
// 0.1 : Initial Definition

/*
 * Copyright (C) 2002 Neil Macvicar <blackmogu@vfemail.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __ALSA_PLUGIN_H__
#define __ALSA_PLUGIN_H__

#define PLUGIN_ID "ALSA Mixer Plugin: "

#include <kdetvmixerplugin.h>

#include <qobject.h>
#include <qstring.h>
#include <qwidget.h>
#include <qmap.h>
#include <qvaluelist.h>
#include <qcombobox.h>

#include <alsa/asoundlib.h>

#define REPORT kdDebug() << PLUGIN_ID << sig << ' '

class KdetvALSA : public KdetvMixerPlugin
{
    Q_OBJECT

public:
    KdetvALSA(Kdetv *ktv, QObject *parent,  const char *name);
    virtual ~KdetvALSA(void);

    virtual int probeDevices(void);
    virtual int setVolume(int LetftChannel, int RightChannel);
    virtual int volumeLeft(void);
    virtual int volumeRight(void);

    virtual int setMuted(bool mute);
    virtual bool muted(void);

public slots:
    virtual QWidget *configWidget(QWidget *, const char *);
    virtual void saveConfig(void);

private slots:
    void cardChanged(const QString &card_name);
 
private:
    void loadConfig(void);
    int useCardMixerElement(const QString &HCTL_id, QString &mixer_element);
    snd_mixer_t *attachMixer(const QString &HCTL_id);
    int detachMixer(snd_mixer_t *mixer, const char *HCTL_id);
    int loadMixerElements(snd_mixer_t *mixer);
  
    QMap<int, QString> probed_cards; 
    QMap<snd_mixer_elem_t *, QString> mixer_elements; 

    QComboBox *card_selector;
    QComboBox *element_selector;

    QString active_HCTL;
    QString active_mixer_element;
    snd_mixer_t *active_mixer;
    snd_mixer_elem_t *active_element;
    int volume_left, volume_right;

    bool muted_flag;
};

#endif
