// -*- c++ -*-

/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 * Copyright (C) 2002 Richard Moore <rich@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#ifndef __KDETVV4L_PLUGIN_H
#define __KDETVV4L_PLUGIN_H

#include <kdetvsrcplugin.h>
#include <qmutex.h>
#include <qmap.h>
#include <qtimer.h>

#include "qvideo.h"
#include "v4lplugincfg.h"

#include "kdetvvideo/kdetvimage.h"

class V4LDev;
class V4LGrabber;
class OverlayController;
class QVideoStream;
class KdetvImageFilterChain;
class KdetvFormatConversionFilter;

/**
 * Video source plugin for Video4Linux.
 */
class KdetvV4L : public KdetvSourcePlugin
{
    Q_OBJECT

public:
    KdetvV4L(Kdetv *ktv, QWidget *parent = 0, const char* name = 0);
    virtual ~KdetvV4L();

    /**
     * To get various values.
     */
    virtual int frequency();
    virtual bool muted();
    virtual bool isTuner();
    virtual int signal();
    virtual QColor colourKey();
    virtual Control::ControlList& controls();

    virtual const QStringList& broadcastedAudioModes();
    virtual const QString&     defaultAudioMode();

    virtual int probeDevices();

    virtual bool videoPlaying() const;

    virtual bool supportsImageFiltering() const { return true; }

public slots:
    /**
     * Sets the device to use.
     */
    virtual int setDevice( const QString &dev );

    /**
     * Sets the channel properties.
     */
    virtual int setChannelProperties(const Channel::PropertyList& properties);

    /**
     * Sets the source to use.
     */
    virtual int setSource( const QString &src );

    /**
     * Sets the tuner mode.
     */
    virtual int setEncoding( const QString &encoding );

    /**
     * Sets the current current channel.
     */
    virtual void setFrequency( int freq );

    /**
     * Mutes the sound.
     */
    virtual void setMuted( bool muted );

    virtual bool setVolume( int left, int right );

    virtual int setAudioMode( const QString& audioMode );

    virtual int startVideo();
    virtual int stopVideo();

    virtual int setVideoDesktop(bool on);
    virtual bool canVideoDesktop() const;

    virtual bool canGrabStill() const;
    virtual bool grabStill( QImage *pix );

    virtual QWidget *configWidget(QWidget*, const char *);
    virtual void saveConfig();

    virtual void setFullscreen(bool);


private:
    QWidget *_w;
    QWidget *_dtReg;
    QWidget *_winReg;
    int _wReg, _hReg;

public:
    V4LDev *dev;
    V4LGrabber *g;

private:
    QMap<QString,QString> _devNames;
    bool _probed;
    QVideoStream *_vs;
    QString _currentDev;
    OverlayController *_overlayController;
    bool _capturing;
    V4LPluginCfg *_cfgWidget;
    int _gsn;  // grabber sequence number
    int _fieldTime;
    KdetvImage::ImageType _mostRecentField;
    KdetvFormatConversionFilter* _formatConversionFilter;

    QSize setScreenResolution(const QSize&);
    QSize _previousSize;

    void calculateGrabFormat(KdetvImageFilterChain* c, KdetvFormatConversionFilter* f);

    // Config options
    bool _autoConfig;
    QVideo::VideoMethod _qvsMethod;
    bool _useOverlay;
    bool _changeRes;
    bool _fullFrameRate;

    Control::ControlList _controls;


private slots:
    void viewMoved();
    void viewResized();
    void repaintScreen();
    void updateClipping();
    int  enableOverlay(bool);
    bool event(QEvent* e);
};

#endif

