
/*
 *
 * Copyright (C) 2002 George Staikos <staikos@kde.org>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */


#include "kdetvpluginbase.h"

#include <kconfig.h>

KdetvPluginBase::KdetvPluginBase(Kdetv *ktv, const QString& cfgkey, QObject *o, const char* n)
    : QObject(o, n),
      _ktv(ktv)
{
	_cfg = new KConfig(QString("kdetv-plugin-")+cfgkey);
}


KdetvPluginBase::~KdetvPluginBase()
 {
	delete _cfg;
	_cfg = 0;
}

PluginDesc* const KdetvPluginBase::pluginDescription() const
{
	return _description;
}

void KdetvPluginBase::saveConfig()
{
}

QWidget* KdetvPluginBase::configWidget(QWidget *, const char *)
{
	return 0;
}

Kdetv* KdetvPluginBase::driver() const
{
	return _ktv;
}

#include "kdetvpluginbase.moc"

