#ifndef DAEMONDOCK
#define DAEMONDOCK 1
/*
 * daemondock.h
 * Copyright (C) 1999 Paul Campbell <paul@taniwha.com>
 *
 * This file contains the docked widget for the laptop battery monitor
 *
 * $Id: daemondock.h 646732 2007-03-26 15:07:10Z ossi $
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */


#include "laptop_daemon.h"
#include <ksystemtray.h>
//Added by qt3to4:
#include <QMouseEvent>
#include <QPixmap>
#include <QShowEvent>
#include <Q3PopupMenu>

class laptop_daemon;
class KPCMCIA;
class KPCMCIACard;
class Q3PopupMenu;
class Q3VBox;
class QSlider;
class KMenu;

#include <QMap>

class laptop_dock : public KSystemTray {

  Q_OBJECT

public:
  laptop_dock(laptop_daemon* parent);
  ~laptop_dock();
  void displayPixmap();

  void mousePressEvent( QMouseEvent * ); 
  void mouseReleaseEvent( QMouseEvent * ); 
  void showEvent( QShowEvent * );  
  void reload_icon();

  inline void setPCMCIA(KPCMCIA *p) { _pcmcia = p; }

  void SetupPopup();

private slots:
  void invokeStandby();
  void invokeSuspend();
  void invokeLockSuspend();
  void invokeHibernation();
  void invokeLockHibernation();
  void invokeSetup();
  void invokeBrightness();
  void invokeBrightnessSlider(int v);

  void slotEjectAction(int id);
  void slotResumeAction(int id);
  void slotSuspendAction(int id);
  void slotInsertAction(int id);
  void slotResetAction(int id);
  void slotDisplayAction(int id);

  void activate_throttle(int ind);
  void fill_throttle();
  void activate_performance(int ind);
  void fill_performance();


  void rootExited(K3Process *p);
  void slotGoRoot(int id);
  void slotQuit();
  void slotHide();

private:
  int brightness;
  Q3VBox *brightness_widget;
  QSlider *brightness_slider;
  laptop_daemon *pdaemon;
  QPixmap	pm;
  Q3PopupMenu	*performance_popup, *throttle_popup;
  int	 	current_code;
  KPCMCIA       *_pcmcia;
  QMap<int,KPCMCIACard *> _ejectActions,
                          _suspendActions,
                          _resumeActions,
                          _resetActions,
                          _displayActions,
                          _insertActions;

  KComponentData instance; 	// handle so we get our pretty icons right
  KMenu 	*rightPopup;

}; 
#endif 

