/***************************************************************************
 *   Copyright (C) 2004, 2005 Thomas Nagy                                  *
 *   tnagy2^8@yahoo.fr                                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License version 2        *
 *   as published by the Free Software Foundation (see COPYING)            *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 ***************************************************************************/

#ifndef _KDISSERTVIEW_H
#define _KDISSERTVIEW_H

#include <kmdichildview.h>
#include <kmdichildfrm.h>

class KDissertPart;

/**
 * This class serves as the kdissert view.
 *
 * @short main view class
 * @author Thomas Nagy <tnagy2^8@yahoo.fr>
 * @version 0.3.3
 */
class KDissertView : public KMdiChildView 
{
    Q_OBJECT
    public:
	KDissertView( QWidget *parentWidget=0L, const char *name=0L );
	virtual ~KDissertView();

	KDissertPart *part();
	QWidget *m_lwidget;
	QWidget *m_cwidget;

    private:
	KDissertPart *m_part;
    
    public slots:
	void updateCaption();
};

#endif // _KDISSERTVIEW_H
