#!/bin/sh -e

# Idea borrowed from RedHat's kernel package

if [ -n "$1" ]; then
	if [ ! -d "$1" ]; then
		echo "$1" does not exist, or is not a directory
		exit 1
	fi
	cd $1
else
	cd /usr/include
fi

if [ ! -d asm-sparc ] ; then
	echo E: asm-sparc must exist, or you will have problems
	exit 1
fi

rm -rf asm
mkdir asm

for h in `ls asm-sparc | grep '\.h$' | sort -u`; do
	name=`echo $h | tr a-z. A-Z_`
	# common header
	cat > asm/$h << EOF
/* All asm/ files are generated and point to the corresponding
 * file in asm-sparc. To regenerate, run "generate-asm"
 */

#ifndef __SPARCSTUB__${name}__
#define __SPARCSTUB__${name}__

EOF
	# sparc only
	if [ -f asm-sparc/$h ]; then
		cat >> asm/$h <<EOF
#ifndef __arch64__
#include <asm-sparc/$h>
#endif
EOF
	fi

	# common footer
	cat >> asm/$h <<EOF

#endif /* !__SPARCSTUB__${name}__ */
EOF

done
