/***************************************************************************
 *   Copyright (C) 2005 Novell, Inc.                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA           *
 ***************************************************************************/

#include "hitwidget.h"
#include <kpushbutton.h>
#include <kdebug.h>
#include <klocale.h>
#include <kurllabel.h>
#include <kglobalsettings.h>
#include <qlayout.h>

HitWidget::HitWidget(QString uri, QString mimetype, QWidget *parent, const char *name)
  : HitWidgetLayout(parent, name), m_uri(uri), m_mimetype(mimetype)
{
  score->setText("");
  setDescriptionText("");
  setPropertiesText("");
}

HitWidget::~HitWidget()
{
}

void HitWidget::setDescriptionText(QString text)
{
  description->setText(text);
}

void HitWidget::setPropertiesText(QString text)
{
  properties->setText(text);
}

void HitWidget::insertHeaderWidget( int index, QWidget * widget)
{
  layoutHeader->insertWidget(index,widget);
}

void HitWidget::insertHitWidget( int index, QWidget * widget)
{
  layoutButton->insertWidget(index,widget);
}

void HitWidget::insertTextWidget( int index, QWidget * widget)
{
  layoutText->insertWidget(index,widget);
}

void HitWidget::insertHitSpacing( int index, int size)
{
  layoutButton->insertSpacing(index,size);
}

QString HitWidget::uri() const
{
  return m_uri;
}

void HitWidget::setUri(const QString uri)
{
  m_uri = uri;
}

QString HitWidget::mimetype() const
{
  return m_mimetype;
}

void HitWidget::adjustSize()
{
  HitWidgetLayout::adjustSize();
  const int dwidth = description->size().width();
  const int pwidth = properties->size().width();
  description->setFixedSize(dwidth,description->heightForWidth(dwidth));
  properties->setFixedSize(pwidth,properties->heightForWidth(pwidth));
  HitWidgetLayout::adjustSize();
}

#include "hitwidget.moc"
