/***************************************************************************
 *   Copyright (C) 2005 Novell, Inc.                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA           *
 ***************************************************************************/

#ifndef SEARCHDLG_H
#define SEARCHDLG_H

#include <searchdlg_layout.h>
#include "kerryapp.h"
#include "beaglesearch.h"
#include <kio/previewjob.h>
#include <kfileitem.h>
#include <dcopinterface.h>

class KFileItem;
class QCheckBox;

class SearchDlg : public HitsLayout, virtual public dcopIface
{
    Q_OBJECT

	enum ScopeType {
		Everywhere,
		Applications,
//		Contacts,
		Documents,
		Conversations,
		Images,
		Media,
                Website
	};

	enum SortType {
		Relevance,
		Name,
		Modified
	};

  public:
    SearchDlg(QWidget *parent = 0, const char *name = 0);
    ~SearchDlg();
    int getDisplayAmount() const { return displayAmount; }
    void setDisplayAmount(int);
    void setSortOrder(int);

  public slots:
    void search(const QString& text);
    void showSearchDialog();

  protected:
    void keyPressEvent(QKeyEvent *);

  signals:
    void searchStarted(const QString& term);

  private slots:
    void slotStartBeagle();
    void slotButtonClear();
    void slotClear();
    void slotPrevious();
    void slotNext();
    void search();
    void searchChanged(const QString &);
    void searchHasOutput(BeagleSearch::BeagleResultList &results);
    void searchLostOutput(BeagleSearch::BeagleVanishedURIList &results);
    void searchFinished();
    void searchError (const QString& error);
    void sortFilterResults();
    void slotOpen();
    void slotOpenDir();
    void slotMailTo(const QString&);
    void slotOpenEvolution(const QString&);
    void slotContextMenu( int row, int col, const QPoint & pos );
    void slotPreview(const KFileItem *, const QPixmap &);
    void slotPreviewResult();

  private:
    BeagleSearch beagle_search;
    BeagleSearch::BeagleResultList results, displayed_results;
    int displayOffset;
    int displayAmount;
    int defaultSortOrder,currentSortOrder;
    void insertResult(BeagleSearch::beagle_result_struct *result,int index);
    void fillTableHits();
    void updateStatus();
    void showQuickTips();
    QCheckBox* cb_beagleStart;

    void displayResults(BeagleSearch::BeagleResultList &items);
    bool mimeTypeMatch( const QString& mimeType, const QStringList& mimeList ) const;
    bool canPreview( KFileItem* item );
    void updatePreviewMimeTypes();
    QStringList* pPreviewMimeTypes;
    KIO::PreviewJob *pPreviewJob;
    void startPreview( const KFileItemList& items );
    void stopPreview();
    KFileItemList previewItems;

    QString takeProperty( const QString& property, QStringList& propertyList);
    QDateTime datetimeFromString( const QString& );
};

#endif
