#!/usr/bin/python3
# This file gets amended at build time by `reconf.sh` with data generated by
# `buildtools/build-langtags.py`.
# The data comes from `resources/standards-data/langtag/langtags.json`.

class LangTagsMap():
    def lookupLangTags(language):
        if language in LangTagsMap.__langTags:
            return LangTagsMap.__langTags[language]
        return None

    def lookupAllTags(language):
        if language in LangTagsMap.__allTags:
            return LangTagsMap.__allTags[language]
        return None

    def translateISO6393ToBCP47(code):
        if code in LangTagsMap.__map3To2:
            return LangTagsMap.__map3To2[code]
        return code

    __langTags = {
        'aa': {'full': 'aa-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'aa-Arab': {'full': 'aa-Arab-ET', 'region': 'ET', 'script': 'Arab', 'suppress': False},
        'aa-DJ': {'full': 'aa-Latn-DJ', 'region': 'DJ', 'script': 'Latn', 'suppress': False},
        'aa-ER': {'full': 'aa-Latn-ER', 'region': 'ER', 'script': 'Latn', 'suppress': False},
        'aa-Ethi': {'full': 'aa-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'aaa': {'full': 'aaa-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'aab': {'full': 'aab-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'aac': {'full': 'aac-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aad': {'full': 'aad-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aae': {'full': 'aae-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'aae-Grek': {'full': 'aae-Grek-IT', 'region': 'IT', 'script': 'Grek', 'suppress': False},
        'aaf': {'full': 'aaf-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'aag': {'full': 'aag-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aah': {'full': 'aah-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aai': {'full': 'aai-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aak': {'full': 'aak-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aal': {'full': 'aal-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'aan': {'full': 'aan-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'aao': {'full': 'aao-Arab-DZ', 'region': 'DZ', 'script': 'Arab', 'suppress': False},
        'aap': {'full': 'aap-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'aaq': {'full': 'aaq-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'aas': {'full': 'aas-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'aat': {'full': 'aat-Grek-GR', 'region': 'GR', 'script': 'Grek', 'suppress': False},
        'aau': {'full': 'aau-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aaw': {'full': 'aaw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aax': {'full': 'aax-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'aaz': {'full': 'aaz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ab': {'full': 'ab-Cyrl-GE', 'region': 'GE', 'script': 'Cyrl', 'suppress': True},
        'ab-Geor': {'full': 'ab-Geor-GE', 'region': 'GE', 'script': 'Geor', 'suppress': False},
        'aba': {'full': 'aba-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'abb': {'full': 'abb-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'abc': {'full': 'abc-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'abd': {'full': 'abd-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'abe': {'full': 'abe-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'abf': {'full': 'abf-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'abg': {'full': 'abg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'abh': {'full': 'abh-Arab-TJ', 'region': 'TJ', 'script': 'Arab', 'suppress': False},
        'abi': {'full': 'abi-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'abj': {'full': 'abj-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'abl': {'full': 'abl-Rjng-ID', 'region': 'ID', 'script': 'Rjng', 'suppress': False},
        'abm': {'full': 'abm-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'abn': {'full': 'abn-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'abo': {'full': 'abo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'abp': {'full': 'abp-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'abq-Cyrl': {'full': 'abq-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'abq-Latn': {'full': 'abq-Latn-TR', 'region': 'TR', 'script': 'Latn', 'suppress': False},
        'abr': {'full': 'abr-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'abs': {'full': 'abs-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'abt': {'full': 'abt-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'abt-x-maprik': {'full': 'abt-Latn-PG-x-maprik', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'abt-x-woserak': {'full': 'abt-Latn-PG-x-woserak', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'abu': {'full': 'abu-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'abv': {'full': 'abv-Arab-BH', 'region': 'BH', 'script': 'Arab', 'suppress': False},
        'abw': {'full': 'abw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'abx': {'full': 'abx-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'aby': {'full': 'aby-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'abz': {'full': 'abz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'aca': {'full': 'aca-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'acb': {'full': 'acb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'acd': {'full': 'acd-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'ace': {'full': 'ace-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ace-Arab': {'full': 'ace-Arab-ID', 'region': 'ID', 'script': 'Arab', 'suppress': False},
        'acf': {'full': 'acf-Latn-LC', 'region': 'LC', 'script': 'Latn', 'suppress': False},
        'ach': {'full': 'ach-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'aci': {'full': 'aci-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'ack': {'full': 'ack-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'acl': {'full': 'acl-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'acm': {'full': 'acm-Arab-IQ', 'region': 'IQ', 'script': 'Arab', 'suppress': False},
        'acn': {'full': 'acn-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'acp': {'full': 'acp-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'acq': {'full': 'acq-Arab-YE', 'region': 'YE', 'script': 'Arab', 'suppress': False},
        'acr': {'full': 'acr-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'acr-x-cubulco': {'full': 'acr-Latn-GT-x-cubulco', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'acr-x-rabinal': {'full': 'acr-Latn-GT-x-rabinal', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'acs': {'full': 'acs-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'act': {'full': 'act-Latn-NL', 'region': 'NL', 'script': 'Latn', 'suppress': False},
        'acu': {'full': 'acu-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'acv': {'full': 'acv-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'acw': {'full': 'acw-Arab-SA', 'region': 'SA', 'script': 'Arab', 'suppress': False},
        'acx': {'full': 'acx-Arab-OM', 'region': 'OM', 'script': 'Arab', 'suppress': False},
        'acy': {'full': 'acy-Latn-CY', 'region': 'CY', 'script': 'Latn', 'suppress': False},
        'acy-Arab': {'full': 'acy-Arab-CY', 'region': 'CY', 'script': 'Arab', 'suppress': False},
        'acy-Grek': {'full': 'acy-Grek-CY', 'region': 'CY', 'script': 'Grek', 'suppress': False},
        'acz': {'full': 'acz-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'ada': {'full': 'ada-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'adb': {'full': 'adb-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'add': {'full': 'add-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'ade': {'full': 'ade-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'adf': {'full': 'adf-Arab-OM', 'region': 'OM', 'script': 'Arab', 'suppress': False},
        'adg': {'full': 'adg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'adh': {'full': 'adh-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'adi': {'full': 'adi-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'adi-Tibt': {'full': 'adi-Tibt-CN', 'region': 'CN', 'script': 'Tibt', 'suppress': False},
        'adj': {'full': 'adj-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'adl': {'full': 'adl-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'adn': {'full': 'adn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ado': {'full': 'ado-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'adq': {'full': 'adq-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'adr': {'full': 'adr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ads': {'full': 'ads-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'ads-Zxxx': {'full': 'ads-Zxxx-GH', 'region': 'GH', 'script': 'Zxxx', 'suppress': False},
        'adt': {'full': 'adt-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'adu': {'full': 'adu-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'adw': {'full': 'adw-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'adx': {'full': 'adx-Tibt-CN', 'region': 'CN', 'script': 'Tibt', 'suppress': False},
        'ady': {'full': 'ady-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'ady-Arab': {'full': 'ady-Arab-RU', 'region': 'RU', 'script': 'Arab', 'suppress': False},
        'ady-Latn': {'full': 'ady-Latn-TR', 'region': 'TR', 'script': 'Latn', 'suppress': False},
        'adz': {'full': 'adz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ae': {'full': 'ae-Avst-IR', 'region': 'IR', 'script': 'Avst', 'suppress': False},
        'ae-Arab': {'full': 'ae-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'ae-Gujr': {'full': 'ae-Gujr-IR', 'region': 'IR', 'script': 'Gujr', 'suppress': False},
        'aea': {'full': 'aea-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'aeb': {'full': 'aeb-Arab-TN', 'region': 'TN', 'script': 'Arab', 'suppress': False},
        'aeb-Latn': {'full': 'aeb-Latn-TN', 'region': 'TN', 'script': 'Latn', 'suppress': False},
        'aec': {'full': 'aec-Arab-EG', 'region': 'EG', 'script': 'Arab', 'suppress': False},
        'aed': {'full': 'aed-Zxxx-AR', 'region': 'AR', 'script': 'Zxxx', 'suppress': False},
        'aee': {'full': 'aee-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'aek': {'full': 'aek-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'ael': {'full': 'ael-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'aem': {'full': 'aem-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'aen': {'full': 'aen-Zxxx-AM', 'region': 'AM', 'script': 'Zxxx', 'suppress': False},
        'aeq': {'full': 'aeq-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'aer': {'full': 'aer-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'aes': {'full': 'aes-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'aeu': {'full': 'aeu-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'aew': {'full': 'aew-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aey': {'full': 'aey-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aez': {'full': 'aez-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'af': {'full': 'af-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': True},
        'af-Arab': {'full': 'af-Arab-ZA', 'region': 'ZA', 'script': 'Arab', 'suppress': False},
        'af-Brai': {'full': 'af-Brai-ZA', 'region': 'ZA', 'script': 'Brai', 'suppress': False},
        'af-NA': {'full': 'af-Latn-NA', 'region': 'NA', 'script': 'Latn', 'suppress': True},
        'afb': {'full': 'afb-Arab-KW', 'region': 'KW', 'script': 'Arab', 'suppress': False},
        'afd': {'full': 'afd-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'afe': {'full': 'afe-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'afg': {'full': 'afg-Zxxx-AF', 'region': 'AF', 'script': 'Zxxx', 'suppress': False},
        'afh': {'full': 'afh-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'afi': {'full': 'afi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'afk': {'full': 'afk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'afn': {'full': 'afn-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'afo': {'full': 'afo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'afp': {'full': 'afp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'afs': {'full': 'afs-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'aft': {'full': 'aft-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'afu': {'full': 'afu-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'afz': {'full': 'afz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'aga': {'full': 'aga-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'agb': {'full': 'agb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'agc': {'full': 'agc-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'agd': {'full': 'agd-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'age': {'full': 'age-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'agf': {'full': 'agf-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'agg': {'full': 'agg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'agh': {'full': 'agh-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'agi': {'full': 'agi-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'agj': {'full': 'agj-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'agj-Arab': {'full': 'agj-Arab-ET', 'region': 'ET', 'script': 'Arab', 'suppress': False},
        'agk': {'full': 'agk-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'agl': {'full': 'agl-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'agm': {'full': 'agm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'agn': {'full': 'agn-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ago': {'full': 'ago-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'agq': {'full': 'agq-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'agr': {'full': 'agr-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'ags': {'full': 'ags-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'agt': {'full': 'agt-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'agu': {'full': 'agu-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'agv': {'full': 'agv-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'agw': {'full': 'agw-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'agx': {'full': 'agx-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'agy': {'full': 'agy-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'agz': {'full': 'agz-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'aha': {'full': 'aha-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'ahb': {'full': 'ahb-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'ahg': {'full': 'ahg-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'ahh': {'full': 'ahh-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ahi': {'full': 'ahi-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'ahk': {'full': 'ahk-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'ahk-Latn-x-louma': {'full': 'ahk-Latn-LA-x-louma', 'region': 'LA', 'script': 'Latn', 'suppress': False},
        'ahk-Mymr': {'full': 'ahk-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'ahk-TH': {'full': 'ahk-Latn-TH', 'region': 'TH', 'script': 'Latn', 'suppress': False},
        'ahk-Thai': {'full': 'ahk-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'ahl': {'full': 'ahl-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'ahm': {'full': 'ahm-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'ahn': {'full': 'ahn-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'aho': {'full': 'aho-Ahom-IN', 'region': 'IN', 'script': 'Ahom', 'suppress': False},
        'ahp': {'full': 'ahp-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'ahr': {'full': 'ahr-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'ahs': {'full': 'ahs-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'aht': {'full': 'aht-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'aia': {'full': 'aia-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'aib': {'full': 'aib-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'aic': {'full': 'aic-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aid': {'full': 'aid-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'aie': {'full': 'aie-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aif': {'full': 'aif-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aig': {'full': 'aig-Latn-AG', 'region': 'AG', 'script': 'Latn', 'suppress': False},
        'aih': {'full': 'aih-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'aii-Cyrl': {'full': 'aii-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'aii-Syrc': {'full': 'aii-Syrc-IQ', 'region': 'IQ', 'script': 'Syrc', 'suppress': False},
        'aij': {'full': 'aij-Hebr-IL', 'region': 'IL', 'script': 'Hebr', 'suppress': False},
        'aik': {'full': 'aik-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ail': {'full': 'ail-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aim': {'full': 'aim-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'ain': {'full': 'ain-Kana-JP', 'region': 'JP', 'script': 'Kana', 'suppress': False},
        'ain-Latn': {'full': 'ain-Latn-JP', 'region': 'JP', 'script': 'Latn', 'suppress': False},
        'aio': {'full': 'aio-Mymr-IN', 'region': 'IN', 'script': 'Mymr', 'suppress': False},
        'aip': {'full': 'aip-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'aiq': {'full': 'aiq-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'air': {'full': 'air-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ait': {'full': 'ait-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'aiw-Arab': {'full': 'aiw-Arab-ET', 'region': 'ET', 'script': 'Arab', 'suppress': False},
        'aiw-Ethi': {'full': 'aiw-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'aiw-Latn': {'full': 'aiw-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'aix': {'full': 'aix-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aiy': {'full': 'aiy-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'aja': {'full': 'aja-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'ajg': {'full': 'ajg-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'aji': {'full': 'aji-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'ajn': {'full': 'ajn-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ajp': {'full': 'ajp-Arab-JO', 'region': 'JO', 'script': 'Arab', 'suppress': False},
        'ajt': {'full': 'ajt-Arab-TN', 'region': 'TN', 'script': 'Arab', 'suppress': False},
        'ajt-Hebr': {'full': 'ajt-Hebr-IL', 'region': 'IL', 'script': 'Hebr', 'suppress': False},
        'aju-Arab': {'full': 'aju-Arab-MA', 'region': 'MA', 'script': 'Arab', 'suppress': False},
        'ajw': {'full': 'ajw-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ajz': {'full': 'ajz-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'ak': {'full': 'ak-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'ak-Arab': {'full': 'ak-Arab-GH', 'region': 'GH', 'script': 'Arab', 'suppress': False},
        'akb': {'full': 'akb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'akb-Batk': {'full': 'akb-Batk-ID', 'region': 'ID', 'script': 'Batk', 'suppress': False},
        'akc': {'full': 'akc-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'akd': {'full': 'akd-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ake': {'full': 'ake-Latn-GY', 'region': 'GY', 'script': 'Latn', 'suppress': False},
        'akf': {'full': 'akf-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'akg': {'full': 'akg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'akh': {'full': 'akh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aki': {'full': 'aki-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'akj': {'full': 'akj-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'akk': {'full': 'akk-Xsux-IQ', 'region': 'IQ', 'script': 'Xsux', 'suppress': False},
        'akl': {'full': 'akl-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'akm': {'full': 'akm-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'ako': {'full': 'ako-Latn-SR', 'region': 'SR', 'script': 'Latn', 'suppress': False},
        'akp': {'full': 'akp-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'akq': {'full': 'akq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'akr': {'full': 'akr-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'aks': {'full': 'aks-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'akt': {'full': 'akt-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aku': {'full': 'aku-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'akv': {'full': 'akv-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'akw': {'full': 'akw-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'akx': {'full': 'akx-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'aky': {'full': 'aky-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'akz': {'full': 'akz-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'ala': {'full': 'ala-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'alc': {'full': 'alc-Latn-CL', 'region': 'CL', 'script': 'Latn', 'suppress': False},
        'ald': {'full': 'ald-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'ale': {'full': 'ale-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'ale-Cyrs': {'full': 'ale-Cyrs-US', 'region': 'US', 'script': 'Cyrs', 'suppress': False},
        'alf': {'full': 'alf-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'alh': {'full': 'alh-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ali': {'full': 'ali-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'alj': {'full': 'alj-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'alk': {'full': 'alk-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'all': {'full': 'all-Mlym-IN', 'region': 'IN', 'script': 'Mlym', 'suppress': False},
        'alm': {'full': 'alm-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'aln': {'full': 'aln-Latn-XK', 'region': 'XK', 'script': 'Latn', 'suppress': False},
        'aln-Brai': {'full': 'aln-Brai-AL', 'region': 'AL', 'script': 'Brai', 'suppress': False},
        'alo': {'full': 'alo-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'alp': {'full': 'alp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'alq': {'full': 'alq-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'alr': {'full': 'alr-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'alt': {'full': 'alt-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'alt-Mong': {'full': 'alt-Mong-RU', 'region': 'RU', 'script': 'Mong', 'suppress': False},
        'alu': {'full': 'alu-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'alw': {'full': 'alw-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'alx': {'full': 'alx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aly': {'full': 'aly-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'alz': {'full': 'alz-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'am': {'full': 'am-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': True},
        'am-Arab': {'full': 'am-Arab-ET', 'region': 'ET', 'script': 'Arab', 'suppress': False},
        'am-Brai': {'full': 'am-Brai-ET', 'region': 'ET', 'script': 'Brai', 'suppress': False},
        'ama': {'full': 'ama-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'amb': {'full': 'amb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'amc': {'full': 'amc-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'ame': {'full': 'ame-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'amf-Ethi': {'full': 'amf-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'amf-Latn': {'full': 'amf-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'amg': {'full': 'amg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ami': {'full': 'ami-Latn-TW', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'ami-Zyyy-TW': {'full': 'ami-Zyyy-TW', 'region': 'TW', 'script': 'Zyyy', 'suppress': False},
        'amj': {'full': 'amj-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'amk': {'full': 'amk-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'aml': {'full': 'aml-Zyyy-BD', 'region': 'BD', 'script': 'Zyyy', 'suppress': False},
        'amm': {'full': 'amm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'amn': {'full': 'amn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'amo': {'full': 'amo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'amp': {'full': 'amp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'amq': {'full': 'amq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'amr': {'full': 'amr-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'ams': {'full': 'ams-Zyyy-JP', 'region': 'JP', 'script': 'Zyyy', 'suppress': False},
        'amt': {'full': 'amt-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'amu': {'full': 'amu-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'amv': {'full': 'amv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'amw-Arab': {'full': 'amw-Arab-SY', 'region': 'SY', 'script': 'Arab', 'suppress': False},
        'amw-Armi': {'full': 'amw-Armi-SY', 'region': 'SY', 'script': 'Armi', 'suppress': False},
        'amw-Latn': {'full': 'amw-Latn-SY', 'region': 'SY', 'script': 'Latn', 'suppress': False},
        'amw-Syrj': {'full': 'amw-Syrj-SY', 'region': 'SY', 'script': 'Syrj', 'suppress': False},
        'amx': {'full': 'amx-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'amy': {'full': 'amy-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'amz': {'full': 'amz-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'an': {'full': 'an-Latn-ES', 'region': 'ES', 'script': 'Latn', 'suppress': False},
        'ana': {'full': 'ana-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'anb': {'full': 'anb-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'anc': {'full': 'anc-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'and': {'full': 'and-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ane': {'full': 'ane-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'anf': {'full': 'anf-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'ang': {'full': 'ang-Latn-GB', 'region': 'GB', 'script': 'Latn', 'suppress': False},
        'anh': {'full': 'anh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ani': {'full': 'ani-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'anj': {'full': 'anj-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ank': {'full': 'ank-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'anl': {'full': 'anl-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'anm': {'full': 'anm-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'ann': {'full': 'ann-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ano': {'full': 'ano-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'anp': {'full': 'anp-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'anq': {'full': 'anq-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'anr': {'full': 'anr-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'ans': {'full': 'ans-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'ant': {'full': 'ant-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'anu': {'full': 'anu-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'anu-Arab': {'full': 'anu-Arab-SS', 'region': 'SS', 'script': 'Arab', 'suppress': False},
        'anu-Latn': {'full': 'anu-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'anv': {'full': 'anv-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'anw': {'full': 'anw-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'anx': {'full': 'anx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'any': {'full': 'any-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'anz': {'full': 'anz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aoa': {'full': 'aoa-Latn-ST', 'region': 'ST', 'script': 'Latn', 'suppress': False},
        'aob': {'full': 'aob-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aoc': {'full': 'aoc-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'aod': {'full': 'aod-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aoe': {'full': 'aoe-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aof': {'full': 'aof-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aog': {'full': 'aog-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aoh': {'full': 'aoh-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'aoi': {'full': 'aoi-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'aoj': {'full': 'aoj-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aoj-x-balif': {'full': 'aoj-Latn-PG-x-balif', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aoj-x-filifita': {'full': 'aoj-Latn-PG-x-filifita', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aok': {'full': 'aok-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'aol': {'full': 'aol-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'aom': {'full': 'aom-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aon': {'full': 'aon-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aor': {'full': 'aor-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'aos': {'full': 'aos-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'aot': {'full': 'aot-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'aou': {'full': 'aou-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'aox': {'full': 'aox-Latn-GY', 'region': 'GY', 'script': 'Latn', 'suppress': False},
        'aoz': {'full': 'aoz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'apb': {'full': 'apb-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'apc': {'full': 'apc-Arab-SY', 'region': 'SY', 'script': 'Arab', 'suppress': False},
        'apd': {'full': 'apd-Arab-TG', 'region': 'TG', 'script': 'Arab', 'suppress': False},
        'apd-Latn': {'full': 'apd-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'ape': {'full': 'ape-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ape-x-coastal': {'full': 'ape-Latn-PG-x-coastal', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ape-x-mountain': {'full': 'ape-Latn-PG-x-mountain', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'apf': {'full': 'apf-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'apg': {'full': 'apg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'aph': {'full': 'aph-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'api': {'full': 'api-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'apj': {'full': 'apj-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'apk': {'full': 'apk-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'apl': {'full': 'apl-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'apm': {'full': 'apm-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'apn': {'full': 'apn-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'apo': {'full': 'apo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'app': {'full': 'app-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'apq': {'full': 'apq-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'apr': {'full': 'apr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aps': {'full': 'aps-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'apt': {'full': 'apt-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'apu': {'full': 'apu-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'apv': {'full': 'apv-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'apw': {'full': 'apw-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'apx': {'full': 'apx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'apy': {'full': 'apy-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'apz': {'full': 'apz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aqc': {'full': 'aqc-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'aqd': {'full': 'aqd-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'aqg': {'full': 'aqg-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'aqm': {'full': 'aqm-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'aqn': {'full': 'aqn-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'aqp': {'full': 'aqp-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'aqr': {'full': 'aqr-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'aqt': {'full': 'aqt-Latn-PY', 'region': 'PY', 'script': 'Latn', 'suppress': False},
        'aqz': {'full': 'aqz-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'ar': {'full': 'ar-Arab-EG', 'region': 'EG', 'script': 'Arab', 'suppress': True},
        'ar-AE': {'full': 'ar-Arab-AE', 'region': 'AE', 'script': 'Arab', 'suppress': True},
        'ar-Brai': {'full': 'ar-Brai-SA', 'region': 'SA', 'script': 'Brai', 'suppress': False},
        'ar-DJ': {'full': 'ar-Arab-DJ', 'region': 'DJ', 'script': 'Arab', 'suppress': True},
        'ar-DZ': {'full': 'ar-Arab-DZ', 'region': 'DZ', 'script': 'Arab', 'suppress': True},
        'ar-EH': {'full': 'ar-Arab-EH', 'region': 'EH', 'script': 'Arab', 'suppress': True},
        'ar-ER': {'full': 'ar-Arab-ER', 'region': 'ER', 'script': 'Arab', 'suppress': True},
        'ar-IL': {'full': 'ar-Arab-IL', 'region': 'IL', 'script': 'Arab', 'suppress': True},
        'ar-IQ': {'full': 'ar-Arab-IQ', 'region': 'IQ', 'script': 'Arab', 'suppress': True},
        'ar-JO': {'full': 'ar-Arab-JO', 'region': 'JO', 'script': 'Arab', 'suppress': True},
        'ar-KM': {'full': 'ar-Arab-KM', 'region': 'KM', 'script': 'Arab', 'suppress': True},
        'ar-LB': {'full': 'ar-Arab-LB', 'region': 'LB', 'script': 'Arab', 'suppress': True},
        'ar-LY': {'full': 'ar-Arab-LY', 'region': 'LY', 'script': 'Arab', 'suppress': True},
        'ar-MA': {'full': 'ar-Arab-MA', 'region': 'MA', 'script': 'Arab', 'suppress': True},
        'ar-MR': {'full': 'ar-Arab-MR', 'region': 'MR', 'script': 'Arab', 'suppress': True},
        'ar-PS': {'full': 'ar-Arab-PS', 'region': 'PS', 'script': 'Arab', 'suppress': True},
        'ar-SA': {'full': 'ar-Arab-SA', 'region': 'SA', 'script': 'Arab', 'suppress': True},
        'ar-SO': {'full': 'ar-Arab-SO', 'region': 'SO', 'script': 'Arab', 'suppress': True},
        'ar-SS': {'full': 'ar-Arab-SS', 'region': 'SS', 'script': 'Arab', 'suppress': True},
        'ar-SY': {'full': 'ar-Arab-SY', 'region': 'SY', 'script': 'Arab', 'suppress': True},
        'ar-Syrc': {'full': 'ar-Syrc-SA', 'region': 'SA', 'script': 'Syrc', 'suppress': False},
        'ar-TN': {'full': 'ar-Arab-TN', 'region': 'TN', 'script': 'Arab', 'suppress': True},
        'arc': {'full': 'arc-Armi-IR', 'region': 'IR', 'script': 'Armi', 'suppress': False},
        'arc-Nbat': {'full': 'arc-Nbat-JO', 'region': 'JO', 'script': 'Nbat', 'suppress': False},
        'arc-Palm': {'full': 'arc-Palm-SY', 'region': 'SY', 'script': 'Palm', 'suppress': False},
        'arc-Syrc': {'full': 'arc-Syrc-XX', 'region': 'XX', 'script': 'Syrc', 'suppress': False},
        'ard': {'full': 'ard-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'are': {'full': 'are-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'arh': {'full': 'arh-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'ari': {'full': 'ari-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'arj': {'full': 'arj-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'ark': {'full': 'ark-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'arl': {'full': 'arl-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'arn': {'full': 'arn-Latn-CL', 'region': 'CL', 'script': 'Latn', 'suppress': False},
        'aro': {'full': 'aro-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'arp': {'full': 'arp-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'arq': {'full': 'arq-Arab-DZ', 'region': 'DZ', 'script': 'Arab', 'suppress': False},
        'arr': {'full': 'arr-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'ars': {'full': 'ars-Arab-SA', 'region': 'SA', 'script': 'Arab', 'suppress': False},
        'aru': {'full': 'aru-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'arv': {'full': 'arv-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'arw': {'full': 'arw-Latn-SR', 'region': 'SR', 'script': 'Latn', 'suppress': False},
        'arx': {'full': 'arx-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'ary': {'full': 'ary-Arab-MA', 'region': 'MA', 'script': 'Arab', 'suppress': False},
        'arz': {'full': 'arz-Arab-EG', 'region': 'EG', 'script': 'Arab', 'suppress': False},
        'arz-Brai': {'full': 'arz-Brai-EG', 'region': 'EG', 'script': 'Brai', 'suppress': False},
        'as': {'full': 'as-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': True},
        'asa': {'full': 'asa-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'asb': {'full': 'asb-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'asc': {'full': 'asc-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ase': {'full': 'ase-Sgnw-US', 'region': 'US', 'script': 'Sgnw', 'suppress': False},
        'ase-Zxxx': {'full': 'ase-Zxxx-US', 'region': 'US', 'script': 'Zxxx', 'suppress': False},
        'asf': {'full': 'asf-Zxxx-AU', 'region': 'AU', 'script': 'Zxxx', 'suppress': False},
        'asg': {'full': 'asg-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ash': {'full': 'ash-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'asi': {'full': 'asi-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'asj': {'full': 'asj-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'ask': {'full': 'ask-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'asl': {'full': 'asl-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'asn': {'full': 'asn-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'aso': {'full': 'aso-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'asp': {'full': 'asp-Zxxx-DZ', 'region': 'DZ', 'script': 'Zxxx', 'suppress': False},
        'asq': {'full': 'asq-Zxxx-AT', 'region': 'AT', 'script': 'Zxxx', 'suppress': False},
        'asr-Deva': {'full': 'asr-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'ass': {'full': 'ass-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'ast': {'full': 'ast-Latn-ES', 'region': 'ES', 'script': 'Latn', 'suppress': False},
        'asu': {'full': 'asu-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'asv': {'full': 'asv-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'asw': {'full': 'asw-Zxxx-AU', 'region': 'AU', 'script': 'Zxxx', 'suppress': False},
        'asx': {'full': 'asx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'asy': {'full': 'asy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'asz': {'full': 'asz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ata': {'full': 'ata-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'atb': {'full': 'atb-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'atb-Lisu': {'full': 'atb-Lisu-CN', 'region': 'CN', 'script': 'Lisu', 'suppress': False},
        'atc': {'full': 'atc-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'atd': {'full': 'atd-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ate': {'full': 'ate-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'atg': {'full': 'atg-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ati': {'full': 'ati-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'atj': {'full': 'atj-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'atk': {'full': 'atk-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'atl': {'full': 'atl-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'atm': {'full': 'atm-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'atn': {'full': 'atn-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'ato': {'full': 'ato-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'atp': {'full': 'atp-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'atq': {'full': 'atq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'atr': {'full': 'atr-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'ats': {'full': 'ats-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'att': {'full': 'att-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'atu': {'full': 'atu-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'atv': {'full': 'atv-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'atw': {'full': 'atw-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'atx': {'full': 'atx-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'aty': {'full': 'aty-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'atz': {'full': 'atz-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'aua': {'full': 'aua-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'aub': {'full': 'aub-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'auc': {'full': 'auc-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'aud': {'full': 'aud-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'aug': {'full': 'aug-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'auh': {'full': 'auh-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'aui': {'full': 'aui-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'auj': {'full': 'auj-Zyyy-LY', 'region': 'LY', 'script': 'Zyyy', 'suppress': False},
        'auk': {'full': 'auk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aul': {'full': 'aul-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'aum': {'full': 'aum-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'aun': {'full': 'aun-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'auo': {'full': 'auo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'aup': {'full': 'aup-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'auq': {'full': 'auq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'aur': {'full': 'aur-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'aut': {'full': 'aut-Latn-PF', 'region': 'PF', 'script': 'Latn', 'suppress': False},
        'auu': {'full': 'auu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'auw': {'full': 'auw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'aux': {'full': 'aux-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'auy': {'full': 'auy-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'auz': {'full': 'auz-Arab-UZ', 'region': 'UZ', 'script': 'Arab', 'suppress': False},
        'av': {'full': 'av-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'avb': {'full': 'avb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'avd': {'full': 'avd-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'avi': {'full': 'avi-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'avk': {'full': 'avk-Latn-001', 'region': '001', 'script': 'Latn', 'suppress': False},
        'avl': {'full': 'avl-Arab-EG', 'region': 'EG', 'script': 'Arab', 'suppress': False},
        'avm': {'full': 'avm-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'avn': {'full': 'avn-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'avo': {'full': 'avo-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'avs': {'full': 'avs-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'avt': {'full': 'avt-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'avu': {'full': 'avu-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'avu-SD': {'full': 'avu-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'avv': {'full': 'avv-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'awa': {'full': 'awa-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'awb': {'full': 'awb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'awc': {'full': 'awc-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'awe': {'full': 'awe-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'awg': {'full': 'awg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'awh': {'full': 'awh-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'awi': {'full': 'awi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'awk': {'full': 'awk-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'awm': {'full': 'awm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'awn': {'full': 'awn-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'awo': {'full': 'awo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'awr': {'full': 'awr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'aws': {'full': 'aws-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'awt': {'full': 'awt-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'awu': {'full': 'awu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'awv': {'full': 'awv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'aww': {'full': 'aww-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'awx': {'full': 'awx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'awy': {'full': 'awy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'axb': {'full': 'axb-Latn-AR', 'region': 'AR', 'script': 'Latn', 'suppress': False},
        'axe': {'full': 'axe-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'axg': {'full': 'axg-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'axk': {'full': 'axk-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'axl': {'full': 'axl-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'axm': {'full': 'axm-Zyyy-AM', 'region': 'AM', 'script': 'Zyyy', 'suppress': False},
        'axx': {'full': 'axx-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'ay': {'full': 'ay-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': True},
        'aya': {'full': 'aya-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ayb': {'full': 'ayb-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'ayc': {'full': 'ayc-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'ayd': {'full': 'ayd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'aye': {'full': 'aye-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ayg': {'full': 'ayg-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'ayh': {'full': 'ayh-Arab-YE', 'region': 'YE', 'script': 'Arab', 'suppress': False},
        'ayi': {'full': 'ayi-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ayk': {'full': 'ayk-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ayl': {'full': 'ayl-Arab-LY', 'region': 'LY', 'script': 'Arab', 'suppress': False},
        'ayn': {'full': 'ayn-Arab-YE', 'region': 'YE', 'script': 'Arab', 'suppress': False},
        'ayo': {'full': 'ayo-Latn-PY', 'region': 'PY', 'script': 'Latn', 'suppress': False},
        'ayp': {'full': 'ayp-Arab-IQ', 'region': 'IQ', 'script': 'Arab', 'suppress': False},
        'ayq': {'full': 'ayq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ays': {'full': 'ays-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ayt': {'full': 'ayt-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ayu': {'full': 'ayu-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ayy': {'full': 'ayy-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ayz': {'full': 'ayz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'az': {'full': 'az-Latn-AZ', 'region': 'AZ', 'script': 'Latn', 'suppress': False},
        'az-Brai': {'full': 'az-Brai-IR', 'region': 'IR', 'script': 'Brai', 'suppress': False},
        'az-Cyrl-AZ': {'full': 'az-Cyrl-AZ', 'region': 'AZ', 'script': 'Cyrl', 'suppress': False},
        'az-IQ': {'full': 'az-Arab-IQ', 'region': 'IQ', 'script': 'Arab', 'suppress': False},
        'az-IR': {'full': 'az-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'az-RU': {'full': 'az-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'aza': {'full': 'aza-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'azb': {'full': 'azb-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'azb-Cyrl': {'full': 'azb-Cyrl-AZ', 'region': 'AZ', 'script': 'Cyrl', 'suppress': False},
        'azd': {'full': 'azd-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'azg': {'full': 'azg-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'azm': {'full': 'azm-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'azn': {'full': 'azn-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'azo': {'full': 'azo-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'azt': {'full': 'azt-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'azz': {'full': 'azz-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ba': {'full': 'ba-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'baa': {'full': 'baa-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'bab': {'full': 'bab-Latn-GW', 'region': 'GW', 'script': 'Latn', 'suppress': False},
        'bac': {'full': 'bac-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bae': {'full': 'bae-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'baf': {'full': 'baf-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bag': {'full': 'bag-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bah': {'full': 'bah-Latn-BS', 'region': 'BS', 'script': 'Latn', 'suppress': False},
        'baj': {'full': 'baj-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bal': {'full': 'bal-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'bal-Latn': {'full': 'bal-Latn-PK', 'region': 'PK', 'script': 'Latn', 'suppress': False},
        'ban': {'full': 'ban-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ban-Bali': {'full': 'ban-Bali-ID', 'region': 'ID', 'script': 'Bali', 'suppress': False},
        'ban-Java': {'full': 'ban-Java-ID', 'region': 'ID', 'script': 'Java', 'suppress': False},
        'bao': {'full': 'bao-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'bap': {'full': 'bap-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'bar': {'full': 'bar-Latn-AT', 'region': 'AT', 'script': 'Latn', 'suppress': False},
        'bas': {'full': 'bas-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bau': {'full': 'bau-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bav': {'full': 'bav-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'baw': {'full': 'baw-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bax': {'full': 'bax-Bamu-CM', 'region': 'CM', 'script': 'Bamu', 'suppress': False},
        'bax-Latn': {'full': 'bax-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bay': {'full': 'bay-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bba': {'full': 'bba-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'bbb': {'full': 'bbb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bbc': {'full': 'bbc-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bbc-Batk': {'full': 'bbc-Batk-ID', 'region': 'ID', 'script': 'Batk', 'suppress': False},
        'bbd': {'full': 'bbd-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bbe': {'full': 'bbe-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bbf': {'full': 'bbf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bbg': {'full': 'bbg-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'bbh': {'full': 'bbh-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'bbi': {'full': 'bbi-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bbj': {'full': 'bbj-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bbk': {'full': 'bbk-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bbl': {'full': 'bbl-Zyyy-GE', 'region': 'GE', 'script': 'Zyyy', 'suppress': False},
        'bbm': {'full': 'bbm-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bbn': {'full': 'bbn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bbo': {'full': 'bbo-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'bbp': {'full': 'bbp-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'bbq': {'full': 'bbq-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bbr': {'full': 'bbr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bbs': {'full': 'bbs-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bbt': {'full': 'bbt-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bbu': {'full': 'bbu-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bbv': {'full': 'bbv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bbw': {'full': 'bbw-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bbx': {'full': 'bbx-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bby': {'full': 'bby-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bbz': {'full': 'bbz-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'bca': {'full': 'bca-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'bca-Hani': {'full': 'bca-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'bcb': {'full': 'bcb-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'bcd': {'full': 'bcd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bce': {'full': 'bce-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bcf': {'full': 'bcf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bcg': {'full': 'bcg-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'bch': {'full': 'bch-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bci': {'full': 'bci-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'bcj': {'full': 'bcj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'bck': {'full': 'bck-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'bcm': {'full': 'bcm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bcn': {'full': 'bcn-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bco': {'full': 'bco-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bcp': {'full': 'bcp-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bcq': {'full': 'bcq-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'bcq-Latn': {'full': 'bcq-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'bcr': {'full': 'bcr-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'bcs': {'full': 'bcs-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bct': {'full': 'bct-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bcu': {'full': 'bcu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bcv': {'full': 'bcv-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bcw': {'full': 'bcw-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bcy': {'full': 'bcy-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bcz': {'full': 'bcz-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'bda': {'full': 'bda-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'bdb': {'full': 'bdb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bdc': {'full': 'bdc-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'bdd': {'full': 'bdd-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bde': {'full': 'bde-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bdf': {'full': 'bdf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bdg': {'full': 'bdg-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'bdh': {'full': 'bdh-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'bdi': {'full': 'bdi-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'bdj': {'full': 'bdj-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'bdk': {'full': 'bdk-Latn-AZ', 'region': 'AZ', 'script': 'Latn', 'suppress': False},
        'bdl': {'full': 'bdl-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bdm': {'full': 'bdm-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'bdn': {'full': 'bdn-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bdo': {'full': 'bdo-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'bdp': {'full': 'bdp-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'bdq': {'full': 'bdq-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'bdr': {'full': 'bdr-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'bds': {'full': 'bds-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'bdt': {'full': 'bdt-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'bdu': {'full': 'bdu-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bdv': {'full': 'bdv-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'bdw': {'full': 'bdw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bdx': {'full': 'bdx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bdy': {'full': 'bdy-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'bdz': {'full': 'bdz-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'be': {'full': 'be-Cyrl-BY', 'region': 'BY', 'script': 'Cyrl', 'suppress': True},
        'be-Brai': {'full': 'be-Brai-BY', 'region': 'BY', 'script': 'Brai', 'suppress': False},
        'be-Latn': {'full': 'be-Latn-BY', 'region': 'BY', 'script': 'Latn', 'suppress': False},
        'bea': {'full': 'bea-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'bea-Cans': {'full': 'bea-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'beb': {'full': 'beb-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bec': {'full': 'bec-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bed': {'full': 'bed-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bee': {'full': 'bee-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'bef': {'full': 'bef-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'beg': {'full': 'beg-Zyyy-BN', 'region': 'BN', 'script': 'Zyyy', 'suppress': False},
        'beh': {'full': 'beh-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'bei': {'full': 'bei-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bej': {'full': 'bej-Arab-SD', 'region': 'SD', 'script': 'Arab', 'suppress': False},
        'bej-Latn': {'full': 'bej-Latn-ER', 'region': 'ER', 'script': 'Latn', 'suppress': False},
        'bek': {'full': 'bek-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bem': {'full': 'bem-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'bem-Brai': {'full': 'bem-Brai-ZM', 'region': 'ZM', 'script': 'Brai', 'suppress': False},
        'beo': {'full': 'beo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bep': {'full': 'bep-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'beq': {'full': 'beq-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'bes': {'full': 'bes-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'bet': {'full': 'bet-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'beu': {'full': 'beu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bev': {'full': 'bev-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'bew': {'full': 'bew-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bex': {'full': 'bex-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'bex-Arab': {'full': 'bex-Arab-SS', 'region': 'SS', 'script': 'Arab', 'suppress': False},
        'bey': {'full': 'bey-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bez': {'full': 'bez-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'bfa': {'full': 'bfa-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'bfa-Arab': {'full': 'bfa-Arab-SS', 'region': 'SS', 'script': 'Arab', 'suppress': False},
        'bfb': {'full': 'bfb-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'bfc': {'full': 'bfc-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'bfd': {'full': 'bfd-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bfe': {'full': 'bfe-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bff': {'full': 'bff-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'bfg': {'full': 'bfg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bfh': {'full': 'bfh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bfi': {'full': 'bfi-Zxxx-GB', 'region': 'GB', 'script': 'Zxxx', 'suppress': False},
        'bfi-x-stokoe': {'full': 'bfi-Zzzz-GB-x-stokoe', 'region': 'GB', 'script': 'Zzzz', 'suppress': False},
        'bfj': {'full': 'bfj-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bfk': {'full': 'bfk-Zxxx-TH', 'region': 'TH', 'script': 'Zxxx', 'suppress': False},
        'bfl': {'full': 'bfl-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'bfm': {'full': 'bfm-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bfn': {'full': 'bfn-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'bfo': {'full': 'bfo-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'bfp': {'full': 'bfp-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bfq': {'full': 'bfq-Taml-IN', 'region': 'IN', 'script': 'Taml', 'suppress': False},
        'bfq-Knda': {'full': 'bfq-Knda-IN', 'region': 'IN', 'script': 'Knda', 'suppress': False},
        'bfq-Latn': {'full': 'bfq-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'bfq-x-badaga': {'full': 'bfq-Zzzz-IN-x-badaga', 'region': 'IN', 'script': 'Zzzz', 'suppress': False},
        'bfr': {'full': 'bfr-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'bfs': {'full': 'bfs-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'bfs-Hani': {'full': 'bfs-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'bft': {'full': 'bft-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'bft-Tibt': {'full': 'bft-Tibt-PK', 'region': 'PK', 'script': 'Tibt', 'suppress': False},
        'bft-x-baltia': {'full': 'bft-Zzzz-PK-x-baltia', 'region': 'PK', 'script': 'Zzzz', 'suppress': False},
        'bfu': {'full': 'bfu-Tibt-IN', 'region': 'IN', 'script': 'Tibt', 'suppress': False},
        'bfu-Takr': {'full': 'bfu-Takr-IN', 'region': 'IN', 'script': 'Takr', 'suppress': False},
        'bfw': {'full': 'bfw-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'bfx': {'full': 'bfx-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'bfy': {'full': 'bfy-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'bfz': {'full': 'bfz-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'bg': {'full': 'bg-Cyrl-BG', 'region': 'BG', 'script': 'Cyrl', 'suppress': True},
        'bg-Brai': {'full': 'bg-Brai-BG', 'region': 'BG', 'script': 'Brai', 'suppress': False},
        'bg-Latn': {'full': 'bg-Latn-BG', 'region': 'BG', 'script': 'Latn', 'suppress': False},
        'bga': {'full': 'bga-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bgb': {'full': 'bgb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bgc': {'full': 'bgc-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'bgd': {'full': 'bgd-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'bge': {'full': 'bge-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'bgf': {'full': 'bgf-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bgg': {'full': 'bgg-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'bgi': {'full': 'bgi-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'bgj': {'full': 'bgj-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bgk': {'full': 'bgk-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'bgl': {'full': 'bgl-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'bgn': {'full': 'bgn-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'bgn-Cyrl': {'full': 'bgn-Cyrl-TM', 'region': 'TM', 'script': 'Cyrl', 'suppress': False},
        'bgo': {'full': 'bgo-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'bgp': {'full': 'bgp-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'bgq': {'full': 'bgq-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'bgr': {'full': 'bgr-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'bgs': {'full': 'bgs-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'bgt': {'full': 'bgt-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'bgu': {'full': 'bgu-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bgv': {'full': 'bgv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bgw': {'full': 'bgw-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'bgx': {'full': 'bgx-Grek-TR', 'region': 'TR', 'script': 'Grek', 'suppress': False},
        'bgx-Latn': {'full': 'bgx-Latn-TR', 'region': 'TR', 'script': 'Latn', 'suppress': False},
        'bgy': {'full': 'bgy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bgz': {'full': 'bgz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bha': {'full': 'bha-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'bhb': {'full': 'bhb-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'bhb-Gujr': {'full': 'bhb-Gujr-IN', 'region': 'IN', 'script': 'Gujr', 'suppress': False},
        'bhc': {'full': 'bhc-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bhd-Arab': {'full': 'bhd-Arab-IN', 'region': 'IN', 'script': 'Arab', 'suppress': False},
        'bhd-Deva': {'full': 'bhd-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'bhe': {'full': 'bhe-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'bhf': {'full': 'bhf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bhg': {'full': 'bhg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bhh': {'full': 'bhh-Cyrl-IL', 'region': 'IL', 'script': 'Cyrl', 'suppress': False},
        'bhh-Hebr': {'full': 'bhh-Hebr-IL', 'region': 'IL', 'script': 'Hebr', 'suppress': False},
        'bhh-Latn': {'full': 'bhh-Latn-IL', 'region': 'IL', 'script': 'Latn', 'suppress': False},
        'bhi': {'full': 'bhi-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'bhj': {'full': 'bhj-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'bhl': {'full': 'bhl-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bhm': {'full': 'bhm-Arab-OM', 'region': 'OM', 'script': 'Arab', 'suppress': False},
        'bhn': {'full': 'bhn-Syrc-GE', 'region': 'GE', 'script': 'Syrc', 'suppress': False},
        'bho': {'full': 'bho-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'bho-Kthi': {'full': 'bho-Kthi-IN', 'region': 'IN', 'script': 'Kthi', 'suppress': False},
        'bhp': {'full': 'bhp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bhq': {'full': 'bhq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bhr': {'full': 'bhr-Latn-MG', 'region': 'MG', 'script': 'Latn', 'suppress': False},
        'bhs': {'full': 'bhs-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bht': {'full': 'bht-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'bhu': {'full': 'bhu-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'bhv': {'full': 'bhv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bhw': {'full': 'bhw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bhx': {'full': 'bhx-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'bhy': {'full': 'bhy-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bhz': {'full': 'bhz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bi': {'full': 'bi-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'bia': {'full': 'bia-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'bib': {'full': 'bib-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'bic': {'full': 'bic-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bid': {'full': 'bid-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'bie': {'full': 'bie-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bif': {'full': 'bif-Latn-GW', 'region': 'GW', 'script': 'Latn', 'suppress': False},
        'big': {'full': 'big-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bij': {'full': 'bij-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bik': {'full': 'bik-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'bik-Brai': {'full': 'bik-Brai-PH', 'region': 'PH', 'script': 'Brai', 'suppress': False},
        'bil': {'full': 'bil-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bim': {'full': 'bim-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'bin': {'full': 'bin-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bio': {'full': 'bio-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bip': {'full': 'bip-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'biq': {'full': 'biq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bir': {'full': 'bir-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bit': {'full': 'bit-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'biu': {'full': 'biu-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'biv': {'full': 'biv-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'biw': {'full': 'biw-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bix': {'full': 'bix-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'biy': {'full': 'biy-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'biz': {'full': 'biz-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bja': {'full': 'bja-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bjb': {'full': 'bjb-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'bjc': {'full': 'bjc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bje': {'full': 'bje-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'bjf': {'full': 'bjf-Syrc-IL', 'region': 'IL', 'script': 'Syrc', 'suppress': False},
        'bjg': {'full': 'bjg-Latn-GW', 'region': 'GW', 'script': 'Latn', 'suppress': False},
        'bjh': {'full': 'bjh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bji': {'full': 'bji-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'bjj': {'full': 'bjj-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'bjk': {'full': 'bjk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bjl': {'full': 'bjl-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bjm': {'full': 'bjm-Zyyy-IQ', 'region': 'IQ', 'script': 'Zyyy', 'suppress': False},
        'bjn': {'full': 'bjn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bjn-Arab': {'full': 'bjn-Arab-ID', 'region': 'ID', 'script': 'Arab', 'suppress': False},
        'bjo': {'full': 'bjo-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'bjp': {'full': 'bjp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bjr': {'full': 'bjr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bjs': {'full': 'bjs-Latn-BB', 'region': 'BB', 'script': 'Latn', 'suppress': False},
        'bjt': {'full': 'bjt-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'bjt-Arab': {'full': 'bjt-Arab-SN', 'region': 'SN', 'script': 'Arab', 'suppress': False},
        'bju': {'full': 'bju-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bjv': {'full': 'bjv-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'bjw': {'full': 'bjw-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'bjx': {'full': 'bjx-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'bjy': {'full': 'bjy-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'bjz': {'full': 'bjz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bka': {'full': 'bka-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bkc': {'full': 'bkc-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bkd': {'full': 'bkd-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'bkf': {'full': 'bkf-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bkg': {'full': 'bkg-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'bkh': {'full': 'bkh-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bki': {'full': 'bki-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'bkj': {'full': 'bkj-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'bkk-x-baltia': {'full': 'bkk-Zzzz-IN-x-baltia', 'region': 'IN', 'script': 'Zzzz', 'suppress': False},
        'bkl': {'full': 'bkl-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bkm': {'full': 'bkm-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bkn': {'full': 'bkn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bko': {'full': 'bko-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bkp': {'full': 'bkp-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bkq': {'full': 'bkq-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'bkr': {'full': 'bkr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bks': {'full': 'bks-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'bkt': {'full': 'bkt-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bku': {'full': 'bku-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'bku-Buhd': {'full': 'bku-Buhd-PH', 'region': 'PH', 'script': 'Buhd', 'suppress': False},
        'bkv': {'full': 'bkv-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bkw': {'full': 'bkw-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'bkx': {'full': 'bkx-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'bky': {'full': 'bky-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bkz': {'full': 'bkz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bla': {'full': 'bla-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'bla-Cans': {'full': 'bla-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'blb': {'full': 'blb-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'blc': {'full': 'blc-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'bld': {'full': 'bld-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ble': {'full': 'ble-Latn-GW', 'region': 'GW', 'script': 'Latn', 'suppress': False},
        'blf': {'full': 'blf-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'blg': {'full': 'blg-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'blh': {'full': 'blh-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'bli': {'full': 'bli-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'blj': {'full': 'blj-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'blk': {'full': 'blk-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'bll': {'full': 'bll-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'blm': {'full': 'blm-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'bln': {'full': 'bln-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'blo': {'full': 'blo-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'blp': {'full': 'blp-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'blq': {'full': 'blq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'blr': {'full': 'blr-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'blr-Latn-x-pangpung': {'full': 'blr-Latn-MM-x-pangpung', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'blr-Tale': {'full': 'blr-Tale-CN', 'region': 'CN', 'script': 'Tale', 'suppress': False},
        'blr-Thai': {'full': 'blr-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'bls': {'full': 'bls-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'blt': {'full': 'blt-Tavt-VN', 'region': 'VN', 'script': 'Tavt', 'suppress': False},
        'blt-Laoo': {'full': 'blt-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'blt-Latn': {'full': 'blt-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'blv': {'full': 'blv-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'blw': {'full': 'blw-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'blx': {'full': 'blx-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'bly': {'full': 'bly-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'blz': {'full': 'blz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bm': {'full': 'bm-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'bm-Arab': {'full': 'bm-Arab-ML', 'region': 'ML', 'script': 'Arab', 'suppress': False},
        'bm-Nkoo': {'full': 'bm-Nkoo-ML', 'region': 'ML', 'script': 'Nkoo', 'suppress': False},
        'bma': {'full': 'bma-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bmb': {'full': 'bmb-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bmc': {'full': 'bmc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bmd': {'full': 'bmd-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'bme': {'full': 'bme-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'bmf': {'full': 'bmf-Latn-SL', 'region': 'SL', 'script': 'Latn', 'suppress': False},
        'bmg': {'full': 'bmg-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bmh': {'full': 'bmh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bmi': {'full': 'bmi-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'bmj': {'full': 'bmj-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'bmk': {'full': 'bmk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bml': {'full': 'bml-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bmm': {'full': 'bmm-Latn-MG', 'region': 'MG', 'script': 'Latn', 'suppress': False},
        'bmn': {'full': 'bmn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bmo': {'full': 'bmo-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bmp': {'full': 'bmp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bmq': {'full': 'bmq-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'bmr': {'full': 'bmr-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'bms': {'full': 'bms-Latn-NE', 'region': 'NE', 'script': 'Latn', 'suppress': False},
        'bmt': {'full': 'bmt-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'bmu': {'full': 'bmu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bmv': {'full': 'bmv-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bmw': {'full': 'bmw-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'bmx': {'full': 'bmx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bmz': {'full': 'bmz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bn': {'full': 'bn-Beng-BD', 'region': 'BD', 'script': 'Beng', 'suppress': True},
        'bn-Brai': {'full': 'bn-Brai-BD', 'region': 'BD', 'script': 'Brai', 'suppress': False},
        'bn-IN': {'full': 'bn-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': True},
        'bn-Newa': {'full': 'bn-Newa-NP', 'region': 'NP', 'script': 'Newa', 'suppress': False},
        'bna': {'full': 'bna-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bnb': {'full': 'bnb-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'bnc': {'full': 'bnc-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'bnd': {'full': 'bnd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bne': {'full': 'bne-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bnf': {'full': 'bnf-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bng': {'full': 'bng-Latn-GQ', 'region': 'GQ', 'script': 'Latn', 'suppress': False},
        'bni': {'full': 'bni-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bnj': {'full': 'bnj-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'bnk': {'full': 'bnk-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'bnl': {'full': 'bnl-Zyyy-SO', 'region': 'SO', 'script': 'Zyyy', 'suppress': False},
        'bnm': {'full': 'bnm-Latn-GQ', 'region': 'GQ', 'script': 'Latn', 'suppress': False},
        'bnn': {'full': 'bnn-Latn-TW', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'bno': {'full': 'bno-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'bnp': {'full': 'bnp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bnq': {'full': 'bnq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bnr': {'full': 'bnr-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'bns': {'full': 'bns-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'bnu': {'full': 'bnu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bnv': {'full': 'bnv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bnw': {'full': 'bnw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bnx': {'full': 'bnx-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bny': {'full': 'bny-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'bnz': {'full': 'bnz-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bo': {'full': 'bo-Tibt-CN', 'region': 'CN', 'script': 'Tibt', 'suppress': False},
        'bo-IN': {'full': 'bo-Tibt-IN', 'region': 'IN', 'script': 'Tibt', 'suppress': False},
        'bo-Latn': {'full': 'bo-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'bo-Marc': {'full': 'bo-Marc-CN', 'region': 'CN', 'script': 'Marc', 'suppress': False},
        'bo-Phag': {'full': 'bo-Phag-CN', 'region': 'CN', 'script': 'Phag', 'suppress': False},
        'boa': {'full': 'boa-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'bob': {'full': 'bob-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'boe': {'full': 'boe-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bof': {'full': 'bof-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'bog': {'full': 'bog-Zxxx-ML', 'region': 'ML', 'script': 'Zxxx', 'suppress': False},
        'boh': {'full': 'boh-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'boi': {'full': 'boi-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'boj': {'full': 'boj-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bok': {'full': 'bok-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'bol': {'full': 'bol-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bom': {'full': 'bom-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bon': {'full': 'bon-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'boo': {'full': 'boo-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'bop': {'full': 'bop-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'boq': {'full': 'boq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bor': {'full': 'bor-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'bot': {'full': 'bot-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'bou': {'full': 'bou-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'bov': {'full': 'bov-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'bow': {'full': 'bow-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'box': {'full': 'box-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'boy': {'full': 'boy-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'boz': {'full': 'boz-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'boz-Arab': {'full': 'boz-Arab-ML', 'region': 'ML', 'script': 'Arab', 'suppress': False},
        'bpa': {'full': 'bpa-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'bpb': {'full': 'bpb-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'bpd': {'full': 'bpd-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'bpg': {'full': 'bpg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bph': {'full': 'bph-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'bpi': {'full': 'bpi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bpj': {'full': 'bpj-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bpk': {'full': 'bpk-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'bpl': {'full': 'bpl-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'bpm': {'full': 'bpm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bpn': {'full': 'bpn-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'bpo': {'full': 'bpo-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bpp': {'full': 'bpp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bpq': {'full': 'bpq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bpr': {'full': 'bpr-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'bps': {'full': 'bps-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'bpt': {'full': 'bpt-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'bpu': {'full': 'bpu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bpv': {'full': 'bpv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bpw': {'full': 'bpw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bpx': {'full': 'bpx-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'bpy': {'full': 'bpy-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'bpz': {'full': 'bpz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bqa': {'full': 'bqa-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'bqb': {'full': 'bqb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bqc': {'full': 'bqc-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'bqd': {'full': 'bqd-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bqf': {'full': 'bqf-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'bqf-Arab': {'full': 'bqf-Arab-GN', 'region': 'GN', 'script': 'Arab', 'suppress': False},
        'bqg': {'full': 'bqg-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'bqh': {'full': 'bqh-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'bqi': {'full': 'bqi-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'bqj': {'full': 'bqj-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'bqk': {'full': 'bqk-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'bql': {'full': 'bql-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bqm': {'full': 'bqm-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bqn': {'full': 'bqn-Zxxx-BG', 'region': 'BG', 'script': 'Zxxx', 'suppress': False},
        'bqo': {'full': 'bqo-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bqp': {'full': 'bqp-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bqq': {'full': 'bqq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bqr': {'full': 'bqr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bqs': {'full': 'bqs-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bqt': {'full': 'bqt-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bqu': {'full': 'bqu-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bqv': {'full': 'bqv-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'bqw': {'full': 'bqw-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bqx': {'full': 'bqx-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bqy': {'full': 'bqy-Zxxx-ID', 'region': 'ID', 'script': 'Zxxx', 'suppress': False},
        'bqz': {'full': 'bqz-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'br': {'full': 'br-Latn-FR', 'region': 'FR', 'script': 'Latn', 'suppress': False},
        'bra': {'full': 'bra-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'brb': {'full': 'brb-Khmr-KH', 'region': 'KH', 'script': 'Khmr', 'suppress': False},
        'brb-Laoo': {'full': 'brb-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'brb-Latn': {'full': 'brb-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'brc': {'full': 'brc-Latn-GY', 'region': 'GY', 'script': 'Latn', 'suppress': False},
        'brd': {'full': 'brd-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'brf': {'full': 'brf-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'brg': {'full': 'brg-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'brh': {'full': 'brh-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'brh-Latn': {'full': 'brh-Latn-PK', 'region': 'PK', 'script': 'Latn', 'suppress': False},
        'bri': {'full': 'bri-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'brj': {'full': 'brj-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'brk': {'full': 'brk-Arab-SD', 'region': 'SD', 'script': 'Arab', 'suppress': False},
        'brl': {'full': 'brl-Latn-BW', 'region': 'BW', 'script': 'Latn', 'suppress': False},
        'brm': {'full': 'brm-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'brn': {'full': 'brn-Latn-CR', 'region': 'CR', 'script': 'Latn', 'suppress': False},
        'bro': {'full': 'bro-Zyyy-BT', 'region': 'BT', 'script': 'Zyyy', 'suppress': False},
        'brp': {'full': 'brp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'brq': {'full': 'brq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'brr': {'full': 'brr-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'brs': {'full': 'brs-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'brt': {'full': 'brt-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bru': {'full': 'bru-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'bru-Laoo': {'full': 'bru-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'bru-Thai': {'full': 'bru-Thai-LA', 'region': 'LA', 'script': 'Thai', 'suppress': False},
        'brv': {'full': 'brv-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'brv-Thai-x-donglng': {'full': 'brv-Thai-TH-x-donglng', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'brv-Thai-x-khongchm': {'full': 'brv-Thai-TH-x-khongchm', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'brv-Thai-x-sakonnkn': {'full': 'brv-Thai-TH-x-sakonnkn', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'brw': {'full': 'brw-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'brx': {'full': 'brx-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'brx-Beng': {'full': 'brx-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'brx-Latn': {'full': 'brx-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'bry': {'full': 'bry-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'brz': {'full': 'brz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bs': {'full': 'bs-Latn-BA', 'region': 'BA', 'script': 'Latn', 'suppress': True},
        'bs-Cyrl': {'full': 'bs-Cyrl-BA', 'region': 'BA', 'script': 'Cyrl', 'suppress': False},
        'bsa': {'full': 'bsa-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bsb': {'full': 'bsb-Latn-BN', 'region': 'BN', 'script': 'Latn', 'suppress': False},
        'bsc': {'full': 'bsc-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'bse': {'full': 'bse-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bsf': {'full': 'bsf-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bsg': {'full': 'bsg-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'bsh': {'full': 'bsh-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'bsi': {'full': 'bsi-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bsj': {'full': 'bsj-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bsk': {'full': 'bsk-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'bsk-Latn': {'full': 'bsk-Latn-PK', 'region': 'PK', 'script': 'Latn', 'suppress': False},
        'bsl': {'full': 'bsl-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bsm': {'full': 'bsm-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bsn': {'full': 'bsn-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'bso': {'full': 'bso-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'bsp': {'full': 'bsp-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'bsq': {'full': 'bsq-Bass-LR', 'region': 'LR', 'script': 'Bass', 'suppress': False},
        'bsq-Latn': {'full': 'bsq-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'bsr': {'full': 'bsr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bss': {'full': 'bss-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bst': {'full': 'bst-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'bst-Latn': {'full': 'bst-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'bsu': {'full': 'bsu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bsv': {'full': 'bsv-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'bsv-Arab': {'full': 'bsv-Arab-GN', 'region': 'GN', 'script': 'Arab', 'suppress': False},
        'bsw': {'full': 'bsw-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'bsx': {'full': 'bsx-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bsy': {'full': 'bsy-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'bta': {'full': 'bta-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'btb': {'full': 'btb-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'btc': {'full': 'btc-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'btd': {'full': 'btd-Batk-ID', 'region': 'ID', 'script': 'Batk', 'suppress': False},
        'bte': {'full': 'bte-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'btf': {'full': 'btf-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'btg': {'full': 'btg-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'bth': {'full': 'bth-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'bti': {'full': 'bti-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'btj': {'full': 'btj-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'btm': {'full': 'btm-Batk-ID', 'region': 'ID', 'script': 'Batk', 'suppress': False},
        'btn': {'full': 'btn-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'bto': {'full': 'bto-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'btp': {'full': 'btp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'btq': {'full': 'btq-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'btr': {'full': 'btr-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'bts': {'full': 'bts-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bts-Batk': {'full': 'bts-Batk-ID', 'region': 'ID', 'script': 'Batk', 'suppress': False},
        'btt': {'full': 'btt-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'btu': {'full': 'btu-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'btv': {'full': 'btv-Deva-PK', 'region': 'PK', 'script': 'Deva', 'suppress': False},
        'btw': {'full': 'btw-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'btx': {'full': 'btx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'btx-Batk': {'full': 'btx-Batk-ID', 'region': 'ID', 'script': 'Batk', 'suppress': False},
        'bty': {'full': 'bty-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'btz': {'full': 'btz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bua': {'full': 'bua-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'bub': {'full': 'bub-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'buc': {'full': 'buc-Latn-YT', 'region': 'YT', 'script': 'Latn', 'suppress': False},
        'bud': {'full': 'bud-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'bud-Brai': {'full': 'bud-Brai-TG', 'region': 'TG', 'script': 'Brai', 'suppress': False},
        'bue': {'full': 'bue-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'buf': {'full': 'buf-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bug': {'full': 'bug-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bug-Bugi': {'full': 'bug-Bugi-ID', 'region': 'ID', 'script': 'Bugi', 'suppress': False},
        'buh': {'full': 'buh-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'bui': {'full': 'bui-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'buj': {'full': 'buj-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'buk': {'full': 'buk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bum': {'full': 'bum-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bun': {'full': 'bun-Latn-SL', 'region': 'SL', 'script': 'Latn', 'suppress': False},
        'buo': {'full': 'buo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bup': {'full': 'bup-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'buq': {'full': 'buq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bus': {'full': 'bus-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'but': {'full': 'but-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'buu': {'full': 'buu-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'buv': {'full': 'buv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'buw': {'full': 'buw-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'bux': {'full': 'bux-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'buy': {'full': 'buy-Latn-SL', 'region': 'SL', 'script': 'Latn', 'suppress': False},
        'buz': {'full': 'buz-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bva': {'full': 'bva-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'bvb': {'full': 'bvb-Latn-GQ', 'region': 'GQ', 'script': 'Latn', 'suppress': False},
        'bvc': {'full': 'bvc-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'bvd': {'full': 'bvd-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'bve': {'full': 'bve-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bvf': {'full': 'bvf-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'bvg': {'full': 'bvg-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bvh': {'full': 'bvh-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bvi': {'full': 'bvi-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'bvj': {'full': 'bvj-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bvk': {'full': 'bvk-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bvl': {'full': 'bvl-Zxxx-BO', 'region': 'BO', 'script': 'Zxxx', 'suppress': False},
        'bvm': {'full': 'bvm-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bvn': {'full': 'bvn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bvo': {'full': 'bvo-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'bvp': {'full': 'bvp-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'bvq': {'full': 'bvq-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'bvr': {'full': 'bvr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'bvt': {'full': 'bvt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bvu': {'full': 'bvu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bvv': {'full': 'bvv-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'bvw': {'full': 'bvw-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bvx': {'full': 'bvx-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'bvy': {'full': 'bvy-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'bvz': {'full': 'bvz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bwa': {'full': 'bwa-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'bwb': {'full': 'bwb-Latn-FJ', 'region': 'FJ', 'script': 'Latn', 'suppress': False},
        'bwc': {'full': 'bwc-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'bwd': {'full': 'bwd-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bwe': {'full': 'bwe-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'bwe-Latn': {'full': 'bwe-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'bwf': {'full': 'bwf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bwg': {'full': 'bwg-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'bwh': {'full': 'bwh-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bwi': {'full': 'bwi-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'bwj': {'full': 'bwj-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'bwk': {'full': 'bwk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bwl': {'full': 'bwl-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bwm': {'full': 'bwm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bwn': {'full': 'bwn-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'bwo': {'full': 'bwo-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'bwo-Ethi': {'full': 'bwo-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'bwp': {'full': 'bwp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bwq': {'full': 'bwq-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'bwr': {'full': 'bwr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bws': {'full': 'bws-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bwt': {'full': 'bwt-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bwu': {'full': 'bwu-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'bww': {'full': 'bww-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bwx': {'full': 'bwx-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'bwy': {'full': 'bwy-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'bwz': {'full': 'bwz-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'bxa': {'full': 'bxa-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'bxb': {'full': 'bxb-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'bxc': {'full': 'bxc-Latn-GQ', 'region': 'GQ', 'script': 'Latn', 'suppress': False},
        'bxd': {'full': 'bxd-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'bxe': {'full': 'bxe-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'bxf': {'full': 'bxf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bxg': {'full': 'bxg-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bxh': {'full': 'bxh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bxi': {'full': 'bxi-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'bxj': {'full': 'bxj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'bxl': {'full': 'bxl-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'bxm': {'full': 'bxm-Cyrl-MN', 'region': 'MN', 'script': 'Cyrl', 'suppress': False},
        'bxm-Latn': {'full': 'bxm-Latn-MN', 'region': 'MN', 'script': 'Latn', 'suppress': False},
        'bxm-Mong': {'full': 'bxm-Mong-MN', 'region': 'MN', 'script': 'Mong', 'suppress': False},
        'bxn': {'full': 'bxn-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'bxo': {'full': 'bxo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bxp': {'full': 'bxp-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bxq': {'full': 'bxq-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bxs': {'full': 'bxs-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bxu': {'full': 'bxu-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'bxv': {'full': 'bxv-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'bxw': {'full': 'bxw-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'bxz': {'full': 'bxz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bya': {'full': 'bya-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'byb': {'full': 'byb-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'byc': {'full': 'byc-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'byd': {'full': 'byd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bye': {'full': 'bye-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'byf': {'full': 'byf-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'byg': {'full': 'byg-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'byh': {'full': 'byh-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'byi': {'full': 'byi-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'byj': {'full': 'byj-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'byk': {'full': 'byk-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'byl': {'full': 'byl-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bym': {'full': 'bym-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'byn': {'full': 'byn-Ethi-ER', 'region': 'ER', 'script': 'Ethi', 'suppress': False},
        'byn-Latn': {'full': 'byn-Latn-ER', 'region': 'ER', 'script': 'Latn', 'suppress': False},
        'byo': {'full': 'byo-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'byp': {'full': 'byp-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'byq': {'full': 'byq-Zyyy-TW', 'region': 'TW', 'script': 'Zyyy', 'suppress': False},
        'byr': {'full': 'byr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bys': {'full': 'bys-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'byt': {'full': 'byt-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'byv': {'full': 'byv-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'byw': {'full': 'byw-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'byx': {'full': 'byx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'byz': {'full': 'byz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bza': {'full': 'bza-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'bzb': {'full': 'bzb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bzc': {'full': 'bzc-Latn-MG', 'region': 'MG', 'script': 'Latn', 'suppress': False},
        'bzd': {'full': 'bzd-Latn-CR', 'region': 'CR', 'script': 'Latn', 'suppress': False},
        'bze': {'full': 'bze-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'bze-Arab': {'full': 'bze-Arab-ML', 'region': 'ML', 'script': 'Arab', 'suppress': False},
        'bzf': {'full': 'bzf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bzg': {'full': 'bzg-Zyyy-TW', 'region': 'TW', 'script': 'Zyyy', 'suppress': False},
        'bzh': {'full': 'bzh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'bzi': {'full': 'bzi-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'bzj': {'full': 'bzj-Latn-BZ', 'region': 'BZ', 'script': 'Latn', 'suppress': False},
        'bzk': {'full': 'bzk-Latn-NI', 'region': 'NI', 'script': 'Latn', 'suppress': False},
        'bzl': {'full': 'bzl-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bzm': {'full': 'bzm-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bzn': {'full': 'bzn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bzo': {'full': 'bzo-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'bzp': {'full': 'bzp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bzq': {'full': 'bzq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bzr': {'full': 'bzr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'bzs': {'full': 'bzs-Zxxx-BR', 'region': 'BR', 'script': 'Zxxx', 'suppress': False},
        'bzt': {'full': 'bzt-Zyyy-001', 'region': '001', 'script': 'Zyyy', 'suppress': False},
        'bzu': {'full': 'bzu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'bzv': {'full': 'bzv-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'bzw': {'full': 'bzw-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bzx': {'full': 'bzx-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'bzy': {'full': 'bzy-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'bzz': {'full': 'bzz-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ca': {'full': 'ca-Latn-ES', 'region': 'ES', 'script': 'Latn', 'suppress': True},
        'ca-FR': {'full': 'ca-Latn-FR', 'region': 'FR', 'script': 'Latn', 'suppress': True},
        'ca-valencia': {'full': 'ca-Latn-ES-valencia', 'region': 'ES', 'script': 'Latn', 'suppress': True},
        'caa': {'full': 'caa-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'cab': {'full': 'cab-Latn-HN', 'region': 'HN', 'script': 'Latn', 'suppress': False},
        'cac': {'full': 'cac-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'cad': {'full': 'cad-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'cae': {'full': 'cae-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'caf': {'full': 'caf-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'caf-Cans': {'full': 'caf-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'cag': {'full': 'cag-Latn-PY', 'region': 'PY', 'script': 'Latn', 'suppress': False},
        'cah': {'full': 'cah-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'caj': {'full': 'caj-Latn-AR', 'region': 'AR', 'script': 'Latn', 'suppress': False},
        'cak': {'full': 'cak-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'cal': {'full': 'cal-Latn-MP', 'region': 'MP', 'script': 'Latn', 'suppress': False},
        'cam': {'full': 'cam-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'can': {'full': 'can-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'cao': {'full': 'cao-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'cap': {'full': 'cap-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'caq': {'full': 'caq-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'car': {'full': 'car-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'cas': {'full': 'cas-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'cav': {'full': 'cav-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'caw': {'full': 'caw-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'cax': {'full': 'cax-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'cay': {'full': 'cay-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'caz': {'full': 'caz-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'cbb': {'full': 'cbb-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'cbc': {'full': 'cbc-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'cbd': {'full': 'cbd-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'cbg': {'full': 'cbg-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'cbi': {'full': 'cbi-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'cbj': {'full': 'cbj-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'cbk': {'full': 'cbk-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'cbk-Brai': {'full': 'cbk-Brai-PH', 'region': 'PH', 'script': 'Brai', 'suppress': False},
        'cbl': {'full': 'cbl-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cbn': {'full': 'cbn-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'cbo': {'full': 'cbo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'cbq': {'full': 'cbq-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'cbr': {'full': 'cbr-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'cbs': {'full': 'cbs-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'cbt': {'full': 'cbt-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'cbu': {'full': 'cbu-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'cbv': {'full': 'cbv-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'cbw': {'full': 'cbw-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'cby': {'full': 'cby-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'cca': {'full': 'cca-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'ccc': {'full': 'ccc-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'ccd': {'full': 'ccd-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'cce': {'full': 'cce-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'ccg': {'full': 'ccg-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'cch': {'full': 'cch-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ccj': {'full': 'ccj-Latn-GW', 'region': 'GW', 'script': 'Latn', 'suppress': False},
        'ccl': {'full': 'ccl-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'ccm': {'full': 'ccm-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'cco': {'full': 'cco-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ccp': {'full': 'ccp-Cakm-BD', 'region': 'BD', 'script': 'Cakm', 'suppress': False},
        'ccp-Beng': {'full': 'ccp-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'ccp-Latn': {'full': 'ccp-Latn-BD', 'region': 'BD', 'script': 'Latn', 'suppress': False},
        'ccr': {'full': 'ccr-Latn-SV', 'region': 'SV', 'script': 'Latn', 'suppress': False},
        'cda': {'full': 'cda-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'cde': {'full': 'cde-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'cdf': {'full': 'cdf-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'cdf-Beng': {'full': 'cdf-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'cdg': {'full': 'cdg-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'cdh': {'full': 'cdh-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'cdh-Takr': {'full': 'cdh-Takr-IN', 'region': 'IN', 'script': 'Takr', 'suppress': False},
        'cdi': {'full': 'cdi-Gujr-IN', 'region': 'IN', 'script': 'Gujr', 'suppress': False},
        'cdj': {'full': 'cdj-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'cdm': {'full': 'cdm-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'cdm-Latn': {'full': 'cdm-Latn-NP', 'region': 'NP', 'script': 'Latn', 'suppress': False},
        'cdn': {'full': 'cdn-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'cdo-Hans': {'full': 'cdo-Hans-CN', 'region': 'CN', 'script': 'Hans', 'suppress': False},
        'cdo-Hant': {'full': 'cdo-Hant-CN', 'region': 'CN', 'script': 'Hant', 'suppress': False},
        'cdo-Latn': {'full': 'cdo-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'cdr': {'full': 'cdr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'cds': {'full': 'cds-Zxxx-TD', 'region': 'TD', 'script': 'Zxxx', 'suppress': False},
        'cdy': {'full': 'cdy-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'cdz': {'full': 'cdz-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'ce': {'full': 'ce-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'ce-Arab': {'full': 'ce-Arab-RU', 'region': 'RU', 'script': 'Arab', 'suppress': False},
        'ce-Latn': {'full': 'ce-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'cea': {'full': 'cea-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'ceb': {'full': 'ceb-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ceb-Brai': {'full': 'ceb-Brai-PH', 'region': 'PH', 'script': 'Brai', 'suppress': False},
        'ceg': {'full': 'ceg-Latn-PY', 'region': 'PY', 'script': 'Latn', 'suppress': False},
        'cek': {'full': 'cek-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cek-x-asang': {'full': 'cek-Latn-MM-x-asang', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cek-x-hnise': {'full': 'cek-Latn-MM-x-hnise', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cek-x-kanise': {'full': 'cek-Latn-MM-x-kanise', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cek-x-khawngtu': {'full': 'cek-Latn-MM-x-khawngtu', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cek-x-khongtu': {'full': 'cek-Latn-MM-x-khongtu', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cek-x-lemi': {'full': 'cek-Latn-MM-x-lemi', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cek-x-likhy': {'full': 'cek-Latn-MM-x-likhy', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cek-x-rengcaa': {'full': 'cek-Latn-MM-x-rengcaa', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cek-x-taaw': {'full': 'cek-Latn-MM-x-taaw', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cen': {'full': 'cen-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'cet': {'full': 'cet-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'cey': {'full': 'cey-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cfa': {'full': 'cfa-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'cfd': {'full': 'cfd-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'cfg': {'full': 'cfg-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'cfm': {'full': 'cfm-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cfm-Beng': {'full': 'cfm-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'cfm-Latn-x-khuals': {'full': 'cfm-Latn-MM-x-khuals', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cfm-Latn-x-lente': {'full': 'cfm-Latn-MM-x-lente', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cfm-Latn-x-zannia': {'full': 'cfm-Latn-MM-x-zannia', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cga': {'full': 'cga-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'cgc': {'full': 'cgc-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'cgg': {'full': 'cgg-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'cgk': {'full': 'cgk-Zyyy-BT', 'region': 'BT', 'script': 'Zyyy', 'suppress': False},
        'ch': {'full': 'ch-Latn-GU', 'region': 'GU', 'script': 'Latn', 'suppress': True},
        'chb': {'full': 'chb-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'chc': {'full': 'chc-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'chd': {'full': 'chd-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'chf': {'full': 'chf-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'chg': {'full': 'chg-Zyyy-TM', 'region': 'TM', 'script': 'Zyyy', 'suppress': False},
        'chh': {'full': 'chh-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'chj': {'full': 'chj-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'chk': {'full': 'chk-Latn-FM', 'region': 'FM', 'script': 'Latn', 'suppress': False},
        'chl': {'full': 'chl-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'chm': {'full': 'chm-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'chm-Latn': {'full': 'chm-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'chn': {'full': 'chn-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'chn-Dupl': {'full': 'chn-Dupl-US', 'region': 'US', 'script': 'Dupl', 'suppress': False},
        'cho': {'full': 'cho-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'chp': {'full': 'chp-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'chp-Cans': {'full': 'chp-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'chq': {'full': 'chq-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'chr': {'full': 'chr-Cher-US', 'region': 'US', 'script': 'Cher', 'suppress': False},
        'chr-Latn': {'full': 'chr-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'cht': {'full': 'cht-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'chw': {'full': 'chw-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'chx': {'full': 'chx-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'chy': {'full': 'chy-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'chz': {'full': 'chz-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'cia': {'full': 'cia-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'cia-Arab': {'full': 'cia-Arab-ID', 'region': 'ID', 'script': 'Arab', 'suppress': False},
        'cia-Hang': {'full': 'cia-Hang-ID', 'region': 'ID', 'script': 'Hang', 'suppress': False},
        'cib': {'full': 'cib-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'cic': {'full': 'cic-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'cid': {'full': 'cid-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'cie': {'full': 'cie-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'cih': {'full': 'cih-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'cik': {'full': 'cik-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'cim': {'full': 'cim-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'cin': {'full': 'cin-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'cip': {'full': 'cip-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'cir': {'full': 'cir-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'ciw': {'full': 'ciw-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'ciw-Cans': {'full': 'ciw-Cans-US', 'region': 'US', 'script': 'Cans', 'suppress': False},
        'ciy': {'full': 'ciy-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'cja': {'full': 'cja-Arab-KH', 'region': 'KH', 'script': 'Arab', 'suppress': False},
        'cja-Cham': {'full': 'cja-Cham-KH', 'region': 'KH', 'script': 'Cham', 'suppress': False},
        'cja-Latn': {'full': 'cja-Latn-KH', 'region': 'KH', 'script': 'Latn', 'suppress': False},
        'cje': {'full': 'cje-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'cjh': {'full': 'cjh-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'cji': {'full': 'cji-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'cjk': {'full': 'cjk-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'cjm': {'full': 'cjm-Cham-VN', 'region': 'VN', 'script': 'Cham', 'suppress': False},
        'cjm-Arab': {'full': 'cjm-Arab-VN', 'region': 'VN', 'script': 'Arab', 'suppress': False},
        'cjm-Latn': {'full': 'cjm-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'cjn': {'full': 'cjn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'cjo': {'full': 'cjo-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'cjp': {'full': 'cjp-Latn-CR', 'region': 'CR', 'script': 'Latn', 'suppress': False},
        'cjs': {'full': 'cjs-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'cjs-Cyrl': {'full': 'cjs-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'cjv': {'full': 'cjv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'cjy-Hans': {'full': 'cjy-Hans-CN', 'region': 'CN', 'script': 'Hans', 'suppress': False},
        'cjy-Hant': {'full': 'cjy-Hant-CN', 'region': 'CN', 'script': 'Hant', 'suppress': False},
        'ckb': {'full': 'ckb-Arab-IQ', 'region': 'IQ', 'script': 'Arab', 'suppress': False},
        'ckb-IR': {'full': 'ckb-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'ckb-Latn': {'full': 'ckb-Latn-IQ', 'region': 'IQ', 'script': 'Latn', 'suppress': False},
        'ckh': {'full': 'ckh-Zyyy-BD', 'region': 'BD', 'script': 'Zyyy', 'suppress': False},
        'ckl': {'full': 'ckl-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ckm': {'full': 'ckm-Latn-HR', 'region': 'HR', 'script': 'Latn', 'suppress': False},
        'ckm-Glag': {'full': 'ckm-Glag-HR', 'region': 'HR', 'script': 'Glag', 'suppress': False},
        'ckn': {'full': 'ckn-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cko': {'full': 'cko-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'ckq': {'full': 'ckq-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'ckr': {'full': 'ckr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'cks': {'full': 'cks-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'ckt': {'full': 'ckt-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'cku': {'full': 'cku-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'ckv': {'full': 'ckv-Latn-TW', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'ckx': {'full': 'ckx-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'cky': {'full': 'cky-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ckz': {'full': 'ckz-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'cla': {'full': 'cla-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'clc': {'full': 'clc-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'cle': {'full': 'cle-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'clh': {'full': 'clh-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'cli': {'full': 'cli-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'clj': {'full': 'clj-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'clk': {'full': 'clk-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'clk-Tibt': {'full': 'clk-Tibt-CN', 'region': 'CN', 'script': 'Tibt', 'suppress': False},
        'cll': {'full': 'cll-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'clm': {'full': 'clm-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'clo': {'full': 'clo-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'clt': {'full': 'clt-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'clu': {'full': 'clu-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'clw': {'full': 'clw-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'cly': {'full': 'cly-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'cma': {'full': 'cma-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'cme': {'full': 'cme-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'cmg-Soyo': {'full': 'cmg-Soyo-MN', 'region': 'MN', 'script': 'Soyo', 'suppress': False},
        'cmi': {'full': 'cmi-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'cml': {'full': 'cml-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'cmm': {'full': 'cmm-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'cmo-Khmr': {'full': 'cmo-Khmr-KH', 'region': 'KH', 'script': 'Khmr', 'suppress': False},
        'cmo-Latn': {'full': 'cmo-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'cmo-Latn-KH': {'full': 'cmo-Latn-KH', 'region': 'KH', 'script': 'Latn', 'suppress': False},
        'cmr': {'full': 'cmr-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cms': {'full': 'cms-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'cmt': {'full': 'cmt-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': False},
        'cna': {'full': 'cna-Tibt-IN', 'region': 'IN', 'script': 'Tibt', 'suppress': False},
        'cnb': {'full': 'cnb-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cnc': {'full': 'cnc-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'cng': {'full': 'cng-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'cnh': {'full': 'cnh-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cni': {'full': 'cni-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'cnk': {'full': 'cnk-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cnl': {'full': 'cnl-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'cno': {'full': 'cno-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'cnp-Hans': {'full': 'cnp-Hans-CN', 'region': 'CN', 'script': 'Hans', 'suppress': False},
        'cnp-Hant': {'full': 'cnp-Hant-CN', 'region': 'CN', 'script': 'Hant', 'suppress': False},
        'cnr': {'full': 'cnr-Cyrl-ME', 'region': 'ME', 'script': 'Cyrl', 'suppress': False},
        'cnr-Latn': {'full': 'cnr-Latn-ME', 'region': 'ME', 'script': 'Latn', 'suppress': False},
        'cns': {'full': 'cns-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'cnt': {'full': 'cnt-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'cnu': {'full': 'cnu-Zyyy-DZ', 'region': 'DZ', 'script': 'Zyyy', 'suppress': False},
        'cnw': {'full': 'cnw-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cnx': {'full': 'cnx-Latn-GB', 'region': 'GB', 'script': 'Latn', 'suppress': False},
        'co': {'full': 'co-Latn-FR', 'region': 'FR', 'script': 'Latn', 'suppress': False},
        'coa': {'full': 'coa-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'cob': {'full': 'cob-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'coc': {'full': 'coc-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'cod': {'full': 'cod-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'coe': {'full': 'coe-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'cof': {'full': 'cof-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'cog': {'full': 'cog-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'coh': {'full': 'coh-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'coj': {'full': 'coj-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'cok': {'full': 'cok-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'col': {'full': 'col-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'com': {'full': 'com-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'con': {'full': 'con-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'coo': {'full': 'coo-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'cop': {'full': 'cop-Copt-EG', 'region': 'EG', 'script': 'Copt', 'suppress': False},
        'cop-Arab': {'full': 'cop-Arab-EG', 'region': 'EG', 'script': 'Arab', 'suppress': False},
        'cop-Grek': {'full': 'cop-Grek-EG', 'region': 'EG', 'script': 'Grek', 'suppress': False},
        'coq': {'full': 'coq-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'cot': {'full': 'cot-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'cou': {'full': 'cou-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'cov': {'full': 'cov-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'cow': {'full': 'cow-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'cox': {'full': 'cox-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'coz': {'full': 'coz-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'cpa': {'full': 'cpa-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'cpb': {'full': 'cpb-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'cpc': {'full': 'cpc-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'cpg': {'full': 'cpg-Grek-GR', 'region': 'GR', 'script': 'Grek', 'suppress': False},
        'cpi': {'full': 'cpi-Latn-NR', 'region': 'NR', 'script': 'Latn', 'suppress': False},
        'cpn': {'full': 'cpn-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'cpo': {'full': 'cpo-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'cps': {'full': 'cps-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'cpu': {'full': 'cpu-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'cpx': {'full': 'cpx-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'cpy': {'full': 'cpy-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'cqd': {'full': 'cqd-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'cr': {'full': 'cr-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'cr-Latn': {'full': 'cr-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'cra': {'full': 'cra-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'crb': {'full': 'crb-Latn-VC', 'region': 'VC', 'script': 'Latn', 'suppress': False},
        'crc': {'full': 'crc-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'crd': {'full': 'crd-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'crf': {'full': 'crf-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'crg': {'full': 'crg-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'crh': {'full': 'crh-Cyrl-UA', 'region': 'UA', 'script': 'Cyrl', 'suppress': False},
        'crh-Arab': {'full': 'crh-Arab-UZ', 'region': 'UZ', 'script': 'Arab', 'suppress': False},
        'crh-Latn': {'full': 'crh-Latn-UA', 'region': 'UA', 'script': 'Latn', 'suppress': False},
        'cri': {'full': 'cri-Latn-ST', 'region': 'ST', 'script': 'Latn', 'suppress': False},
        'crj': {'full': 'crj-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'crj-Latn': {'full': 'crj-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'crk': {'full': 'crk-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'crk-Latn': {'full': 'crk-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'crl': {'full': 'crl-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'crl-Latn': {'full': 'crl-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'crm': {'full': 'crm-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'crn': {'full': 'crn-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'cro': {'full': 'cro-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'crq': {'full': 'crq-Latn-AR', 'region': 'AR', 'script': 'Latn', 'suppress': False},
        'crr': {'full': 'crr-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'crs': {'full': 'crs-Latn-SC', 'region': 'SC', 'script': 'Latn', 'suppress': False},
        'crt': {'full': 'crt-Latn-AR', 'region': 'AR', 'script': 'Latn', 'suppress': False},
        'crv': {'full': 'crv-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'crw': {'full': 'crw-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'crx': {'full': 'crx-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'crx-Cans': {'full': 'crx-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'cry': {'full': 'cry-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'crz': {'full': 'crz-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'cs': {'full': 'cs-Latn-CZ', 'region': 'CZ', 'script': 'Latn', 'suppress': True},
        'cs-Brai': {'full': 'cs-Brai-CZ', 'region': 'CZ', 'script': 'Brai', 'suppress': False},
        'csa': {'full': 'csa-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'csb': {'full': 'csb-Latn-PL', 'region': 'PL', 'script': 'Latn', 'suppress': False},
        'csc': {'full': 'csc-Zxxx-ES', 'region': 'ES', 'script': 'Zxxx', 'suppress': False},
        'csd': {'full': 'csd-Zxxx-TH', 'region': 'TH', 'script': 'Zxxx', 'suppress': False},
        'cse': {'full': 'cse-Zxxx-CZ', 'region': 'CZ', 'script': 'Zxxx', 'suppress': False},
        'csf': {'full': 'csf-Zxxx-CU', 'region': 'CU', 'script': 'Zxxx', 'suppress': False},
        'csg': {'full': 'csg-Zxxx-CL', 'region': 'CL', 'script': 'Zxxx', 'suppress': False},
        'csh': {'full': 'csh-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'csh-Latn': {'full': 'csh-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'csi': {'full': 'csi-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'csj': {'full': 'csj-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'csk': {'full': 'csk-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'csl': {'full': 'csl-Zxxx-CN', 'region': 'CN', 'script': 'Zxxx', 'suppress': False},
        'csm': {'full': 'csm-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'csn': {'full': 'csn-Zxxx-CO', 'region': 'CO', 'script': 'Zxxx', 'suppress': False},
        'cso': {'full': 'cso-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'csp-Hans': {'full': 'csp-Hans-CN', 'region': 'CN', 'script': 'Hans', 'suppress': False},
        'csp-Hant': {'full': 'csp-Hant-CN', 'region': 'CN', 'script': 'Hant', 'suppress': False},
        'csq': {'full': 'csq-Zxxx-HR', 'region': 'HR', 'script': 'Zxxx', 'suppress': False},
        'csr': {'full': 'csr-Zxxx-CR', 'region': 'CR', 'script': 'Zxxx', 'suppress': False},
        'css': {'full': 'css-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'cst': {'full': 'cst-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'csv': {'full': 'csv-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'csw': {'full': 'csw-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'csy': {'full': 'csy-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'csz': {'full': 'csz-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'cta': {'full': 'cta-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ctc': {'full': 'ctc-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'ctd': {'full': 'ctd-Pauc-MM', 'region': 'MM', 'script': 'Pauc', 'suppress': False},
        'ctd-Latn': {'full': 'ctd-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'cte': {'full': 'cte-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ctg': {'full': 'ctg-Beng-BD', 'region': 'BD', 'script': 'Beng', 'suppress': False},
        'ctg-Arab': {'full': 'ctg-Arab-BD', 'region': 'BD', 'script': 'Arab', 'suppress': False},
        'ctg-Latn': {'full': 'ctg-Latn-BD', 'region': 'BD', 'script': 'Latn', 'suppress': False},
        'cth': {'full': 'cth-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'ctl': {'full': 'ctl-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ctm': {'full': 'ctm-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'ctn': {'full': 'ctn-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'cto': {'full': 'cto-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'ctp': {'full': 'ctp-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'cts': {'full': 'cts-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ctt': {'full': 'ctt-Taml-IN', 'region': 'IN', 'script': 'Taml', 'suppress': False},
        'ctu': {'full': 'ctu-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ctu-x-tila': {'full': 'ctu-Latn-MX-x-tila', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ctu-x-tumbala': {'full': 'ctu-Latn-MX-x-tumbala', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ctz': {'full': 'ctz-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'cu': {'full': 'cu-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'cu-Cyrs': {'full': 'cu-Cyrs-RU', 'region': 'RU', 'script': 'Cyrs', 'suppress': False},
        'cu-Glag': {'full': 'cu-Glag-BG', 'region': 'BG', 'script': 'Glag', 'suppress': False},
        'cua': {'full': 'cua-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'cub': {'full': 'cub-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'cuc': {'full': 'cuc-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'cug': {'full': 'cug-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'cuh': {'full': 'cuh-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'cui': {'full': 'cui-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'cuj': {'full': 'cuj-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'cuk': {'full': 'cuk-Latn-PA', 'region': 'PA', 'script': 'Latn', 'suppress': False},
        'cul': {'full': 'cul-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'cuo': {'full': 'cuo-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'cup': {'full': 'cup-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'cuq': {'full': 'cuq-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'cur': {'full': 'cur-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'cut': {'full': 'cut-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'cuu': {'full': 'cuu-Lana-CN', 'region': 'CN', 'script': 'Lana', 'suppress': False},
        'cuv': {'full': 'cuv-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'cuw': {'full': 'cuw-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'cux': {'full': 'cux-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'cuy': {'full': 'cuy-Latn-XX', 'region': 'XX', 'script': 'Latn', 'suppress': False},
        'cv': {'full': 'cv-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'cvg': {'full': 'cvg-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'cvg-Tibt': {'full': 'cvg-Tibt-IN', 'region': 'IN', 'script': 'Tibt', 'suppress': False},
        'cvn': {'full': 'cvn-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'cwa': {'full': 'cwa-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'cwb': {'full': 'cwb-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'cwe': {'full': 'cwe-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'cwg': {'full': 'cwg-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'cwt': {'full': 'cwt-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'cy': {'full': 'cy-Latn-GB', 'region': 'GB', 'script': 'Latn', 'suppress': True},
        'cy-Brai': {'full': 'cy-Brai-GB', 'region': 'GB', 'script': 'Brai', 'suppress': False},
        'cya': {'full': 'cya-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'cyb': {'full': 'cyb-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'cyo': {'full': 'cyo-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'czh-Hans': {'full': 'czh-Hans-CN', 'region': 'CN', 'script': 'Hans', 'suppress': False},
        'czh-Hant': {'full': 'czh-Hant-CN', 'region': 'CN', 'script': 'Hant', 'suppress': False},
        'czk': {'full': 'czk-Zyyy-CZ', 'region': 'CZ', 'script': 'Zyyy', 'suppress': False},
        'czn': {'full': 'czn-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'czo': {'full': 'czo-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'czt': {'full': 'czt-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'da': {'full': 'da-Latn-DK', 'region': 'DK', 'script': 'Latn', 'suppress': True},
        'da-Brai': {'full': 'da-Brai-DK', 'region': 'DK', 'script': 'Brai', 'suppress': False},
        'daa': {'full': 'daa-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'dac': {'full': 'dac-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dad': {'full': 'dad-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dae': {'full': 'dae-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'dag': {'full': 'dag-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'dag-Arab': {'full': 'dag-Arab-GH', 'region': 'GH', 'script': 'Arab', 'suppress': False},
        'dah': {'full': 'dah-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dai': {'full': 'dai-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'daj': {'full': 'daj-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'dak': {'full': 'dak-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'dal': {'full': 'dal-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'dam': {'full': 'dam-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'dao': {'full': 'dao-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'dao-x-khengdai': {'full': 'dao-Latn-MM-x-khengdai', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'dao-x-matlic': {'full': 'dao-Latn-MM-x-matlic', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'dao-x-mattui': {'full': 'dao-Latn-MM-x-mattui', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'dao-x-yindu': {'full': 'dao-Latn-MM-x-yindu', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'daq': {'full': 'daq-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'dar': {'full': 'dar-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'das': {'full': 'das-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'dau': {'full': 'dau-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'dav': {'full': 'dav-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'daw': {'full': 'daw-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'dax': {'full': 'dax-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'daz': {'full': 'daz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dba': {'full': 'dba-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'dbb': {'full': 'dbb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'dbd': {'full': 'dbd-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'dbe': {'full': 'dbe-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dbf': {'full': 'dbf-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dbg': {'full': 'dbg-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'dbi': {'full': 'dbi-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'dbj': {'full': 'dbj-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'dbj-Arab': {'full': 'dbj-Arab-MY', 'region': 'MY', 'script': 'Arab', 'suppress': False},
        'dbl': {'full': 'dbl-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dbm': {'full': 'dbm-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'dbn': {'full': 'dbn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dbo': {'full': 'dbo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'dbp': {'full': 'dbp-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'dbq': {'full': 'dbq-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'dbr': {'full': 'dbr-Zyyy-SO', 'region': 'SO', 'script': 'Zyyy', 'suppress': False},
        'dbt': {'full': 'dbt-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'dbu': {'full': 'dbu-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'dbv': {'full': 'dbv-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'dbw': {'full': 'dbw-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'dby': {'full': 'dby-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dcc': {'full': 'dcc-Arab-IN', 'region': 'IN', 'script': 'Arab', 'suppress': False},
        'dcc-Deva': {'full': 'dcc-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'dcr': {'full': 'dcr-Latn-VI', 'region': 'VI', 'script': 'Latn', 'suppress': False},
        'dda': {'full': 'dda-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ddd': {'full': 'ddd-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'dde': {'full': 'dde-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'ddg': {'full': 'ddg-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'ddi': {'full': 'ddi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ddj': {'full': 'ddj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ddn': {'full': 'ddn-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'ddo': {'full': 'ddo-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'ddr': {'full': 'ddr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dds': {'full': 'dds-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'ddw': {'full': 'ddw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'de': {'full': 'de-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': True},
        'de-AT': {'full': 'de-Latn-AT', 'region': 'AT', 'script': 'Latn', 'suppress': True},
        'de-Brai': {'full': 'de-Brai-DE', 'region': 'DE', 'script': 'Brai', 'suppress': False},
        'de-CH': {'full': 'de-Latn-CH', 'region': 'CH', 'script': 'Latn', 'suppress': True},
        'de-Dupl': {'full': 'de-Dupl-DE', 'region': 'DE', 'script': 'Dupl', 'suppress': False},
        'de-IT': {'full': 'de-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': True},
        'de-LI': {'full': 'de-Latn-LI', 'region': 'LI', 'script': 'Latn', 'suppress': True},
        'de-LU': {'full': 'de-Latn-LU', 'region': 'LU', 'script': 'Latn', 'suppress': True},
        'de-Latf': {'full': 'de-Latf-DE', 'region': 'DE', 'script': 'Latf', 'suppress': False},
        'de-Runr': {'full': 'de-Runr-DE', 'region': 'DE', 'script': 'Runr', 'suppress': False},
        'dec': {'full': 'dec-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'ded': {'full': 'ded-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dee': {'full': 'dee-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'def': {'full': 'def-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'deg': {'full': 'deg-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'deh': {'full': 'deh-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'dei': {'full': 'dei-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dek': {'full': 'dek-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'del': {'full': 'del-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'del-Latn-CA': {'full': 'del-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'dem': {'full': 'dem-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'den': {'full': 'den-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'den-Cans': {'full': 'den-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'dep': {'full': 'dep-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'deq': {'full': 'deq-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'der-Beng': {'full': 'der-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'der-Latn': {'full': 'der-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'des': {'full': 'des-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'dev': {'full': 'dev-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dez': {'full': 'dez-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'dga': {'full': 'dga-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'dgb': {'full': 'dgb-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'dgc': {'full': 'dgc-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'dgd': {'full': 'dgd-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'dge': {'full': 'dge-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dgg': {'full': 'dgg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dgh': {'full': 'dgh-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'dgi': {'full': 'dgi-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'dgk': {'full': 'dgk-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'dgl-Arab': {'full': 'dgl-Arab-SD', 'region': 'SD', 'script': 'Arab', 'suppress': False},
        'dgl-Copt': {'full': 'dgl-Copt-SD-x-olnubian', 'region': 'SD', 'script': 'Copt', 'suppress': False},
        'dgl-Latn': {'full': 'dgl-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'dgn': {'full': 'dgn-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dgr': {'full': 'dgr-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'dgs': {'full': 'dgs-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'dgt': {'full': 'dgt-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dgu': {'full': 'dgu-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'dgw': {'full': 'dgw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dgx': {'full': 'dgx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dgz': {'full': 'dgz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dhg': {'full': 'dhg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dhi': {'full': 'dhi-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'dhl': {'full': 'dhl-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dhm': {'full': 'dhm-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'dhn': {'full': 'dhn-Gujr-IN', 'region': 'IN', 'script': 'Gujr', 'suppress': False},
        'dho': {'full': 'dho-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'dhr': {'full': 'dhr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dhs': {'full': 'dhs-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'dhu': {'full': 'dhu-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dhv': {'full': 'dhv-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'dhw': {'full': 'dhw-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'dhx': {'full': 'dhx-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dia': {'full': 'dia-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dib': {'full': 'dib-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'dic': {'full': 'dic-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'did': {'full': 'did-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'dif': {'full': 'dif-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dig': {'full': 'dig-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'dih': {'full': 'dih-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'dii': {'full': 'dii-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'dij': {'full': 'dij-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dik-Arab': {'full': 'dik-Arab-SS', 'region': 'SS', 'script': 'Arab', 'suppress': False},
        'dil': {'full': 'dil-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'dim': {'full': 'dim-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'din': {'full': 'din-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'din-Arab': {'full': 'din-Arab-SS', 'region': 'SS', 'script': 'Arab', 'suppress': False},
        'dio': {'full': 'dio-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'dip': {'full': 'dip-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'dir': {'full': 'dir-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'dis-Beng': {'full': 'dis-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'dis-Latn': {'full': 'dis-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'diu': {'full': 'diu-Latn-NA', 'region': 'NA', 'script': 'Latn', 'suppress': False},
        'diw': {'full': 'diw-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'dix': {'full': 'dix-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'diy': {'full': 'diy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'diz': {'full': 'diz-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'dja': {'full': 'dja-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'djb': {'full': 'djb-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'djc': {'full': 'djc-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'djd': {'full': 'djd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dje': {'full': 'dje-Latn-NE', 'region': 'NE', 'script': 'Latn', 'suppress': False},
        'dje-Arab': {'full': 'dje-Arab-NE', 'region': 'NE', 'script': 'Arab', 'suppress': False},
        'dje-Brai': {'full': 'dje-Brai-NE', 'region': 'NE', 'script': 'Brai', 'suppress': False},
        'djf': {'full': 'djf-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dji': {'full': 'dji-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'djj': {'full': 'djj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'djk': {'full': 'djk-Latn-SR', 'region': 'SR', 'script': 'Latn', 'suppress': False},
        'djk-Afak': {'full': 'djk-Afak-SR', 'region': 'SR', 'script': 'Afak', 'suppress': False},
        'djm': {'full': 'djm-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'djn': {'full': 'djn-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'djo': {'full': 'djo-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'djr': {'full': 'djr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dju': {'full': 'dju-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'djw': {'full': 'djw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dka': {'full': 'dka-Zyyy-BT', 'region': 'BT', 'script': 'Zyyy', 'suppress': False},
        'dkk': {'full': 'dkk-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dkr': {'full': 'dkr-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'dks': {'full': 'dks-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'dkx': {'full': 'dkx-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'dlg': {'full': 'dlg-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'dlk': {'full': 'dlk-Zyyy-ER', 'region': 'ER', 'script': 'Zyyy', 'suppress': False},
        'dlm': {'full': 'dlm-Latn-HR', 'region': 'HR', 'script': 'Latn', 'suppress': False},
        'dln': {'full': 'dln-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'dma': {'full': 'dma-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'dmb': {'full': 'dmb-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'dmc': {'full': 'dmc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dmd': {'full': 'dmd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dme': {'full': 'dme-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'dmf': {'full': 'dmf-Medf-NG', 'region': 'NG', 'script': 'Medf', 'suppress': False},
        'dmg': {'full': 'dmg-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'dmk': {'full': 'dmk-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'dml': {'full': 'dml-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'dmm': {'full': 'dmm-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'dmo': {'full': 'dmo-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'dmr': {'full': 'dmr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dms': {'full': 'dms-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dmu': {'full': 'dmu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dmv': {'full': 'dmv-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'dmw': {'full': 'dmw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dmx': {'full': 'dmx-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'dmy': {'full': 'dmy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dna': {'full': 'dna-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dnd': {'full': 'dnd-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dne': {'full': 'dne-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'dng': {'full': 'dng-Cyrl-KG', 'region': 'KG', 'script': 'Cyrl', 'suppress': False},
        'dni': {'full': 'dni-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dnj': {'full': 'dnj-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'dnj-LR': {'full': 'dnj-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'dnk': {'full': 'dnk-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dnn': {'full': 'dnn-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'dno': {'full': 'dno-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'dnr': {'full': 'dnr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dnt': {'full': 'dnt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dnu': {'full': 'dnu-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'dnv': {'full': 'dnv-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'dnw': {'full': 'dnw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dny': {'full': 'dny-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'doa': {'full': 'doa-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dob': {'full': 'dob-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'doc': {'full': 'doc-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'doe': {'full': 'doe-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'dof': {'full': 'dof-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'doh': {'full': 'doh-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'doi': {'full': 'doi-Arab-IN', 'region': 'IN', 'script': 'Arab', 'suppress': False},
        'doi-Deva': {'full': 'doi-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'doi-Takr': {'full': 'doi-Takr-IN', 'region': 'IN', 'script': 'Takr', 'suppress': False},
        'dok': {'full': 'dok-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dol': {'full': 'dol-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'don': {'full': 'don-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'doo': {'full': 'doo-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'dop': {'full': 'dop-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'doq': {'full': 'doq-Zxxx-DO', 'region': 'DO', 'script': 'Zxxx', 'suppress': False},
        'dor': {'full': 'dor-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'dos': {'full': 'dos-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'dot': {'full': 'dot-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'dov': {'full': 'dov-Latn-ZW', 'region': 'ZW', 'script': 'Latn', 'suppress': False},
        'dow': {'full': 'dow-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'dox': {'full': 'dox-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'doy': {'full': 'doy-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'doz': {'full': 'doz-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'dpp': {'full': 'dpp-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'drb': {'full': 'drb-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'drc': {'full': 'drc-Latn-PT', 'region': 'PT', 'script': 'Latn', 'suppress': False},
        'drd': {'full': 'drd-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'dre': {'full': 'dre-Tibt-NP', 'region': 'NP', 'script': 'Tibt', 'suppress': False},
        'drg': {'full': 'drg-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'dri': {'full': 'dri-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'drl': {'full': 'drl-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'drn': {'full': 'drn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dro': {'full': 'dro-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'drq': {'full': 'drq-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'drs': {'full': 'drs-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'drt': {'full': 'drt-Latn-NL', 'region': 'NL', 'script': 'Latn', 'suppress': False},
        'dru': {'full': 'dru-Latn-TW', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'dry': {'full': 'dry-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'dsb': {'full': 'dsb-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': True},
        'dse': {'full': 'dse-Zxxx-NL', 'region': 'NL', 'script': 'Zxxx', 'suppress': False},
        'dsh': {'full': 'dsh-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'dsi': {'full': 'dsi-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'dsl': {'full': 'dsl-Zxxx-DK', 'region': 'DK', 'script': 'Zxxx', 'suppress': False},
        'dsn': {'full': 'dsn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dso': {'full': 'dso-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'dsq-Arab': {'full': 'dsq-Arab-ML', 'region': 'ML', 'script': 'Arab', 'suppress': False},
        'dsq-Latn': {'full': 'dsq-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'dta': {'full': 'dta-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'dta-Cyrl': {'full': 'dta-Cyrl-CN', 'region': 'CN', 'script': 'Cyrl', 'suppress': False},
        'dta-Hans': {'full': 'dta-Hans-CN', 'region': 'CN', 'script': 'Hans', 'suppress': False},
        'dta-Mong-x-manchu': {'full': 'dta-Mong-CN-x-manchu', 'region': 'CN', 'script': 'Mong', 'suppress': False},
        'dtb': {'full': 'dtb-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'dtd': {'full': 'dtd-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'dth': {'full': 'dth-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dti': {'full': 'dti-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'dtk': {'full': 'dtk-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'dtm': {'full': 'dtm-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'dtn': {'full': 'dtn-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'dto': {'full': 'dto-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'dtp': {'full': 'dtp-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'dtr': {'full': 'dtr-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'dts': {'full': 'dts-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'dtt': {'full': 'dtt-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'dtu': {'full': 'dtu-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'dty': {'full': 'dty-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'dua': {'full': 'dua-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'dub': {'full': 'dub-Gujr-IN', 'region': 'IN', 'script': 'Gujr', 'suppress': False},
        'duc': {'full': 'duc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'due': {'full': 'due-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'duf': {'full': 'duf-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'dug': {'full': 'dug-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'duh-Deva': {'full': 'duh-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'duh-Gujr': {'full': 'duh-Gujr-IN', 'region': 'IN', 'script': 'Gujr', 'suppress': False},
        'dui': {'full': 'dui-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'duk': {'full': 'duk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dul': {'full': 'dul-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'dum': {'full': 'dum-Latn-NL', 'region': 'NL', 'script': 'Latn', 'suppress': False},
        'dun': {'full': 'dun-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'duo': {'full': 'duo-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'dup': {'full': 'dup-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'duq': {'full': 'duq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dur': {'full': 'dur-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'dus': {'full': 'dus-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'duu': {'full': 'duu-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'duv': {'full': 'duv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'duw': {'full': 'duw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'dux': {'full': 'dux-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'duy': {'full': 'duy-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'duz': {'full': 'duz-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'dv': {'full': 'dv-Thaa-MV', 'region': 'MV', 'script': 'Thaa', 'suppress': True},
        'dv-Diak': {'full': 'dv-Diak-MV', 'region': 'MV', 'script': 'Diak', 'suppress': False},
        'dva': {'full': 'dva-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dwa': {'full': 'dwa-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'dwk': {'full': 'dwk-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'dwr': {'full': 'dwr-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'dwr-Ethi': {'full': 'dwr-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'dws': {'full': 'dws-Zyyy-001', 'region': '001', 'script': 'Zyyy', 'suppress': False},
        'dwu': {'full': 'dwu-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dww': {'full': 'dww-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'dwy': {'full': 'dwy-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dwz': {'full': 'dwz-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'dya': {'full': 'dya-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'dyb': {'full': 'dyb-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dyd': {'full': 'dyd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dyg': {'full': 'dyg-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'dyi': {'full': 'dyi-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'dym': {'full': 'dym-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'dyn': {'full': 'dyn-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dyo': {'full': 'dyo-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'dyo-Arab': {'full': 'dyo-Arab-SN', 'region': 'SN', 'script': 'Arab', 'suppress': False},
        'dyu': {'full': 'dyu-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'dyu-Arab': {'full': 'dyu-Arab-CI', 'region': 'CI', 'script': 'Arab', 'suppress': False},
        'dyu-Nkoo': {'full': 'dyu-Nkoo-CI', 'region': 'CI', 'script': 'Nkoo', 'suppress': False},
        'dyy': {'full': 'dyy-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dz': {'full': 'dz-Tibt-BT', 'region': 'BT', 'script': 'Tibt', 'suppress': True},
        'dza': {'full': 'dza-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'dze': {'full': 'dze-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'dzg': {'full': 'dzg-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'dzl': {'full': 'dzl-Zyyy-BT', 'region': 'BT', 'script': 'Zyyy', 'suppress': False},
        'dzn': {'full': 'dzn-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'eaa': {'full': 'eaa-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ebc': {'full': 'ebc-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ebg': {'full': 'ebg-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ebk': {'full': 'ebk-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ebo': {'full': 'ebo-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'ebr': {'full': 'ebr-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'ebu': {'full': 'ebu-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'ecr': {'full': 'ecr-Zyyy-GR', 'region': 'GR', 'script': 'Zyyy', 'suppress': False},
        'ecs': {'full': 'ecs-Zxxx-EC', 'region': 'EC', 'script': 'Zxxx', 'suppress': False},
        'ecy': {'full': 'ecy-Zyyy-CY', 'region': 'CY', 'script': 'Zyyy', 'suppress': False},
        'ee': {'full': 'ee-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'ee-Brai': {'full': 'ee-Brai-GH', 'region': 'GH', 'script': 'Brai', 'suppress': False},
        'ee-TG': {'full': 'ee-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'eee': {'full': 'eee-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'efa': {'full': 'efa-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'efe': {'full': 'efe-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'efi': {'full': 'efi-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ega': {'full': 'ega-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'egl': {'full': 'egl-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'ego': {'full': 'ego-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'egy': {'full': 'egy-Egyp-EG', 'region': 'EG', 'script': 'Egyp', 'suppress': False},
        'ehu': {'full': 'ehu-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'eip': {'full': 'eip-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'eit': {'full': 'eit-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'eiv': {'full': 'eiv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'eja': {'full': 'eja-Latn-GW', 'region': 'GW', 'script': 'Latn', 'suppress': False},
        'eka': {'full': 'eka-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'eka-Latn-NG-x-ekajuk': {'full': 'eka-Latn-NG-x-ekajuk', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ekc': {'full': 'ekc-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'eke': {'full': 'eke-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ekg': {'full': 'ekg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'eki': {'full': 'eki-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ekl': {'full': 'ekl-Latn-BD', 'region': 'BD', 'script': 'Latn', 'suppress': False},
        'ekm': {'full': 'ekm-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'eko': {'full': 'eko-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'eko-Arab': {'full': 'eko-Arab-MZ', 'region': 'MZ', 'script': 'Arab', 'suppress': False},
        'ekp': {'full': 'ekp-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ekr': {'full': 'ekr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'eky': {'full': 'eky-Kali-MM', 'region': 'MM', 'script': 'Kali', 'suppress': False},
        'el': {'full': 'el-Grek-GR', 'region': 'GR', 'script': 'Grek', 'suppress': True},
        'el-Brai': {'full': 'el-Brai-GR', 'region': 'GR', 'script': 'Brai', 'suppress': False},
        'el-Cyrl': {'full': 'el-Cyrl-UA', 'region': 'UA', 'script': 'Cyrl', 'suppress': False},
        'ele': {'full': 'ele-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'elh': {'full': 'elh-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'eli': {'full': 'eli-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'elk': {'full': 'elk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'elm': {'full': 'elm-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'elo': {'full': 'elo-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'elu': {'full': 'elu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'elx': {'full': 'elx-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'ema': {'full': 'ema-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'emb': {'full': 'emb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'eme': {'full': 'eme-Latn-GF', 'region': 'GF', 'script': 'Latn', 'suppress': False},
        'emg': {'full': 'emg-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'emi': {'full': 'emi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'emm': {'full': 'emm-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'emn': {'full': 'emn-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'emp': {'full': 'emp-Latn-PA', 'region': 'PA', 'script': 'Latn', 'suppress': False},
        'ems': {'full': 'ems-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'ems-Cyrl': {'full': 'ems-Cyrl-US', 'region': 'US', 'script': 'Cyrl', 'suppress': False},
        'emu': {'full': 'emu-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'emw': {'full': 'emw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'emx': {'full': 'emx-Latn-FR', 'region': 'FR', 'script': 'Latn', 'suppress': False},
        'emy': {'full': 'emy-Zyyy-MX', 'region': 'MX', 'script': 'Zyyy', 'suppress': False},
        'en': {'full': 'en-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': True},
        'en-001': {'full': 'en-Latn-001', 'region': '001', 'script': 'Latn', 'suppress': True},
        'en-150': {'full': 'en-Latn-150', 'region': '150', 'script': 'Latn', 'suppress': True},
        'en-AE': {'full': 'en-Latn-AE', 'region': 'AE', 'script': 'Latn', 'suppress': True},
        'en-AG': {'full': 'en-Latn-AG', 'region': 'AG', 'script': 'Latn', 'suppress': True},
        'en-AI': {'full': 'en-Latn-AI', 'region': 'AI', 'script': 'Latn', 'suppress': True},
        'en-AT': {'full': 'en-Latn-AT', 'region': 'AT', 'script': 'Latn', 'suppress': True},
        'en-AU': {'full': 'en-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': True},
        'en-BB': {'full': 'en-Latn-BB', 'region': 'BB', 'script': 'Latn', 'suppress': True},
        'en-BE': {'full': 'en-Latn-BE', 'region': 'BE', 'script': 'Latn', 'suppress': True},
        'en-BI': {'full': 'en-Latn-BI', 'region': 'BI', 'script': 'Latn', 'suppress': True},
        'en-BM': {'full': 'en-Latn-BM', 'region': 'BM', 'script': 'Latn', 'suppress': True},
        'en-BS': {'full': 'en-Latn-BS', 'region': 'BS', 'script': 'Latn', 'suppress': True},
        'en-BW': {'full': 'en-Latn-BW', 'region': 'BW', 'script': 'Latn', 'suppress': True},
        'en-BZ': {'full': 'en-Latn-BZ', 'region': 'BZ', 'script': 'Latn', 'suppress': True},
        'en-Brai': {'full': 'en-Brai-GB', 'region': 'GB', 'script': 'Brai', 'suppress': False},
        'en-CA': {'full': 'en-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': True},
        'en-CC': {'full': 'en-Latn-CC', 'region': 'CC', 'script': 'Latn', 'suppress': True},
        'en-CH': {'full': 'en-Latn-CH', 'region': 'CH', 'script': 'Latn', 'suppress': True},
        'en-CK': {'full': 'en-Latn-CK', 'region': 'CK', 'script': 'Latn', 'suppress': True},
        'en-CM': {'full': 'en-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': True},
        'en-CX': {'full': 'en-Latn-CX', 'region': 'CX', 'script': 'Latn', 'suppress': True},
        'en-DE': {'full': 'en-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': True},
        'en-DG': {'full': 'en-Latn-DG', 'region': 'DG', 'script': 'Latn', 'suppress': True},
        'en-DK': {'full': 'en-Latn-DK', 'region': 'DK', 'script': 'Latn', 'suppress': True},
        'en-DM': {'full': 'en-Latn-DM', 'region': 'DM', 'script': 'Latn', 'suppress': True},
        'en-Dsrt': {'full': 'en-Dsrt-US', 'region': 'US', 'script': 'Dsrt', 'suppress': False},
        'en-Dupl': {'full': 'en-Dupl-US', 'region': 'US', 'script': 'Dupl', 'suppress': False},
        'en-ER': {'full': 'en-Latn-ER', 'region': 'ER', 'script': 'Latn', 'suppress': True},
        'en-FI': {'full': 'en-Latn-FI', 'region': 'FI', 'script': 'Latn', 'suppress': True},
        'en-FJ': {'full': 'en-Latn-FJ', 'region': 'FJ', 'script': 'Latn', 'suppress': True},
        'en-FK': {'full': 'en-Latn-FK', 'region': 'FK', 'script': 'Latn', 'suppress': True},
        'en-GB': {'full': 'en-Latn-GB', 'region': 'GB', 'script': 'Latn', 'suppress': True},
        'en-GD': {'full': 'en-Latn-GD', 'region': 'GD', 'script': 'Latn', 'suppress': True},
        'en-GG': {'full': 'en-Latn-GG', 'region': 'GG', 'script': 'Latn', 'suppress': True},
        'en-GH': {'full': 'en-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': True},
        'en-GI': {'full': 'en-Latn-GI', 'region': 'GI', 'script': 'Latn', 'suppress': True},
        'en-GM': {'full': 'en-Latn-GM', 'region': 'GM', 'script': 'Latn', 'suppress': True},
        'en-GU': {'full': 'en-Latn-GU', 'region': 'GU', 'script': 'Latn', 'suppress': True},
        'en-GY': {'full': 'en-Latn-GY', 'region': 'GY', 'script': 'Latn', 'suppress': True},
        'en-HK': {'full': 'en-Latn-HK', 'region': 'HK', 'script': 'Latn', 'suppress': True},
        'en-IE': {'full': 'en-Latn-IE', 'region': 'IE', 'script': 'Latn', 'suppress': True},
        'en-IL': {'full': 'en-Latn-IL', 'region': 'IL', 'script': 'Latn', 'suppress': True},
        'en-IM': {'full': 'en-Latn-IM', 'region': 'IM', 'script': 'Latn', 'suppress': True},
        'en-IN': {'full': 'en-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': True},
        'en-IO': {'full': 'en-Latn-IO', 'region': 'IO', 'script': 'Latn', 'suppress': True},
        'en-JE': {'full': 'en-Latn-JE', 'region': 'JE', 'script': 'Latn', 'suppress': True},
        'en-JM': {'full': 'en-Latn-JM', 'region': 'JM', 'script': 'Latn', 'suppress': True},
        'en-KE': {'full': 'en-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': True},
        'en-KI': {'full': 'en-Latn-KI', 'region': 'KI', 'script': 'Latn', 'suppress': True},
        'en-KN': {'full': 'en-Latn-KN', 'region': 'KN', 'script': 'Latn', 'suppress': True},
        'en-KY': {'full': 'en-Latn-KY', 'region': 'KY', 'script': 'Latn', 'suppress': True},
        'en-LC': {'full': 'en-Latn-LC', 'region': 'LC', 'script': 'Latn', 'suppress': True},
        'en-LR': {'full': 'en-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': True},
        'en-LS': {'full': 'en-Latn-LS', 'region': 'LS', 'script': 'Latn', 'suppress': True},
        'en-MG': {'full': 'en-Latn-MG', 'region': 'MG', 'script': 'Latn', 'suppress': True},
        'en-MH': {'full': 'en-Latn-MH', 'region': 'MH', 'script': 'Latn', 'suppress': True},
        'en-MO': {'full': 'en-Latn-MO', 'region': 'MO', 'script': 'Latn', 'suppress': True},
        'en-MP': {'full': 'en-Latn-MP', 'region': 'MP', 'script': 'Latn', 'suppress': True},
        'en-MS': {'full': 'en-Latn-MS', 'region': 'MS', 'script': 'Latn', 'suppress': True},
        'en-MT': {'full': 'en-Latn-MT', 'region': 'MT', 'script': 'Latn', 'suppress': True},
        'en-MU': {'full': 'en-Latn-MU', 'region': 'MU', 'script': 'Latn', 'suppress': True},
        'en-MW': {'full': 'en-Latn-MW', 'region': 'MW', 'script': 'Latn', 'suppress': True},
        'en-MY': {'full': 'en-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': True},
        'en-NA': {'full': 'en-Latn-NA', 'region': 'NA', 'script': 'Latn', 'suppress': True},
        'en-NF': {'full': 'en-Latn-NF', 'region': 'NF', 'script': 'Latn', 'suppress': True},
        'en-NG': {'full': 'en-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': True},
        'en-NL': {'full': 'en-Latn-NL', 'region': 'NL', 'script': 'Latn', 'suppress': True},
        'en-NR': {'full': 'en-Latn-NR', 'region': 'NR', 'script': 'Latn', 'suppress': True},
        'en-NU': {'full': 'en-Latn-NU', 'region': 'NU', 'script': 'Latn', 'suppress': True},
        'en-NZ': {'full': 'en-Latn-NZ', 'region': 'NZ', 'script': 'Latn', 'suppress': True},
        'en-PG': {'full': 'en-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': True},
        'en-PH': {'full': 'en-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': True},
        'en-PK': {'full': 'en-Latn-PK', 'region': 'PK', 'script': 'Latn', 'suppress': True},
        'en-PN': {'full': 'en-Latn-PN', 'region': 'PN', 'script': 'Latn', 'suppress': True},
        'en-PW': {'full': 'en-Latn-PW', 'region': 'PW', 'script': 'Latn', 'suppress': True},
        'en-RW': {'full': 'en-Latn-RW', 'region': 'RW', 'script': 'Latn', 'suppress': True},
        'en-SB': {'full': 'en-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': True},
        'en-SC': {'full': 'en-Latn-SC', 'region': 'SC', 'script': 'Latn', 'suppress': True},
        'en-SD': {'full': 'en-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': True},
        'en-SE': {'full': 'en-Latn-SE', 'region': 'SE', 'script': 'Latn', 'suppress': True},
        'en-SG': {'full': 'en-Latn-SG', 'region': 'SG', 'script': 'Latn', 'suppress': True},
        'en-SH': {'full': 'en-Latn-SH', 'region': 'SH', 'script': 'Latn', 'suppress': True},
        'en-SI': {'full': 'en-Latn-SI', 'region': 'SI', 'script': 'Latn', 'suppress': True},
        'en-SL': {'full': 'en-Latn-SL', 'region': 'SL', 'script': 'Latn', 'suppress': True},
        'en-SS': {'full': 'en-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': True},
        'en-SX': {'full': 'en-Latn-SX', 'region': 'SX', 'script': 'Latn', 'suppress': True},
        'en-SZ': {'full': 'en-Latn-SZ', 'region': 'SZ', 'script': 'Latn', 'suppress': True},
        'en-Shaw': {'full': 'en-Shaw-GB', 'region': 'GB', 'script': 'Shaw', 'suppress': False},
        'en-TK': {'full': 'en-Latn-TK', 'region': 'TK', 'script': 'Latn', 'suppress': True},
        'en-TO': {'full': 'en-Latn-TO', 'region': 'TO', 'script': 'Latn', 'suppress': True},
        'en-TT': {'full': 'en-Latn-TT', 'region': 'TT', 'script': 'Latn', 'suppress': True},
        'en-TV': {'full': 'en-Latn-TV', 'region': 'TV', 'script': 'Latn', 'suppress': True},
        'en-TZ': {'full': 'en-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': True},
        'en-UG': {'full': 'en-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': True},
        'en-VC': {'full': 'en-Latn-VC', 'region': 'VC', 'script': 'Latn', 'suppress': True},
        'en-VU': {'full': 'en-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': True},
        'en-WS': {'full': 'en-Latn-WS', 'region': 'WS', 'script': 'Latn', 'suppress': True},
        'en-ZA': {'full': 'en-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': True},
        'en-ZM': {'full': 'en-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': True},
        'en-ZW': {'full': 'en-Latn-ZW', 'region': 'ZW', 'script': 'Latn', 'suppress': True},
        'ena': {'full': 'ena-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'enb': {'full': 'enb-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'enc': {'full': 'enc-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'end': {'full': 'end-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'enf': {'full': 'enf-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'enh': {'full': 'enh-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'enl': {'full': 'enl-Latn-PY', 'region': 'PY', 'script': 'Latn', 'suppress': False},
        'enm': {'full': 'enm-Latn-GB', 'region': 'GB', 'script': 'Latn', 'suppress': False},
        'enn': {'full': 'enn-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'eno': {'full': 'eno-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'enq': {'full': 'enq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'enr': {'full': 'enr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'enu': {'full': 'enu-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'env': {'full': 'env-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'enw': {'full': 'enw-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'enx': {'full': 'enx-Latn-PY', 'region': 'PY', 'script': 'Latn', 'suppress': False},
        'eo': {'full': 'eo-Latn-001', 'region': '001', 'script': 'Latn', 'suppress': True},
        'eot': {'full': 'eot-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'epi': {'full': 'epi-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'era': {'full': 'era-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'erg': {'full': 'erg-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'erh': {'full': 'erh-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'eri': {'full': 'eri-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'erk': {'full': 'erk-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'ero': {'full': 'ero-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'err': {'full': 'err-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ers': {'full': 'ers-Zzzz-CN-x-ersushab', 'region': 'CN', 'script': 'Zzzz', 'suppress': False},
        'ert': {'full': 'ert-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'erw': {'full': 'erw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'es': {'full': 'es-Latn-ES', 'region': 'ES', 'script': 'Latn', 'suppress': True},
        'es-419': {'full': 'es-Latn-419', 'region': '419', 'script': 'Latn', 'suppress': True},
        'es-AR': {'full': 'es-Latn-AR', 'region': 'AR', 'script': 'Latn', 'suppress': True},
        'es-BO': {'full': 'es-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': True},
        'es-BR': {'full': 'es-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': True},
        'es-BZ': {'full': 'es-Latn-BZ', 'region': 'BZ', 'script': 'Latn', 'suppress': True},
        'es-Brai': {'full': 'es-Brai-ES', 'region': 'ES', 'script': 'Brai', 'suppress': False},
        'es-CL': {'full': 'es-Latn-CL', 'region': 'CL', 'script': 'Latn', 'suppress': True},
        'es-CO': {'full': 'es-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': True},
        'es-CR': {'full': 'es-Latn-CR', 'region': 'CR', 'script': 'Latn', 'suppress': True},
        'es-CU': {'full': 'es-Latn-CU', 'region': 'CU', 'script': 'Latn', 'suppress': True},
        'es-DO': {'full': 'es-Latn-DO', 'region': 'DO', 'script': 'Latn', 'suppress': True},
        'es-Dupl': {'full': 'es-Dupl-ES', 'region': 'ES', 'script': 'Dupl', 'suppress': False},
        'es-EC': {'full': 'es-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': True},
        'es-GQ': {'full': 'es-Latn-GQ', 'region': 'GQ', 'script': 'Latn', 'suppress': True},
        'es-GT': {'full': 'es-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': True},
        'es-HN': {'full': 'es-Latn-HN', 'region': 'HN', 'script': 'Latn', 'suppress': True},
        'es-MX': {'full': 'es-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': True},
        'es-NI': {'full': 'es-Latn-NI', 'region': 'NI', 'script': 'Latn', 'suppress': True},
        'es-PA': {'full': 'es-Latn-PA', 'region': 'PA', 'script': 'Latn', 'suppress': True},
        'es-PE': {'full': 'es-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': True},
        'es-PH': {'full': 'es-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': True},
        'es-PR': {'full': 'es-Latn-PR', 'region': 'PR', 'script': 'Latn', 'suppress': True},
        'es-PY': {'full': 'es-Latn-PY', 'region': 'PY', 'script': 'Latn', 'suppress': True},
        'es-SV': {'full': 'es-Latn-SV', 'region': 'SV', 'script': 'Latn', 'suppress': True},
        'es-US': {'full': 'es-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': True},
        'es-UY': {'full': 'es-Latn-UY', 'region': 'UY', 'script': 'Latn', 'suppress': True},
        'es-VE': {'full': 'es-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': True},
        'ese': {'full': 'ese-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'esg': {'full': 'esg-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'esg-Gonm': {'full': 'esg-Gonm-IN', 'region': 'IN', 'script': 'Gonm', 'suppress': False},
        'esg-Telu': {'full': 'esg-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'esh': {'full': 'esh-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'esi': {'full': 'esi-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'esl': {'full': 'esl-Zxxx-EG', 'region': 'EG', 'script': 'Zxxx', 'suppress': False},
        'esm': {'full': 'esm-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'esn': {'full': 'esn-Zxxx-SV', 'region': 'SV', 'script': 'Zxxx', 'suppress': False},
        'eso': {'full': 'eso-Zxxx-EE', 'region': 'EE', 'script': 'Zxxx', 'suppress': False},
        'esq': {'full': 'esq-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'ess': {'full': 'ess-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'ess-Cyrl': {'full': 'ess-Cyrl-US', 'region': 'US', 'script': 'Cyrl', 'suppress': False},
        'esu': {'full': 'esu-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'esy': {'full': 'esy-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'esy-Zzzz-x-eskaya': {'full': 'esy-Zzzz-PH-x-eskaya', 'region': 'PH', 'script': 'Zzzz', 'suppress': False},
        'et': {'full': 'et-Latn-EE', 'region': 'EE', 'script': 'Latn', 'suppress': True},
        'et-Brai': {'full': 'et-Brai-EE', 'region': 'EE', 'script': 'Brai', 'suppress': False},
        'etb': {'full': 'etb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'etc': {'full': 'etc-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'eth': {'full': 'eth-Zxxx-ET', 'region': 'ET', 'script': 'Zxxx', 'suppress': False},
        'etn': {'full': 'etn-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'eto': {'full': 'eto-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'etr': {'full': 'etr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ets': {'full': 'ets-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ett': {'full': 'ett-Ital-IT', 'region': 'IT', 'script': 'Ital', 'suppress': False},
        'ett-Latn': {'full': 'ett-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'etu': {'full': 'etu-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'etx': {'full': 'etx-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'etz': {'full': 'etz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'eu': {'full': 'eu-Latn-ES', 'region': 'ES', 'script': 'Latn', 'suppress': True},
        'eve': {'full': 'eve-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'evh': {'full': 'evh-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'evn': {'full': 'evn-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'evn-Latn': {'full': 'evn-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'evn-Mong': {'full': 'evn-Mong-CN', 'region': 'CN', 'script': 'Mong', 'suppress': False},
        'ewo': {'full': 'ewo-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'ext': {'full': 'ext-Latn-ES', 'region': 'ES', 'script': 'Latn', 'suppress': False},
        'eya': {'full': 'eya-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'eyo': {'full': 'eyo-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'eza': {'full': 'eza-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'eze': {'full': 'eze-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'fa': {'full': 'fa-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': True},
        'fa-AF': {'full': 'fa-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': True},
        'faa': {'full': 'faa-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'fab': {'full': 'fab-Latn-GQ', 'region': 'GQ', 'script': 'Latn', 'suppress': False},
        'fad': {'full': 'fad-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'faf': {'full': 'faf-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'fag': {'full': 'fag-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'fah': {'full': 'fah-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'fai': {'full': 'fai-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'faj': {'full': 'faj-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'fak': {'full': 'fak-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'fal': {'full': 'fal-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'fam': {'full': 'fam-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'fan': {'full': 'fan-Latn-GQ', 'region': 'GQ', 'script': 'Latn', 'suppress': False},
        'fap': {'full': 'fap-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'far': {'full': 'far-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'fau': {'full': 'fau-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'fax': {'full': 'fax-Latn-ES', 'region': 'ES', 'script': 'Latn', 'suppress': False},
        'fay': {'full': 'fay-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'faz': {'full': 'faz-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'fbl': {'full': 'fbl-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'fcs': {'full': 'fcs-Zxxx-CA', 'region': 'CA', 'script': 'Zxxx', 'suppress': False},
        'fer': {'full': 'fer-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'ff': {'full': 'ff-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'ff-Adlm': {'full': 'ff-Adlm-GN', 'region': 'GN', 'script': 'Adlm', 'suppress': False},
        'ff-Arab': {'full': 'ff-Arab-SN', 'region': 'SN', 'script': 'Arab', 'suppress': False},
        'ff-GH': {'full': 'ff-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'ff-GM': {'full': 'ff-Latn-GM', 'region': 'GM', 'script': 'Latn', 'suppress': False},
        'ff-GN': {'full': 'ff-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'ff-LR': {'full': 'ff-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'ff-MR': {'full': 'ff-Latn-MR', 'region': 'MR', 'script': 'Latn', 'suppress': False},
        'ff-NG': {'full': 'ff-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ff-SL': {'full': 'ff-Latn-SL', 'region': 'SL', 'script': 'Latn', 'suppress': False},
        'ffi': {'full': 'ffi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ffm': {'full': 'ffm-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'ffm-Arab': {'full': 'ffm-Arab-ML', 'region': 'ML', 'script': 'Arab', 'suppress': False},
        'fgr': {'full': 'fgr-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'fi': {'full': 'fi-Latn-FI', 'region': 'FI', 'script': 'Latn', 'suppress': True},
        'fi-Brai': {'full': 'fi-Brai-FI', 'region': 'FI', 'script': 'Brai', 'suppress': False},
        'fia': {'full': 'fia-Arab-SD', 'region': 'SD', 'script': 'Arab', 'suppress': False},
        'fia-Copt': {'full': 'fia-Copt-SD-x-olnubian', 'region': 'SD', 'script': 'Copt', 'suppress': False},
        'fia-Latn': {'full': 'fia-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'fie': {'full': 'fie-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'fil': {'full': 'fil-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'fil-Tglg': {'full': 'fil-Tglg-PH', 'region': 'PH', 'script': 'Tglg', 'suppress': False},
        'fip': {'full': 'fip-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'fir': {'full': 'fir-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'fit': {'full': 'fit-Latn-SE', 'region': 'SE', 'script': 'Latn', 'suppress': False},
        'fiw': {'full': 'fiw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'fj': {'full': 'fj-Latn-FJ', 'region': 'FJ', 'script': 'Latn', 'suppress': True},
        'fkk': {'full': 'fkk-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'fkv': {'full': 'fkv-Latn-NO', 'region': 'NO', 'script': 'Latn', 'suppress': False},
        'fla': {'full': 'fla-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'flh': {'full': 'flh-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'fli': {'full': 'fli-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'fll': {'full': 'fll-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'fln': {'full': 'fln-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'flr': {'full': 'flr-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'fly': {'full': 'fly-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': False},
        'fmp': {'full': 'fmp-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'fmu': {'full': 'fmu-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'fnb': {'full': 'fnb-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'fng': {'full': 'fng-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': False},
        'fni': {'full': 'fni-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'fo': {'full': 'fo-Latn-FO', 'region': 'FO', 'script': 'Latn', 'suppress': True},
        'fo-DK': {'full': 'fo-Latn-DK', 'region': 'DK', 'script': 'Latn', 'suppress': True},
        'fod': {'full': 'fod-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'foi': {'full': 'foi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'fom': {'full': 'fom-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'fon': {'full': 'fon-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'for': {'full': 'for-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'fos': {'full': 'fos-Latn-TW', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'fpe': {'full': 'fpe-Latn-GQ', 'region': 'GQ', 'script': 'Latn', 'suppress': False},
        'fqs': {'full': 'fqs-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'fr': {'full': 'fr-Latn-FR', 'region': 'FR', 'script': 'Latn', 'suppress': True},
        'fr-BE': {'full': 'fr-Latn-BE', 'region': 'BE', 'script': 'Latn', 'suppress': True},
        'fr-BI': {'full': 'fr-Latn-BI', 'region': 'BI', 'script': 'Latn', 'suppress': True},
        'fr-Brai': {'full': 'fr-Brai-FR', 'region': 'FR', 'script': 'Brai', 'suppress': False},
        'fr-CA': {'full': 'fr-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': True},
        'fr-CD': {'full': 'fr-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': True},
        'fr-CH': {'full': 'fr-Latn-CH', 'region': 'CH', 'script': 'Latn', 'suppress': True},
        'fr-CI': {'full': 'fr-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': True},
        'fr-CM': {'full': 'fr-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': True},
        'fr-DJ': {'full': 'fr-Latn-DJ', 'region': 'DJ', 'script': 'Latn', 'suppress': True},
        'fr-DZ': {'full': 'fr-Latn-DZ', 'region': 'DZ', 'script': 'Latn', 'suppress': True},
        'fr-Dupl': {'full': 'fr-Dupl-FR', 'region': 'FR', 'script': 'Dupl', 'suppress': False},
        'fr-GF': {'full': 'fr-Latn-GF', 'region': 'GF', 'script': 'Latn', 'suppress': True},
        'fr-GN': {'full': 'fr-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': True},
        'fr-HT': {'full': 'fr-Latn-HT', 'region': 'HT', 'script': 'Latn', 'suppress': True},
        'fr-KM': {'full': 'fr-Latn-KM', 'region': 'KM', 'script': 'Latn', 'suppress': True},
        'fr-LU': {'full': 'fr-Latn-LU', 'region': 'LU', 'script': 'Latn', 'suppress': True},
        'fr-MA': {'full': 'fr-Latn-MA', 'region': 'MA', 'script': 'Latn', 'suppress': True},
        'fr-MG': {'full': 'fr-Latn-MG', 'region': 'MG', 'script': 'Latn', 'suppress': True},
        'fr-ML': {'full': 'fr-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': True},
        'fr-MR': {'full': 'fr-Latn-MR', 'region': 'MR', 'script': 'Latn', 'suppress': True},
        'fr-MU': {'full': 'fr-Latn-MU', 'region': 'MU', 'script': 'Latn', 'suppress': True},
        'fr-RE': {'full': 'fr-Latn-RE', 'region': 'RE', 'script': 'Latn', 'suppress': True},
        'fr-RW': {'full': 'fr-Latn-RW', 'region': 'RW', 'script': 'Latn', 'suppress': True},
        'fr-SC': {'full': 'fr-Latn-SC', 'region': 'SC', 'script': 'Latn', 'suppress': True},
        'fr-SN': {'full': 'fr-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': True},
        'fr-SY': {'full': 'fr-Latn-SY', 'region': 'SY', 'script': 'Latn', 'suppress': True},
        'fr-TD': {'full': 'fr-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': True},
        'fr-TN': {'full': 'fr-Latn-TN', 'region': 'TN', 'script': 'Latn', 'suppress': True},
        'fr-VU': {'full': 'fr-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': True},
        'frc': {'full': 'frc-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'frd': {'full': 'frd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'frk': {'full': 'frk-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': False},
        'frm': {'full': 'frm-Latn-FR', 'region': 'FR', 'script': 'Latn', 'suppress': False},
        'fro': {'full': 'fro-Latn-FR', 'region': 'FR', 'script': 'Latn', 'suppress': False},
        'frp': {'full': 'frp-Latn-FR', 'region': 'FR', 'script': 'Latn', 'suppress': False},
        'frq': {'full': 'frq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'frr': {'full': 'frr-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': True},
        'frs': {'full': 'frs-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': True},
        'frt': {'full': 'frt-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'fse': {'full': 'fse-Zxxx-FI', 'region': 'FI', 'script': 'Zxxx', 'suppress': False},
        'fsl': {'full': 'fsl-Zxxx-FR', 'region': 'FR', 'script': 'Zxxx', 'suppress': False},
        'fss': {'full': 'fss-Zxxx-FI', 'region': 'FI', 'script': 'Zxxx', 'suppress': False},
        'fub': {'full': 'fub-Arab-CM', 'region': 'CM', 'script': 'Arab', 'suppress': False},
        'fub-Latn': {'full': 'fub-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'fud': {'full': 'fud-Latn-WF', 'region': 'WF', 'script': 'Latn', 'suppress': False},
        'fue': {'full': 'fue-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'fuf': {'full': 'fuf-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'fuf-Adlm': {'full': 'fuf-Adlm-GN', 'region': 'GN', 'script': 'Adlm', 'suppress': False},
        'fuf-Arab': {'full': 'fuf-Arab-GN', 'region': 'GN', 'script': 'Arab', 'suppress': False},
        'fuh-Arab': {'full': 'fuh-Arab-NE', 'region': 'NE', 'script': 'Arab', 'suppress': False},
        'fuh-BF': {'full': 'fuh-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'fuh-Latn': {'full': 'fuh-Latn-NE', 'region': 'NE', 'script': 'Latn', 'suppress': False},
        'fui': {'full': 'fui-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'fuj': {'full': 'fuj-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'fum': {'full': 'fum-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'fun': {'full': 'fun-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'fuq': {'full': 'fuq-Latn-NE', 'region': 'NE', 'script': 'Latn', 'suppress': False},
        'fur': {'full': 'fur-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'fut': {'full': 'fut-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'fuu': {'full': 'fuu-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'fuv': {'full': 'fuv-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'fuv-Arab': {'full': 'fuv-Arab-NG', 'region': 'NG', 'script': 'Arab', 'suppress': False},
        'fuy': {'full': 'fuy-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'fvr': {'full': 'fvr-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'fwa': {'full': 'fwa-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'fwe': {'full': 'fwe-Latn-NA', 'region': 'NA', 'script': 'Latn', 'suppress': False},
        'fy': {'full': 'fy-Latn-NL', 'region': 'NL', 'script': 'Latn', 'suppress': True},
        'ga': {'full': 'ga-Latn-IE', 'region': 'IE', 'script': 'Latn', 'suppress': True},
        'ga-Latg': {'full': 'ga-Latg-IE', 'region': 'IE', 'script': 'Latg', 'suppress': False},
        'ga-Ogam': {'full': 'ga-Ogam-IE', 'region': 'IE', 'script': 'Ogam', 'suppress': False},
        'gaa': {'full': 'gaa-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'gaa-Arab': {'full': 'gaa-Arab-GH', 'region': 'GH', 'script': 'Arab', 'suppress': False},
        'gab': {'full': 'gab-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'gac': {'full': 'gac-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'gad': {'full': 'gad-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'gae': {'full': 'gae-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'gaf': {'full': 'gaf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gag': {'full': 'gag-Latn-MD', 'region': 'MD', 'script': 'Latn', 'suppress': False},
        'gag-Cyrl': {'full': 'gag-Cyrl-MD', 'region': 'MD', 'script': 'Cyrl', 'suppress': False},
        'gag-Grek': {'full': 'gag-Grek-MD', 'region': 'MD', 'script': 'Grek', 'suppress': False},
        'gah': {'full': 'gah-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gai': {'full': 'gai-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gaj': {'full': 'gaj-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gak': {'full': 'gak-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'gal': {'full': 'gal-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'gam': {'full': 'gam-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gan': {'full': 'gan-Hans-CN', 'region': 'CN', 'script': 'Hans', 'suppress': False},
        'gan-Hant': {'full': 'gan-Hant-CN', 'region': 'CN', 'script': 'Hant', 'suppress': False},
        'gan-Latn': {'full': 'gan-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'gao': {'full': 'gao-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gap': {'full': 'gap-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gaq': {'full': 'gaq-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'gar': {'full': 'gar-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gas': {'full': 'gas-Gujr-IN', 'region': 'IN', 'script': 'Gujr', 'suppress': False},
        'gat': {'full': 'gat-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gau': {'full': 'gau-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'gaw': {'full': 'gaw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gax': {'full': 'gax-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'gax-Ethi': {'full': 'gax-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'gax-Ethi-x-borana': {'full': 'gax-Ethi-ET-x-borana', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'gax-Ethi-x-guji': {'full': 'gax-Ethi-ET-x-guji', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'gay': {'full': 'gay-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'gba': {'full': 'gba-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'gba-Arab': {'full': 'gba-Arab-CF', 'region': 'CF', 'script': 'Arab', 'suppress': False},
        'gbb': {'full': 'gbb-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gbd': {'full': 'gbd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gbe': {'full': 'gbe-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gbf': {'full': 'gbf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gbg': {'full': 'gbg-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'gbh': {'full': 'gbh-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'gbi': {'full': 'gbi-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'gbj': {'full': 'gbj-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'gbk': {'full': 'gbk-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'gbk-Takr': {'full': 'gbk-Takr-IN', 'region': 'IN', 'script': 'Takr', 'suppress': False},
        'gbl': {'full': 'gbl-Gujr-IN', 'region': 'IN', 'script': 'Gujr', 'suppress': False},
        'gbl-Deva': {'full': 'gbl-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'gbm': {'full': 'gbm-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'gbn': {'full': 'gbn-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'gbp': {'full': 'gbp-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'gbq': {'full': 'gbq-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'gbr': {'full': 'gbr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gbs': {'full': 'gbs-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'gbu': {'full': 'gbu-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gbv': {'full': 'gbv-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'gbw': {'full': 'gbw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gbx': {'full': 'gbx-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'gby': {'full': 'gby-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gbz': {'full': 'gbz-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'gcc': {'full': 'gcc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gcd': {'full': 'gcd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gce': {'full': 'gce-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'gcf': {'full': 'gcf-Latn-GP', 'region': 'GP', 'script': 'Latn', 'suppress': False},
        'gcl': {'full': 'gcl-Latn-GD', 'region': 'GD', 'script': 'Latn', 'suppress': False},
        'gcn': {'full': 'gcn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gcr': {'full': 'gcr-Latn-GF', 'region': 'GF', 'script': 'Latn', 'suppress': False},
        'gct': {'full': 'gct-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'gd': {'full': 'gd-Latn-GB', 'region': 'GB', 'script': 'Latn', 'suppress': False},
        'gda': {'full': 'gda-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'gdb': {'full': 'gdb-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'gdb-Telu': {'full': 'gdb-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'gdc': {'full': 'gdc-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gdd': {'full': 'gdd-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gde': {'full': 'gde-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gdf': {'full': 'gdf-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gdg': {'full': 'gdg-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'gdh': {'full': 'gdh-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gdi': {'full': 'gdi-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'gdj': {'full': 'gdj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gdk': {'full': 'gdk-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'gdl': {'full': 'gdl-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'gdl-Ethi': {'full': 'gdl-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'gdm': {'full': 'gdm-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'gdn': {'full': 'gdn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gdo': {'full': 'gdo-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'gdq': {'full': 'gdq-Latn-YE', 'region': 'YE', 'script': 'Latn', 'suppress': False},
        'gdr': {'full': 'gdr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gds': {'full': 'gds-Zxxx-NP', 'region': 'NP', 'script': 'Zxxx', 'suppress': False},
        'gdt': {'full': 'gdt-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gdu': {'full': 'gdu-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gdx': {'full': 'gdx-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'gea': {'full': 'gea-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'geb': {'full': 'geb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gec': {'full': 'gec-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'ged': {'full': 'ged-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gef': {'full': 'gef-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'geg': {'full': 'geg-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'geh': {'full': 'geh-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'gei': {'full': 'gei-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'gej': {'full': 'gej-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'gek': {'full': 'gek-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gel': {'full': 'gel-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'geq': {'full': 'geq-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'ges': {'full': 'ges-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'gev': {'full': 'gev-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'gew': {'full': 'gew-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gex': {'full': 'gex-Zyyy-SO', 'region': 'SO', 'script': 'Zyyy', 'suppress': False},
        'gey': {'full': 'gey-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'gez': {'full': 'gez-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'gfk': {'full': 'gfk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gft': {'full': 'gft-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'gga': {'full': 'gga-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'ggb': {'full': 'ggb-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'ggd': {'full': 'ggd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gge': {'full': 'gge-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ggg': {'full': 'ggg-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'ggk': {'full': 'ggk-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ggl': {'full': 'ggl-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ggt': {'full': 'ggt-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ggu': {'full': 'ggu-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'ggw': {'full': 'ggw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gha': {'full': 'gha-Zyyy-LY', 'region': 'LY', 'script': 'Zyyy', 'suppress': False},
        'ghc': {'full': 'ghc-Latn-GB', 'region': 'GB', 'script': 'Latn', 'suppress': False},
        'ghe': {'full': 'ghe-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'ghh': {'full': 'ghh-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'ghk': {'full': 'ghk-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'ghl': {'full': 'ghl-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'ghn': {'full': 'ghn-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'gho': {'full': 'gho-Zyyy-MA', 'region': 'MA', 'script': 'Zyyy', 'suppress': False},
        'ghr': {'full': 'ghr-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'ghs': {'full': 'ghs-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ght': {'full': 'ght-Tibt-NP', 'region': 'NP', 'script': 'Tibt', 'suppress': False},
        'gia': {'full': 'gia-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gib': {'full': 'gib-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gic': {'full': 'gic-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': False},
        'gid': {'full': 'gid-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'gie': {'full': 'gie-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'gig': {'full': 'gig-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'gih': {'full': 'gih-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gil': {'full': 'gil-Latn-KI', 'region': 'KI', 'script': 'Latn', 'suppress': False},
        'gim': {'full': 'gim-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gin': {'full': 'gin-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'gip': {'full': 'gip-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'giq': {'full': 'giq-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'gir': {'full': 'gir-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'gis': {'full': 'gis-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'git': {'full': 'git-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'giu': {'full': 'giu-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'giw': {'full': 'giw-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'gix': {'full': 'gix-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'giy': {'full': 'giy-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'giz': {'full': 'giz-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'gji': {'full': 'gji-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gjk': {'full': 'gjk-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'gjk-Gujr': {'full': 'gjk-Gujr-PK', 'region': 'PK', 'script': 'Gujr', 'suppress': False},
        'gjm': {'full': 'gjm-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gjn': {'full': 'gjn-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'gjn-Arab': {'full': 'gjn-Arab-GH', 'region': 'GH', 'script': 'Arab', 'suppress': False},
        'gjr': {'full': 'gjr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gju': {'full': 'gju-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'gju-Deva': {'full': 'gju-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'gka': {'full': 'gka-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gkd': {'full': 'gkd-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gke': {'full': 'gke-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'gkn': {'full': 'gkn-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gko': {'full': 'gko-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gkp': {'full': 'gkp-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'gku': {'full': 'gku-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': False},
        'gl': {'full': 'gl-Latn-ES', 'region': 'ES', 'script': 'Latn', 'suppress': True},
        'glc': {'full': 'glc-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'gld': {'full': 'gld-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'glh': {'full': 'glh-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'glj': {'full': 'glj-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'glk': {'full': 'glk-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'glk-Latn': {'full': 'glk-Latn-IR', 'region': 'IR', 'script': 'Latn', 'suppress': False},
        'gll': {'full': 'gll-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'glo': {'full': 'glo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'glr': {'full': 'glr-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'glu': {'full': 'glu-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'glw': {'full': 'glw-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gly': {'full': 'gly-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'gma': {'full': 'gma-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gmb': {'full': 'gmb-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'gmd': {'full': 'gmd-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gmg': {'full': 'gmg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gmh': {'full': 'gmh-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': False},
        'gml': {'full': 'gml-Latf-DE', 'region': 'DE', 'script': 'Latf', 'suppress': False},
        'gmm': {'full': 'gmm-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'gmn': {'full': 'gmn-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'gmr': {'full': 'gmr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gmu': {'full': 'gmu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gmv': {'full': 'gmv-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'gmv-Latn': {'full': 'gmv-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'gmx': {'full': 'gmx-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'gmy': {'full': 'gmy-Zyyy-GR', 'region': 'GR', 'script': 'Zyyy', 'suppress': False},
        'gmz': {'full': 'gmz-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gn': {'full': 'gn-Latn-PY', 'region': 'PY', 'script': 'Latn', 'suppress': True},
        'gna': {'full': 'gna-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'gnb': {'full': 'gnb-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'gnc': {'full': 'gnc-Latn-ES', 'region': 'ES', 'script': 'Latn', 'suppress': False},
        'gnd': {'full': 'gnd-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'gne': {'full': 'gne-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gng': {'full': 'gng-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'gnh': {'full': 'gnh-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gni': {'full': 'gni-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gnj': {'full': 'gnj-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'gnk': {'full': 'gnk-Latn-BW', 'region': 'BW', 'script': 'Latn', 'suppress': False},
        'gnl': {'full': 'gnl-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gnm': {'full': 'gnm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gnn': {'full': 'gnn-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gnq': {'full': 'gnq-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'gnr': {'full': 'gnr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gnt': {'full': 'gnt-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gnu': {'full': 'gnu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gnw': {'full': 'gnw-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'gnz': {'full': 'gnz-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'goa': {'full': 'goa-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'gob': {'full': 'gob-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'goc': {'full': 'goc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'god': {'full': 'god-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'goe': {'full': 'goe-Zyyy-BT', 'region': 'BT', 'script': 'Zyyy', 'suppress': False},
        'gof': {'full': 'gof-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'gof-Latn': {'full': 'gof-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'gog': {'full': 'gog-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'goh': {'full': 'goh-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': False},
        'goi': {'full': 'goi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'goj': {'full': 'goj-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'gok': {'full': 'gok-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'gol': {'full': 'gol-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'gom': {'full': 'gom-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'gom-Knda': {'full': 'gom-Knda-IN', 'region': 'IN', 'script': 'Knda', 'suppress': False},
        'gom-Latn': {'full': 'gom-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'gon': {'full': 'gon-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'gon-Deva': {'full': 'gon-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'gon-Gonm': {'full': 'gon-Gonm-IN', 'region': 'IN', 'script': 'Gonm', 'suppress': False},
        'goo': {'full': 'goo-Latn-FJ', 'region': 'FJ', 'script': 'Latn', 'suppress': False},
        'gop': {'full': 'gop-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'goq': {'full': 'goq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'gor': {'full': 'gor-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'gos': {'full': 'gos-Latn-NL', 'region': 'NL', 'script': 'Latn', 'suppress': False},
        'got': {'full': 'got-Goth-UA', 'region': 'UA', 'script': 'Goth', 'suppress': False},
        'gou': {'full': 'gou-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'gow': {'full': 'gow-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'gox': {'full': 'gox-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'goy': {'full': 'goy-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'goz': {'full': 'goz-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'gpa': {'full': 'gpa-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gpe': {'full': 'gpe-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'gpn': {'full': 'gpn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gqa': {'full': 'gqa-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gqi': {'full': 'gqi-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'gqn': {'full': 'gqn-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'gqr': {'full': 'gqr-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'gqu': {'full': 'gqu-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'gra-Deva': {'full': 'gra-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'gra-Gujr': {'full': 'gra-Gujr-IN', 'region': 'IN', 'script': 'Gujr', 'suppress': False},
        'grb': {'full': 'grb-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'grc': {'full': 'grc-Cprt-CY', 'region': 'CY', 'script': 'Cprt', 'suppress': False},
        'grc-Grek': {'full': 'grc-Grek-GR', 'region': 'GR', 'script': 'Grek', 'suppress': False},
        'grc-Linb': {'full': 'grc-Linb-GR', 'region': 'GR', 'script': 'Linb', 'suppress': False},
        'grd': {'full': 'grd-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'grg': {'full': 'grg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'grh': {'full': 'grh-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gri': {'full': 'gri-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'grj': {'full': 'grj-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'grm': {'full': 'grm-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'gro': {'full': 'gro-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'grq': {'full': 'grq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'grr': {'full': 'grr-Zyyy-DZ', 'region': 'DZ', 'script': 'Zyyy', 'suppress': False},
        'grs': {'full': 'grs-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'grt': {'full': 'grt-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'grt-Brai': {'full': 'grt-Brai-IN', 'region': 'IN', 'script': 'Brai', 'suppress': False},
        'grt-Latn': {'full': 'grt-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'gru': {'full': 'gru-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'gru-Latn': {'full': 'gru-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'grv': {'full': 'grv-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'grw': {'full': 'grw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'grx': {'full': 'grx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gry': {'full': 'gry-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'grz': {'full': 'grz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gse': {'full': 'gse-Zxxx-GH', 'region': 'GH', 'script': 'Zxxx', 'suppress': False},
        'gsg': {'full': 'gsg-Zxxx-DE', 'region': 'DE', 'script': 'Zxxx', 'suppress': False},
        'gsl': {'full': 'gsl-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'gsm': {'full': 'gsm-Zxxx-GT', 'region': 'GT', 'script': 'Zxxx', 'suppress': False},
        'gsn': {'full': 'gsn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gso': {'full': 'gso-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'gsp': {'full': 'gsp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gss': {'full': 'gss-Zxxx-GR', 'region': 'GR', 'script': 'Zxxx', 'suppress': False},
        'gsw': {'full': 'gsw-Latn-CH', 'region': 'CH', 'script': 'Latn', 'suppress': True},
        'gta': {'full': 'gta-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'gtu': {'full': 'gtu-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gu': {'full': 'gu-Gujr-IN', 'region': 'IN', 'script': 'Gujr', 'suppress': True},
        'gu-Brai': {'full': 'gu-Brai-IN', 'region': 'IN', 'script': 'Brai', 'suppress': False},
        'gu-Khoj': {'full': 'gu-Khoj-IN', 'region': 'IN', 'script': 'Khoj', 'suppress': False},
        'gua': {'full': 'gua-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gub': {'full': 'gub-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'guc': {'full': 'guc-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'gud': {'full': 'gud-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'gue': {'full': 'gue-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'guf': {'full': 'guf-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'guh': {'full': 'guh-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'gui': {'full': 'gui-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'guk': {'full': 'guk-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'guk-Ethi': {'full': 'guk-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'gul': {'full': 'gul-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'gum': {'full': 'gum-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'gun': {'full': 'gun-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'guo': {'full': 'guo-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'gup': {'full': 'gup-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'guq': {'full': 'guq-Latn-PY', 'region': 'PY', 'script': 'Latn', 'suppress': False},
        'gur': {'full': 'gur-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'gus': {'full': 'gus-Zxxx-GN', 'region': 'GN', 'script': 'Zxxx', 'suppress': False},
        'gut': {'full': 'gut-Latn-CR', 'region': 'CR', 'script': 'Latn', 'suppress': False},
        'guu': {'full': 'guu-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'guw': {'full': 'guw-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'gux': {'full': 'gux-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'guz': {'full': 'guz-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'gv': {'full': 'gv-Latn-IM', 'region': 'IM', 'script': 'Latn', 'suppress': True},
        'gva': {'full': 'gva-Latn-PY', 'region': 'PY', 'script': 'Latn', 'suppress': False},
        'gvc': {'full': 'gvc-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'gve': {'full': 'gve-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gvf': {'full': 'gvf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gvj': {'full': 'gvj-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'gvl': {'full': 'gvl-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'gvm': {'full': 'gvm-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gvn': {'full': 'gvn-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gvo': {'full': 'gvo-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'gvp': {'full': 'gvp-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'gvr': {'full': 'gvr-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'gvr-Latn': {'full': 'gvr-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'gvs': {'full': 'gvs-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gvy': {'full': 'gvy-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gwa': {'full': 'gwa-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'gwb': {'full': 'gwb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gwc': {'full': 'gwc-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'gwd': {'full': 'gwd-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'gwe': {'full': 'gwe-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'gwf': {'full': 'gwf-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'gwg': {'full': 'gwg-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gwi': {'full': 'gwi-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'gwj': {'full': 'gwj-Latn-BW', 'region': 'BW', 'script': 'Latn', 'suppress': False},
        'gwm': {'full': 'gwm-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gwn': {'full': 'gwn-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gwr': {'full': 'gwr-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'gwt': {'full': 'gwt-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'gwu': {'full': 'gwu-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gww': {'full': 'gww-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gwx': {'full': 'gwx-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'gxx': {'full': 'gxx-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'gyb': {'full': 'gyb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'gyd': {'full': 'gyd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gye': {'full': 'gye-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'gyf': {'full': 'gyf-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gyg': {'full': 'gyg-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'gyi': {'full': 'gyi-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'gyl': {'full': 'gyl-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'gym': {'full': 'gym-Latn-PA', 'region': 'PA', 'script': 'Latn', 'suppress': False},
        'gyn': {'full': 'gyn-Latn-GY', 'region': 'GY', 'script': 'Latn', 'suppress': False},
        'gyo': {'full': 'gyo-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'gyr': {'full': 'gyr-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'gyy': {'full': 'gyy-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'gza': {'full': 'gza-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'gzi': {'full': 'gzi-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'gzn': {'full': 'gzn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ha': {'full': 'ha-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ha-Arab': {'full': 'ha-Arab-NG', 'region': 'NG', 'script': 'Arab', 'suppress': False},
        'ha-Brai': {'full': 'ha-Brai-NG', 'region': 'NG', 'script': 'Brai', 'suppress': False},
        'ha-CM': {'full': 'ha-Arab-CM', 'region': 'CM', 'script': 'Arab', 'suppress': False},
        'ha-GH': {'full': 'ha-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'ha-NE': {'full': 'ha-Arab-NE', 'region': 'NE', 'script': 'Arab', 'suppress': False},
        'ha-SD': {'full': 'ha-Arab-SD', 'region': 'SD', 'script': 'Arab', 'suppress': False},
        'haa': {'full': 'haa-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'hab': {'full': 'hab-Zxxx-VN', 'region': 'VN', 'script': 'Zxxx', 'suppress': False},
        'hac': {'full': 'hac-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'had': {'full': 'had-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'hae': {'full': 'hae-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'haf': {'full': 'haf-Zxxx-VN', 'region': 'VN', 'script': 'Zxxx', 'suppress': False},
        'hag': {'full': 'hag-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'hah': {'full': 'hah-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'hai': {'full': 'hai-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'haj': {'full': 'haj-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'haj-Beng': {'full': 'haj-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'hak': {'full': 'hak-Hans-CN', 'region': 'CN', 'script': 'Hans', 'suppress': False},
        'hak-Hant': {'full': 'hak-Hant-CN', 'region': 'CN', 'script': 'Hant', 'suppress': False},
        'hak-Latn': {'full': 'hak-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'hal': {'full': 'hal-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'ham': {'full': 'ham-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'han': {'full': 'han-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'hao': {'full': 'hao-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'hap': {'full': 'hap-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'haq': {'full': 'haq-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'har': {'full': 'har-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'har-Arab': {'full': 'har-Arab-ET', 'region': 'ET', 'script': 'Arab', 'suppress': False},
        'har-Latn': {'full': 'har-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'has': {'full': 'has-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'hav': {'full': 'hav-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'haw': {'full': 'haw-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'hax': {'full': 'hax-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'hay': {'full': 'hay-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'haz': {'full': 'haz-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'hba': {'full': 'hba-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'hbb': {'full': 'hbb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'hbn': {'full': 'hbn-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'hbo': {'full': 'hbo-Hebr-IL', 'region': 'IL', 'script': 'Hebr', 'suppress': False},
        'hbu': {'full': 'hbu-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'hca': {'full': 'hca-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'hch': {'full': 'hch-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'hds': {'full': 'hds-Zxxx-HN', 'region': 'HN', 'script': 'Zxxx', 'suppress': False},
        'hdy': {'full': 'hdy-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'hdy-Latn': {'full': 'hdy-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'he': {'full': 'he-Hebr-IL', 'region': 'IL', 'script': 'Hebr', 'suppress': True},
        'he-Brai': {'full': 'he-Brai-IL', 'region': 'IL', 'script': 'Brai', 'suppress': False},
        'hed': {'full': 'hed-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'heg': {'full': 'heg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'heh': {'full': 'heh-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'hei': {'full': 'hei-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'hem': {'full': 'hem-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'hgm': {'full': 'hgm-Latn-NA', 'region': 'NA', 'script': 'Latn', 'suppress': False},
        'hgw': {'full': 'hgw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'hhi': {'full': 'hhi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'hhr': {'full': 'hhr-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'hhy': {'full': 'hhy-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'hi': {'full': 'hi-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': True},
        'hi-Brai': {'full': 'hi-Brai-IN', 'region': 'IN', 'script': 'Brai', 'suppress': False},
        'hi-Mahj': {'full': 'hi-Mahj-IN', 'region': 'IN', 'script': 'Mahj', 'suppress': False},
        'hi-Newa': {'full': 'hi-Newa-IN', 'region': 'IN', 'script': 'Newa', 'suppress': False},
        'hia': {'full': 'hia-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'hib': {'full': 'hib-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'hid': {'full': 'hid-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'hif': {'full': 'hif-Latn-FJ', 'region': 'FJ', 'script': 'Latn', 'suppress': False},
        'hif-Deva': {'full': 'hif-Deva-FJ', 'region': 'FJ', 'script': 'Deva', 'suppress': False},
        'hig': {'full': 'hig-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'hih': {'full': 'hih-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'hii': {'full': 'hii-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'hij': {'full': 'hij-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'hik': {'full': 'hik-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'hil': {'full': 'hil-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'hil-Brai': {'full': 'hil-Brai-PH', 'region': 'PH', 'script': 'Brai', 'suppress': False},
        'hio': {'full': 'hio-Latn-BW', 'region': 'BW', 'script': 'Latn', 'suppress': False},
        'hir': {'full': 'hir-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'hit': {'full': 'hit-Xsux-TR', 'region': 'TR', 'script': 'Xsux', 'suppress': False},
        'hiw': {'full': 'hiw-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'hix': {'full': 'hix-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'hji': {'full': 'hji-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'hka': {'full': 'hka-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'hke': {'full': 'hke-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'hkk': {'full': 'hkk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'hkn': {'full': 'hkn-Zyyy-KH', 'region': 'KH', 'script': 'Zyyy', 'suppress': False},
        'hks': {'full': 'hks-Zxxx-HK', 'region': 'HK', 'script': 'Zxxx', 'suppress': False},
        'hla': {'full': 'hla-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'hlb': {'full': 'hlb-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'hld': {'full': 'hld-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'hle': {'full': 'hle-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'hlt': {'full': 'hlt-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'hlu': {'full': 'hlu-Hluw-TR', 'region': 'TR', 'script': 'Hluw', 'suppress': False},
        'hma': {'full': 'hma-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'hmb': {'full': 'hmb-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'hmc': {'full': 'hmc-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'hmd': {'full': 'hmd-Plrd-CN', 'region': 'CN', 'script': 'Plrd', 'suppress': False},
        'hmd-Hmng': {'full': 'hmd-Hmng-CN', 'region': 'CN', 'script': 'Hmng', 'suppress': False},
        'hmd-Latn': {'full': 'hmd-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'hme': {'full': 'hme-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'hmf': {'full': 'hmf-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'hmg': {'full': 'hmg-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'hmh': {'full': 'hmh-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'hmi': {'full': 'hmi-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'hmj': {'full': 'hmj-Bopo-CN', 'region': 'CN', 'script': 'Bopo', 'suppress': False},
        'hmk': {'full': 'hmk-Zyyy-KR', 'region': 'KR', 'script': 'Zyyy', 'suppress': False},
        'hml': {'full': 'hml-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'hmm': {'full': 'hmm-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'hmn': {'full': 'hmn-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'hmn-Bopo': {'full': 'hmn-Bopo-CN', 'region': 'CN', 'script': 'Bopo', 'suppress': False},
        'hmn-Hmng': {'full': 'hmn-Hmng-CN', 'region': 'CN', 'script': 'Hmng', 'suppress': False},
        'hmp': {'full': 'hmp-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'hmq': {'full': 'hmq-Bopo-CN', 'region': 'CN', 'script': 'Bopo', 'suppress': False},
        'hmr': {'full': 'hmr-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'hms': {'full': 'hms-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'hmt': {'full': 'hmt-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'hmu': {'full': 'hmu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'hmv': {'full': 'hmv-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'hmw': {'full': 'hmw-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'hmy': {'full': 'hmy-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'hmz-Latn': {'full': 'hmz-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'hmz-Plrd': {'full': 'hmz-Plrd-CN', 'region': 'CN', 'script': 'Plrd', 'suppress': False},
        'hna': {'full': 'hna-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'hnd': {'full': 'hnd-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'hne': {'full': 'hne-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'hng': {'full': 'hng-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'hnh': {'full': 'hnh-Latn-BW', 'region': 'BW', 'script': 'Latn', 'suppress': False},
        'hni': {'full': 'hni-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'hnj': {'full': 'hnj-Hmng-LA', 'region': 'LA', 'script': 'Hmng', 'suppress': False},
        'hnj-Laoo': {'full': 'hnj-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'hnj-Latn': {'full': 'hnj-Latn-LA', 'region': 'LA', 'script': 'Latn', 'suppress': False},
        'hnj-Plrd': {'full': 'hnj-Plrd-CN', 'region': 'CN', 'script': 'Plrd', 'suppress': False},
        'hnj-Thai': {'full': 'hnj-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'hnn': {'full': 'hnn-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'hnn-Hano': {'full': 'hnn-Hano-PH', 'region': 'PH', 'script': 'Hano', 'suppress': False},
        'hno': {'full': 'hno-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'hns': {'full': 'hns-Latn-SR', 'region': 'SR', 'script': 'Latn', 'suppress': False},
        'hnu': {'full': 'hnu-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'ho': {'full': 'ho-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ho-Brai': {'full': 'ho-Brai-PG', 'region': 'PG', 'script': 'Brai', 'suppress': False},
        'hoa': {'full': 'hoa-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'hob': {'full': 'hob-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'hoc': {'full': 'hoc-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'hoc-Latn': {'full': 'hoc-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'hoc-Orya': {'full': 'hoc-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'hoc-Telu': {'full': 'hoc-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'hoc-Wara': {'full': 'hoc-Wara-IN', 'region': 'IN', 'script': 'Wara', 'suppress': False},
        'hod': {'full': 'hod-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'hoe': {'full': 'hoe-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'hoh': {'full': 'hoh-Zyyy-OM', 'region': 'OM', 'script': 'Zyyy', 'suppress': False},
        'hoi': {'full': 'hoi-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'hoj': {'full': 'hoj-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'hol': {'full': 'hol-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'hom': {'full': 'hom-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'hoo': {'full': 'hoo-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'hop': {'full': 'hop-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'hor': {'full': 'hor-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'hos': {'full': 'hos-Zxxx-VN', 'region': 'VN', 'script': 'Zxxx', 'suppress': False},
        'hot': {'full': 'hot-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'hov': {'full': 'hov-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'how': {'full': 'how-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'hoy': {'full': 'hoy-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'hoz': {'full': 'hoz-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'hpo': {'full': 'hpo-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'hps': {'full': 'hps-Zxxx-US', 'region': 'US', 'script': 'Zxxx', 'suppress': False},
        'hr': {'full': 'hr-Latn-HR', 'region': 'HR', 'script': 'Latn', 'suppress': True},
        'hr-BA': {'full': 'hr-Latn-BA', 'region': 'BA', 'script': 'Latn', 'suppress': True},
        'hr-Brai': {'full': 'hr-Brai-HR', 'region': 'HR', 'script': 'Brai', 'suppress': False},
        'hra': {'full': 'hra-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'hrc': {'full': 'hrc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'hre': {'full': 'hre-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'hre-x-1960': {'full': 'hre-Latn-VN-x-1960', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'hrk': {'full': 'hrk-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'hrm': {'full': 'hrm-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'hro': {'full': 'hro-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'hrp': {'full': 'hrp-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'hrt': {'full': 'hrt-Syrc-TR', 'region': 'TR', 'script': 'Syrc', 'suppress': False},
        'hru': {'full': 'hru-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'hrw': {'full': 'hrw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'hrx': {'full': 'hrx-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'hrz': {'full': 'hrz-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'hsb': {'full': 'hsb-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': True},
        'hsh': {'full': 'hsh-Zxxx-HU', 'region': 'HU', 'script': 'Zxxx', 'suppress': False},
        'hsl': {'full': 'hsl-Zxxx-NG', 'region': 'NG', 'script': 'Zxxx', 'suppress': False},
        'hsn': {'full': 'hsn-Hans-CN', 'region': 'CN', 'script': 'Hans', 'suppress': False},
        'hsn-Hant': {'full': 'hsn-Hant-CN', 'region': 'CN', 'script': 'Hant', 'suppress': False},
        'hsn-Nshu': {'full': 'hsn-Nshu-CN', 'region': 'CN', 'script': 'Nshu', 'suppress': False},
        'hss': {'full': 'hss-Zyyy-OM', 'region': 'OM', 'script': 'Zyyy', 'suppress': False},
        'ht': {'full': 'ht-Latn-HT', 'region': 'HT', 'script': 'Latn', 'suppress': True},
        'hti': {'full': 'hti-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'hto': {'full': 'hto-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'hts': {'full': 'hts-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'htu': {'full': 'htu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'htx': {'full': 'htx-Zyyy-TR', 'region': 'TR', 'script': 'Zyyy', 'suppress': False},
        'hu': {'full': 'hu-Latn-HU', 'region': 'HU', 'script': 'Latn', 'suppress': True},
        'hu-Brai': {'full': 'hu-Brai-HU', 'region': 'HU', 'script': 'Brai', 'suppress': False},
        'hub': {'full': 'hub-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'huc': {'full': 'huc-Latn-BW', 'region': 'BW', 'script': 'Latn', 'suppress': False},
        'hud': {'full': 'hud-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'hue': {'full': 'hue-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'huf': {'full': 'huf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'hug': {'full': 'hug-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'huh': {'full': 'huh-Latn-CL', 'region': 'CL', 'script': 'Latn', 'suppress': False},
        'hui': {'full': 'hui-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'huj': {'full': 'huj-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'huk': {'full': 'huk-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'hul': {'full': 'hul-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'hum': {'full': 'hum-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'huo': {'full': 'huo-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'hup': {'full': 'hup-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'huq': {'full': 'huq-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'hur': {'full': 'hur-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'hus': {'full': 'hus-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'hut': {'full': 'hut-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'huu': {'full': 'huu-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'huv': {'full': 'huv-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'huw': {'full': 'huw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'hux': {'full': 'hux-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'huy': {'full': 'huy-Hebr-IL', 'region': 'IL', 'script': 'Hebr', 'suppress': False},
        'huz': {'full': 'huz-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'hvc': {'full': 'hvc-Latn-HT', 'region': 'HT', 'script': 'Latn', 'suppress': False},
        'hve': {'full': 'hve-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'hvk': {'full': 'hvk-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'hvn': {'full': 'hvn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'hvv': {'full': 'hvv-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'hwa': {'full': 'hwa-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'hwc': {'full': 'hwc-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'hwo': {'full': 'hwo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'hy': {'full': 'hy-Armn-AM', 'region': 'AM', 'script': 'Armn', 'suppress': True},
        'hy-Brai': {'full': 'hy-Brai-AM', 'region': 'AM', 'script': 'Brai', 'suppress': False},
        'hya': {'full': 'hya-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'hyw': {'full': 'hyw-Armn-AM', 'region': 'AM', 'script': 'Armn', 'suppress': False},
        'hz': {'full': 'hz-Latn-NA', 'region': 'NA', 'script': 'Latn', 'suppress': False},
        'ia': {'full': 'ia-Latn-FR', 'region': 'FR', 'script': 'Latn', 'suppress': False},
        'iai': {'full': 'iai-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'ian': {'full': 'ian-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'iap': {'full': 'iap-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'iar': {'full': 'iar-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'iba': {'full': 'iba-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'ibb': {'full': 'ibb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ibd': {'full': 'ibd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ibe': {'full': 'ibe-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ibg': {'full': 'ibg-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ibh': {'full': 'ibh-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'ibl': {'full': 'ibl-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ibm': {'full': 'ibm-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ibn': {'full': 'ibn-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ibr': {'full': 'ibr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ibu': {'full': 'ibu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'iby': {'full': 'iby-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ica': {'full': 'ica-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'ich': {'full': 'ich-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'icl': {'full': 'icl-Zxxx-IS', 'region': 'IS', 'script': 'Zxxx', 'suppress': False},
        'icr': {'full': 'icr-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'id': {'full': 'id-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': True},
        'id-Arab': {'full': 'id-Arab-ID', 'region': 'ID', 'script': 'Arab', 'suppress': False},
        'id-Brai': {'full': 'id-Brai-ID', 'region': 'ID', 'script': 'Brai', 'suppress': False},
        'ida': {'full': 'ida-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'idb': {'full': 'idb-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'idc': {'full': 'idc-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'idd': {'full': 'idd-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'ide': {'full': 'ide-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'idi': {'full': 'idi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'idr': {'full': 'idr-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'ids': {'full': 'ids-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'idt': {'full': 'idt-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'idu': {'full': 'idu-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ie': {'full': 'ie-Latn-001', 'region': '001', 'script': 'Latn', 'suppress': False},
        'ifa': {'full': 'ifa-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ifb': {'full': 'ifb-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ife': {'full': 'ife-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'ife-BJ': {'full': 'ife-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'iff': {'full': 'iff-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'ifk': {'full': 'ifk-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ifm': {'full': 'ifm-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'ifu': {'full': 'ifu-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ify': {'full': 'ify-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ig': {'full': 'ig-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'igb': {'full': 'igb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ige': {'full': 'ige-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'igg': {'full': 'igg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'igl': {'full': 'igl-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'igm': {'full': 'igm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ign': {'full': 'ign-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'igo': {'full': 'igo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'igs': {'full': 'igs-Zyyy-001', 'region': '001', 'script': 'Zyyy', 'suppress': False},
        'igw': {'full': 'igw-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ihb': {'full': 'ihb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ihi': {'full': 'ihi-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ihp': {'full': 'ihp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ihw': {'full': 'ihw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ii': {'full': 'ii-Yiii-CN', 'region': 'CN', 'script': 'Yiii', 'suppress': False},
        'ii-Latn': {'full': 'ii-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'iin': {'full': 'iin-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ijc': {'full': 'ijc-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ije': {'full': 'ije-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ijj': {'full': 'ijj-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'ijn': {'full': 'ijn-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ijs': {'full': 'ijs-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ik': {'full': 'ik-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'ike-Latn': {'full': 'ike-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'iki': {'full': 'iki-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ikk': {'full': 'ikk-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ikl': {'full': 'ikl-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'iko': {'full': 'iko-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ikp': {'full': 'ikp-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ikr': {'full': 'ikr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'iks': {'full': 'iks-Zxxx-CA', 'region': 'CA', 'script': 'Zxxx', 'suppress': False},
        'ikt': {'full': 'ikt-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'ikt-Cans': {'full': 'ikt-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'ikv': {'full': 'ikv-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ikw': {'full': 'ikw-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ikx': {'full': 'ikx-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'ikz': {'full': 'ikz-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'ila': {'full': 'ila-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ilb': {'full': 'ilb-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'ilg': {'full': 'ilg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ili': {'full': 'ili-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ilk': {'full': 'ilk-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ilm': {'full': 'ilm-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'ilo': {'full': 'ilo-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ilo-Brai': {'full': 'ilo-Brai-PH', 'region': 'PH', 'script': 'Brai', 'suppress': False},
        'ilo-Tglg': {'full': 'ilo-Tglg-PH', 'region': 'PH', 'script': 'Tglg', 'suppress': False},
        'ilp': {'full': 'ilp-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ils': {'full': 'ils-Zxxx-IT', 'region': 'IT', 'script': 'Zxxx', 'suppress': False},
        'ilu': {'full': 'ilu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ilv': {'full': 'ilv-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ima': {'full': 'ima-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'imi': {'full': 'imi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'iml': {'full': 'iml-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'imn': {'full': 'imn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'imo': {'full': 'imo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'imr': {'full': 'imr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ims': {'full': 'ims-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'imy': {'full': 'imy-Zyyy-TR', 'region': 'TR', 'script': 'Zyyy', 'suppress': False},
        'inb': {'full': 'inb-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'ing': {'full': 'ing-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'inh': {'full': 'inh-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'inh-Arab': {'full': 'inh-Arab-RU', 'region': 'RU', 'script': 'Arab', 'suppress': False},
        'inh-Latn': {'full': 'inh-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'inj': {'full': 'inj-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'inl': {'full': 'inl-Zxxx-ID', 'region': 'ID', 'script': 'Zxxx', 'suppress': False},
        'inm': {'full': 'inm-Zyyy-YE', 'region': 'YE', 'script': 'Zyyy', 'suppress': False},
        'inn': {'full': 'inn-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ino': {'full': 'ino-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'inp': {'full': 'inp-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'ins': {'full': 'ins-Zxxx-IN', 'region': 'IN', 'script': 'Zxxx', 'suppress': False},
        'int': {'full': 'int-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'inz': {'full': 'inz-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'io': {'full': 'io-Latn-001', 'region': '001', 'script': 'Latn', 'suppress': False},
        'ior': {'full': 'ior-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'iou': {'full': 'iou-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'iow': {'full': 'iow-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'ipi': {'full': 'ipi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ipo': {'full': 'ipo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'iqu': {'full': 'iqu-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'iqw': {'full': 'iqw-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ire': {'full': 'ire-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'irh': {'full': 'irh-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'iri': {'full': 'iri-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'irk': {'full': 'irk-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'irn': {'full': 'irn-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'irr': {'full': 'irr-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'iru': {'full': 'iru-Taml-IN', 'region': 'IN', 'script': 'Taml', 'suppress': False},
        'iru-Mlym': {'full': 'iru-Mlym-IN', 'region': 'IN', 'script': 'Mlym', 'suppress': False},
        'irx': {'full': 'irx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'iry': {'full': 'iry-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'is': {'full': 'is-Latn-IS', 'region': 'IS', 'script': 'Latn', 'suppress': True},
        'isa': {'full': 'isa-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'isc': {'full': 'isc-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'isd': {'full': 'isd-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ise': {'full': 'ise-Zxxx-IT', 'region': 'IT', 'script': 'Zxxx', 'suppress': False},
        'isg': {'full': 'isg-Zxxx-IE', 'region': 'IE', 'script': 'Zxxx', 'suppress': False},
        'ish': {'full': 'ish-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'isi': {'full': 'isi-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'isk': {'full': 'isk-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'ism': {'full': 'ism-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'isn': {'full': 'isn-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'iso': {'full': 'iso-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'isr': {'full': 'isr-Zxxx-IL', 'region': 'IL', 'script': 'Zxxx', 'suppress': False},
        'ist': {'full': 'ist-Latn-HR', 'region': 'HR', 'script': 'Latn', 'suppress': False},
        'isu': {'full': 'isu-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'it': {'full': 'it-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': True},
        'it-Brai': {'full': 'it-Brai-IT', 'region': 'IT', 'script': 'Brai', 'suppress': False},
        'it-CH': {'full': 'it-Latn-CH', 'region': 'CH', 'script': 'Latn', 'suppress': True},
        'itb': {'full': 'itb-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'itd': {'full': 'itd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ite': {'full': 'ite-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'iti': {'full': 'iti-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'itk': {'full': 'itk-Hebr-IT', 'region': 'IT', 'script': 'Hebr', 'suppress': False},
        'itl': {'full': 'itl-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'itm': {'full': 'itm-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ito': {'full': 'ito-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'itr': {'full': 'itr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'its': {'full': 'its-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'itt': {'full': 'itt-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'itv': {'full': 'itv-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'itw': {'full': 'itw-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'itx': {'full': 'itx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ity': {'full': 'ity-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'itz': {'full': 'itz-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'iu': {'full': 'iu-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'iu-Latn': {'full': 'iu-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'ium': {'full': 'ium-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'ium-Hani': {'full': 'ium-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'ium-Laoo': {'full': 'ium-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'ium-Thai': {'full': 'ium-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'ium-x-1954': {'full': 'ium-Latn-CN-x-1954', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'ivb': {'full': 'ivb-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ivv': {'full': 'ivv-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'iwk': {'full': 'iwk-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'iwm': {'full': 'iwm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'iwo': {'full': 'iwo-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'iws': {'full': 'iws-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ixc': {'full': 'ixc-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ixl': {'full': 'ixl-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'iya': {'full': 'iya-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'iyo': {'full': 'iyo-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'iyx': {'full': 'iyx-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'izh': {'full': 'izh-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'izr': {'full': 'izr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'izz': {'full': 'izz-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ja': {'full': 'ja-Jpan-JP', 'region': 'JP', 'script': 'Jpan', 'suppress': True},
        'ja-Brai': {'full': 'ja-Brai-JP', 'region': 'JP', 'script': 'Brai', 'suppress': False},
        'ja-Latn': {'full': 'ja-Latn-JP', 'region': 'JP', 'script': 'Latn', 'suppress': False},
        'jaa': {'full': 'jaa-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'jab': {'full': 'jab-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jac': {'full': 'jac-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'jad': {'full': 'jad-Arab-GN', 'region': 'GN', 'script': 'Arab', 'suppress': False},
        'jae': {'full': 'jae-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'jaf': {'full': 'jaf-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jah': {'full': 'jah-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'jaj': {'full': 'jaj-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'jak': {'full': 'jak-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'jal': {'full': 'jal-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'jam': {'full': 'jam-Latn-JM', 'region': 'JM', 'script': 'Latn', 'suppress': False},
        'jan': {'full': 'jan-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'jao': {'full': 'jao-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'jaq': {'full': 'jaq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'jas': {'full': 'jas-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'jat': {'full': 'jat-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'jau': {'full': 'jau-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'jax': {'full': 'jax-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'jay': {'full': 'jay-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'jaz': {'full': 'jaz-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'jbe': {'full': 'jbe-Hebr-IL', 'region': 'IL', 'script': 'Hebr', 'suppress': False},
        'jbi': {'full': 'jbi-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'jbj': {'full': 'jbj-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'jbk': {'full': 'jbk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'jbn': {'full': 'jbn-Arab-LY', 'region': 'LY', 'script': 'Arab', 'suppress': False},
        'jbo': {'full': 'jbo-Latn-001', 'region': '001', 'script': 'Latn', 'suppress': False},
        'jbr': {'full': 'jbr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'jbt': {'full': 'jbt-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'jbu': {'full': 'jbu-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'jbw': {'full': 'jbw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'jcs': {'full': 'jcs-Zxxx-JM', 'region': 'JM', 'script': 'Zxxx', 'suppress': False},
        'jct': {'full': 'jct-Cyrl-UA', 'region': 'UA', 'script': 'Cyrl', 'suppress': False},
        'jct-Latn': {'full': 'jct-Latn-UA', 'region': 'UA', 'script': 'Latn', 'suppress': False},
        'jda': {'full': 'jda-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'jdg': {'full': 'jdg-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'jdt': {'full': 'jdt-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'jdt-Hebr': {'full': 'jdt-Hebr-RU', 'region': 'RU', 'script': 'Hebr', 'suppress': False},
        'jdt-Latn': {'full': 'jdt-Latn-AZ', 'region': 'AZ', 'script': 'Latn', 'suppress': False},
        'jeb': {'full': 'jeb-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'jee': {'full': 'jee-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'jeh': {'full': 'jeh-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'jeh-Laoo': {'full': 'jeh-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'jei': {'full': 'jei-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'jek': {'full': 'jek-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'jel': {'full': 'jel-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'jen': {'full': 'jen-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jer': {'full': 'jer-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jet': {'full': 'jet-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'jeu': {'full': 'jeu-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'jgb': {'full': 'jgb-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'jge': {'full': 'jge-Zyyy-IL', 'region': 'IL', 'script': 'Zyyy', 'suppress': False},
        'jgk': {'full': 'jgk-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jgo': {'full': 'jgo-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'jhi': {'full': 'jhi-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'jhs': {'full': 'jhs-Zxxx-NP', 'region': 'NP', 'script': 'Zxxx', 'suppress': False},
        'jia': {'full': 'jia-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'jib': {'full': 'jib-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jic': {'full': 'jic-Latn-HN', 'region': 'HN', 'script': 'Latn', 'suppress': False},
        'jid': {'full': 'jid-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jie': {'full': 'jie-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jig': {'full': 'jig-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'jih': {'full': 'jih-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'jii': {'full': 'jii-Zyyy-SO', 'region': 'SO', 'script': 'Zyyy', 'suppress': False},
        'jil': {'full': 'jil-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'jim': {'full': 'jim-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'jio': {'full': 'jio-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'jiq': {'full': 'jiq-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'jit': {'full': 'jit-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'jiu': {'full': 'jiu-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'jiv': {'full': 'jiv-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'jiy': {'full': 'jiy-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'jje': {'full': 'jje-Hang-KR', 'region': 'KR', 'script': 'Hang', 'suppress': False},
        'jjr': {'full': 'jjr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jka': {'full': 'jka-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'jkm': {'full': 'jkm-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'jko': {'full': 'jko-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'jkp': {'full': 'jkp-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'jkr': {'full': 'jkr-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'jku': {'full': 'jku-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jle': {'full': 'jle-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'jls': {'full': 'jls-Zxxx-JM', 'region': 'JM', 'script': 'Zxxx', 'suppress': False},
        'jma': {'full': 'jma-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'jmb': {'full': 'jmb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jmc': {'full': 'jmc-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'jmd': {'full': 'jmd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'jmi': {'full': 'jmi-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jml': {'full': 'jml-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'jmn': {'full': 'jmn-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'jmr': {'full': 'jmr-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'jms': {'full': 'jms-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jmw': {'full': 'jmw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'jmx': {'full': 'jmx-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'jna': {'full': 'jna-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'jnd': {'full': 'jnd-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'jng': {'full': 'jng-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'jni': {'full': 'jni-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jnj': {'full': 'jnj-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'jnl': {'full': 'jnl-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'jns': {'full': 'jns-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'jns-Latn': {'full': 'jns-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'jns-Takr': {'full': 'jns-Takr-IN', 'region': 'IN', 'script': 'Takr', 'suppress': False},
        'job': {'full': 'job-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'jod': {'full': 'jod-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'jog': {'full': 'jog-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'jor': {'full': 'jor-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'jos': {'full': 'jos-Zxxx-JO', 'region': 'JO', 'script': 'Zxxx', 'suppress': False},
        'jow': {'full': 'jow-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'jpa': {'full': 'jpa-Zyyy-PS', 'region': 'PS', 'script': 'Zyyy', 'suppress': False},
        'jpr': {'full': 'jpr-Hebr-IL', 'region': 'IL', 'script': 'Hebr', 'suppress': False},
        'jqr': {'full': 'jqr-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'jra': {'full': 'jra-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'jra-Khmr': {'full': 'jra-Khmr-KH', 'region': 'KH', 'script': 'Khmr', 'suppress': False},
        'jrb': {'full': 'jrb-Hebr-IL', 'region': 'IL', 'script': 'Hebr', 'suppress': False},
        'jrr': {'full': 'jrr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jrt': {'full': 'jrt-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jru': {'full': 'jru-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'jsl': {'full': 'jsl-Zxxx-JP', 'region': 'JP', 'script': 'Zxxx', 'suppress': False},
        'jua': {'full': 'jua-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'jub': {'full': 'jub-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'juc': {'full': 'juc-Jurc-CN', 'region': 'CN', 'script': 'Jurc', 'suppress': False},
        'jud': {'full': 'jud-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'juh': {'full': 'juh-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jui': {'full': 'jui-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'juk': {'full': 'juk-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jul': {'full': 'jul-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'jum': {'full': 'jum-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'jun': {'full': 'jun-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'juo': {'full': 'juo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'jup': {'full': 'jup-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'jur': {'full': 'jur-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'jus': {'full': 'jus-Zxxx-NP', 'region': 'NP', 'script': 'Zxxx', 'suppress': False},
        'jut': {'full': 'jut-Latn-DK', 'region': 'DK', 'script': 'Latn', 'suppress': False},
        'juu': {'full': 'juu-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'juw': {'full': 'juw-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'juy': {'full': 'juy-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'jv': {'full': 'jv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'jv-Java': {'full': 'jv-Java-ID', 'region': 'ID', 'script': 'Java', 'suppress': False},
        'jvd': {'full': 'jvd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'jvn': {'full': 'jvn-Latn-SR', 'region': 'SR', 'script': 'Latn', 'suppress': False},
        'jwi': {'full': 'jwi-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'jya': {'full': 'jya-Tibt-CN', 'region': 'CN', 'script': 'Tibt', 'suppress': False},
        'jye': {'full': 'jye-Hebr-IL', 'region': 'IL', 'script': 'Hebr', 'suppress': False},
        'jyy': {'full': 'jyy-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'ka': {'full': 'ka-Geor-GE', 'region': 'GE', 'script': 'Geor', 'suppress': True},
        'ka-Brai': {'full': 'ka-Brai-GE', 'region': 'GE', 'script': 'Brai', 'suppress': False},
        'ka-Geok': {'full': 'ka-Geok-GE', 'region': 'GE', 'script': 'Geok', 'suppress': False},
        'kaa': {'full': 'kaa-Cyrl-UZ', 'region': 'UZ', 'script': 'Cyrl', 'suppress': False},
        'kaa-Arab': {'full': 'kaa-Arab-UZ', 'region': 'UZ', 'script': 'Arab', 'suppress': False},
        'kaa-Latn': {'full': 'kaa-Latn-UZ', 'region': 'UZ', 'script': 'Latn', 'suppress': False},
        'kab': {'full': 'kab-Latn-DZ', 'region': 'DZ', 'script': 'Latn', 'suppress': False},
        'kab-Arab': {'full': 'kab-Arab-DZ', 'region': 'DZ', 'script': 'Arab', 'suppress': False},
        'kab-Tfng': {'full': 'kab-Tfng-DZ', 'region': 'DZ', 'script': 'Tfng', 'suppress': False},
        'kac': {'full': 'kac-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'kad': {'full': 'kad-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kae': {'full': 'kae-Zyyy-TW', 'region': 'TW', 'script': 'Zyyy', 'suppress': False},
        'kaf': {'full': 'kaf-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'kag': {'full': 'kag-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'kah': {'full': 'kah-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'kai': {'full': 'kai-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kaj': {'full': 'kaj-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kak': {'full': 'kak-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'kam': {'full': 'kam-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'kao': {'full': 'kao-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'kap': {'full': 'kap-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'kaq': {'full': 'kaq-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'kav': {'full': 'kav-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kaw': {'full': 'kaw-Bali-MY', 'region': 'MY', 'script': 'Bali', 'suppress': False},
        'kax': {'full': 'kax-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kay': {'full': 'kay-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kba': {'full': 'kba-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'kbb': {'full': 'kbb-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kbc': {'full': 'kbc-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kbd': {'full': 'kbd-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'kbe': {'full': 'kbe-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'kbg-Tibt': {'full': 'kbg-Tibt-IN-x-hingna', 'region': 'IN', 'script': 'Tibt', 'suppress': False},
        'kbh': {'full': 'kbh-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'kbi': {'full': 'kbi-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kbj': {'full': 'kbj-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'kbk': {'full': 'kbk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kbl': {'full': 'kbl-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'kbm': {'full': 'kbm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kbn': {'full': 'kbn-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'kbo': {'full': 'kbo-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'kbp': {'full': 'kbp-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'kbp-Brai': {'full': 'kbp-Brai-TG', 'region': 'TG', 'script': 'Brai', 'suppress': False},
        'kbq': {'full': 'kbq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kbr': {'full': 'kbr-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'kbr-Ethi': {'full': 'kbr-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'kbs': {'full': 'kbs-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'kbt': {'full': 'kbt-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kbu': {'full': 'kbu-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'kbv': {'full': 'kbv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kbw': {'full': 'kbw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kbx': {'full': 'kbx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kby': {'full': 'kby-Arab-NE', 'region': 'NE', 'script': 'Arab', 'suppress': False},
        'kby-Latn': {'full': 'kby-Latn-NE', 'region': 'NE', 'script': 'Latn', 'suppress': False},
        'kbz': {'full': 'kbz-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kca': {'full': 'kca-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'kcb': {'full': 'kcb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kcc': {'full': 'kcc-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kcd': {'full': 'kcd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kce': {'full': 'kce-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kcf': {'full': 'kcf-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kcg': {'full': 'kcg-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kch': {'full': 'kch-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kci': {'full': 'kci-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kcj': {'full': 'kcj-Latn-GW', 'region': 'GW', 'script': 'Latn', 'suppress': False},
        'kck': {'full': 'kck-Latn-ZW', 'region': 'ZW', 'script': 'Latn', 'suppress': False},
        'kcl': {'full': 'kcl-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kcm': {'full': 'kcm-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'kcn': {'full': 'kcn-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'kco': {'full': 'kco-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kcp': {'full': 'kcp-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'kcq': {'full': 'kcq-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kcr': {'full': 'kcr-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'kcs': {'full': 'kcs-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kct': {'full': 'kct-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kcu': {'full': 'kcu-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'kcv': {'full': 'kcv-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'kcw': {'full': 'kcw-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'kcx': {'full': 'kcx-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'kcy': {'full': 'kcy-Zyyy-DZ', 'region': 'DZ', 'script': 'Zyyy', 'suppress': False},
        'kcz': {'full': 'kcz-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'kda': {'full': 'kda-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'kdc': {'full': 'kdc-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'kdd': {'full': 'kdd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'kde': {'full': 'kde-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'kdf': {'full': 'kdf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kdg': {'full': 'kdg-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'kdh': {'full': 'kdh-Arab-TG', 'region': 'TG', 'script': 'Arab', 'suppress': False},
        'kdh-Latn': {'full': 'kdh-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'kdi': {'full': 'kdi-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'kdj': {'full': 'kdj-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'kdk': {'full': 'kdk-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'kdl': {'full': 'kdl-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kdm': {'full': 'kdm-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kdn': {'full': 'kdn-Latn-ZW', 'region': 'ZW', 'script': 'Latn', 'suppress': False},
        'kdp': {'full': 'kdp-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kdq': {'full': 'kdq-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'kdr': {'full': 'kdr-Latn-LT', 'region': 'LT', 'script': 'Latn', 'suppress': False},
        'kdr-Cyrl': {'full': 'kdr-Cyrl-UA', 'region': 'UA', 'script': 'Cyrl', 'suppress': False},
        'kdt': {'full': 'kdt-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'kdt-Khmr': {'full': 'kdt-Khmr-KH', 'region': 'KH', 'script': 'Khmr', 'suppress': False},
        'kdt-Laoo': {'full': 'kdt-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'kdu': {'full': 'kdu-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'kdw': {'full': 'kdw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kdx': {'full': 'kdx-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kdy': {'full': 'kdy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kdz': {'full': 'kdz-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'kea': {'full': 'kea-Latn-CV', 'region': 'CV', 'script': 'Latn', 'suppress': False},
        'keb': {'full': 'keb-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'kec': {'full': 'kec-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'ked': {'full': 'ked-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'kee': {'full': 'kee-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'kef': {'full': 'kef-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'keg': {'full': 'keg-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'keh': {'full': 'keh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kei': {'full': 'kei-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kej': {'full': 'kej-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'kek': {'full': 'kek-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'kel': {'full': 'kel-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'kem': {'full': 'kem-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'ken': {'full': 'ken-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'keo': {'full': 'keo-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'kep': {'full': 'kep-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'keq': {'full': 'keq-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'ker': {'full': 'ker-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'kes': {'full': 'kes-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ket': {'full': 'ket-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'keu': {'full': 'keu-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'kev': {'full': 'kev-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'kew': {'full': 'kew-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kex': {'full': 'kex-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'kex-Gujr': {'full': 'kex-Gujr-IN', 'region': 'IN', 'script': 'Gujr', 'suppress': False},
        'key': {'full': 'key-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'kez': {'full': 'kez-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kfa': {'full': 'kfa-Knda-IN', 'region': 'IN', 'script': 'Knda', 'suppress': False},
        'kfb': {'full': 'kfb-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'kfc': {'full': 'kfc-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'kfd': {'full': 'kfd-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'kfe': {'full': 'kfe-Taml-IN', 'region': 'IN', 'script': 'Taml', 'suppress': False},
        'kff-Deva': {'full': 'kff-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'kff-Latn': {'full': 'kff-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'kff-Orya': {'full': 'kff-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'kff-Telu': {'full': 'kff-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'kfg-Knda': {'full': 'kfg-Knda-IN', 'region': 'IN', 'script': 'Knda', 'suppress': False},
        'kfg-Mlym': {'full': 'kfg-Mlym-IN', 'region': 'IN', 'script': 'Mlym', 'suppress': False},
        'kfh': {'full': 'kfh-Mlym-IN', 'region': 'IN', 'script': 'Mlym', 'suppress': False},
        'kfi': {'full': 'kfi-Taml-IN', 'region': 'IN', 'script': 'Taml', 'suppress': False},
        'kfi-Knda': {'full': 'kfi-Knda-IN', 'region': 'IN', 'script': 'Knda', 'suppress': False},
        'kfj': {'full': 'kfj-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'kfk': {'full': 'kfk-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'kfk-Takr': {'full': 'kfk-Takr-IN', 'region': 'IN', 'script': 'Takr', 'suppress': False},
        'kfl': {'full': 'kfl-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'kfm': {'full': 'kfm-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'kfn': {'full': 'kfn-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'kfo': {'full': 'kfo-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'kfp': {'full': 'kfp-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'kfq': {'full': 'kfq-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'kfr': {'full': 'kfr-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'kfr-Gujr': {'full': 'kfr-Gujr-IN', 'region': 'IN', 'script': 'Gujr', 'suppress': False},
        'kfs': {'full': 'kfs-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'kft': {'full': 'kft-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'kfu': {'full': 'kfu-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'kfv': {'full': 'kfv-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'kfw': {'full': 'kfw-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'kfx': {'full': 'kfx-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'kfx-Takr': {'full': 'kfx-Takr-IN', 'region': 'IN', 'script': 'Takr', 'suppress': False},
        'kfy': {'full': 'kfy-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'kfz': {'full': 'kfz-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'kg': {'full': 'kg-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'kga': {'full': 'kga-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'kgb': {'full': 'kgb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kge': {'full': 'kge-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kgf': {'full': 'kgf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kgg': {'full': 'kgg-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'kgi': {'full': 'kgi-Zxxx-MY', 'region': 'MY', 'script': 'Zxxx', 'suppress': False},
        'kgj': {'full': 'kgj-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'kgk': {'full': 'kgk-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kgl': {'full': 'kgl-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'kgm': {'full': 'kgm-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kgn': {'full': 'kgn-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'kgo': {'full': 'kgo-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'kgp': {'full': 'kgp-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kgq': {'full': 'kgq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kgr': {'full': 'kgr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kgs': {'full': 'kgs-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'kgt': {'full': 'kgt-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kgu': {'full': 'kgu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kgv': {'full': 'kgv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kgw': {'full': 'kgw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kgx': {'full': 'kgx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kgy': {'full': 'kgy-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'kha': {'full': 'kha-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'kha-Beng': {'full': 'kha-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'khb': {'full': 'khb-Talu-CN', 'region': 'CN', 'script': 'Talu', 'suppress': False},
        'khb-Lana': {'full': 'khb-Lana-CN', 'region': 'CN', 'script': 'Lana', 'suppress': False},
        'khc': {'full': 'khc-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'khd': {'full': 'khd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'khe': {'full': 'khe-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'khf': {'full': 'khf-Thai-LA', 'region': 'LA', 'script': 'Thai', 'suppress': False},
        'khg': {'full': 'khg-Tibt-CN', 'region': 'CN', 'script': 'Tibt', 'suppress': False},
        'khh': {'full': 'khh-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'khj': {'full': 'khj-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'khl': {'full': 'khl-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'khn': {'full': 'khn-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'kho': {'full': 'kho-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'khp': {'full': 'khp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'khq': {'full': 'khq-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'khr': {'full': 'khr-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'khr-Deva': {'full': 'khr-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'khs': {'full': 'khs-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kht': {'full': 'kht-Mymr-IN', 'region': 'IN', 'script': 'Mymr', 'suppress': False},
        'khu': {'full': 'khu-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'khv': {'full': 'khv-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'khw': {'full': 'khw-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'khx': {'full': 'khx-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'khy': {'full': 'khy-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'khz': {'full': 'khz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ki': {'full': 'ki-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'kia': {'full': 'kia-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'kib': {'full': 'kib-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'kic': {'full': 'kic-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'kid': {'full': 'kid-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'kie': {'full': 'kie-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'kif': {'full': 'kif-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'kig': {'full': 'kig-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kih': {'full': 'kih-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kii': {'full': 'kii-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'kij': {'full': 'kij-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kil': {'full': 'kil-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kim': {'full': 'kim-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'kio': {'full': 'kio-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'kip': {'full': 'kip-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'kiq': {'full': 'kiq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kis': {'full': 'kis-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kit': {'full': 'kit-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kiu': {'full': 'kiu-Latn-TR', 'region': 'TR', 'script': 'Latn', 'suppress': False},
        'kiv': {'full': 'kiv-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'kiw': {'full': 'kiw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kix': {'full': 'kix-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'kiy': {'full': 'kiy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kiz': {'full': 'kiz-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'kj': {'full': 'kj-Latn-NA', 'region': 'NA', 'script': 'Latn', 'suppress': False},
        'kj-Brai': {'full': 'kj-Brai-AO', 'region': 'AO', 'script': 'Brai', 'suppress': False},
        'kja': {'full': 'kja-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kjb': {'full': 'kjb-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'kjc': {'full': 'kjc-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kjd': {'full': 'kjd-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kje': {'full': 'kje-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kjf': {'full': 'kjf-Zyyy-AZ', 'region': 'AZ', 'script': 'Zyyy', 'suppress': False},
        'kjg': {'full': 'kjg-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'kjg-Latn': {'full': 'kjg-Latn-LA', 'region': 'LA', 'script': 'Latn', 'suppress': False},
        'kjg-Thai': {'full': 'kjg-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'kjh': {'full': 'kjh-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'kji': {'full': 'kji-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'kjj': {'full': 'kjj-Latn-AZ', 'region': 'AZ', 'script': 'Latn', 'suppress': False},
        'kjk': {'full': 'kjk-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kjl': {'full': 'kjl-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'kjm': {'full': 'kjm-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'kjn': {'full': 'kjn-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'kjo': {'full': 'kjo-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'kjp': {'full': 'kjp-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'kjp-Leke': {'full': 'kjp-Leke-MM', 'region': 'MM', 'script': 'Leke', 'suppress': False},
        'kjp-Mymr-x-chekhi': {'full': 'kjp-Mymr-MM-x-chekhi', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'kjp-Mymr-x-phlouyu': {'full': 'kjp-Mymr-MM-x-phlouyu', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'kjp-Mymr-x-thiyon': {'full': 'kjp-Mymr-MM-x-thiyon', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'kjp-Thai': {'full': 'kjp-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'kjq': {'full': 'kjq-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'kjr': {'full': 'kjr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kjs': {'full': 'kjs-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kjt': {'full': 'kjt-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'kju': {'full': 'kju-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'kjv': {'full': 'kjv-Latn-001', 'region': '001', 'script': 'Latn', 'suppress': False},
        'kjx': {'full': 'kjx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kjy': {'full': 'kjy-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kjz-Tibt': {'full': 'kjz-Tibt-BT-x-uchen', 'region': 'BT', 'script': 'Tibt', 'suppress': False},
        'kk': {'full': 'kk-Cyrl-KZ', 'region': 'KZ', 'script': 'Cyrl', 'suppress': True},
        'kk-AF': {'full': 'kk-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'kk-Brai': {'full': 'kk-Brai-KZ', 'region': 'KZ', 'script': 'Brai', 'suppress': False},
        'kk-CN': {'full': 'kk-Arab-CN', 'region': 'CN', 'script': 'Arab', 'suppress': False},
        'kk-IR': {'full': 'kk-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'kk-Latn': {'full': 'kk-Latn-TR', 'region': 'TR', 'script': 'Latn', 'suppress': False},
        'kk-MN': {'full': 'kk-Arab-MN', 'region': 'MN', 'script': 'Arab', 'suppress': False},
        'kka': {'full': 'kka-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kkb': {'full': 'kkb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kkc': {'full': 'kkc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kkd': {'full': 'kkd-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kke': {'full': 'kke-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'kke-Arab': {'full': 'kke-Arab-GN', 'region': 'GN', 'script': 'Arab', 'suppress': False},
        'kkf': {'full': 'kkf-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'kkg': {'full': 'kkg-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'kkh': {'full': 'kkh-Lana-MM', 'region': 'MM', 'script': 'Lana', 'suppress': False},
        'kki': {'full': 'kki-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'kkj': {'full': 'kkj-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'kkj-TD': {'full': 'kkj-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'kkk': {'full': 'kkk-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'kkl': {'full': 'kkl-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kkm': {'full': 'kkm-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kkn': {'full': 'kkn-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'kko': {'full': 'kko-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'kkp': {'full': 'kkp-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'kkq': {'full': 'kkq-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'kkr': {'full': 'kkr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kks': {'full': 'kks-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kkt': {'full': 'kkt-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'kku': {'full': 'kku-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kkv': {'full': 'kkv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kkw': {'full': 'kkw-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'kkx': {'full': 'kkx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kky': {'full': 'kky-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'kkz': {'full': 'kkz-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'kl': {'full': 'kl-Latn-GL', 'region': 'GL', 'script': 'Latn', 'suppress': True},
        'kla': {'full': 'kla-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'klb': {'full': 'klb-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'klc': {'full': 'klc-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'kld': {'full': 'kld-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'kle': {'full': 'kle-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'klf': {'full': 'klf-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'klg': {'full': 'klg-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'klh': {'full': 'klh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kli': {'full': 'kli-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'klj': {'full': 'klj-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'klk': {'full': 'klk-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kll': {'full': 'kll-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'klm': {'full': 'klm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kln': {'full': 'kln-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'klo': {'full': 'klo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'klp': {'full': 'klp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'klq': {'full': 'klq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'klr': {'full': 'klr-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'kls': {'full': 'kls-Latn-PK', 'region': 'PK', 'script': 'Latn', 'suppress': False},
        'kls-Arab': {'full': 'kls-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'klt': {'full': 'klt-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'klu': {'full': 'klu-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'klv': {'full': 'klv-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'klw': {'full': 'klw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'klx': {'full': 'klx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kly': {'full': 'kly-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'klz': {'full': 'klz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'km': {'full': 'km-Khmr-KH', 'region': 'KH', 'script': 'Khmr', 'suppress': True},
        'kma': {'full': 'kma-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'kmb': {'full': 'kmb-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'kmc': {'full': 'kmc-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'kmc-Hani': {'full': 'kmc-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'kmd': {'full': 'kmd-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'kme': {'full': 'kme-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'kmf': {'full': 'kmf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kmg': {'full': 'kmg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kmh': {'full': 'kmh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kmi': {'full': 'kmi-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kmj': {'full': 'kmj-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'kmk': {'full': 'kmk-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'kml': {'full': 'kml-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'kmm': {'full': 'kmm-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'kmn': {'full': 'kmn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kmo': {'full': 'kmo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kmp': {'full': 'kmp-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'kmq': {'full': 'kmq-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'kms': {'full': 'kms-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kmt': {'full': 'kmt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kmu': {'full': 'kmu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kmv': {'full': 'kmv-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kmw': {'full': 'kmw-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'kmx': {'full': 'kmx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kmy': {'full': 'kmy-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kmz': {'full': 'kmz-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'kn': {'full': 'kn-Knda-IN', 'region': 'IN', 'script': 'Knda', 'suppress': True},
        'kn-Brai': {'full': 'kn-Brai-IN', 'region': 'IN', 'script': 'Brai', 'suppress': False},
        'kn-Nand': {'full': 'kn-Nand-IN', 'region': 'IN', 'script': 'Nand', 'suppress': False},
        'kna': {'full': 'kna-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'knb': {'full': 'knb-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'knd': {'full': 'knd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kne': {'full': 'kne-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'knf': {'full': 'knf-Latn-GW', 'region': 'GW', 'script': 'Latn', 'suppress': False},
        'kni': {'full': 'kni-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'knj': {'full': 'knj-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'knk': {'full': 'knk-Latn-SL', 'region': 'SL', 'script': 'Latn', 'suppress': False},
        'knk-Arab': {'full': 'knk-Arab-SL', 'region': 'SL', 'script': 'Arab', 'suppress': False},
        'knl': {'full': 'knl-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'knm': {'full': 'knm-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'knn-Knda': {'full': 'knn-Knda-IN', 'region': 'IN', 'script': 'Knda', 'suppress': False},
        'knn-Latn': {'full': 'knn-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'kno': {'full': 'kno-Latn-SL', 'region': 'SL', 'script': 'Latn', 'suppress': False},
        'knp': {'full': 'knp-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'knq': {'full': 'knq-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'knr': {'full': 'knr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kns': {'full': 'kns-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'kns-Thai': {'full': 'kns-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'knt': {'full': 'knt-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'knu': {'full': 'knu-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'knv': {'full': 'knv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'knw': {'full': 'knw-Latn-NA', 'region': 'NA', 'script': 'Latn', 'suppress': False},
        'knx': {'full': 'knx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kny': {'full': 'kny-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'knz': {'full': 'knz-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'ko': {'full': 'ko-Kore-KR', 'region': 'KR', 'script': 'Kore', 'suppress': True},
        'ko-Brai': {'full': 'ko-Brai-KR', 'region': 'KR', 'script': 'Brai', 'suppress': False},
        'ko-KP': {'full': 'ko-Kore-KP', 'region': 'KP', 'script': 'Kore', 'suppress': True},
        'ko-Latn': {'full': 'ko-Latn-KR', 'region': 'KR', 'script': 'Latn', 'suppress': False},
        'koa': {'full': 'koa-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'koc': {'full': 'koc-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kod': {'full': 'kod-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'koe': {'full': 'koe-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'kof': {'full': 'kof-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kog': {'full': 'kog-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'koh': {'full': 'koh-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'koi': {'full': 'koi-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'koi-Latn': {'full': 'koi-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'koi-Perm': {'full': 'koi-Perm-RU', 'region': 'RU', 'script': 'Perm', 'suppress': False},
        'kok': {'full': 'kok-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': True},
        'kol': {'full': 'kol-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'koo': {'full': 'koo-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'kop': {'full': 'kop-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'koq': {'full': 'koq-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'kos': {'full': 'kos-Latn-FM', 'region': 'FM', 'script': 'Latn', 'suppress': False},
        'kot': {'full': 'kot-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'kou': {'full': 'kou-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'kov': {'full': 'kov-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kow': {'full': 'kow-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'koy': {'full': 'koy-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'koz': {'full': 'koz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kpa': {'full': 'kpa-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kpb': {'full': 'kpb-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'kpc': {'full': 'kpc-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'kpd': {'full': 'kpd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kpe': {'full': 'kpe-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'kpe-Kpel': {'full': 'kpe-Kpel-LR', 'region': 'LR', 'script': 'Kpel', 'suppress': False},
        'kpf': {'full': 'kpf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kpg': {'full': 'kpg-Latn-FM', 'region': 'FM', 'script': 'Latn', 'suppress': False},
        'kph': {'full': 'kph-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'kpi': {'full': 'kpi-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kpj': {'full': 'kpj-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kpk': {'full': 'kpk-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kpl': {'full': 'kpl-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'kpm': {'full': 'kpm-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'kpn': {'full': 'kpn-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kpo': {'full': 'kpo-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'kpq': {'full': 'kpq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kpr': {'full': 'kpr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kps': {'full': 'kps-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kpt': {'full': 'kpt-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'kpu': {'full': 'kpu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kpw': {'full': 'kpw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kpx': {'full': 'kpx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kpy': {'full': 'kpy-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'kpz': {'full': 'kpz-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'kqa': {'full': 'kqa-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kqb': {'full': 'kqb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kqc': {'full': 'kqc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kqd': {'full': 'kqd-Syrc-IQ', 'region': 'IQ', 'script': 'Syrc', 'suppress': False},
        'kqe': {'full': 'kqe-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'kqf': {'full': 'kqf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kqg': {'full': 'kqg-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'kqh': {'full': 'kqh-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'kqi': {'full': 'kqi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kqj': {'full': 'kqj-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kqk': {'full': 'kqk-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'kql': {'full': 'kql-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kqm': {'full': 'kqm-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'kqn': {'full': 'kqn-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'kqo': {'full': 'kqo-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'kqp': {'full': 'kqp-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'kqq': {'full': 'kqq-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kqr': {'full': 'kqr-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'kqs': {'full': 'kqs-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'kqt': {'full': 'kqt-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'kqu': {'full': 'kqu-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': False},
        'kqv': {'full': 'kqv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kqw': {'full': 'kqw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kqx': {'full': 'kqx-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'kqy': {'full': 'kqy-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'kqy-Latn': {'full': 'kqy-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'kqz': {'full': 'kqz-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': False},
        'kr': {'full': 'kr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kr-Arab': {'full': 'kr-Arab-NG', 'region': 'NG', 'script': 'Arab', 'suppress': False},
        'kra': {'full': 'kra-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'krb': {'full': 'krb-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'krc': {'full': 'krc-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'krd': {'full': 'krd-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'kre': {'full': 'kre-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'krf': {'full': 'krf-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'krh': {'full': 'krh-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kri': {'full': 'kri-Latn-SL', 'region': 'SL', 'script': 'Latn', 'suppress': False},
        'krj': {'full': 'krj-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'krk': {'full': 'krk-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'krl': {'full': 'krl-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'krl-Cyrl': {'full': 'krl-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'krn': {'full': 'krn-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'krp': {'full': 'krp-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'krr': {'full': 'krr-Khmr-KH', 'region': 'KH', 'script': 'Khmr', 'suppress': False},
        'krs': {'full': 'krs-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'krt': {'full': 'krt-Latn-NE', 'region': 'NE', 'script': 'Latn', 'suppress': False},
        'kru': {'full': 'kru-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'kru-Deva-NP': {'full': 'kru-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'krv': {'full': 'krv-Khmr-KH', 'region': 'KH', 'script': 'Khmr', 'suppress': False},
        'krw': {'full': 'krw-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'krx': {'full': 'krx-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'kry': {'full': 'kry-Latn-AZ', 'region': 'AZ', 'script': 'Latn', 'suppress': False},
        'krz': {'full': 'krz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ks': {'full': 'ks-Arab-IN', 'region': 'IN', 'script': 'Arab', 'suppress': False},
        'ks-Deva': {'full': 'ks-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'ks-Latn': {'full': 'ks-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'ks-Shrd': {'full': 'ks-Shrd-IN', 'region': 'IN', 'script': 'Shrd', 'suppress': False},
        'ksa': {'full': 'ksa-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ksb': {'full': 'ksb-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'ksc': {'full': 'ksc-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ksd': {'full': 'ksd-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kse': {'full': 'kse-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ksf': {'full': 'ksf-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'ksg': {'full': 'ksg-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'ksh': {'full': 'ksh-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': False},
        'ksi': {'full': 'ksi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ksj': {'full': 'ksj-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ksk': {'full': 'ksk-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'ksl': {'full': 'ksl-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ksm': {'full': 'ksm-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ksn': {'full': 'ksn-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'kso': {'full': 'kso-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ksp': {'full': 'ksp-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'ksq': {'full': 'ksq-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ksr': {'full': 'ksr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kss': {'full': 'kss-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'kst': {'full': 'kst-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'ksu': {'full': 'ksu-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'ksv': {'full': 'ksv-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'ksw': {'full': 'ksw-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'ksw-Latn': {'full': 'ksw-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'ksx': {'full': 'ksx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ksy': {'full': 'ksy-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'ksz': {'full': 'ksz-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'kta': {'full': 'kta-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'ktb': {'full': 'ktb-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'ktb-Latn': {'full': 'ktb-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'ktc': {'full': 'ktc-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ktd': {'full': 'ktd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'kte': {'full': 'kte-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'ktf': {'full': 'ktf-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'ktg': {'full': 'ktg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'kth': {'full': 'kth-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'kti': {'full': 'kti-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ktj': {'full': 'ktj-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'ktk': {'full': 'ktk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ktl': {'full': 'ktl-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'ktm': {'full': 'ktm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ktn': {'full': 'ktn-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kto': {'full': 'kto-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ktp': {'full': 'ktp-Plrd-CN', 'region': 'CN', 'script': 'Plrd', 'suppress': False},
        'ktq': {'full': 'ktq-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'kts': {'full': 'kts-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ktt': {'full': 'ktt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ktu': {'full': 'ktu-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'ktv': {'full': 'ktv-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'ktw': {'full': 'ktw-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'ktx': {'full': 'ktx-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kty': {'full': 'kty-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'ktz': {'full': 'ktz-Latn-NA', 'region': 'NA', 'script': 'Latn', 'suppress': False},
        'ku': {'full': 'ku-Latn-TR', 'region': 'TR', 'script': 'Latn', 'suppress': False},
        'ku-Arab': {'full': 'ku-Arab-IQ', 'region': 'IQ', 'script': 'Arab', 'suppress': False},
        'ku-Arab-TR': {'full': 'ku-Arab-TR', 'region': 'TR', 'script': 'Arab', 'suppress': False},
        'ku-Armn': {'full': 'ku-Armn-AZ', 'region': 'AZ', 'script': 'Armn', 'suppress': False},
        'ku-Cyrl': {'full': 'ku-Cyrl-IQ', 'region': 'IQ', 'script': 'Cyrl', 'suppress': False},
        'ku-Cyrl-AZ': {'full': 'ku-Cyrl-AZ', 'region': 'AZ', 'script': 'Cyrl', 'suppress': False},
        'ku-LB': {'full': 'ku-Arab-LB', 'region': 'LB', 'script': 'Arab', 'suppress': False},
        'ku-Yezi-GE': {'full': 'ku-Yezi-GE', 'region': 'GE', 'script': 'Yezi', 'suppress': False},
        'kub': {'full': 'kub-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kuc': {'full': 'kuc-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kud': {'full': 'kud-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kue': {'full': 'kue-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kuf': {'full': 'kuf-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'kug': {'full': 'kug-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kuh': {'full': 'kuh-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kui': {'full': 'kui-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kuj': {'full': 'kuj-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'kuk': {'full': 'kuk-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kul': {'full': 'kul-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kum': {'full': 'kum-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'kum-Arab': {'full': 'kum-Arab-RU', 'region': 'RU', 'script': 'Arab', 'suppress': False},
        'kum-Latn': {'full': 'kum-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'kun': {'full': 'kun-Latn-ER', 'region': 'ER', 'script': 'Latn', 'suppress': False},
        'kuo': {'full': 'kuo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kup': {'full': 'kup-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kuq': {'full': 'kuq-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kus': {'full': 'kus-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'kut': {'full': 'kut-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'kuu': {'full': 'kuu-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'kuv': {'full': 'kuv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kuw': {'full': 'kuw-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'kux': {'full': 'kux-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'kuy': {'full': 'kuy-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'kuz': {'full': 'kuz-Latn-CL', 'region': 'CL', 'script': 'Latn', 'suppress': False},
        'kv': {'full': 'kv-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'kv-Latn': {'full': 'kv-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'kv-Perm': {'full': 'kv-Perm-RU', 'region': 'RU', 'script': 'Perm', 'suppress': False},
        'kva': {'full': 'kva-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'kvb': {'full': 'kvb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kvc': {'full': 'kvc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kvd': {'full': 'kvd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kve': {'full': 'kve-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'kvf': {'full': 'kvf-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'kvg': {'full': 'kvg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kvh': {'full': 'kvh-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kvi': {'full': 'kvi-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'kvj': {'full': 'kvj-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'kvk': {'full': 'kvk-Zxxx-KR', 'region': 'KR', 'script': 'Zxxx', 'suppress': False},
        'kvl': {'full': 'kvl-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'kvm': {'full': 'kvm-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'kvn': {'full': 'kvn-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'kvo': {'full': 'kvo-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kvp': {'full': 'kvp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kvq-Latn': {'full': 'kvq-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'kvq-Mymr': {'full': 'kvq-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'kvr': {'full': 'kvr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kvr-Rjng': {'full': 'kvr-Rjng-ID', 'region': 'ID', 'script': 'Rjng', 'suppress': False},
        'kvt': {'full': 'kvt-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'kvu': {'full': 'kvu-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'kvv': {'full': 'kvv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kvw': {'full': 'kvw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kvx': {'full': 'kvx-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'kvy': {'full': 'kvy-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'kvz': {'full': 'kvz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kw': {'full': 'kw-Latn-GB', 'region': 'GB', 'script': 'Latn', 'suppress': False},
        'kwa': {'full': 'kwa-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kwb': {'full': 'kwb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kwc': {'full': 'kwc-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'kwd': {'full': 'kwd-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'kwe': {'full': 'kwe-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kwf': {'full': 'kwf-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'kwg': {'full': 'kwg-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'kwh': {'full': 'kwh-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kwi': {'full': 'kwi-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'kwj': {'full': 'kwj-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kwk': {'full': 'kwk-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'kwl': {'full': 'kwl-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'kwm': {'full': 'kwm-Latn-NA', 'region': 'NA', 'script': 'Latn', 'suppress': False},
        'kwn': {'full': 'kwn-Latn-NA', 'region': 'NA', 'script': 'Latn', 'suppress': False},
        'kwo': {'full': 'kwo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kwp': {'full': 'kwp-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'kwr': {'full': 'kwr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kws': {'full': 'kws-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'kwt': {'full': 'kwt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kwu': {'full': 'kwu-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'kwv': {'full': 'kwv-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'kww': {'full': 'kww-Latn-SR', 'region': 'SR', 'script': 'Latn', 'suppress': False},
        'kwx': {'full': 'kwx-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'kwy': {'full': 'kwy-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'kwz': {'full': 'kwz-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'kxa': {'full': 'kxa-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kxb': {'full': 'kxb-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'kxc': {'full': 'kxc-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'kxc-Latn': {'full': 'kxc-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'kxd': {'full': 'kxd-Latn-BN', 'region': 'BN', 'script': 'Latn', 'suppress': False},
        'kxd-Arab': {'full': 'kxd-Arab-BN', 'region': 'BN', 'script': 'Arab', 'suppress': False},
        'kxf': {'full': 'kxf-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'kxf-Latn': {'full': 'kxf-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'kxf-Latn-x-manuma': {'full': 'kxf-Latn-MM-x-manuma', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'kxh': {'full': 'kxh-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'kxi': {'full': 'kxi-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'kxj': {'full': 'kxj-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'kxk': {'full': 'kxk-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'kxm': {'full': 'kxm-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'kxm-Khmr': {'full': 'kxm-Khmr-TH', 'region': 'TH', 'script': 'Khmr', 'suppress': False},
        'kxn': {'full': 'kxn-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'kxo': {'full': 'kxo-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kxp': {'full': 'kxp-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'kxp-Gujr': {'full': 'kxp-Gujr-IN', 'region': 'IN', 'script': 'Gujr', 'suppress': False},
        'kxp-x-thr': {'full': 'kxp-Arab-PK-x-thr', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'kxq': {'full': 'kxq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kxr': {'full': 'kxr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kxs': {'full': 'kxs-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'kxt': {'full': 'kxt-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kxu': {'full': 'kxu-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'kxv': {'full': 'kxv-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'kxw': {'full': 'kxw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kxx': {'full': 'kxx-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'kxy': {'full': 'kxy-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'kxz': {'full': 'kxz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ky': {'full': 'ky-Cyrl-KG', 'region': 'KG', 'script': 'Cyrl', 'suppress': False},
        'ky-CN': {'full': 'ky-Arab-CN', 'region': 'CN', 'script': 'Arab', 'suppress': False},
        'ky-TR': {'full': 'ky-Latn-TR', 'region': 'TR', 'script': 'Latn', 'suppress': False},
        'kya': {'full': 'kya-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'kyb': {'full': 'kyb-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'kyc': {'full': 'kyc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kyd': {'full': 'kyd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kye': {'full': 'kye-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'kyf': {'full': 'kyf-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'kyg': {'full': 'kyg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kyh': {'full': 'kyh-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'kyi': {'full': 'kyi-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'kyj': {'full': 'kyj-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'kyk': {'full': 'kyk-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'kyl': {'full': 'kyl-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'kym': {'full': 'kym-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'kyn': {'full': 'kyn-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'kyo': {'full': 'kyo-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kyp': {'full': 'kyp-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'kyq': {'full': 'kyq-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'kyr': {'full': 'kyr-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kys': {'full': 'kys-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'kyt': {'full': 'kyt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kyu': {'full': 'kyu-Kali-MM', 'region': 'MM', 'script': 'Kali', 'suppress': False},
        'kyu-Latn': {'full': 'kyu-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'kyu-Mymr': {'full': 'kyu-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'kyv': {'full': 'kyv-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'kyw-Beng': {'full': 'kyw-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'kyw-Deva': {'full': 'kyw-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'kyw-Orya': {'full': 'kyw-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'kyx': {'full': 'kyx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kyy': {'full': 'kyy-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kyz': {'full': 'kyz-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kza': {'full': 'kza-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'kzb': {'full': 'kzb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kzc': {'full': 'kzc-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'kzd': {'full': 'kzd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kze': {'full': 'kze-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'kzf': {'full': 'kzf-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kzg': {'full': 'kzg-Zyyy-JP', 'region': 'JP', 'script': 'Zyyy', 'suppress': False},
        'kzi': {'full': 'kzi-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'kzk': {'full': 'kzk-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'kzl': {'full': 'kzl-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kzm': {'full': 'kzm-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kzn': {'full': 'kzn-Latn-MW', 'region': 'MW', 'script': 'Latn', 'suppress': False},
        'kzo': {'full': 'kzo-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'kzp': {'full': 'kzp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kzq': {'full': 'kzq-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'kzr': {'full': 'kzr-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'kzs': {'full': 'kzs-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'kzu': {'full': 'kzu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kzv': {'full': 'kzv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kzw': {'full': 'kzw-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'kzx': {'full': 'kzx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'kzy': {'full': 'kzy-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'kzz': {'full': 'kzz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'la': {'full': 'la-Latn-VA', 'region': 'VA', 'script': 'Latn', 'suppress': True},
        'laa': {'full': 'laa-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'lab': {'full': 'lab-Lina-GR', 'region': 'GR', 'script': 'Lina', 'suppress': False},
        'lac': {'full': 'lac-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'lad': {'full': 'lad-Hebr-IL', 'region': 'IL', 'script': 'Hebr', 'suppress': False},
        'lad-Cyrl': {'full': 'lad-Cyrl-TR', 'region': 'TR', 'script': 'Cyrl', 'suppress': False},
        'lad-Latn': {'full': 'lad-Latn-TR', 'region': 'TR', 'script': 'Latn', 'suppress': False},
        'lae': {'full': 'lae-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'lae-Tibt': {'full': 'lae-Tibt-IN', 'region': 'IN', 'script': 'Tibt', 'suppress': False},
        'laf': {'full': 'laf-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'lag': {'full': 'lag-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'lah': {'full': 'lah-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'lah-Khoj': {'full': 'lah-Khoj-PK', 'region': 'PK', 'script': 'Khoj', 'suppress': False},
        'lah-Latn': {'full': 'lah-Latn-PK', 'region': 'PK', 'script': 'Latn', 'suppress': False},
        'lah-Mahj-IN': {'full': 'lah-Mahj-IN', 'region': 'IN', 'script': 'Mahj', 'suppress': False},
        'lah-Zzzz-PK': {'full': 'lah-Zzzz-PK', 'region': 'PK', 'script': 'Zzzz', 'suppress': False},
        'lai': {'full': 'lai-Latn-MW', 'region': 'MW', 'script': 'Latn', 'suppress': False},
        'laj': {'full': 'laj-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'lak': {'full': 'lak-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'lal': {'full': 'lal-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'lam': {'full': 'lam-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'lan': {'full': 'lan-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'lap': {'full': 'lap-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'laq': {'full': 'laq-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'lar': {'full': 'lar-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'las': {'full': 'las-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'lau': {'full': 'lau-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'law': {'full': 'law-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lax-Beng': {'full': 'lax-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'lax-Latn': {'full': 'lax-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'lay': {'full': 'lay-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'laz': {'full': 'laz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lb': {'full': 'lb-Latn-LU', 'region': 'LU', 'script': 'Latn', 'suppress': True},
        'lba': {'full': 'lba-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'lbb': {'full': 'lbb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lbc': {'full': 'lbc-Lisu-CN', 'region': 'CN', 'script': 'Lisu', 'suppress': False},
        'lbe': {'full': 'lbe-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'lbf-Deva': {'full': 'lbf-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'lbf-Tibt': {'full': 'lbf-Tibt-CN', 'region': 'CN', 'script': 'Tibt', 'suppress': False},
        'lbg': {'full': 'lbg-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'lbi': {'full': 'lbi-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'lbj': {'full': 'lbj-Tibt-IN', 'region': 'IN', 'script': 'Tibt', 'suppress': False},
        'lbl': {'full': 'lbl-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'lbm': {'full': 'lbm-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'lbn-Laoo': {'full': 'lbn-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'lbn-Latn': {'full': 'lbn-Latn-LA', 'region': 'LA', 'script': 'Latn', 'suppress': False},
        'lbo': {'full': 'lbo-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'lbq': {'full': 'lbq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lbr': {'full': 'lbr-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'lbs': {'full': 'lbs-Zxxx-LY', 'region': 'LY', 'script': 'Zxxx', 'suppress': False},
        'lbt': {'full': 'lbt-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'lbu': {'full': 'lbu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lbv': {'full': 'lbv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lbw': {'full': 'lbw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lbx': {'full': 'lbx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lby': {'full': 'lby-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'lbz': {'full': 'lbz-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'lcc': {'full': 'lcc-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lcd': {'full': 'lcd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lce': {'full': 'lce-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lcf': {'full': 'lcf-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lch': {'full': 'lch-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'lcl': {'full': 'lcl-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lcm': {'full': 'lcm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lcp': {'full': 'lcp-Thai-CN', 'region': 'CN', 'script': 'Thai', 'suppress': False},
        'lcq': {'full': 'lcq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lcs': {'full': 'lcs-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lda': {'full': 'lda-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'ldb': {'full': 'ldb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ldd': {'full': 'ldd-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ldg': {'full': 'ldg-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ldh': {'full': 'ldh-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ldi': {'full': 'ldi-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'ldj': {'full': 'ldj-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ldk': {'full': 'ldk-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ldl': {'full': 'ldl-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ldm': {'full': 'ldm-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'ldn': {'full': 'ldn-Zyyy-001', 'region': '001', 'script': 'Zyyy', 'suppress': False},
        'ldo': {'full': 'ldo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ldp': {'full': 'ldp-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ldq': {'full': 'ldq-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'lea': {'full': 'lea-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'leb': {'full': 'leb-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'lec': {'full': 'lec-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'led': {'full': 'led-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'lee': {'full': 'lee-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'lef': {'full': 'lef-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'leh': {'full': 'leh-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'lei': {'full': 'lei-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lej': {'full': 'lej-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'lek': {'full': 'lek-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lel': {'full': 'lel-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'lem': {'full': 'lem-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'len': {'full': 'len-Latn-HN', 'region': 'HN', 'script': 'Latn', 'suppress': False},
        'leo': {'full': 'leo-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'lep': {'full': 'lep-Lepc-IN', 'region': 'IN', 'script': 'Lepc', 'suppress': False},
        'lep-Tibt': {'full': 'lep-Tibt-IN', 'region': 'IN', 'script': 'Tibt', 'suppress': False},
        'leq': {'full': 'leq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ler': {'full': 'ler-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'les': {'full': 'les-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'let': {'full': 'let-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'leu': {'full': 'leu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lev': {'full': 'lev-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lew': {'full': 'lew-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lex': {'full': 'lex-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ley': {'full': 'ley-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lez': {'full': 'lez-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'lez-Aghb': {'full': 'lez-Aghb-AZ', 'region': 'AZ', 'script': 'Aghb', 'suppress': False},
        'lfa': {'full': 'lfa-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'lfn': {'full': 'lfn-Latn-001', 'region': '001', 'script': 'Latn', 'suppress': False},
        'lfn-Cyrl': {'full': 'lfn-Cyrl-001', 'region': '001', 'script': 'Cyrl', 'suppress': False},
        'lg': {'full': 'lg-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'lg-Arab': {'full': 'lg-Arab-UG', 'region': 'UG', 'script': 'Arab', 'suppress': False},
        'lga': {'full': 'lga-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'lgb': {'full': 'lgb-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'lgg': {'full': 'lgg-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'lgg-Arab': {'full': 'lgg-Arab-UG', 'region': 'UG', 'script': 'Arab', 'suppress': False},
        'lgh': {'full': 'lgh-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'lgi': {'full': 'lgi-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lgk': {'full': 'lgk-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'lgl': {'full': 'lgl-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'lgm': {'full': 'lgm-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'lgn': {'full': 'lgn-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'lgq': {'full': 'lgq-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'lgr': {'full': 'lgr-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'lgt': {'full': 'lgt-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lgu': {'full': 'lgu-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'lgz': {'full': 'lgz-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'lha': {'full': 'lha-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'lhh': {'full': 'lhh-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lhi': {'full': 'lhi-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'lhl': {'full': 'lhl-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'lhm': {'full': 'lhm-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'lhn': {'full': 'lhn-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'lhp': {'full': 'lhp-Zyyy-BT', 'region': 'BT', 'script': 'Zyyy', 'suppress': False},
        'lhs': {'full': 'lhs-Syrc-SY', 'region': 'SY', 'script': 'Syrc', 'suppress': False},
        'lht': {'full': 'lht-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'lhu': {'full': 'lhu-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'li': {'full': 'li-Latn-NL', 'region': 'NL', 'script': 'Latn', 'suppress': False},
        'lia': {'full': 'lia-Latn-SL', 'region': 'SL', 'script': 'Latn', 'suppress': False},
        'lib': {'full': 'lib-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lic': {'full': 'lic-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'lid': {'full': 'lid-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lie': {'full': 'lie-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'lif': {'full': 'lif-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'lif-Limb': {'full': 'lif-Limb-IN', 'region': 'IN', 'script': 'Limb', 'suppress': False},
        'lig': {'full': 'lig-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'lih': {'full': 'lih-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lij': {'full': 'lij-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'lik': {'full': 'lik-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'lil': {'full': 'lil-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'lil-Dupl': {'full': 'lil-Dupl-CA', 'region': 'CA', 'script': 'Dupl', 'suppress': False},
        'lio': {'full': 'lio-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lip': {'full': 'lip-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'liq': {'full': 'liq-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'lir': {'full': 'lir-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'lis': {'full': 'lis-Lisu-CN', 'region': 'CN', 'script': 'Lisu', 'suppress': False},
        'lis-Latn': {'full': 'lis-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'liu': {'full': 'liu-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'liv': {'full': 'liv-Latn-LV', 'region': 'LV', 'script': 'Latn', 'suppress': False},
        'liw': {'full': 'liw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lix': {'full': 'lix-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'liy': {'full': 'liy-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'liz': {'full': 'liz-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'lja': {'full': 'lja-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'lje': {'full': 'lje-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lji': {'full': 'lji-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ljl': {'full': 'ljl-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ljp': {'full': 'ljp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ljp-Rjng': {'full': 'ljp-Rjng-ID', 'region': 'ID', 'script': 'Rjng', 'suppress': False},
        'ljw': {'full': 'ljw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ljx': {'full': 'ljx-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'lka': {'full': 'lka-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'lkb': {'full': 'lkb-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'lkc': {'full': 'lkc-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'lkd': {'full': 'lkd-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'lke': {'full': 'lke-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'lkh': {'full': 'lkh-Zyyy-BT', 'region': 'BT', 'script': 'Zyyy', 'suppress': False},
        'lki': {'full': 'lki-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'lkj': {'full': 'lkj-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'lkl': {'full': 'lkl-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lkm': {'full': 'lkm-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'lkn': {'full': 'lkn-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'lko': {'full': 'lko-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'lkr': {'full': 'lkr-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'lks': {'full': 'lks-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'lkt': {'full': 'lkt-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'lku': {'full': 'lku-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'lky': {'full': 'lky-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'lla': {'full': 'lla-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'llb': {'full': 'llb-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'llc': {'full': 'llc-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'lld': {'full': 'lld-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'lle': {'full': 'lle-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'llf': {'full': 'llf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'llg': {'full': 'llg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'llh': {'full': 'llh-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'lli': {'full': 'lli-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'llj': {'full': 'llj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'llk': {'full': 'llk-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'lll': {'full': 'lll-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'llm': {'full': 'llm-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lln': {'full': 'lln-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'llp': {'full': 'llp-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'llq': {'full': 'llq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lls': {'full': 'lls-Zxxx-LT', 'region': 'LT', 'script': 'Zxxx', 'suppress': False},
        'llu': {'full': 'llu-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'llx': {'full': 'llx-Latn-FJ', 'region': 'FJ', 'script': 'Latn', 'suppress': False},
        'lma': {'full': 'lma-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'lmb': {'full': 'lmb-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'lmc': {'full': 'lmc-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'lmd': {'full': 'lmd-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'lme': {'full': 'lme-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'lmf': {'full': 'lmf-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lmg': {'full': 'lmg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lmh': {'full': 'lmh-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'lmi': {'full': 'lmi-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'lmj': {'full': 'lmj-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lmk': {'full': 'lmk-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'lmk-Mymr': {'full': 'lmk-Mymr-IN', 'region': 'IN', 'script': 'Mymr', 'suppress': False},
        'lml': {'full': 'lml-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'lmn': {'full': 'lmn-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'lmn-Deva': {'full': 'lmn-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'lmn-Knda': {'full': 'lmn-Knda-IN', 'region': 'IN', 'script': 'Knda', 'suppress': False},
        'lmo': {'full': 'lmo-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'lmp': {'full': 'lmp-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'lmq': {'full': 'lmq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lmr': {'full': 'lmr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lmu': {'full': 'lmu-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'lmv': {'full': 'lmv-Latn-FJ', 'region': 'FJ', 'script': 'Latn', 'suppress': False},
        'lmw': {'full': 'lmw-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'lmx': {'full': 'lmx-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'lmy': {'full': 'lmy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lmz': {'full': 'lmz-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'ln': {'full': 'ln-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': True},
        'ln-AO': {'full': 'ln-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': True},
        'lna': {'full': 'lna-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'lnb': {'full': 'lnb-Latn-NA', 'region': 'NA', 'script': 'Latn', 'suppress': False},
        'lnd': {'full': 'lnd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lng': {'full': 'lng-Zyyy-HU', 'region': 'HU', 'script': 'Zyyy', 'suppress': False},
        'lnh': {'full': 'lnh-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'lni': {'full': 'lni-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lnj': {'full': 'lnj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'lnl': {'full': 'lnl-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'lnm': {'full': 'lnm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lnn': {'full': 'lnn-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'lno': {'full': 'lno-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'lns': {'full': 'lns-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'lnu': {'full': 'lnu-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'lnw': {'full': 'lnw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'lnz': {'full': 'lnz-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'lo': {'full': 'lo-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': True},
        'loa': {'full': 'loa-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lob': {'full': 'lob-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'loc': {'full': 'loc-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'loe': {'full': 'loe-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lof': {'full': 'lof-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'log': {'full': 'log-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'loh': {'full': 'loh-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'loi': {'full': 'loi-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'loj': {'full': 'loj-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lok': {'full': 'lok-Latn-SL', 'region': 'SL', 'script': 'Latn', 'suppress': False},
        'lol': {'full': 'lol-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'lom': {'full': 'lom-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'lom-Loma': {'full': 'lom-Loma-LR', 'region': 'LR', 'script': 'Loma', 'suppress': False},
        'lon': {'full': 'lon-Latn-MW', 'region': 'MW', 'script': 'Latn', 'suppress': False},
        'loo': {'full': 'loo-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'lop': {'full': 'lop-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'loq': {'full': 'loq-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'lor': {'full': 'lor-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'los': {'full': 'los-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lot': {'full': 'lot-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'lot-Arab': {'full': 'lot-Arab-SS', 'region': 'SS', 'script': 'Arab', 'suppress': False},
        'lou': {'full': 'lou-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'lov': {'full': 'lov-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'low': {'full': 'low-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'lox': {'full': 'lox-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'loy': {'full': 'loy-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'loy-Tibt': {'full': 'loy-Tibt-NP', 'region': 'NP', 'script': 'Tibt', 'suppress': False},
        'loz': {'full': 'loz-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'lpa': {'full': 'lpa-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'lpe': {'full': 'lpe-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lpn': {'full': 'lpn-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'lpo': {'full': 'lpo-Plrd-CN', 'region': 'CN', 'script': 'Plrd', 'suppress': False},
        'lpo-Lisu': {'full': 'lpo-Lisu-CN', 'region': 'CN', 'script': 'Lisu', 'suppress': False},
        'lpx': {'full': 'lpx-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'lra': {'full': 'lra-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'lrc': {'full': 'lrc-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'lrc-IQ': {'full': 'lrc-Arab-IQ', 'region': 'IQ', 'script': 'Arab', 'suppress': False},
        'lre': {'full': 'lre-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'lrg': {'full': 'lrg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'lri': {'full': 'lri-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'lrk': {'full': 'lrk-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'lrl': {'full': 'lrl-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'lrm': {'full': 'lrm-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'lrn': {'full': 'lrn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lro': {'full': 'lro-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'lrr': {'full': 'lrr-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'lrt': {'full': 'lrt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lrv': {'full': 'lrv-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'lrz': {'full': 'lrz-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'lsa': {'full': 'lsa-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'lsd': {'full': 'lsd-Hebr-IL', 'region': 'IL', 'script': 'Hebr', 'suppress': False},
        'lse': {'full': 'lse-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'lsg': {'full': 'lsg-Zxxx-FR', 'region': 'FR', 'script': 'Zxxx', 'suppress': False},
        'lsh': {'full': 'lsh-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'lsi': {'full': 'lsi-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'lsl': {'full': 'lsl-Zxxx-LV', 'region': 'LV', 'script': 'Zxxx', 'suppress': False},
        'lsm': {'full': 'lsm-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'lsn': {'full': 'lsn-Zxxx-CN', 'region': 'CN', 'script': 'Zxxx', 'suppress': False},
        'lso': {'full': 'lso-Zxxx-LA', 'region': 'LA', 'script': 'Zxxx', 'suppress': False},
        'lsp': {'full': 'lsp-Zxxx-PA', 'region': 'PA', 'script': 'Zxxx', 'suppress': False},
        'lsr': {'full': 'lsr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lss': {'full': 'lss-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'lst': {'full': 'lst-Zxxx-TT', 'region': 'TT', 'script': 'Zxxx', 'suppress': False},
        'lsv': {'full': 'lsv-Zxxx-PE', 'region': 'PE', 'script': 'Zxxx', 'suppress': False},
        'lsy': {'full': 'lsy-Zxxx-MU', 'region': 'MU', 'script': 'Zxxx', 'suppress': False},
        'lt': {'full': 'lt-Latn-LT', 'region': 'LT', 'script': 'Latn', 'suppress': True},
        'lt-Latf': {'full': 'lt-Latf-LT', 'region': 'LT', 'script': 'Latf', 'suppress': False},
        'ltc': {'full': 'ltc-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ltg': {'full': 'ltg-Latn-LV', 'region': 'LV', 'script': 'Latn', 'suppress': False},
        'lth': {'full': 'lth-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'lti': {'full': 'lti-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ltn': {'full': 'ltn-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'lto': {'full': 'lto-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'lts': {'full': 'lts-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'ltu': {'full': 'ltu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lu': {'full': 'lu-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'lua': {'full': 'lua-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'luc': {'full': 'luc-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'lud': {'full': 'lud-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'lue': {'full': 'lue-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'luf': {'full': 'luf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'lui': {'full': 'lui-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'luj': {'full': 'luj-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'luk': {'full': 'luk-Zyyy-BT', 'region': 'BT', 'script': 'Zyyy', 'suppress': False},
        'lul': {'full': 'lul-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'lum': {'full': 'lum-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'lun': {'full': 'lun-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'luo': {'full': 'luo-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'lup': {'full': 'lup-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'luq': {'full': 'luq-Latn-CU', 'region': 'CU', 'script': 'Latn', 'suppress': False},
        'lur': {'full': 'lur-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lus': {'full': 'lus-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'lus-Beng': {'full': 'lus-Beng-BD', 'region': 'BD', 'script': 'Beng', 'suppress': False},
        'lus-Brai': {'full': 'lus-Brai-IN', 'region': 'IN', 'script': 'Brai', 'suppress': False},
        'lut': {'full': 'lut-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'luu': {'full': 'luu-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'luv': {'full': 'luv-Zyyy-OM', 'region': 'OM', 'script': 'Zyyy', 'suppress': False},
        'luw': {'full': 'luw-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'luy': {'full': 'luy-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'luz': {'full': 'luz-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'lv': {'full': 'lv-Latn-LV', 'region': 'LV', 'script': 'Latn', 'suppress': True},
        'lv-Brai': {'full': 'lv-Brai-LV', 'region': 'LV', 'script': 'Brai', 'suppress': False},
        'lva': {'full': 'lva-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'lvi': {'full': 'lvi-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'lvk': {'full': 'lvk-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'lvu': {'full': 'lvu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lwa': {'full': 'lwa-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'lwe': {'full': 'lwe-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lwg': {'full': 'lwg-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'lwh': {'full': 'lwh-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'lwl': {'full': 'lwl-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'lwm': {'full': 'lwm-Thai-CN', 'region': 'CN', 'script': 'Thai', 'suppress': False},
        'lwo': {'full': 'lwo-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'lwo-ZA': {'full': 'lwo-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': False},
        'lws': {'full': 'lws-Zxxx-MW', 'region': 'MW', 'script': 'Zxxx', 'suppress': False},
        'lwt': {'full': 'lwt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'lwu': {'full': 'lwu-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'lww': {'full': 'lww-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'lya': {'full': 'lya-Zyyy-BT', 'region': 'BT', 'script': 'Zyyy', 'suppress': False},
        'lyg': {'full': 'lyg-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'lyn': {'full': 'lyn-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'lzh': {'full': 'lzh-Hans-CN', 'region': 'CN', 'script': 'Hans', 'suppress': False},
        'lzh-Hant': {'full': 'lzh-Hant-CN', 'region': 'CN', 'script': 'Hant', 'suppress': False},
        'lzl': {'full': 'lzl-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'lzn': {'full': 'lzn-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'lzz': {'full': 'lzz-Latn-TR', 'region': 'TR', 'script': 'Latn', 'suppress': False},
        'lzz-Geor': {'full': 'lzz-Geor-TR', 'region': 'TR', 'script': 'Geor', 'suppress': False},
        'maa': {'full': 'maa-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mab': {'full': 'mab-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mad': {'full': 'mad-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mae': {'full': 'mae-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'maf': {'full': 'maf-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mag': {'full': 'mag-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'mai': {'full': 'mai-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': True},
        'mai-Kthi': {'full': 'mai-Kthi-IN', 'region': 'IN', 'script': 'Kthi', 'suppress': False},
        'mai-Newa': {'full': 'mai-Newa-IN', 'region': 'IN', 'script': 'Newa', 'suppress': False},
        'mai-Tirh': {'full': 'mai-Tirh-IN', 'region': 'IN', 'script': 'Tirh', 'suppress': False},
        'maj': {'full': 'maj-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mak': {'full': 'mak-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mak-Bugi': {'full': 'mak-Bugi-ID', 'region': 'ID', 'script': 'Bugi', 'suppress': False},
        'mak-Maka': {'full': 'mak-Maka-ID', 'region': 'ID', 'script': 'Maka', 'suppress': False},
        'mam': {'full': 'mam-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'man': {'full': 'man-Latn-GM', 'region': 'GM', 'script': 'Latn', 'suppress': False},
        'man-Arab': {'full': 'man-Arab-GN', 'region': 'GN', 'script': 'Arab', 'suppress': False},
        'man-GN': {'full': 'man-Nkoo-GN', 'region': 'GN', 'script': 'Nkoo', 'suppress': False},
        'man-Latn-GN': {'full': 'man-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'maq': {'full': 'maq-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mas': {'full': 'mas-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'mas-TZ': {'full': 'mas-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'mat': {'full': 'mat-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mau': {'full': 'mau-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mav': {'full': 'mav-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'maw': {'full': 'maw-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'maw-Arab': {'full': 'maw-Arab-GH', 'region': 'GH', 'script': 'Arab', 'suppress': False},
        'max': {'full': 'max-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'maz': {'full': 'maz-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mba': {'full': 'mba-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'mbb': {'full': 'mbb-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'mbc': {'full': 'mbc-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'mbd': {'full': 'mbd-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'mbe': {'full': 'mbe-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'mbf': {'full': 'mbf-Latn-SG', 'region': 'SG', 'script': 'Latn', 'suppress': False},
        'mbh': {'full': 'mbh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mbi': {'full': 'mbi-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'mbj': {'full': 'mbj-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'mbk': {'full': 'mbk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mbl': {'full': 'mbl-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'mbm': {'full': 'mbm-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'mbn': {'full': 'mbn-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'mbo': {'full': 'mbo-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mbp': {'full': 'mbp-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'mbq': {'full': 'mbq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mbr': {'full': 'mbr-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'mbs': {'full': 'mbs-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'mbt': {'full': 'mbt-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'mbu': {'full': 'mbu-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mbv': {'full': 'mbv-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'mbw': {'full': 'mbw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mbx': {'full': 'mbx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mby': {'full': 'mby-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'mbz': {'full': 'mbz-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mca': {'full': 'mca-Latn-PY', 'region': 'PY', 'script': 'Latn', 'suppress': False},
        'mcb': {'full': 'mcb-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'mcc': {'full': 'mcc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mcd': {'full': 'mcd-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'mce': {'full': 'mce-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mcf': {'full': 'mcf-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'mcg': {'full': 'mcg-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'mch': {'full': 'mch-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'mci': {'full': 'mci-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mcj': {'full': 'mcj-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mck': {'full': 'mck-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'mcl': {'full': 'mcl-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'mcm': {'full': 'mcm-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'mcn': {'full': 'mcn-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'mco': {'full': 'mco-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mcp': {'full': 'mcp-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mcq': {'full': 'mcq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mcr': {'full': 'mcr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mcs': {'full': 'mcs-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mct': {'full': 'mct-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mcu': {'full': 'mcu-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mcu-Laoo-CM': {'full': 'mcu-Laoo-CM', 'region': 'CM', 'script': 'Laoo', 'suppress': False},
        'mcv': {'full': 'mcv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mcw': {'full': 'mcw-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'mcx': {'full': 'mcx-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'mcy': {'full': 'mcy-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mcz': {'full': 'mcz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mda': {'full': 'mda-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mdb': {'full': 'mdb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mdc': {'full': 'mdc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mdd': {'full': 'mdd-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mde': {'full': 'mde-Arab-TD', 'region': 'TD', 'script': 'Arab', 'suppress': False},
        'mde-Latn': {'full': 'mde-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'mdf': {'full': 'mdf-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'mdg': {'full': 'mdg-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'mdh': {'full': 'mdh-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'mdi': {'full': 'mdi-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'mdj': {'full': 'mdj-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'mdk': {'full': 'mdk-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'mdl': {'full': 'mdl-Zxxx-MT', 'region': 'MT', 'script': 'Zxxx', 'suppress': False},
        'mdm': {'full': 'mdm-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'mdn': {'full': 'mdn-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'mdp': {'full': 'mdp-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'mdq': {'full': 'mdq-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'mdr': {'full': 'mdr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mdr-Bugi': {'full': 'mdr-Bugi-ID', 'region': 'ID', 'script': 'Bugi', 'suppress': False},
        'mds': {'full': 'mds-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mdt': {'full': 'mdt-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'mdu': {'full': 'mdu-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'mdv': {'full': 'mdv-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mdw': {'full': 'mdw-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'mdx': {'full': 'mdx-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'mdx-Latn': {'full': 'mdx-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'mdy': {'full': 'mdy-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'mdy-Latn': {'full': 'mdy-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'mdz': {'full': 'mdz-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'mea': {'full': 'mea-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'meb': {'full': 'meb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mec': {'full': 'mec-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'med': {'full': 'med-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mee': {'full': 'mee-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mef': {'full': 'mef-Zyyy-BD', 'region': 'BD', 'script': 'Zyyy', 'suppress': False},
        'meh': {'full': 'meh-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mei': {'full': 'mei-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'mej': {'full': 'mej-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mek': {'full': 'mek-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mel': {'full': 'mel-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'mem': {'full': 'mem-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'men': {'full': 'men-Latn-SL', 'region': 'SL', 'script': 'Latn', 'suppress': True},
        'men-Mend': {'full': 'men-Mend-SL', 'region': 'SL', 'script': 'Mend', 'suppress': False},
        'meo': {'full': 'meo-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'meo-Arab': {'full': 'meo-Arab-MY', 'region': 'MY', 'script': 'Arab', 'suppress': False},
        'mep': {'full': 'mep-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'meq': {'full': 'meq-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mer': {'full': 'mer-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'mes': {'full': 'mes-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'met': {'full': 'met-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'meu': {'full': 'meu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mev': {'full': 'mev-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'mew': {'full': 'mew-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mey': {'full': 'mey-Latn-MR', 'region': 'MR', 'script': 'Latn', 'suppress': False},
        'mey-Arab': {'full': 'mey-Arab-MR', 'region': 'MR', 'script': 'Arab', 'suppress': False},
        'mez': {'full': 'mez-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'mfa': {'full': 'mfa-Arab-TH', 'region': 'TH', 'script': 'Arab', 'suppress': False},
        'mfa-Thai': {'full': 'mfa-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'mfb': {'full': 'mfb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mfc': {'full': 'mfc-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'mfd': {'full': 'mfd-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mfe': {'full': 'mfe-Latn-MU', 'region': 'MU', 'script': 'Latn', 'suppress': False},
        'mff': {'full': 'mff-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mfg': {'full': 'mfg-Arab-GN', 'region': 'GN', 'script': 'Arab', 'suppress': False},
        'mfh': {'full': 'mfh-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mfi': {'full': 'mfi-Arab-CM', 'region': 'CM', 'script': 'Arab', 'suppress': False},
        'mfi-Latn': {'full': 'mfi-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mfj': {'full': 'mfj-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mfk': {'full': 'mfk-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mfl': {'full': 'mfl-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mfm': {'full': 'mfm-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mfn': {'full': 'mfn-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mfo': {'full': 'mfo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mfp': {'full': 'mfp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mfq': {'full': 'mfq-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'mfr': {'full': 'mfr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'mfs': {'full': 'mfs-Zxxx-MX', 'region': 'MX', 'script': 'Zxxx', 'suppress': False},
        'mft': {'full': 'mft-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mfu': {'full': 'mfu-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'mfv': {'full': 'mfv-Latn-GW', 'region': 'GW', 'script': 'Latn', 'suppress': False},
        'mfw': {'full': 'mfw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mfx': {'full': 'mfx-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'mfy': {'full': 'mfy-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mfz': {'full': 'mfz-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'mg': {'full': 'mg-Latn-MG', 'region': 'MG', 'script': 'Latn', 'suppress': True},
        'mg-Arab': {'full': 'mg-Arab-MG', 'region': 'MG', 'script': 'Arab', 'suppress': False},
        'mg-Brai': {'full': 'mg-Brai-MG', 'region': 'MG', 'script': 'Brai', 'suppress': False},
        'mga': {'full': 'mga-Latg-IE', 'region': 'IE', 'script': 'Latg', 'suppress': False},
        'mgb': {'full': 'mgb-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'mgc': {'full': 'mgc-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'mgd': {'full': 'mgd-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'mgd-Arab': {'full': 'mgd-Arab-SS', 'region': 'SS', 'script': 'Arab', 'suppress': False},
        'mge': {'full': 'mge-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'mgf': {'full': 'mgf-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mgg': {'full': 'mgg-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mgh': {'full': 'mgh-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'mgi': {'full': 'mgi-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mgj': {'full': 'mgj-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mgk': {'full': 'mgk-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mgl': {'full': 'mgl-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mgm': {'full': 'mgm-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'mgn': {'full': 'mgn-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'mgo': {'full': 'mgo-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mgp': {'full': 'mgp-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'mgp-Brah-x-akkha': {'full': 'mgp-Brah-NP-x-akkha', 'region': 'NP', 'script': 'Brah', 'suppress': False},
        'mgq': {'full': 'mgq-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'mgr': {'full': 'mgr-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'mgs': {'full': 'mgs-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'mgt': {'full': 'mgt-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mgu': {'full': 'mgu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mgv': {'full': 'mgv-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'mgw': {'full': 'mgw-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'mgy': {'full': 'mgy-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'mgz': {'full': 'mgz-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'mh': {'full': 'mh-Latn-MH', 'region': 'MH', 'script': 'Latn', 'suppress': True},
        'mha': {'full': 'mha-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'mhb': {'full': 'mhb-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'mhc': {'full': 'mhc-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mhd': {'full': 'mhd-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'mhe': {'full': 'mhe-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'mhf': {'full': 'mhf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mhg': {'full': 'mhg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'mhi': {'full': 'mhi-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'mhj': {'full': 'mhj-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'mhk': {'full': 'mhk-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mhl': {'full': 'mhl-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mhm': {'full': 'mhm-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'mhn': {'full': 'mhn-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'mho': {'full': 'mho-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'mhp': {'full': 'mhp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mhq': {'full': 'mhq-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'mhs': {'full': 'mhs-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mht': {'full': 'mht-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'mhu': {'full': 'mhu-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'mhw': {'full': 'mhw-Latn-BW', 'region': 'BW', 'script': 'Latn', 'suppress': False},
        'mhx': {'full': 'mhx-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'mhy': {'full': 'mhy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mhz': {'full': 'mhz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mi': {'full': 'mi-Latn-NZ', 'region': 'NZ', 'script': 'Latn', 'suppress': False},
        'mia': {'full': 'mia-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'mib': {'full': 'mib-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mic': {'full': 'mic-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'mic-Zzzz-x-kauder': {'full': 'mic-Zzzz-CA-x-kauder', 'region': 'CA', 'script': 'Zzzz', 'suppress': False},
        'mid': {'full': 'mid-Mand-IQ', 'region': 'IQ', 'script': 'Mand', 'suppress': False},
        'mie': {'full': 'mie-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mif': {'full': 'mif-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mig': {'full': 'mig-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mih': {'full': 'mih-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mii': {'full': 'mii-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mij': {'full': 'mij-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mik': {'full': 'mik-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'mil': {'full': 'mil-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mim': {'full': 'mim-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'min': {'full': 'min-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'min-Arab': {'full': 'min-Arab-ID', 'region': 'ID', 'script': 'Arab', 'suppress': False},
        'mio': {'full': 'mio-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mip': {'full': 'mip-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'miq': {'full': 'miq-Latn-NI', 'region': 'NI', 'script': 'Latn', 'suppress': False},
        'mir': {'full': 'mir-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mis': {'full': 'mis-Hatr-IQ', 'region': 'IQ', 'script': 'Hatr', 'suppress': False},
        'mit': {'full': 'mit-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'miu': {'full': 'miu-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'miw': {'full': 'miw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mix': {'full': 'mix-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'miy': {'full': 'miy-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'miz': {'full': 'miz-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mjb': {'full': 'mjb-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'mjc': {'full': 'mjc-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mjd': {'full': 'mjd-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'mje': {'full': 'mje-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'mjg': {'full': 'mjg-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'mjh': {'full': 'mjh-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'mji': {'full': 'mji-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'mjj': {'full': 'mjj-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mjk': {'full': 'mjk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mjl': {'full': 'mjl-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'mjl-Takr': {'full': 'mjl-Takr-IN', 'region': 'IN', 'script': 'Takr', 'suppress': False},
        'mjm': {'full': 'mjm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mjn': {'full': 'mjn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mjo': {'full': 'mjo-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'mjp': {'full': 'mjp-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'mjq': {'full': 'mjq-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'mjr': {'full': 'mjr-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'mjs': {'full': 'mjs-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mjt': {'full': 'mjt-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'mjt-Beng': {'full': 'mjt-Beng-BD', 'region': 'BD', 'script': 'Beng', 'suppress': False},
        'mju': {'full': 'mju-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'mjv': {'full': 'mjv-Mlym-IN', 'region': 'IN', 'script': 'Mlym', 'suppress': False},
        'mjw': {'full': 'mjw-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'mjx': {'full': 'mjx-Latn-BD', 'region': 'BD', 'script': 'Latn', 'suppress': False},
        'mjy': {'full': 'mjy-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'mjz': {'full': 'mjz-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'mk': {'full': 'mk-Cyrl-MK', 'region': 'MK', 'script': 'Cyrl', 'suppress': True},
        'mk-Brai': {'full': 'mk-Brai-MK', 'region': 'MK', 'script': 'Brai', 'suppress': False},
        'mka': {'full': 'mka-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'mkb': {'full': 'mkb-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'mkc': {'full': 'mkc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mke': {'full': 'mke-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'mkf': {'full': 'mkf-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mkg': {'full': 'mkg-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'mki': {'full': 'mki-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'mkj': {'full': 'mkj-Latn-FM', 'region': 'FM', 'script': 'Latn', 'suppress': False},
        'mkk': {'full': 'mkk-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mkl': {'full': 'mkl-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'mkm': {'full': 'mkm-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'mkn': {'full': 'mkn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mko': {'full': 'mko-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mkp': {'full': 'mkp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mkq': {'full': 'mkq-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'mkr': {'full': 'mkr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mks': {'full': 'mks-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mkt': {'full': 'mkt-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'mku': {'full': 'mku-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'mkv': {'full': 'mkv-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mkw': {'full': 'mkw-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'mkx': {'full': 'mkx-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'mky': {'full': 'mky-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mkz': {'full': 'mkz-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'ml': {'full': 'ml-Mlym-IN', 'region': 'IN', 'script': 'Mlym', 'suppress': True},
        'ml-Arab': {'full': 'ml-Arab-IN', 'region': 'IN', 'script': 'Arab', 'suppress': False},
        'ml-Brai': {'full': 'ml-Brai-IN', 'region': 'IN', 'script': 'Brai', 'suppress': False},
        'mla': {'full': 'mla-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mlb': {'full': 'mlb-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mlc': {'full': 'mlc-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'mle': {'full': 'mle-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mlf': {'full': 'mlf-Thai-LA', 'region': 'LA', 'script': 'Thai', 'suppress': False},
        'mlf-Latn': {'full': 'mlf-Latn-LA', 'region': 'LA', 'script': 'Latn', 'suppress': False},
        'mlh': {'full': 'mlh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mli': {'full': 'mli-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mlj': {'full': 'mlj-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'mlk': {'full': 'mlk-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'mll': {'full': 'mll-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mlm': {'full': 'mlm-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'mln': {'full': 'mln-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'mlo': {'full': 'mlo-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'mlp': {'full': 'mlp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mlq-Arab': {'full': 'mlq-Arab-SN', 'region': 'SN', 'script': 'Arab', 'suppress': False},
        'mlq-Latn': {'full': 'mlq-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'mlr': {'full': 'mlr-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mls': {'full': 'mls-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'mlu': {'full': 'mlu-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'mlv': {'full': 'mlv-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mlw': {'full': 'mlw-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mlx': {'full': 'mlx-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mlz': {'full': 'mlz-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'mma': {'full': 'mma-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mmb': {'full': 'mmb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mmc': {'full': 'mmc-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mmd': {'full': 'mmd-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'mmd-Hans': {'full': 'mmd-Hans-CN', 'region': 'CN', 'script': 'Hans', 'suppress': False},
        'mmd-Hant': {'full': 'mmd-Hant-CN', 'region': 'CN', 'script': 'Hant', 'suppress': False},
        'mme': {'full': 'mme-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mmf': {'full': 'mmf-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mmg': {'full': 'mmg-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mmh': {'full': 'mmh-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'mmi': {'full': 'mmi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mmj': {'full': 'mmj-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'mmk': {'full': 'mmk-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'mml': {'full': 'mml-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'mmm': {'full': 'mmm-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mmn': {'full': 'mmn-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'mmo': {'full': 'mmo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mmp': {'full': 'mmp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mmq': {'full': 'mmq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mmr': {'full': 'mmr-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'mmt': {'full': 'mmt-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mmu': {'full': 'mmu-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mmv': {'full': 'mmv-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'mmw': {'full': 'mmw-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mmx': {'full': 'mmx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mmy': {'full': 'mmy-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'mmz': {'full': 'mmz-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'mn': {'full': 'mn-Cyrl-MN', 'region': 'MN', 'script': 'Cyrl', 'suppress': False},
        'mn-Brai': {'full': 'mn-Brai-MN', 'region': 'MN', 'script': 'Brai', 'suppress': False},
        'mn-CN': {'full': 'mn-Mong-CN', 'region': 'CN', 'script': 'Mong', 'suppress': False},
        'mn-Mong-MN': {'full': 'mn-Mong-MN', 'region': 'MN', 'script': 'Mong', 'suppress': False},
        'mn-Phag': {'full': 'mn-Phag-CN', 'region': 'CN', 'script': 'Phag', 'suppress': False},
        'mn-Phag-MN': {'full': 'mn-Phag-MN', 'region': 'MN', 'script': 'Phag', 'suppress': False},
        'mn-Tibt': {'full': 'mn-Tibt-CN', 'region': 'CN', 'script': 'Tibt', 'suppress': False},
        'mna': {'full': 'mna-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mnb': {'full': 'mnb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mnc-Mong': {'full': 'mnc-Mong-CN', 'region': 'CN', 'script': 'Mong', 'suppress': False},
        'mnc-Mong-x-manchu': {'full': 'mnc-Mong-CN-x-manchu', 'region': 'CN', 'script': 'Mong', 'suppress': False},
        'mnc-Mong-x-olmanchu': {'full': 'mnc-Mong-CN-x-olmanchu', 'region': 'CN', 'script': 'Mong', 'suppress': False},
        'mnd': {'full': 'mnd-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'mne': {'full': 'mne-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'mnf': {'full': 'mnf-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mng': {'full': 'mng-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'mnh': {'full': 'mnh-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'mni': {'full': 'mni-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'mni-Brai': {'full': 'mni-Brai-IN', 'region': 'IN', 'script': 'Brai', 'suppress': False},
        'mni-Mtei': {'full': 'mni-Mtei-IN', 'region': 'IN', 'script': 'Mtei', 'suppress': False},
        'mnj-Arab': {'full': 'mnj-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'mnl': {'full': 'mnl-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mnm': {'full': 'mnm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mnn': {'full': 'mnn-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'mnp': {'full': 'mnp-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'mnq': {'full': 'mnq-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'mnr': {'full': 'mnr-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'mns': {'full': 'mns-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'mnu': {'full': 'mnu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mnv': {'full': 'mnv-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'mnw': {'full': 'mnw-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'mnx': {'full': 'mnx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mny': {'full': 'mny-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'mnz': {'full': 'mnz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'moa': {'full': 'moa-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'moc': {'full': 'moc-Latn-AR', 'region': 'AR', 'script': 'Latn', 'suppress': False},
        'mod': {'full': 'mod-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'moe': {'full': 'moe-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'mog': {'full': 'mog-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'moh': {'full': 'moh-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'moi': {'full': 'moi-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'moj': {'full': 'moj-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'mok': {'full': 'mok-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mom': {'full': 'mom-Latn-NI', 'region': 'NI', 'script': 'Latn', 'suppress': False},
        'moo': {'full': 'moo-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'mop': {'full': 'mop-Latn-BZ', 'region': 'BZ', 'script': 'Latn', 'suppress': False},
        'moq': {'full': 'moq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mor': {'full': 'mor-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'mos': {'full': 'mos-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'mos-Brai': {'full': 'mos-Brai-BF', 'region': 'BF', 'script': 'Brai', 'suppress': False},
        'mot': {'full': 'mot-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'mou': {'full': 'mou-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'mov': {'full': 'mov-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'mow': {'full': 'mow-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'mox': {'full': 'mox-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'moy': {'full': 'moy-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'moz': {'full': 'moz-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'mpa': {'full': 'mpa-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'mpb': {'full': 'mpb-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'mpc': {'full': 'mpc-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'mpd': {'full': 'mpd-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'mpe': {'full': 'mpe-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'mpe-Ethi': {'full': 'mpe-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'mpg': {'full': 'mpg-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'mph': {'full': 'mph-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'mpi': {'full': 'mpi-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mpj': {'full': 'mpj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'mpk': {'full': 'mpk-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'mpl': {'full': 'mpl-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mpm': {'full': 'mpm-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mpn': {'full': 'mpn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mpo': {'full': 'mpo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mpp': {'full': 'mpp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mpq': {'full': 'mpq-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'mpr': {'full': 'mpr-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'mps': {'full': 'mps-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mpt': {'full': 'mpt-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mpu': {'full': 'mpu-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'mpv': {'full': 'mpv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mpw': {'full': 'mpw-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'mpx': {'full': 'mpx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mpy': {'full': 'mpy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mpz': {'full': 'mpz-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'mqa': {'full': 'mqa-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mqb': {'full': 'mqb-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mqc': {'full': 'mqc-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mqe': {'full': 'mqe-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mqf': {'full': 'mqf-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mqg': {'full': 'mqg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mqh': {'full': 'mqh-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mqi': {'full': 'mqi-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mqj': {'full': 'mqj-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mqk': {'full': 'mqk-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'mql': {'full': 'mql-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'mqm': {'full': 'mqm-Latn-PF', 'region': 'PF', 'script': 'Latn', 'suppress': False},
        'mqn': {'full': 'mqn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mqo': {'full': 'mqo-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mqp': {'full': 'mqp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mqq': {'full': 'mqq-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'mqr': {'full': 'mqr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mqs': {'full': 'mqs-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mqt': {'full': 'mqt-Zyyy-TH', 'region': 'TH', 'script': 'Zyyy', 'suppress': False},
        'mqu': {'full': 'mqu-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'mqv': {'full': 'mqv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mqw': {'full': 'mqw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mqx': {'full': 'mqx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mqx-Bugi': {'full': 'mqx-Bugi-ID', 'region': 'ID', 'script': 'Bugi', 'suppress': False},
        'mqy': {'full': 'mqy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mqz': {'full': 'mqz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mr': {'full': 'mr-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': True},
        'mr-Brai': {'full': 'mr-Brai-IN', 'region': 'IN', 'script': 'Brai', 'suppress': False},
        'mr-Modi': {'full': 'mr-Modi-IN', 'region': 'IN', 'script': 'Modi', 'suppress': False},
        'mra': {'full': 'mra-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'mrb': {'full': 'mrb-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mrc': {'full': 'mrc-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'mrd': {'full': 'mrd-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'mre': {'full': 'mre-Zxxx-US', 'region': 'US', 'script': 'Zxxx', 'suppress': False},
        'mrf': {'full': 'mrf-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mrg': {'full': 'mrg-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'mrg-Beng': {'full': 'mrg-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'mrg-Deva': {'full': 'mrg-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'mrh': {'full': 'mrh-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'mrj': {'full': 'mrj-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'mrk': {'full': 'mrk-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'mrl': {'full': 'mrl-Latn-FM', 'region': 'FM', 'script': 'Latn', 'suppress': False},
        'mrm': {'full': 'mrm-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mrn': {'full': 'mrn-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'mro': {'full': 'mro-Mroo-BD', 'region': 'BD', 'script': 'Mroo', 'suppress': False},
        'mro-Latn': {'full': 'mro-Latn-BD', 'region': 'BD', 'script': 'Latn', 'suppress': False},
        'mrp': {'full': 'mrp-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mrq': {'full': 'mrq-Latn-PF', 'region': 'PF', 'script': 'Latn', 'suppress': False},
        'mrr': {'full': 'mrr-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'mrs': {'full': 'mrs-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mrt': {'full': 'mrt-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mru': {'full': 'mru-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mrv': {'full': 'mrv-Latn-PF', 'region': 'PF', 'script': 'Latn', 'suppress': False},
        'mrw': {'full': 'mrw-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'mrx': {'full': 'mrx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mry': {'full': 'mry-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'mrz': {'full': 'mrz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ms': {'full': 'ms-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': True},
        'ms-Arab': {'full': 'ms-Arab-MY', 'region': 'MY', 'script': 'Arab', 'suppress': False},
        'ms-BN': {'full': 'ms-Latn-BN', 'region': 'BN', 'script': 'Latn', 'suppress': True},
        'ms-Brai': {'full': 'ms-Brai-MY', 'region': 'MY', 'script': 'Brai', 'suppress': False},
        'ms-CC': {'full': 'ms-Arab-CC', 'region': 'CC', 'script': 'Arab', 'suppress': False},
        'ms-ID': {'full': 'ms-Arab-ID', 'region': 'ID', 'script': 'Arab', 'suppress': False},
        'ms-SG': {'full': 'ms-Latn-SG', 'region': 'SG', 'script': 'Latn', 'suppress': True},
        'msb': {'full': 'msb-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'msc': {'full': 'msc-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'msd': {'full': 'msd-Zxxx-MX', 'region': 'MX', 'script': 'Zxxx', 'suppress': False},
        'mse': {'full': 'mse-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'msf': {'full': 'msf-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'msg': {'full': 'msg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'msh': {'full': 'msh-Latn-MG', 'region': 'MG', 'script': 'Latn', 'suppress': False},
        'msi': {'full': 'msi-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'msj': {'full': 'msj-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'msk': {'full': 'msk-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'msl': {'full': 'msl-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'msm': {'full': 'msm-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'msn': {'full': 'msn-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mso': {'full': 'mso-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'msp': {'full': 'msp-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'msq': {'full': 'msq-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'msr': {'full': 'msr-Zxxx-MN', 'region': 'MN', 'script': 'Zxxx', 'suppress': False},
        'mss': {'full': 'mss-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'msu': {'full': 'msu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'msv': {'full': 'msv-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'msw': {'full': 'msw-Latn-GW', 'region': 'GW', 'script': 'Latn', 'suppress': False},
        'msx': {'full': 'msx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'msy': {'full': 'msy-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'msz': {'full': 'msz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mt': {'full': 'mt-Latn-MT', 'region': 'MT', 'script': 'Latn', 'suppress': True},
        'mt-Arab': {'full': 'mt-Arab-MT', 'region': 'MT', 'script': 'Arab', 'suppress': False},
        'mt-Brai': {'full': 'mt-Brai-MT', 'region': 'MT', 'script': 'Brai', 'suppress': False},
        'mta': {'full': 'mta-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'mtb': {'full': 'mtb-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'mtc': {'full': 'mtc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mtd': {'full': 'mtd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mte': {'full': 'mte-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'mtf': {'full': 'mtf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mtg': {'full': 'mtg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mth': {'full': 'mth-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mti': {'full': 'mti-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mtj': {'full': 'mtj-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mtk': {'full': 'mtk-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mtl': {'full': 'mtl-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mtm': {'full': 'mtm-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'mtn': {'full': 'mtn-Latn-NI', 'region': 'NI', 'script': 'Latn', 'suppress': False},
        'mto': {'full': 'mto-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mtp': {'full': 'mtp-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'mtq': {'full': 'mtq-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'mtr': {'full': 'mtr-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'mts': {'full': 'mts-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'mtt': {'full': 'mtt-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mtu': {'full': 'mtu-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mtv': {'full': 'mtv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mtw': {'full': 'mtw-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'mtx': {'full': 'mtx-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mty': {'full': 'mty-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mua': {'full': 'mua-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mub': {'full': 'mub-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'muc': {'full': 'muc-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mud': {'full': 'mud-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'mue': {'full': 'mue-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'mug': {'full': 'mug-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'muh': {'full': 'muh-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'mui': {'full': 'mui-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'muj': {'full': 'muj-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'muk': {'full': 'muk-Tibt-NP', 'region': 'NP', 'script': 'Tibt', 'suppress': False},
        'mul': {'full': 'mul-Zyyy-001', 'region': '001', 'script': 'Zyyy', 'suppress': False},
        'mum': {'full': 'mum-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'muo': {'full': 'muo-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'muq': {'full': 'muq-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'mur': {'full': 'mur-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'mur-Arab': {'full': 'mur-Arab-SS', 'region': 'SS', 'script': 'Arab', 'suppress': False},
        'mus': {'full': 'mus-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'mut': {'full': 'mut-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'muu': {'full': 'muu-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'muv': {'full': 'muv-Taml-IN', 'region': 'IN', 'script': 'Taml', 'suppress': False},
        'mux': {'full': 'mux-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'muy': {'full': 'muy-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'muz': {'full': 'muz-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'muz-Latn': {'full': 'muz-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'mva': {'full': 'mva-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mvb': {'full': 'mvb-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'mvd': {'full': 'mvd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mve-Arab': {'full': 'mve-Arab-PK-x-sindhi', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'mve-Arab-x-urdu': {'full': 'mve-Arab-PK-x-urdu', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'mvf': {'full': 'mvf-Mong-CN', 'region': 'CN', 'script': 'Mong', 'suppress': False},
        'mvf-Phag': {'full': 'mvf-Phag-CN', 'region': 'CN', 'script': 'Phag', 'suppress': False},
        'mvg': {'full': 'mvg-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mvh': {'full': 'mvh-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'mvi': {'full': 'mvi-Zyyy-JP', 'region': 'JP', 'script': 'Zyyy', 'suppress': False},
        'mvk': {'full': 'mvk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mvl': {'full': 'mvl-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'mvm': {'full': 'mvm-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'mvn': {'full': 'mvn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mvo': {'full': 'mvo-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'mvp': {'full': 'mvp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mvq': {'full': 'mvq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mvr': {'full': 'mvr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mvs': {'full': 'mvs-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mvt': {'full': 'mvt-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mvu': {'full': 'mvu-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'mvv': {'full': 'mvv-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'mvw': {'full': 'mvw-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'mvx': {'full': 'mvx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mvy': {'full': 'mvy-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'mvz-Arab': {'full': 'mvz-Arab-ET', 'region': 'ET', 'script': 'Arab', 'suppress': False},
        'mwa': {'full': 'mwa-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mwb': {'full': 'mwb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mwc': {'full': 'mwc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mwe': {'full': 'mwe-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'mwf': {'full': 'mwf-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'mwg': {'full': 'mwg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mwh': {'full': 'mwh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mwi': {'full': 'mwi-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mwk': {'full': 'mwk-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'mwl': {'full': 'mwl-Latn-PT', 'region': 'PT', 'script': 'Latn', 'suppress': False},
        'mwm': {'full': 'mwm-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'mwn': {'full': 'mwn-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'mwo': {'full': 'mwo-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mwp': {'full': 'mwp-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'mwq': {'full': 'mwq-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'mwr': {'full': 'mwr-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'mwr-Mahj': {'full': 'mwr-Mahj-IN', 'region': 'IN', 'script': 'Mahj', 'suppress': False},
        'mws': {'full': 'mws-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'mwt': {'full': 'mwt-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'mwt-Thai': {'full': 'mwt-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'mwu': {'full': 'mwu-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'mwv': {'full': 'mwv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mww': {'full': 'mww-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'mww-Hmng': {'full': 'mww-Hmng-CN', 'region': 'CN', 'script': 'Hmng', 'suppress': False},
        'mww-Laoo': {'full': 'mww-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'mww-Plrd': {'full': 'mww-Plrd-CN', 'region': 'CN', 'script': 'Plrd', 'suppress': False},
        'mww-Thai': {'full': 'mww-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'mwx': {'full': 'mwx-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'mwy': {'full': 'mwy-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'mwz': {'full': 'mwz-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'mxa': {'full': 'mxa-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mxb': {'full': 'mxb-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mxc': {'full': 'mxc-Latn-ZW', 'region': 'ZW', 'script': 'Latn', 'suppress': False},
        'mxd': {'full': 'mxd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mxe': {'full': 'mxe-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'mxf': {'full': 'mxf-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mxg': {'full': 'mxg-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'mxh': {'full': 'mxh-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'mxi': {'full': 'mxi-Latn-ES', 'region': 'ES', 'script': 'Latn', 'suppress': False},
        'mxj': {'full': 'mxj-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'mxk': {'full': 'mxk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mxl': {'full': 'mxl-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'mxm': {'full': 'mxm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mxn': {'full': 'mxn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mxo': {'full': 'mxo-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'mxp': {'full': 'mxp-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mxq': {'full': 'mxq-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mxr': {'full': 'mxr-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'mxs': {'full': 'mxs-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mxt': {'full': 'mxt-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mxu': {'full': 'mxu-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mxv': {'full': 'mxv-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mxw': {'full': 'mxw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mxx': {'full': 'mxx-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'mxy': {'full': 'mxy-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mxz': {'full': 'mxz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'my': {'full': 'my-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': True},
        'my-Brai': {'full': 'my-Brai-MM', 'region': 'MM', 'script': 'Brai', 'suppress': False},
        'myb': {'full': 'myb-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'myc': {'full': 'myc-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'mye': {'full': 'mye-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'myf': {'full': 'myf-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'myg': {'full': 'myg-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'myh': {'full': 'myh-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'myi': {'full': 'myi-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'myj': {'full': 'myj-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'myk': {'full': 'myk-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'myl': {'full': 'myl-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mym': {'full': 'mym-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'mym-Latn': {'full': 'mym-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'myo': {'full': 'myo-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'myp': {'full': 'myp-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'myr': {'full': 'myr-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'mys': {'full': 'mys-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'myu': {'full': 'myu-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'myv': {'full': 'myv-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'myw': {'full': 'myw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'myx': {'full': 'myx-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'myy': {'full': 'myy-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'myz': {'full': 'myz-Mand-IR', 'region': 'IR', 'script': 'Mand', 'suppress': False},
        'mza': {'full': 'mza-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mzb-Arab': {'full': 'mzb-Arab-DZ', 'region': 'DZ', 'script': 'Arab', 'suppress': False},
        'mzb-Latn': {'full': 'mzb-Latn-DZ', 'region': 'DZ', 'script': 'Latn', 'suppress': False},
        'mzb-Tfng': {'full': 'mzb-Tfng-DZ', 'region': 'DZ', 'script': 'Tfng', 'suppress': False},
        'mzc': {'full': 'mzc-Zxxx-MG', 'region': 'MG', 'script': 'Zxxx', 'suppress': False},
        'mzd': {'full': 'mzd-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'mze': {'full': 'mze-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mzg': {'full': 'mzg-Zxxx-VA', 'region': 'VA', 'script': 'Zxxx', 'suppress': False},
        'mzh': {'full': 'mzh-Latn-AR', 'region': 'AR', 'script': 'Latn', 'suppress': False},
        'mzi': {'full': 'mzi-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mzj': {'full': 'mzj-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'mzk': {'full': 'mzk-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mzl': {'full': 'mzl-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'mzm': {'full': 'mzm-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'mzn': {'full': 'mzn-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'mzo': {'full': 'mzo-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'mzp': {'full': 'mzp-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'mzq': {'full': 'mzq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'mzr': {'full': 'mzr-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'mzs': {'full': 'mzs-Zyyy-MO', 'region': 'MO', 'script': 'Zyyy', 'suppress': False},
        'mzt': {'full': 'mzt-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'mzu': {'full': 'mzu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'mzv': {'full': 'mzv-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'mzw': {'full': 'mzw-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'mzx': {'full': 'mzx-Latn-GY', 'region': 'GY', 'script': 'Latn', 'suppress': False},
        'mzy': {'full': 'mzy-Zxxx-MZ', 'region': 'MZ', 'script': 'Zxxx', 'suppress': False},
        'mzz': {'full': 'mzz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'na': {'full': 'na-Latn-NR', 'region': 'NR', 'script': 'Latn', 'suppress': True},
        'naa': {'full': 'naa-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nab': {'full': 'nab-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'nac': {'full': 'nac-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nae': {'full': 'nae-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'naf': {'full': 'naf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nag': {'full': 'nag-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'naj': {'full': 'naj-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'nak': {'full': 'nak-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nal': {'full': 'nal-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nam': {'full': 'nam-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nan': {'full': 'nan-Hans-CN', 'region': 'CN', 'script': 'Hans', 'suppress': False},
        'nan-Bopo': {'full': 'nan-Bopo-TW', 'region': 'TW', 'script': 'Bopo', 'suppress': False},
        'nan-Kana': {'full': 'nan-Kana-TW', 'region': 'TW', 'script': 'Kana', 'suppress': False},
        'nan-Latn': {'full': 'nan-Latn-TW', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'nan-Latn-x-transpoj': {'full': 'nan-Latn-TW-x-transpoj', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'nao': {'full': 'nao-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'nap': {'full': 'nap-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'naq': {'full': 'naq-Latn-NA', 'region': 'NA', 'script': 'Latn', 'suppress': False},
        'nar': {'full': 'nar-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'nas': {'full': 'nas-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nat': {'full': 'nat-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'naw': {'full': 'naw-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'nax': {'full': 'nax-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nay': {'full': 'nay-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'naz': {'full': 'naz-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nb': {'full': 'nb-Latn-NO', 'region': 'NO', 'script': 'Latn', 'suppress': True},
        'nba': {'full': 'nba-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'nbb': {'full': 'nbb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'nbc': {'full': 'nbc-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nbd': {'full': 'nbd-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'nbe': {'full': 'nbe-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nbg': {'full': 'nbg-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'nbh': {'full': 'nbh-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'nbi': {'full': 'nbi-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nbj': {'full': 'nbj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nbk': {'full': 'nbk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nbm': {'full': 'nbm-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'nbn': {'full': 'nbn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nbo': {'full': 'nbo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'nbp': {'full': 'nbp-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'nbq': {'full': 'nbq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nbr': {'full': 'nbr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'nbs': {'full': 'nbs-Zxxx-NA', 'region': 'NA', 'script': 'Zxxx', 'suppress': False},
        'nbt-Deva': {'full': 'nbt-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'nbt-Latn': {'full': 'nbt-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nbu': {'full': 'nbu-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nbv': {'full': 'nbv-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'nbw': {'full': 'nbw-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'nby': {'full': 'nby-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nca': {'full': 'nca-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ncb-Deva': {'full': 'ncb-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'ncb-Latn': {'full': 'ncb-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'ncc': {'full': 'ncc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ncd': {'full': 'ncd-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'nce': {'full': 'nce-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ncf': {'full': 'ncf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ncg': {'full': 'ncg-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'nch': {'full': 'nch-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nci': {'full': 'nci-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ncj': {'full': 'ncj-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nck': {'full': 'nck-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ncl': {'full': 'ncl-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ncm': {'full': 'ncm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ncn': {'full': 'ncn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nco': {'full': 'nco-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ncq': {'full': 'ncq-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'ncq-Thai': {'full': 'ncq-Thai-LA', 'region': 'LA', 'script': 'Thai', 'suppress': False},
        'ncr': {'full': 'ncr-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'ncs': {'full': 'ncs-Zxxx-NI', 'region': 'NI', 'script': 'Zxxx', 'suppress': False},
        'nct-Beng': {'full': 'nct-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'nct-Latn': {'full': 'nct-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'ncu': {'full': 'ncu-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'ncx': {'full': 'ncx-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ncz': {'full': 'ncz-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'nd': {'full': 'nd-Latn-ZW', 'region': 'ZW', 'script': 'Latn', 'suppress': True},
        'nda': {'full': 'nda-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'ndb': {'full': 'ndb-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'ndc': {'full': 'ndc-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'ndd': {'full': 'ndd-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ndf': {'full': 'ndf-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'ndg': {'full': 'ndg-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'ndh': {'full': 'ndh-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'ndi': {'full': 'ndi-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ndj': {'full': 'ndj-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'ndk': {'full': 'ndk-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'ndl': {'full': 'ndl-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'ndm': {'full': 'ndm-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'ndn': {'full': 'ndn-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'ndp': {'full': 'ndp-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'ndq': {'full': 'ndq-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'ndr': {'full': 'ndr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'nds': {'full': 'nds-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': True},
        'nds-NL': {'full': 'nds-Latn-NL', 'region': 'NL', 'script': 'Latn', 'suppress': True},
        'ndt': {'full': 'ndt-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'ndu': {'full': 'ndu-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'ndv': {'full': 'ndv-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'ndw': {'full': 'ndw-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'ndx': {'full': 'ndx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ndy': {'full': 'ndy-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'ndy-TD': {'full': 'ndy-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'ndz': {'full': 'ndz-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'ne': {'full': 'ne-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': True},
        'ne-Brai': {'full': 'ne-Brai-NP', 'region': 'NP', 'script': 'Brai', 'suppress': False},
        'ne-IN': {'full': 'ne-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': True},
        'ne-Newa': {'full': 'ne-Newa-NP', 'region': 'NP', 'script': 'Newa', 'suppress': False},
        'nea': {'full': 'nea-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'neb': {'full': 'neb-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'nec': {'full': 'nec-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ned': {'full': 'ned-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'nee': {'full': 'nee-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'nef': {'full': 'nef-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'neg': {'full': 'neg-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'neh': {'full': 'neh-Zyyy-BT', 'region': 'BT', 'script': 'Zyyy', 'suppress': False},
        'nei': {'full': 'nei-Zyyy-TR', 'region': 'TR', 'script': 'Zyyy', 'suppress': False},
        'nej': {'full': 'nej-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nek': {'full': 'nek-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'nem': {'full': 'nem-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'nen': {'full': 'nen-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'neo': {'full': 'neo-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'neq': {'full': 'neq-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ner': {'full': 'ner-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nes': {'full': 'nes-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'net': {'full': 'net-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'neu': {'full': 'neu-Latn-001', 'region': '001', 'script': 'Latn', 'suppress': False},
        'nev': {'full': 'nev-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'new': {'full': 'new-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'new-Newa': {'full': 'new-Newa-NP', 'region': 'NP', 'script': 'Newa', 'suppress': False},
        'new-Zzzz-x-ranjana': {'full': 'new-Zzzz-NP-x-ranjana', 'region': 'NP', 'script': 'Zzzz', 'suppress': False},
        'nex': {'full': 'nex-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ney': {'full': 'ney-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'nez': {'full': 'nez-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'nfa': {'full': 'nfa-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nfd': {'full': 'nfd-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'nfl': {'full': 'nfl-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'nfr': {'full': 'nfr-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'nfu': {'full': 'nfu-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'ng': {'full': 'ng-Latn-NA', 'region': 'NA', 'script': 'Latn', 'suppress': False},
        'nga': {'full': 'nga-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'ngb': {'full': 'ngb-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'ngc': {'full': 'ngc-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'ngd': {'full': 'ngd-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'nge': {'full': 'nge-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'ngg': {'full': 'ngg-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'ngh': {'full': 'ngh-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': False},
        'ngi': {'full': 'ngi-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ngj': {'full': 'ngj-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'ngk': {'full': 'ngk-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ngl': {'full': 'ngl-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'ngm': {'full': 'ngm-Latn-FM', 'region': 'FM', 'script': 'Latn', 'suppress': False},
        'ngn': {'full': 'ngn-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'ngo': {'full': 'ngo-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'ngp': {'full': 'ngp-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'ngq': {'full': 'ngq-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'ngr': {'full': 'ngr-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'ngs': {'full': 'ngs-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ngt': {'full': 'ngt-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'ngu': {'full': 'ngu-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ngv': {'full': 'ngv-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'ngw': {'full': 'ngw-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ngx': {'full': 'ngx-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ngy': {'full': 'ngy-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'ngz': {'full': 'ngz-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'nha': {'full': 'nha-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nhb': {'full': 'nhb-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'nhc': {'full': 'nhc-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nhd': {'full': 'nhd-Latn-PY', 'region': 'PY', 'script': 'Latn', 'suppress': False},
        'nhe': {'full': 'nhe-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nhf': {'full': 'nhf-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nhg': {'full': 'nhg-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nhh': {'full': 'nhh-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'nhi': {'full': 'nhi-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nhk': {'full': 'nhk-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nhm': {'full': 'nhm-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nhn': {'full': 'nhn-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nho': {'full': 'nho-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nhp': {'full': 'nhp-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nhq': {'full': 'nhq-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nhr': {'full': 'nhr-Latn-BW', 'region': 'BW', 'script': 'Latn', 'suppress': False},
        'nht': {'full': 'nht-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nhu': {'full': 'nhu-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'nhv': {'full': 'nhv-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nhw': {'full': 'nhw-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nhx': {'full': 'nhx-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nhy': {'full': 'nhy-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nhz': {'full': 'nhz-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nia': {'full': 'nia-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nib': {'full': 'nib-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nid': {'full': 'nid-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nie': {'full': 'nie-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'nif': {'full': 'nif-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nig': {'full': 'nig-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nih': {'full': 'nih-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'nii': {'full': 'nii-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nij': {'full': 'nij-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nik': {'full': 'nik-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'nil': {'full': 'nil-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nim': {'full': 'nim-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'nin': {'full': 'nin-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'nio': {'full': 'nio-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'niq': {'full': 'niq-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'nir': {'full': 'nir-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nis': {'full': 'nis-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nit': {'full': 'nit-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'niu': {'full': 'niu-Latn-NU', 'region': 'NU', 'script': 'Latn', 'suppress': True},
        'niv': {'full': 'niv-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'niv-Latn': {'full': 'niv-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'niw': {'full': 'niw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nix': {'full': 'nix-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'niy': {'full': 'niy-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'niz': {'full': 'niz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nja': {'full': 'nja-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'njb': {'full': 'njb-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'njd': {'full': 'njd-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'njh': {'full': 'njh-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nji': {'full': 'nji-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'njj': {'full': 'njj-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'njl': {'full': 'njl-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'njm': {'full': 'njm-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'njn': {'full': 'njn-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'njo': {'full': 'njo-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'njr': {'full': 'njr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'njs': {'full': 'njs-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'njt': {'full': 'njt-Latn-SR', 'region': 'SR', 'script': 'Latn', 'suppress': False},
        'nju': {'full': 'nju-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'njx': {'full': 'njx-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'njy': {'full': 'njy-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'njz-Beng': {'full': 'njz-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'njz-Latn': {'full': 'njz-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nka': {'full': 'nka-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'nkb': {'full': 'nkb-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nkc': {'full': 'nkc-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'nkd': {'full': 'nkd-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nke': {'full': 'nke-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'nkf': {'full': 'nkf-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nkg': {'full': 'nkg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nkh': {'full': 'nkh-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nki-Beng': {'full': 'nki-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'nki-Latn': {'full': 'nki-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nkj': {'full': 'nkj-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nkk': {'full': 'nkk-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'nkm': {'full': 'nkm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nkn': {'full': 'nkn-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'nko': {'full': 'nko-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'nkp': {'full': 'nkp-Zyyy-TO', 'region': 'TO', 'script': 'Zyyy', 'suppress': False},
        'nkq': {'full': 'nkq-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'nkr': {'full': 'nkr-Latn-FM', 'region': 'FM', 'script': 'Latn', 'suppress': False},
        'nks': {'full': 'nks-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nkt': {'full': 'nkt-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'nku': {'full': 'nku-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'nkv': {'full': 'nkv-Latn-MW', 'region': 'MW', 'script': 'Latn', 'suppress': False},
        'nkw': {'full': 'nkw-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'nkx': {'full': 'nkx-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'nkz': {'full': 'nkz-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'nl': {'full': 'nl-Latn-NL', 'region': 'NL', 'script': 'Latn', 'suppress': True},
        'nl-AW': {'full': 'nl-Latn-AW', 'region': 'AW', 'script': 'Latn', 'suppress': True},
        'nl-BE': {'full': 'nl-Latn-BE', 'region': 'BE', 'script': 'Latn', 'suppress': True},
        'nl-BQ': {'full': 'nl-Latn-BQ', 'region': 'BQ', 'script': 'Latn', 'suppress': True},
        'nl-Brai': {'full': 'nl-Brai-NL', 'region': 'NL', 'script': 'Brai', 'suppress': False},
        'nl-CW': {'full': 'nl-Latn-CW', 'region': 'CW', 'script': 'Latn', 'suppress': True},
        'nl-SR': {'full': 'nl-Latn-SR', 'region': 'SR', 'script': 'Latn', 'suppress': True},
        'nl-SX': {'full': 'nl-Latn-SX', 'region': 'SX', 'script': 'Latn', 'suppress': True},
        'nla': {'full': 'nla-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'nlc': {'full': 'nlc-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nle': {'full': 'nle-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'nlg': {'full': 'nlg-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'nli': {'full': 'nli-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'nlj': {'full': 'nlj-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'nlk': {'full': 'nlk-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nll': {'full': 'nll-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'nlm': {'full': 'nlm-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'nlo': {'full': 'nlo-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'nlq': {'full': 'nlq-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'nlu': {'full': 'nlu-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'nlv': {'full': 'nlv-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nlw': {'full': 'nlw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nlx': {'full': 'nlx-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'nly': {'full': 'nly-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nlz': {'full': 'nlz-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'nma': {'full': 'nma-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nmb': {'full': 'nmb-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'nmc': {'full': 'nmc-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'nmd': {'full': 'nmd-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'nme': {'full': 'nme-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nmf': {'full': 'nmf-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nmg': {'full': 'nmg-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'nmg-GQ': {'full': 'nmg-Latn-GQ', 'region': 'GQ', 'script': 'Latn', 'suppress': False},
        'nmh': {'full': 'nmh-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nmi': {'full': 'nmi-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'nmj': {'full': 'nmj-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'nmk': {'full': 'nmk-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'nml': {'full': 'nml-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'nmm': {'full': 'nmm-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'nmm-Tibt': {'full': 'nmm-Tibt-NP', 'region': 'NP', 'script': 'Tibt', 'suppress': False},
        'nmn': {'full': 'nmn-Latn-BW', 'region': 'BW', 'script': 'Latn', 'suppress': False},
        'nmo-Beng': {'full': 'nmo-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'nmo-Latn': {'full': 'nmo-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nmp': {'full': 'nmp-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nmq': {'full': 'nmq-Latn-ZW', 'region': 'ZW', 'script': 'Latn', 'suppress': False},
        'nmr': {'full': 'nmr-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'nms': {'full': 'nms-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'nmt': {'full': 'nmt-Latn-FM', 'region': 'FM', 'script': 'Latn', 'suppress': False},
        'nmu': {'full': 'nmu-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'nmv': {'full': 'nmv-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nmw': {'full': 'nmw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nmx': {'full': 'nmx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nmy': {'full': 'nmy-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'nmz': {'full': 'nmz-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'nn': {'full': 'nn-Latn-NO', 'region': 'NO', 'script': 'Latn', 'suppress': True},
        'nna': {'full': 'nna-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nnb': {'full': 'nnb-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'nnc': {'full': 'nnc-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'nnd': {'full': 'nnd-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'nne': {'full': 'nne-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'nnf': {'full': 'nnf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nng-Beng': {'full': 'nng-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'nng-Latn': {'full': 'nng-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nnh': {'full': 'nnh-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'nni': {'full': 'nni-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nnj': {'full': 'nnj-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'nnk': {'full': 'nnk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nnl': {'full': 'nnl-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nnm': {'full': 'nnm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nnn': {'full': 'nnn-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'nnp-Deva': {'full': 'nnp-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'nnp-Latn': {'full': 'nnp-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nnp-Wcho': {'full': 'nnp-Wcho-IN', 'region': 'IN', 'script': 'Wcho', 'suppress': False},
        'nnq': {'full': 'nnq-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'nnr': {'full': 'nnr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nnt': {'full': 'nnt-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'nnu': {'full': 'nnu-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'nnv': {'full': 'nnv-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nnw': {'full': 'nnw-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'nny': {'full': 'nny-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nnz': {'full': 'nnz-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'no': {'full': 'no-Latn-NO', 'region': 'NO', 'script': 'Latn', 'suppress': True},
        'noa': {'full': 'noa-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'noc': {'full': 'noc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nod': {'full': 'nod-Lana-TH', 'region': 'TH', 'script': 'Lana', 'suppress': False},
        'nod-Thai': {'full': 'nod-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'noe': {'full': 'noe-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'nof': {'full': 'nof-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nog': {'full': 'nog-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'noh': {'full': 'noh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'noi': {'full': 'noi-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'noj': {'full': 'noj-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'nok': {'full': 'nok-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'nol': {'full': 'nol-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'nom': {'full': 'nom-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'non': {'full': 'non-Runr-SE', 'region': 'SE', 'script': 'Runr', 'suppress': False},
        'nop': {'full': 'nop-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'noq': {'full': 'noq-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'nos': {'full': 'nos-Yiii-CN', 'region': 'CN', 'script': 'Yiii', 'suppress': False},
        'not': {'full': 'not-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'nou': {'full': 'nou-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nov': {'full': 'nov-Latn-001', 'region': '001', 'script': 'Latn', 'suppress': False},
        'now': {'full': 'now-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'noy': {'full': 'noy-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'noz': {'full': 'noz-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'npa': {'full': 'npa-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'npb': {'full': 'npb-Zyyy-BT', 'region': 'BT', 'script': 'Zyyy', 'suppress': False},
        'npg': {'full': 'npg-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'nph': {'full': 'nph-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'npl': {'full': 'npl-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'npn': {'full': 'npn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'npo': {'full': 'npo-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nps': {'full': 'nps-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'npu': {'full': 'npu-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'npx': {'full': 'npx-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'npy': {'full': 'npy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nqg': {'full': 'nqg-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'nqk': {'full': 'nqk-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'nql': {'full': 'nql-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'nqm': {'full': 'nqm-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nqn': {'full': 'nqn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nqo': {'full': 'nqo-Nkoo-GN', 'region': 'GN', 'script': 'Nkoo', 'suppress': True},
        'nqq': {'full': 'nqq-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'nqy': {'full': 'nqy-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'nr': {'full': 'nr-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': True},
        'nr-Brai': {'full': 'nr-Brai-ZA', 'region': 'ZA', 'script': 'Brai', 'suppress': False},
        'nra': {'full': 'nra-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'nrb': {'full': 'nrb-Latn-ER', 'region': 'ER', 'script': 'Latn', 'suppress': False},
        'nrc': {'full': 'nrc-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'nre': {'full': 'nre-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nrf': {'full': 'nrf-Latn-JE', 'region': 'JE', 'script': 'Latn', 'suppress': False},
        'nrg': {'full': 'nrg-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'nri': {'full': 'nri-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nrk': {'full': 'nrk-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nrl': {'full': 'nrl-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nrm': {'full': 'nrm-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'nrn': {'full': 'nrn-Zyyy-GB', 'region': 'GB', 'script': 'Zyyy', 'suppress': False},
        'nrp': {'full': 'nrp-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'nrr': {'full': 'nrr-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'nrt': {'full': 'nrt-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'nru': {'full': 'nru-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'nrx': {'full': 'nrx-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nrz': {'full': 'nrz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nsa': {'full': 'nsa-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nsb': {'full': 'nsb-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': False},
        'nsc': {'full': 'nsc-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'nsd': {'full': 'nsd-Yiii-CN', 'region': 'CN', 'script': 'Yiii', 'suppress': False},
        'nse': {'full': 'nse-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'nsf': {'full': 'nsf-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'nsg': {'full': 'nsg-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'nsh': {'full': 'nsh-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'nsi': {'full': 'nsi-Zxxx-NG', 'region': 'NG', 'script': 'Zxxx', 'suppress': False},
        'nsk': {'full': 'nsk-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'nsk-Latn': {'full': 'nsk-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'nsl': {'full': 'nsl-Zxxx-NO', 'region': 'NO', 'script': 'Zxxx', 'suppress': False},
        'nsm': {'full': 'nsm-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nsn': {'full': 'nsn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nso': {'full': 'nso-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': True},
        'nso-Brai': {'full': 'nso-Brai-ZA', 'region': 'ZA', 'script': 'Brai', 'suppress': False},
        'nsp': {'full': 'nsp-Zxxx-NP', 'region': 'NP', 'script': 'Zxxx', 'suppress': False},
        'nsq': {'full': 'nsq-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'nsr': {'full': 'nsr-Zxxx-CA', 'region': 'CA', 'script': 'Zxxx', 'suppress': False},
        'nss': {'full': 'nss-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nst': {'full': 'nst-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'nst-x-moshang': {'full': 'nst-Latn-MM-x-moshang', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'nsu': {'full': 'nsu-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nsv': {'full': 'nsv-Yiii-CN', 'region': 'CN', 'script': 'Yiii', 'suppress': False},
        'nsw': {'full': 'nsw-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'nsx': {'full': 'nsx-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'nsy': {'full': 'nsy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nsz': {'full': 'nsz-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'ntd': {'full': 'ntd-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'nte': {'full': 'nte-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'ntg': {'full': 'ntg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nti': {'full': 'nti-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'ntj': {'full': 'ntj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ntk': {'full': 'ntk-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'ntm': {'full': 'ntm-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'nto': {'full': 'nto-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'ntp': {'full': 'ntp-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ntr': {'full': 'ntr-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'ntu': {'full': 'ntu-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'ntw': {'full': 'ntw-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'ntx': {'full': 'ntx-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'nty': {'full': 'nty-Yiii-VN', 'region': 'VN', 'script': 'Yiii', 'suppress': False},
        'ntz': {'full': 'ntz-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'nua': {'full': 'nua-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'nuc': {'full': 'nuc-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'nud': {'full': 'nud-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nue': {'full': 'nue-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'nuf': {'full': 'nuf-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'nug': {'full': 'nug-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nuh': {'full': 'nuh-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'nui': {'full': 'nui-Latn-GQ', 'region': 'GQ', 'script': 'Latn', 'suppress': False},
        'nuj': {'full': 'nuj-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'nuk': {'full': 'nuk-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'nul': {'full': 'nul-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'num': {'full': 'num-Latn-TO', 'region': 'TO', 'script': 'Latn', 'suppress': False},
        'nun': {'full': 'nun-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'nuo': {'full': 'nuo-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'nup': {'full': 'nup-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'nup-Arab': {'full': 'nup-Arab-NG', 'region': 'NG', 'script': 'Arab', 'suppress': False},
        'nuq': {'full': 'nuq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nur': {'full': 'nur-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nus': {'full': 'nus-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'nut': {'full': 'nut-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'nuu': {'full': 'nuu-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'nuv': {'full': 'nuv-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'nuw': {'full': 'nuw-Latn-FM', 'region': 'FM', 'script': 'Latn', 'suppress': False},
        'nux': {'full': 'nux-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nuy': {'full': 'nuy-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nuz': {'full': 'nuz-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'nv': {'full': 'nv-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'nvh': {'full': 'nvh-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'nvm': {'full': 'nvm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nvo': {'full': 'nvo-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'nwa': {'full': 'nwa-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'nwb': {'full': 'nwb-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'nwc': {'full': 'nwc-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'nwe': {'full': 'nwe-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'nwg': {'full': 'nwg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nwi': {'full': 'nwi-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'nwm': {'full': 'nwm-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'nwo': {'full': 'nwo-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nwr': {'full': 'nwr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nwx': {'full': 'nwx-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'nwy': {'full': 'nwy-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'nxa': {'full': 'nxa-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'nxd': {'full': 'nxd-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'nxe': {'full': 'nxe-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nxg': {'full': 'nxg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nxi': {'full': 'nxi-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'nxk': {'full': 'nxk-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'nxl': {'full': 'nxl-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'nxm': {'full': 'nxm-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'nxn': {'full': 'nxn-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nxo': {'full': 'nxo-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'nxq': {'full': 'nxq-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'nxq-Lisu': {'full': 'nxq-Lisu-CN', 'region': 'CN', 'script': 'Lisu', 'suppress': False},
        'nxq-Nkgb': {'full': 'nxq-Nkgb-CN', 'region': 'CN', 'script': 'Nkgb', 'suppress': False},
        'nxr': {'full': 'nxr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'nxx': {'full': 'nxx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ny': {'full': 'ny-Latn-MW', 'region': 'MW', 'script': 'Latn', 'suppress': True},
        'ny-Brai': {'full': 'ny-Brai-MW', 'region': 'MW', 'script': 'Brai', 'suppress': False},
        'nyb': {'full': 'nyb-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'nyc': {'full': 'nyc-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'nyd': {'full': 'nyd-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'nye': {'full': 'nye-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'nyf': {'full': 'nyf-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'nyg': {'full': 'nyg-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'nyh': {'full': 'nyh-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nyi': {'full': 'nyi-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'nyj': {'full': 'nyj-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'nyk': {'full': 'nyk-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'nyl': {'full': 'nyl-Zyyy-TH', 'region': 'TH', 'script': 'Zyyy', 'suppress': False},
        'nym': {'full': 'nym-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'nyn': {'full': 'nyn-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'nyo': {'full': 'nyo-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'nyp': {'full': 'nyp-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'nyq': {'full': 'nyq-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'nyr': {'full': 'nyr-Latn-MW', 'region': 'MW', 'script': 'Latn', 'suppress': False},
        'nys': {'full': 'nys-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nyt': {'full': 'nyt-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nyu': {'full': 'nyu-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'nyv': {'full': 'nyv-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nyw': {'full': 'nyw-Zyyy-TH', 'region': 'TH', 'script': 'Zyyy', 'suppress': False},
        'nyx': {'full': 'nyx-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'nyy': {'full': 'nyy-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'nza': {'full': 'nza-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'nzb': {'full': 'nzb-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'nzd': {'full': 'nzd-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'nzi': {'full': 'nzi-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'nzk': {'full': 'nzk-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'nzm': {'full': 'nzm-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'nzs': {'full': 'nzs-Zxxx-NZ', 'region': 'NZ', 'script': 'Zxxx', 'suppress': False},
        'nzu': {'full': 'nzu-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'nzy': {'full': 'nzy-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'nzz': {'full': 'nzz-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'oaa': {'full': 'oaa-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'oac': {'full': 'oac-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'oar': {'full': 'oar-Syrc-SY', 'region': 'SY', 'script': 'Syrc', 'suppress': False},
        'oav': {'full': 'oav-Geor-GE', 'region': 'GE', 'script': 'Geor', 'suppress': False},
        'obi': {'full': 'obi-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'obk': {'full': 'obk-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'obl': {'full': 'obl-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'obm': {'full': 'obm-Phnx-JO', 'region': 'JO', 'script': 'Phnx', 'suppress': False},
        'obo': {'full': 'obo-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'obr': {'full': 'obr-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'obt': {'full': 'obt-Latn-FR', 'region': 'FR', 'script': 'Latn', 'suppress': False},
        'obu': {'full': 'obu-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'oc': {'full': 'oc-Latn-FR', 'region': 'FR', 'script': 'Latn', 'suppress': False},
        'oca': {'full': 'oca-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'och': {'full': 'och-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'oco': {'full': 'oco-Latn-GB', 'region': 'GB', 'script': 'Latn', 'suppress': False},
        'ocu': {'full': 'ocu-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'oda': {'full': 'oda-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'odk': {'full': 'odk-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'odt': {'full': 'odt-Latn-NL', 'region': 'NL', 'script': 'Latn', 'suppress': False},
        'odu': {'full': 'odu-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ofo': {'full': 'ofo-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'ofs': {'full': 'ofs-Zyyy-NL', 'region': 'NL', 'script': 'Zyyy', 'suppress': False},
        'ofu': {'full': 'ofu-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ogb': {'full': 'ogb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ogc': {'full': 'ogc-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'oge': {'full': 'oge-Geok-GE', 'region': 'GE', 'script': 'Geok', 'suppress': False},
        'ogg': {'full': 'ogg-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ogo': {'full': 'ogo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ogu': {'full': 'ogu-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'oht': {'full': 'oht-Zyyy-TR', 'region': 'TR', 'script': 'Zyyy', 'suppress': False},
        'ohu-Hung': {'full': 'ohu-Hung-HU', 'region': 'HU', 'script': 'Hung', 'suppress': False},
        'ohu-Latn': {'full': 'ohu-Latn-HU', 'region': 'HU', 'script': 'Latn', 'suppress': False},
        'oia': {'full': 'oia-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'oin': {'full': 'oin-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'oj': {'full': 'oj-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'oj-Cans': {'full': 'oj-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'ojb': {'full': 'ojb-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'ojb-Cans': {'full': 'ojb-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'ojc': {'full': 'ojc-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'ojp': {'full': 'ojp-Zyyy-JP', 'region': 'JP', 'script': 'Zyyy', 'suppress': False},
        'ojs': {'full': 'ojs-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'ojs-Latn': {'full': 'ojs-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'ojv': {'full': 'ojv-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'ojw': {'full': 'ojw-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'ojw-Cans': {'full': 'ojw-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'oka': {'full': 'oka-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'oka-Dupl': {'full': 'oka-Dupl-CA', 'region': 'CA', 'script': 'Dupl', 'suppress': False},
        'okb': {'full': 'okb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'okd': {'full': 'okd-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'oke': {'full': 'oke-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'okg': {'full': 'okg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'okh': {'full': 'okh-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'oki': {'full': 'oki-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'okj': {'full': 'okj-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'okk': {'full': 'okk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'okl': {'full': 'okl-Zxxx-XX', 'region': 'XX', 'script': 'Zxxx', 'suppress': False},
        'okm': {'full': 'okm-Zyyy-KR', 'region': 'KR', 'script': 'Zyyy', 'suppress': False},
        'okn': {'full': 'okn-Zyyy-JP', 'region': 'JP', 'script': 'Zyyy', 'suppress': False},
        'oko': {'full': 'oko-Zyyy-KR', 'region': 'KR', 'script': 'Zyyy', 'suppress': False},
        'okr': {'full': 'okr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'oks': {'full': 'oks-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'oku': {'full': 'oku-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'okv': {'full': 'okv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'okx': {'full': 'okx-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ola': {'full': 'ola-Tibt-NP', 'region': 'NP', 'script': 'Tibt', 'suppress': False},
        'old': {'full': 'old-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'ole': {'full': 'ole-Zyyy-BT', 'region': 'BT', 'script': 'Zyyy', 'suppress': False},
        'olk': {'full': 'olk-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'olm': {'full': 'olm-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'olo': {'full': 'olo-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'olr': {'full': 'olr-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'olt': {'full': 'olt-Latn-LT', 'region': 'LT', 'script': 'Latn', 'suppress': False},
        'olu': {'full': 'olu-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'om': {'full': 'om-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': True},
        'om-Arab': {'full': 'om-Arab-ET', 'region': 'ET', 'script': 'Arab', 'suppress': False},
        'om-Ethi': {'full': 'om-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'om-KE': {'full': 'om-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': True},
        'oma': {'full': 'oma-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'omb': {'full': 'omb-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'omc': {'full': 'omc-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'omg': {'full': 'omg-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'omi': {'full': 'omi-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'omk': {'full': 'omk-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'oml': {'full': 'oml-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'omn': {'full': 'omn-Lina-XX', 'region': 'XX', 'script': 'Lina', 'suppress': False},
        'omo': {'full': 'omo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'omp': {'full': 'omp-Mtei-IN', 'region': 'IN', 'script': 'Mtei', 'suppress': False},
        'omr': {'full': 'omr-Modi-IN', 'region': 'IN', 'script': 'Modi', 'suppress': False},
        'omt': {'full': 'omt-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'omu': {'full': 'omu-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'omw': {'full': 'omw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'omx': {'full': 'omx-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'ona': {'full': 'ona-Latn-AR', 'region': 'AR', 'script': 'Latn', 'suppress': False},
        'onb': {'full': 'onb-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'one': {'full': 'one-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'ong': {'full': 'ong-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'oni': {'full': 'oni-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'onj': {'full': 'onj-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'onk': {'full': 'onk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'onn': {'full': 'onn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ono': {'full': 'ono-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'onp-Deva': {'full': 'onp-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'onp-Latn': {'full': 'onp-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'onr': {'full': 'onr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ons': {'full': 'ons-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ont': {'full': 'ont-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'onu': {'full': 'onu-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'onw': {'full': 'onw-Copt-SD-x-olnubian', 'region': 'SD', 'script': 'Copt', 'suppress': False},
        'onx': {'full': 'onx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ood': {'full': 'ood-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'oog': {'full': 'oog-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'oon': {'full': 'oon-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'oor': {'full': 'oor-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': False},
        'oos': {'full': 'oos-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'opa': {'full': 'opa-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'opk': {'full': 'opk-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'opm': {'full': 'opm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'opo': {'full': 'opo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'opt': {'full': 'opt-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'opy': {'full': 'opy-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'or': {'full': 'or-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': True},
        'or-Brai': {'full': 'or-Brai-IN', 'region': 'IN', 'script': 'Brai', 'suppress': False},
        'ora': {'full': 'ora-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'orc': {'full': 'orc-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'ore': {'full': 'ore-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'org': {'full': 'org-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'orh': {'full': 'orh-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'orn': {'full': 'orn-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'oro': {'full': 'oro-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'orr': {'full': 'orr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ors': {'full': 'ors-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'ort': {'full': 'ort-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'oru': {'full': 'oru-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'orv': {'full': 'orv-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'orw': {'full': 'orw-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'orx': {'full': 'orx-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'orz': {'full': 'orz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'os': {'full': 'os-Cyrl-GE', 'region': 'GE', 'script': 'Cyrl', 'suppress': False},
        'os-Geor': {'full': 'os-Geor-RU', 'region': 'RU', 'script': 'Geor', 'suppress': False},
        'os-Latn': {'full': 'os-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'os-RU': {'full': 'os-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'osa': {'full': 'osa-Osge-US', 'region': 'US', 'script': 'Osge', 'suppress': False},
        'osa-Latn': {'full': 'osa-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'osc': {'full': 'osc-Ital-IT', 'region': 'IT', 'script': 'Ital', 'suppress': False},
        'osc-Latn': {'full': 'osc-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'osi': {'full': 'osi-Java-ID', 'region': 'ID', 'script': 'Java', 'suppress': False},
        'oso': {'full': 'oso-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'osp': {'full': 'osp-Latn-ES', 'region': 'ES', 'script': 'Latn', 'suppress': False},
        'ost': {'full': 'ost-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'osu': {'full': 'osu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'osx': {'full': 'osx-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': False},
        'ota': {'full': 'ota-Arab-TR', 'region': 'TR', 'script': 'Arab', 'suppress': False},
        'otb': {'full': 'otb-Tibt-CN', 'region': 'CN', 'script': 'Tibt', 'suppress': False},
        'otd': {'full': 'otd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ote': {'full': 'ote-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'oti': {'full': 'oti-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'otk': {'full': 'otk-Orkh-MN', 'region': 'MN', 'script': 'Orkh', 'suppress': False},
        'otl': {'full': 'otl-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'otm': {'full': 'otm-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'otn': {'full': 'otn-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'otq': {'full': 'otq-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'otr': {'full': 'otr-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'ots': {'full': 'ots-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ott': {'full': 'ott-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'otu': {'full': 'otu-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'otw': {'full': 'otw-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'otx': {'full': 'otx-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'oty': {'full': 'oty-Gran-IN', 'region': 'IN', 'script': 'Gran', 'suppress': False},
        'otz': {'full': 'otz-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'oua': {'full': 'oua-Zyyy-DZ', 'region': 'DZ', 'script': 'Zyyy', 'suppress': False},
        'oub': {'full': 'oub-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'oue': {'full': 'oue-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'oui': {'full': 'oui-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'oui-Mong': {'full': 'oui-Mong-XX', 'region': 'XX', 'script': 'Mong', 'suppress': False},
        'oum': {'full': 'oum-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ovd': {'full': 'ovd-Latn-SE', 'region': 'SE', 'script': 'Latn', 'suppress': False},
        'owi': {'full': 'owi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'owl': {'full': 'owl-Latn-GB', 'region': 'GB', 'script': 'Latn', 'suppress': False},
        'oyb': {'full': 'oyb-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'oyd': {'full': 'oyd-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'oym': {'full': 'oym-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'oyy': {'full': 'oyy-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ozm': {'full': 'ozm-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'pa': {'full': 'pa-Guru-IN', 'region': 'IN', 'script': 'Guru', 'suppress': True},
        'pa-Khoj': {'full': 'pa-Khoj-IN', 'region': 'IN', 'script': 'Khoj', 'suppress': False},
        'pa-Mahj': {'full': 'pa-Mahj-IN', 'region': 'IN', 'script': 'Mahj', 'suppress': False},
        'pa-PK': {'full': 'pa-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'pab': {'full': 'pab-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'pac': {'full': 'pac-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'pac-Laoo-x-diacado': {'full': 'pac-Laoo-LA-x-diacado', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'pac-x-diacado': {'full': 'pac-Latn-VN-x-diacado', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'pad': {'full': 'pad-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'pae': {'full': 'pae-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'paf': {'full': 'paf-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'pag': {'full': 'pag-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'pag-Brai': {'full': 'pag-Brai-PH', 'region': 'PH', 'script': 'Brai', 'suppress': False},
        'pah': {'full': 'pah-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'pai': {'full': 'pai-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'pak': {'full': 'pak-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'pal': {'full': 'pal-Phli-IR', 'region': 'IR', 'script': 'Phli', 'suppress': False},
        'pal-Phlp': {'full': 'pal-Phlp-CN', 'region': 'CN', 'script': 'Phlp', 'suppress': False},
        'pam': {'full': 'pam-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'pam-Brai': {'full': 'pam-Brai-PH', 'region': 'PH', 'script': 'Brai', 'suppress': False},
        'pao': {'full': 'pao-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'pap': {'full': 'pap-Latn-AW', 'region': 'AW', 'script': 'Latn', 'suppress': False},
        'paq': {'full': 'paq-Zyyy-TJ', 'region': 'TJ', 'script': 'Zyyy', 'suppress': False},
        'par': {'full': 'par-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'pas': {'full': 'pas-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pat': {'full': 'pat-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'pau': {'full': 'pau-Latn-PW', 'region': 'PW', 'script': 'Latn', 'suppress': False},
        'pav': {'full': 'pav-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'paw': {'full': 'paw-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'pax': {'full': 'pax-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'pay': {'full': 'pay-Latn-HN', 'region': 'HN', 'script': 'Latn', 'suppress': False},
        'paz': {'full': 'paz-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'pbb': {'full': 'pbb-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'pbc': {'full': 'pbc-Latn-GY', 'region': 'GY', 'script': 'Latn', 'suppress': False},
        'pbe': {'full': 'pbe-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'pbf': {'full': 'pbf-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'pbg': {'full': 'pbg-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'pbh': {'full': 'pbh-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'pbi': {'full': 'pbi-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'pbl': {'full': 'pbl-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'pbm': {'full': 'pbm-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'pbn': {'full': 'pbn-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'pbo': {'full': 'pbo-Latn-GW', 'region': 'GW', 'script': 'Latn', 'suppress': False},
        'pbp': {'full': 'pbp-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'pbr': {'full': 'pbr-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'pbs': {'full': 'pbs-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'pbt': {'full': 'pbt-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'pbv': {'full': 'pbv-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'pby': {'full': 'pby-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'pca': {'full': 'pca-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'pcb': {'full': 'pcb-Zyyy-KH', 'region': 'KH', 'script': 'Zyyy', 'suppress': False},
        'pcc-Hani': {'full': 'pcc-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'pcc-Latn': {'full': 'pcc-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'pcd': {'full': 'pcd-Latn-FR', 'region': 'FR', 'script': 'Latn', 'suppress': False},
        'pce': {'full': 'pce-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'pcf': {'full': 'pcf-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'pcg-Knda': {'full': 'pcg-Knda-IN', 'region': 'IN', 'script': 'Knda', 'suppress': False},
        'pcg-Mlym': {'full': 'pcg-Mlym-IN', 'region': 'IN', 'script': 'Mlym', 'suppress': False},
        'pcg-Taml': {'full': 'pcg-Taml-IN', 'region': 'IN', 'script': 'Taml', 'suppress': False},
        'pch': {'full': 'pch-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'pci-Deva': {'full': 'pci-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'pci-Orya': {'full': 'pci-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'pcj': {'full': 'pcj-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'pck': {'full': 'pck-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'pcl': {'full': 'pcl-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'pcm': {'full': 'pcm-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'pcn': {'full': 'pcn-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'pcp': {'full': 'pcp-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'pcw': {'full': 'pcw-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'pda': {'full': 'pda-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'pdc': {'full': 'pdc-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'pdi': {'full': 'pdi-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'pdn': {'full': 'pdn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pdo': {'full': 'pdo-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pdt': {'full': 'pdt-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'pdu': {'full': 'pdu-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'pdu-Mymr': {'full': 'pdu-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'pea': {'full': 'pea-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'peb': {'full': 'peb-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'ped': {'full': 'ped-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'pee': {'full': 'pee-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pef': {'full': 'pef-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'peg': {'full': 'peg-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'peh': {'full': 'peh-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'pei': {'full': 'pei-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'pej': {'full': 'pej-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'pek': {'full': 'pek-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'pel': {'full': 'pel-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pem': {'full': 'pem-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'peo': {'full': 'peo-Xpeo-IR', 'region': 'IR', 'script': 'Xpeo', 'suppress': False},
        'pep': {'full': 'pep-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'peq': {'full': 'peq-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'pev': {'full': 'pev-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'pex': {'full': 'pex-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'pey': {'full': 'pey-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pez': {'full': 'pez-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'pfa': {'full': 'pfa-Latn-FM', 'region': 'FM', 'script': 'Latn', 'suppress': False},
        'pfe': {'full': 'pfe-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'pfl': {'full': 'pfl-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': False},
        'pga': {'full': 'pga-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'pgd': {'full': 'pgd-Khar-PK', 'region': 'PK', 'script': 'Khar', 'suppress': False},
        'pgg': {'full': 'pgg-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'pgi': {'full': 'pgi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'pgk': {'full': 'pgk-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'pgl': {'full': 'pgl-Ogam-IE', 'region': 'IE', 'script': 'Ogam', 'suppress': False},
        'pgn': {'full': 'pgn-Ital-IT', 'region': 'IT', 'script': 'Ital', 'suppress': False},
        'pgs': {'full': 'pgs-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'pgu': {'full': 'pgu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pgz': {'full': 'pgz-Zxxx-PG', 'region': 'PG', 'script': 'Zxxx', 'suppress': False},
        'pha': {'full': 'pha-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'phd': {'full': 'phd-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'phg': {'full': 'phg-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'phh': {'full': 'phh-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'phk': {'full': 'phk-Mymr-IN', 'region': 'IN', 'script': 'Mymr', 'suppress': False},
        'phl': {'full': 'phl-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'phm': {'full': 'phm-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'phn': {'full': 'phn-Phnx-LB', 'region': 'LB', 'script': 'Phnx', 'suppress': False},
        'pho': {'full': 'pho-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'phq': {'full': 'phq-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'phr': {'full': 'phr-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'pht': {'full': 'pht-Zyyy-TH', 'region': 'TH', 'script': 'Zyyy', 'suppress': False},
        'phu': {'full': 'phu-Zyyy-TH', 'region': 'TH', 'script': 'Zyyy', 'suppress': False},
        'phv': {'full': 'phv-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'phw': {'full': 'phw-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'pi-Deva': {'full': 'pi-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'pi-Mymr': {'full': 'pi-Mymr-IN', 'region': 'IN', 'script': 'Mymr', 'suppress': False},
        'pi-Sinh': {'full': 'pi-Sinh-IN', 'region': 'IN', 'script': 'Sinh', 'suppress': False},
        'pi-Thai': {'full': 'pi-Thai-IN', 'region': 'IN', 'script': 'Thai', 'suppress': False},
        'pia': {'full': 'pia-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'pib': {'full': 'pib-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'pic': {'full': 'pic-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'pid': {'full': 'pid-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'pie': {'full': 'pie-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'pif': {'full': 'pif-Latn-FM', 'region': 'FM', 'script': 'Latn', 'suppress': False},
        'pig': {'full': 'pig-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'pih': {'full': 'pih-Latn-NF', 'region': 'NF', 'script': 'Latn', 'suppress': False},
        'pii': {'full': 'pii-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'pij': {'full': 'pij-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'pil': {'full': 'pil-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'pim': {'full': 'pim-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'pin': {'full': 'pin-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'pio': {'full': 'pio-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'pip': {'full': 'pip-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'pir': {'full': 'pir-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'pis': {'full': 'pis-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'pit': {'full': 'pit-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'piu': {'full': 'piu-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'piv': {'full': 'piv-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'piw': {'full': 'piw-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'pix': {'full': 'pix-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'piy': {'full': 'piy-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'piz': {'full': 'piz-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'pjt': {'full': 'pjt-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'pka': {'full': 'pka-Brah-IN', 'region': 'IN', 'script': 'Brah', 'suppress': False},
        'pkb': {'full': 'pkb-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'pkc': {'full': 'pkc-Zyyy-KR', 'region': 'KR', 'script': 'Zyyy', 'suppress': False},
        'pkg': {'full': 'pkg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'pkh-Deva': {'full': 'pkh-Deva-BD', 'region': 'BD', 'script': 'Deva', 'suppress': False},
        'pkh-Latn': {'full': 'pkh-Latn-BD', 'region': 'BD', 'script': 'Latn', 'suppress': False},
        'pkn': {'full': 'pkn-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'pko': {'full': 'pko-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'pkp': {'full': 'pkp-Latn-CK', 'region': 'CK', 'script': 'Latn', 'suppress': False},
        'pkr': {'full': 'pkr-Mlym-IN', 'region': 'IN', 'script': 'Mlym', 'suppress': False},
        'pks': {'full': 'pks-Zxxx-PK', 'region': 'PK', 'script': 'Zxxx', 'suppress': False},
        'pkt': {'full': 'pkt-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'pku': {'full': 'pku-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pl': {'full': 'pl-Latn-PL', 'region': 'PL', 'script': 'Latn', 'suppress': True},
        'pl-Brai': {'full': 'pl-Brai-PL', 'region': 'PL', 'script': 'Brai', 'suppress': False},
        'pla': {'full': 'pla-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'plb': {'full': 'plb-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'plc': {'full': 'plc-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'pld': {'full': 'pld-Latn-GB', 'region': 'GB', 'script': 'Latn', 'suppress': False},
        'ple': {'full': 'ple-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'plg': {'full': 'plg-Latn-AR', 'region': 'AR', 'script': 'Latn', 'suppress': False},
        'plh': {'full': 'plh-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'plj': {'full': 'plj-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'plk': {'full': 'plk-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'pll': {'full': 'pll-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'pln': {'full': 'pln-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'plo': {'full': 'plo-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'plp': {'full': 'plp-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'plq': {'full': 'plq-Zyyy-TR', 'region': 'TR', 'script': 'Zyyy', 'suppress': False},
        'plr': {'full': 'plr-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'pls': {'full': 'pls-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'plu': {'full': 'plu-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'plv': {'full': 'plv-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'plw': {'full': 'plw-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ply': {'full': 'ply-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'plz': {'full': 'plz-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'pma': {'full': 'pma-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'pmb': {'full': 'pmb-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'pmd': {'full': 'pmd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'pme': {'full': 'pme-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'pmf': {'full': 'pmf-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pmh': {'full': 'pmh-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'pmi': {'full': 'pmi-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'pmj': {'full': 'pmj-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'pmk': {'full': 'pmk-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'pml': {'full': 'pml-Zyyy-TN', 'region': 'TN', 'script': 'Zyyy', 'suppress': False},
        'pmm': {'full': 'pmm-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'pmn': {'full': 'pmn-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'pmo': {'full': 'pmo-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pmq': {'full': 'pmq-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'pmr': {'full': 'pmr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'pms': {'full': 'pms-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'pmt': {'full': 'pmt-Latn-PF', 'region': 'PF', 'script': 'Latn', 'suppress': False},
        'pmw': {'full': 'pmw-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'pmx': {'full': 'pmx-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'pmy': {'full': 'pmy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pmz': {'full': 'pmz-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'pna': {'full': 'pna-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'pnc': {'full': 'pnc-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pnd': {'full': 'pnd-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'pne': {'full': 'pne-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'png': {'full': 'png-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'pnh': {'full': 'pnh-Latn-CK', 'region': 'CK', 'script': 'Latn', 'suppress': False},
        'pni': {'full': 'pni-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pnj': {'full': 'pnj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'pnk': {'full': 'pnk-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'pnl': {'full': 'pnl-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'pnm': {'full': 'pnm-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'pnn': {'full': 'pnn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'pno': {'full': 'pno-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'pnp': {'full': 'pnp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pnq': {'full': 'pnq-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'pnr': {'full': 'pnr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'pns': {'full': 'pns-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pnt': {'full': 'pnt-Grek-GR', 'region': 'GR', 'script': 'Grek', 'suppress': False},
        'pnt-Cyrl': {'full': 'pnt-Cyrl-GR', 'region': 'GR', 'script': 'Cyrl', 'suppress': False},
        'pnt-Latn': {'full': 'pnt-Latn-TR', 'region': 'TR', 'script': 'Latn', 'suppress': False},
        'pnu': {'full': 'pnu-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'pnv': {'full': 'pnv-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'pnw': {'full': 'pnw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'pnx': {'full': 'pnx-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'pny': {'full': 'pny-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'pnz': {'full': 'pnz-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'poc': {'full': 'poc-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'poe': {'full': 'poe-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'pof': {'full': 'pof-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'pog': {'full': 'pog-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'poh': {'full': 'poh-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'poi': {'full': 'poi-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'pok': {'full': 'pok-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'pom': {'full': 'pom-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'pon': {'full': 'pon-Latn-FM', 'region': 'FM', 'script': 'Latn', 'suppress': False},
        'poo': {'full': 'poo-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'pop': {'full': 'pop-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'poq': {'full': 'poq-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'pos': {'full': 'pos-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'pot': {'full': 'pot-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'pov': {'full': 'pov-Latn-GW', 'region': 'GW', 'script': 'Latn', 'suppress': False},
        'pow': {'full': 'pow-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'pox': {'full': 'pox-Zyyy-DE', 'region': 'DE', 'script': 'Zyyy', 'suppress': False},
        'poy': {'full': 'poy-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'ppe': {'full': 'ppe-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ppi': {'full': 'ppi-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ppk': {'full': 'ppk-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ppl': {'full': 'ppl-Latn-SV', 'region': 'SV', 'script': 'Latn', 'suppress': False},
        'ppm': {'full': 'ppm-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ppn': {'full': 'ppn-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ppo': {'full': 'ppo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ppp': {'full': 'ppp-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'ppq': {'full': 'ppq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'pps': {'full': 'pps-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ppt': {'full': 'ppt-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ppu': {'full': 'ppu-Zyyy-TW', 'region': 'TW', 'script': 'Zyyy', 'suppress': False},
        'pqa': {'full': 'pqa-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'pqm': {'full': 'pqm-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'pra': {'full': 'pra-Khar-PK', 'region': 'PK', 'script': 'Khar', 'suppress': False},
        'prb': {'full': 'prb-Zyyy-TH', 'region': 'TH', 'script': 'Zyyy', 'suppress': False},
        'prc': {'full': 'prc-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'prd': {'full': 'prd-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'pre': {'full': 'pre-Latn-ST', 'region': 'ST', 'script': 'Latn', 'suppress': False},
        'prf': {'full': 'prf-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'prg': {'full': 'prg-Latn-001', 'region': '001', 'script': 'Latn', 'suppress': False},
        'prh': {'full': 'prh-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'pri': {'full': 'pri-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'prk': {'full': 'prk-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'prl': {'full': 'prl-Zxxx-PE', 'region': 'PE', 'script': 'Zxxx', 'suppress': False},
        'prm': {'full': 'prm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'prn': {'full': 'prn-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'pro': {'full': 'pro-Latn-FR', 'region': 'FR', 'script': 'Latn', 'suppress': False},
        'prp': {'full': 'prp-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'prq': {'full': 'prq-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'prr': {'full': 'prr-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'prs': {'full': 'prs-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'prt': {'full': 'prt-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'pru': {'full': 'pru-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'prw': {'full': 'prw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'prx': {'full': 'prx-Arab-IN', 'region': 'IN', 'script': 'Arab', 'suppress': False},
        'prx-Tibt': {'full': 'prx-Tibt-IN', 'region': 'IN', 'script': 'Tibt', 'suppress': False},
        'prz': {'full': 'prz-Zxxx-CO', 'region': 'CO', 'script': 'Zxxx', 'suppress': False},
        'ps': {'full': 'ps-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': True},
        'ps-PK': {'full': 'ps-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': True},
        'psa': {'full': 'psa-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'psc': {'full': 'psc-Zxxx-IR', 'region': 'IR', 'script': 'Zxxx', 'suppress': False},
        'psd': {'full': 'psd-Zxxx-US', 'region': 'US', 'script': 'Zxxx', 'suppress': False},
        'pse': {'full': 'pse-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'psg': {'full': 'psg-Zxxx-MY', 'region': 'MY', 'script': 'Zxxx', 'suppress': False},
        'psh': {'full': 'psh-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'psi': {'full': 'psi-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'psl': {'full': 'psl-Zxxx-PR', 'region': 'PR', 'script': 'Zxxx', 'suppress': False},
        'psm': {'full': 'psm-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'psn': {'full': 'psn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pso': {'full': 'pso-Zxxx-PL', 'region': 'PL', 'script': 'Zxxx', 'suppress': False},
        'psp': {'full': 'psp-Zxxx-PH', 'region': 'PH', 'script': 'Zxxx', 'suppress': False},
        'psq': {'full': 'psq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'psr': {'full': 'psr-Zxxx-PT', 'region': 'PT', 'script': 'Zxxx', 'suppress': False},
        'pss': {'full': 'pss-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'pst': {'full': 'pst-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'psu-Brah': {'full': 'psu-Brah-IN', 'region': 'IN', 'script': 'Brah', 'suppress': False},
        'psu-Deva': {'full': 'psu-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'psw': {'full': 'psw-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'psy': {'full': 'psy-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'pt': {'full': 'pt-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': True},
        'pt-AO': {'full': 'pt-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': True},
        'pt-Brai': {'full': 'pt-Brai-PT', 'region': 'PT', 'script': 'Brai', 'suppress': False},
        'pt-CV': {'full': 'pt-Latn-CV', 'region': 'CV', 'script': 'Latn', 'suppress': True},
        'pt-GW': {'full': 'pt-Latn-GW', 'region': 'GW', 'script': 'Latn', 'suppress': True},
        'pt-LU': {'full': 'pt-Latn-LU', 'region': 'LU', 'script': 'Latn', 'suppress': True},
        'pt-MO': {'full': 'pt-Latn-MO', 'region': 'MO', 'script': 'Latn', 'suppress': True},
        'pt-MZ': {'full': 'pt-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': True},
        'pt-PT': {'full': 'pt-Latn-PT', 'region': 'PT', 'script': 'Latn', 'suppress': True},
        'pt-ST': {'full': 'pt-Latn-ST', 'region': 'ST', 'script': 'Latn', 'suppress': True},
        'pt-TL': {'full': 'pt-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': True},
        'pta': {'full': 'pta-Latn-PY', 'region': 'PY', 'script': 'Latn', 'suppress': False},
        'pth': {'full': 'pth-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'pti': {'full': 'pti-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ptn': {'full': 'ptn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pto': {'full': 'pto-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'ptp': {'full': 'ptp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ptq': {'full': 'ptq-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'ptr': {'full': 'ptr-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'ptt': {'full': 'ptt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ptu': {'full': 'ptu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ptv': {'full': 'ptv-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'ptw': {'full': 'ptw-Zyyy-CA', 'region': 'CA', 'script': 'Zyyy', 'suppress': False},
        'pty': {'full': 'pty-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'pua': {'full': 'pua-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'pub': {'full': 'pub-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'puc': {'full': 'puc-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pud': {'full': 'pud-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pue': {'full': 'pue-Latn-AR', 'region': 'AR', 'script': 'Latn', 'suppress': False},
        'puf': {'full': 'puf-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'pug': {'full': 'pug-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'pui': {'full': 'pui-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'puj': {'full': 'puj-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'puk': {'full': 'puk-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'pum': {'full': 'pum-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'puo': {'full': 'puo-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'pup': {'full': 'pup-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'puq': {'full': 'puq-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'pur': {'full': 'pur-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'put': {'full': 'put-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'puu': {'full': 'puu-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'puw': {'full': 'puw-Latn-FM', 'region': 'FM', 'script': 'Latn', 'suppress': False},
        'pux': {'full': 'pux-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'puy': {'full': 'puy-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'pwa': {'full': 'pwa-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'pwb': {'full': 'pwb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'pwg': {'full': 'pwg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'pwi': {'full': 'pwi-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'pwm': {'full': 'pwm-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'pwn': {'full': 'pwn-Latn-TW', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'pwo': {'full': 'pwo-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'pwr': {'full': 'pwr-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'pww': {'full': 'pww-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'pxm': {'full': 'pxm-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'pye': {'full': 'pye-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'pym': {'full': 'pym-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'pyn': {'full': 'pyn-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'pys': {'full': 'pys-Zxxx-PY', 'region': 'PY', 'script': 'Zxxx', 'suppress': False},
        'pyu': {'full': 'pyu-Latn-TW', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'pyu-Hani': {'full': 'pyu-Hani-TW', 'region': 'TW', 'script': 'Hani', 'suppress': False},
        'pyx': {'full': 'pyx-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'pyy': {'full': 'pyy-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'pzn': {'full': 'pzn-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'qu': {'full': 'qu-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': True},
        'qu-BO': {'full': 'qu-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': True},
        'qu-EC': {'full': 'qu-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': True},
        'qua': {'full': 'qua-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'qub': {'full': 'qub-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'quc': {'full': 'quc-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'qud': {'full': 'qud-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'quf': {'full': 'quf-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qug': {'full': 'qug-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'qui': {'full': 'qui-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'quk': {'full': 'quk-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qul': {'full': 'qul-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'qum': {'full': 'qum-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'qun': {'full': 'qun-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'qup': {'full': 'qup-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'quq': {'full': 'quq-Latn-ES', 'region': 'ES', 'script': 'Latn', 'suppress': False},
        'qur': {'full': 'qur-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qus': {'full': 'qus-Latn-AR', 'region': 'AR', 'script': 'Latn', 'suppress': False},
        'quv': {'full': 'quv-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'quw': {'full': 'quw-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'qux': {'full': 'qux-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'quy': {'full': 'quy-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qva': {'full': 'qva-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qvc': {'full': 'qvc-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qve': {'full': 'qve-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qvh': {'full': 'qvh-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qvi': {'full': 'qvi-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'qvj': {'full': 'qvj-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'qvl': {'full': 'qvl-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qvm': {'full': 'qvm-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qvn': {'full': 'qvn-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qvo': {'full': 'qvo-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qvp': {'full': 'qvp-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qvs': {'full': 'qvs-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qvw': {'full': 'qvw-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qvy': {'full': 'qvy-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'qvz': {'full': 'qvz-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'qwa': {'full': 'qwa-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qwc': {'full': 'qwc-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qwh': {'full': 'qwh-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qwm': {'full': 'qwm-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'qws': {'full': 'qws-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qwt': {'full': 'qwt-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'qxa': {'full': 'qxa-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qxc': {'full': 'qxc-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qxh': {'full': 'qxh-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qxl': {'full': 'qxl-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'qxn': {'full': 'qxn-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qxo': {'full': 'qxo-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qxp': {'full': 'qxp-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qxq': {'full': 'qxq-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'qxr': {'full': 'qxr-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'qxs': {'full': 'qxs-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'qxt': {'full': 'qxt-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qxu': {'full': 'qxu-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qxw': {'full': 'qxw-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'qya': {'full': 'qya-Latn-001', 'region': '001', 'script': 'Latn', 'suppress': False},
        'qya-Cirt': {'full': 'qya-Cirt-001', 'region': '001', 'script': 'Cirt', 'suppress': False},
        'qya-Sara': {'full': 'qya-Sara-001', 'region': '001', 'script': 'Sara', 'suppress': False},
        'qya-Teng': {'full': 'qya-Teng-001', 'region': '001', 'script': 'Teng', 'suppress': False},
        'qyp': {'full': 'qyp-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'raa': {'full': 'raa-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'rab': {'full': 'rab-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'rac': {'full': 'rac-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'rad': {'full': 'rad-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'raf': {'full': 'raf-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'rag': {'full': 'rag-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'rah': {'full': 'rah-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'rah-Latn': {'full': 'rah-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'rai': {'full': 'rai-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'raj': {'full': 'raj-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'raj-Latn': {'full': 'raj-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'rak': {'full': 'rak-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ral': {'full': 'ral-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'ram': {'full': 'ram-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'ran': {'full': 'ran-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'rao': {'full': 'rao-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'rap': {'full': 'rap-Latn-CL', 'region': 'CL', 'script': 'Latn', 'suppress': False},
        'raq': {'full': 'raq-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'rar': {'full': 'rar-Latn-CK', 'region': 'CK', 'script': 'Latn', 'suppress': False},
        'ras': {'full': 'ras-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'rat': {'full': 'rat-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'rau': {'full': 'rau-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'rav': {'full': 'rav-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'raw': {'full': 'raw-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'raw-x-daruzerw': {'full': 'raw-Latn-MM-x-daruzerw', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'raw-x-longmin': {'full': 'raw-Latn-MM-x-longmin', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'raw-x-longmis': {'full': 'raw-Latn-MM-x-longmis', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'raw-x-tangsare': {'full': 'raw-Latn-MM-x-tangsare', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'raw-x-tangsarw': {'full': 'raw-Latn-MM-x-tangsarw', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'rax': {'full': 'rax-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ray': {'full': 'ray-Latn-PF', 'region': 'PF', 'script': 'Latn', 'suppress': False},
        'raz': {'full': 'raz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'rbb': {'full': 'rbb-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'rbk': {'full': 'rbk-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'rbl': {'full': 'rbl-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'rbp': {'full': 'rbp-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'rcf': {'full': 'rcf-Latn-RE', 'region': 'RE', 'script': 'Latn', 'suppress': False},
        'rdb': {'full': 'rdb-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'rea': {'full': 'rea-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'reb': {'full': 'reb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ree': {'full': 'ree-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'reg': {'full': 'reg-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'rei': {'full': 'rei-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'rej': {'full': 'rej-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'rej-Rjng': {'full': 'rej-Rjng-ID', 'region': 'ID', 'script': 'Rjng', 'suppress': False},
        'rel': {'full': 'rel-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'rem': {'full': 'rem-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'ren': {'full': 'ren-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'rer': {'full': 'rer-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'res': {'full': 'res-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ret': {'full': 'ret-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'rey': {'full': 'rey-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'rga': {'full': 'rga-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'rge': {'full': 'rge-Zyyy-GR', 'region': 'GR', 'script': 'Zyyy', 'suppress': False},
        'rgk': {'full': 'rgk-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'rgn': {'full': 'rgn-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'rgr': {'full': 'rgr-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'rgs': {'full': 'rgs-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'rgu': {'full': 'rgu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'rhg-Arab': {'full': 'rhg-Arab-MM', 'region': 'MM', 'script': 'Arab', 'suppress': False},
        'rhg-Latn': {'full': 'rhg-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'rhg-Rohg': {'full': 'rhg-Rohg-MM', 'region': 'MM', 'script': 'Rohg', 'suppress': False},
        'rhp': {'full': 'rhp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ria': {'full': 'ria-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'rie': {'full': 'rie-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'rif': {'full': 'rif-Tfng-MA', 'region': 'MA', 'script': 'Tfng', 'suppress': False},
        'rif-Arab': {'full': 'rif-Arab-MA', 'region': 'MA', 'script': 'Arab', 'suppress': False},
        'rif-Latn': {'full': 'rif-Latn-MA', 'region': 'MA', 'script': 'Latn', 'suppress': False},
        'rif-NL': {'full': 'rif-Latn-NL', 'region': 'NL', 'script': 'Latn', 'suppress': False},
        'ril': {'full': 'ril-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'rim': {'full': 'rim-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'rin': {'full': 'rin-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'rir': {'full': 'rir-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'rit': {'full': 'rit-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'riu': {'full': 'riu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'rjg': {'full': 'rjg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'rji': {'full': 'rji-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'rjs': {'full': 'rjs-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'rka': {'full': 'rka-Zyyy-KH', 'region': 'KH', 'script': 'Zyyy', 'suppress': False},
        'rkb': {'full': 'rkb-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'rkh': {'full': 'rkh-Latn-CK', 'region': 'CK', 'script': 'Latn', 'suppress': False},
        'rki': {'full': 'rki-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'rkm': {'full': 'rkm-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'rkt': {'full': 'rkt-Beng-BD', 'region': 'BD', 'script': 'Beng', 'suppress': False},
        'rkw': {'full': 'rkw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'rm': {'full': 'rm-Latn-CH', 'region': 'CH', 'script': 'Latn', 'suppress': True},
        'rma': {'full': 'rma-Latn-NI', 'region': 'NI', 'script': 'Latn', 'suppress': False},
        'rmb': {'full': 'rmb-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'rmc': {'full': 'rmc-Latn-SK', 'region': 'SK', 'script': 'Latn', 'suppress': False},
        'rmd': {'full': 'rmd-Latn-DK', 'region': 'DK', 'script': 'Latn', 'suppress': False},
        'rme': {'full': 'rme-Latn-GB', 'region': 'GB', 'script': 'Latn', 'suppress': False},
        'rmf': {'full': 'rmf-Latn-FI', 'region': 'FI', 'script': 'Latn', 'suppress': False},
        'rmg': {'full': 'rmg-Zyyy-NO', 'region': 'NO', 'script': 'Zyyy', 'suppress': False},
        'rmh': {'full': 'rmh-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'rmi': {'full': 'rmi-Zyyy-AM', 'region': 'AM', 'script': 'Zyyy', 'suppress': False},
        'rmk': {'full': 'rmk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'rml': {'full': 'rml-Latn-PL', 'region': 'PL', 'script': 'Latn', 'suppress': False},
        'rml-Cyrl': {'full': 'rml-Cyrl-BY', 'region': 'BY', 'script': 'Cyrl', 'suppress': False},
        'rmm': {'full': 'rmm-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'rmn': {'full': 'rmn-Latn-RS', 'region': 'RS', 'script': 'Latn', 'suppress': False},
        'rmn-Cyrl': {'full': 'rmn-Cyrl-BG', 'region': 'BG', 'script': 'Cyrl', 'suppress': False},
        'rmn-Grek': {'full': 'rmn-Grek-GR', 'region': 'GR', 'script': 'Grek', 'suppress': False},
        'rmo': {'full': 'rmo-Latn-CH', 'region': 'CH', 'script': 'Latn', 'suppress': False},
        'rmp': {'full': 'rmp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'rmq': {'full': 'rmq-Latn-ES', 'region': 'ES', 'script': 'Latn', 'suppress': False},
        'rms': {'full': 'rms-Zxxx-RO', 'region': 'RO', 'script': 'Zxxx', 'suppress': False},
        'rmt': {'full': 'rmt-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'rmu': {'full': 'rmu-Latn-SE', 'region': 'SE', 'script': 'Latn', 'suppress': False},
        'rmv': {'full': 'rmv-Zyyy-001', 'region': '001', 'script': 'Zyyy', 'suppress': False},
        'rmw': {'full': 'rmw-Latn-GB', 'region': 'GB', 'script': 'Latn', 'suppress': False},
        'rmx': {'full': 'rmx-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'rmz': {'full': 'rmz-Mymr-IN', 'region': 'IN', 'script': 'Mymr', 'suppress': False},
        'rn': {'full': 'rn-Latn-BI', 'region': 'BI', 'script': 'Latn', 'suppress': True},
        'rn-Brai': {'full': 'rn-Brai-BI', 'region': 'BI', 'script': 'Brai', 'suppress': False},
        'rnd': {'full': 'rnd-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'rng': {'full': 'rng-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'rnl': {'full': 'rnl-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'rnn': {'full': 'rnn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'rnp': {'full': 'rnp-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'rnr': {'full': 'rnr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'rnw': {'full': 'rnw-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'ro': {'full': 'ro-Latn-RO', 'region': 'RO', 'script': 'Latn', 'suppress': True},
        'ro-Brai': {'full': 'ro-Brai-RO', 'region': 'RO', 'script': 'Brai', 'suppress': False},
        'ro-Cyrl': {'full': 'ro-Cyrl-MD', 'region': 'MD', 'script': 'Cyrl', 'suppress': False},
        'ro-Dupl': {'full': 'ro-Dupl-RO', 'region': 'RO', 'script': 'Dupl', 'suppress': False},
        'ro-MD': {'full': 'ro-Latn-MD', 'region': 'MD', 'script': 'Latn', 'suppress': True},
        'rob': {'full': 'rob-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'roc': {'full': 'roc-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'rod': {'full': 'rod-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'roe': {'full': 'roe-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'rof': {'full': 'rof-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'rog': {'full': 'rog-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'rol': {'full': 'rol-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'rom': {'full': 'rom-Latn-RO', 'region': 'RO', 'script': 'Latn', 'suppress': False},
        'rom-Cyrl': {'full': 'rom-Cyrl-RO', 'region': 'RO', 'script': 'Cyrl', 'suppress': False},
        'rom-Cyrl-BG': {'full': 'rom-Cyrl-BG', 'region': 'BG', 'script': 'Cyrl', 'suppress': False},
        'roo': {'full': 'roo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'rop': {'full': 'rop-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ror': {'full': 'ror-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'rou': {'full': 'rou-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'row': {'full': 'row-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'rpn': {'full': 'rpn-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'rpt': {'full': 'rpt-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'rri': {'full': 'rri-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'rro': {'full': 'rro-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'rrt': {'full': 'rrt-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'rsb': {'full': 'rsb-Zyyy-RS', 'region': 'RS', 'script': 'Zyyy', 'suppress': False},
        'rsi': {'full': 'rsi-Zxxx-SB', 'region': 'SB', 'script': 'Zxxx', 'suppress': False},
        'rsl': {'full': 'rsl-Zxxx-RU', 'region': 'RU', 'script': 'Zxxx', 'suppress': False},
        'rsm': {'full': 'rsm-Zxxx-AU', 'region': 'AU', 'script': 'Zxxx', 'suppress': False},
        'rtc': {'full': 'rtc-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'rth': {'full': 'rth-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'rtm': {'full': 'rtm-Latn-FJ', 'region': 'FJ', 'script': 'Latn', 'suppress': False},
        'rts': {'full': 'rts-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'rtw': {'full': 'rtw-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'ru': {'full': 'ru-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': True},
        'ru-BY': {'full': 'ru-Cyrl-BY', 'region': 'BY', 'script': 'Cyrl', 'suppress': True},
        'ru-Brai': {'full': 'ru-Brai-RU', 'region': 'RU', 'script': 'Brai', 'suppress': False},
        'ru-KG': {'full': 'ru-Cyrl-KG', 'region': 'KG', 'script': 'Cyrl', 'suppress': True},
        'ru-KZ': {'full': 'ru-Cyrl-KZ', 'region': 'KZ', 'script': 'Cyrl', 'suppress': True},
        'ru-MD': {'full': 'ru-Cyrl-MD', 'region': 'MD', 'script': 'Cyrl', 'suppress': True},
        'ru-UA': {'full': 'ru-Cyrl-UA', 'region': 'UA', 'script': 'Cyrl', 'suppress': True},
        'rub': {'full': 'rub-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'ruc': {'full': 'ruc-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'rue': {'full': 'rue-Cyrl-UA', 'region': 'UA', 'script': 'Cyrl', 'suppress': False},
        'rue-Latn': {'full': 'rue-Latn-SK', 'region': 'SK', 'script': 'Latn', 'suppress': False},
        'ruf': {'full': 'ruf-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'rug': {'full': 'rug-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'ruh': {'full': 'ruh-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'rui': {'full': 'rui-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'ruk': {'full': 'ruk-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ruo': {'full': 'ruo-Latn-HR', 'region': 'HR', 'script': 'Latn', 'suppress': False},
        'rup': {'full': 'rup-Latn-RO', 'region': 'RO', 'script': 'Latn', 'suppress': False},
        'rup-Grek': {'full': 'rup-Grek-GR', 'region': 'GR', 'script': 'Grek', 'suppress': False},
        'ruq': {'full': 'ruq-Latn-GR', 'region': 'GR', 'script': 'Latn', 'suppress': False},
        'rut': {'full': 'rut-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'rut-Latn': {'full': 'rut-Latn-AZ', 'region': 'AZ', 'script': 'Latn', 'suppress': False},
        'ruu': {'full': 'ruu-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'ruy': {'full': 'ruy-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ruz': {'full': 'ruz-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'rw': {'full': 'rw-Latn-RW', 'region': 'RW', 'script': 'Latn', 'suppress': True},
        'rw-Brai': {'full': 'rw-Brai-RW', 'region': 'RW', 'script': 'Brai', 'suppress': False},
        'rwa': {'full': 'rwa-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'rwk': {'full': 'rwk-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'rwm': {'full': 'rwm-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'rwo': {'full': 'rwo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'rwo-x-karo': {'full': 'rwo-Latn-PG-x-karo', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'rwr': {'full': 'rwr-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'rxd': {'full': 'rxd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'rxw': {'full': 'rxw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ryn': {'full': 'ryn-Zyyy-JP', 'region': 'JP', 'script': 'Zyyy', 'suppress': False},
        'rys': {'full': 'rys-Zyyy-JP', 'region': 'JP', 'script': 'Zyyy', 'suppress': False},
        'ryu': {'full': 'ryu-Kana-JP', 'region': 'JP', 'script': 'Kana', 'suppress': False},
        'rzh': {'full': 'rzh-Zyyy-YE', 'region': 'YE', 'script': 'Zyyy', 'suppress': False},
        'sa': {'full': 'sa-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'sa-Gran': {'full': 'sa-Gran-IN', 'region': 'IN', 'script': 'Gran', 'suppress': False},
        'sa-Mymr': {'full': 'sa-Mymr-IN', 'region': 'IN', 'script': 'Mymr', 'suppress': False},
        'sa-Nand': {'full': 'sa-Nand-IN', 'region': 'IN', 'script': 'Nand', 'suppress': False},
        'sa-Newa': {'full': 'sa-Newa-IN', 'region': 'IN', 'script': 'Newa', 'suppress': False},
        'sa-Shrd': {'full': 'sa-Shrd-IN', 'region': 'IN', 'script': 'Shrd', 'suppress': False},
        'sa-Sidd': {'full': 'sa-Sidd-IN', 'region': 'IN', 'script': 'Sidd', 'suppress': False},
        'sa-Sinh': {'full': 'sa-Sinh-IN', 'region': 'IN', 'script': 'Sinh', 'suppress': False},
        'saa': {'full': 'saa-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'sab': {'full': 'sab-Latn-PA', 'region': 'PA', 'script': 'Latn', 'suppress': False},
        'sac': {'full': 'sac-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'sad': {'full': 'sad-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'sae': {'full': 'sae-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'saf': {'full': 'saf-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'sah': {'full': 'sah-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'saj': {'full': 'saj-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sak': {'full': 'sak-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'sam': {'full': 'sam-Samr-PS', 'region': 'PS', 'script': 'Samr', 'suppress': False},
        'sam-Hebr': {'full': 'sam-Hebr-PS', 'region': 'PS', 'script': 'Hebr', 'suppress': False},
        'sam-Syrc': {'full': 'sam-Syrc-PS', 'region': 'PS', 'script': 'Syrc', 'suppress': False},
        'sao': {'full': 'sao-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'saq': {'full': 'saq-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'sar': {'full': 'sar-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'sas': {'full': 'sas-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sas-Bali': {'full': 'sas-Bali-ID', 'region': 'ID', 'script': 'Bali', 'suppress': False},
        'sat': {'full': 'sat-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'sat-Beng': {'full': 'sat-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'sat-Deva': {'full': 'sat-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'sat-Olck': {'full': 'sat-Olck-IN', 'region': 'IN', 'script': 'Olck', 'suppress': False},
        'sat-Orya': {'full': 'sat-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'sau': {'full': 'sau-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sav': {'full': 'sav-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'sav-Arab': {'full': 'sav-Arab-SN', 'region': 'SN', 'script': 'Arab', 'suppress': False},
        'saw': {'full': 'saw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sax': {'full': 'sax-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'say': {'full': 'say-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'saz': {'full': 'saz-Saur-IN', 'region': 'IN', 'script': 'Saur', 'suppress': False},
        'saz-Deva': {'full': 'saz-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'saz-Taml': {'full': 'saz-Taml-IN', 'region': 'IN', 'script': 'Taml', 'suppress': False},
        'saz-Telu': {'full': 'saz-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'sba': {'full': 'sba-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'sbb': {'full': 'sbb-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'sbc': {'full': 'sbc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sbd': {'full': 'sbd-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'sbe': {'full': 'sbe-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sbf': {'full': 'sbf-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'sbg': {'full': 'sbg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sbh': {'full': 'sbh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sbi': {'full': 'sbi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sbj': {'full': 'sbj-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'sbk': {'full': 'sbk-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'sbl': {'full': 'sbl-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'sbm': {'full': 'sbm-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'sbn': {'full': 'sbn-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'sbo': {'full': 'sbo-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'sbp': {'full': 'sbp-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'sbq': {'full': 'sbq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sbr': {'full': 'sbr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sbs': {'full': 'sbs-Latn-NA', 'region': 'NA', 'script': 'Latn', 'suppress': False},
        'sbt': {'full': 'sbt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sbu-Deva': {'full': 'sbu-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'sbu-Tibt': {'full': 'sbu-Tibt-IN', 'region': 'IN', 'script': 'Tibt', 'suppress': False},
        'sbv': {'full': 'sbv-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'sbw': {'full': 'sbw-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'sbx': {'full': 'sbx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sby': {'full': 'sby-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'sbz': {'full': 'sbz-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'sc': {'full': 'sc-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'scb': {'full': 'scb-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'sce': {'full': 'sce-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'sce-Arab': {'full': 'sce-Arab-CN', 'region': 'CN', 'script': 'Arab', 'suppress': False},
        'scf': {'full': 'scf-Latn-PA', 'region': 'PA', 'script': 'Latn', 'suppress': False},
        'scg': {'full': 'scg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sch': {'full': 'sch-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'sci': {'full': 'sci-Latn-LK', 'region': 'LK', 'script': 'Latn', 'suppress': False},
        'sck': {'full': 'sck-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'sck-Beng': {'full': 'sck-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'scl': {'full': 'scl-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'scl-IN': {'full': 'scl-Arab-IN', 'region': 'IN', 'script': 'Arab', 'suppress': False},
        'scn': {'full': 'scn-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'sco': {'full': 'sco-Latn-GB', 'region': 'GB', 'script': 'Latn', 'suppress': False},
        'scp': {'full': 'scp-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'scq': {'full': 'scq-Zyyy-KH', 'region': 'KH', 'script': 'Zyyy', 'suppress': False},
        'scs': {'full': 'scs-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'scs-Cans': {'full': 'scs-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'sct': {'full': 'sct-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'scu': {'full': 'scu-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'scv': {'full': 'scv-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'scw': {'full': 'scw-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'scx': {'full': 'scx-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'sd': {'full': 'sd-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'sd-Deva': {'full': 'sd-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'sd-Guru': {'full': 'sd-Guru-IN', 'region': 'IN', 'script': 'Guru', 'suppress': False},
        'sd-Khoj': {'full': 'sd-Khoj-IN', 'region': 'IN', 'script': 'Khoj', 'suppress': False},
        'sd-Khoj-PK': {'full': 'sd-Khoj-PK', 'region': 'PK', 'script': 'Khoj', 'suppress': False},
        'sd-Sind': {'full': 'sd-Sind-IN', 'region': 'IN', 'script': 'Sind', 'suppress': False},
        'sda': {'full': 'sda-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sdb': {'full': 'sdb-Zyyy-IQ', 'region': 'IQ', 'script': 'Zyyy', 'suppress': False},
        'sdc': {'full': 'sdc-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'sde': {'full': 'sde-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'sdf': {'full': 'sdf-Zyyy-IQ', 'region': 'IQ', 'script': 'Zyyy', 'suppress': False},
        'sdg': {'full': 'sdg-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'sdh': {'full': 'sdh-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'sdj': {'full': 'sdj-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'sdk': {'full': 'sdk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sdl': {'full': 'sdl-Zxxx-SA', 'region': 'SA', 'script': 'Zxxx', 'suppress': False},
        'sdm': {'full': 'sdm-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sdn': {'full': 'sdn-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'sdo': {'full': 'sdo-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'sdp': {'full': 'sdp-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'sdq': {'full': 'sdq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sdr-Beng': {'full': 'sdr-Beng-BD', 'region': 'BD', 'script': 'Beng', 'suppress': False},
        'sdr-Deva': {'full': 'sdr-Deva-BD', 'region': 'BD', 'script': 'Deva', 'suppress': False},
        'sdr-Latn': {'full': 'sdr-Latn-BD', 'region': 'BD', 'script': 'Latn', 'suppress': False},
        'sds': {'full': 'sds-Zyyy-TN', 'region': 'TN', 'script': 'Zyyy', 'suppress': False},
        'sdt': {'full': 'sdt-Zyyy-FR', 'region': 'FR', 'script': 'Zyyy', 'suppress': False},
        'sdu': {'full': 'sdu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sdx': {'full': 'sdx-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'sdz': {'full': 'sdz-Zyyy-NL', 'region': 'NL', 'script': 'Zyyy', 'suppress': False},
        'se': {'full': 'se-Latn-NO', 'region': 'NO', 'script': 'Latn', 'suppress': False},
        'se-Cyrl': {'full': 'se-Cyrl-NO', 'region': 'NO', 'script': 'Cyrl', 'suppress': False},
        'se-FI': {'full': 'se-Latn-FI', 'region': 'FI', 'script': 'Latn', 'suppress': False},
        'se-SE': {'full': 'se-Latn-SE', 'region': 'SE', 'script': 'Latn', 'suppress': False},
        'sea': {'full': 'sea-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'seb': {'full': 'seb-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'sec': {'full': 'sec-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'sed': {'full': 'sed-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'see': {'full': 'see-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'sef': {'full': 'sef-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'seg': {'full': 'seg-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'seh': {'full': 'seh-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'sei': {'full': 'sei-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'sej': {'full': 'sej-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sek': {'full': 'sek-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'sek-Cans': {'full': 'sek-Cans-CA', 'region': 'CA', 'script': 'Cans', 'suppress': False},
        'sel': {'full': 'sel-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'sen': {'full': 'sen-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'seo': {'full': 'seo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sep': {'full': 'sep-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'seq': {'full': 'seq-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'ser': {'full': 'ser-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'ses': {'full': 'ses-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'set': {'full': 'set-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'seu': {'full': 'seu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sev': {'full': 'sev-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'sew': {'full': 'sew-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sey': {'full': 'sey-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'sez': {'full': 'sez-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'sfb': {'full': 'sfb-Zxxx-BE', 'region': 'BE', 'script': 'Zxxx', 'suppress': False},
        'sfe': {'full': 'sfe-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'sfm': {'full': 'sfm-Plrd-CN', 'region': 'CN', 'script': 'Plrd', 'suppress': False},
        'sfs': {'full': 'sfs-Zxxx-ZA', 'region': 'ZA', 'script': 'Zxxx', 'suppress': False},
        'sfw': {'full': 'sfw-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'sg': {'full': 'sg-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': True},
        'sga': {'full': 'sga-Ogam-IE', 'region': 'IE', 'script': 'Ogam', 'suppress': False},
        'sga-Latn': {'full': 'sga-Latn-IE', 'region': 'IE', 'script': 'Latn', 'suppress': False},
        'sgb': {'full': 'sgb-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'sgc': {'full': 'sgc-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'sgd': {'full': 'sgd-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'sge': {'full': 'sge-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sgg': {'full': 'sgg-Zxxx-CH', 'region': 'CH', 'script': 'Zxxx', 'suppress': False},
        'sgh-Arab': {'full': 'sgh-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'sgh-Cyrl': {'full': 'sgh-Cyrl-TJ', 'region': 'TJ', 'script': 'Cyrl', 'suppress': False},
        'sgh-Latn': {'full': 'sgh-Latn-TJ', 'region': 'TJ', 'script': 'Latn', 'suppress': False},
        'sgi': {'full': 'sgi-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'sgj': {'full': 'sgj-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'sgk': {'full': 'sgk-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'sgm': {'full': 'sgm-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'sgn-MM': {'full': 'sgn-Zxxx-MM', 'region': 'MM', 'script': 'Zxxx', 'suppress': False},
        'sgp': {'full': 'sgp-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'sgr': {'full': 'sgr-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'sgs': {'full': 'sgs-Latn-LT', 'region': 'LT', 'script': 'Latn', 'suppress': False},
        'sgt': {'full': 'sgt-Zyyy-BT', 'region': 'BT', 'script': 'Zyyy', 'suppress': False},
        'sgu': {'full': 'sgu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sgw': {'full': 'sgw-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'sgx': {'full': 'sgx-Zxxx-SL', 'region': 'SL', 'script': 'Zxxx', 'suppress': False},
        'sgy': {'full': 'sgy-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'sgz': {'full': 'sgz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sh': {'full': 'sh-Latn-RS', 'region': 'RS', 'script': 'Latn', 'suppress': False},
        'sha': {'full': 'sha-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'shb': {'full': 'shb-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'shc': {'full': 'shc-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'shd': {'full': 'shd-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'she': {'full': 'she-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'shg': {'full': 'shg-Latn-BW', 'region': 'BW', 'script': 'Latn', 'suppress': False},
        'shh': {'full': 'shh-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'shi': {'full': 'shi-Tfng-MA', 'region': 'MA', 'script': 'Tfng', 'suppress': False},
        'shi-Arab': {'full': 'shi-Arab-MA', 'region': 'MA', 'script': 'Arab', 'suppress': False},
        'shi-Latn': {'full': 'shi-Latn-MA', 'region': 'MA', 'script': 'Latn', 'suppress': False},
        'shj': {'full': 'shj-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'shk': {'full': 'shk-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'shk-Arab': {'full': 'shk-Arab-SS', 'region': 'SS', 'script': 'Arab', 'suppress': False},
        'shl': {'full': 'shl-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'shm': {'full': 'shm-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'shn': {'full': 'shn-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'shn-Mymr-x-taimau': {'full': 'shn-Mymr-MM-x-taimau', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'shn-Tale': {'full': 'shn-Tale-MM', 'region': 'MM', 'script': 'Tale', 'suppress': False},
        'shn-Thai': {'full': 'shn-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'sho': {'full': 'sho-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'shp': {'full': 'shp-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'shq': {'full': 'shq-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'shr': {'full': 'shr-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'shs': {'full': 'shs-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'sht': {'full': 'sht-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'shu-Arab': {'full': 'shu-Arab-TD', 'region': 'TD', 'script': 'Arab', 'suppress': False},
        'shu-Latn': {'full': 'shu-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'shv': {'full': 'shv-Zyyy-OM', 'region': 'OM', 'script': 'Zyyy', 'suppress': False},
        'shw': {'full': 'shw-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'shx': {'full': 'shx-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'shy-Arab': {'full': 'shy-Arab-DZ', 'region': 'DZ', 'script': 'Arab', 'suppress': False},
        'shy-Latn': {'full': 'shy-Latn-DZ', 'region': 'DZ', 'script': 'Latn', 'suppress': False},
        'shy-Tfng': {'full': 'shy-Tfng-DZ', 'region': 'DZ', 'script': 'Tfng', 'suppress': False},
        'shz': {'full': 'shz-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'si': {'full': 'si-Sinh-LK', 'region': 'LK', 'script': 'Sinh', 'suppress': True},
        'si-Brai': {'full': 'si-Brai-LK', 'region': 'LK', 'script': 'Brai', 'suppress': False},
        'sia': {'full': 'sia-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'sib': {'full': 'sib-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'sid': {'full': 'sid-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'sid-Ethi': {'full': 'sid-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'sie': {'full': 'sie-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'sif': {'full': 'sif-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'sig': {'full': 'sig-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'sih': {'full': 'sih-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'sii': {'full': 'sii-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'sij': {'full': 'sij-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sik': {'full': 'sik-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'sil': {'full': 'sil-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'sim': {'full': 'sim-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sip': {'full': 'sip-Tibt-IN', 'region': 'IN', 'script': 'Tibt', 'suppress': False},
        'siq': {'full': 'siq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sir': {'full': 'sir-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'sis': {'full': 'sis-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'siu': {'full': 'siu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'siv': {'full': 'siv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'siw': {'full': 'siw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'six': {'full': 'six-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'siy': {'full': 'siy-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'siz': {'full': 'siz-Arab-EG', 'region': 'EG', 'script': 'Arab', 'suppress': False},
        'sja': {'full': 'sja-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'sjb': {'full': 'sjb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sjd': {'full': 'sjd-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'sje': {'full': 'sje-Zyyy-SE', 'region': 'SE', 'script': 'Zyyy', 'suppress': False},
        'sjg': {'full': 'sjg-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'sjk': {'full': 'sjk-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'sjl': {'full': 'sjl-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'sjm': {'full': 'sjm-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'sjn': {'full': 'sjn-Zyyy-001', 'region': '001', 'script': 'Zyyy', 'suppress': False},
        'sjo': {'full': 'sjo-Mong-CN-x-sibe', 'region': 'CN', 'script': 'Mong', 'suppress': False},
        'sjo-Cyrl': {'full': 'sjo-Cyrl-CN', 'region': 'CN', 'script': 'Cyrl', 'suppress': False},
        'sjo-Latn': {'full': 'sjo-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'sjo-Mong-x-manchu': {'full': 'sjo-Mong-CN-x-manchu', 'region': 'CN', 'script': 'Mong', 'suppress': False},
        'sjp': {'full': 'sjp-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'sjr': {'full': 'sjr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sjs': {'full': 'sjs-Zyyy-MA', 'region': 'MA', 'script': 'Zyyy', 'suppress': False},
        'sjt': {'full': 'sjt-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'sju': {'full': 'sju-Latn-SE', 'region': 'SE', 'script': 'Latn', 'suppress': False},
        'sjw': {'full': 'sjw-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'sk': {'full': 'sk-Latn-SK', 'region': 'SK', 'script': 'Latn', 'suppress': True},
        'sk-Brai': {'full': 'sk-Brai-SK', 'region': 'SK', 'script': 'Brai', 'suppress': False},
        'ska': {'full': 'ska-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'skb': {'full': 'skb-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'skc': {'full': 'skc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'skd': {'full': 'skd-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'ske': {'full': 'ske-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'skf': {'full': 'skf-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'skg': {'full': 'skg-Latn-MG', 'region': 'MG', 'script': 'Latn', 'suppress': False},
        'skh': {'full': 'skh-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ski': {'full': 'ski-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'skj': {'full': 'skj-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'skm': {'full': 'skm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'skn': {'full': 'skn-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'sko': {'full': 'sko-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'skp': {'full': 'skp-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'skq': {'full': 'skq-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'skr': {'full': 'skr-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'skr-Deva': {'full': 'skr-Deva-PK', 'region': 'PK', 'script': 'Deva', 'suppress': False},
        'skr-Guru': {'full': 'skr-Guru-PK', 'region': 'PK', 'script': 'Guru', 'suppress': False},
        'skr-Khoj': {'full': 'skr-Khoj-PK', 'region': 'PK', 'script': 'Khoj', 'suppress': False},
        'sks': {'full': 'sks-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'skt': {'full': 'skt-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'sku': {'full': 'sku-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'skv': {'full': 'skv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'skw': {'full': 'skw-Latn-GY', 'region': 'GY', 'script': 'Latn', 'suppress': False},
        'skx': {'full': 'skx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sky': {'full': 'sky-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'skz': {'full': 'skz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sl': {'full': 'sl-Latn-SI', 'region': 'SI', 'script': 'Latn', 'suppress': True},
        'sl-Brai': {'full': 'sl-Brai-SI', 'region': 'SI', 'script': 'Brai', 'suppress': False},
        'slc': {'full': 'slc-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'sld': {'full': 'sld-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'sle': {'full': 'sle-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'slf': {'full': 'slf-Zxxx-CH', 'region': 'CH', 'script': 'Zxxx', 'suppress': False},
        'slg': {'full': 'slg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'slh': {'full': 'slh-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'sli': {'full': 'sli-Latn-PL', 'region': 'PL', 'script': 'Latn', 'suppress': False},
        'slj': {'full': 'slj-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'sll': {'full': 'sll-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'slm': {'full': 'slm-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'sln': {'full': 'sln-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'slp': {'full': 'slp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'slq': {'full': 'slq-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'slr': {'full': 'slr-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'sls': {'full': 'sls-Zxxx-SG', 'region': 'SG', 'script': 'Zxxx', 'suppress': False},
        'slt': {'full': 'slt-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'slu': {'full': 'slu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'slw': {'full': 'slw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'slx': {'full': 'slx-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'sly': {'full': 'sly-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'slz': {'full': 'slz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sm': {'full': 'sm-Latn-WS', 'region': 'WS', 'script': 'Latn', 'suppress': True},
        'sma': {'full': 'sma-Latn-SE', 'region': 'SE', 'script': 'Latn', 'suppress': False},
        'smb': {'full': 'smb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'smc': {'full': 'smc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'smd': {'full': 'smd-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'smf': {'full': 'smf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'smg': {'full': 'smg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'smh': {'full': 'smh-Yiii-CN', 'region': 'CN', 'script': 'Yiii', 'suppress': False},
        'smj': {'full': 'smj-Latn-SE', 'region': 'SE', 'script': 'Latn', 'suppress': False},
        'smk': {'full': 'smk-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'sml': {'full': 'sml-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'smm': {'full': 'smm-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'smn': {'full': 'smn-Latn-FI', 'region': 'FI', 'script': 'Latn', 'suppress': False},
        'smp': {'full': 'smp-Samr-IL', 'region': 'IL', 'script': 'Samr', 'suppress': False},
        'smp-Arab': {'full': 'smp-Arab-PS', 'region': 'PS', 'script': 'Arab', 'suppress': False},
        'smp-Hebr': {'full': 'smp-Hebr-PS', 'region': 'PS', 'script': 'Hebr', 'suppress': False},
        'smq': {'full': 'smq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'smr': {'full': 'smr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sms': {'full': 'sms-Latn-FI', 'region': 'FI', 'script': 'Latn', 'suppress': False},
        'smt': {'full': 'smt-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'smu': {'full': 'smu-Zyyy-KH', 'region': 'KH', 'script': 'Zyyy', 'suppress': False},
        'smv': {'full': 'smv-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'smw': {'full': 'smw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'smx': {'full': 'smx-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'smy': {'full': 'smy-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'smz': {'full': 'smz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sn': {'full': 'sn-Latn-ZW', 'region': 'ZW', 'script': 'Latn', 'suppress': False},
        'sn-Brai': {'full': 'sn-Brai-ZW', 'region': 'ZW', 'script': 'Brai', 'suppress': False},
        'snb': {'full': 'snb-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'snc': {'full': 'snc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sne': {'full': 'sne-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'snf': {'full': 'snf-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'sng': {'full': 'sng-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'sng-Brai': {'full': 'sng-Brai-CD', 'region': 'CD', 'script': 'Brai', 'suppress': False},
        'snh': {'full': 'snh-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'sni': {'full': 'sni-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'snj': {'full': 'snj-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'snk': {'full': 'snk-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'snk-Arab': {'full': 'snk-Arab-ML', 'region': 'ML', 'script': 'Arab', 'suppress': False},
        'snl': {'full': 'snl-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'snm': {'full': 'snm-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'snn': {'full': 'snn-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'sno': {'full': 'sno-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'snp': {'full': 'snp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'snp-x-lambau': {'full': 'snp-Latn-PG-x-lambau', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'snq': {'full': 'snq-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'snr': {'full': 'snr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sns': {'full': 'sns-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'snu': {'full': 'snu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'snv': {'full': 'snv-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'snw': {'full': 'snw-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'snx': {'full': 'snx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sny': {'full': 'sny-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'snz': {'full': 'snz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'so': {'full': 'so-Latn-SO', 'region': 'SO', 'script': 'Latn', 'suppress': True},
        'so-Arab': {'full': 'so-Arab-SO', 'region': 'SO', 'script': 'Arab', 'suppress': False},
        'so-DJ': {'full': 'so-Latn-DJ', 'region': 'DJ', 'script': 'Latn', 'suppress': True},
        'so-ET': {'full': 'so-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': True},
        'so-KE': {'full': 'so-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': True},
        'so-Osma': {'full': 'so-Osma-SO', 'region': 'SO', 'script': 'Osma', 'suppress': False},
        'soa': {'full': 'soa-Tavt-TH', 'region': 'TH', 'script': 'Tavt', 'suppress': False},
        'soa-Thai': {'full': 'soa-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'sob': {'full': 'sob-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'soc': {'full': 'soc-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'sod': {'full': 'sod-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'soe': {'full': 'soe-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'sog-Mani': {'full': 'sog-Mani-XX', 'region': 'XX', 'script': 'Mani', 'suppress': False},
        'sog-Sogd': {'full': 'sog-Sogd-XX', 'region': 'XX', 'script': 'Sogd', 'suppress': False},
        'sog-Sogo': {'full': 'sog-Sogo-XX', 'region': 'XX', 'script': 'Sogo', 'suppress': False},
        'sog-Syrc': {'full': 'sog-Syrc-XX', 'region': 'XX', 'script': 'Syrc', 'suppress': False},
        'soh': {'full': 'soh-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'soi': {'full': 'soi-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'soj': {'full': 'soj-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'sok': {'full': 'sok-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'sol': {'full': 'sol-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'soo': {'full': 'soo-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'sop': {'full': 'sop-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'soq': {'full': 'soq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sor': {'full': 'sor-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'sos': {'full': 'sos-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'sou': {'full': 'sou-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'sov': {'full': 'sov-Latn-PW', 'region': 'PW', 'script': 'Latn', 'suppress': False},
        'sow': {'full': 'sow-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sox': {'full': 'sox-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'soy': {'full': 'soy-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'soz': {'full': 'soz-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'spb': {'full': 'spb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'spc': {'full': 'spc-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'spd': {'full': 'spd-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'spe': {'full': 'spe-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'spg': {'full': 'spg-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'spi': {'full': 'spi-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'spk': {'full': 'spk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'spl': {'full': 'spl-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'spm': {'full': 'spm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'spn': {'full': 'spn-Latn-PY', 'region': 'PY', 'script': 'Latn', 'suppress': False},
        'spo': {'full': 'spo-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'spp': {'full': 'spp-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'spq': {'full': 'spq-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'spr': {'full': 'spr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sps': {'full': 'sps-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'spt': {'full': 'spt-Tibt-IN', 'region': 'IN', 'script': 'Tibt', 'suppress': False},
        'spu': {'full': 'spu-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'spv': {'full': 'spv-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'spx': {'full': 'spx-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'sq': {'full': 'sq-Latn-AL', 'region': 'AL', 'script': 'Latn', 'suppress': True},
        'sq-Brai': {'full': 'sq-Brai-AL', 'region': 'AL', 'script': 'Brai', 'suppress': False},
        'sq-Elba': {'full': 'sq-Elba-AL', 'region': 'AL', 'script': 'Elba', 'suppress': False},
        'sq-Grek': {'full': 'sq-Grek-GR', 'region': 'GR', 'script': 'Grek', 'suppress': False},
        'sq-MK': {'full': 'sq-Latn-MK', 'region': 'MK', 'script': 'Latn', 'suppress': True},
        'sq-XK': {'full': 'sq-Latn-XK', 'region': 'XK', 'script': 'Latn', 'suppress': True},
        'sqa': {'full': 'sqa-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'sqh': {'full': 'sqh-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'sqk': {'full': 'sqk-Zxxx-AL', 'region': 'AL', 'script': 'Zxxx', 'suppress': False},
        'sqm': {'full': 'sqm-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'sqn': {'full': 'sqn-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'sqo': {'full': 'sqo-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'sqq': {'full': 'sqq-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'sqr': {'full': 'sqr-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'sqs': {'full': 'sqs-Zxxx-LK', 'region': 'LK', 'script': 'Zxxx', 'suppress': False},
        'sqt': {'full': 'sqt-Arab-YE', 'region': 'YE', 'script': 'Arab', 'suppress': False},
        'sqt-Latn': {'full': 'sqt-Latn-YE', 'region': 'YE', 'script': 'Latn', 'suppress': False},
        'squ': {'full': 'squ-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'sr': {'full': 'sr-Cyrl-RS', 'region': 'RS', 'script': 'Cyrl', 'suppress': False},
        'sr-BA': {'full': 'sr-Cyrl-BA', 'region': 'BA', 'script': 'Cyrl', 'suppress': False},
        'sr-Brai': {'full': 'sr-Brai-RS', 'region': 'RS', 'script': 'Brai', 'suppress': False},
        'sr-Cyrl-ME': {'full': 'sr-Cyrl-ME', 'region': 'ME', 'script': 'Cyrl', 'suppress': False},
        'sr-Latn': {'full': 'sr-Latn-RS', 'region': 'RS', 'script': 'Latn', 'suppress': False},
        'sr-Latn-BA': {'full': 'sr-Latn-BA', 'region': 'BA', 'script': 'Latn', 'suppress': False},
        'sr-Latn-XK': {'full': 'sr-Latn-XK', 'region': 'XK', 'script': 'Latn', 'suppress': False},
        'sr-ME': {'full': 'sr-Latn-ME', 'region': 'ME', 'script': 'Latn', 'suppress': False},
        'sr-RO': {'full': 'sr-Latn-RO', 'region': 'RO', 'script': 'Latn', 'suppress': False},
        'sr-RU': {'full': 'sr-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'sr-TR': {'full': 'sr-Latn-TR', 'region': 'TR', 'script': 'Latn', 'suppress': False},
        'sr-XK': {'full': 'sr-Cyrl-XK', 'region': 'XK', 'script': 'Cyrl', 'suppress': False},
        'sra': {'full': 'sra-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'srb': {'full': 'srb-Sora-IN', 'region': 'IN', 'script': 'Sora', 'suppress': False},
        'srb-Latn': {'full': 'srb-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'srb-Orya': {'full': 'srb-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'srb-Telu': {'full': 'srb-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'sre': {'full': 'sre-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'srf': {'full': 'srf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'srg': {'full': 'srg-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'srh': {'full': 'srh-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'sri': {'full': 'sri-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'srk': {'full': 'srk-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'srl': {'full': 'srl-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'srm': {'full': 'srm-Latn-SR', 'region': 'SR', 'script': 'Latn', 'suppress': False},
        'srn': {'full': 'srn-Latn-SR', 'region': 'SR', 'script': 'Latn', 'suppress': False},
        'sro': {'full': 'sro-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'srq': {'full': 'srq-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'srr': {'full': 'srr-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'srr-Arab': {'full': 'srr-Arab-SN', 'region': 'SN', 'script': 'Arab', 'suppress': False},
        'srs': {'full': 'srs-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'srt': {'full': 'srt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sru': {'full': 'sru-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'srv': {'full': 'srv-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'srw': {'full': 'srw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'srx': {'full': 'srx-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'srx-Takr': {'full': 'srx-Takr-IN', 'region': 'IN', 'script': 'Takr', 'suppress': False},
        'sry': {'full': 'sry-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'srz': {'full': 'srz-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'ss': {'full': 'ss-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': True},
        'ssb': {'full': 'ssb-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ssc': {'full': 'ssc-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'ssd': {'full': 'ssd-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sse': {'full': 'sse-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'sse-Arab': {'full': 'sse-Arab-PH', 'region': 'PH', 'script': 'Arab', 'suppress': False},
        'ssf': {'full': 'ssf-Latn-TW', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'ssg': {'full': 'ssg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ssh': {'full': 'ssh-Arab-AE', 'region': 'AE', 'script': 'Arab', 'suppress': False},
        'ssi': {'full': 'ssi-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'ssj': {'full': 'ssj-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ssk': {'full': 'ssk-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'ssl': {'full': 'ssl-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'ssm': {'full': 'ssm-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'ssn': {'full': 'ssn-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'sso': {'full': 'sso-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ssp': {'full': 'ssp-Zxxx-ES', 'region': 'ES', 'script': 'Zxxx', 'suppress': False},
        'ssq': {'full': 'ssq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ssr': {'full': 'ssr-Zxxx-CH', 'region': 'CH', 'script': 'Zxxx', 'suppress': False},
        'sss': {'full': 'sss-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'sss-Thai': {'full': 'sss-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'sst': {'full': 'sst-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ssu': {'full': 'ssu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ssv': {'full': 'ssv-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'ssx': {'full': 'ssx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ssy': {'full': 'ssy-Latn-ER', 'region': 'ER', 'script': 'Latn', 'suppress': False},
        'ssy-Ethi': {'full': 'ssy-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'ssz': {'full': 'ssz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'st': {'full': 'st-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': True},
        'st-LS': {'full': 'st-Latn-LS', 'region': 'LS', 'script': 'Latn', 'suppress': True},
        'sta': {'full': 'sta-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'stb': {'full': 'stb-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'std': {'full': 'std-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'ste': {'full': 'ste-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'stf': {'full': 'stf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'stg': {'full': 'stg-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'sth': {'full': 'sth-Latn-IE', 'region': 'IE', 'script': 'Latn', 'suppress': False},
        'sti': {'full': 'sti-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'sti-KH': {'full': 'sti-Latn-KH', 'region': 'KH', 'script': 'Latn', 'suppress': False},
        'stj': {'full': 'stj-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'stk': {'full': 'stk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'stl': {'full': 'stl-Latn-NL', 'region': 'NL', 'script': 'Latn', 'suppress': False},
        'stm': {'full': 'stm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'stn': {'full': 'stn-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'sto': {'full': 'sto-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'stp': {'full': 'stp-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'stq': {'full': 'stq-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': False},
        'str': {'full': 'str-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'sts': {'full': 'sts-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'stt': {'full': 'stt-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'stu': {'full': 'stu-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'stv': {'full': 'stv-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'stv-Arab': {'full': 'stv-Arab-ET', 'region': 'ET', 'script': 'Arab', 'suppress': False},
        'stw': {'full': 'stw-Latn-FM', 'region': 'FM', 'script': 'Latn', 'suppress': False},
        'sty': {'full': 'sty-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'su': {'full': 'su-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'su-Arab': {'full': 'su-Arab-ID', 'region': 'ID', 'script': 'Arab', 'suppress': False},
        'su-Java': {'full': 'su-Java-ID', 'region': 'ID', 'script': 'Java', 'suppress': False},
        'su-Sund': {'full': 'su-Sund-ID', 'region': 'ID', 'script': 'Sund', 'suppress': False},
        'sua': {'full': 'sua-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sub': {'full': 'sub-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'suc': {'full': 'suc-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'sue': {'full': 'sue-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sug': {'full': 'sug-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'sui': {'full': 'sui-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'suj': {'full': 'suj-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'suk': {'full': 'suk-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'suq': {'full': 'suq-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'suq-Ethi': {'full': 'suq-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'sur': {'full': 'sur-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'sus': {'full': 'sus-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'sus-Arab': {'full': 'sus-Arab-GN', 'region': 'GN', 'script': 'Arab', 'suppress': False},
        'sut': {'full': 'sut-Latn-NI', 'region': 'NI', 'script': 'Latn', 'suppress': False},
        'suv': {'full': 'suv-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'suv-Beng': {'full': 'suv-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'suv-Deva': {'full': 'suv-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'suw': {'full': 'suw-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'sux': {'full': 'sux-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'suy': {'full': 'suy-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'suz': {'full': 'suz-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'sv': {'full': 'sv-Latn-SE', 'region': 'SE', 'script': 'Latn', 'suppress': True},
        'sv-Brai': {'full': 'sv-Brai-SE', 'region': 'SE', 'script': 'Brai', 'suppress': False},
        'sv-FI': {'full': 'sv-Latn-FI', 'region': 'FI', 'script': 'Latn', 'suppress': True},
        'sva': {'full': 'sva-Geor-GE', 'region': 'GE', 'script': 'Geor', 'suppress': False},
        'sva-Cyrl': {'full': 'sva-Cyrl-GE', 'region': 'GE', 'script': 'Cyrl', 'suppress': False},
        'sva-Latn': {'full': 'sva-Latn-GE', 'region': 'GE', 'script': 'Latn', 'suppress': False},
        'svb': {'full': 'svb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'svc': {'full': 'svc-Latn-VC', 'region': 'VC', 'script': 'Latn', 'suppress': False},
        'sve': {'full': 'sve-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'svk': {'full': 'svk-Zxxx-SK', 'region': 'SK', 'script': 'Zxxx', 'suppress': False},
        'svm': {'full': 'svm-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'svs': {'full': 'svs-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'svx': {'full': 'svx-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'sw': {'full': 'sw-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': True},
        'sw-Arab': {'full': 'sw-Arab-TZ', 'region': 'TZ', 'script': 'Arab', 'suppress': False},
        'sw-CD': {'full': 'sw-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': True},
        'sw-KE': {'full': 'sw-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': True},
        'sw-UG': {'full': 'sw-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': True},
        'swb': {'full': 'swb-Arab-YT', 'region': 'YT', 'script': 'Arab', 'suppress': False},
        'swb-Latn': {'full': 'swb-Latn-YT', 'region': 'YT', 'script': 'Latn', 'suppress': False},
        'swc': {'full': 'swc-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'swc-Arab': {'full': 'swc-Arab-CD', 'region': 'CD', 'script': 'Arab', 'suppress': False},
        'swf': {'full': 'swf-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'swg': {'full': 'swg-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': False},
        'swh-Arab': {'full': 'swh-Arab-TZ', 'region': 'TZ', 'script': 'Arab', 'suppress': False},
        'swh-Brai': {'full': 'swh-Brai-TZ', 'region': 'TZ', 'script': 'Brai', 'suppress': False},
        'swi': {'full': 'swi-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'swj': {'full': 'swj-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'swk': {'full': 'swk-Latn-MW', 'region': 'MW', 'script': 'Latn', 'suppress': False},
        'swl': {'full': 'swl-Zxxx-SE', 'region': 'SE', 'script': 'Zxxx', 'suppress': False},
        'swm': {'full': 'swm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'swn': {'full': 'swn-Zyyy-LY', 'region': 'LY', 'script': 'Zyyy', 'suppress': False},
        'swo': {'full': 'swo-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'swp': {'full': 'swp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'swq': {'full': 'swq-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'swr': {'full': 'swr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sws': {'full': 'sws-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'swt': {'full': 'swt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'swu': {'full': 'swu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'swv': {'full': 'swv-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'sww': {'full': 'sww-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'swx': {'full': 'swx-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'swy': {'full': 'swy-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'sxb': {'full': 'sxb-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'sxc': {'full': 'sxc-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'sxe': {'full': 'sxe-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'sxg': {'full': 'sxg-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'sxk': {'full': 'sxk-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'sxl': {'full': 'sxl-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'sxm': {'full': 'sxm-Zyyy-KH', 'region': 'KH', 'script': 'Zyyy', 'suppress': False},
        'sxn': {'full': 'sxn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'sxo': {'full': 'sxo-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'sxr': {'full': 'sxr-Zyyy-TW', 'region': 'TW', 'script': 'Zyyy', 'suppress': False},
        'sxs': {'full': 'sxs-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'sxu': {'full': 'sxu-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': False},
        'sxw': {'full': 'sxw-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'sya': {'full': 'sya-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'syb': {'full': 'syb-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'syc': {'full': 'syc-Syrc-TR', 'region': 'TR', 'script': 'Syrc', 'suppress': False},
        'syi': {'full': 'syi-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'syk': {'full': 'syk-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'syl': {'full': 'syl-Beng-BD', 'region': 'BD', 'script': 'Beng', 'suppress': False},
        'syl-Latn': {'full': 'syl-Latn-BD', 'region': 'BD', 'script': 'Latn', 'suppress': False},
        'syl-Sylo': {'full': 'syl-Sylo-BD', 'region': 'BD', 'script': 'Sylo', 'suppress': False},
        'sym': {'full': 'sym-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'syn': {'full': 'syn-Syrc-IR', 'region': 'IR', 'script': 'Syrc', 'suppress': False},
        'syo': {'full': 'syo-Latn-KH', 'region': 'KH', 'script': 'Latn', 'suppress': False},
        'syr': {'full': 'syr-Syrc-IQ', 'region': 'IQ', 'script': 'Syrc', 'suppress': False},
        'sys': {'full': 'sys-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'syw': {'full': 'syw-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'syx': {'full': 'syx-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'syy': {'full': 'syy-Zxxx-IL', 'region': 'IL', 'script': 'Zxxx', 'suppress': False},
        'sza': {'full': 'sza-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'szb': {'full': 'szb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'szc': {'full': 'szc-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'szd': {'full': 'szd-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'sze': {'full': 'sze-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'szg': {'full': 'szg-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'szl': {'full': 'szl-Latn-PL', 'region': 'PL', 'script': 'Latn', 'suppress': False},
        'szn': {'full': 'szn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'szp': {'full': 'szp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'szs': {'full': 'szs-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'szs-Zxxx': {'full': 'szs-Zxxx-SB', 'region': 'SB', 'script': 'Zxxx', 'suppress': False},
        'szv': {'full': 'szv-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'szw': {'full': 'szw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'szy': {'full': 'szy-Latn-TW', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'ta': {'full': 'ta-Taml-IN', 'region': 'IN', 'script': 'Taml', 'suppress': True},
        'ta-Brai': {'full': 'ta-Brai-IN', 'region': 'IN', 'script': 'Brai', 'suppress': False},
        'ta-LK': {'full': 'ta-Taml-LK', 'region': 'LK', 'script': 'Taml', 'suppress': True},
        'ta-MY': {'full': 'ta-Taml-MY', 'region': 'MY', 'script': 'Taml', 'suppress': True},
        'ta-SG': {'full': 'ta-Taml-SG', 'region': 'SG', 'script': 'Taml', 'suppress': True},
        'taa': {'full': 'taa-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'tab': {'full': 'tab-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'tac': {'full': 'tac-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tad': {'full': 'tad-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tae': {'full': 'tae-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'taf': {'full': 'taf-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'tag': {'full': 'tag-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'taj': {'full': 'taj-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'taj-Tibt': {'full': 'taj-Tibt-BT', 'region': 'BT', 'script': 'Tibt', 'suppress': False},
        'taj-Tibt-x-tamhig': {'full': 'taj-Tibt-BT-x-tamhig', 'region': 'BT', 'script': 'Tibt', 'suppress': False},
        'tak': {'full': 'tak-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'tal': {'full': 'tal-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'tan': {'full': 'tan-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'tao': {'full': 'tao-Latn-TW', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'tap': {'full': 'tap-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'taq-Latn': {'full': 'taq-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'taq-Tfng': {'full': 'taq-Tfng-ML', 'region': 'ML', 'script': 'Tfng', 'suppress': False},
        'tar': {'full': 'tar-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tas': {'full': 'tas-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'tau': {'full': 'tau-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'tav': {'full': 'tav-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'taw': {'full': 'taw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tax': {'full': 'tax-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'tay': {'full': 'tay-Latn-TW', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'tay-Hans': {'full': 'tay-Hans-TW', 'region': 'TW', 'script': 'Hans', 'suppress': False},
        'tay-Hant': {'full': 'tay-Hant-TW', 'region': 'TW', 'script': 'Hant', 'suppress': False},
        'taz': {'full': 'taz-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'tba': {'full': 'tba-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'tbb': {'full': 'tbb-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'tbc': {'full': 'tbc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tbd': {'full': 'tbd-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tbe': {'full': 'tbe-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'tbf': {'full': 'tbf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tbg': {'full': 'tbg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tbh': {'full': 'tbh-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'tbi': {'full': 'tbi-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'tbj': {'full': 'tbj-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tbk': {'full': 'tbk-Tagb-PH', 'region': 'PH', 'script': 'Tagb', 'suppress': False},
        'tbk-Latn': {'full': 'tbk-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'tbl': {'full': 'tbl-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'tbm': {'full': 'tbm-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'tbn': {'full': 'tbn-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'tbo': {'full': 'tbo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tbp': {'full': 'tbp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tbr': {'full': 'tbr-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'tbs': {'full': 'tbs-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tbt': {'full': 'tbt-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'tbu': {'full': 'tbu-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tbv': {'full': 'tbv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tbw': {'full': 'tbw-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'tbw-Tagb': {'full': 'tbw-Tagb-PH', 'region': 'PH', 'script': 'Tagb', 'suppress': False},
        'tbx': {'full': 'tbx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tby': {'full': 'tby-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tbz': {'full': 'tbz-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'tca': {'full': 'tca-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'tcb': {'full': 'tcb-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'tcc': {'full': 'tcc-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'tcd': {'full': 'tcd-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'tce': {'full': 'tce-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'tcf': {'full': 'tcf-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tcg': {'full': 'tcg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tch': {'full': 'tch-Latn-TC', 'region': 'TC', 'script': 'Latn', 'suppress': False},
        'tci': {'full': 'tci-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tck': {'full': 'tck-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'tcl': {'full': 'tcl-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'tcm': {'full': 'tcm-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tcn': {'full': 'tcn-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'tco': {'full': 'tco-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'tcp': {'full': 'tcp-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'tcq': {'full': 'tcq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tcs': {'full': 'tcs-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'tct': {'full': 'tct-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'tcu': {'full': 'tcu-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tcw': {'full': 'tcw-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tcx': {'full': 'tcx-Taml-IN', 'region': 'IN', 'script': 'Taml', 'suppress': False},
        'tcy': {'full': 'tcy-Knda-IN', 'region': 'IN', 'script': 'Knda', 'suppress': False},
        'tcy-Zzzz-x-tulu': {'full': 'tcy-Zzzz-IN-x-tulu', 'region': 'IN', 'script': 'Zzzz', 'suppress': False},
        'tcz': {'full': 'tcz-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'tda-Arab': {'full': 'tda-Arab-NE', 'region': 'NE', 'script': 'Arab', 'suppress': False},
        'tda-Latn': {'full': 'tda-Latn-NE', 'region': 'NE', 'script': 'Latn', 'suppress': False},
        'tda-Tfng': {'full': 'tda-Tfng-NE', 'region': 'NE', 'script': 'Tfng', 'suppress': False},
        'tdb': {'full': 'tdb-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'tdb-Beng': {'full': 'tdb-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'tdb-Kthi': {'full': 'tdb-Kthi-IN', 'region': 'IN', 'script': 'Kthi', 'suppress': False},
        'tdc': {'full': 'tdc-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'tdd': {'full': 'tdd-Tale-CN', 'region': 'CN', 'script': 'Tale', 'suppress': False},
        'tdd-MM': {'full': 'tdd-Tale-MM', 'region': 'MM', 'script': 'Tale', 'suppress': False},
        'tde': {'full': 'tde-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'tdf': {'full': 'tdf-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'tdg': {'full': 'tdg-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'tdg-Tibt': {'full': 'tdg-Tibt-NP', 'region': 'NP', 'script': 'Tibt', 'suppress': False},
        'tdh': {'full': 'tdh-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'tdi': {'full': 'tdi-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tdj': {'full': 'tdj-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tdk': {'full': 'tdk-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'tdl': {'full': 'tdl-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'tdm': {'full': 'tdm-Latn-GY', 'region': 'GY', 'script': 'Latn', 'suppress': False},
        'tdn': {'full': 'tdn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tdo': {'full': 'tdo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'tdq': {'full': 'tdq-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'tdr': {'full': 'tdr-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'tds': {'full': 'tds-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tdt': {'full': 'tdt-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'tdv': {'full': 'tdv-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'tdx': {'full': 'tdx-Latn-MG', 'region': 'MG', 'script': 'Latn', 'suppress': False},
        'tdy': {'full': 'tdy-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'te': {'full': 'te-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': True},
        'te-Brai': {'full': 'te-Brai-IN', 'region': 'IN', 'script': 'Brai', 'suppress': False},
        'tea': {'full': 'tea-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'teb': {'full': 'teb-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'tec': {'full': 'tec-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'ted': {'full': 'ted-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'tee': {'full': 'tee-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tef': {'full': 'tef-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'teg': {'full': 'teg-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'teh': {'full': 'teh-Latn-AR', 'region': 'AR', 'script': 'Latn', 'suppress': False},
        'tei': {'full': 'tei-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tek': {'full': 'tek-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'tem': {'full': 'tem-Latn-SL', 'region': 'SL', 'script': 'Latn', 'suppress': True},
        'ten': {'full': 'ten-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'teo': {'full': 'teo-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'teo-KE': {'full': 'teo-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'tep': {'full': 'tep-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'teq': {'full': 'teq-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'ter': {'full': 'ter-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'tes': {'full': 'tes-Java-ID', 'region': 'ID', 'script': 'Java', 'suppress': False},
        'tet': {'full': 'tet-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'teu': {'full': 'teu-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'tev': {'full': 'tev-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tew': {'full': 'tew-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'tew-x-sanclara': {'full': 'tew-Latn-US-x-sanclara', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'tew-x-sanjuan': {'full': 'tew-Latn-US-x-sanjuan', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'tex': {'full': 'tex-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'tey': {'full': 'tey-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'tez-Latn': {'full': 'tez-Latn-NE', 'region': 'NE', 'script': 'Latn', 'suppress': False},
        'tez-Tfng': {'full': 'tez-Tfng-NE', 'region': 'NE', 'script': 'Tfng', 'suppress': False},
        'tfi': {'full': 'tfi-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'tfn': {'full': 'tfn-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'tfo': {'full': 'tfo-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tfr': {'full': 'tfr-Latn-PA', 'region': 'PA', 'script': 'Latn', 'suppress': False},
        'tft': {'full': 'tft-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tg': {'full': 'tg-Cyrl-TJ', 'region': 'TJ', 'script': 'Cyrl', 'suppress': False},
        'tg-Arab': {'full': 'tg-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'tg-Hebr': {'full': 'tg-Hebr-UZ', 'region': 'UZ', 'script': 'Hebr', 'suppress': False},
        'tg-Latn': {'full': 'tg-Latn-TJ', 'region': 'TJ', 'script': 'Latn', 'suppress': False},
        'tga': {'full': 'tga-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'tgb': {'full': 'tgb-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'tgc': {'full': 'tgc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tgd': {'full': 'tgd-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'tge': {'full': 'tge-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'tgf': {'full': 'tgf-Zyyy-BT', 'region': 'BT', 'script': 'Zyyy', 'suppress': False},
        'tgh': {'full': 'tgh-Latn-TT', 'region': 'TT', 'script': 'Latn', 'suppress': False},
        'tgi': {'full': 'tgi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tgj': {'full': 'tgj-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'tgn': {'full': 'tgn-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'tgo': {'full': 'tgo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tgp': {'full': 'tgp-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'tgq': {'full': 'tgq-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'tgr': {'full': 'tgr-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'tgs': {'full': 'tgs-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'tgt': {'full': 'tgt-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'tgu': {'full': 'tgu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tgv': {'full': 'tgv-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'tgw': {'full': 'tgw-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'tgx': {'full': 'tgx-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'tgy': {'full': 'tgy-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'tgz': {'full': 'tgz-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'th': {'full': 'th-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': True},
        'th-Brai': {'full': 'th-Brai-TH', 'region': 'TH', 'script': 'Brai', 'suppress': False},
        'thd': {'full': 'thd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'the': {'full': 'the-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'thf': {'full': 'thf-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'thh': {'full': 'thh-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'thi': {'full': 'thi-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'thk': {'full': 'thk-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'thl': {'full': 'thl-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'thm': {'full': 'thm-Zyyy-TH', 'region': 'TH', 'script': 'Zyyy', 'suppress': False},
        'thn': {'full': 'thn-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'thp': {'full': 'thp-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'thp-Dupl': {'full': 'thp-Dupl-CA', 'region': 'CA', 'script': 'Dupl', 'suppress': False},
        'thq': {'full': 'thq-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'thr': {'full': 'thr-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'ths': {'full': 'ths-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'tht': {'full': 'tht-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'thu': {'full': 'thu-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'thv-Arab': {'full': 'thv-Arab-DZ', 'region': 'DZ', 'script': 'Arab', 'suppress': False},
        'thv-Latn': {'full': 'thv-Latn-DZ', 'region': 'DZ', 'script': 'Latn', 'suppress': False},
        'thv-Latn-DZ-x-ahaggar': {'full': 'thv-Latn-DZ-x-ahaggar', 'region': 'DZ', 'script': 'Latn', 'suppress': False},
        'thv-Tfng': {'full': 'thv-Tfng-DZ', 'region': 'DZ', 'script': 'Tfng', 'suppress': False},
        'thw': {'full': 'thw-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'thy': {'full': 'thy-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'thz-Latn': {'full': 'thz-Latn-NE', 'region': 'NE', 'script': 'Latn', 'suppress': False},
        'thz-Tfng': {'full': 'thz-Tfng-NE', 'region': 'NE', 'script': 'Tfng', 'suppress': False},
        'ti': {'full': 'ti-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': True},
        'ti-Arab': {'full': 'ti-Arab-ET', 'region': 'ET', 'script': 'Arab', 'suppress': False},
        'ti-ER': {'full': 'ti-Ethi-ER', 'region': 'ER', 'script': 'Ethi', 'suppress': True},
        'tia': {'full': 'tia-Zyyy-DZ', 'region': 'DZ', 'script': 'Zyyy', 'suppress': False},
        'tic': {'full': 'tic-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'tif': {'full': 'tif-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tig': {'full': 'tig-Ethi-ER', 'region': 'ER', 'script': 'Ethi', 'suppress': False},
        'tig-SD': {'full': 'tig-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'tih': {'full': 'tih-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'tii': {'full': 'tii-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'tij': {'full': 'tij-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'tik': {'full': 'tik-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'til': {'full': 'til-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'tim': {'full': 'tim-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tin': {'full': 'tin-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'tio': {'full': 'tio-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tip': {'full': 'tip-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tiq': {'full': 'tiq-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'tis': {'full': 'tis-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'tit': {'full': 'tit-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'tiu': {'full': 'tiu-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'tiv': {'full': 'tiv-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'tiw': {'full': 'tiw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'tix': {'full': 'tix-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'tiy': {'full': 'tiy-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'tiz': {'full': 'tiz-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'tja': {'full': 'tja-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'tjg': {'full': 'tjg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tji': {'full': 'tji-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'tjj': {'full': 'tjj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'tjl': {'full': 'tjl-Mymr-MM', 'region': 'MM', 'script': 'Mymr', 'suppress': False},
        'tjm': {'full': 'tjm-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'tjn': {'full': 'tjn-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'tjo': {'full': 'tjo-Zyyy-DZ', 'region': 'DZ', 'script': 'Zyyy', 'suppress': False},
        'tjp': {'full': 'tjp-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'tjs': {'full': 'tjs-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'tju': {'full': 'tju-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'tjw': {'full': 'tjw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'tk': {'full': 'tk-Latn-TM', 'region': 'TM', 'script': 'Latn', 'suppress': False},
        'tk-Arab': {'full': 'tk-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'tk-Arab-IR': {'full': 'tk-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'tk-Cyrl': {'full': 'tk-Cyrl-TM', 'region': 'TM', 'script': 'Cyrl', 'suppress': False},
        'tka': {'full': 'tka-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'tkb': {'full': 'tkb-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'tkd': {'full': 'tkd-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'tke': {'full': 'tke-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'tkf': {'full': 'tkf-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'tkg': {'full': 'tkg-Latn-MG', 'region': 'MG', 'script': 'Latn', 'suppress': False},
        'tkl': {'full': 'tkl-Latn-TK', 'region': 'TK', 'script': 'Latn', 'suppress': True},
        'tkm': {'full': 'tkm-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'tkn': {'full': 'tkn-Zyyy-JP', 'region': 'JP', 'script': 'Zyyy', 'suppress': False},
        'tkp': {'full': 'tkp-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'tkq': {'full': 'tkq-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'tkr': {'full': 'tkr-Latn-AZ', 'region': 'AZ', 'script': 'Latn', 'suppress': False},
        'tkr-Cyrl': {'full': 'tkr-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'tks': {'full': 'tks-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'tkt': {'full': 'tkt-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'tku': {'full': 'tku-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tkv': {'full': 'tkv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tkw': {'full': 'tkw-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'tkx': {'full': 'tkx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tkz': {'full': 'tkz-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'tl': {'full': 'tl-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': True},
        'tl-Brai': {'full': 'tl-Brai-PH', 'region': 'PH', 'script': 'Brai', 'suppress': False},
        'tl-Tglg': {'full': 'tl-Tglg-PH', 'region': 'PH', 'script': 'Tglg', 'suppress': False},
        'tla': {'full': 'tla-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tlb': {'full': 'tlb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tlc': {'full': 'tlc-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tld': {'full': 'tld-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tlf': {'full': 'tlf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tlg': {'full': 'tlg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tlh': {'full': 'tlh-Piqd-001', 'region': '001', 'script': 'Piqd', 'suppress': False},
        'tlh-Latn': {'full': 'tlh-Latn-001', 'region': '001', 'script': 'Latn', 'suppress': False},
        'tli': {'full': 'tli-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'tli-Cyrl': {'full': 'tli-Cyrl-US', 'region': 'US', 'script': 'Cyrl', 'suppress': False},
        'tlj': {'full': 'tlj-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'tlj-GH': {'full': 'tlj-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'tlk': {'full': 'tlk-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tll': {'full': 'tll-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'tlm': {'full': 'tlm-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'tln': {'full': 'tln-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tlo': {'full': 'tlo-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'tlp': {'full': 'tlp-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tlq': {'full': 'tlq-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'tlr': {'full': 'tlr-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'tls': {'full': 'tls-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'tlt': {'full': 'tlt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tlu': {'full': 'tlu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tlv': {'full': 'tlv-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tlx': {'full': 'tlx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tly': {'full': 'tly-Latn-AZ', 'region': 'AZ', 'script': 'Latn', 'suppress': False},
        'tly-Arab': {'full': 'tly-Arab-AZ', 'region': 'AZ', 'script': 'Arab', 'suppress': False},
        'tly-Cyrl': {'full': 'tly-Cyrl-AZ', 'region': 'AZ', 'script': 'Cyrl', 'suppress': False},
        'tma': {'full': 'tma-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'tmb': {'full': 'tmb-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'tmc': {'full': 'tmc-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'tmd': {'full': 'tmd-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tme': {'full': 'tme-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'tmf': {'full': 'tmf-Latn-PY', 'region': 'PY', 'script': 'Latn', 'suppress': False},
        'tmg': {'full': 'tmg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tmh': {'full': 'tmh-Latn-NE', 'region': 'NE', 'script': 'Latn', 'suppress': True},
        'tmh-Arab': {'full': 'tmh-Arab-NE', 'region': 'NE', 'script': 'Arab', 'suppress': False},
        'tmh-Tfng': {'full': 'tmh-Tfng-NE', 'region': 'NE', 'script': 'Tfng', 'suppress': False},
        'tmi': {'full': 'tmi-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'tmj': {'full': 'tmj-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tmk': {'full': 'tmk-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'tml': {'full': 'tml-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tmm': {'full': 'tmm-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'tmn': {'full': 'tmn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tmo': {'full': 'tmo-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'tmq': {'full': 'tmq-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tmr': {'full': 'tmr-Syrc-IL', 'region': 'IL', 'script': 'Syrc', 'suppress': False},
        'tms': {'full': 'tms-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'tmt': {'full': 'tmt-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'tmu': {'full': 'tmu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tmv': {'full': 'tmv-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'tmw': {'full': 'tmw-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'tmy': {'full': 'tmy-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tmz': {'full': 'tmz-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'tn': {'full': 'tn-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': True},
        'tn-BW': {'full': 'tn-Latn-BW', 'region': 'BW', 'script': 'Latn', 'suppress': True},
        'tna': {'full': 'tna-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'tnb': {'full': 'tnb-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'tnc': {'full': 'tnc-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'tnd': {'full': 'tnd-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'tng': {'full': 'tng-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'tnh': {'full': 'tnh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tni': {'full': 'tni-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tnk': {'full': 'tnk-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'tnl': {'full': 'tnl-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'tnm': {'full': 'tnm-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tnn': {'full': 'tnn-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'tno': {'full': 'tno-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'tnp': {'full': 'tnp-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'tnq': {'full': 'tnq-Latn-PR', 'region': 'PR', 'script': 'Latn', 'suppress': False},
        'tnr': {'full': 'tnr-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'tns': {'full': 'tns-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tnt': {'full': 'tnt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tnu': {'full': 'tnu-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'tnv': {'full': 'tnv-Cakm-BD', 'region': 'BD', 'script': 'Cakm', 'suppress': False},
        'tnw': {'full': 'tnw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tnx': {'full': 'tnx-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'tny': {'full': 'tny-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'tnz': {'full': 'tnz-Zyyy-TH', 'region': 'TH', 'script': 'Zyyy', 'suppress': False},
        'to': {'full': 'to-Latn-TO', 'region': 'TO', 'script': 'Latn', 'suppress': True},
        'tob': {'full': 'tob-Latn-AR', 'region': 'AR', 'script': 'Latn', 'suppress': False},
        'toc': {'full': 'toc-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tod': {'full': 'tod-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'tof': {'full': 'tof-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tog': {'full': 'tog-Latn-MW', 'region': 'MW', 'script': 'Latn', 'suppress': False},
        'toh': {'full': 'toh-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'toi': {'full': 'toi-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'toj': {'full': 'toj-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tol': {'full': 'tol-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'tom': {'full': 'tom-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'too': {'full': 'too-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'top': {'full': 'top-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'toq': {'full': 'toq-Latn-SS', 'region': 'SS', 'script': 'Latn', 'suppress': False},
        'tor': {'full': 'tor-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'tos': {'full': 'tos-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tou': {'full': 'tou-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'tov': {'full': 'tov-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'tow': {'full': 'tow-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'tox': {'full': 'tox-Latn-PW', 'region': 'PW', 'script': 'Latn', 'suppress': False},
        'toy': {'full': 'toy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'toz': {'full': 'toz-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'tpa': {'full': 'tpa-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tpc': {'full': 'tpc-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tpe-Beng': {'full': 'tpe-Beng-BD', 'region': 'BD', 'script': 'Beng', 'suppress': False},
        'tpe-Latn': {'full': 'tpe-Latn-BD', 'region': 'BD', 'script': 'Latn', 'suppress': False},
        'tpf': {'full': 'tpf-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tpg': {'full': 'tpg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tpi': {'full': 'tpi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': True},
        'tpj': {'full': 'tpj-Latn-PY', 'region': 'PY', 'script': 'Latn', 'suppress': False},
        'tpk': {'full': 'tpk-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'tpl': {'full': 'tpl-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tpm': {'full': 'tpm-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'tpn': {'full': 'tpn-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'tpo': {'full': 'tpo-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'tpp': {'full': 'tpp-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tpq': {'full': 'tpq-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'tpr': {'full': 'tpr-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'tpt': {'full': 'tpt-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tpu': {'full': 'tpu-Khmr-KH', 'region': 'KH', 'script': 'Khmr', 'suppress': False},
        'tpv': {'full': 'tpv-Latn-MP', 'region': 'MP', 'script': 'Latn', 'suppress': False},
        'tpw': {'full': 'tpw-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'tpx': {'full': 'tpx-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tpy': {'full': 'tpy-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'tpz': {'full': 'tpz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tqb': {'full': 'tqb-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'tql': {'full': 'tql-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'tqm': {'full': 'tqm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tqn': {'full': 'tqn-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'tqo': {'full': 'tqo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tqp': {'full': 'tqp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tqq': {'full': 'tqq-Zyyy-SO', 'region': 'SO', 'script': 'Zyyy', 'suppress': False},
        'tqr': {'full': 'tqr-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'tqt': {'full': 'tqt-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tqu': {'full': 'tqu-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'tqw': {'full': 'tqw-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'tr': {'full': 'tr-Latn-TR', 'region': 'TR', 'script': 'Latn', 'suppress': True},
        'tr-Arab': {'full': 'tr-Arab-TR', 'region': 'TR', 'script': 'Arab', 'suppress': False},
        'tr-Brai': {'full': 'tr-Brai-TR', 'region': 'TR', 'script': 'Brai', 'suppress': False},
        'tr-CY': {'full': 'tr-Latn-CY', 'region': 'CY', 'script': 'Latn', 'suppress': True},
        'tr-Cyrl': {'full': 'tr-Cyrl-BG', 'region': 'BG', 'script': 'Cyrl', 'suppress': False},
        'tr-Grek': {'full': 'tr-Grek-TR', 'region': 'TR', 'script': 'Grek', 'suppress': False},
        'tra': {'full': 'tra-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'trb': {'full': 'trb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'trc': {'full': 'trc-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'trd': {'full': 'trd-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'tre': {'full': 'tre-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'trf': {'full': 'trf-Latn-TT', 'region': 'TT', 'script': 'Latn', 'suppress': False},
        'trg': {'full': 'trg-Hebr-IL', 'region': 'IL', 'script': 'Hebr', 'suppress': False},
        'trh': {'full': 'trh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tri': {'full': 'tri-Latn-SR', 'region': 'SR', 'script': 'Latn', 'suppress': False},
        'trj': {'full': 'trj-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'trl': {'full': 'trl-Zyyy-GB', 'region': 'GB', 'script': 'Zyyy', 'suppress': False},
        'trm': {'full': 'trm-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'trn': {'full': 'trn-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'tro': {'full': 'tro-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'trp-Beng': {'full': 'trp-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'trp-Latn': {'full': 'trp-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'trq': {'full': 'trq-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'trr': {'full': 'trr-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'trs': {'full': 'trs-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'trt': {'full': 'trt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tru': {'full': 'tru-Latn-TR', 'region': 'TR', 'script': 'Latn', 'suppress': False},
        'tru-Syrc': {'full': 'tru-Syrc-TR', 'region': 'TR', 'script': 'Syrc', 'suppress': False},
        'trv': {'full': 'trv-Latn-TW', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'trw': {'full': 'trw-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'trx': {'full': 'trx-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'try': {'full': 'try-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'trz': {'full': 'trz-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'ts': {'full': 'ts-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': True},
        'ts-Brai': {'full': 'ts-Brai-ZA', 'region': 'ZA', 'script': 'Brai', 'suppress': False},
        'tsa': {'full': 'tsa-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'tsb': {'full': 'tsb-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'tsc': {'full': 'tsc-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'tsd': {'full': 'tsd-Grek-GR', 'region': 'GR', 'script': 'Grek', 'suppress': False},
        'tse': {'full': 'tse-Zxxx-TN', 'region': 'TN', 'script': 'Zxxx', 'suppress': False},
        'tsg': {'full': 'tsg-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'tsg-Arab': {'full': 'tsg-Arab-PH', 'region': 'PH', 'script': 'Arab', 'suppress': False},
        'tsh': {'full': 'tsh-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'tsi': {'full': 'tsi-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'tsj': {'full': 'tsj-Tibt-BT', 'region': 'BT', 'script': 'Tibt', 'suppress': False},
        'tsk': {'full': 'tsk-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'tsl': {'full': 'tsl-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'tsm': {'full': 'tsm-Zxxx-TR', 'region': 'TR', 'script': 'Zxxx', 'suppress': False},
        'tsp': {'full': 'tsp-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'tsq': {'full': 'tsq-Zxxx-TH', 'region': 'TH', 'script': 'Zxxx', 'suppress': False},
        'tsr': {'full': 'tsr-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'tss': {'full': 'tss-Zxxx-TW', 'region': 'TW', 'script': 'Zxxx', 'suppress': False},
        'tst': {'full': 'tst-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'tsu': {'full': 'tsu-Latn-TW', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'tsv': {'full': 'tsv-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'tsw': {'full': 'tsw-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'tsx': {'full': 'tsx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tsy': {'full': 'tsy-Zxxx-ML', 'region': 'ML', 'script': 'Zxxx', 'suppress': False},
        'tsz': {'full': 'tsz-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tt': {'full': 'tt-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'tt-Latn': {'full': 'tt-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'tta': {'full': 'tta-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'ttb': {'full': 'ttb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ttc': {'full': 'ttc-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'ttd': {'full': 'ttd-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tte': {'full': 'tte-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ttf': {'full': 'ttf-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'ttg': {'full': 'ttg-Zyyy-BN', 'region': 'BN', 'script': 'Zyyy', 'suppress': False},
        'tth': {'full': 'tth-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'tti': {'full': 'tti-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ttj': {'full': 'ttj-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'ttk': {'full': 'ttk-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'ttl': {'full': 'ttl-Latn-ZM', 'region': 'ZM', 'script': 'Latn', 'suppress': False},
        'ttm': {'full': 'ttm-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'ttn': {'full': 'ttn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tto': {'full': 'tto-Laoo-LA', 'region': 'LA', 'script': 'Laoo', 'suppress': False},
        'ttp': {'full': 'ttp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ttr': {'full': 'ttr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'tts': {'full': 'tts-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'ttt': {'full': 'ttt-Latn-AZ', 'region': 'AZ', 'script': 'Latn', 'suppress': False},
        'ttt-Arab': {'full': 'ttt-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'ttt-Cyrl': {'full': 'ttt-Cyrl-AZ', 'region': 'AZ', 'script': 'Cyrl', 'suppress': False},
        'ttu': {'full': 'ttu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ttv': {'full': 'ttv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ttw': {'full': 'ttw-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'tty': {'full': 'tty-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ttz': {'full': 'ttz-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'tua': {'full': 'tua-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tub': {'full': 'tub-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'tuc': {'full': 'tuc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tuc-x-oov': {'full': 'tuc-Latn-PG-x-oov', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tuc-x-tuam': {'full': 'tuc-Latn-PG-x-tuam', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tud': {'full': 'tud-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'tue': {'full': 'tue-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'tuf': {'full': 'tuf-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'tug': {'full': 'tug-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'tuh': {'full': 'tuh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tui': {'full': 'tui-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'tuj': {'full': 'tuj-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tul': {'full': 'tul-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'tum': {'full': 'tum-Latn-MW', 'region': 'MW', 'script': 'Latn', 'suppress': False},
        'tun': {'full': 'tun-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'tuo': {'full': 'tuo-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'tuq': {'full': 'tuq-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'tus': {'full': 'tus-Latn-CA', 'region': 'CA', 'script': 'Latn', 'suppress': False},
        'tuu': {'full': 'tuu-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'tuv': {'full': 'tuv-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'tux': {'full': 'tux-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'tuy': {'full': 'tuy-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'tuz': {'full': 'tuz-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'tva': {'full': 'tva-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'tvd': {'full': 'tvd-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'tve': {'full': 'tve-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tvk': {'full': 'tvk-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'tvl': {'full': 'tvl-Latn-TV', 'region': 'TV', 'script': 'Latn', 'suppress': True},
        'tvm': {'full': 'tvm-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tvn': {'full': 'tvn-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'tvo': {'full': 'tvo-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tvs': {'full': 'tvs-Latn-KE', 'region': 'KE', 'script': 'Latn', 'suppress': False},
        'tvt': {'full': 'tvt-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'tvu': {'full': 'tvu-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'tvw': {'full': 'tvw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tvx': {'full': 'tvx-Latn-TW', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'tvy': {'full': 'tvy-Zyyy-TL', 'region': 'TL', 'script': 'Zyyy', 'suppress': False},
        'twa': {'full': 'twa-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'twb': {'full': 'twb-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'twc': {'full': 'twc-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'twd': {'full': 'twd-Latn-NL', 'region': 'NL', 'script': 'Latn', 'suppress': False},
        'twe': {'full': 'twe-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'twf': {'full': 'twf-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'twg': {'full': 'twg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'twh': {'full': 'twh-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'twh-Tavt': {'full': 'twh-Tavt-VN', 'region': 'VN', 'script': 'Tavt', 'suppress': False},
        'twl': {'full': 'twl-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'twm': {'full': 'twm-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'twn': {'full': 'twn-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'two': {'full': 'two-Latn-BW', 'region': 'BW', 'script': 'Latn', 'suppress': False},
        'twp': {'full': 'twp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'twq': {'full': 'twq-Latn-NE', 'region': 'NE', 'script': 'Latn', 'suppress': False},
        'twr': {'full': 'twr-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'twt': {'full': 'twt-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'twu': {'full': 'twu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tww': {'full': 'tww-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'twx': {'full': 'twx-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'twy': {'full': 'twy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'txa': {'full': 'txa-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'txb': {'full': 'txb-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'txc': {'full': 'txc-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'txe': {'full': 'txe-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'txg-Tang': {'full': 'txg-Tang-CN', 'region': 'CN', 'script': 'Tang', 'suppress': False},
        'txh': {'full': 'txh-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'txi': {'full': 'txi-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'txj': {'full': 'txj-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'txm': {'full': 'txm-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'txn': {'full': 'txn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'txo-Beng': {'full': 'txo-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'txo-Deva': {'full': 'txo-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'txo-Toto': {'full': 'txo-Toto-IN', 'region': 'IN', 'script': 'Toto', 'suppress': False},
        'txq': {'full': 'txq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'txr': {'full': 'txr-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'txs': {'full': 'txs-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'txt': {'full': 'txt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'txu': {'full': 'txu-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'txx': {'full': 'txx-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'txy': {'full': 'txy-Latn-MG', 'region': 'MG', 'script': 'Latn', 'suppress': False},
        'ty': {'full': 'ty-Latn-PF', 'region': 'PF', 'script': 'Latn', 'suppress': False},
        'tya': {'full': 'tya-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'tye': {'full': 'tye-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'tyh': {'full': 'tyh-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'tyi': {'full': 'tyi-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'tyj': {'full': 'tyj-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'tyj-Zzzz-x-taiyo': {'full': 'tyj-Zzzz-VN-x-taiyo', 'region': 'VN', 'script': 'Zzzz', 'suppress': False},
        'tyl': {'full': 'tyl-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'tyn': {'full': 'tyn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'typ': {'full': 'typ-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'tyr': {'full': 'tyr-Tavt-VN', 'region': 'VN', 'script': 'Tavt', 'suppress': False},
        'tys': {'full': 'tys-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'tyt-Latn': {'full': 'tyt-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'tyt-Tavt': {'full': 'tyt-Tavt-VN', 'region': 'VN', 'script': 'Tavt', 'suppress': False},
        'tyu': {'full': 'tyu-Latn-BW', 'region': 'BW', 'script': 'Latn', 'suppress': False},
        'tyv': {'full': 'tyv-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'tyx': {'full': 'tyx-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'tyz': {'full': 'tyz-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'tza': {'full': 'tza-Zxxx-TZ', 'region': 'TZ', 'script': 'Zxxx', 'suppress': False},
        'tzh': {'full': 'tzh-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tzj': {'full': 'tzj-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'tzj-x-western': {'full': 'tzj-Latn-GT-x-western', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'tzl': {'full': 'tzl-Zyyy-001', 'region': '001', 'script': 'Zyyy', 'suppress': False},
        'tzm': {'full': 'tzm-Latn-MA', 'region': 'MA', 'script': 'Latn', 'suppress': False},
        'tzm-Arab': {'full': 'tzm-Arab-MA', 'region': 'MA', 'script': 'Arab', 'suppress': False},
        'tzm-Tfng': {'full': 'tzm-Tfng-MA', 'region': 'MA', 'script': 'Tfng', 'suppress': False},
        'tzn': {'full': 'tzn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'tzo': {'full': 'tzo-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tzo-x-huixtan': {'full': 'tzo-Latn-MX-x-huixtan', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tzo-x-sanandre': {'full': 'tzo-Latn-MX-x-sanandre', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tzo-x-zinacntn': {'full': 'tzo-Latn-MX-x-zinacntn', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'tzx': {'full': 'tzx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'uam': {'full': 'uam-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'uan': {'full': 'uan-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'uar': {'full': 'uar-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'uba': {'full': 'uba-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ubi': {'full': 'ubi-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'ubl': {'full': 'ubl-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'ubr': {'full': 'ubr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ubu': {'full': 'ubu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ubu-x-kala': {'full': 'ubu-Latn-PG-x-kala', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ubu-x-nopenge': {'full': 'ubu-Latn-PG-x-nopenge', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'uby': {'full': 'uby-Zyyy-TR', 'region': 'TR', 'script': 'Zyyy', 'suppress': False},
        'uda': {'full': 'uda-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ude': {'full': 'ude-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'udg': {'full': 'udg-Mlym-IN', 'region': 'IN', 'script': 'Mlym', 'suppress': False},
        'udi': {'full': 'udi-Cyrl-AZ', 'region': 'AZ', 'script': 'Cyrl', 'suppress': False},
        'udj': {'full': 'udj-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'udl': {'full': 'udl-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'udm': {'full': 'udm-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'udm-Latn': {'full': 'udm-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'udu': {'full': 'udu-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'ues': {'full': 'ues-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ufi': {'full': 'ufi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ug': {'full': 'ug-Arab-CN', 'region': 'CN', 'script': 'Arab', 'suppress': False},
        'ug-KZ': {'full': 'ug-Cyrl-KZ', 'region': 'KZ', 'script': 'Cyrl', 'suppress': False},
        'ug-Latn': {'full': 'ug-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'ug-MN': {'full': 'ug-Cyrl-MN', 'region': 'MN', 'script': 'Cyrl', 'suppress': False},
        'uga': {'full': 'uga-Ugar-SY', 'region': 'SY', 'script': 'Ugar', 'suppress': False},
        'ugb': {'full': 'ugb-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'uge': {'full': 'uge-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'ugn': {'full': 'ugn-Zxxx-UG', 'region': 'UG', 'script': 'Zxxx', 'suppress': False},
        'ugo': {'full': 'ugo-Zyyy-TH', 'region': 'TH', 'script': 'Zyyy', 'suppress': False},
        'ugy': {'full': 'ugy-Zxxx-UY', 'region': 'UY', 'script': 'Zxxx', 'suppress': False},
        'uha': {'full': 'uha-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'uhn': {'full': 'uhn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'uis': {'full': 'uis-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'uiv': {'full': 'uiv-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'uji': {'full': 'uji-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'uk': {'full': 'uk-Cyrl-UA', 'region': 'UA', 'script': 'Cyrl', 'suppress': True},
        'uka': {'full': 'uka-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ukg': {'full': 'ukg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ukh': {'full': 'ukh-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'uki': {'full': 'uki-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'ukk': {'full': 'ukk-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'ukl': {'full': 'ukl-Zxxx-UA', 'region': 'UA', 'script': 'Zxxx', 'suppress': False},
        'ukp': {'full': 'ukp-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ukq': {'full': 'ukq-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'uks': {'full': 'uks-Zxxx-BR', 'region': 'BR', 'script': 'Zxxx', 'suppress': False},
        'uku': {'full': 'uku-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ukw': {'full': 'ukw-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'uky': {'full': 'uky-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ula': {'full': 'ula-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ulb': {'full': 'ulb-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ulc': {'full': 'ulc-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'ule': {'full': 'ule-Latn-AR', 'region': 'AR', 'script': 'Latn', 'suppress': False},
        'ulf': {'full': 'ulf-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'uli': {'full': 'uli-Latn-FM', 'region': 'FM', 'script': 'Latn', 'suppress': False},
        'ulk': {'full': 'ulk-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ull': {'full': 'ull-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'ulm': {'full': 'ulm-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'uln': {'full': 'uln-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ulu': {'full': 'ulu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ulw': {'full': 'ulw-Latn-NI', 'region': 'NI', 'script': 'Latn', 'suppress': False},
        'uma': {'full': 'uma-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'umb': {'full': 'umb-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'umc': {'full': 'umc-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'umd': {'full': 'umd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'umg': {'full': 'umg-Qaax-AU', 'region': 'AU', 'script': 'Qaax', 'suppress': False},
        'umi': {'full': 'umi-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'umm': {'full': 'umm-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'umn': {'full': 'umn-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'umo': {'full': 'umo-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'ump': {'full': 'ump-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'umr': {'full': 'umr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ums': {'full': 'ums-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'una': {'full': 'una-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'und': {'full': 'und-Zyyy-001', 'region': '001', 'script': 'Zyyy', 'suppress': False},
        'une': {'full': 'une-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ung': {'full': 'ung-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'unk': {'full': 'unk-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'unm': {'full': 'unm-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'unn': {'full': 'unn-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'unr': {'full': 'unr-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'unr-Latn': {'full': 'unr-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'unr-NP': {'full': 'unr-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'unr-Orya': {'full': 'unr-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'unu': {'full': 'unu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'unx': {'full': 'unx-Beng-IN', 'region': 'IN', 'script': 'Beng', 'suppress': False},
        'unx-Deva': {'full': 'unx-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'unz': {'full': 'unz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'upi': {'full': 'upi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'upv': {'full': 'upv-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'ur': {'full': 'ur-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': True},
        'ur-Brai': {'full': 'ur-Brai-PK', 'region': 'PK', 'script': 'Brai', 'suppress': False},
        'ur-IN': {'full': 'ur-Arab-IN', 'region': 'IN', 'script': 'Arab', 'suppress': True},
        'ur-Latn': {'full': 'ur-Latn-PK', 'region': 'PK', 'script': 'Latn', 'suppress': False},
        'ura': {'full': 'ura-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'urb': {'full': 'urb-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'urc': {'full': 'urc-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ure': {'full': 'ure-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'urf': {'full': 'urf-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'urg': {'full': 'urg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'urh': {'full': 'urh-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'uri': {'full': 'uri-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'urk': {'full': 'urk-Thai-TH', 'region': 'TH', 'script': 'Thai', 'suppress': False},
        'url': {'full': 'url-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'urm': {'full': 'urm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'urn': {'full': 'urn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'uro': {'full': 'uro-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'urp': {'full': 'urp-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'urr': {'full': 'urr-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'urt': {'full': 'urt-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'uru': {'full': 'uru-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'urv': {'full': 'urv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'urw': {'full': 'urw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'urx': {'full': 'urx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ury': {'full': 'ury-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'urz': {'full': 'urz-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'usa': {'full': 'usa-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ush': {'full': 'ush-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'usi-Beng': {'full': 'usi-Beng-BD', 'region': 'BD', 'script': 'Beng', 'suppress': False},
        'usi-Latn': {'full': 'usi-Latn-BD', 'region': 'BD', 'script': 'Latn', 'suppress': False},
        'usk': {'full': 'usk-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'usp': {'full': 'usp-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'uss': {'full': 'uss-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'usu': {'full': 'usu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'uta': {'full': 'uta-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ute': {'full': 'ute-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'uth': {'full': 'uth-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'utp': {'full': 'utp-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'utr': {'full': 'utr-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'utu': {'full': 'utu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'uum': {'full': 'uum-Grek-GE', 'region': 'GE', 'script': 'Grek', 'suppress': False},
        'uum-Cyrl': {'full': 'uum-Cyrl-GE', 'region': 'GE', 'script': 'Cyrl', 'suppress': False},
        'uun': {'full': 'uun-Latn-TW', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'uur': {'full': 'uur-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'uuu': {'full': 'uuu-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'uve': {'full': 'uve-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'uvh': {'full': 'uvh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'uvl': {'full': 'uvl-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'uwa': {'full': 'uwa-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'uya': {'full': 'uya-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'uz': {'full': 'uz-Latn-UZ', 'region': 'UZ', 'script': 'Latn', 'suppress': False},
        'uz-AF': {'full': 'uz-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'uz-Brai': {'full': 'uz-Brai-UZ', 'region': 'UZ', 'script': 'Brai', 'suppress': False},
        'uz-CN': {'full': 'uz-Cyrl-CN', 'region': 'CN', 'script': 'Cyrl', 'suppress': False},
        'uz-Cyrl': {'full': 'uz-Cyrl-UZ', 'region': 'UZ', 'script': 'Cyrl', 'suppress': False},
        'uz-Sogd': {'full': 'uz-Sogd-CN', 'region': 'CN', 'script': 'Sogd', 'suppress': False},
        'uzs': {'full': 'uzs-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'vaa': {'full': 'vaa-Taml-IN', 'region': 'IN', 'script': 'Taml', 'suppress': False},
        'vae': {'full': 'vae-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'vaf': {'full': 'vaf-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'vag': {'full': 'vag-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'vah': {'full': 'vah-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'vai': {'full': 'vai-Vaii-LR', 'region': 'LR', 'script': 'Vaii', 'suppress': False},
        'vai-Latn': {'full': 'vai-Latn-LR', 'region': 'LR', 'script': 'Latn', 'suppress': False},
        'vaj': {'full': 'vaj-Latn-NA', 'region': 'NA', 'script': 'Latn', 'suppress': False},
        'val': {'full': 'val-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'vam': {'full': 'vam-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'van': {'full': 'van-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'vao': {'full': 'vao-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'vap': {'full': 'vap-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'var': {'full': 'var-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'vas': {'full': 'vas-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'vas-Gujr': {'full': 'vas-Gujr-IN', 'region': 'IN', 'script': 'Gujr', 'suppress': False},
        'vau': {'full': 'vau-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'vav': {'full': 'vav-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'vav-Gujr': {'full': 'vav-Gujr-IN', 'region': 'IN', 'script': 'Gujr', 'suppress': False},
        'vay': {'full': 'vay-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'vbb': {'full': 'vbb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'vbk': {'full': 'vbk-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        've': {'full': 've-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': True},
        've-Brai': {'full': 've-Brai-ZA', 'region': 'ZA', 'script': 'Brai', 'suppress': False},
        'vec': {'full': 'vec-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'ved': {'full': 'ved-Zyyy-LK', 'region': 'LK', 'script': 'Zyyy', 'suppress': False},
        'vel': {'full': 'vel-Zyyy-NL', 'region': 'NL', 'script': 'Zyyy', 'suppress': False},
        'vem': {'full': 'vem-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'veo': {'full': 'veo-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'vep': {'full': 'vep-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'ver': {'full': 'ver-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'vgr': {'full': 'vgr-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'vgt': {'full': 'vgt-Zxxx-BE', 'region': 'BE', 'script': 'Zxxx', 'suppress': False},
        'vi': {'full': 'vi-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': True},
        'vi-Brai': {'full': 'vi-Brai-VN', 'region': 'VN', 'script': 'Brai', 'suppress': False},
        'vi-Hani': {'full': 'vi-Hani-VN', 'region': 'VN', 'script': 'Hani', 'suppress': False},
        'vic': {'full': 'vic-Latn-SX', 'region': 'SX', 'script': 'Latn', 'suppress': False},
        'vid': {'full': 'vid-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'vif': {'full': 'vif-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'vig': {'full': 'vig-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'vil': {'full': 'vil-Latn-AR', 'region': 'AR', 'script': 'Latn', 'suppress': False},
        'vin': {'full': 'vin-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'vis': {'full': 'vis-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'vit': {'full': 'vit-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'viv': {'full': 'viv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'vka': {'full': 'vka-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'vki': {'full': 'vki-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'vkj': {'full': 'vkj-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'vkk': {'full': 'vkk-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'vkl': {'full': 'vkl-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'vkm': {'full': 'vkm-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'vko': {'full': 'vko-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'vkp-Deva': {'full': 'vkp-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'vkp-Latn': {'full': 'vkp-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'vkt': {'full': 'vkt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'vku': {'full': 'vku-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'vlp': {'full': 'vlp-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'vls': {'full': 'vls-Latn-BE', 'region': 'BE', 'script': 'Latn', 'suppress': False},
        'vma': {'full': 'vma-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'vmb': {'full': 'vmb-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'vmc': {'full': 'vmc-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'vmd': {'full': 'vmd-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'vme': {'full': 'vme-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'vmf': {'full': 'vmf-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': False},
        'vmg': {'full': 'vmg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'vmh': {'full': 'vmh-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'vmi': {'full': 'vmi-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'vmj': {'full': 'vmj-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'vmk': {'full': 'vmk-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'vml': {'full': 'vml-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'vmm': {'full': 'vmm-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'vmp': {'full': 'vmp-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'vmq': {'full': 'vmq-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'vmr': {'full': 'vmr-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'vms': {'full': 'vms-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'vmu': {'full': 'vmu-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'vmv': {'full': 'vmv-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'vmw': {'full': 'vmw-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'vmw-Arab': {'full': 'vmw-Arab-MZ', 'region': 'MZ', 'script': 'Arab', 'suppress': False},
        'vmx': {'full': 'vmx-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'vmy': {'full': 'vmy-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'vmz': {'full': 'vmz-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'vnk': {'full': 'vnk-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'vnm': {'full': 'vnm-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'vnp': {'full': 'vnp-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'vo': {'full': 'vo-Latn-001', 'region': '001', 'script': 'Latn', 'suppress': False},
        'vor': {'full': 'vor-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'vot': {'full': 'vot-Latn-RU', 'region': 'RU', 'script': 'Latn', 'suppress': False},
        'vot-Cyrl': {'full': 'vot-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'vra': {'full': 'vra-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'vro': {'full': 'vro-Latn-EE', 'region': 'EE', 'script': 'Latn', 'suppress': False},
        'vrs': {'full': 'vrs-Latn-SB', 'region': 'SB', 'script': 'Latn', 'suppress': False},
        'vrt': {'full': 'vrt-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'vsi': {'full': 'vsi-Zxxx-MD', 'region': 'MD', 'script': 'Zxxx', 'suppress': False},
        'vsl': {'full': 'vsl-Zxxx-VE', 'region': 'VE', 'script': 'Zxxx', 'suppress': False},
        'vsv': {'full': 'vsv-Zxxx-ES', 'region': 'ES', 'script': 'Zxxx', 'suppress': False},
        'vto': {'full': 'vto-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'vum': {'full': 'vum-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'vun': {'full': 'vun-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'vut': {'full': 'vut-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'vwa': {'full': 'vwa-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'wa': {'full': 'wa-Latn-BE', 'region': 'BE', 'script': 'Latn', 'suppress': False},
        'waa': {'full': 'waa-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'wab': {'full': 'wab-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wac': {'full': 'wac-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'wad': {'full': 'wad-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wae': {'full': 'wae-Latn-CH', 'region': 'CH', 'script': 'Latn', 'suppress': False},
        'waf': {'full': 'waf-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'wag': {'full': 'wag-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wah': {'full': 'wah-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wai': {'full': 'wai-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'waj': {'full': 'waj-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wal': {'full': 'wal-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'wal-Latn': {'full': 'wal-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'wam': {'full': 'wam-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'wan': {'full': 'wan-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'wao': {'full': 'wao-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'wap': {'full': 'wap-Latn-GY', 'region': 'GY', 'script': 'Latn', 'suppress': False},
        'waq': {'full': 'waq-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'war': {'full': 'war-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'war-Brai': {'full': 'war-Brai-PH', 'region': 'PH', 'script': 'Brai', 'suppress': False},
        'was': {'full': 'was-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'wat': {'full': 'wat-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wau': {'full': 'wau-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'wav': {'full': 'wav-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'waw': {'full': 'waw-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'wax': {'full': 'wax-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'way': {'full': 'way-Latn-SR', 'region': 'SR', 'script': 'Latn', 'suppress': False},
        'waz': {'full': 'waz-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wba': {'full': 'wba-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'wbb': {'full': 'wbb-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wbe': {'full': 'wbe-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wbf': {'full': 'wbf-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'wbh': {'full': 'wbh-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'wbi': {'full': 'wbi-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'wbj': {'full': 'wbj-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'wbk': {'full': 'wbk-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'wbl': {'full': 'wbl-Latn-PK', 'region': 'PK', 'script': 'Latn', 'suppress': False},
        'wbl-Arab': {'full': 'wbl-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'wbl-Cyrl': {'full': 'wbl-Cyrl-TJ', 'region': 'TJ', 'script': 'Cyrl', 'suppress': False},
        'wbm': {'full': 'wbm-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'wbp': {'full': 'wbp-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wbq': {'full': 'wbq-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'wbr': {'full': 'wbr-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'wbs': {'full': 'wbs-Zxxx-IN', 'region': 'IN', 'script': 'Zxxx', 'suppress': False},
        'wbt': {'full': 'wbt-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wbv': {'full': 'wbv-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wbw': {'full': 'wbw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wca': {'full': 'wca-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'wci': {'full': 'wci-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'wdd': {'full': 'wdd-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'wdg': {'full': 'wdg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wdj': {'full': 'wdj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wdk': {'full': 'wdk-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wdu': {'full': 'wdu-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wdy': {'full': 'wdy-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wea': {'full': 'wea-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'wec': {'full': 'wec-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'wed': {'full': 'wed-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'weg': {'full': 'weg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'weh': {'full': 'weh-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'wei': {'full': 'wei-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wem': {'full': 'wem-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'weo': {'full': 'weo-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wep': {'full': 'wep-Latn-DE', 'region': 'DE', 'script': 'Latn', 'suppress': False},
        'wer': {'full': 'wer-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wes': {'full': 'wes-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'wet': {'full': 'wet-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'weu': {'full': 'weu-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'wew': {'full': 'wew-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wfg': {'full': 'wfg-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wga': {'full': 'wga-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wgb': {'full': 'wgb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wgg': {'full': 'wgg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wgi': {'full': 'wgi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wgo': {'full': 'wgo-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wgu': {'full': 'wgu-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wgy': {'full': 'wgy-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wha': {'full': 'wha-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'whg': {'full': 'whg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'whk': {'full': 'whk-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'whu': {'full': 'whu-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wib': {'full': 'wib-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'wic': {'full': 'wic-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'wie': {'full': 'wie-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wif': {'full': 'wif-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wig': {'full': 'wig-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wih': {'full': 'wih-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wii': {'full': 'wii-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wij': {'full': 'wij-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wik': {'full': 'wik-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wil': {'full': 'wil-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wim': {'full': 'wim-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'win': {'full': 'win-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'wir': {'full': 'wir-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'wiu': {'full': 'wiu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wiv': {'full': 'wiv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wiy': {'full': 'wiy-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'wja': {'full': 'wja-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'wji': {'full': 'wji-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'wka': {'full': 'wka-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'wkb': {'full': 'wkb-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'wkd': {'full': 'wkd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wkl': {'full': 'wkl-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'wkr': {'full': 'wkr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wku': {'full': 'wku-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'wkw': {'full': 'wkw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wky': {'full': 'wky-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wla': {'full': 'wla-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wlc': {'full': 'wlc-Zyyy-KM', 'region': 'KM', 'script': 'Zyyy', 'suppress': False},
        'wle-Arab': {'full': 'wle-Arab-ET', 'region': 'ET', 'script': 'Arab', 'suppress': False},
        'wlg': {'full': 'wlg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wlh': {'full': 'wlh-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'wli': {'full': 'wli-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wlk': {'full': 'wlk-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'wll': {'full': 'wll-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'wlm': {'full': 'wlm-Latn-GB', 'region': 'GB', 'script': 'Latn', 'suppress': False},
        'wlo': {'full': 'wlo-Arab-ID', 'region': 'ID', 'script': 'Arab', 'suppress': False},
        'wlr': {'full': 'wlr-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'wls': {'full': 'wls-Latn-WF', 'region': 'WF', 'script': 'Latn', 'suppress': False},
        'wlu': {'full': 'wlu-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wlv': {'full': 'wlv-Latn-AR', 'region': 'AR', 'script': 'Latn', 'suppress': False},
        'wlw': {'full': 'wlw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wlx': {'full': 'wlx-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'wly': {'full': 'wly-Zyyy-NP', 'region': 'NP', 'script': 'Zyyy', 'suppress': False},
        'wma': {'full': 'wma-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'wmb': {'full': 'wmb-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wmc': {'full': 'wmc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wmd': {'full': 'wmd-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'wme': {'full': 'wme-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'wmh': {'full': 'wmh-Latn-TL', 'region': 'TL', 'script': 'Latn', 'suppress': False},
        'wmi': {'full': 'wmi-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wmm': {'full': 'wmm-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wmn': {'full': 'wmn-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'wmo': {'full': 'wmo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wms': {'full': 'wms-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wmt': {'full': 'wmt-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wmw': {'full': 'wmw-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'wmw-Arab': {'full': 'wmw-Arab-MZ', 'region': 'MZ', 'script': 'Arab', 'suppress': False},
        'wmx': {'full': 'wmx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wnb': {'full': 'wnb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wnc': {'full': 'wnc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wnd': {'full': 'wnd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wne': {'full': 'wne-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'wng': {'full': 'wng-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wni': {'full': 'wni-Arab-KM', 'region': 'KM', 'script': 'Arab', 'suppress': False},
        'wni-Latn': {'full': 'wni-Latn-KM', 'region': 'KM', 'script': 'Latn', 'suppress': False},
        'wnk': {'full': 'wnk-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wnm': {'full': 'wnm-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wnn': {'full': 'wnn-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wno': {'full': 'wno-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wnp': {'full': 'wnp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wnu': {'full': 'wnu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wnw': {'full': 'wnw-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'wny': {'full': 'wny-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wo': {'full': 'wo-Latn-SN', 'region': 'SN', 'script': 'Latn', 'suppress': False},
        'wo-Arab': {'full': 'wo-Arab-SN', 'region': 'SN', 'script': 'Arab', 'suppress': False},
        'woa': {'full': 'woa-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wob': {'full': 'wob-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'woc': {'full': 'woc-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wod': {'full': 'wod-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'woe': {'full': 'woe-Latn-FM', 'region': 'FM', 'script': 'Latn', 'suppress': False},
        'woe-Wole': {'full': 'woe-Wole-FM', 'region': 'FM', 'script': 'Wole', 'suppress': False},
        'wof': {'full': 'wof-Latn-GM', 'region': 'GM', 'script': 'Latn', 'suppress': False},
        'wof-Arab': {'full': 'wof-Arab-GM', 'region': 'GM', 'script': 'Arab', 'suppress': False},
        'wog': {'full': 'wog-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'woi': {'full': 'woi-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wok': {'full': 'wok-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'wom': {'full': 'wom-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'won': {'full': 'won-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'woo': {'full': 'woo-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wor': {'full': 'wor-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wos': {'full': 'wos-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wow': {'full': 'wow-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'woy': {'full': 'woy-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'wpc': {'full': 'wpc-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'wra': {'full': 'wra-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wrb': {'full': 'wrb-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wrd': {'full': 'wrd-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'wrg': {'full': 'wrg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wrh': {'full': 'wrh-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wri': {'full': 'wri-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wrk': {'full': 'wrk-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wrl': {'full': 'wrl-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wrm': {'full': 'wrm-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wrn': {'full': 'wrn-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'wro': {'full': 'wro-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wrp': {'full': 'wrp-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wrr': {'full': 'wrr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wrs': {'full': 'wrs-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wru': {'full': 'wru-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wrv': {'full': 'wrv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wrw': {'full': 'wrw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wrx': {'full': 'wrx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wry': {'full': 'wry-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'wrz': {'full': 'wrz-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wsa': {'full': 'wsa-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wsg': {'full': 'wsg-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'wsg-Deva': {'full': 'wsg-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'wsg-Gong': {'full': 'wsg-Gong-IN', 'region': 'IN', 'script': 'Gong', 'suppress': False},
        'wsg-Gonm': {'full': 'wsg-Gonm-IN', 'region': 'IN', 'script': 'Gonm', 'suppress': False},
        'wsi': {'full': 'wsi-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'wsk': {'full': 'wsk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wsr': {'full': 'wsr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wss': {'full': 'wss-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'wsu': {'full': 'wsu-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'wsv': {'full': 'wsv-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'wtf': {'full': 'wtf-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wth': {'full': 'wth-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wti': {'full': 'wti-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'wtk': {'full': 'wtk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wtm': {'full': 'wtm-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'wtw': {'full': 'wtw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wtw-Bugi': {'full': 'wtw-Bugi-ID', 'region': 'ID', 'script': 'Bugi', 'suppress': False},
        'wua': {'full': 'wua-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wub': {'full': 'wub-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wud': {'full': 'wud-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'wuh': {'full': 'wuh-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'wul': {'full': 'wul-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wum': {'full': 'wum-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'wun': {'full': 'wun-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'wur': {'full': 'wur-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wut': {'full': 'wut-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wuu': {'full': 'wuu-Hans-CN', 'region': 'CN', 'script': 'Hans', 'suppress': False},
        'wuu-Hant': {'full': 'wuu-Hant-CN', 'region': 'CN', 'script': 'Hant', 'suppress': False},
        'wuu-Latn': {'full': 'wuu-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'wuv': {'full': 'wuv-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'wux': {'full': 'wux-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wuy': {'full': 'wuy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'wwa': {'full': 'wwa-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'wwb': {'full': 'wwb-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wwo': {'full': 'wwo-Latn-VU', 'region': 'VU', 'script': 'Latn', 'suppress': False},
        'wwr': {'full': 'wwr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'www': {'full': 'www-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'wxa': {'full': 'wxa-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'wxw': {'full': 'wxw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wya': {'full': 'wya-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'wyb': {'full': 'wyb-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wyi': {'full': 'wyi-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'wym': {'full': 'wym-Latn-PL', 'region': 'PL', 'script': 'Latn', 'suppress': False},
        'wyr': {'full': 'wyr-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'wyy': {'full': 'wyy-Latn-FJ', 'region': 'FJ', 'script': 'Latn', 'suppress': False},
        'x-bad-mru': {'full': 'x-bad-mru-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'xaa': {'full': 'xaa-Latn-ES', 'region': 'ES', 'script': 'Latn', 'suppress': False},
        'xab': {'full': 'xab-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'xac': {'full': 'xac-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'xad': {'full': 'xad-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xae': {'full': 'xae-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xag': {'full': 'xag-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xai': {'full': 'xai-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xaj': {'full': 'xaj-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xak': {'full': 'xak-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'xal': {'full': 'xal-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'xal-Mong-x-todo': {'full': 'xal-Mong-CN-x-todo', 'region': 'CN', 'script': 'Mong', 'suppress': False},
        'xam': {'full': 'xam-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': False},
        'xan': {'full': 'xan-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'xao': {'full': 'xao-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'xap': {'full': 'xap-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xaq': {'full': 'xaq-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xar': {'full': 'xar-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'xas': {'full': 'xas-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'xat': {'full': 'xat-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xau': {'full': 'xau-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xav': {'full': 'xav-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xaw': {'full': 'xaw-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'xay': {'full': 'xay-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xbb': {'full': 'xbb-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xbc': {'full': 'xbc-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xbd': {'full': 'xbd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xbe': {'full': 'xbe-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xbg': {'full': 'xbg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xbi': {'full': 'xbi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'xbj': {'full': 'xbj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xbm': {'full': 'xbm-Latn-FR', 'region': 'FR', 'script': 'Latn', 'suppress': False},
        'xbn': {'full': 'xbn-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'xbo': {'full': 'xbo-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xbp': {'full': 'xbp-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xbr': {'full': 'xbr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xbw': {'full': 'xbw-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xby': {'full': 'xby-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xcb': {'full': 'xcb-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xcc': {'full': 'xcc-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xce': {'full': 'xce-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xcg': {'full': 'xcg-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xch': {'full': 'xch-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xcl': {'full': 'xcl-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xcm': {'full': 'xcm-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xcn': {'full': 'xcn-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xco': {'full': 'xco-Arab-XX', 'region': 'XX', 'script': 'Arab', 'suppress': False},
        'xco-Chrs': {'full': 'xco-Chrs-XX', 'region': 'XX', 'script': 'Chrs', 'suppress': False},
        'xcr': {'full': 'xcr-Cari-TR', 'region': 'TR', 'script': 'Cari', 'suppress': False},
        'xct': {'full': 'xct-Tibt-XX', 'region': 'XX', 'script': 'Tibt', 'suppress': False},
        'xcu': {'full': 'xcu-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xcv': {'full': 'xcv-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xcw': {'full': 'xcw-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xcy': {'full': 'xcy-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xda': {'full': 'xda-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xdc': {'full': 'xdc-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xdk': {'full': 'xdk-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xdm': {'full': 'xdm-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xdo': {'full': 'xdo-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'xdy': {'full': 'xdy-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xeb': {'full': 'xeb-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xed': {'full': 'xed-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'xeg': {'full': 'xeg-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': False},
        'xel': {'full': 'xel-Zyyy-SD', 'region': 'SD', 'script': 'Zyyy', 'suppress': False},
        'xem': {'full': 'xem-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xep': {'full': 'xep-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xer': {'full': 'xer-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xes': {'full': 'xes-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'xet': {'full': 'xet-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xeu': {'full': 'xeu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'xfa': {'full': 'xfa-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xga': {'full': 'xga-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xgb': {'full': 'xgb-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'xgd': {'full': 'xgd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xgf': {'full': 'xgf-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xgg': {'full': 'xgg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xgi': {'full': 'xgi-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xgl': {'full': 'xgl-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xgm': {'full': 'xgm-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xgr': {'full': 'xgr-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xgu': {'full': 'xgu-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xgw': {'full': 'xgw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xh': {'full': 'xh-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': True},
        'xh-Brai': {'full': 'xh-Brai-ZA', 'region': 'ZA', 'script': 'Brai', 'suppress': False},
        'xha': {'full': 'xha-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xhc': {'full': 'xhc-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xhd': {'full': 'xhd-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xhe': {'full': 'xhe-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'xhr': {'full': 'xhr-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xht': {'full': 'xht-Zyyy-TR', 'region': 'TR', 'script': 'Zyyy', 'suppress': False},
        'xhu': {'full': 'xhu-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xhv': {'full': 'xhv-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'xib': {'full': 'xib-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xii': {'full': 'xii-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': False},
        'xil': {'full': 'xil-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xin': {'full': 'xin-Latn-GT', 'region': 'GT', 'script': 'Latn', 'suppress': False},
        'xir': {'full': 'xir-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xis': {'full': 'xis-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'xiv': {'full': 'xiv-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xiy': {'full': 'xiy-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xjb': {'full': 'xjb-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xjt': {'full': 'xjt-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xka': {'full': 'xka-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'xkb': {'full': 'xkb-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'xkc': {'full': 'xkc-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'xkd': {'full': 'xkd-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xke': {'full': 'xke-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xkf-Tibt': {'full': 'xkf-Tibt-BT-x-uchen', 'region': 'BT', 'script': 'Tibt', 'suppress': False},
        'xkg': {'full': 'xkg-Latn-ML', 'region': 'ML', 'script': 'Latn', 'suppress': False},
        'xki': {'full': 'xki-Zxxx-KE', 'region': 'KE', 'script': 'Zxxx', 'suppress': False},
        'xkj': {'full': 'xkj-Arab-IR', 'region': 'IR', 'script': 'Arab', 'suppress': False},
        'xkk': {'full': 'xkk-Zyyy-KH', 'region': 'KH', 'script': 'Zyyy', 'suppress': False},
        'xkl': {'full': 'xkl-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xkn': {'full': 'xkn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xko': {'full': 'xko-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'xkp': {'full': 'xkp-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'xkq': {'full': 'xkq-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xkr': {'full': 'xkr-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xks': {'full': 'xks-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xkt': {'full': 'xkt-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'xku': {'full': 'xku-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'xkv': {'full': 'xkv-Latn-BW', 'region': 'BW', 'script': 'Latn', 'suppress': False},
        'xkw': {'full': 'xkw-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xkx': {'full': 'xkx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'xky': {'full': 'xky-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'xkz': {'full': 'xkz-Latn-BT', 'region': 'BT', 'script': 'Latn', 'suppress': False},
        'xkz-Tibt-x-uchen': {'full': 'xkz-Tibt-BT-x-uchen', 'region': 'BT', 'script': 'Tibt', 'suppress': False},
        'xla': {'full': 'xla-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'xlb': {'full': 'xlb-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xlc': {'full': 'xlc-Lyci-TR', 'region': 'TR', 'script': 'Lyci', 'suppress': False},
        'xld': {'full': 'xld-Lydi-TR', 'region': 'TR', 'script': 'Lydi', 'suppress': False},
        'xle': {'full': 'xle-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xlg': {'full': 'xlg-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xli': {'full': 'xli-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xln': {'full': 'xln-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xlo': {'full': 'xlo-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xlp': {'full': 'xlp-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xls': {'full': 'xls-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xlu': {'full': 'xlu-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xly': {'full': 'xly-Elym-IR', 'region': 'IR', 'script': 'Elym', 'suppress': False},
        'xma': {'full': 'xma-Zyyy-SO', 'region': 'SO', 'script': 'Zyyy', 'suppress': False},
        'xmb': {'full': 'xmb-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'xmc': {'full': 'xmc-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'xmd': {'full': 'xmd-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'xme': {'full': 'xme-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xmf': {'full': 'xmf-Geor-GE', 'region': 'GE', 'script': 'Geor', 'suppress': False},
        'xmg': {'full': 'xmg-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'xmg-Zzzz-x-bagam': {'full': 'xmg-Zzzz-CM-x-bagam', 'region': 'CM', 'script': 'Zzzz', 'suppress': False},
        'xmh': {'full': 'xmh-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xmj': {'full': 'xmj-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'xmk': {'full': 'xmk-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xml': {'full': 'xml-Zxxx-MY', 'region': 'MY', 'script': 'Zxxx', 'suppress': False},
        'xmm': {'full': 'xmm-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xmn': {'full': 'xmn-Mani-CN', 'region': 'CN', 'script': 'Mani', 'suppress': False},
        'xmo': {'full': 'xmo-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xmp': {'full': 'xmp-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xmq': {'full': 'xmq-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xmr': {'full': 'xmr-Merc-SD', 'region': 'SD', 'script': 'Merc', 'suppress': False},
        'xms': {'full': 'xms-Zxxx-MA', 'region': 'MA', 'script': 'Zxxx', 'suppress': False},
        'xmt': {'full': 'xmt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xmu': {'full': 'xmu-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xmv': {'full': 'xmv-Latn-MG', 'region': 'MG', 'script': 'Latn', 'suppress': False},
        'xmw': {'full': 'xmw-Latn-MG', 'region': 'MG', 'script': 'Latn', 'suppress': False},
        'xmx': {'full': 'xmx-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xmy': {'full': 'xmy-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xmz': {'full': 'xmz-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xna': {'full': 'xna-Narb-SA', 'region': 'SA', 'script': 'Narb', 'suppress': False},
        'xnb': {'full': 'xnb-Zyyy-TW', 'region': 'TW', 'script': 'Zyyy', 'suppress': False},
        'xng': {'full': 'xng-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xnh': {'full': 'xnh-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'xni': {'full': 'xni-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xnk': {'full': 'xnk-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xnm': {'full': 'xnm-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xnn': {'full': 'xnn-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'xno': {'full': 'xno-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xnr': {'full': 'xnr-Deva-IN', 'region': 'IN', 'script': 'Deva', 'suppress': False},
        'xns': {'full': 'xns-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'xnt': {'full': 'xnt-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'xnu': {'full': 'xnu-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xny': {'full': 'xny-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xnz-Arab': {'full': 'xnz-Arab-EG', 'region': 'EG', 'script': 'Arab', 'suppress': False},
        'xnz-Copt': {'full': 'xnz-Copt-EG-x-olnubian', 'region': 'EG', 'script': 'Copt', 'suppress': False},
        'xnz-Latn': {'full': 'xnz-Latn-EG', 'region': 'EG', 'script': 'Latn', 'suppress': False},
        'xoc': {'full': 'xoc-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'xod': {'full': 'xod-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xog': {'full': 'xog-Latn-UG', 'region': 'UG', 'script': 'Latn', 'suppress': False},
        'xoi': {'full': 'xoi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'xok': {'full': 'xok-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xom': {'full': 'xom-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'xom-Ethi': {'full': 'xom-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'xon': {'full': 'xon-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'xon-Brai': {'full': 'xon-Brai-GH', 'region': 'GH', 'script': 'Brai', 'suppress': False},
        'xoo': {'full': 'xoo-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xop': {'full': 'xop-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'xor': {'full': 'xor-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xow': {'full': 'xow-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'xpa': {'full': 'xpa-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xpb': {'full': 'xpb-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xpc': {'full': 'xpc-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xpd': {'full': 'xpd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xpf': {'full': 'xpf-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xpg': {'full': 'xpg-Grek-TR', 'region': 'TR', 'script': 'Grek', 'suppress': False},
        'xph': {'full': 'xph-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xpi': {'full': 'xpi-Zyyy-GB', 'region': 'GB', 'script': 'Zyyy', 'suppress': False},
        'xpj': {'full': 'xpj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xpk': {'full': 'xpk-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xpl': {'full': 'xpl-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xpm': {'full': 'xpm-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'xpn': {'full': 'xpn-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xpo': {'full': 'xpo-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'xpp': {'full': 'xpp-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'xpq': {'full': 'xpq-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'xpr': {'full': 'xpr-Prti-IR', 'region': 'IR', 'script': 'Prti', 'suppress': False},
        'xps': {'full': 'xps-Zyyy-TR', 'region': 'TR', 'script': 'Zyyy', 'suppress': False},
        'xpt': {'full': 'xpt-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xpu': {'full': 'xpu-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xpv': {'full': 'xpv-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xpw': {'full': 'xpw-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xpx': {'full': 'xpx-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xpy': {'full': 'xpy-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'xpz': {'full': 'xpz-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xqa': {'full': 'xqa-Zyyy-TR', 'region': 'TR', 'script': 'Zyyy', 'suppress': False},
        'xqt': {'full': 'xqt-Zyyy-YE', 'region': 'YE', 'script': 'Zyyy', 'suppress': False},
        'xra': {'full': 'xra-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xrb': {'full': 'xrb-Latn-BF', 'region': 'BF', 'script': 'Latn', 'suppress': False},
        'xrd': {'full': 'xrd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xre': {'full': 'xre-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xrg': {'full': 'xrg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xri': {'full': 'xri-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xrm': {'full': 'xrm-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'xrn': {'full': 'xrn-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'xrr': {'full': 'xrr-Zyyy-IT', 'region': 'IT', 'script': 'Zyyy', 'suppress': False},
        'xrt': {'full': 'xrt-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'xru': {'full': 'xru-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xrw': {'full': 'xrw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'xsa': {'full': 'xsa-Sarb-YE', 'region': 'YE', 'script': 'Sarb', 'suppress': False},
        'xsb': {'full': 'xsb-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'xsc': {'full': 'xsc-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xsd': {'full': 'xsd-Zyyy-TR', 'region': 'TR', 'script': 'Zyyy', 'suppress': False},
        'xse': {'full': 'xse-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xsh': {'full': 'xsh-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'xsi': {'full': 'xsi-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'xsm': {'full': 'xsm-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'xsn': {'full': 'xsn-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'xso': {'full': 'xso-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'xsp': {'full': 'xsp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'xsq': {'full': 'xsq-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'xsr': {'full': 'xsr-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'xsr-Tibt': {'full': 'xsr-Tibt-CN', 'region': 'CN', 'script': 'Tibt', 'suppress': False},
        'xss': {'full': 'xss-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'xsu': {'full': 'xsu-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'xsv': {'full': 'xsv-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xsy': {'full': 'xsy-Latn-TW', 'region': 'TW', 'script': 'Latn', 'suppress': False},
        'xta': {'full': 'xta-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'xtb': {'full': 'xtb-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'xtc': {'full': 'xtc-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'xtd': {'full': 'xtd-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'xte': {'full': 'xte-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xtg': {'full': 'xtg-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xth': {'full': 'xth-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xti': {'full': 'xti-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'xtj': {'full': 'xtj-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'xtl': {'full': 'xtl-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'xtm': {'full': 'xtm-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'xtn': {'full': 'xtn-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'xto': {'full': 'xto-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'xtp': {'full': 'xtp-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'xtq': {'full': 'xtq-Zyyy-IR', 'region': 'IR', 'script': 'Zyyy', 'suppress': False},
        'xtr': {'full': 'xtr-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'xts': {'full': 'xts-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'xtt': {'full': 'xtt-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'xtu': {'full': 'xtu-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'xtv': {'full': 'xtv-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xtw': {'full': 'xtw-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xty': {'full': 'xty-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'xtz': {'full': 'xtz-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xua': {'full': 'xua-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'xub-Knda': {'full': 'xub-Knda-IN', 'region': 'IN', 'script': 'Knda', 'suppress': False},
        'xub-Mlym': {'full': 'xub-Mlym-IN', 'region': 'IN', 'script': 'Mlym', 'suppress': False},
        'xub-Taml': {'full': 'xub-Taml-IN', 'region': 'IN', 'script': 'Taml', 'suppress': False},
        'xud': {'full': 'xud-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xug': {'full': 'xug-Zyyy-JP', 'region': 'JP', 'script': 'Zyyy', 'suppress': False},
        'xuj': {'full': 'xuj-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'xul': {'full': 'xul-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xum': {'full': 'xum-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'xum-Ital': {'full': 'xum-Ital-IT', 'region': 'IT', 'script': 'Ital', 'suppress': False},
        'xun': {'full': 'xun-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xuo': {'full': 'xuo-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'xup': {'full': 'xup-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'xur': {'full': 'xur-Zyyy-TR', 'region': 'TR', 'script': 'Zyyy', 'suppress': False},
        'xut': {'full': 'xut-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xuu': {'full': 'xuu-Latn-NA', 'region': 'NA', 'script': 'Latn', 'suppress': False},
        'xve': {'full': 'xve-Ital-IT', 'region': 'IT', 'script': 'Ital', 'suppress': False},
        'xvi': {'full': 'xvi-Arab-AF', 'region': 'AF', 'script': 'Arab', 'suppress': False},
        'xvn': {'full': 'xvn-Latn-ES', 'region': 'ES', 'script': 'Latn', 'suppress': False},
        'xvo': {'full': 'xvo-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'xvs': {'full': 'xvs-Latn-IT', 'region': 'IT', 'script': 'Latn', 'suppress': False},
        'xwa': {'full': 'xwa-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xwc': {'full': 'xwc-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'xwd': {'full': 'xwd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xwe': {'full': 'xwe-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'xwg': {'full': 'xwg-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'xwj': {'full': 'xwj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xwk': {'full': 'xwk-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xwl': {'full': 'xwl-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'xwo': {'full': 'xwo-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'xwr': {'full': 'xwr-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xwt': {'full': 'xwt-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xww': {'full': 'xww-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xxb': {'full': 'xxb-Latn-GH', 'region': 'GH', 'script': 'Latn', 'suppress': False},
        'xxk': {'full': 'xxk-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xxm': {'full': 'xxm-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xxr': {'full': 'xxr-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xxt': {'full': 'xxt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'xya': {'full': 'xya-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xyb': {'full': 'xyb-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xyj': {'full': 'xyj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xyk': {'full': 'xyk-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xyl': {'full': 'xyl-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'xyt': {'full': 'xyt-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xyy': {'full': 'xyy-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'xzh': {'full': 'xzh-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'xzm': {'full': 'xzm-Zyyy-XX', 'region': 'XX', 'script': 'Zyyy', 'suppress': False},
        'xzp': {'full': 'xzp-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'yaa': {'full': 'yaa-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'yab': {'full': 'yab-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'yac': {'full': 'yac-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'yad': {'full': 'yad-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'yae': {'full': 'yae-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'yaf': {'full': 'yaf-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'yag': {'full': 'yag-Latn-CL', 'region': 'CL', 'script': 'Latn', 'suppress': False},
        'yah-Cyrl': {'full': 'yah-Cyrl-TJ', 'region': 'TJ', 'script': 'Cyrl', 'suppress': False},
        'yah-Latn': {'full': 'yah-Latn-TJ', 'region': 'TJ', 'script': 'Latn', 'suppress': False},
        'yai': {'full': 'yai-Cyrl-TJ', 'region': 'TJ', 'script': 'Cyrl', 'suppress': False},
        'yaj': {'full': 'yaj-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'yak': {'full': 'yak-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'yal-Arab': {'full': 'yal-Arab-GN', 'region': 'GN', 'script': 'Arab', 'suppress': False},
        'yal-Latn': {'full': 'yal-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'yam': {'full': 'yam-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'yan': {'full': 'yan-Latn-NI', 'region': 'NI', 'script': 'Latn', 'suppress': False},
        'yao': {'full': 'yao-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'yao-Arab': {'full': 'yao-Arab-MZ', 'region': 'MZ', 'script': 'Arab', 'suppress': False},
        'yap': {'full': 'yap-Latn-FM', 'region': 'FM', 'script': 'Latn', 'suppress': False},
        'yaq': {'full': 'yaq-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'yar': {'full': 'yar-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'yas': {'full': 'yas-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'yat': {'full': 'yat-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'yau': {'full': 'yau-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'yav': {'full': 'yav-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'yaw': {'full': 'yaw-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'yax': {'full': 'yax-Latn-AO', 'region': 'AO', 'script': 'Latn', 'suppress': False},
        'yay': {'full': 'yay-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'yaz': {'full': 'yaz-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'yba': {'full': 'yba-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ybb': {'full': 'ybb-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'ybe': {'full': 'ybe-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ybh': {'full': 'ybh-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'ybi': {'full': 'ybi-Deva-NP', 'region': 'NP', 'script': 'Deva', 'suppress': False},
        'ybj': {'full': 'ybj-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ybk': {'full': 'ybk-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ybl': {'full': 'ybl-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ybm': {'full': 'ybm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ybn': {'full': 'ybn-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'ybo': {'full': 'ybo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ybx': {'full': 'ybx-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yby': {'full': 'yby-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ych': {'full': 'ych-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ycl': {'full': 'ycl-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'ycn': {'full': 'ycn-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'ycp': {'full': 'ycp-Zyyy-LA', 'region': 'LA', 'script': 'Zyyy', 'suppress': False},
        'yda': {'full': 'yda-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'yde': {'full': 'yde-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ydg': {'full': 'ydg-Arab-PK', 'region': 'PK', 'script': 'Arab', 'suppress': False},
        'ydk': {'full': 'ydk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yea-Knda': {'full': 'yea-Knda-IN', 'region': 'IN', 'script': 'Knda', 'suppress': False},
        'yea-Mlym': {'full': 'yea-Mlym-IN', 'region': 'IN', 'script': 'Mlym', 'suppress': False},
        'yec': {'full': 'yec-Zyyy-DE', 'region': 'DE', 'script': 'Zyyy', 'suppress': False},
        'yee': {'full': 'yee-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yei': {'full': 'yei-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'yej': {'full': 'yej-Grek-IL', 'region': 'IL', 'script': 'Grek', 'suppress': False},
        'yel': {'full': 'yel-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'yer': {'full': 'yer-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'yes': {'full': 'yes-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'yet': {'full': 'yet-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'yeu': {'full': 'yeu-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'yev': {'full': 'yev-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yey': {'full': 'yey-Latn-BW', 'region': 'BW', 'script': 'Latn', 'suppress': False},
        'yga': {'full': 'yga-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ygi': {'full': 'ygi-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ygl': {'full': 'ygl-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ygm': {'full': 'ygm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ygp': {'full': 'ygp-Plrd-CN', 'region': 'CN', 'script': 'Plrd', 'suppress': False},
        'ygr': {'full': 'ygr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ygs': {'full': 'ygs-Zxxx-AU', 'region': 'AU', 'script': 'Zxxx', 'suppress': False},
        'ygu': {'full': 'ygu-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ygw': {'full': 'ygw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yha': {'full': 'yha-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yhd': {'full': 'yhd-Hebr-IL', 'region': 'IL', 'script': 'Hebr', 'suppress': False},
        'yhl': {'full': 'yhl-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yhs': {'full': 'yhs-Zxxx-AU', 'region': 'AU', 'script': 'Zxxx', 'suppress': False},
        'yi': {'full': 'yi-Hebr-001', 'region': '001', 'script': 'Hebr', 'suppress': True},
        'yia': {'full': 'yia-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'yif': {'full': 'yif-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yig': {'full': 'yig-Yiii-CN', 'region': 'CN', 'script': 'Yiii', 'suppress': False},
        'yih': {'full': 'yih-Hebr-DE', 'region': 'DE', 'script': 'Hebr', 'suppress': False},
        'yii': {'full': 'yii-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'yij': {'full': 'yij-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'yik': {'full': 'yik-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yil': {'full': 'yil-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'yim': {'full': 'yim-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'yin': {'full': 'yin-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'yip': {'full': 'yip-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yiq': {'full': 'yiq-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yir': {'full': 'yir-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'yis': {'full': 'yis-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yit': {'full': 'yit-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yiu': {'full': 'yiu-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yiv': {'full': 'yiv-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yix': {'full': 'yix-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yiz': {'full': 'yiz-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yka': {'full': 'yka-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'yka-Arab': {'full': 'yka-Arab-PH', 'region': 'PH', 'script': 'Arab', 'suppress': False},
        'ykg': {'full': 'ykg-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'yki': {'full': 'yki-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ykk': {'full': 'ykk-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ykl': {'full': 'ykl-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ykm': {'full': 'ykm-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ykn': {'full': 'ykn-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yko': {'full': 'yko-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'ykr': {'full': 'ykr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ykt': {'full': 'ykt-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yku': {'full': 'yku-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yky': {'full': 'yky-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'yla': {'full': 'yla-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ylb': {'full': 'ylb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yle': {'full': 'yle-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ylg': {'full': 'ylg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yli': {'full': 'yli-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'yll': {'full': 'yll-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ylm': {'full': 'ylm-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yln': {'full': 'yln-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ylo': {'full': 'ylo-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ylr': {'full': 'ylr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ylu': {'full': 'ylu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yly': {'full': 'yly-Latn-NC', 'region': 'NC', 'script': 'Latn', 'suppress': False},
        'ymb': {'full': 'ymb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ymc': {'full': 'ymc-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ymd': {'full': 'ymd-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yme': {'full': 'yme-Latn-PE', 'region': 'PE', 'script': 'Latn', 'suppress': False},
        'ymg': {'full': 'ymg-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'ymh': {'full': 'ymh-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ymi': {'full': 'ymi-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ymk': {'full': 'ymk-Latn-MZ', 'region': 'MZ', 'script': 'Latn', 'suppress': False},
        'ymk-Arab': {'full': 'ymk-Arab-MZ', 'region': 'MZ', 'script': 'Arab', 'suppress': False},
        'yml': {'full': 'yml-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ymm': {'full': 'ymm-Latn-SO', 'region': 'SO', 'script': 'Latn', 'suppress': False},
        'ymn': {'full': 'ymn-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'ymo': {'full': 'ymo-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ymp': {'full': 'ymp-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ymq': {'full': 'ymq-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ymr': {'full': 'ymr-Zyyy-IN', 'region': 'IN', 'script': 'Zyyy', 'suppress': False},
        'yms': {'full': 'yms-Zyyy-TR', 'region': 'TR', 'script': 'Zyyy', 'suppress': False},
        'ymx': {'full': 'ymx-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ymz': {'full': 'ymz-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yna': {'full': 'yna-Plrd-CN', 'region': 'CN', 'script': 'Plrd', 'suppress': False},
        'ynd': {'full': 'ynd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'yne': {'full': 'yne-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yng': {'full': 'yng-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'ynk': {'full': 'ynk-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'ynl': {'full': 'ynl-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ynn': {'full': 'ynn-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'yno': {'full': 'yno-Zyyy-TH', 'region': 'TH', 'script': 'Zyyy', 'suppress': False},
        'ynq': {'full': 'ynq-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'yns': {'full': 'yns-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'ynu': {'full': 'ynu-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'yo': {'full': 'yo-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'yo-Arab': {'full': 'yo-Arab-NG', 'region': 'NG', 'script': 'Arab', 'suppress': False},
        'yo-BJ': {'full': 'yo-Latn-BJ', 'region': 'BJ', 'script': 'Latn', 'suppress': False},
        'yo-Brai': {'full': 'yo-Brai-NG', 'region': 'NG', 'script': 'Brai', 'suppress': False},
        'yob': {'full': 'yob-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yog': {'full': 'yog-Latn-PH', 'region': 'PH', 'script': 'Latn', 'suppress': False},
        'yoi': {'full': 'yoi-Zyyy-JP', 'region': 'JP', 'script': 'Zyyy', 'suppress': False},
        'yok': {'full': 'yok-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'yol': {'full': 'yol-Zyyy-GB', 'region': 'GB', 'script': 'Zyyy', 'suppress': False},
        'yom': {'full': 'yom-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'yon': {'full': 'yon-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yot': {'full': 'yot-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'yox': {'full': 'yox-Zyyy-JP', 'region': 'JP', 'script': 'Zyyy', 'suppress': False},
        'yoy': {'full': 'yoy-Zyyy-TH', 'region': 'TH', 'script': 'Zyyy', 'suppress': False},
        'ypa': {'full': 'ypa-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ypb': {'full': 'ypb-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ypg': {'full': 'ypg-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yph': {'full': 'yph-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ypm': {'full': 'ypm-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ypn': {'full': 'ypn-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ypo': {'full': 'ypo-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ypp': {'full': 'ypp-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ypz': {'full': 'ypz-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yra': {'full': 'yra-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yrb': {'full': 'yrb-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yre': {'full': 'yre-Latn-CI', 'region': 'CI', 'script': 'Latn', 'suppress': False},
        'yrk': {'full': 'yrk-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'yrl': {'full': 'yrl-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'yrm': {'full': 'yrm-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'yrn': {'full': 'yrn-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yro': {'full': 'yro-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'yrs': {'full': 'yrs-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'yrw': {'full': 'yrw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yry': {'full': 'yry-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ysc': {'full': 'ysc-Zyyy-HU', 'region': 'HU', 'script': 'Zyyy', 'suppress': False},
        'ysd': {'full': 'ysd-Yiii-CN', 'region': 'CN', 'script': 'Yiii', 'suppress': False},
        'ysg': {'full': 'ysg-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ysl': {'full': 'ysl-Zxxx-RS', 'region': 'RS', 'script': 'Zxxx', 'suppress': False},
        'ysn': {'full': 'ysn-Yiii-CN', 'region': 'CN', 'script': 'Yiii', 'suppress': False},
        'yso': {'full': 'yso-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ysp': {'full': 'ysp-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ysr': {'full': 'ysr-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'yss': {'full': 'yss-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ysy': {'full': 'ysy-Plrd-CN', 'region': 'CN', 'script': 'Plrd', 'suppress': False},
        'yta': {'full': 'yta-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ytl': {'full': 'ytl-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ytp': {'full': 'ytp-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ytw': {'full': 'ytw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yty': {'full': 'yty-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'yua': {'full': 'yua-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'yub': {'full': 'yub-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'yuc': {'full': 'yuc-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'yud': {'full': 'yud-Hebr-IL', 'region': 'IL', 'script': 'Hebr', 'suppress': False},
        'yue': {'full': 'yue-Hant-HK', 'region': 'HK', 'script': 'Hant', 'suppress': False},
        'yue-Brai': {'full': 'yue-Brai-HK', 'region': 'HK', 'script': 'Brai', 'suppress': False},
        'yue-CN': {'full': 'yue-Hans-CN', 'region': 'CN', 'script': 'Hans', 'suppress': False},
        'yue-Latn': {'full': 'yue-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'yuf': {'full': 'yuf-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'yug': {'full': 'yug-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'yui': {'full': 'yui-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'yuj': {'full': 'yuj-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yuk': {'full': 'yuk-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'yul': {'full': 'yul-Latn-CF', 'region': 'CF', 'script': 'Latn', 'suppress': False},
        'yum': {'full': 'yum-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'yun': {'full': 'yun-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'yup': {'full': 'yup-Latn-CO', 'region': 'CO', 'script': 'Latn', 'suppress': False},
        'yuq': {'full': 'yuq-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'yur': {'full': 'yur-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'yut': {'full': 'yut-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yuw': {'full': 'yuw-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yux': {'full': 'yux-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'yuy': {'full': 'yuy-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yuz': {'full': 'yuz-Latn-BO', 'region': 'BO', 'script': 'Latn', 'suppress': False},
        'yva': {'full': 'yva-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'yvt': {'full': 'yvt-Latn-VE', 'region': 'VE', 'script': 'Latn', 'suppress': False},
        'ywa': {'full': 'ywa-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'ywg': {'full': 'ywg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ywl': {'full': 'ywl-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ywn': {'full': 'ywn-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'ywq': {'full': 'ywq-Plrd-CN', 'region': 'CN', 'script': 'Plrd', 'suppress': False},
        'ywq-Yiii': {'full': 'ywq-Yiii-CN', 'region': 'CN', 'script': 'Yiii', 'suppress': False},
        'ywr': {'full': 'ywr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'ywt': {'full': 'ywt-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'ywu': {'full': 'ywu-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yww': {'full': 'yww-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'yxa': {'full': 'yxa-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'yxg': {'full': 'yxg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'yxl': {'full': 'yxl-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'yxm': {'full': 'yxm-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'yxu': {'full': 'yxu-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'yxy': {'full': 'yxy-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'yyr': {'full': 'yyr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'yyu': {'full': 'yyu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'yyz': {'full': 'yyz-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yzg': {'full': 'yzg-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'yzk': {'full': 'yzk-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'za': {'full': 'za-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'za-Hani': {'full': 'za-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'za-Hans': {'full': 'za-Hans-CN', 'region': 'CN', 'script': 'Hans', 'suppress': False},
        'zaa': {'full': 'zaa-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zab': {'full': 'zab-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zac': {'full': 'zac-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zad': {'full': 'zad-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zae': {'full': 'zae-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zaf': {'full': 'zaf-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zag': {'full': 'zag-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'zag-Arab': {'full': 'zag-Arab-SD', 'region': 'SD', 'script': 'Arab', 'suppress': False},
        'zag-Zzzz-x-beria': {'full': 'zag-Zzzz-SD-x-beria', 'region': 'SD', 'script': 'Zzzz', 'suppress': False},
        'zah': {'full': 'zah-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'zaj': {'full': 'zaj-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'zak': {'full': 'zak-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'zal': {'full': 'zal-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'zam': {'full': 'zam-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zao': {'full': 'zao-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zap': {'full': 'zap-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zaq': {'full': 'zaq-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zar': {'full': 'zar-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zas': {'full': 'zas-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zat': {'full': 'zat-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zau': {'full': 'zau-Tibt-IN', 'region': 'IN', 'script': 'Tibt', 'suppress': False},
        'zav': {'full': 'zav-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zaw': {'full': 'zaw-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zax': {'full': 'zax-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zay': {'full': 'zay-Latn-ET', 'region': 'ET', 'script': 'Latn', 'suppress': False},
        'zay-Ethi': {'full': 'zay-Ethi-ET', 'region': 'ET', 'script': 'Ethi', 'suppress': False},
        'zaz': {'full': 'zaz-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'zba': {'full': 'zba-Zyyy-001', 'region': '001', 'script': 'Zyyy', 'suppress': False},
        'zbc': {'full': 'zbc-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'zbe': {'full': 'zbe-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'zbl': {'full': 'zbl-Blis-001', 'region': '001', 'script': 'Blis', 'suppress': True},
        'zbt': {'full': 'zbt-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'zbw': {'full': 'zbw-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'zca': {'full': 'zca-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zch': {'full': 'zch-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'zdj': {'full': 'zdj-Arab-KM', 'region': 'KM', 'script': 'Arab', 'suppress': False},
        'zdj-Latn': {'full': 'zdj-Latn-KM', 'region': 'KM', 'script': 'Latn', 'suppress': False},
        'zea': {'full': 'zea-Latn-NL', 'region': 'NL', 'script': 'Latn', 'suppress': False},
        'zeg': {'full': 'zeg-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'zeh': {'full': 'zeh-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'zen': {'full': 'zen-Tfng-MR', 'region': 'MR', 'script': 'Tfng', 'suppress': False},
        'zen-Arab': {'full': 'zen-Arab-MR', 'region': 'MR', 'script': 'Arab', 'suppress': False},
        'zga': {'full': 'zga-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'zgb': {'full': 'zgb-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'zgh': {'full': 'zgh-Tfng-MA', 'region': 'MA', 'script': 'Tfng', 'suppress': False},
        'zgm': {'full': 'zgm-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'zgn': {'full': 'zgn-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'zgr': {'full': 'zgr-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'zh-AU': {'full': 'zh-Hant-AU', 'region': 'AU', 'script': 'Hant', 'suppress': False},
        'zh-BN': {'full': 'zh-Hant-BN', 'region': 'BN', 'script': 'Hant', 'suppress': False},
        'zh-Bopo': {'full': 'zh-Bopo-TW', 'region': 'TW', 'script': 'Bopo', 'suppress': False},
        'zh-Brai': {'full': 'zh-Brai-CN', 'region': 'CN', 'script': 'Brai', 'suppress': False},
        'zh-CN': {'full': 'zh-Hans-CN', 'region': 'CN', 'script': 'Hans', 'suppress': False},
        'zh-GB': {'full': 'zh-Hant-GB', 'region': 'GB', 'script': 'Hant', 'suppress': False},
        'zh-GF': {'full': 'zh-Hant-GF', 'region': 'GF', 'script': 'Hant', 'suppress': False},
        'zh-HK': {'full': 'zh-Hant-HK', 'region': 'HK', 'script': 'Hant', 'suppress': False},
        'zh-Hanb': {'full': 'zh-Hanb-TW', 'region': 'TW', 'script': 'Hanb', 'suppress': False},
        'zh-Hans-HK': {'full': 'zh-Hans-HK', 'region': 'HK', 'script': 'Hans', 'suppress': False},
        'zh-Hans-MO': {'full': 'zh-Hans-MO', 'region': 'MO', 'script': 'Hans', 'suppress': False},
        'zh-ID': {'full': 'zh-Hant-ID', 'region': 'ID', 'script': 'Hant', 'suppress': False},
        'zh-Latn': {'full': 'zh-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'zh-MO': {'full': 'zh-Hant-MO', 'region': 'MO', 'script': 'Hant', 'suppress': False},
        'zh-MY': {'full': 'zh-Hant-MY', 'region': 'MY', 'script': 'Hant', 'suppress': False},
        'zh-PA': {'full': 'zh-Hant-PA', 'region': 'PA', 'script': 'Hant', 'suppress': False},
        'zh-PF': {'full': 'zh-Hant-PF', 'region': 'PF', 'script': 'Hant', 'suppress': False},
        'zh-PH': {'full': 'zh-Hant-PH', 'region': 'PH', 'script': 'Hant', 'suppress': False},
        'zh-Phag': {'full': 'zh-Phag-CN', 'region': 'CN', 'script': 'Phag', 'suppress': False},
        'zh-SG': {'full': 'zh-Hans-SG', 'region': 'SG', 'script': 'Hans', 'suppress': False},
        'zh-SR': {'full': 'zh-Hant-SR', 'region': 'SR', 'script': 'Hant', 'suppress': False},
        'zh-TH': {'full': 'zh-Hant-TH', 'region': 'TH', 'script': 'Hant', 'suppress': False},
        'zh-TW': {'full': 'zh-Hant-TW', 'region': 'TW', 'script': 'Hant', 'suppress': False},
        'zh-US': {'full': 'zh-Hant-US', 'region': 'US', 'script': 'Hant', 'suppress': False},
        'zh-VN': {'full': 'zh-Hant-VN', 'region': 'VN', 'script': 'Hant', 'suppress': False},
        'zhb': {'full': 'zhb-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'zhd-Hani': {'full': 'zhd-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'zhd-Latn': {'full': 'zhd-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'zhi': {'full': 'zhi-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'zhn-Hani': {'full': 'zhn-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'zhn-Latn': {'full': 'zhn-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'zhw': {'full': 'zhw-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'zhx': {'full': 'zhx-Nshu-CN', 'region': 'CN', 'script': 'Nshu', 'suppress': False},
        'zia': {'full': 'zia-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'zib': {'full': 'zib-Zxxx-ZW', 'region': 'ZW', 'script': 'Zxxx', 'suppress': False},
        'zik': {'full': 'zik-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'zil': {'full': 'zil-Latn-GN', 'region': 'GN', 'script': 'Latn', 'suppress': False},
        'zim': {'full': 'zim-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'zin': {'full': 'zin-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'zir': {'full': 'zir-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'ziw': {'full': 'ziw-Latn-TZ', 'region': 'TZ', 'script': 'Latn', 'suppress': False},
        'ziz': {'full': 'ziz-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'zka': {'full': 'zka-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'zkb': {'full': 'zkb-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'zkd': {'full': 'zkd-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'zkg': {'full': 'zkg-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'zkh': {'full': 'zkh-Zyyy-TR', 'region': 'TR', 'script': 'Zyyy', 'suppress': False},
        'zkk': {'full': 'zkk-Zyyy-US', 'region': 'US', 'script': 'Zyyy', 'suppress': False},
        'zkn': {'full': 'zkn-Zyyy-MM', 'region': 'MM', 'script': 'Zyyy', 'suppress': False},
        'zko': {'full': 'zko-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'zkp': {'full': 'zkp-Latn-BR', 'region': 'BR', 'script': 'Latn', 'suppress': False},
        'zkr': {'full': 'zkr-Zyyy-CN', 'region': 'CN', 'script': 'Zyyy', 'suppress': False},
        'zkt-Kitl': {'full': 'zkt-Kitl-CN', 'region': 'CN', 'script': 'Kitl', 'suppress': False},
        'zkt-Kits': {'full': 'zkt-Kits-CN', 'region': 'CN', 'script': 'Kits', 'suppress': False},
        'zku': {'full': 'zku-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'zkv': {'full': 'zkv-Zyyy-LV', 'region': 'LV', 'script': 'Zyyy', 'suppress': False},
        'zkz': {'full': 'zkz-Cyrl-RU', 'region': 'RU', 'script': 'Cyrl', 'suppress': False},
        'zlj': {'full': 'zlj-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'zlj-Latn': {'full': 'zlj-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'zlm': {'full': 'zlm-Latn-TG', 'region': 'TG', 'script': 'Latn', 'suppress': False},
        'zlm-Arab': {'full': 'zlm-Arab-MY', 'region': 'MY', 'script': 'Arab', 'suppress': False},
        'zln': {'full': 'zln-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'zlq': {'full': 'zlq-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'zma': {'full': 'zma-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'zmb': {'full': 'zmb-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'zmc': {'full': 'zmc-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'zmd': {'full': 'zmd-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'zme': {'full': 'zme-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'zmf': {'full': 'zmf-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'zmg': {'full': 'zmg-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'zmh': {'full': 'zmh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'zmi': {'full': 'zmi-Latn-MY', 'region': 'MY', 'script': 'Latn', 'suppress': False},
        'zmj': {'full': 'zmj-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'zmk': {'full': 'zmk-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'zml': {'full': 'zml-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'zmm': {'full': 'zmm-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'zmn': {'full': 'zmn-Latn-GA', 'region': 'GA', 'script': 'Latn', 'suppress': False},
        'zmo': {'full': 'zmo-Latn-SD', 'region': 'SD', 'script': 'Latn', 'suppress': False},
        'zmp': {'full': 'zmp-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'zmq': {'full': 'zmq-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'zmr': {'full': 'zmr-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'zms': {'full': 'zms-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'zmt': {'full': 'zmt-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'zmu': {'full': 'zmu-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'zmv': {'full': 'zmv-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'zmw': {'full': 'zmw-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'zmx': {'full': 'zmx-Latn-CG', 'region': 'CG', 'script': 'Latn', 'suppress': False},
        'zmy': {'full': 'zmy-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'zmz': {'full': 'zmz-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'zna': {'full': 'zna-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'zne': {'full': 'zne-Latn-CD', 'region': 'CD', 'script': 'Latn', 'suppress': False},
        'zne-Arab': {'full': 'zne-Arab-SS', 'region': 'SS', 'script': 'Arab', 'suppress': False},
        'zng': {'full': 'zng-Latn-VN', 'region': 'VN', 'script': 'Latn', 'suppress': False},
        'znk': {'full': 'znk-Latn-AU', 'region': 'AU', 'script': 'Latn', 'suppress': False},
        'zns': {'full': 'zns-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'zoc': {'full': 'zoc-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zoh': {'full': 'zoh-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zom': {'full': 'zom-Latn-IN', 'region': 'IN', 'script': 'Latn', 'suppress': False},
        'zoo': {'full': 'zoo-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zoq': {'full': 'zoq-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zor': {'full': 'zor-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zos': {'full': 'zos-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpa': {'full': 'zpa-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpb': {'full': 'zpb-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpc': {'full': 'zpc-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpd': {'full': 'zpd-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpe': {'full': 'zpe-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpf': {'full': 'zpf-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpg': {'full': 'zpg-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zph': {'full': 'zph-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpi': {'full': 'zpi-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpj': {'full': 'zpj-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpk': {'full': 'zpk-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpl': {'full': 'zpl-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpm': {'full': 'zpm-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpn': {'full': 'zpn-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpo': {'full': 'zpo-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpp': {'full': 'zpp-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpq': {'full': 'zpq-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpr': {'full': 'zpr-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zps': {'full': 'zps-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpt': {'full': 'zpt-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpu': {'full': 'zpu-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpv': {'full': 'zpv-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpw': {'full': 'zpw-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpx': {'full': 'zpx-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpy': {'full': 'zpy-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zpz': {'full': 'zpz-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zqe': {'full': 'zqe-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'zqe-Latn': {'full': 'zqe-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'zra': {'full': 'zra-Zyyy-KR', 'region': 'KR', 'script': 'Zyyy', 'suppress': False},
        'zrg-Orya': {'full': 'zrg-Orya-IN', 'region': 'IN', 'script': 'Orya', 'suppress': False},
        'zrg-Telu': {'full': 'zrg-Telu-IN', 'region': 'IN', 'script': 'Telu', 'suppress': False},
        'zrn': {'full': 'zrn-Latn-TD', 'region': 'TD', 'script': 'Latn', 'suppress': False},
        'zro': {'full': 'zro-Latn-EC', 'region': 'EC', 'script': 'Latn', 'suppress': False},
        'zrp': {'full': 'zrp-Zyyy-FR', 'region': 'FR', 'script': 'Zyyy', 'suppress': False},
        'zrs': {'full': 'zrs-Latn-ID', 'region': 'ID', 'script': 'Latn', 'suppress': False},
        'zsa': {'full': 'zsa-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'zsk': {'full': 'zsk-Zyyy-TR', 'region': 'TR', 'script': 'Zyyy', 'suppress': False},
        'zsl': {'full': 'zsl-Zxxx-ZM', 'region': 'ZM', 'script': 'Zxxx', 'suppress': False},
        'zsr': {'full': 'zsr-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zsu': {'full': 'zsu-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'zte': {'full': 'zte-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ztg': {'full': 'ztg-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ztl': {'full': 'ztl-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ztm': {'full': 'ztm-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ztn': {'full': 'ztn-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ztp': {'full': 'ztp-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ztq': {'full': 'ztq-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zts': {'full': 'zts-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ztt': {'full': 'ztt-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ztu': {'full': 'ztu-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'ztx': {'full': 'ztx-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zty': {'full': 'zty-Latn-MX', 'region': 'MX', 'script': 'Latn', 'suppress': False},
        'zu': {'full': 'zu-Latn-ZA', 'region': 'ZA', 'script': 'Latn', 'suppress': True},
        'zu-Brai': {'full': 'zu-Brai-ZA', 'region': 'ZA', 'script': 'Brai', 'suppress': False},
        'zua': {'full': 'zua-Latn-NG', 'region': 'NG', 'script': 'Latn', 'suppress': False},
        'zuh': {'full': 'zuh-Latn-PG', 'region': 'PG', 'script': 'Latn', 'suppress': False},
        'zum': {'full': 'zum-Zyyy-OM', 'region': 'OM', 'script': 'Zyyy', 'suppress': False},
        'zun': {'full': 'zun-Latn-US', 'region': 'US', 'script': 'Latn', 'suppress': False},
        'zuy': {'full': 'zuy-Latn-CM', 'region': 'CM', 'script': 'Latn', 'suppress': False},
        'zwa': {'full': 'zwa-Zyyy-ET', 'region': 'ET', 'script': 'Zyyy', 'suppress': False},
        'zxx': {'full': 'zxx-Zyyy-001', 'region': '001', 'script': 'Zyyy', 'suppress': False},
        'zyg': {'full': 'zyg-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'zyg-Nshu': {'full': 'zyg-Nshu-CN', 'region': 'CN', 'script': 'Nshu', 'suppress': False},
        'zyj': {'full': 'zyj-Latn-CN', 'region': 'CN', 'script': 'Latn', 'suppress': False},
        'zyj-Hani': {'full': 'zyj-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'zyn': {'full': 'zyn-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False},
        'zyp': {'full': 'zyp-Latn-MM', 'region': 'MM', 'script': 'Latn', 'suppress': False},
        'zza': {'full': 'zza-Latn-TR', 'region': 'TR', 'script': 'Latn', 'suppress': False},
        'zza-Arab': {'full': 'zza-Arab-TR', 'region': 'TR', 'script': 'Arab', 'suppress': False},
        'zzj': {'full': 'zzj-Hani-CN', 'region': 'CN', 'script': 'Hani', 'suppress': False} }

    __allTags = { 'aa': 'aa',
        'aa-Latn-ET': 'aa',
        'aa-ET': 'aa',
        'aa-Latn': 'aa',
        'aa-Arab': 'aa-Arab',
        'aa-Arab-ET': 'aa-Arab',
        'aa-DJ': 'aa-DJ',
        'aa-Latn-DJ': 'aa-DJ',
        'aa-ER': 'aa-ER',
        'aa-Latn-ER': 'aa-ER',
        'aa-Ethi': 'aa-Ethi',
        'aa-Ethi-ET': 'aa-Ethi',
        'aaa': 'aaa',
        'aaa-Latn-NG': 'aaa',
        'aaa-Latn': 'aaa',
        'aaa-NG': 'aaa',
        'aab': 'aab',
        'aab-Latn-NG': 'aab',
        'aab-Latn': 'aab',
        'aab-NG': 'aab',
        'aac': 'aac',
        'aac-Latn-PG': 'aac',
        'aac-Latn': 'aac',
        'aac-PG': 'aac',
        'aad': 'aad',
        'aad-Latn-PG': 'aad',
        'aad-Latn': 'aad',
        'aad-PG': 'aad',
        'aae': 'aae',
        'aae-Latn-IT': 'aae',
        'aae-IT': 'aae',
        'aae-Latn': 'aae',
        'aae-Grek': 'aae-Grek',
        'aae-Grek-IT': 'aae-Grek',
        'aaf': 'aaf',
        'aaf-Zyyy-IN': 'aaf',
        'aaf-IN': 'aaf',
        'aaf-Zyyy': 'aaf',
        'aag': 'aag',
        'aag-Latn-PG': 'aag',
        'aag-Latn': 'aag',
        'aag-PG': 'aag',
        'aah': 'aah',
        'aah-Latn-PG': 'aah',
        'aah-Latn': 'aah',
        'aah-PG': 'aah',
        'aai': 'aai',
        'aai-Latn-PG': 'aai',
        'aai-Latn': 'aai',
        'aai-PG': 'aai',
        'aak': 'aak',
        'aak-Latn-PG': 'aak',
        'aak-Latn': 'aak',
        'aak-PG': 'aak',
        'aal': 'aal',
        'aal-Latn-CM': 'aal',
        'aal-CM': 'aal',
        'aal-Latn': 'aal',
        'aan': 'aan',
        'aan-Latn-BR': 'aan',
        'aan-BR': 'aan',
        'aan-Latn': 'aan',
        'aao': 'aao',
        'aao-Arab-DZ': 'aao',
        'aao-Arab': 'aao',
        'aao-DZ': 'aao',
        'ar-aao': 'aao',
        'ar-aao-DZ': 'aao',
        'aap': 'aap',
        'aap-Latn-BR': 'aap',
        'aap-BR': 'aap',
        'aap-Latn': 'aap',
        'aaq': 'aaq',
        'aaq-Zyyy-US': 'aaq',
        'aaq-US': 'aaq',
        'aaq-Zyyy': 'aaq',
        'aas': 'aas',
        'aas-Latn-TZ': 'aas',
        'aam': 'aas',
        'aam-Latn': 'aas',
        'aam-Latn-TZ': 'aas',
        'aam-TZ': 'aas',
        'aas-Latn': 'aas',
        'aas-TZ': 'aas',
        'aat': 'aat',
        'aat-Grek-GR': 'aat',
        'aat-GR': 'aat',
        'aat-Grek': 'aat',
        'aau': 'aau',
        'aau-Latn-PG': 'aau',
        'aau-Latn': 'aau',
        'aau-PG': 'aau',
        'aaw': 'aaw',
        'aaw-Latn-PG': 'aaw',
        'aaw-Latn': 'aaw',
        'aaw-PG': 'aaw',
        'aax': 'aax',
        'aax-Latn-ID': 'aax',
        'aax-ID': 'aax',
        'aax-Latn': 'aax',
        'aaz': 'aaz',
        'aaz-Latn-ID': 'aaz',
        'aaz-ID': 'aaz',
        'aaz-Latn': 'aaz',
        'ab': 'ab',
        'ab-Cyrl-GE': 'ab',
        'ab-Cyrl': 'ab',
        'ab-GE': 'ab',
        'ab-Geor': 'ab-Geor',
        'ab-Geor-GE': 'ab-Geor',
        'aba': 'aba',
        'aba-Latn-CI': 'aba',
        'aba-CI': 'aba',
        'aba-Latn': 'aba',
        'abb': 'abb',
        'abb-Latn-CM': 'abb',
        'abb-CM': 'abb',
        'abb-Latn': 'abb',
        'abc': 'abc',
        'abc-Latn-PH': 'abc',
        'abc-Latn': 'abc',
        'abc-PH': 'abc',
        'abd': 'abd',
        'abd-Latn-PH': 'abd',
        'abd-Latn': 'abd',
        'abd-PH': 'abd',
        'abe': 'abe',
        'abe-Latn-CA': 'abe',
        'abe-CA': 'abe',
        'abe-Latn': 'abe',
        'abf': 'abf',
        'abf-Latn-MY': 'abf',
        'abf-Latn': 'abf',
        'abf-MY': 'abf',
        'abg': 'abg',
        'abg-Latn-PG': 'abg',
        'abg-Latn': 'abg',
        'abg-PG': 'abg',
        'abh': 'abh',
        'abh-Arab-TJ': 'abh',
        'abh-Arab': 'abh',
        'abh-TJ': 'abh',
        'ar-abh': 'abh',
        'ar-abh-TJ': 'abh',
        'abi': 'abi',
        'abi-Latn-CI': 'abi',
        'abi-CI': 'abi',
        'abi-Latn': 'abi',
        'abj': 'abj',
        'abj-Zyyy-IN': 'abj',
        'abj-IN': 'abj',
        'abj-Zyyy': 'abj',
        'abl': 'abl',
        'abl-Rjng-ID': 'abl',
        'abl-ID': 'abl',
        'abl-Rjng': 'abl',
        'abm': 'abm',
        'abm-Latn-NG': 'abm',
        'abm-Latn': 'abm',
        'abm-NG': 'abm',
        'abn': 'abn',
        'abn-Latn-NG': 'abn',
        'abn-Latn': 'abn',
        'abn-NG': 'abn',
        'abo': 'abo',
        'abo-Latn-NG': 'abo',
        'abo-Latn': 'abo',
        'abo-NG': 'abo',
        'abp': 'abp',
        'abp-Latn-PH': 'abp',
        'abp-Latn': 'abp',
        'abp-PH': 'abp',
        'abq-Cyrl': 'abq-Cyrl',
        'abq-Cyrl-RU': 'abq-Cyrl',
        'abq': 'abq-Cyrl',
        'abq-RU': 'abq-Cyrl',
        'abq-Latn': 'abq-Latn',
        'abq-Latn-TR': 'abq-Latn',
        'abq-TR': 'abq-Latn',
        'abr': 'abr',
        'abr-Latn-GH': 'abr',
        'abr-GH': 'abr',
        'abr-Latn': 'abr',
        'abs': 'abs',
        'abs-Latn-ID': 'abs',
        'abs-ID': 'abs',
        'abs-Latn': 'abs',
        'abt': 'abt',
        'abt-Latn-PG': 'abt',
        'abt-Latn': 'abt',
        'abt-PG': 'abt',
        'abt-x-maprik': 'abt-x-maprik',
        'abt-Latn-PG-x-maprik': 'abt-x-maprik',
        'abt-Latn-x-maprik': 'abt-x-maprik',
        'abt-PG-x-maprik': 'abt-x-maprik',
        'abt-x-woserak': 'abt-x-woserak',
        'abt-Latn-PG-x-woserak': 'abt-x-woserak',
        'abt-Latn-x-woserak': 'abt-x-woserak',
        'abt-PG-x-woserak': 'abt-x-woserak',
        'abu': 'abu',
        'abu-Latn-CI': 'abu',
        'abu-CI': 'abu',
        'abu-Latn': 'abu',
        'abv': 'abv',
        'abv-Arab-BH': 'abv',
        'abv-Arab': 'abv',
        'abv-BH': 'abv',
        'ar-abv': 'abv',
        'ar-abv-BH': 'abv',
        'abw': 'abw',
        'abw-Latn-PG': 'abw',
        'abw-Latn': 'abw',
        'abw-PG': 'abw',
        'abx': 'abx',
        'abx-Latn-PH': 'abx',
        'abx-Latn': 'abx',
        'abx-PH': 'abx',
        'aby': 'aby',
        'aby-Latn-PG': 'aby',
        'aby-Latn': 'aby',
        'aby-PG': 'aby',
        'abz': 'abz',
        'abz-Latn-ID': 'abz',
        'abz-ID': 'abz',
        'abz-Latn': 'abz',
        'aca': 'aca',
        'aca-Latn-CO': 'aca',
        'aca-CO': 'aca',
        'aca-Latn': 'aca',
        'acb': 'acb',
        'acb-Latn-NG': 'acb',
        'acb-Latn': 'acb',
        'acb-NG': 'acb',
        'acd': 'acd',
        'acd-Latn-GH': 'acd',
        'acd-GH': 'acd',
        'acd-Latn': 'acd',
        'ace': 'ace',
        'ace-Latn-ID': 'ace',
        'ace-ID': 'ace',
        'ace-Latn': 'ace',
        'ace-Arab': 'ace-Arab',
        'ace-Arab-ID': 'ace-Arab',
        'acf': 'acf',
        'acf-Latn-LC': 'acf',
        'acf-LC': 'acf',
        'acf-Latn': 'acf',
        'ach': 'ach',
        'ach-Latn-UG': 'ach',
        'ach-Latn': 'ach',
        'ach-UG': 'ach',
        'aci': 'aci',
        'aci-Zyyy-IN': 'aci',
        'aci-IN': 'aci',
        'aci-Zyyy': 'aci',
        'ack': 'ack',
        'ack-Zyyy-IN': 'ack',
        'ack-IN': 'ack',
        'ack-Zyyy': 'ack',
        'acl': 'acl',
        'acl-Zyyy-IN': 'acl',
        'acl-IN': 'acl',
        'acl-Zyyy': 'acl',
        'acm': 'acm',
        'acm-Arab-IQ': 'acm',
        'acm-Arab': 'acm',
        'acm-IQ': 'acm',
        'ar-acm': 'acm',
        'ar-acm-IQ': 'acm',
        'acn': 'acn',
        'acn-Latn-CN': 'acn',
        'acn-CN': 'acn',
        'acn-Latn': 'acn',
        'xia': 'acn',
        'xia-CN': 'acn',
        'xia-Latn': 'acn',
        'xia-Latn-CN': 'acn',
        'acp': 'acp',
        'acp-Latn-NG': 'acp',
        'acp-Latn': 'acp',
        'acp-NG': 'acp',
        'acq': 'acq',
        'acq-Arab-YE': 'acq',
        'acq-Arab': 'acq',
        'acq-YE': 'acq',
        'ar-acq': 'acq',
        'ar-acq-YE': 'acq',
        'acr': 'acr',
        'acr-Latn-GT': 'acr',
        'acr-GT': 'acr',
        'acr-Latn': 'acr',
        'acr-x-cubulco': 'acr-x-cubulco',
        'acr-Latn-GT-x-cubulco': 'acr-x-cubulco',
        'acr-GT-x-cubulco': 'acr-x-cubulco',
        'acr-Latn-x-cubulco': 'acr-x-cubulco',
        'acr-x-rabinal': 'acr-x-rabinal',
        'acr-Latn-GT-x-rabinal': 'acr-x-rabinal',
        'acr-GT-x-rabinal': 'acr-x-rabinal',
        'acr-Latn-x-rabinal': 'acr-x-rabinal',
        'acs': 'acs',
        'acs-Latn-BR': 'acs',
        'acs-BR': 'acs',
        'acs-Latn': 'acs',
        'act': 'act',
        'act-Latn-NL': 'act',
        'act-Latn': 'act',
        'act-NL': 'act',
        'acu': 'acu',
        'acu-Latn-EC': 'acu',
        'acu-EC': 'acu',
        'acu-Latn': 'acu',
        'acv': 'acv',
        'acv-Latn-US': 'acv',
        'acv-Latn': 'acv',
        'acv-US': 'acv',
        'acw': 'acw',
        'acw-Arab-SA': 'acw',
        'acw-Arab': 'acw',
        'acw-SA': 'acw',
        'ar-acw': 'acw',
        'ar-acw-SA': 'acw',
        'acx': 'acx',
        'acx-Arab-OM': 'acx',
        'acx-Arab': 'acx',
        'acx-OM': 'acx',
        'ar-acx': 'acx',
        'ar-acx-OM': 'acx',
        'acy': 'acy',
        'acy-Latn-CY': 'acy',
        'acy-CY': 'acy',
        'acy-Latn': 'acy',
        'ar-acy': 'acy',
        'ar-acy-CY': 'acy',
        'acy-Arab': 'acy-Arab',
        'acy-Arab-CY': 'acy-Arab',
        'acy-Grek': 'acy-Grek',
        'acy-Grek-CY': 'acy-Grek',
        'acz': 'acz',
        'acz-Latn-SD': 'acz',
        'acz-Latn': 'acz',
        'acz-SD': 'acz',
        'ada': 'ada',
        'ada-Latn-GH': 'ada',
        'ada-GH': 'ada',
        'ada-Latn': 'ada',
        'adb': 'adb',
        'adb-Latn-TL': 'adb',
        'adb-Latn': 'adb',
        'adb-TL': 'adb',
        'add': 'add',
        'add-Latn-CM': 'add',
        'add-CM': 'add',
        'add-Latn': 'add',
        'ade': 'ade',
        'ade-Latn-TG': 'ade',
        'ade-Latn': 'ade',
        'ade-TG': 'ade',
        'adf': 'adf',
        'adf-Arab-OM': 'adf',
        'adf-Arab': 'adf',
        'adf-OM': 'adf',
        'ar-adf': 'adf',
        'ar-adf-OM': 'adf',
        'adg': 'adg',
        'adg-Latn-AU': 'adg',
        'adg-AU': 'adg',
        'adg-Latn': 'adg',
        'adh': 'adh',
        'adh-Latn-UG': 'adh',
        'adh-Latn': 'adh',
        'adh-UG': 'adh',
        'adi': 'adi',
        'adi-Latn-IN': 'adi',
        'adi-IN': 'adi',
        'adi-Latn': 'adi',
        'adi-Tibt': 'adi-Tibt',
        'adi-Tibt-CN': 'adi-Tibt',
        'adi-CN': 'adi-Tibt',
        'adj': 'adj',
        'adj-Latn-CI': 'adj',
        'adj-CI': 'adj',
        'adj-Latn': 'adj',
        'adl': 'adl',
        'adl-Latn-IN': 'adl',
        'adl-IN': 'adl',
        'adl-Latn': 'adl',
        'adn': 'adn',
        'adn-Latn-ID': 'adn',
        'adn-ID': 'adn',
        'adn-Latn': 'adn',
        'ado': 'ado',
        'ado-Latn-PG': 'ado',
        'ado-Latn': 'ado',
        'ado-PG': 'ado',
        'adq': 'adq',
        'adq-Latn-GH': 'adq',
        'adq-GH': 'adq',
        'adq-Latn': 'adq',
        'adr': 'adr',
        'adr-Latn-ID': 'adr',
        'adr-ID': 'adr',
        'adr-Latn': 'adr',
        'ads': 'ads',
        'ads-Latn-GH': 'ads',
        'ads-GH': 'ads',
        'ads-Latn': 'ads',
        'sgn-ads': 'ads',
        'sgn-ads-GH': 'ads',
        'ads-Zxxx': 'ads-Zxxx',
        'ads-Zxxx-GH': 'ads-Zxxx',
        'adt': 'adt',
        'adt-Latn-AU': 'adt',
        'adt-AU': 'adt',
        'adt-Latn': 'adt',
        'adu': 'adu',
        'adu-Latn-NG': 'adu',
        'adu-Latn': 'adu',
        'adu-NG': 'adu',
        'adw': 'adw',
        'adw-Latn-BR': 'adw',
        'adw-BR': 'adw',
        'adw-Latn': 'adw',
        'adx': 'adx',
        'adx-Tibt-CN': 'adx',
        'adx-CN': 'adx',
        'adx-Tibt': 'adx',
        'pcr': 'adx',
        'pcr-CN': 'adx',
        'pcr-Tibt': 'adx',
        'pcr-Tibt-CN': 'adx',
        'ady': 'ady',
        'ady-Cyrl-RU': 'ady',
        'ady-Cyrl': 'ady',
        'ady-RU': 'ady',
        'ady-Arab': 'ady-Arab',
        'ady-Arab-RU': 'ady-Arab',
        'ady-Latn': 'ady-Latn',
        'ady-Latn-TR': 'ady-Latn',
        'ady-TR': 'ady-Latn',
        'adz': 'adz',
        'adz-Latn-PG': 'adz',
        'adz-Latn': 'adz',
        'adz-PG': 'adz',
        'ae': 'ae',
        'ae-Avst-IR': 'ae',
        'ae-Avst': 'ae',
        'ae-IR': 'ae',
        'ae-Arab': 'ae-Arab',
        'ae-Arab-IR': 'ae-Arab',
        'ae-Gujr': 'ae-Gujr',
        'ae-Gujr-IR': 'ae-Gujr',
        'aea': 'aea',
        'aea-Latn-AU': 'aea',
        'aea-AU': 'aea',
        'aea-Latn': 'aea',
        'aeb': 'aeb',
        'aeb-Arab-TN': 'aeb',
        'aeb-Arab': 'aeb',
        'aeb-TN': 'aeb',
        'ar-aeb': 'aeb',
        'ar-aeb-TN': 'aeb',
        'aeb-Latn': 'aeb-Latn',
        'aeb-Latn-TN': 'aeb-Latn',
        'aec': 'aec',
        'aec-Arab-EG': 'aec',
        'aec-Arab': 'aec',
        'aec-EG': 'aec',
        'ar-aec': 'aec',
        'ar-aec-EG': 'aec',
        'aed': 'aed',
        'aed-Zxxx-AR': 'aed',
        'aed-AR': 'aed',
        'aed-Zxxx': 'aed',
        'sgn-aed': 'aed',
        'sgn-aed-AR': 'aed',
        'aee': 'aee',
        'aee-Arab-AF': 'aee',
        'aee-AF': 'aee',
        'aee-Arab': 'aee',
        'aek': 'aek',
        'aek-Latn-NC': 'aek',
        'aek-Latn': 'aek',
        'aek-NC': 'aek',
        'ael': 'ael',
        'ael-Latn-CM': 'ael',
        'ael-CM': 'ael',
        'ael-Latn': 'ael',
        'aem': 'aem',
        'aem-Latn-VN': 'aem',
        'aem-Latn': 'aem',
        'aem-VN': 'aem',
        'aen': 'aen',
        'aen-Zxxx-AM': 'aen',
        'aen-AM': 'aen',
        'aen-Zxxx': 'aen',
        'sgn-aen': 'aen',
        'sgn-aen-AM': 'aen',
        'aeq': 'aeq',
        'aeq-Arab-PK': 'aeq',
        'aeq-Arab': 'aeq',
        'aeq-PK': 'aeq',
        'aer': 'aer',
        'aer-Latn-AU': 'aer',
        'aer-AU': 'aer',
        'aer-Latn': 'aer',
        'aes': 'aes',
        'aes-Zyyy-US': 'aes',
        'aes-US': 'aes',
        'aes-Zyyy': 'aes',
        'aeu': 'aeu',
        'aeu-Latn-CN': 'aeu',
        'aeu-CN': 'aeu',
        'aeu-Latn': 'aeu',
        'aew': 'aew',
        'aew-Latn-PG': 'aew',
        'aew-Latn': 'aew',
        'aew-PG': 'aew',
        'aey': 'aey',
        'aey-Latn-PG': 'aey',
        'aey-Latn': 'aey',
        'aey-PG': 'aey',
        'aez': 'aez',
        'aez-Latn-PG': 'aez',
        'aez-Latn': 'aez',
        'aez-PG': 'aez',
        'af': 'af',
        'af-Latn-ZA': 'af',
        'af-Latn': 'af',
        'af-ZA': 'af',
        'af-Arab': 'af-Arab',
        'af-Arab-ZA': 'af-Arab',
        'af-Brai': 'af-Brai',
        'af-Brai-ZA': 'af-Brai',
        'af-NA': 'af-NA',
        'af-Latn-NA': 'af-NA',
        'afb': 'afb',
        'afb-Arab-KW': 'afb',
        'afb-Arab': 'afb',
        'afb-KW': 'afb',
        'ar-afb': 'afb',
        'ar-afb-KW': 'afb',
        'afd': 'afd',
        'afd-Latn-PG': 'afd',
        'afd-Latn': 'afd',
        'afd-PG': 'afd',
        'afe': 'afe',
        'afe-Latn-NG': 'afe',
        'afe-Latn': 'afe',
        'afe-NG': 'afe',
        'afg': 'afg',
        'afg-Zxxx-AF': 'afg',
        'afg-AF': 'afg',
        'afg-Zxxx': 'afg',
        'sgn-afg': 'afg',
        'sgn-afg-AF': 'afg',
        'afh': 'afh',
        'afh-Latn-GH': 'afh',
        'afh-GH': 'afh',
        'afh-Latn': 'afh',
        'afi': 'afi',
        'afi-Latn-PG': 'afi',
        'afi-Latn': 'afi',
        'afi-PG': 'afi',
        'afk': 'afk',
        'afk-Latn-PG': 'afk',
        'afk-Latn': 'afk',
        'afk-PG': 'afk',
        'afn': 'afn',
        'afn-Latn-NG': 'afn',
        'afn-Latn': 'afn',
        'afn-NG': 'afn',
        'afo': 'afo',
        'afo-Latn-NG': 'afo',
        'afo-Latn': 'afo',
        'afo-NG': 'afo',
        'afp': 'afp',
        'afp-Latn-PG': 'afp',
        'afp-Latn': 'afp',
        'afp-PG': 'afp',
        'afs': 'afs',
        'afs-Latn-MX': 'afs',
        'afs-Latn': 'afs',
        'afs-MX': 'afs',
        'aft': 'aft',
        'aft-Zyyy-SD': 'aft',
        'aft-SD': 'aft',
        'aft-Zyyy': 'aft',
        'afu': 'afu',
        'afu-Latn-GH': 'afu',
        'afu-GH': 'afu',
        'afu-Latn': 'afu',
        'afz': 'afz',
        'afz-Latn-ID': 'afz',
        'afz-ID': 'afz',
        'afz-Latn': 'afz',
        'aga': 'aga',
        'aga-Latn-PE': 'aga',
        'aga-Latn': 'aga',
        'aga-PE': 'aga',
        'agb': 'agb',
        'agb-Latn-NG': 'agb',
        'agb-Latn': 'agb',
        'agb-NG': 'agb',
        'agc': 'agc',
        'agc-Latn-NG': 'agc',
        'agc-Latn': 'agc',
        'agc-NG': 'agc',
        'agd': 'agd',
        'agd-Latn-PG': 'agd',
        'agd-Latn': 'agd',
        'agd-PG': 'agd',
        'age': 'age',
        'age-Latn-PG': 'age',
        'age-Latn': 'age',
        'age-PG': 'age',
        'agf': 'agf',
        'agf-Latn-ID': 'agf',
        'agf-ID': 'agf',
        'agf-Latn': 'agf',
        'agg': 'agg',
        'agg-Latn-PG': 'agg',
        'agg-Latn': 'agg',
        'agg-PG': 'agg',
        'agh': 'agh',
        'agh-Latn-CD': 'agh',
        'agh-CD': 'agh',
        'agh-Latn': 'agh',
        'agi': 'agi',
        'agi-Zyyy-IN': 'agi',
        'agi-IN': 'agi',
        'agi-Zyyy': 'agi',
        'agj': 'agj',
        'agj-Ethi-ET': 'agj',
        'agj-ET': 'agj',
        'agj-Ethi': 'agj',
        'agj-Arab': 'agj-Arab',
        'agj-Arab-ET': 'agj-Arab',
        'agk': 'agk',
        'agk-Latn-PH': 'agk',
        'agk-Latn': 'agk',
        'agk-PH': 'agk',
        'agl': 'agl',
        'agl-Latn-PG': 'agl',
        'agl-Latn': 'agl',
        'agl-PG': 'agl',
        'agm': 'agm',
        'agm-Latn-PG': 'agm',
        'agm-Latn': 'agm',
        'agm-PG': 'agm',
        'agn': 'agn',
        'agn-Latn-PH': 'agn',
        'agn-Latn': 'agn',
        'agn-PH': 'agn',
        'ago': 'ago',
        'ago-Latn-PG': 'ago',
        'ago-Latn': 'ago',
        'ago-PG': 'ago',
        'agq': 'agq',
        'agq-Latn-CM': 'agq',
        'agq-CM': 'agq',
        'agq-Latn': 'agq',
        'agr': 'agr',
        'agr-Latn-PE': 'agr',
        'agr-Latn': 'agr',
        'agr-PE': 'agr',
        'ags': 'ags',
        'ags-Latn-CM': 'ags',
        'ags-CM': 'ags',
        'ags-Latn': 'ags',
        'agt': 'agt',
        'agt-Latn-PH': 'agt',
        'agt-Latn': 'agt',
        'agt-PH': 'agt',
        'agu': 'agu',
        'agu-Latn-GT': 'agu',
        'agu-GT': 'agu',
        'agu-Latn': 'agu',
        'agv': 'agv',
        'agv-Latn-PH': 'agv',
        'agv-Latn': 'agv',
        'agv-PH': 'agv',
        'agw': 'agw',
        'agw-Latn-SB': 'agw',
        'agw-Latn': 'agw',
        'agw-SB': 'agw',
        'agx': 'agx',
        'agx-Cyrl-RU': 'agx',
        'agx-Cyrl': 'agx',
        'agx-RU': 'agx',
        'agy': 'agy',
        'agy-Latn-PH': 'agy',
        'agy-Latn': 'agy',
        'agy-PH': 'agy',
        'agz': 'agz',
        'agz-Latn-PH': 'agz',
        'agz-Latn': 'agz',
        'agz-PH': 'agz',
        'aha': 'aha',
        'aha-Latn-GH': 'aha',
        'aha-GH': 'aha',
        'aha-Latn': 'aha',
        'ahb': 'ahb',
        'ahb-Latn-VU': 'ahb',
        'ahb-Latn': 'ahb',
        'ahb-VU': 'ahb',
        'ahg': 'ahg',
        'ahg-Ethi-ET': 'ahg',
        'ahg-ET': 'ahg',
        'ahg-Ethi': 'ahg',
        'ahh': 'ahh',
        'ahh-Latn-ID': 'ahh',
        'ahh-ID': 'ahh',
        'ahh-Latn': 'ahh',
        'ahi': 'ahi',
        'ahi-Latn-CI': 'ahi',
        'ahi-CI': 'ahi',
        'ahi-Latn': 'ahi',
        'ahk': 'ahk',
        'ahk-Latn-MM': 'ahk',
        'ahk-Latn': 'ahk',
        'ahk-MM': 'ahk',
        'ahk-Latn-x-louma': 'ahk-Latn-x-louma',
        'ahk-Latn-LA-x-louma': 'ahk-Latn-x-louma',
        'ahk-LA-x-louma': 'ahk-Latn-x-louma',
        'ahk-Mymr': 'ahk-Mymr',
        'ahk-Mymr-MM': 'ahk-Mymr',
        'ahk-TH': 'ahk-TH',
        'ahk-Latn-TH': 'ahk-TH',
        'ahk-Thai': 'ahk-Thai',
        'ahk-Thai-TH': 'ahk-Thai',
        'ahl': 'ahl',
        'ahl-Latn-TG': 'ahl',
        'ahl-Latn': 'ahl',
        'ahl-TG': 'ahl',
        'ahm': 'ahm',
        'ahm-Latn-CI': 'ahm',
        'ahm-CI': 'ahm',
        'ahm-Latn': 'ahm',
        'ahn': 'ahn',
        'ahn-Latn-NG': 'ahn',
        'ahn-Latn': 'ahn',
        'ahn-NG': 'ahn',
        'aho': 'aho',
        'aho-Ahom-IN': 'aho',
        'aho-Ahom': 'aho',
        'aho-IN': 'aho',
        'ahp': 'ahp',
        'ahp-Latn-CI': 'ahp',
        'ahp-CI': 'ahp',
        'ahp-Latn': 'ahp',
        'ahr': 'ahr',
        'ahr-Zyyy-IN': 'ahr',
        'ahr-IN': 'ahr',
        'ahr-Zyyy': 'ahr',
        'ahs': 'ahs',
        'ahs-Latn-NG': 'ahs',
        'ahs-Latn': 'ahs',
        'ahs-NG': 'ahs',
        'aht': 'aht',
        'aht-Latn-US': 'aht',
        'aht-Latn': 'aht',
        'aht-US': 'aht',
        'aia': 'aia',
        'aia-Latn-SB': 'aia',
        'aia-Latn': 'aia',
        'aia-SB': 'aia',
        'aib': 'aib',
        'aib-Zyyy-CN': 'aib',
        'aib-CN': 'aib',
        'aib-Zyyy': 'aib',
        'aic': 'aic',
        'aic-Latn-PG': 'aic',
        'aic-Latn': 'aic',
        'aic-PG': 'aic',
        'aid': 'aid',
        'aid-Latn-AU': 'aid',
        'aid-AU': 'aid',
        'aid-Latn': 'aid',
        'aie': 'aie',
        'aie-Latn-PG': 'aie',
        'aie-Latn': 'aie',
        'aie-PG': 'aie',
        'aif': 'aif',
        'aif-Latn-PG': 'aif',
        'aif-Latn': 'aif',
        'aif-PG': 'aif',
        'aig': 'aig',
        'aig-Latn-AG': 'aig',
        'aig-AG': 'aig',
        'aig-Latn': 'aig',
        'aih': 'aih',
        'aih-Zyyy-CN': 'aih',
        'aih-CN': 'aih',
        'aih-Zyyy': 'aih',
        'aii-Cyrl': 'aii-Cyrl',
        'aii-Cyrl-RU': 'aii-Cyrl',
        'aii-RU': 'aii-Cyrl',
        'aii-Syrc': 'aii-Syrc',
        'aii-Syrc-IQ': 'aii-Syrc',
        'aii-IQ': 'aii-Syrc',
        'aij': 'aij',
        'aij-Hebr-IL': 'aij',
        'aij-Hebr': 'aij',
        'aij-IL': 'aij',
        'aik': 'aik',
        'aik-Latn-NG': 'aik',
        'aik-Latn': 'aik',
        'aik-NG': 'aik',
        'ail': 'ail',
        'ail-Latn-PG': 'ail',
        'ail-Latn': 'ail',
        'ail-PG': 'ail',
        'aim': 'aim',
        'aim-Latn-IN': 'aim',
        'aim-IN': 'aim',
        'aim-Latn': 'aim',
        'ain': 'ain',
        'ain-Kana-JP': 'ain',
        'ain-JP': 'ain',
        'ain-Kana': 'ain',
        'ain-Latn': 'ain-Latn',
        'ain-Latn-JP': 'ain-Latn',
        'aio': 'aio',
        'aio-Mymr-IN': 'aio',
        'aio-IN': 'aio',
        'aio-Mymr': 'aio',
        'aip': 'aip',
        'aip-Latn-ID': 'aip',
        'aip-ID': 'aip',
        'aip-Latn': 'aip',
        'aiq': 'aiq',
        'aiq-Arab-AF': 'aiq',
        'aiq-AF': 'aiq',
        'aiq-Arab': 'aiq',
        'air': 'air',
        'air-Latn-ID': 'air',
        'air-ID': 'air',
        'air-Latn': 'air',
        'ait': 'ait',
        'ait-Latn-BR': 'ait',
        'ait-BR': 'ait',
        'ait-Latn': 'ait',
        'aiw-Arab': 'aiw-Arab',
        'aiw-Arab-ET': 'aiw-Arab',
        'aiw-Ethi': 'aiw-Ethi',
        'aiw-Ethi-ET': 'aiw-Ethi',
        'aiw-Latn': 'aiw-Latn',
        'aiw-Latn-ET': 'aiw-Latn',
        'aix': 'aix',
        'aix-Latn-PG': 'aix',
        'aix-Latn': 'aix',
        'aix-PG': 'aix',
        'aiy': 'aiy',
        'aiy-Latn-CF': 'aiy',
        'aiy-CF': 'aiy',
        'aiy-Latn': 'aiy',
        'aja': 'aja',
        'aja-Latn-SS': 'aja',
        'aja-Latn': 'aja',
        'aja-SS': 'aja',
        'ajg': 'ajg',
        'ajg-Latn-BJ': 'ajg',
        'ajg-BJ': 'ajg',
        'ajg-Latn': 'ajg',
        'aji': 'aji',
        'aji-Latn-NC': 'aji',
        'aji-Latn': 'aji',
        'aji-NC': 'aji',
        'ajn': 'ajn',
        'ajn-Latn-AU': 'ajn',
        'ajn-AU': 'ajn',
        'ajn-Latn': 'ajn',
        'ajp': 'ajp',
        'ajp-Arab-JO': 'ajp',
        'ajp-Arab': 'ajp',
        'ajp-JO': 'ajp',
        'ar-ajp': 'ajp',
        'ar-ajp-JO': 'ajp',
        'ajt': 'ajt',
        'ajt-Arab-TN': 'ajt',
        'ajt-Arab': 'ajt',
        'ajt-TN': 'ajt',
        'ajt-Hebr': 'ajt-Hebr',
        'ajt-Hebr-IL': 'ajt-Hebr',
        'ajt-IL': 'ajt-Hebr',
        'aju-Arab': 'aju-Arab',
        'aju-Arab-MA': 'aju-Arab',
        'aju-MA': 'aju-Arab',
        'ajw': 'ajw',
        'ajw-Latn-NG': 'ajw',
        'ajw-Latn': 'ajw',
        'ajw-NG': 'ajw',
        'ajz': 'ajz',
        'ajz-Latn-IN': 'ajz',
        'ajz-IN': 'ajz',
        'ajz-Latn': 'ajz',
        'ak': 'ak',
        'ak-Latn-GH': 'ak',
        'ak-GH': 'ak',
        'ak-Latn': 'ak',
        'fat': 'ak',
        'fat-GH': 'ak',
        'fat-Latn': 'ak',
        'fat-Latn-GH': 'ak',
        'tw': 'ak',
        'tw-GH': 'ak',
        'tw-Latn': 'ak',
        'tw-Latn-GH': 'ak',
        'ak-Arab': 'ak-Arab',
        'ak-Arab-GH': 'ak-Arab',
        'akb': 'akb',
        'akb-Latn-ID': 'akb',
        'akb-ID': 'akb',
        'akb-Latn': 'akb',
        'akb-Batk': 'akb-Batk',
        'akb-Batk-ID': 'akb-Batk',
        'akc': 'akc',
        'akc-Latn-ID': 'akc',
        'akc-ID': 'akc',
        'akc-Latn': 'akc',
        'akd': 'akd',
        'akd-Latn-NG': 'akd',
        'akd-Latn': 'akd',
        'akd-NG': 'akd',
        'ake': 'ake',
        'ake-Latn-GY': 'ake',
        'ake-GY': 'ake',
        'ake-Latn': 'ake',
        'akf': 'akf',
        'akf-Latn-NG': 'akf',
        'akf-Latn': 'akf',
        'akf-NG': 'akf',
        'akg': 'akg',
        'akg-Latn-ID': 'akg',
        'akg-ID': 'akg',
        'akg-Latn': 'akg',
        'akh': 'akh',
        'akh-Latn-PG': 'akh',
        'akh-Latn': 'akh',
        'akh-PG': 'akh',
        'aki': 'aki',
        'aki-Latn-PG': 'aki',
        'aki-Latn': 'aki',
        'aki-PG': 'aki',
        'akj': 'akj',
        'akj-Zyyy-IN': 'akj',
        'akj-IN': 'akj',
        'akj-Zyyy': 'akj',
        'akk': 'akk',
        'akk-Xsux-IQ': 'akk',
        'akk-IQ': 'akk',
        'akk-Xsux': 'akk',
        'akl': 'akl',
        'akl-Latn-PH': 'akl',
        'akl-Latn': 'akl',
        'akl-PH': 'akl',
        'akm': 'akm',
        'akm-Zyyy-IN': 'akm',
        'akm-IN': 'akm',
        'akm-Zyyy': 'akm',
        'ako': 'ako',
        'ako-Latn-SR': 'ako',
        'ako-Latn': 'ako',
        'ako-SR': 'ako',
        'akp': 'akp',
        'akp-Latn-GH': 'akp',
        'akp-GH': 'akp',
        'akp-Latn': 'akp',
        'akq': 'akq',
        'akq-Latn-PG': 'akq',
        'akq-Latn': 'akq',
        'akq-PG': 'akq',
        'akr': 'akr',
        'akr-Latn-VU': 'akr',
        'akr-Latn': 'akr',
        'akr-VU': 'akr',
        'aks': 'aks',
        'aks-Latn-TG': 'aks',
        'aks-Latn': 'aks',
        'aks-TG': 'aks',
        'akt': 'akt',
        'akt-Latn-PG': 'akt',
        'akt-Latn': 'akt',
        'akt-PG': 'akt',
        'aku': 'aku',
        'aku-Latn-CM': 'aku',
        'aku-CM': 'aku',
        'aku-Latn': 'aku',
        'akv': 'akv',
        'akv-Cyrl-RU': 'akv',
        'akv-Cyrl': 'akv',
        'akv-RU': 'akv',
        'akw': 'akw',
        'akw-Latn-CG': 'akw',
        'akw-CG': 'akw',
        'akw-Latn': 'akw',
        'akx': 'akx',
        'akx-Zyyy-IN': 'akx',
        'akx-IN': 'akx',
        'akx-Zyyy': 'akx',
        'aky': 'aky',
        'aky-Zyyy-IN': 'aky',
        'aky-IN': 'aky',
        'aky-Zyyy': 'aky',
        'akz': 'akz',
        'akz-Latn-US': 'akz',
        'akz-Latn': 'akz',
        'akz-US': 'akz',
        'ala': 'ala',
        'ala-Latn-NG': 'ala',
        'ala-Latn': 'ala',
        'ala-NG': 'ala',
        'alc': 'alc',
        'alc-Latn-CL': 'alc',
        'alc-CL': 'alc',
        'alc-Latn': 'alc',
        'ald': 'ald',
        'ald-Latn-CI': 'ald',
        'ald-CI': 'ald',
        'ald-Latn': 'ald',
        'ale': 'ale',
        'ale-Latn-US': 'ale',
        'ale-Latn': 'ale',
        'ale-US': 'ale',
        'ale-Cyrs': 'ale-Cyrs',
        'ale-Cyrs-US': 'ale-Cyrs',
        'alf': 'alf',
        'alf-Latn-NG': 'alf',
        'alf-Latn': 'alf',
        'alf-NG': 'alf',
        'alh': 'alh',
        'alh-Latn-AU': 'alh',
        'alh-AU': 'alh',
        'alh-Latn': 'alh',
        'ali': 'ali',
        'ali-Latn-PG': 'ali',
        'ali-Latn': 'ali',
        'ali-PG': 'ali',
        'alj': 'alj',
        'alj-Latn-PH': 'alj',
        'alj-Latn': 'alj',
        'alj-PH': 'alj',
        'alk': 'alk',
        'alk-Zyyy-LA': 'alk',
        'alk-LA': 'alk',
        'alk-Zyyy': 'alk',
        'all': 'all',
        'all-Mlym-IN': 'all',
        'all-IN': 'all',
        'all-Mlym': 'all',
        'alm': 'alm',
        'alm-Latn-VU': 'alm',
        'alm-Latn': 'alm',
        'alm-VU': 'alm',
        'aln': 'aln',
        'aln-Latn-XK': 'aln',
        'aln-Latn': 'aln',
        'aln-XK': 'aln',
        'aln-Brai': 'aln-Brai',
        'aln-Brai-AL': 'aln-Brai',
        'aln-AL': 'aln-Brai',
        'alo': 'alo',
        'alo-Latn-ID': 'alo',
        'alo-ID': 'alo',
        'alo-Latn': 'alo',
        'alp': 'alp',
        'alp-Latn-ID': 'alp',
        'alp-ID': 'alp',
        'alp-Latn': 'alp',
        'alq': 'alq',
        'alq-Latn-CA': 'alq',
        'alq-CA': 'alq',
        'alq-Latn': 'alq',
        'alr': 'alr',
        'alr-Cyrl-RU': 'alr',
        'alr-Cyrl': 'alr',
        'alr-RU': 'alr',
        'alt': 'alt',
        'alt-Cyrl-RU': 'alt',
        'alt-Cyrl': 'alt',
        'alt-RU': 'alt',
        'alt-Mong': 'alt-Mong',
        'alt-Mong-RU': 'alt-Mong',
        'alu': 'alu',
        'alu-Latn-SB': 'alu',
        'alu-Latn': 'alu',
        'alu-SB': 'alu',
        'alw': 'alw',
        'alw-Ethi-ET': 'alw',
        'alw-ET': 'alw',
        'alw-Ethi': 'alw',
        'alx': 'alx',
        'alx-Latn-PG': 'alx',
        'alx-Latn': 'alx',
        'alx-PG': 'alx',
        'aly': 'aly',
        'aly-Latn-AU': 'aly',
        'aly-AU': 'aly',
        'aly-Latn': 'aly',
        'alz': 'alz',
        'alz-Latn-CD': 'alz',
        'alz-CD': 'alz',
        'alz-Latn': 'alz',
        'am': 'am',
        'am-Ethi-ET': 'am',
        'am-ET': 'am',
        'am-Ethi': 'am',
        'am-Arab': 'am-Arab',
        'am-Arab-ET': 'am-Arab',
        'am-Brai': 'am-Brai',
        'am-Brai-ET': 'am-Brai',
        'ama': 'ama',
        'ama-Latn-BR': 'ama',
        'ama-BR': 'ama',
        'ama-Latn': 'ama',
        'amb': 'amb',
        'amb-Latn-NG': 'amb',
        'amb-Latn': 'amb',
        'amb-NG': 'amb',
        'amc': 'amc',
        'amc-Latn-PE': 'amc',
        'amc-Latn': 'amc',
        'amc-PE': 'amc',
        'ame': 'ame',
        'ame-Latn-PE': 'ame',
        'ame-Latn': 'ame',
        'ame-PE': 'ame',
        'amf-Ethi': 'amf-Ethi',
        'amf-Ethi-ET': 'amf-Ethi',
        'amf-Latn': 'amf-Latn',
        'amf-Latn-ET': 'amf-Latn',
        'amg': 'amg',
        'amg-Latn-AU': 'amg',
        'amg-AU': 'amg',
        'amg-Latn': 'amg',
        'ami': 'ami',
        'ami-Latn-TW': 'ami',
        'ami-Latn': 'ami',
        'ami-TW': 'ami',
        'ami-Zyyy-TW': 'ami-Zyyy-TW',
        'ais': 'ami-Zyyy-TW',
        'ais-TW': 'ami-Zyyy-TW',
        'ais-Zyyy': 'ami-Zyyy-TW',
        'ais-Zyyy-TW': 'ami-Zyyy-TW',
        'amj': 'amj',
        'amj-Latn-TD': 'amj',
        'amj-Latn': 'amj',
        'amj-TD': 'amj',
        'amk': 'amk',
        'amk-Latn-ID': 'amk',
        'amk-ID': 'amk',
        'amk-Latn': 'amk',
        'aml': 'aml',
        'aml-Zyyy-BD': 'aml',
        'aml-BD': 'aml',
        'aml-Zyyy': 'aml',
        'amm': 'amm',
        'amm-Latn-PG': 'amm',
        'amm-Latn': 'amm',
        'amm-PG': 'amm',
        'amn': 'amn',
        'amn-Latn-PG': 'amn',
        'amn-Latn': 'amn',
        'amn-PG': 'amn',
        'amo': 'amo',
        'amo-Latn-NG': 'amo',
        'amo-Latn': 'amo',
        'amo-NG': 'amo',
        'amp': 'amp',
        'amp-Latn-PG': 'amp',
        'amp-Latn': 'amp',
        'amp-PG': 'amp',
        'amq': 'amq',
        'amq-Latn-ID': 'amq',
        'amq-ID': 'amq',
        'amq-Latn': 'amq',
        'amr': 'amr',
        'amr-Latn-PE': 'amr',
        'amr-Latn': 'amr',
        'amr-PE': 'amr',
        'ams': 'ams',
        'ams-Zyyy-JP': 'ams',
        'ams-JP': 'ams',
        'ams-Zyyy': 'ams',
        'amt': 'amt',
        'amt-Latn-PG': 'amt',
        'amt-Latn': 'amt',
        'amt-PG': 'amt',
        'amu': 'amu',
        'amu-Latn-MX': 'amu',
        'amu-Latn': 'amu',
        'amu-MX': 'amu',
        'amv': 'amv',
        'amv-Latn-ID': 'amv',
        'amv-ID': 'amv',
        'amv-Latn': 'amv',
        'amw-Arab': 'amw-Arab',
        'amw-Arab-SY': 'amw-Arab',
        'amw-Armi': 'amw-Armi',
        'amw-Armi-SY': 'amw-Armi',
        'amw-Latn': 'amw-Latn',
        'amw-Latn-SY': 'amw-Latn',
        'amw-Syrj': 'amw-Syrj',
        'amw-Syrj-SY': 'amw-Syrj',
        'amx': 'amx',
        'amx-Latn-AU': 'amx',
        'amx-AU': 'amx',
        'amx-Latn': 'amx',
        'amy': 'amy',
        'amy-Latn-AU': 'amy',
        'amy-AU': 'amy',
        'amy-Latn': 'amy',
        'amz': 'amz',
        'amz-Latn-AU': 'amz',
        'amz-AU': 'amz',
        'amz-Latn': 'amz',
        'an': 'an',
        'an-Latn-ES': 'an',
        'an-ES': 'an',
        'an-Latn': 'an',
        'ana': 'ana',
        'ana-Latn-CO': 'ana',
        'ana-CO': 'ana',
        'ana-Latn': 'ana',
        'anb': 'anb',
        'anb-Latn-PE': 'anb',
        'anb-Latn': 'anb',
        'anb-PE': 'anb',
        'anc': 'anc',
        'anc-Latn-NG': 'anc',
        'anc-Latn': 'anc',
        'anc-NG': 'anc',
        'and': 'and',
        'and-Latn-ID': 'and',
        'and-ID': 'and',
        'and-Latn': 'and',
        'ane': 'ane',
        'ane-Latn-NC': 'ane',
        'ane-Latn': 'ane',
        'ane-NC': 'ane',
        'anf': 'anf',
        'anf-Latn-GH': 'anf',
        'anf-GH': 'anf',
        'anf-Latn': 'anf',
        'ang': 'ang',
        'ang-Latn-GB': 'ang',
        'ang-GB': 'ang',
        'ang-Latn': 'ang',
        'anh': 'anh',
        'anh-Latn-PG': 'anh',
        'anh-Latn': 'anh',
        'anh-PG': 'anh',
        'ani': 'ani',
        'ani-Cyrl-RU': 'ani',
        'ani-Cyrl': 'ani',
        'ani-RU': 'ani',
        'anj': 'anj',
        'anj-Latn-PG': 'anj',
        'anj-Latn': 'anj',
        'anj-PG': 'anj',
        'ank': 'ank',
        'ank-Latn-NG': 'ank',
        'ank-Latn': 'ank',
        'ank-NG': 'ank',
        'anl': 'anl',
        'anl-Latn-MM': 'anl',
        'anl-Latn': 'anl',
        'anl-MM': 'anl',
        'anm': 'anm',
        'anm-Latn-IN': 'anm',
        'anm-IN': 'anm',
        'anm-Latn': 'anm',
        'ann': 'ann',
        'ann-Latn-NG': 'ann',
        'ann-Latn': 'ann',
        'ann-NG': 'ann',
        'ano': 'ano',
        'ano-Latn-CO': 'ano',
        'ano-CO': 'ano',
        'ano-Latn': 'ano',
        'anp': 'anp',
        'anp-Deva-IN': 'anp',
        'anp-Deva': 'anp',
        'anp-IN': 'anp',
        'anq': 'anq',
        'anq-Zyyy-IN': 'anq',
        'anq-IN': 'anq',
        'anq-Zyyy': 'anq',
        'anr': 'anr',
        'anr-Deva-IN': 'anr',
        'anr-Deva': 'anr',
        'anr-IN': 'anr',
        'ans': 'ans',
        'ans-Latn-CO': 'ans',
        'ans-CO': 'ans',
        'ans-Latn': 'ans',
        'ant': 'ant',
        'ant-Latn-AU': 'ant',
        'ant-AU': 'ant',
        'ant-Latn': 'ant',
        'anu': 'anu',
        'anu-Ethi-ET': 'anu',
        'anu-ET': 'anu',
        'anu-Ethi': 'anu',
        'anu-Arab': 'anu-Arab',
        'anu-Arab-SS': 'anu-Arab',
        'anu-Latn': 'anu-Latn',
        'anu-Latn-SS': 'anu-Latn',
        'anv': 'anv',
        'anv-Latn-CM': 'anv',
        'anv-CM': 'anv',
        'anv-Latn': 'anv',
        'anw': 'anw',
        'anw-Latn-NG': 'anw',
        'anw-Latn': 'anw',
        'anw-NG': 'anw',
        'anx': 'anx',
        'anx-Latn-PG': 'anx',
        'anx-Latn': 'anx',
        'anx-PG': 'anx',
        'any': 'any',
        'any-Latn-CI': 'any',
        'any-CI': 'any',
        'any-Latn': 'any',
        'anz': 'anz',
        'anz-Latn-PG': 'anz',
        'anz-Latn': 'anz',
        'anz-PG': 'anz',
        'aoa': 'aoa',
        'aoa-Latn-ST': 'aoa',
        'aoa-Latn': 'aoa',
        'aoa-ST': 'aoa',
        'aob': 'aob',
        'aob-Latn-PG': 'aob',
        'aob-Latn': 'aob',
        'aob-PG': 'aob',
        'aoc': 'aoc',
        'aoc-Latn-VE': 'aoc',
        'aoc-Latn': 'aoc',
        'aoc-VE': 'aoc',
        'aod': 'aod',
        'aod-Latn-PG': 'aod',
        'aod-Latn': 'aod',
        'aod-PG': 'aod',
        'aoe': 'aoe',
        'aoe-Latn-PG': 'aoe',
        'aoe-Latn': 'aoe',
        'aoe-PG': 'aoe',
        'aof': 'aof',
        'aof-Latn-PG': 'aof',
        'aof-Latn': 'aof',
        'aof-PG': 'aof',
        'aog': 'aog',
        'aog-Latn-PG': 'aog',
        'aog-Latn': 'aog',
        'aog-PG': 'aog',
        'myd': 'aog',
        'myd-Latn': 'aog',
        'myd-Latn-PG': 'aog',
        'myd-PG': 'aog',
        'aoh': 'aoh',
        'aoh-Latn-CO': 'aoh',
        'aoh-CO': 'aoh',
        'aoh-Latn': 'aoh',
        'aoi': 'aoi',
        'aoi-Latn-AU': 'aoi',
        'aoi-AU': 'aoi',
        'aoi-Latn': 'aoi',
        'aoj': 'aoj',
        'aoj-Latn-PG': 'aoj',
        'aoj-Latn': 'aoj',
        'aoj-PG': 'aoj',
        'aoj-x-balif': 'aoj-x-balif',
        'aoj-Latn-PG-x-balif': 'aoj-x-balif',
        'aoj-Latn-x-balif': 'aoj-x-balif',
        'aoj-PG-x-balif': 'aoj-x-balif',
        'aoj-x-filifita': 'aoj-x-filifita',
        'aoj-Latn-PG-x-filifita': 'aoj-x-filifita',
        'aoj-Latn-x-filifita': 'aoj-x-filifita',
        'aoj-PG-x-filifita': 'aoj-x-filifita',
        'aok': 'aok',
        'aok-Latn-NC': 'aok',
        'aok-Latn': 'aok',
        'aok-NC': 'aok',
        'aol': 'aol',
        'aol-Latn-ID': 'aol',
        'aol-ID': 'aol',
        'aol-Latn': 'aol',
        'aom': 'aom',
        'aom-Latn-PG': 'aom',
        'aom-Latn': 'aom',
        'aom-PG': 'aom',
        'aon': 'aon',
        'aon-Latn-PG': 'aon',
        'aon-Latn': 'aon',
        'aon-PG': 'aon',
        'aor': 'aor',
        'aor-Latn-VU': 'aor',
        'aor-Latn': 'aor',
        'aor-VU': 'aor',
        'aos': 'aos',
        'aos-Latn-ID': 'aos',
        'aos-ID': 'aos',
        'aos-Latn': 'aos',
        'aot': 'aot',
        'aot-Zyyy-IN': 'aot',
        'aot-IN': 'aot',
        'aot-Zyyy': 'aot',
        'aou': 'aou',
        'aou-Zyyy-CN': 'aou',
        'aou-CN': 'aou',
        'aou-Zyyy': 'aou',
        'aox': 'aox',
        'aox-Latn-GY': 'aox',
        'aox-GY': 'aox',
        'aox-Latn': 'aox',
        'aoz': 'aoz',
        'aoz-Latn-ID': 'aoz',
        'aoz-ID': 'aoz',
        'aoz-Latn': 'aoz',
        'apb': 'apb',
        'apb-Latn-SB': 'apb',
        'apb-Latn': 'apb',
        'apb-SB': 'apb',
        'apc': 'apc',
        'apc-Arab-SY': 'apc',
        'apc-Arab': 'apc',
        'apc-SY': 'apc',
        'ar-apc': 'apc',
        'ar-apc-SY': 'apc',
        'apd': 'apd',
        'apd-Arab-TG': 'apd',
        'apd-Arab': 'apd',
        'apd-TG': 'apd',
        'ar-apd': 'apd',
        'ar-apd-TG': 'apd',
        'apd-Latn': 'apd-Latn',
        'apd-Latn-SD': 'apd-Latn',
        'apd-SD': 'apd-Latn',
        'ar-apd-SD': 'apd-Latn',
        'ape': 'ape',
        'ape-Latn-PG': 'ape',
        'ape-Latn': 'ape',
        'ape-PG': 'ape',
        'ape-x-coastal': 'ape-x-coastal',
        'ape-Latn-PG-x-coastal': 'ape-x-coastal',
        'ape-Latn-x-coastal': 'ape-x-coastal',
        'ape-PG-x-coastal': 'ape-x-coastal',
        'ape-x-mountain': 'ape-x-mountain',
        'ape-Latn-PG-x-mountain': 'ape-x-mountain',
        'ape-Latn-x-mountain': 'ape-x-mountain',
        'ape-PG-x-mountain': 'ape-x-mountain',
        'apf': 'apf',
        'apf-Latn-PH': 'apf',
        'apf-Latn': 'apf',
        'apf-PH': 'apf',
        'apg': 'apg',
        'apg-Latn-ID': 'apg',
        'apg-ID': 'apg',
        'apg-Latn': 'apg',
        'aph': 'aph',
        'aph-Deva-NP': 'aph',
        'aph-Deva': 'aph',
        'aph-NP': 'aph',
        'api': 'api',
        'api-Latn-BR': 'api',
        'api-BR': 'api',
        'api-Latn': 'api',
        'apj': 'apj',
        'apj-Latn-US': 'apj',
        'apj-Latn': 'apj',
        'apj-US': 'apj',
        'apk': 'apk',
        'apk-Latn-US': 'apk',
        'apk-Latn': 'apk',
        'apk-US': 'apk',
        'apl': 'apl',
        'apl-Latn-US': 'apl',
        'apl-Latn': 'apl',
        'apl-US': 'apl',
        'apm': 'apm',
        'apm-Latn-US': 'apm',
        'apm-Latn': 'apm',
        'apm-US': 'apm',
        'apn': 'apn',
        'apn-Latn-BR': 'apn',
        'apn-BR': 'apn',
        'apn-Latn': 'apn',
        'apo': 'apo',
        'apo-Latn-PG': 'apo',
        'apo-Latn': 'apo',
        'apo-PG': 'apo',
        'app': 'app',
        'app-Latn-VU': 'app',
        'app-Latn': 'app',
        'app-VU': 'app',
        'apq': 'apq',
        'apq-Zyyy-IN': 'apq',
        'apq-IN': 'apq',
        'apq-Zyyy': 'apq',
        'apr': 'apr',
        'apr-Latn-PG': 'apr',
        'apr-Latn': 'apr',
        'apr-PG': 'apr',
        'aps': 'aps',
        'aps-Latn-PG': 'aps',
        'aps-Latn': 'aps',
        'aps-PG': 'aps',
        'apt': 'apt',
        'apt-Latn-IN': 'apt',
        'apt-IN': 'apt',
        'apt-Latn': 'apt',
        'apu': 'apu',
        'apu-Latn-BR': 'apu',
        'apu-BR': 'apu',
        'apu-Latn': 'apu',
        'apv': 'apv',
        'apv-Latn-BR': 'apv',
        'apv-BR': 'apv',
        'apv-Latn': 'apv',
        'apw': 'apw',
        'apw-Latn-US': 'apw',
        'apw-Latn': 'apw',
        'apw-US': 'apw',
        'apx': 'apx',
        'apx-Latn-ID': 'apx',
        'apx-ID': 'apx',
        'apx-Latn': 'apx',
        'apy': 'apy',
        'apy-Latn-BR': 'apy',
        'apy-BR': 'apy',
        'apy-Latn': 'apy',
        'apz': 'apz',
        'apz-Latn-PG': 'apz',
        'apz-Latn': 'apz',
        'apz-PG': 'apz',
        'aqc': 'aqc',
        'aqc-Cyrl-RU': 'aqc',
        'aqc-Cyrl': 'aqc',
        'aqc-RU': 'aqc',
        'aqd': 'aqd',
        'aqd-Latn-ML': 'aqd',
        'aqd-Latn': 'aqd',
        'aqd-ML': 'aqd',
        'aqg': 'aqg',
        'aqg-Latn-NG': 'aqg',
        'aqg-Latn': 'aqg',
        'aqg-NG': 'aqg',
        'aqm': 'aqm',
        'aqm-Latn-ID': 'aqm',
        'aqm-ID': 'aqm',
        'aqm-Latn': 'aqm',
        'aqn': 'aqn',
        'aqn-Latn-PH': 'aqn',
        'aqn-Latn': 'aqn',
        'aqn-PH': 'aqn',
        'aqp': 'aqp',
        'aqp-Zyyy-US': 'aqp',
        'aqp-US': 'aqp',
        'aqp-Zyyy': 'aqp',
        'aqr': 'aqr',
        'aqr-Latn-NC': 'aqr',
        'aqr-Latn': 'aqr',
        'aqr-NC': 'aqr',
        'aqt': 'aqt',
        'aqt-Latn-PY': 'aqt',
        'aqt-Latn': 'aqt',
        'aqt-PY': 'aqt',
        'aqz': 'aqz',
        'aqz-Latn-BR': 'aqz',
        'aqz-BR': 'aqz',
        'aqz-Latn': 'aqz',
        'ar': 'ar',
        'ar-Arab-EG': 'ar',
        'ar-Arab': 'ar',
        'ar-EG': 'ar',
        'ar-AE': 'ar-AE',
        'ar-Arab-AE': 'ar-AE',
        'ar-Brai': 'ar-Brai',
        'ar-Brai-SA': 'ar-Brai',
        'arb-Brai': 'ar-Brai',
        'arb-Brai-SA': 'ar-Brai',
        'ar-DJ': 'ar-DJ',
        'ar-Arab-DJ': 'ar-DJ',
        'ar-DZ': 'ar-DZ',
        'ar-Arab-DZ': 'ar-DZ',
        'ar-EH': 'ar-EH',
        'ar-Arab-EH': 'ar-EH',
        'ar-ER': 'ar-ER',
        'ar-Arab-ER': 'ar-ER',
        'ar-IL': 'ar-IL',
        'ar-Arab-IL': 'ar-IL',
        'ar-IQ': 'ar-IQ',
        'ar-Arab-IQ': 'ar-IQ',
        'ar-JO': 'ar-JO',
        'ar-Arab-JO': 'ar-JO',
        'ar-KM': 'ar-KM',
        'ar-Arab-KM': 'ar-KM',
        'ar-LB': 'ar-LB',
        'ar-Arab-LB': 'ar-LB',
        'ar-LY': 'ar-LY',
        'ar-Arab-LY': 'ar-LY',
        'ar-MA': 'ar-MA',
        'ar-Arab-MA': 'ar-MA',
        'ar-MR': 'ar-MR',
        'ar-Arab-MR': 'ar-MR',
        'ar-PS': 'ar-PS',
        'ar-Arab-PS': 'ar-PS',
        'ar-SA': 'ar-SA',
        'ar-Arab-SA': 'ar-SA',
        'ar-arb': 'ar-SA',
        'ar-arb-SA': 'ar-SA',
        'arb': 'ar-SA',
        'arb-Arab': 'ar-SA',
        'arb-Arab-SA': 'ar-SA',
        'arb-SA': 'ar-SA',
        'ar-SO': 'ar-SO',
        'ar-Arab-SO': 'ar-SO',
        'ar-SS': 'ar-SS',
        'ar-Arab-SS': 'ar-SS',
        'ar-SY': 'ar-SY',
        'ar-Arab-SY': 'ar-SY',
        'ar-Syrc': 'ar-Syrc',
        'ar-Syrc-SA': 'ar-Syrc',
        'ar-TN': 'ar-TN',
        'ar-Arab-TN': 'ar-TN',
        'arc': 'arc',
        'arc-Armi-IR': 'arc',
        'arc-Armi': 'arc',
        'arc-IR': 'arc',
        'arc-Nbat': 'arc-Nbat',
        'arc-Nbat-JO': 'arc-Nbat',
        'arc-JO': 'arc-Nbat',
        'arc-Palm': 'arc-Palm',
        'arc-Palm-SY': 'arc-Palm',
        'arc-SY': 'arc-Palm',
        'arc-Syrc': 'arc-Syrc',
        'arc-Syrc-XX': 'arc-Syrc',
        'arc-XX': 'arc-Syrc',
        'ard': 'ard',
        'ard-Latn-AU': 'ard',
        'ard-AU': 'ard',
        'ard-Latn': 'ard',
        'are': 'are',
        'are-Latn-AU': 'are',
        'are-AU': 'are',
        'are-Latn': 'are',
        'arh': 'arh',
        'arh-Latn-CO': 'arh',
        'arh-CO': 'arh',
        'arh-Latn': 'arh',
        'ari': 'ari',
        'ari-Latn-US': 'ari',
        'ari-Latn': 'ari',
        'ari-US': 'ari',
        'arj': 'arj',
        'arj-Latn-BR': 'arj',
        'arj-BR': 'arj',
        'arj-Latn': 'arj',
        'ark': 'ark',
        'ark-Latn-BR': 'ark',
        'ark-BR': 'ark',
        'ark-Latn': 'ark',
        'arl': 'arl',
        'arl-Latn-PE': 'arl',
        'arl-Latn': 'arl',
        'arl-PE': 'arl',
        'arn': 'arn',
        'arn-Latn-CL': 'arn',
        'arn-CL': 'arn',
        'arn-Latn': 'arn',
        'aro': 'aro',
        'aro-Latn-BO': 'aro',
        'aro-BO': 'aro',
        'aro-Latn': 'aro',
        'arp': 'arp',
        'arp-Latn-US': 'arp',
        'arp-Latn': 'arp',
        'arp-US': 'arp',
        'arq': 'arq',
        'arq-Arab-DZ': 'arq',
        'ar-arq': 'arq',
        'ar-arq-DZ': 'arq',
        'arq-Arab': 'arq',
        'arq-DZ': 'arq',
        'arr': 'arr',
        'arr-Latn-BR': 'arr',
        'arr-BR': 'arr',
        'arr-Latn': 'arr',
        'ars': 'ars',
        'ars-Arab-SA': 'ars',
        'ar-ars': 'ars',
        'ar-ars-SA': 'ars',
        'ars-Arab': 'ars',
        'ars-SA': 'ars',
        'aru': 'aru',
        'aru-Latn-BR': 'aru',
        'aru-BR': 'aru',
        'aru-Latn': 'aru',
        'arv': 'arv',
        'arv-Zyyy-ET': 'arv',
        'arv-ET': 'arv',
        'arv-Zyyy': 'arv',
        'arw': 'arw',
        'arw-Latn-SR': 'arw',
        'arw-Latn': 'arw',
        'arw-SR': 'arw',
        'arx': 'arx',
        'arx-Latn-BR': 'arx',
        'arx-BR': 'arx',
        'arx-Latn': 'arx',
        'ary': 'ary',
        'ary-Arab-MA': 'ary',
        'ar-ary': 'ary',
        'ar-ary-MA': 'ary',
        'ary-Arab': 'ary',
        'ary-MA': 'ary',
        'arz': 'arz',
        'arz-Arab-EG': 'arz',
        'ar-arz': 'arz',
        'ar-arz-EG': 'arz',
        'arz-Arab': 'arz',
        'arz-EG': 'arz',
        'arz-Brai': 'arz-Brai',
        'arz-Brai-EG': 'arz-Brai',
        'as': 'as',
        'as-Beng-IN': 'as',
        'as-Beng': 'as',
        'as-IN': 'as',
        'asa': 'asa',
        'asa-Latn-TZ': 'asa',
        'asa-Latn': 'asa',
        'asa-TZ': 'asa',
        'asb': 'asb',
        'asb-Latn-CA': 'asb',
        'asb-CA': 'asb',
        'asb-Latn': 'asb',
        'asc': 'asc',
        'asc-Latn-ID': 'asc',
        'asc-ID': 'asc',
        'asc-Latn': 'asc',
        'ase': 'ase',
        'ase-Sgnw-US': 'ase',
        'ase-Sgnw': 'ase',
        'ase-US': 'ase',
        'sgn-ase': 'ase',
        'sgn-ase-US': 'ase',
        'ase-Zxxx': 'ase-Zxxx',
        'ase-Zxxx-US': 'ase-Zxxx',
        'asf': 'asf',
        'asf-Zxxx-AU': 'asf',
        'asf-AU': 'asf',
        'asf-Zxxx': 'asf',
        'sgn-asf': 'asf',
        'sgn-asf-AU': 'asf',
        'asg': 'asg',
        'asg-Latn-NG': 'asg',
        'asg-Latn': 'asg',
        'asg-NG': 'asg',
        'ash': 'ash',
        'ash-Latn-PE': 'ash',
        'ash-Latn': 'ash',
        'ash-PE': 'ash',
        'asi': 'asi',
        'asi-Latn-ID': 'asi',
        'asi-ID': 'asi',
        'asi-Latn': 'asi',
        'asj': 'asj',
        'asj-Latn-CM': 'asj',
        'asj-CM': 'asj',
        'asj-Latn': 'asj',
        'ask': 'ask',
        'ask-Arab-AF': 'ask',
        'ask-AF': 'ask',
        'ask-Arab': 'ask',
        'asl': 'asl',
        'asl-Latn-ID': 'asl',
        'asl-ID': 'asl',
        'asl-Latn': 'asl',
        'asn': 'asn',
        'asn-Latn-BR': 'asn',
        'asn-BR': 'asn',
        'asn-Latn': 'asn',
        'aso': 'aso',
        'aso-Latn-PG': 'aso',
        'aso-Latn': 'aso',
        'aso-PG': 'aso',
        'asp': 'asp',
        'asp-Zxxx-DZ': 'asp',
        'asp-DZ': 'asp',
        'asp-Zxxx': 'asp',
        'sgn-asp': 'asp',
        'sgn-asp-DZ': 'asp',
        'asq': 'asq',
        'asq-Zxxx-AT': 'asq',
        'asq-AT': 'asq',
        'asq-Zxxx': 'asq',
        'sgn-asq': 'asq',
        'sgn-asq-AT': 'asq',
        'asr-Deva': 'asr-Deva',
        'asr-Deva-IN': 'asr-Deva',
        'asr-IN': 'asr-Deva',
        'ass': 'ass',
        'ass-Latn-CM': 'ass',
        'ass-CM': 'ass',
        'ass-Latn': 'ass',
        'ast': 'ast',
        'ast-Latn-ES': 'ast',
        'ast-ES': 'ast',
        'ast-Latn': 'ast',
        'asu': 'asu',
        'asu-Latn-BR': 'asu',
        'asu-BR': 'asu',
        'asu-Latn': 'asu',
        'asv': 'asv',
        'asv-Latn-CD': 'asv',
        'asv-CD': 'asv',
        'asv-Latn': 'asv',
        'asw': 'asw',
        'asw-Zxxx-AU': 'asw',
        'asw-AU': 'asw',
        'asw-Zxxx': 'asw',
        'sgn-asw': 'asw',
        'sgn-asw-AU': 'asw',
        'asx': 'asx',
        'asx-Latn-PG': 'asx',
        'asx-Latn': 'asx',
        'asx-PG': 'asx',
        'asy': 'asy',
        'asy-Latn-ID': 'asy',
        'asy-ID': 'asy',
        'asy-Latn': 'asy',
        'asz': 'asz',
        'asz-Latn-ID': 'asz',
        'asz-ID': 'asz',
        'asz-Latn': 'asz',
        'ata': 'ata',
        'ata-Latn-PG': 'ata',
        'ata-Latn': 'ata',
        'ata-PG': 'ata',
        'atb': 'atb',
        'atb-Latn-CN': 'atb',
        'atb-CN': 'atb',
        'atb-Latn': 'atb',
        'atb-Lisu': 'atb-Lisu',
        'atb-Lisu-CN': 'atb-Lisu',
        'atc': 'atc',
        'atc-Latn-PE': 'atc',
        'atc-Latn': 'atc',
        'atc-PE': 'atc',
        'atd': 'atd',
        'atd-Latn-PH': 'atd',
        'atd-Latn': 'atd',
        'atd-PH': 'atd',
        'ate': 'ate',
        'ate-Latn-PG': 'ate',
        'ate-Latn': 'ate',
        'ate-PG': 'ate',
        'atg': 'atg',
        'atg-Latn-NG': 'atg',
        'atg-Latn': 'atg',
        'atg-NG': 'atg',
        'ati': 'ati',
        'ati-Latn-CI': 'ati',
        'ati-CI': 'ati',
        'ati-Latn': 'ati',
        'atj': 'atj',
        'atj-Latn-CA': 'atj',
        'atj-CA': 'atj',
        'atj-Latn': 'atj',
        'atk': 'atk',
        'atk-Latn-PH': 'atk',
        'atk-Latn': 'atk',
        'atk-PH': 'atk',
        'atl': 'atl',
        'atl-Latn-PH': 'atl',
        'atl-Latn': 'atl',
        'atl-PH': 'atl',
        'atm': 'atm',
        'atm-Latn-PH': 'atm',
        'atm-Latn': 'atm',
        'atm-PH': 'atm',
        'atn': 'atn',
        'atn-Arab-IR': 'atn',
        'atn-Arab': 'atn',
        'atn-IR': 'atn',
        'ato': 'ato',
        'ato-Latn-CM': 'ato',
        'ato-CM': 'ato',
        'ato-Latn': 'ato',
        'atp': 'atp',
        'atp-Latn-PH': 'atp',
        'atp-Latn': 'atp',
        'atp-PH': 'atp',
        'atq': 'atq',
        'atq-Latn-ID': 'atq',
        'atq-ID': 'atq',
        'atq-Latn': 'atq',
        'atr': 'atr',
        'atr-Latn-BR': 'atr',
        'atr-BR': 'atr',
        'atr-Latn': 'atr',
        'ats': 'ats',
        'ats-Latn-US': 'ats',
        'ats-Latn': 'ats',
        'ats-US': 'ats',
        'att': 'att',
        'att-Latn-PH': 'att',
        'att-Latn': 'att',
        'att-PH': 'att',
        'atu': 'atu',
        'atu-Latn-SS': 'atu',
        'atu-Latn': 'atu',
        'atu-SS': 'atu',
        'atv': 'atv',
        'atv-Cyrl-RU': 'atv',
        'atv-Cyrl': 'atv',
        'atv-RU': 'atv',
        'atw': 'atw',
        'atw-Latn-US': 'atw',
        'atw-Latn': 'atw',
        'atw-US': 'atw',
        'atx': 'atx',
        'atx-Latn-BR': 'atx',
        'atx-BR': 'atx',
        'atx-Latn': 'atx',
        'aty': 'aty',
        'aty-Latn-VU': 'aty',
        'aty-Latn': 'aty',
        'aty-VU': 'aty',
        'atz': 'atz',
        'atz-Latn-PH': 'atz',
        'atz-Latn': 'atz',
        'atz-PH': 'atz',
        'aua': 'aua',
        'aua-Latn-SB': 'aua',
        'aua-Latn': 'aua',
        'aua-SB': 'aua',
        'aub': 'aub',
        'aub-Zyyy-CN': 'aub',
        'aub-CN': 'aub',
        'aub-Zyyy': 'aub',
        'auc': 'auc',
        'auc-Latn-EC': 'auc',
        'auc-EC': 'auc',
        'auc-Latn': 'auc',
        'aud': 'aud',
        'aud-Latn-SB': 'aud',
        'aud-Latn': 'aud',
        'aud-SB': 'aud',
        'aug': 'aug',
        'aug-Latn-BJ': 'aug',
        'aug-BJ': 'aug',
        'aug-Latn': 'aug',
        'auh': 'auh',
        'auh-Latn-ZM': 'auh',
        'auh-Latn': 'auh',
        'auh-ZM': 'auh',
        'aui': 'aui',
        'aui-Latn-PG': 'aui',
        'aui-Latn': 'aui',
        'aui-PG': 'aui',
        'auj': 'auj',
        'auj-Zyyy-LY': 'auj',
        'auj-LY': 'auj',
        'auj-Zyyy': 'auj',
        'auk': 'auk',
        'auk-Latn-PG': 'auk',
        'auk-Latn': 'auk',
        'auk-PG': 'auk',
        'aul': 'aul',
        'aul-Latn-VU': 'aul',
        'aul-Latn': 'aul',
        'aul-VU': 'aul',
        'aum': 'aum',
        'aum-Latn-NG': 'aum',
        'aum-Latn': 'aum',
        'aum-NG': 'aum',
        'aun': 'aun',
        'aun-Latn-PG': 'aun',
        'aun-Latn': 'aun',
        'aun-PG': 'aun',
        'auo': 'auo',
        'auo-Latn-NG': 'auo',
        'auo-Latn': 'auo',
        'auo-NG': 'auo',
        'aup': 'aup',
        'aup-Latn-PG': 'aup',
        'aup-Latn': 'aup',
        'aup-PG': 'aup',
        'auq': 'auq',
        'auq-Latn-ID': 'auq',
        'auq-ID': 'auq',
        'auq-Latn': 'auq',
        'aur': 'aur',
        'aur-Latn-PG': 'aur',
        'aur-Latn': 'aur',
        'aur-PG': 'aur',
        'aut': 'aut',
        'aut-Latn-PF': 'aut',
        'aut-Latn': 'aut',
        'aut-PF': 'aut',
        'auu': 'auu',
        'auu-Latn-ID': 'auu',
        'auu-ID': 'auu',
        'auu-Latn': 'auu',
        'auw': 'auw',
        'auw-Latn-ID': 'auw',
        'auw-ID': 'auw',
        'auw-Latn': 'auw',
        'aux': 'aux',
        'aux-Latn-BR': 'aux',
        'aux-BR': 'aux',
        'aux-Latn': 'aux',
        'auy': 'auy',
        'auy-Latn-PG': 'auy',
        'auy-Latn': 'auy',
        'auy-PG': 'auy',
        'auz': 'auz',
        'auz-Arab-UZ': 'auz',
        'ar-auz': 'auz',
        'ar-auz-UZ': 'auz',
        'auz-Arab': 'auz',
        'auz-UZ': 'auz',
        'av': 'av',
        'av-Cyrl-RU': 'av',
        'av-Cyrl': 'av',
        'av-RU': 'av',
        'avb': 'avb',
        'avb-Latn-PG': 'avb',
        'avb-Latn': 'avb',
        'avb-PG': 'avb',
        'avd': 'avd',
        'avd-Zyyy-IR': 'avd',
        'avd-IR': 'avd',
        'avd-Zyyy': 'avd',
        'avi': 'avi',
        'avi-Latn-CI': 'avi',
        'avi-CI': 'avi',
        'avi-Latn': 'avi',
        'avk': 'avk',
        'avk-Latn-001': 'avk',
        'avk-001': 'avk',
        'avk-Latn': 'avk',
        'avl': 'avl',
        'avl-Arab-EG': 'avl',
        'ar-avl': 'avl',
        'ar-avl-EG': 'avl',
        'avl-Arab': 'avl',
        'avl-EG': 'avl',
        'avm': 'avm',
        'avm-Latn-AU': 'avm',
        'avm-AU': 'avm',
        'avm-Latn': 'avm',
        'avn': 'avn',
        'avn-Latn-GH': 'avn',
        'avn-GH': 'avn',
        'avn-Latn': 'avn',
        'avo': 'avo',
        'avo-Latn-BR': 'avo',
        'avo-BR': 'avo',
        'avo-Latn': 'avo',
        'avs': 'avs',
        'avs-Latn-PE': 'avs',
        'avs-Latn': 'avs',
        'avs-PE': 'avs',
        'avt': 'avt',
        'avt-Latn-PG': 'avt',
        'avt-Latn': 'avt',
        'avt-PG': 'avt',
        'avu': 'avu',
        'avu-Latn-SS': 'avu',
        'avu-Latn': 'avu',
        'avu-SS': 'avu',
        'avu-SD': 'avu-SD',
        'avu-Latn-SD': 'avu-SD',
        'avv': 'avv',
        'avv-Latn-BR': 'avv',
        'avv-BR': 'avv',
        'avv-Latn': 'avv',
        'awa': 'awa',
        'awa-Deva-IN': 'awa',
        'awa-Deva': 'awa',
        'awa-IN': 'awa',
        'awb': 'awb',
        'awb-Latn-PG': 'awb',
        'awb-Latn': 'awb',
        'awb-PG': 'awb',
        'awc': 'awc',
        'awc-Latn-NG': 'awc',
        'awc-Latn': 'awc',
        'awc-NG': 'awc',
        'awe': 'awe',
        'awe-Latn-BR': 'awe',
        'awe-BR': 'awe',
        'awe-Latn': 'awe',
        'awg': 'awg',
        'awg-Latn-AU': 'awg',
        'awg-AU': 'awg',
        'awg-Latn': 'awg',
        'awh': 'awh',
        'awh-Latn-ID': 'awh',
        'awh-ID': 'awh',
        'awh-Latn': 'awh',
        'awi': 'awi',
        'awi-Latn-PG': 'awi',
        'awi-Latn': 'awi',
        'awi-PG': 'awi',
        'awk': 'awk',
        'awk-Latn-AU': 'awk',
        'awk-AU': 'awk',
        'awk-Latn': 'awk',
        'awm': 'awm',
        'awm-Latn-PG': 'awm',
        'awm-Latn': 'awm',
        'awm-PG': 'awm',
        'awn': 'awn',
        'awn-Ethi-ET': 'awn',
        'awn-ET': 'awn',
        'awn-Ethi': 'awn',
        'awo': 'awo',
        'awo-Latn-NG': 'awo',
        'awo-Latn': 'awo',
        'awo-NG': 'awo',
        'awr': 'awr',
        'awr-Latn-ID': 'awr',
        'awr-ID': 'awr',
        'awr-Latn': 'awr',
        'aws': 'aws',
        'aws-Latn-ID': 'aws',
        'aws-ID': 'aws',
        'aws-Latn': 'aws',
        'awt': 'awt',
        'awt-Latn-BR': 'awt',
        'awt-BR': 'awt',
        'awt-Latn': 'awt',
        'awu': 'awu',
        'awu-Latn-ID': 'awu',
        'awu-ID': 'awu',
        'awu-Latn': 'awu',
        'awv': 'awv',
        'awv-Latn-ID': 'awv',
        'awv-ID': 'awv',
        'awv-Latn': 'awv',
        'aww': 'aww',
        'aww-Latn-PG': 'aww',
        'aww-Latn': 'aww',
        'aww-PG': 'aww',
        'awx': 'awx',
        'awx-Latn-PG': 'awx',
        'awx-Latn': 'awx',
        'awx-PG': 'awx',
        'awy': 'awy',
        'awy-Latn-ID': 'awy',
        'awy-ID': 'awy',
        'awy-Latn': 'awy',
        'axb': 'axb',
        'axb-Latn-AR': 'axb',
        'axb-AR': 'axb',
        'axb-Latn': 'axb',
        'axe': 'axe',
        'axe-Latn-AU': 'axe',
        'axe-AU': 'axe',
        'axe-Latn': 'axe',
        'axg': 'axg',
        'axg-Latn-BR': 'axg',
        'axg-BR': 'axg',
        'axg-Latn': 'axg',
        'axk': 'axk',
        'axk-Latn-CF': 'axk',
        'axk-CF': 'axk',
        'axk-Latn': 'axk',
        'axl': 'axl',
        'axl-Latn-AU': 'axl',
        'axl-AU': 'axl',
        'axl-Latn': 'axl',
        'axm': 'axm',
        'axm-Zyyy-AM': 'axm',
        'axm-AM': 'axm',
        'axm-Zyyy': 'axm',
        'axx': 'axx',
        'axx-Latn-NC': 'axx',
        'axx-Latn': 'axx',
        'axx-NC': 'axx',
        'ay': 'ay',
        'ay-Latn-BO': 'ay',
        'ay-BO': 'ay',
        'ay-Latn': 'ay',
        'ayr': 'ay',
        'ayr-BO': 'ay',
        'ayr-Latn': 'ay',
        'ayr-Latn-BO': 'ay',
        'aya': 'aya',
        'aya-Latn-PG': 'aya',
        'aya-Latn': 'aya',
        'aya-PG': 'aya',
        'ayb': 'ayb',
        'ayb-Latn-BJ': 'ayb',
        'ayb-BJ': 'ayb',
        'ayb-Latn': 'ayb',
        'ayc': 'ayc',
        'ayc-Latn-PE': 'ayc',
        'ayc-Latn': 'ayc',
        'ayc-PE': 'ayc',
        'ayd': 'ayd',
        'ayd-Latn-AU': 'ayd',
        'ayd-AU': 'ayd',
        'ayd-Latn': 'ayd',
        'aye': 'aye',
        'aye-Latn-NG': 'aye',
        'aye-Latn': 'aye',
        'aye-NG': 'aye',
        'ayg': 'ayg',
        'ayg-Latn-TG': 'ayg',
        'ayg-Latn': 'ayg',
        'ayg-TG': 'ayg',
        'ayh': 'ayh',
        'ayh-Arab-YE': 'ayh',
        'ar-ayh': 'ayh',
        'ar-ayh-YE': 'ayh',
        'ayh-Arab': 'ayh',
        'ayh-YE': 'ayh',
        'ayi': 'ayi',
        'ayi-Latn-NG': 'ayi',
        'ayi-Latn': 'ayi',
        'ayi-NG': 'ayi',
        'ayk': 'ayk',
        'ayk-Latn-NG': 'ayk',
        'ayk-Latn': 'ayk',
        'ayk-NG': 'ayk',
        'ayl': 'ayl',
        'ayl-Arab-LY': 'ayl',
        'ar-ayl': 'ayl',
        'ar-ayl-LY': 'ayl',
        'ayl-Arab': 'ayl',
        'ayl-LY': 'ayl',
        'ayn': 'ayn',
        'ayn-Arab-YE': 'ayn',
        'ar-ayn': 'ayn',
        'ar-ayn-YE': 'ayn',
        'ayn-Arab': 'ayn',
        'ayn-YE': 'ayn',
        'ayo': 'ayo',
        'ayo-Latn-PY': 'ayo',
        'ayo-Latn': 'ayo',
        'ayo-PY': 'ayo',
        'ayp': 'ayp',
        'ayp-Arab-IQ': 'ayp',
        'ar-ayp': 'ayp',
        'ar-ayp-IQ': 'ayp',
        'ayp-Arab': 'ayp',
        'ayp-IQ': 'ayp',
        'ayq': 'ayq',
        'ayq-Latn-PG': 'ayq',
        'ayq-Latn': 'ayq',
        'ayq-PG': 'ayq',
        'ays': 'ays',
        'ays-Latn-PH': 'ays',
        'ays-Latn': 'ays',
        'ays-PH': 'ays',
        'ayt': 'ayt',
        'ayt-Latn-PH': 'ayt',
        'ayt-Latn': 'ayt',
        'ayt-PH': 'ayt',
        'ayu': 'ayu',
        'ayu-Latn-NG': 'ayu',
        'ayu-Latn': 'ayu',
        'ayu-NG': 'ayu',
        'ayy': 'ayy',
        'ayy-Latn-PH': 'ayy',
        'ayy-Latn': 'ayy',
        'ayy-PH': 'ayy',
        'ayz': 'ayz',
        'ayz-Latn-ID': 'ayz',
        'ayz-ID': 'ayz',
        'ayz-Latn': 'ayz',
        'az': 'az',
        'az-Latn-AZ': 'az',
        'az-AZ': 'az',
        'az-Latn': 'az',
        'azj': 'az',
        'azj-AZ': 'az',
        'azj-Latn': 'az',
        'azj-Latn-AZ': 'az',
        'az-Brai': 'az-Brai',
        'az-Brai-IR': 'az-Brai',
        'azj-Brai': 'az-Brai',
        'azj-Brai-IR': 'az-Brai',
        'az-Cyrl-AZ': 'az-Cyrl-AZ',
        'az-IQ': 'az-IQ',
        'az-Arab-IQ': 'az-IQ',
        'az-IR': 'az-IR',
        'az-Arab-IR': 'az-IR',
        'az-Arab': 'az-IR',
        'azj-Arab': 'az-IR',
        'azj-Arab-IR': 'az-IR',
        'az-RU': 'az-RU',
        'az-Cyrl-RU': 'az-RU',
        'az-Cyrl': 'az-RU',
        'azj-Cyrl': 'az-RU',
        'azj-Cyrl-RU': 'az-RU',
        'aza': 'aza',
        'aza-Zyyy-CN': 'aza',
        'aza-CN': 'aza',
        'aza-Zyyy': 'aza',
        'azb': 'azb',
        'azb-Arab-IR': 'azb',
        'azb-Arab': 'azb',
        'azb-IR': 'azb',
        'azb-Cyrl': 'azb-Cyrl',
        'azb-Cyrl-AZ': 'azb-Cyrl',
        'azb-AZ': 'azb-Cyrl',
        'azd': 'azd',
        'azd-Latn-MX': 'azd',
        'azd-Latn': 'azd',
        'azd-MX': 'azd',
        'azg': 'azg',
        'azg-Latn-MX': 'azg',
        'azg-Latn': 'azg',
        'azg-MX': 'azg',
        'azm': 'azm',
        'azm-Latn-MX': 'azm',
        'azm-Latn': 'azm',
        'azm-MX': 'azm',
        'azn': 'azn',
        'azn-Latn-MX': 'azn',
        'azn-Latn': 'azn',
        'azn-MX': 'azn',
        'azo': 'azo',
        'azo-Latn-CM': 'azo',
        'azo-CM': 'azo',
        'azo-Latn': 'azo',
        'azt': 'azt',
        'azt-Latn-PH': 'azt',
        'azt-Latn': 'azt',
        'azt-PH': 'azt',
        'azz': 'azz',
        'azz-Latn-MX': 'azz',
        'azz-Latn': 'azz',
        'azz-MX': 'azz',
        'ba': 'ba',
        'ba-Cyrl-RU': 'ba',
        'ba-Cyrl': 'ba',
        'ba-RU': 'ba',
        'baa': 'baa',
        'baa-Latn-SB': 'baa',
        'baa-Latn': 'baa',
        'baa-SB': 'baa',
        'bab': 'bab',
        'bab-Latn-GW': 'bab',
        'bab-GW': 'bab',
        'bab-Latn': 'bab',
        'bac': 'bac',
        'bac-Latn-ID': 'bac',
        'bac-ID': 'bac',
        'bac-Latn': 'bac',
        'bae': 'bae',
        'bae-Latn-VE': 'bae',
        'bae-Latn': 'bae',
        'bae-VE': 'bae',
        'baf': 'baf',
        'baf-Latn-CM': 'baf',
        'baf-CM': 'baf',
        'baf-Latn': 'baf',
        'bag': 'bag',
        'bag-Latn-CM': 'bag',
        'bag-CM': 'bag',
        'bag-Latn': 'bag',
        'bah': 'bah',
        'bah-Latn-BS': 'bah',
        'bah-BS': 'bah',
        'bah-Latn': 'bah',
        'baj': 'baj',
        'baj-Latn-ID': 'baj',
        'baj-ID': 'baj',
        'baj-Latn': 'baj',
        'bal': 'bal',
        'bal-Arab-PK': 'bal',
        'bal-Arab': 'bal',
        'bal-PK': 'bal',
        'bcc': 'bal',
        'bcc-Arab': 'bal',
        'bcc-Arab-PK': 'bal',
        'bcc-PK': 'bal',
        'bal-Latn': 'bal-Latn',
        'bal-Latn-PK': 'bal-Latn',
        'bcc-Latn': 'bal-Latn',
        'bcc-Latn-PK': 'bal-Latn',
        'ban': 'ban',
        'ban-Latn-ID': 'ban',
        'ban-ID': 'ban',
        'ban-Latn': 'ban',
        'ban-Bali': 'ban-Bali',
        'ban-Bali-ID': 'ban-Bali',
        'ban-Java': 'ban-Java',
        'ban-Java-ID': 'ban-Java',
        'bao': 'bao',
        'bao-Latn-CO': 'bao',
        'bao-CO': 'bao',
        'bao-Latn': 'bao',
        'bap': 'bap',
        'bap-Deva-NP': 'bap',
        'bap-Deva': 'bap',
        'bap-NP': 'bap',
        'bar': 'bar',
        'bar-Latn-AT': 'bar',
        'bar-AT': 'bar',
        'bar-Latn': 'bar',
        'bas': 'bas',
        'bas-Latn-CM': 'bas',
        'bas-CM': 'bas',
        'bas-Latn': 'bas',
        'bau': 'bau',
        'bau-Latn-NG': 'bau',
        'bau-Latn': 'bau',
        'bau-NG': 'bau',
        'bav': 'bav',
        'bav-Latn-CM': 'bav',
        'bav-CM': 'bav',
        'bav-Latn': 'bav',
        'baw': 'baw',
        'baw-Latn-CM': 'baw',
        'baw-CM': 'baw',
        'baw-Latn': 'baw',
        'bax': 'bax',
        'bax-Bamu-CM': 'bax',
        'bax-Bamu': 'bax',
        'bax-CM': 'bax',
        'bax-Latn': 'bax-Latn',
        'bax-Latn-CM': 'bax-Latn',
        'bay': 'bay',
        'bay-Latn-ID': 'bay',
        'bay-ID': 'bay',
        'bay-Latn': 'bay',
        'bba': 'bba',
        'bba-Latn-BJ': 'bba',
        'bba-BJ': 'bba',
        'bba-Latn': 'bba',
        'bbb': 'bbb',
        'bbb-Latn-PG': 'bbb',
        'bbb-Latn': 'bbb',
        'bbb-PG': 'bbb',
        'bbc': 'bbc',
        'bbc-Latn-ID': 'bbc',
        'bbc-ID': 'bbc',
        'bbc-Latn': 'bbc',
        'bbc-Batk': 'bbc-Batk',
        'bbc-Batk-ID': 'bbc-Batk',
        'bbd': 'bbd',
        'bbd-Latn-PG': 'bbd',
        'bbd-Latn': 'bbd',
        'bbd-PG': 'bbd',
        'bbe': 'bbe',
        'bbe-Latn-CD': 'bbe',
        'bbe-CD': 'bbe',
        'bbe-Latn': 'bbe',
        'bbf': 'bbf',
        'bbf-Latn-PG': 'bbf',
        'bbf-Latn': 'bbf',
        'bbf-PG': 'bbf',
        'bbg': 'bbg',
        'bbg-Latn-GA': 'bbg',
        'bbg-GA': 'bbg',
        'bbg-Latn': 'bbg',
        'bbh': 'bbh',
        'bbh-Zyyy-CN': 'bbh',
        'bbh-CN': 'bbh',
        'bbh-Zyyy': 'bbh',
        'bbi': 'bbi',
        'bbi-Latn-CM': 'bbi',
        'bbi-CM': 'bbi',
        'bbi-Latn': 'bbi',
        'bbj': 'bbj',
        'bbj-Latn-CM': 'bbj',
        'bbj-CM': 'bbj',
        'bbj-Latn': 'bbj',
        'bbk': 'bbk',
        'bbk-Latn-CM': 'bbk',
        'bbk-CM': 'bbk',
        'bbk-Latn': 'bbk',
        'bbl': 'bbl',
        'bbl-Zyyy-GE': 'bbl',
        'bbl-GE': 'bbl',
        'bbl-Zyyy': 'bbl',
        'bbm': 'bbm',
        'bbm-Latn-CD': 'bbm',
        'bbm-CD': 'bbm',
        'bbm-Latn': 'bbm',
        'bbn': 'bbn',
        'bbn-Latn-PG': 'bbn',
        'bbn-Latn': 'bbn',
        'bbn-PG': 'bbn',
        'bbo': 'bbo',
        'bbo-Latn-BF': 'bbo',
        'bbo-BF': 'bbo',
        'bbo-Latn': 'bbo',
        'bbp': 'bbp',
        'bbp-Latn-CF': 'bbp',
        'bbp-CF': 'bbp',
        'bbp-Latn': 'bbp',
        'bbq': 'bbq',
        'bbq-Latn-CM': 'bbq',
        'bbq-CM': 'bbq',
        'bbq-Latn': 'bbq',
        'bbr': 'bbr',
        'bbr-Latn-PG': 'bbr',
        'bbr-Latn': 'bbr',
        'bbr-PG': 'bbr',
        'bbs': 'bbs',
        'bbs-Latn-NG': 'bbs',
        'bbs-Latn': 'bbs',
        'bbs-NG': 'bbs',
        'bbt': 'bbt',
        'bbt-Latn-NG': 'bbt',
        'bbt-Latn': 'bbt',
        'bbt-NG': 'bbt',
        'bbu': 'bbu',
        'bbu-Latn-NG': 'bbu',
        'bbu-Latn': 'bbu',
        'bbu-NG': 'bbu',
        'bbv': 'bbv',
        'bbv-Latn-PG': 'bbv',
        'bbv-Latn': 'bbv',
        'bbv-PG': 'bbv',
        'bbw': 'bbw',
        'bbw-Latn-CM': 'bbw',
        'bbw-CM': 'bbw',
        'bbw-Latn': 'bbw',
        'bbx': 'bbx',
        'bbx-Latn-CM': 'bbx',
        'bbx-CM': 'bbx',
        'bbx-Latn': 'bbx',
        'bby': 'bby',
        'bby-Latn-CM': 'bby',
        'bby-CM': 'bby',
        'bby-Latn': 'bby',
        'bbz': 'bbz',
        'bbz-Latn-TD': 'bbz',
        'ar-bbz': 'bbz',
        'ar-bbz-TD': 'bbz',
        'bbz-Latn': 'bbz',
        'bbz-TD': 'bbz',
        'bca': 'bca',
        'bca-Latn-CN': 'bca',
        'bca-CN': 'bca',
        'bca-Latn': 'bca',
        'bca-Hani': 'bca-Hani',
        'bca-Hani-CN': 'bca-Hani',
        'bcb': 'bcb',
        'bcb-Latn-SN': 'bcb',
        'bcb-Latn': 'bcb',
        'bcb-SN': 'bcb',
        'bcd': 'bcd',
        'bcd-Latn-ID': 'bcd',
        'bcd-ID': 'bcd',
        'bcd-Latn': 'bcd',
        'bce': 'bce',
        'bce-Latn-CM': 'bce',
        'bce-CM': 'bce',
        'bce-Latn': 'bce',
        'bcf': 'bcf',
        'bcf-Latn-PG': 'bcf',
        'bcf-Latn': 'bcf',
        'bcf-PG': 'bcf',
        'bcg': 'bcg',
        'bcg-Latn-GN': 'bcg',
        'bcg-GN': 'bcg',
        'bcg-Latn': 'bcg',
        'bgm': 'bcg',
        'bgm-GN': 'bcg',
        'bgm-Latn': 'bcg',
        'bgm-Latn-GN': 'bcg',
        'bch': 'bch',
        'bch-Latn-PG': 'bch',
        'bch-Latn': 'bch',
        'bch-PG': 'bch',
        'bci': 'bci',
        'bci-Latn-CI': 'bci',
        'bci-CI': 'bci',
        'bci-Latn': 'bci',
        'bcj': 'bcj',
        'bcj-Latn-AU': 'bcj',
        'bcj-AU': 'bcj',
        'bcj-Latn': 'bcj',
        'bck': 'bck',
        'bck-Latn-AU': 'bck',
        'bck-AU': 'bck',
        'bck-Latn': 'bck',
        'bcm': 'bcm',
        'bcm-Latn-PG': 'bcm',
        'bcm-Latn': 'bcm',
        'bcm-PG': 'bcm',
        'bcn': 'bcn',
        'bcn-Latn-NG': 'bcn',
        'bcn-Latn': 'bcn',
        'bcn-NG': 'bcn',
        'bco': 'bco',
        'bco-Latn-PG': 'bco',
        'bco-Latn': 'bco',
        'bco-PG': 'bco',
        'bcp': 'bcp',
        'bcp-Latn-CD': 'bcp',
        'bcp-CD': 'bcp',
        'bcp-Latn': 'bcp',
        'bcq': 'bcq',
        'bcq-Ethi-ET': 'bcq',
        'bcq-ET': 'bcq',
        'bcq-Ethi': 'bcq',
        'bcq-Latn': 'bcq-Latn',
        'bcq-Latn-ET': 'bcq-Latn',
        'bcr': 'bcr',
        'bcr-Latn-CA': 'bcr',
        'bcr-CA': 'bcr',
        'bcr-Latn': 'bcr',
        'bcs': 'bcs',
        'bcs-Latn-NG': 'bcs',
        'bcs-Latn': 'bcs',
        'bcs-NG': 'bcs',
        'bct': 'bct',
        'bct-Latn-CD': 'bct',
        'bct-CD': 'bct',
        'bct-Latn': 'bct',
        'bcu': 'bcu',
        'bcu-Latn-PG': 'bcu',
        'bcu-Latn': 'bcu',
        'bcu-PG': 'bcu',
        'bcv': 'bcv',
        'bcv-Latn-NG': 'bcv',
        'bcv-Latn': 'bcv',
        'bcv-NG': 'bcv',
        'bcw': 'bcw',
        'bcw-Latn-CM': 'bcw',
        'bcw-CM': 'bcw',
        'bcw-Latn': 'bcw',
        'bcy': 'bcy',
        'bcy-Latn-NG': 'bcy',
        'bcy-Latn': 'bcy',
        'bcy-NG': 'bcy',
        'bcz': 'bcz',
        'bcz-Latn-SN': 'bcz',
        'bcz-Latn': 'bcz',
        'bcz-SN': 'bcz',
        'bda': 'bda',
        'bda-Latn-SN': 'bda',
        'bda-Latn': 'bda',
        'bda-SN': 'bda',
        'bdb': 'bdb',
        'bdb-Latn-ID': 'bdb',
        'bdb-ID': 'bdb',
        'bdb-Latn': 'bdb',
        'bdc': 'bdc',
        'bdc-Latn-CO': 'bdc',
        'bdc-CO': 'bdc',
        'bdc-Latn': 'bdc',
        'bdd': 'bdd',
        'bdd-Latn-PG': 'bdd',
        'bdd-Latn': 'bdd',
        'bdd-PG': 'bdd',
        'bde': 'bde',
        'bde-Latn-NG': 'bde',
        'bde-Latn': 'bde',
        'bde-NG': 'bde',
        'bdf': 'bdf',
        'bdf-Latn-PG': 'bdf',
        'bdf-Latn': 'bdf',
        'bdf-PG': 'bdf',
        'bdg': 'bdg',
        'bdg-Latn-MY': 'bdg',
        'bdg-Latn': 'bdg',
        'bdg-MY': 'bdg',
        'bdh': 'bdh',
        'bdh-Latn-SS': 'bdh',
        'bdh-Latn': 'bdh',
        'bdh-SS': 'bdh',
        'bdi': 'bdi',
        'bdi-Latn-SD': 'bdi',
        'bdi-Latn': 'bdi',
        'bdi-SD': 'bdi',
        'bdj': 'bdj',
        'bdj-Latn-SS': 'bdj',
        'bdj-Latn': 'bdj',
        'bdj-SS': 'bdj',
        'bdk': 'bdk',
        'bdk-Latn-AZ': 'bdk',
        'bdk-AZ': 'bdk',
        'bdk-Latn': 'bdk',
        'bdl': 'bdl',
        'bdl-Latn-ID': 'bdl',
        'bdl-ID': 'bdl',
        'bdl-Latn': 'bdl',
        'bdm': 'bdm',
        'bdm-Latn-TD': 'bdm',
        'bdm-Latn': 'bdm',
        'bdm-TD': 'bdm',
        'bdn': 'bdn',
        'bdn-Latn-CM': 'bdn',
        'bdn-CM': 'bdn',
        'bdn-Latn': 'bdn',
        'bdo': 'bdo',
        'bdo-Latn-TD': 'bdo',
        'bdo-Latn': 'bdo',
        'bdo-TD': 'bdo',
        'bdp': 'bdp',
        'bdp-Latn-TZ': 'bdp',
        'bdp-Latn': 'bdp',
        'bdp-TZ': 'bdp',
        'bdq': 'bdq',
        'bdq-Latn-VN': 'bdq',
        'bdq-Latn': 'bdq',
        'bdq-VN': 'bdq',
        'bdr': 'bdr',
        'bdr-Latn-MY': 'bdr',
        'bdr-Latn': 'bdr',
        'bdr-MY': 'bdr',
        'bds': 'bds',
        'bds-Latn-TZ': 'bds',
        'bds-Latn': 'bds',
        'bds-TZ': 'bds',
        'bdt': 'bdt',
        'bdt-Latn-CF': 'bdt',
        'bdt-CF': 'bdt',
        'bdt-Latn': 'bdt',
        'bdu': 'bdu',
        'bdu-Latn-CM': 'bdu',
        'bdu-CM': 'bdu',
        'bdu-Latn': 'bdu',
        'bdv': 'bdv',
        'bdv-Orya-IN': 'bdv',
        'bdv-IN': 'bdv',
        'bdv-Orya': 'bdv',
        'bdw': 'bdw',
        'bdw-Latn-ID': 'bdw',
        'bdw-ID': 'bdw',
        'bdw-Latn': 'bdw',
        'bdx': 'bdx',
        'bdx-Latn-ID': 'bdx',
        'bdx-ID': 'bdx',
        'bdx-Latn': 'bdx',
        'bdy': 'bdy',
        'bdy-Latn-AU': 'bdy',
        'bdy-AU': 'bdy',
        'bdy-Latn': 'bdy',
        'bdz': 'bdz',
        'bdz-Arab-PK': 'bdz',
        'bdz-Arab': 'bdz',
        'bdz-PK': 'bdz',
        'be': 'be',
        'be-Cyrl-BY': 'be',
        'be-BY': 'be',
        'be-Cyrl': 'be',
        'be-Brai': 'be-Brai',
        'be-Brai-BY': 'be-Brai',
        'be-Latn': 'be-Latn',
        'be-Latn-BY': 'be-Latn',
        'bea': 'bea',
        'bea-Latn-CA': 'bea',
        'bea-CA': 'bea',
        'bea-Latn': 'bea',
        'bea-Cans': 'bea-Cans',
        'bea-Cans-CA': 'bea-Cans',
        'beb': 'beb',
        'beb-Latn-CM': 'beb',
        'beb-CM': 'beb',
        'beb-Latn': 'beb',
        'bec': 'bec',
        'bec-Latn-CM': 'bec',
        'bec-CM': 'bec',
        'bec-Latn': 'bec',
        'bed': 'bed',
        'bed-Latn-ID': 'bed',
        'bed-ID': 'bed',
        'bed-Latn': 'bed',
        'bee': 'bee',
        'bee-Deva-IN': 'bee',
        'bee-Deva': 'bee',
        'bee-IN': 'bee',
        'bef': 'bef',
        'bef-Latn-PG': 'bef',
        'bef-Latn': 'bef',
        'bef-PG': 'bef',
        'beg': 'beg',
        'beg-Zyyy-BN': 'beg',
        'beg-BN': 'beg',
        'beg-Zyyy': 'beg',
        'beh': 'beh',
        'beh-Latn-BJ': 'beh',
        'beh-BJ': 'beh',
        'beh-Latn': 'beh',
        'bei': 'bei',
        'bei-Latn-ID': 'bei',
        'bei-ID': 'bei',
        'bei-Latn': 'bei',
        'bej': 'bej',
        'bej-Arab-SD': 'bej',
        'bej-Arab': 'bej',
        'bej-SD': 'bej',
        'bej-Latn': 'bej-Latn',
        'bej-Latn-ER': 'bej-Latn',
        'bej-ER': 'bej-Latn',
        'bek': 'bek',
        'bek-Latn-PG': 'bek',
        'bek-Latn': 'bek',
        'bek-PG': 'bek',
        'bem': 'bem',
        'bem-Latn-ZM': 'bem',
        'bem-Latn': 'bem',
        'bem-ZM': 'bem',
        'bmy': 'bem',
        'bmy-Latn': 'bem',
        'bmy-Latn-ZM': 'bem',
        'bmy-ZM': 'bem',
        'bem-Brai': 'bem-Brai',
        'bem-Brai-ZM': 'bem-Brai',
        'beo': 'beo',
        'beo-Latn-PG': 'beo',
        'beo-Latn': 'beo',
        'beo-PG': 'beo',
        'bep': 'bep',
        'bep-Latn-ID': 'bep',
        'bep-ID': 'bep',
        'bep-Latn': 'bep',
        'beq': 'beq',
        'beq-Latn-CG': 'beq',
        'beq-CG': 'beq',
        'beq-Latn': 'beq',
        'bes': 'bes',
        'bes-Latn-TD': 'bes',
        'bes-Latn': 'bes',
        'bes-TD': 'bes',
        'bet': 'bet',
        'bet-Latn-CI': 'bet',
        'bet-CI': 'bet',
        'bet-Latn': 'bet',
        'beu': 'beu',
        'beu-Latn-ID': 'beu',
        'beu-ID': 'beu',
        'beu-Latn': 'beu',
        'bev': 'bev',
        'bev-Latn-CI': 'bev',
        'bev-CI': 'bev',
        'bev-Latn': 'bev',
        'bew': 'bew',
        'bew-Latn-ID': 'bew',
        'bew-ID': 'bew',
        'bew-Latn': 'bew',
        'bex': 'bex',
        'bex-Latn-SS': 'bex',
        'bex-Latn': 'bex',
        'bex-SS': 'bex',
        'bex-Arab': 'bex-Arab',
        'bex-Arab-SS': 'bex-Arab',
        'bey': 'bey',
        'bey-Latn-PG': 'bey',
        'bey-Latn': 'bey',
        'bey-PG': 'bey',
        'bez': 'bez',
        'bez-Latn-TZ': 'bez',
        'bez-Latn': 'bez',
        'bez-TZ': 'bez',
        'bfa': 'bfa',
        'bfa-Latn-SS': 'bfa',
        'bfa-Latn': 'bfa',
        'bfa-SS': 'bfa',
        'bfa-Arab': 'bfa-Arab',
        'bfa-Arab-SS': 'bfa-Arab',
        'bfb': 'bfb',
        'bfb-Deva-IN': 'bfb',
        'bfb-Deva': 'bfb',
        'bfb-IN': 'bfb',
        'bfc': 'bfc',
        'bfc-Latn-CN': 'bfc',
        'bfc-CN': 'bfc',
        'bfc-Latn': 'bfc',
        'bfd': 'bfd',
        'bfd-Latn-CM': 'bfd',
        'bfd-CM': 'bfd',
        'bfd-Latn': 'bfd',
        'bfe': 'bfe',
        'bfe-Latn-ID': 'bfe',
        'bfe-ID': 'bfe',
        'bfe-Latn': 'bfe',
        'bff': 'bff',
        'bff-Latn-CF': 'bff',
        'bff-CF': 'bff',
        'bff-Latn': 'bff',
        'bfg': 'bfg',
        'bfg-Latn-ID': 'bfg',
        'bfg-ID': 'bfg',
        'bfg-Latn': 'bfg',
        'bfh': 'bfh',
        'bfh-Latn-PG': 'bfh',
        'bfh-Latn': 'bfh',
        'bfh-PG': 'bfh',
        'bfi': 'bfi',
        'bfi-Zxxx-GB': 'bfi',
        'bfi-GB': 'bfi',
        'bfi-Zxxx': 'bfi',
        'sgn-bfi': 'bfi',
        'sgn-bfi-GB': 'bfi',
        'bfi-x-stokoe': 'bfi-x-stokoe',
        'bfi-Zzzz-GB-x-stokoe': 'bfi-x-stokoe',
        'bfi-GB-x-stokoe': 'bfi-x-stokoe',
        'bfi-Zzzz-x-stokoe': 'bfi-x-stokoe',
        'sgn-bfi-GB-x-stokoe': 'bfi-x-stokoe',
        'sgn-bfi-x-stokoe': 'bfi-x-stokoe',
        'bfj': 'bfj',
        'bfj-Latn-CM': 'bfj',
        'bfj-CM': 'bfj',
        'bfj-Latn': 'bfj',
        'bfk': 'bfk',
        'bfk-Zxxx-TH': 'bfk',
        'bfk-TH': 'bfk',
        'bfk-Zxxx': 'bfk',
        'sgn-bfk': 'bfk',
        'sgn-bfk-TH': 'bfk',
        'bfl': 'bfl',
        'bfl-Latn-CF': 'bfl',
        'bfl-CF': 'bfl',
        'bfl-Latn': 'bfl',
        'bfm': 'bfm',
        'bfm-Latn-CM': 'bfm',
        'bfm-CM': 'bfm',
        'bfm-Latn': 'bfm',
        'bfn': 'bfn',
        'bfn-Latn-TL': 'bfn',
        'bfn-Latn': 'bfn',
        'bfn-TL': 'bfn',
        'bfo': 'bfo',
        'bfo-Latn-BF': 'bfo',
        'bfo-BF': 'bfo',
        'bfo-Latn': 'bfo',
        'bfp': 'bfp',
        'bfp-Latn-CM': 'bfp',
        'bfp-CM': 'bfp',
        'bfp-Latn': 'bfp',
        'bfq': 'bfq',
        'bfq-Taml-IN': 'bfq',
        'bfq-IN': 'bfq',
        'bfq-Taml': 'bfq',
        'bfq-Knda': 'bfq-Knda',
        'bfq-Knda-IN': 'bfq-Knda',
        'bfq-Latn': 'bfq-Latn',
        'bfq-Latn-IN': 'bfq-Latn',
        'bfq-x-badaga': 'bfq-x-badaga',
        'bfq-Zzzz-IN-x-badaga': 'bfq-x-badaga',
        'bfq-IN-x-badaga': 'bfq-x-badaga',
        'bfq-Zzzz-x-badaga': 'bfq-x-badaga',
        'bfr': 'bfr',
        'bfr-Zyyy-IN': 'bfr',
        'bfr-IN': 'bfr',
        'bfr-Zyyy': 'bfr',
        'bfs': 'bfs',
        'bfs-Latn-CN': 'bfs',
        'bfs-CN': 'bfs',
        'bfs-Latn': 'bfs',
        'bfs-Hani': 'bfs-Hani',
        'bfs-Hani-CN': 'bfs-Hani',
        'bft': 'bft',
        'bft-Arab-PK': 'bft',
        'bft-Arab': 'bft',
        'bft-PK': 'bft',
        'bft-Tibt': 'bft-Tibt',
        'bft-Tibt-PK': 'bft-Tibt',
        'bft-x-baltia': 'bft-x-baltia',
        'bft-Zzzz-PK-x-baltia': 'bft-x-baltia',
        'bft-PK-x-baltia': 'bft-x-baltia',
        'bft-Zzzz-x-baltia': 'bft-x-baltia',
        'bfu': 'bfu',
        'bfu-Tibt-IN': 'bfu',
        'bfu-IN': 'bfu',
        'bfu-Tibt': 'bfu',
        'bfu-Takr': 'bfu-Takr',
        'bfu-Takr-IN': 'bfu-Takr',
        'bfw': 'bfw',
        'bfw-Orya-IN': 'bfw',
        'bfw-IN': 'bfw',
        'bfw-Orya': 'bfw',
        'bfx': 'bfx',
        'bfx-Latn-PH': 'bfx',
        'bfx-Latn': 'bfx',
        'bfx-PH': 'bfx',
        'bfy': 'bfy',
        'bfy-Deva-IN': 'bfy',
        'bfy-Deva': 'bfy',
        'bfy-IN': 'bfy',
        'ppa': 'bfy',
        'ppa-Deva': 'bfy',
        'ppa-Deva-IN': 'bfy',
        'ppa-IN': 'bfy',
        'bfz': 'bfz',
        'bfz-Deva-IN': 'bfz',
        'bfz-Deva': 'bfz',
        'bfz-IN': 'bfz',
        'bg': 'bg',
        'bg-Cyrl-BG': 'bg',
        'bg-BG': 'bg',
        'bg-Cyrl': 'bg',
        'bg-Brai': 'bg-Brai',
        'bg-Brai-BG': 'bg-Brai',
        'bg-Latn': 'bg-Latn',
        'bg-Latn-BG': 'bg-Latn',
        'bga': 'bga',
        'bga-Latn-NG': 'bga',
        'bga-Latn': 'bga',
        'bga-NG': 'bga',
        'bgb': 'bgb',
        'bgb-Latn-ID': 'bgb',
        'bgb-ID': 'bgb',
        'bgb-Latn': 'bgb',
        'bgc': 'bgc',
        'bgc-Deva-IN': 'bgc',
        'bgc-Deva': 'bgc',
        'bgc-IN': 'bgc',
        'bgd': 'bgd',
        'bgd-Deva-IN': 'bgd',
        'bgd-Deva': 'bgd',
        'bgd-IN': 'bgd',
        'bge': 'bge',
        'bge-Zyyy-IN': 'bge',
        'bge-IN': 'bge',
        'bge-Zyyy': 'bge',
        'bgf': 'bgf',
        'bgf-Latn-CM': 'bgf',
        'bgf-CM': 'bgf',
        'bgf-Latn': 'bgf',
        'bgg': 'bgg',
        'bgg-Latn-IN': 'bgg',
        'bgg-IN': 'bgg',
        'bgg-Latn': 'bgg',
        'bgi': 'bgi',
        'bgi-Latn-PH': 'bgi',
        'bgi-Latn': 'bgi',
        'bgi-PH': 'bgi',
        'bgj': 'bgj',
        'bgj-Latn-CM': 'bgj',
        'bgj-CM': 'bgj',
        'bgj-Latn': 'bgj',
        'bgk': 'bgk',
        'bgk-Zyyy-LA': 'bgk',
        'bgk-LA': 'bgk',
        'bgk-Zyyy': 'bgk',
        'bgl': 'bgl',
        'bgl-Zyyy-LA': 'bgl',
        'bgl-LA': 'bgl',
        'bgl-Zyyy': 'bgl',
        'bgn': 'bgn',
        'bgn-Arab-PK': 'bgn',
        'bgn-Arab': 'bgn',
        'bgn-PK': 'bgn',
        'bgn-Cyrl': 'bgn-Cyrl',
        'bgn-Cyrl-TM': 'bgn-Cyrl',
        'bgn-TM': 'bgn-Cyrl',
        'bgo': 'bgo',
        'bgo-Latn-GN': 'bgo',
        'bgo-GN': 'bgo',
        'bgo-Latn': 'bgo',
        'bgp': 'bgp',
        'bgp-Arab-PK': 'bgp',
        'bgp-Arab': 'bgp',
        'bgp-PK': 'bgp',
        'bgq': 'bgq',
        'bgq-Deva-IN': 'bgq',
        'bgq-Deva': 'bgq',
        'bgq-IN': 'bgq',
        'bgr': 'bgr',
        'bgr-Latn-IN': 'bgr',
        'bgr-IN': 'bgr',
        'bgr-Latn': 'bgr',
        'bgs': 'bgs',
        'bgs-Latn-PH': 'bgs',
        'bgs-Latn': 'bgs',
        'bgs-PH': 'bgs',
        'bgt': 'bgt',
        'bgt-Latn-SB': 'bgt',
        'bgt-Latn': 'bgt',
        'bgt-SB': 'bgt',
        'bgu': 'bgu',
        'bgu-Latn-NG': 'bgu',
        'bgu-Latn': 'bgu',
        'bgu-NG': 'bgu',
        'bgv': 'bgv',
        'bgv-Latn-ID': 'bgv',
        'bgv-ID': 'bgv',
        'bgv-Latn': 'bgv',
        'bgw': 'bgw',
        'bgw-Deva-IN': 'bgw',
        'bgw-Deva': 'bgw',
        'bgw-IN': 'bgw',
        'bgx': 'bgx',
        'bgx-Grek-TR': 'bgx',
        'bgx-Grek': 'bgx',
        'bgx-TR': 'bgx',
        'bgx-Latn': 'bgx-Latn',
        'bgx-Latn-TR': 'bgx-Latn',
        'bgy': 'bgy',
        'bgy-Latn-ID': 'bgy',
        'bgy-ID': 'bgy',
        'bgy-Latn': 'bgy',
        'bgz': 'bgz',
        'bgz-Latn-ID': 'bgz',
        'bgz-ID': 'bgz',
        'bgz-Latn': 'bgz',
        'bha': 'bha',
        'bha-Deva-IN': 'bha',
        'bha-Deva': 'bha',
        'bha-IN': 'bha',
        'bhb': 'bhb',
        'bhb-Deva-IN': 'bhb',
        'bhb-Deva': 'bhb',
        'bhb-IN': 'bhb',
        'bhb-Gujr': 'bhb-Gujr',
        'bhb-Gujr-IN': 'bhb-Gujr',
        'bhc': 'bhc',
        'bhc-Latn-ID': 'bhc',
        'bhc-ID': 'bhc',
        'bhc-Latn': 'bhc',
        'bhd-Arab': 'bhd-Arab',
        'bhd-Arab-IN': 'bhd-Arab',
        'bhd-Deva': 'bhd-Deva',
        'bhd-Deva-IN': 'bhd-Deva',
        'bhe': 'bhe',
        'bhe-Arab-PK': 'bhe',
        'bhe-Arab': 'bhe',
        'bhe-PK': 'bhe',
        'bhf': 'bhf',
        'bhf-Latn-PG': 'bhf',
        'bhf-Latn': 'bhf',
        'bhf-PG': 'bhf',
        'bhg': 'bhg',
        'bhg-Latn-PG': 'bhg',
        'bhg-Latn': 'bhg',
        'bhg-PG': 'bhg',
        'bhh': 'bhh',
        'bhh-Cyrl-IL': 'bhh',
        'bhh-Cyrl': 'bhh',
        'bhh-IL': 'bhh',
        'bhh-Hebr': 'bhh-Hebr',
        'bhh-Hebr-IL': 'bhh-Hebr',
        'bhh-Latn': 'bhh-Latn',
        'bhh-Latn-IL': 'bhh-Latn',
        'bhi': 'bhi',
        'bhi-Deva-IN': 'bhi',
        'bhi-Deva': 'bhi',
        'bhi-IN': 'bhi',
        'bhj': 'bhj',
        'bhj-Deva-NP': 'bhj',
        'bhj-Deva': 'bhj',
        'bhj-NP': 'bhj',
        'bhl': 'bhl',
        'bhl-Latn-PG': 'bhl',
        'bhl-Latn': 'bhl',
        'bhl-PG': 'bhl',
        'bhm': 'bhm',
        'bhm-Arab-OM': 'bhm',
        'bhm-Arab': 'bhm',
        'bhm-OM': 'bhm',
        'bhn': 'bhn',
        'bhn-Syrc-GE': 'bhn',
        'bhn-GE': 'bhn',
        'bhn-Syrc': 'bhn',
        'bho': 'bho',
        'bho-Deva-IN': 'bho',
        'bh-Deva': 'bho',
        'bh-Deva-IN': 'bho',
        'bho-Deva': 'bho',
        'bho-IN': 'bho',
        'bho-Kthi': 'bho-Kthi',
        'bho-Kthi-IN': 'bho-Kthi',
        'bh': 'bho-Kthi',
        'bh-IN': 'bho-Kthi',
        'bh-Kthi': 'bho-Kthi',
        'bh-Kthi-IN': 'bho-Kthi',
        'bhp': 'bhp',
        'bhp-Latn-ID': 'bhp',
        'bhp-ID': 'bhp',
        'bhp-Latn': 'bhp',
        'bhq': 'bhq',
        'bhq-Latn-ID': 'bhq',
        'bhq-ID': 'bhq',
        'bhq-Latn': 'bhq',
        'bhr': 'bhr',
        'bhr-Latn-MG': 'bhr',
        'bhr-Latn': 'bhr',
        'bhr-MG': 'bhr',
        'bhs': 'bhs',
        'bhs-Latn-CM': 'bhs',
        'bhs-CM': 'bhs',
        'bhs-Latn': 'bhs',
        'bht': 'bht',
        'bht-Zyyy-IN': 'bht',
        'bht-IN': 'bht',
        'bht-Zyyy': 'bht',
        'bhu': 'bhu',
        'bhu-Deva-IN': 'bhu',
        'bhu-Deva': 'bhu',
        'bhu-IN': 'bhu',
        'bhv': 'bhv',
        'bhv-Latn-ID': 'bhv',
        'bhv-ID': 'bhv',
        'bhv-Latn': 'bhv',
        'bhw': 'bhw',
        'bhw-Latn-ID': 'bhw',
        'bhw-ID': 'bhw',
        'bhw-Latn': 'bhw',
        'bhx': 'bhx',
        'bhx-Zyyy-IN': 'bhx',
        'bhx-IN': 'bhx',
        'bhx-Zyyy': 'bhx',
        'bhy': 'bhy',
        'bhy-Latn-CD': 'bhy',
        'bhy-CD': 'bhy',
        'bhy-Latn': 'bhy',
        'bhz': 'bhz',
        'bhz-Latn-ID': 'bhz',
        'bhz-ID': 'bhz',
        'bhz-Latn': 'bhz',
        'bi': 'bi',
        'bi-Latn-VU': 'bi',
        'bi-Latn': 'bi',
        'bi-VU': 'bi',
        'bia': 'bia',
        'bia-Latn-AU': 'bia',
        'bia-AU': 'bia',
        'bia-Latn': 'bia',
        'bib': 'bib',
        'bib-Latn-BF': 'bib',
        'bib-BF': 'bib',
        'bib-Latn': 'bib',
        'bic': 'bic',
        'bic-Latn-PG': 'bic',
        'bic-Latn': 'bic',
        'bic-PG': 'bic',
        'bid': 'bid',
        'bid-Latn-TD': 'bid',
        'bid-Latn': 'bid',
        'bid-TD': 'bid',
        'bie': 'bie',
        'bie-Latn-PG': 'bie',
        'bie-Latn': 'bie',
        'bie-PG': 'bie',
        'bif': 'bif',
        'bif-Latn-GW': 'bif',
        'bif-GW': 'bif',
        'bif-Latn': 'bif',
        'big': 'big',
        'big-Latn-PG': 'big',
        'big-Latn': 'big',
        'big-PG': 'big',
        'bij': 'bij',
        'bij-Latn-NG': 'bij',
        'bij-Latn': 'bij',
        'bij-NG': 'bij',
        'bik': 'bik',
        'bik-Latn-PH': 'bik',
        'bcl': 'bik',
        'bcl-Latn': 'bik',
        'bcl-Latn-PH': 'bik',
        'bcl-PH': 'bik',
        'bhk': 'bik',
        'bhk-Latn': 'bik',
        'bhk-Latn-PH': 'bik',
        'bhk-PH': 'bik',
        'bik-Latn': 'bik',
        'bik-PH': 'bik',
        'bik-Brai': 'bik-Brai',
        'bik-Brai-PH': 'bik-Brai',
        'bcl-Brai': 'bik-Brai',
        'bcl-Brai-PH': 'bik-Brai',
        'bil': 'bil',
        'bil-Latn-NG': 'bil',
        'bil-Latn': 'bil',
        'bil-NG': 'bil',
        'bim': 'bim',
        'bim-Latn-GH': 'bim',
        'bim-GH': 'bim',
        'bim-Latn': 'bim',
        'bin': 'bin',
        'bin-Latn-NG': 'bin',
        'bin-Latn': 'bin',
        'bin-NG': 'bin',
        'bio': 'bio',
        'bio-Latn-PG': 'bio',
        'bio-Latn': 'bio',
        'bio-PG': 'bio',
        'bip': 'bip',
        'bip-Latn-CD': 'bip',
        'bip-CD': 'bip',
        'bip-Latn': 'bip',
        'biq': 'biq',
        'biq-Latn-PG': 'biq',
        'biq-Latn': 'biq',
        'biq-PG': 'biq',
        'bir': 'bir',
        'bir-Latn-PG': 'bir',
        'bir-Latn': 'bir',
        'bir-PG': 'bir',
        'bit': 'bit',
        'bit-Latn-PG': 'bit',
        'bit-Latn': 'bit',
        'bit-PG': 'bit',
        'biu': 'biu',
        'biu-Latn-IN': 'biu',
        'biu-IN': 'biu',
        'biu-Latn': 'biu',
        'biv': 'biv',
        'biv-Latn-GH': 'biv',
        'biv-GH': 'biv',
        'biv-Latn': 'biv',
        'biw': 'biw',
        'biw-Latn-CM': 'biw',
        'biw-CM': 'biw',
        'biw-Latn': 'biw',
        'bix': 'bix',
        'bix-Zyyy-IN': 'bix',
        'bix-IN': 'bix',
        'bix-Zyyy': 'bix',
        'biy': 'biy',
        'biy-Deva-IN': 'biy',
        'biy-Deva': 'biy',
        'biy-IN': 'biy',
        'biz': 'biz',
        'biz-Latn-CD': 'biz',
        'biz-CD': 'biz',
        'biz-Latn': 'biz',
        'bja': 'bja',
        'bja-Latn-CD': 'bja',
        'bja-CD': 'bja',
        'bja-Latn': 'bja',
        'bjb': 'bjb',
        'bjb-Latn-AU': 'bjb',
        'bjb-AU': 'bjb',
        'bjb-Latn': 'bjb',
        'bjc': 'bjc',
        'bjc-Latn-PG': 'bjc',
        'bjc-Latn': 'bjc',
        'bjc-PG': 'bjc',
        'bje': 'bje',
        'bje-Zyyy-CN': 'bje',
        'bje-CN': 'bje',
        'bje-Zyyy': 'bje',
        'bjf': 'bjf',
        'bjf-Syrc-IL': 'bjf',
        'bjf-IL': 'bjf',
        'bjf-Syrc': 'bjf',
        'bjg': 'bjg',
        'bjg-Latn-GW': 'bjg',
        'bjg-GW': 'bjg',
        'bjg-Latn': 'bjg',
        'bjh': 'bjh',
        'bjh-Latn-PG': 'bjh',
        'bjh-Latn': 'bjh',
        'bjh-PG': 'bjh',
        'bji': 'bji',
        'bji-Ethi-ET': 'bji',
        'bji-ET': 'bji',
        'bji-Ethi': 'bji',
        'bjj': 'bjj',
        'bjj-Deva-IN': 'bjj',
        'bjj-Deva': 'bjj',
        'bjj-IN': 'bjj',
        'bjk': 'bjk',
        'bjk-Latn-PG': 'bjk',
        'bjk-Latn': 'bjk',
        'bjk-PG': 'bjk',
        'bjl': 'bjl',
        'bjl-Latn-PG': 'bjl',
        'bjl-Latn': 'bjl',
        'bjl-PG': 'bjl',
        'bjm': 'bjm',
        'bjm-Zyyy-IQ': 'bjm',
        'bjm-IQ': 'bjm',
        'bjm-Zyyy': 'bjm',
        'bjn': 'bjn',
        'bjn-Latn-ID': 'bjn',
        'bjn-ID': 'bjn',
        'bjn-Latn': 'bjn',
        'ms-bjn': 'bjn',
        'ms-bjn-ID': 'bjn',
        'bjn-Arab': 'bjn-Arab',
        'bjn-Arab-ID': 'bjn-Arab',
        'bjo': 'bjo',
        'bjo-Latn-CF': 'bjo',
        'bjo-CF': 'bjo',
        'bjo-Latn': 'bjo',
        'bjp': 'bjp',
        'bjp-Latn-PG': 'bjp',
        'bjp-Latn': 'bjp',
        'bjp-PG': 'bjp',
        'bjr': 'bjr',
        'bjr-Latn-PG': 'bjr',
        'bjr-Latn': 'bjr',
        'bjr-PG': 'bjr',
        'bjs': 'bjs',
        'bjs-Latn-BB': 'bjs',
        'bjs-BB': 'bjs',
        'bjs-Latn': 'bjs',
        'bjt': 'bjt',
        'bjt-Latn-SN': 'bjt',
        'bjt-Latn': 'bjt',
        'bjt-SN': 'bjt',
        'bjt-Arab': 'bjt-Arab',
        'bjt-Arab-SN': 'bjt-Arab',
        'bju': 'bju',
        'bju-Latn-CM': 'bju',
        'bju-CM': 'bju',
        'bju-Latn': 'bju',
        'bjv': 'bjv',
        'bjv-Latn-TD': 'bjv',
        'bjv-Latn': 'bjv',
        'bjv-TD': 'bjv',
        'bjw': 'bjw',
        'bjw-Latn-CI': 'bjw',
        'bjw-CI': 'bjw',
        'bjw-Latn': 'bjw',
        'bjx': 'bjx',
        'bjx-Latn-PH': 'bjx',
        'bjx-Latn': 'bjx',
        'bjx-PH': 'bjx',
        'bjy': 'bjy',
        'bjy-Latn-AU': 'bjy',
        'bjy-AU': 'bjy',
        'bjy-Latn': 'bjy',
        'bjz': 'bjz',
        'bjz-Latn-PG': 'bjz',
        'bjz-Latn': 'bjz',
        'bjz-PG': 'bjz',
        'bka': 'bka',
        'bka-Latn-NG': 'bka',
        'bka-Latn': 'bka',
        'bka-NG': 'bka',
        'bkc': 'bkc',
        'bkc-Latn-CM': 'bkc',
        'bkc-CM': 'bkc',
        'bkc-Latn': 'bkc',
        'bkd': 'bkd',
        'bkd-Latn-PH': 'bkd',
        'bkd-Latn': 'bkd',
        'bkd-PH': 'bkd',
        'bkf': 'bkf',
        'bkf-Latn-CD': 'bkf',
        'bkf-CD': 'bkf',
        'bkf-Latn': 'bkf',
        'bkg': 'bkg',
        'bkg-Latn-CF': 'bkg',
        'bkg-CF': 'bkg',
        'bkg-Latn': 'bkg',
        'bkh': 'bkh',
        'bkh-Latn-CM': 'bkh',
        'bkh-CM': 'bkh',
        'bkh-Latn': 'bkh',
        'bki': 'bki',
        'bki-Latn-VU': 'bki',
        'bki-Latn': 'bki',
        'bki-VU': 'bki',
        'bkj': 'bkj',
        'bkj-Latn-CF': 'bkj',
        'bkj-CF': 'bkj',
        'bkj-Latn': 'bkj',
        'bkk-x-baltia': 'bkk-x-baltia',
        'bkk-Zzzz-IN-x-baltia': 'bkk-x-baltia',
        'bkk-IN-x-baltia': 'bkk-x-baltia',
        'bkk-Zzzz-x-baltia': 'bkk-x-baltia',
        'bkl': 'bkl',
        'bkl-Latn-ID': 'bkl',
        'bkl-ID': 'bkl',
        'bkl-Latn': 'bkl',
        'bkm': 'bkm',
        'bkm-Latn-CM': 'bkm',
        'bkm-CM': 'bkm',
        'bkm-Latn': 'bkm',
        'bkn': 'bkn',
        'bkn-Latn-ID': 'bkn',
        'bkn-ID': 'bkn',
        'bkn-Latn': 'bkn',
        'bko': 'bko',
        'bko-Latn-CM': 'bko',
        'bko-CM': 'bko',
        'bko-Latn': 'bko',
        'bkp': 'bkp',
        'bkp-Latn-CD': 'bkp',
        'bkp-CD': 'bkp',
        'bkp-Latn': 'bkp',
        'bkq': 'bkq',
        'bkq-Latn-BR': 'bkq',
        'bkq-BR': 'bkq',
        'bkq-Latn': 'bkq',
        'bkr': 'bkr',
        'bkr-Latn-ID': 'bkr',
        'bkr-ID': 'bkr',
        'bkr-Latn': 'bkr',
        'bks': 'bks',
        'bks-Latn-PH': 'bks',
        'bks-Latn': 'bks',
        'bks-PH': 'bks',
        'bkt': 'bkt',
        'bkt-Latn-CD': 'bkt',
        'bkt-CD': 'bkt',
        'bkt-Latn': 'bkt',
        'bku': 'bku',
        'bku-Latn-PH': 'bku',
        'bku-Latn': 'bku',
        'bku-PH': 'bku',
        'bku-Buhd': 'bku-Buhd',
        'bku-Buhd-PH': 'bku-Buhd',
        'bkv': 'bkv',
        'bkv-Latn-NG': 'bkv',
        'bkv-Latn': 'bkv',
        'bkv-NG': 'bkv',
        'bkw': 'bkw',
        'bkw-Latn-CG': 'bkw',
        'bkw-CG': 'bkw',
        'bkw-Latn': 'bkw',
        'bkx': 'bkx',
        'bkx-Latn-TL': 'bkx',
        'bkx-Latn': 'bkx',
        'bkx-TL': 'bkx',
        'bky': 'bky',
        'bky-Latn-NG': 'bky',
        'bky-Latn': 'bky',
        'bky-NG': 'bky',
        'bkz': 'bkz',
        'bkz-Latn-ID': 'bkz',
        'bkz-ID': 'bkz',
        'bkz-Latn': 'bkz',
        'bla': 'bla',
        'bla-Latn-CA': 'bla',
        'bla-CA': 'bla',
        'bla-Latn': 'bla',
        'bla-Cans': 'bla-Cans',
        'bla-Cans-CA': 'bla-Cans',
        'blb': 'blb',
        'blb-Latn-SB': 'blb',
        'blb-Latn': 'blb',
        'blb-SB': 'blb',
        'blc': 'blc',
        'blc-Latn-CA': 'blc',
        'blc-CA': 'blc',
        'blc-Latn': 'blc',
        'bld': 'bld',
        'bld-Latn-ID': 'bld',
        'bld-ID': 'bld',
        'bld-Latn': 'bld',
        'ble': 'ble',
        'ble-Latn-GW': 'ble',
        'ble-GW': 'ble',
        'ble-Latn': 'ble',
        'blf': 'blf',
        'blf-Latn-ID': 'blf',
        'blf-ID': 'blf',
        'blf-Latn': 'blf',
        'blg': 'blg',
        'blg-Latn-MY': 'blg',
        'blg-Latn': 'blg',
        'blg-MY': 'blg',
        'blh': 'blh',
        'blh-Latn-LR': 'blh',
        'blh-LR': 'blh',
        'blh-Latn': 'blh',
        'bli': 'bli',
        'bli-Latn-CD': 'bli',
        'bli-CD': 'bli',
        'bli-Latn': 'bli',
        'blj': 'blj',
        'blj-Latn-ID': 'blj',
        'blj-ID': 'blj',
        'blj-Latn': 'blj',
        'blk': 'blk',
        'blk-Mymr-MM': 'blk',
        'blk-MM': 'blk',
        'blk-Mymr': 'blk',
        'bll': 'bll',
        'bll-Zyyy-US': 'bll',
        'bll-US': 'bll',
        'bll-Zyyy': 'bll',
        'blm': 'blm',
        'blm-Latn-SS': 'blm',
        'blm-Latn': 'blm',
        'blm-SS': 'blm',
        'bln': 'bln',
        'bln-Latn-PH': 'bln',
        'bln-Latn': 'bln',
        'bln-PH': 'bln',
        'blo': 'blo',
        'blo-Latn-BJ': 'blo',
        'blo-BJ': 'blo',
        'blo-Latn': 'blo',
        'blp': 'blp',
        'blp-Latn-SB': 'blp',
        'blp-Latn': 'blp',
        'blp-SB': 'blp',
        'blq': 'blq',
        'blq-Latn-PG': 'blq',
        'blq-Latn': 'blq',
        'blq-PG': 'blq',
        'blr': 'blr',
        'blr-Latn-CN': 'blr',
        'blr-CN': 'blr',
        'blr-Latn': 'blr',
        'blr-Latn-x-pangpung': 'blr-Latn-x-pangpung',
        'blr-Latn-MM-x-pangpung': 'blr-Latn-x-pangpung',
        'blr-MM-x-pangpung': 'blr-Latn-x-pangpung',
        'blr-Tale': 'blr-Tale',
        'blr-Tale-CN': 'blr-Tale',
        'blr-Thai': 'blr-Thai',
        'blr-Thai-TH': 'blr-Thai',
        'blr-TH': 'blr-Thai',
        'bls': 'bls',
        'bls-Latn-ID': 'bls',
        'bls-ID': 'bls',
        'bls-Latn': 'bls',
        'blt': 'blt',
        'blt-Tavt-VN': 'blt',
        'blt-Tavt': 'blt',
        'blt-VN': 'blt',
        'blt-Laoo': 'blt-Laoo',
        'blt-Laoo-LA': 'blt-Laoo',
        'blt-LA': 'blt-Laoo',
        'blt-Latn': 'blt-Latn',
        'blt-Latn-VN': 'blt-Latn',
        'blv': 'blv',
        'blv-Latn-AO': 'blv',
        'blv-AO': 'blv',
        'blv-Latn': 'blv',
        'blw': 'blw',
        'blw-Latn-PH': 'blw',
        'blw-Latn': 'blw',
        'blw-PH': 'blw',
        'blx': 'blx',
        'blx-Latn-PH': 'blx',
        'blx-Latn': 'blx',
        'blx-PH': 'blx',
        'bly': 'bly',
        'bly-Latn-BJ': 'bly',
        'bly-BJ': 'bly',
        'bly-Latn': 'bly',
        'blz': 'blz',
        'blz-Latn-ID': 'blz',
        'blz-ID': 'blz',
        'blz-Latn': 'blz',
        'bm': 'bm',
        'bm-Latn-ML': 'bm',
        'bm-Latn': 'bm',
        'bm-ML': 'bm',
        'bm-Arab': 'bm-Arab',
        'bm-Arab-ML': 'bm-Arab',
        'bm-Nkoo': 'bm-Nkoo',
        'bm-Nkoo-ML': 'bm-Nkoo',
        'bma': 'bma',
        'bma-Latn-NG': 'bma',
        'bma-Latn': 'bma',
        'bma-NG': 'bma',
        'bmb': 'bmb',
        'bmb-Latn-CD': 'bmb',
        'bmb-CD': 'bmb',
        'bmb-Latn': 'bmb',
        'bmc': 'bmc',
        'bmc-Latn-PG': 'bmc',
        'bmc-Latn': 'bmc',
        'bmc-PG': 'bmc',
        'bmd': 'bmd',
        'bmd-Latn-GN': 'bmd',
        'bmd-GN': 'bmd',
        'bmd-Latn': 'bmd',
        'bme': 'bme',
        'bme-Latn-CF': 'bme',
        'bme-CF': 'bme',
        'bme-Latn': 'bme',
        'bmf': 'bmf',
        'bmf-Latn-SL': 'bmf',
        'bmf-Latn': 'bmf',
        'bmf-SL': 'bmf',
        'krm': 'bmf',
        'krm-Latn': 'bmf',
        'krm-Latn-SL': 'bmf',
        'krm-SL': 'bmf',
        'bmg': 'bmg',
        'bmg-Latn-CD': 'bmg',
        'bmg-CD': 'bmg',
        'bmg-Latn': 'bmg',
        'bmh': 'bmh',
        'bmh-Latn-PG': 'bmh',
        'bmh-Latn': 'bmh',
        'bmh-PG': 'bmh',
        'bmi': 'bmi',
        'bmi-Latn-TD': 'bmi',
        'bmi-Latn': 'bmi',
        'bmi-TD': 'bmi',
        'bmj': 'bmj',
        'bmj-Deva-NP': 'bmj',
        'bmj-Deva': 'bmj',
        'bmj-NP': 'bmj',
        'bmk': 'bmk',
        'bmk-Latn-PG': 'bmk',
        'bmk-Latn': 'bmk',
        'bmk-PG': 'bmk',
        'bml': 'bml',
        'bml-Latn-CD': 'bml',
        'bml-CD': 'bml',
        'bml-Latn': 'bml',
        'bmm': 'bmm',
        'bmm-Latn-MG': 'bmm',
        'bmm-Latn': 'bmm',
        'bmm-MG': 'bmm',
        'bmn': 'bmn',
        'bmn-Latn-PG': 'bmn',
        'bmn-Latn': 'bmn',
        'bmn-PG': 'bmn',
        'bmo': 'bmo',
        'bmo-Latn-CM': 'bmo',
        'bmo-CM': 'bmo',
        'bmo-Latn': 'bmo',
        'bmp': 'bmp',
        'bmp-Latn-PG': 'bmp',
        'bmp-Latn': 'bmp',
        'bmp-PG': 'bmp',
        'bmq': 'bmq',
        'bmq-Latn-ML': 'bmq',
        'bmq-Latn': 'bmq',
        'bmq-ML': 'bmq',
        'bmr': 'bmr',
        'bmr-Latn-CO': 'bmr',
        'bmr-CO': 'bmr',
        'bmr-Latn': 'bmr',
        'bms': 'bms',
        'bms-Latn-NE': 'bms',
        'bms-Latn': 'bms',
        'bms-NE': 'bms',
        'bmt': 'bmt',
        'bmt-Zyyy-CN': 'bmt',
        'bmt-CN': 'bmt',
        'bmt-Zyyy': 'bmt',
        'bmu': 'bmu',
        'bmu-Latn-PG': 'bmu',
        'bmu-Latn': 'bmu',
        'bmu-PG': 'bmu',
        'bmv': 'bmv',
        'bmv-Latn-CM': 'bmv',
        'bmv-CM': 'bmv',
        'bmv-Latn': 'bmv',
        'bmw': 'bmw',
        'bmw-Latn-CG': 'bmw',
        'bmw-CG': 'bmw',
        'bmw-Latn': 'bmw',
        'bmx': 'bmx',
        'bmx-Latn-PG': 'bmx',
        'bmx-Latn': 'bmx',
        'bmx-PG': 'bmx',
        'bmz': 'bmz',
        'bmz-Latn-PG': 'bmz',
        'bmz-Latn': 'bmz',
        'bmz-PG': 'bmz',
        'bn': 'bn',
        'bn-Beng-BD': 'bn',
        'bn-BD': 'bn',
        'bn-Beng': 'bn',
        'bn-Brai': 'bn-Brai',
        'bn-Brai-BD': 'bn-Brai',
        'bn-IN': 'bn-IN',
        'bn-Beng-IN': 'bn-IN',
        'bn-Newa': 'bn-Newa',
        'bn-Newa-NP': 'bn-Newa',
        'bn-NP': 'bn-Newa',
        'bna': 'bna',
        'bna-Latn-ID': 'bna',
        'bna-ID': 'bna',
        'bna-Latn': 'bna',
        'bnb': 'bnb',
        'bnb-Latn-MY': 'bnb',
        'bnb-Latn': 'bnb',
        'bnb-MY': 'bnb',
        'bnc': 'bnc',
        'bnc-Latn-PH': 'bnc',
        'bkb': 'bnc',
        'bkb-Latn': 'bnc',
        'bkb-Latn-PH': 'bnc',
        'bkb-PH': 'bnc',
        'bnc-Latn': 'bnc',
        'bnc-PH': 'bnc',
        'lbk': 'bnc',
        'lbk-Latn': 'bnc',
        'lbk-Latn-PH': 'bnc',
        'lbk-PH': 'bnc',
        'bnd': 'bnd',
        'bnd-Latn-ID': 'bnd',
        'bnd-ID': 'bnd',
        'bnd-Latn': 'bnd',
        'bne': 'bne',
        'bne-Latn-ID': 'bne',
        'bne-ID': 'bne',
        'bne-Latn': 'bne',
        'bnf': 'bnf',
        'bnf-Latn-ID': 'bnf',
        'bnf-ID': 'bnf',
        'bnf-Latn': 'bnf',
        'bng': 'bng',
        'bng-Latn-GQ': 'bng',
        'bng-GQ': 'bng',
        'bng-Latn': 'bng',
        'bni': 'bni',
        'bni-Latn-CD': 'bni',
        'bni-CD': 'bni',
        'bni-Latn': 'bni',
        'bnj': 'bnj',
        'bnj-Latn-PH': 'bnj',
        'bnj-Latn': 'bnj',
        'bnj-PH': 'bnj',
        'bnk': 'bnk',
        'bnk-Latn-VU': 'bnk',
        'bnk-Latn': 'bnk',
        'bnk-VU': 'bnk',
        'bnl': 'bnl',
        'bnl-Zyyy-SO': 'bnl',
        'bnl-SO': 'bnl',
        'bnl-Zyyy': 'bnl',
        'bnm': 'bnm',
        'bnm-Latn-GQ': 'bnm',
        'bnm-GQ': 'bnm',
        'bnm-Latn': 'bnm',
        'bnn': 'bnn',
        'bnn-Latn-TW': 'bnn',
        'bnn-Latn': 'bnn',
        'bnn-TW': 'bnn',
        'bno': 'bno',
        'bno-Latn-PH': 'bno',
        'bno-Latn': 'bno',
        'bno-PH': 'bno',
        'bnp': 'bnp',
        'bnp-Latn-PG': 'bnp',
        'bnp-Latn': 'bnp',
        'bnp-PG': 'bnp',
        'bnq': 'bnq',
        'bnq-Latn-ID': 'bnq',
        'bnq-ID': 'bnq',
        'bnq-Latn': 'bnq',
        'bnr': 'bnr',
        'bnr-Latn-VU': 'bnr',
        'bnr-Latn': 'bnr',
        'bnr-VU': 'bnr',
        'bns': 'bns',
        'bns-Deva-IN': 'bns',
        'bns-Deva': 'bns',
        'bns-IN': 'bns',
        'bnu': 'bnu',
        'bnu-Latn-ID': 'bnu',
        'bnu-ID': 'bnu',
        'bnu-Latn': 'bnu',
        'bnv': 'bnv',
        'bnv-Latn-ID': 'bnv',
        'bnv-ID': 'bnv',
        'bnv-Latn': 'bnv',
        'bnw': 'bnw',
        'bnw-Latn-PG': 'bnw',
        'bnw-Latn': 'bnw',
        'bnw-PG': 'bnw',
        'bnx': 'bnx',
        'bnx-Latn-CD': 'bnx',
        'bnx-CD': 'bnx',
        'bnx-Latn': 'bnx',
        'bny': 'bny',
        'bny-Latn-MY': 'bny',
        'bny-Latn': 'bny',
        'bny-MY': 'bny',
        'bnz': 'bnz',
        'bnz-Latn-CM': 'bnz',
        'bnz-CM': 'bnz',
        'bnz-Latn': 'bnz',
        'bo': 'bo',
        'bo-Tibt-CN': 'bo',
        'bo-CN': 'bo',
        'bo-Tibt': 'bo',
        'bo-IN': 'bo-IN',
        'bo-Tibt-IN': 'bo-IN',
        'bo-Latn': 'bo-Latn',
        'bo-Latn-CN': 'bo-Latn',
        'bo-Marc': 'bo-Marc',
        'bo-Marc-CN': 'bo-Marc',
        'bo-Phag': 'bo-Phag',
        'bo-Phag-CN': 'bo-Phag',
        'boa': 'boa',
        'boa-Latn-PE': 'boa',
        'boa-Latn': 'boa',
        'boa-PE': 'boa',
        'bob': 'bob',
        'bob-Latn-KE': 'bob',
        'bob-KE': 'bob',
        'bob-Latn': 'bob',
        'boe': 'boe',
        'boe-Latn-CM': 'boe',
        'boe-CM': 'boe',
        'boe-Latn': 'boe',
        'bof': 'bof',
        'bof-Latn-BF': 'bof',
        'bof-BF': 'bof',
        'bof-Latn': 'bof',
        'bog': 'bog',
        'bog-Zxxx-ML': 'bog',
        'bog-ML': 'bog',
        'bog-Zxxx': 'bog',
        'sgn-bog': 'bog',
        'sgn-bog-ML': 'bog',
        'boh': 'boh',
        'boh-Latn-CD': 'boh',
        'boh-CD': 'boh',
        'boh-Latn': 'boh',
        'boi': 'boi',
        'boi-Zyyy-US': 'boi',
        'boi-US': 'boi',
        'boi-Zyyy': 'boi',
        'boj': 'boj',
        'boj-Latn-PG': 'boj',
        'boj-Latn': 'boj',
        'boj-PG': 'boj',
        'bok': 'bok',
        'bok-Latn-CG': 'bok',
        'bok-CG': 'bok',
        'bok-Latn': 'bok',
        'bol': 'bol',
        'bol-Latn-NG': 'bol',
        'bol-Latn': 'bol',
        'bol-NG': 'bol',
        'bom': 'bom',
        'bom-Latn-NG': 'bom',
        'bom-Latn': 'bom',
        'bom-NG': 'bom',
        'bon': 'bon',
        'bon-Latn-PG': 'bon',
        'bon-Latn': 'bon',
        'bon-PG': 'bon',
        'boo': 'boo',
        'boo-Latn-ML': 'boo',
        'boo-Latn': 'boo',
        'boo-ML': 'boo',
        'bop': 'bop',
        'bop-Latn-PG': 'bop',
        'bop-Latn': 'bop',
        'bop-PG': 'bop',
        'boq': 'boq',
        'boq-Latn-PG': 'boq',
        'boq-Latn': 'boq',
        'boq-PG': 'boq',
        'bor': 'bor',
        'bor-Latn-BR': 'bor',
        'bor-BR': 'bor',
        'bor-Latn': 'bor',
        'bot': 'bot',
        'bot-Latn-SS': 'bot',
        'bot-Latn': 'bot',
        'bot-SS': 'bot',
        'bou': 'bou',
        'bou-Latn-TZ': 'bou',
        'bou-Latn': 'bou',
        'bou-TZ': 'bou',
        'bov': 'bov',
        'bov-Latn-GH': 'bov',
        'bov-GH': 'bov',
        'bov-Latn': 'bov',
        'bow': 'bow',
        'bow-Latn-PG': 'bow',
        'bow-Latn': 'bow',
        'bow-PG': 'bow',
        'box': 'box',
        'box-Latn-BF': 'box',
        'box-BF': 'box',
        'box-Latn': 'box',
        'boy': 'boy',
        'boy-Latn-CF': 'boy',
        'boy-CF': 'boy',
        'boy-Latn': 'boy',
        'boz': 'boz',
        'boz-Latn-ML': 'boz',
        'boz-Latn': 'boz',
        'boz-ML': 'boz',
        'boz-Arab': 'boz-Arab',
        'boz-Arab-ML': 'boz-Arab',
        'bpa': 'bpa',
        'bpa-Latn-VU': 'bpa',
        'bpa-Latn': 'bpa',
        'bpa-VU': 'bpa',
        'bpb': 'bpb',
        'bpb-Latn-CO': 'bpb',
        'bpb-CO': 'bpb',
        'bpb-Latn': 'bpb',
        'bpd': 'bpd',
        'bpd-Latn-CF': 'bpd',
        'bpd-CF': 'bpd',
        'bpd-Latn': 'bpd',
        'bpg': 'bpg',
        'bpg-Latn-ID': 'bpg',
        'bpg-ID': 'bpg',
        'bpg-Latn': 'bpg',
        'bph': 'bph',
        'bph-Cyrl-RU': 'bph',
        'bph-Cyrl': 'bph',
        'bph-RU': 'bph',
        'bpi': 'bpi',
        'bpi-Latn-PG': 'bpi',
        'bpi-Latn': 'bpi',
        'bpi-PG': 'bpi',
        'bpj': 'bpj',
        'bpj-Latn-CD': 'bpj',
        'bpj-CD': 'bpj',
        'bpj-Latn': 'bpj',
        'bpk': 'bpk',
        'bpk-Latn-NC': 'bpk',
        'bpk-Latn': 'bpk',
        'bpk-NC': 'bpk',
        'bpl': 'bpl',
        'bpl-Latn-AU': 'bpl',
        'bpl-AU': 'bpl',
        'bpl-Latn': 'bpl',
        'bpm': 'bpm',
        'bpm-Latn-PG': 'bpm',
        'bpm-Latn': 'bpm',
        'bpm-PG': 'bpm',
        'bpn': 'bpn',
        'bpn-Zyyy-CN': 'bpn',
        'bpn-CN': 'bpn',
        'bpn-Zyyy': 'bpn',
        'bpo': 'bpo',
        'bpo-Latn-ID': 'bpo',
        'bpo-ID': 'bpo',
        'bpo-Latn': 'bpo',
        'bpp': 'bpp',
        'bpp-Latn-ID': 'bpp',
        'bpp-ID': 'bpp',
        'bpp-Latn': 'bpp',
        'nxu': 'bpp',
        'nxu-ID': 'bpp',
        'nxu-Latn': 'bpp',
        'nxu-Latn-ID': 'bpp',
        'bpq': 'bpq',
        'bpq-Latn-ID': 'bpq',
        'bpq-ID': 'bpq',
        'bpq-Latn': 'bpq',
        'bpr': 'bpr',
        'bpr-Latn-PH': 'bpr',
        'bpr-Latn': 'bpr',
        'bpr-PH': 'bpr',
        'bps': 'bps',
        'bps-Latn-PH': 'bps',
        'bps-Latn': 'bps',
        'bps-PH': 'bps',
        'bpt': 'bpt',
        'bpt-Latn-AU': 'bpt',
        'bpt-AU': 'bpt',
        'bpt-Latn': 'bpt',
        'bpu': 'bpu',
        'bpu-Latn-PG': 'bpu',
        'bpu-Latn': 'bpu',
        'bpu-PG': 'bpu',
        'bpv': 'bpv',
        'bpv-Latn-ID': 'bpv',
        'bpv-ID': 'bpv',
        'bpv-Latn': 'bpv',
        'bpw': 'bpw',
        'bpw-Latn-PG': 'bpw',
        'bpw-Latn': 'bpw',
        'bpw-PG': 'bpw',
        'bpx': 'bpx',
        'bpx-Deva-IN': 'bpx',
        'bpx-Deva': 'bpx',
        'bpx-IN': 'bpx',
        'bpy': 'bpy',
        'bpy-Beng-IN': 'bpy',
        'bpy-Beng': 'bpy',
        'bpy-IN': 'bpy',
        'bpz': 'bpz',
        'bpz-Latn-ID': 'bpz',
        'bpz-ID': 'bpz',
        'bpz-Latn': 'bpz',
        'bqa': 'bqa',
        'bqa-Latn-BJ': 'bqa',
        'bqa-BJ': 'bqa',
        'bqa-Latn': 'bqa',
        'bqb': 'bqb',
        'bqb-Latn-ID': 'bqb',
        'bqb-ID': 'bqb',
        'bqb-Latn': 'bqb',
        'bqc': 'bqc',
        'bqc-Latn-BJ': 'bqc',
        'bqc-BJ': 'bqc',
        'bqc-Latn': 'bqc',
        'bqd': 'bqd',
        'bqd-Latn-CM': 'bqd',
        'bqd-CM': 'bqd',
        'bqd-Latn': 'bqd',
        'bqf': 'bqf',
        'bqf-Latn-GN': 'bqf',
        'bqf-GN': 'bqf',
        'bqf-Latn': 'bqf',
        'bqf-Arab': 'bqf-Arab',
        'bqf-Arab-GN': 'bqf-Arab',
        'bqg': 'bqg',
        'bqg-Latn-TG': 'bqg',
        'bqg-Latn': 'bqg',
        'bqg-TG': 'bqg',
        'bqh': 'bqh',
        'bqh-Zyyy-CN': 'bqh',
        'bqh-CN': 'bqh',
        'bqh-Zyyy': 'bqh',
        'bqi': 'bqi',
        'bqi-Arab-IR': 'bqi',
        'bqi-Arab': 'bqi',
        'bqi-IR': 'bqi',
        'bqj': 'bqj',
        'bqj-Latn-SN': 'bqj',
        'bqj-Latn': 'bqj',
        'bqj-SN': 'bqj',
        'bqk': 'bqk',
        'bqk-Latn-CF': 'bqk',
        'bqk-CF': 'bqk',
        'bqk-Latn': 'bqk',
        'bql': 'bql',
        'bql-Latn-PG': 'bql',
        'bql-Latn': 'bql',
        'bql-PG': 'bql',
        'bqm': 'bqm',
        'bqm-Latn-CM': 'bqm',
        'bqm-CM': 'bqm',
        'bqm-Latn': 'bqm',
        'bqn': 'bqn',
        'bqn-Zxxx-BG': 'bqn',
        'bqn-BG': 'bqn',
        'bqn-Zxxx': 'bqn',
        'sgn-bqn': 'bqn',
        'sgn-bqn-BG': 'bqn',
        'bqo': 'bqo',
        'bqo-Latn-CM': 'bqo',
        'bqo-CM': 'bqo',
        'bqo-Latn': 'bqo',
        'bqp': 'bqp',
        'bqp-Latn-NG': 'bqp',
        'bqp-Latn': 'bqp',
        'bqp-NG': 'bqp',
        'bqq': 'bqq',
        'bqq-Latn-ID': 'bqq',
        'bqq-ID': 'bqq',
        'bqq-Latn': 'bqq',
        'bqr': 'bqr',
        'bqr-Latn-ID': 'bqr',
        'bqr-ID': 'bqr',
        'bqr-Latn': 'bqr',
        'bqs': 'bqs',
        'bqs-Latn-PG': 'bqs',
        'bqs-Latn': 'bqs',
        'bqs-PG': 'bqs',
        'bqt': 'bqt',
        'bqt-Latn-CM': 'bqt',
        'bqt-CM': 'bqt',
        'bqt-Latn': 'bqt',
        'bqu': 'bqu',
        'bqu-Latn-CD': 'bqu',
        'bqu-CD': 'bqu',
        'bqu-Latn': 'bqu',
        'bqv': 'bqv',
        'bqv-Latn-CI': 'bqv',
        'bqv-CI': 'bqv',
        'bqv-Latn': 'bqv',
        'bqw': 'bqw',
        'bqw-Latn-NG': 'bqw',
        'bqw-Latn': 'bqw',
        'bqw-NG': 'bqw',
        'bqx': 'bqx',
        'bqx-Latn-NG': 'bqx',
        'bqx-Latn': 'bqx',
        'bqx-NG': 'bqx',
        'bqy': 'bqy',
        'bqy-Zxxx-ID': 'bqy',
        'bqy-ID': 'bqy',
        'bqy-Zxxx': 'bqy',
        'sgn-bqy': 'bqy',
        'sgn-bqy-ID': 'bqy',
        'bqz': 'bqz',
        'bqz-Latn-CM': 'bqz',
        'bqz-CM': 'bqz',
        'bqz-Latn': 'bqz',
        'br': 'br',
        'br-Latn-FR': 'br',
        'br-FR': 'br',
        'br-Latn': 'br',
        'bra': 'bra',
        'bra-Deva-IN': 'bra',
        'bra-Deva': 'bra',
        'bra-IN': 'bra',
        'brb': 'brb',
        'brb-Khmr-KH': 'brb',
        'brb-KH': 'brb',
        'brb-Khmr': 'brb',
        'brb-Laoo': 'brb-Laoo',
        'brb-Laoo-LA': 'brb-Laoo',
        'brb-LA': 'brb-Laoo',
        'brb-Latn': 'brb-Latn',
        'brb-Latn-VN': 'brb-Latn',
        'brb-VN': 'brb-Latn',
        'brc': 'brc',
        'brc-Latn-GY': 'brc',
        'brc-GY': 'brc',
        'brc-Latn': 'brc',
        'brd': 'brd',
        'brd-Deva-NP': 'brd',
        'brd-Deva': 'brd',
        'brd-NP': 'brd',
        'brf': 'brf',
        'brf-Latn-CD': 'brf',
        'brf-CD': 'brf',
        'brf-Latn': 'brf',
        'brg': 'brg',
        'brg-Latn-BO': 'brg',
        'brg-BO': 'brg',
        'brg-Latn': 'brg',
        'brh': 'brh',
        'brh-Arab-PK': 'brh',
        'brh-Arab': 'brh',
        'brh-PK': 'brh',
        'brh-Latn': 'brh-Latn',
        'brh-Latn-PK': 'brh-Latn',
        'bri': 'bri',
        'bri-Latn-CM': 'bri',
        'bri-CM': 'bri',
        'bri-Latn': 'bri',
        'brj': 'brj',
        'brj-Latn-VU': 'brj',
        'brj-Latn': 'brj',
        'brj-VU': 'brj',
        'brk': 'brk',
        'brk-Arab-SD': 'brk',
        'brk-Arab': 'brk',
        'brk-SD': 'brk',
        'brl': 'brl',
        'brl-Latn-BW': 'brl',
        'brl-BW': 'brl',
        'brl-Latn': 'brl',
        'brm': 'brm',
        'brm-Latn-CD': 'brm',
        'brm-CD': 'brm',
        'brm-Latn': 'brm',
        'brn': 'brn',
        'brn-Latn-CR': 'brn',
        'brn-CR': 'brn',
        'brn-Latn': 'brn',
        'bro': 'bro',
        'bro-Zyyy-BT': 'bro',
        'bro-BT': 'bro',
        'bro-Zyyy': 'bro',
        'brp': 'brp',
        'brp-Latn-ID': 'brp',
        'brp-ID': 'brp',
        'brp-Latn': 'brp',
        'brq': 'brq',
        'brq-Latn-PG': 'brq',
        'brq-Latn': 'brq',
        'brq-PG': 'brq',
        'brr': 'brr',
        'brr-Latn-SB': 'brr',
        'brr-Latn': 'brr',
        'brr-SB': 'brr',
        'brs': 'brs',
        'brs-Latn-ID': 'brs',
        'brs-ID': 'brs',
        'brs-Latn': 'brs',
        'brt': 'brt',
        'brt-Latn-NG': 'brt',
        'brt-Latn': 'brt',
        'brt-NG': 'brt',
        'bru': 'bru',
        'bru-Latn-VN': 'bru',
        'bru-Latn': 'bru',
        'bru-VN': 'bru',
        'bru-Laoo': 'bru-Laoo',
        'bru-Laoo-LA': 'bru-Laoo',
        'bru-Thai': 'bru-Thai',
        'bru-Thai-LA': 'bru-Thai',
        'brv': 'brv',
        'brv-Laoo-LA': 'brv',
        'brv-LA': 'brv',
        'brv-Laoo': 'brv',
        'brv-Thai-x-donglng': 'brv-Thai-x-donglng',
        'brv-Thai-TH-x-donglng': 'brv-Thai-x-donglng',
        'brv-TH-x-donglng': 'brv-Thai-x-donglng',
        'brv-Thai-x-khongchm': 'brv-Thai-x-khongchm',
        'brv-Thai-TH-x-khongchm': 'brv-Thai-x-khongchm',
        'brv-TH-x-khongchm': 'brv-Thai-x-khongchm',
        'brv-Thai-x-sakonnkn': 'brv-Thai-x-sakonnkn',
        'brv-Thai-TH-x-sakonnkn': 'brv-Thai-x-sakonnkn',
        'brv-TH-x-sakonnkn': 'brv-Thai-x-sakonnkn',
        'brw': 'brw',
        'brw-Zyyy-IN': 'brw',
        'brw-IN': 'brw',
        'brw-Zyyy': 'brw',
        'brx': 'brx',
        'brx-Deva-IN': 'brx',
        'brx-Deva': 'brx',
        'brx-IN': 'brx',
        'brx-Beng': 'brx-Beng',
        'brx-Beng-IN': 'brx-Beng',
        'brx-Latn': 'brx-Latn',
        'brx-Latn-IN': 'brx-Latn',
        'bry': 'bry',
        'bry-Latn-PG': 'bry',
        'bry-Latn': 'bry',
        'bry-PG': 'bry',
        'brz': 'brz',
        'brz-Latn-PG': 'brz',
        'brz-Latn': 'brz',
        'brz-PG': 'brz',
        'bs': 'bs',
        'bs-Latn-BA': 'bs',
        'bs-BA': 'bs',
        'bs-Latn': 'bs',
        'bs-Cyrl': 'bs-Cyrl',
        'bs-Cyrl-BA': 'bs-Cyrl',
        'bsa': 'bsa',
        'bsa-Latn-ID': 'bsa',
        'bsa-ID': 'bsa',
        'bsa-Latn': 'bsa',
        'bsb': 'bsb',
        'bsb-Latn-BN': 'bsb',
        'bsb-BN': 'bsb',
        'bsb-Latn': 'bsb',
        'bsc': 'bsc',
        'bsc-Latn-SN': 'bsc',
        'bsc-Latn': 'bsc',
        'bsc-SN': 'bsc',
        'bse': 'bse',
        'bse-Latn-CM': 'bse',
        'bse-CM': 'bse',
        'bse-Latn': 'bse',
        'bsf': 'bsf',
        'bsf-Latn-NG': 'bsf',
        'bsf-Latn': 'bsf',
        'bsf-NG': 'bsf',
        'bsg': 'bsg',
        'bsg-Zyyy-IR': 'bsg',
        'bsg-IR': 'bsg',
        'bsg-Zyyy': 'bsg',
        'bsh': 'bsh',
        'bsh-Arab-AF': 'bsh',
        'bsh-AF': 'bsh',
        'bsh-Arab': 'bsh',
        'bsi': 'bsi',
        'bsi-Latn-CM': 'bsi',
        'bsi-CM': 'bsi',
        'bsi-Latn': 'bsi',
        'bsj': 'bsj',
        'bsj-Latn-NG': 'bsj',
        'bsj-Latn': 'bsj',
        'bsj-NG': 'bsj',
        'bsk': 'bsk',
        'bsk-Arab-PK': 'bsk',
        'bsk-Arab': 'bsk',
        'bsk-PK': 'bsk',
        'bsk-Latn': 'bsk-Latn',
        'bsk-Latn-PK': 'bsk-Latn',
        'bsl': 'bsl',
        'bsl-Latn-NG': 'bsl',
        'bsl-Latn': 'bsl',
        'bsl-NG': 'bsl',
        'bsm': 'bsm',
        'bsm-Latn-ID': 'bsm',
        'bsm-ID': 'bsm',
        'bsm-Latn': 'bsm',
        'bsn': 'bsn',
        'bsn-Latn-CO': 'bsn',
        'bsn-CO': 'bsn',
        'bsn-Latn': 'bsn',
        'bso': 'bso',
        'bso-Latn-TD': 'bso',
        'bso-Latn': 'bso',
        'bso-TD': 'bso',
        'bsp': 'bsp',
        'bsp-Latn-GN': 'bsp',
        'bsp-GN': 'bsp',
        'bsp-Latn': 'bsp',
        'bsq': 'bsq',
        'bsq-Bass-LR': 'bsq',
        'bsq-Bass': 'bsq',
        'bsq-LR': 'bsq',
        'bsq-Latn': 'bsq-Latn',
        'bsq-Latn-LR': 'bsq-Latn',
        'bsr': 'bsr',
        'bsr-Latn-NG': 'bsr',
        'bsr-Latn': 'bsr',
        'bsr-NG': 'bsr',
        'bss': 'bss',
        'bss-Latn-CM': 'bss',
        'bss-CM': 'bss',
        'bss-Latn': 'bss',
        'bst': 'bst',
        'bst-Ethi-ET': 'bst',
        'bst-ET': 'bst',
        'bst-Ethi': 'bst',
        'bst-Latn': 'bst-Latn',
        'bst-Latn-ET': 'bst-Latn',
        'bsu': 'bsu',
        'bsu-Latn-ID': 'bsu',
        'bsu-ID': 'bsu',
        'bsu-Latn': 'bsu',
        'bsv': 'bsv',
        'bsv-Latn-GN': 'bsv',
        'bsv-GN': 'bsv',
        'bsv-Latn': 'bsv',
        'bsv-Arab': 'bsv-Arab',
        'bsv-Arab-GN': 'bsv-Arab',
        'bsw': 'bsw',
        'bsw-Zyyy-ET': 'bsw',
        'bsw-ET': 'bsw',
        'bsw-Zyyy': 'bsw',
        'bsx': 'bsx',
        'bsx-Latn-NG': 'bsx',
        'bsx-Latn': 'bsx',
        'bsx-NG': 'bsx',
        'bsy': 'bsy',
        'bsy-Latn-MY': 'bsy',
        'bsy-Latn': 'bsy',
        'bsy-MY': 'bsy',
        'bta': 'bta',
        'bta-Latn-NG': 'bta',
        'bta-Latn': 'bta',
        'bta-NG': 'bta',
        'btb': 'btb',
        'btb-Latn-CM': 'btb',
        'btb-CM': 'btb',
        'btb-Latn': 'btb',
        'btc': 'btc',
        'btc-Latn-CM': 'btc',
        'btc-CM': 'btc',
        'btc-Latn': 'btc',
        'btd': 'btd',
        'btd-Batk-ID': 'btd',
        'btd-Batk': 'btd',
        'btd-ID': 'btd',
        'bte': 'bte',
        'bte-Latn-NG': 'bte',
        'bte-Latn': 'bte',
        'bte-NG': 'bte',
        'btf': 'btf',
        'btf-Latn-TD': 'btf',
        'btf-Latn': 'btf',
        'btf-TD': 'btf',
        'btg': 'btg',
        'btg-Latn-CI': 'btg',
        'btg-CI': 'btg',
        'btg-Latn': 'btg',
        'bth': 'bth',
        'bth-Latn-MY': 'bth',
        'bth-Latn': 'bth',
        'bth-MY': 'bth',
        'bti': 'bti',
        'bti-Latn-ID': 'bti',
        'bti-ID': 'bti',
        'bti-Latn': 'bti',
        'btj': 'btj',
        'btj-Latn-ID': 'btj',
        'btj-ID': 'btj',
        'btj-Latn': 'btj',
        'ms-btj': 'btj',
        'ms-btj-ID': 'btj',
        'btm': 'btm',
        'btm-Batk-ID': 'btm',
        'btm-Batk': 'btm',
        'btm-ID': 'btm',
        'btn': 'btn',
        'btn-Latn-PH': 'btn',
        'btn-Latn': 'btn',
        'btn-PH': 'btn',
        'bto': 'bto',
        'bto-Latn-PH': 'bto',
        'bto-Latn': 'bto',
        'bto-PH': 'bto',
        'btp': 'btp',
        'btp-Latn-PG': 'btp',
        'btp-Latn': 'btp',
        'btp-PG': 'btp',
        'btq': 'btq',
        'btq-Latn-MY': 'btq',
        'btq-Latn': 'btq',
        'btq-MY': 'btq',
        'btr': 'btr',
        'btr-Latn-VU': 'btr',
        'btr-Latn': 'btr',
        'btr-VU': 'btr',
        'bts': 'bts',
        'bts-Latn-ID': 'bts',
        'bts-ID': 'bts',
        'bts-Latn': 'bts',
        'bts-Batk': 'bts-Batk',
        'bts-Batk-ID': 'bts-Batk',
        'btt': 'btt',
        'btt-Latn-NG': 'btt',
        'btt-Latn': 'btt',
        'btt-NG': 'btt',
        'btu': 'btu',
        'btu-Latn-NG': 'btu',
        'btu-Latn': 'btu',
        'btu-NG': 'btu',
        'btv': 'btv',
        'btv-Deva-PK': 'btv',
        'btv-Deva': 'btv',
        'btv-PK': 'btv',
        'btw': 'btw',
        'btw-Latn-PH': 'btw',
        'btw-Latn': 'btw',
        'btw-PH': 'btw',
        'btx': 'btx',
        'btx-Latn-ID': 'btx',
        'btx-ID': 'btx',
        'btx-Latn': 'btx',
        'btx-Batk': 'btx-Batk',
        'btx-Batk-ID': 'btx-Batk',
        'bty': 'bty',
        'bty-Latn-ID': 'bty',
        'bty-ID': 'bty',
        'bty-Latn': 'bty',
        'btz': 'btz',
        'btz-Latn-ID': 'btz',
        'btz-ID': 'btz',
        'btz-Latn': 'btz',
        'bua': 'bua',
        'bua-Cyrl-RU': 'bua',
        'bua-Cyrl': 'bua',
        'bua-RU': 'bua',
        'bxr': 'bua',
        'bxr-Cyrl': 'bua',
        'bxr-Cyrl-RU': 'bua',
        'bxr-RU': 'bua',
        'bub': 'bub',
        'bub-Latn-TD': 'bub',
        'bub-Latn': 'bub',
        'bub-TD': 'bub',
        'buc': 'buc',
        'buc-Latn-YT': 'buc',
        'buc-Latn': 'buc',
        'buc-YT': 'buc',
        'bud': 'bud',
        'bud-Latn-TG': 'bud',
        'bud-Latn': 'bud',
        'bud-TG': 'bud',
        'bud-Brai': 'bud-Brai',
        'bud-Brai-TG': 'bud-Brai',
        'bue': 'bue',
        'bue-Latn-CA': 'bue',
        'bue-CA': 'bue',
        'bue-Latn': 'bue',
        'buf': 'buf',
        'buf-Latn-CD': 'buf',
        'buf-CD': 'buf',
        'buf-Latn': 'buf',
        'bug': 'bug',
        'bug-Latn-ID': 'bug',
        'bug-ID': 'bug',
        'bug-Latn': 'bug',
        'bug-Bugi': 'bug-Bugi',
        'bug-Bugi-ID': 'bug-Bugi',
        'buh': 'buh',
        'buh-Latn-CN': 'buh',
        'buh-CN': 'buh',
        'buh-Latn': 'buh',
        'bui': 'bui',
        'bui-Latn-CG': 'bui',
        'bui-CG': 'bui',
        'bui-Latn': 'bui',
        'buj': 'buj',
        'buj-Latn-NG': 'buj',
        'buj-Latn': 'buj',
        'buj-NG': 'buj',
        'buk': 'buk',
        'buk-Latn-PG': 'buk',
        'buk-Latn': 'buk',
        'buk-PG': 'buk',
        'bum': 'bum',
        'bum-Latn-CM': 'bum',
        'bum-CM': 'bum',
        'bum-Latn': 'bum',
        'bun': 'bun',
        'bun-Latn-SL': 'bun',
        'bun-Latn': 'bun',
        'bun-SL': 'bun',
        'buo': 'buo',
        'buo-Latn-PG': 'buo',
        'buo-Latn': 'buo',
        'buo-PG': 'buo',
        'bup': 'bup',
        'bup-Latn-ID': 'bup',
        'bup-ID': 'bup',
        'bup-Latn': 'bup',
        'buq': 'buq',
        'buq-Latn-PG': 'buq',
        'buq-Latn': 'buq',
        'buq-PG': 'buq',
        'bus': 'bus',
        'bus-Latn-NG': 'bus',
        'bus-Latn': 'bus',
        'bus-NG': 'bus',
        'but': 'but',
        'but-Latn-PG': 'but',
        'but-Latn': 'but',
        'but-PG': 'but',
        'buu': 'buu',
        'buu-Latn-CD': 'buu',
        'buu-CD': 'buu',
        'buu-Latn': 'buu',
        'buv': 'buv',
        'buv-Latn-PG': 'buv',
        'buv-Latn': 'buv',
        'buv-PG': 'buv',
        'buw': 'buw',
        'buw-Latn-GA': 'buw',
        'buw-GA': 'buw',
        'buw-Latn': 'buw',
        'bux': 'bux',
        'bux-Latn-NG': 'bux',
        'bux-Latn': 'bux',
        'bux-NG': 'bux',
        'buy': 'buy',
        'buy-Latn-SL': 'buy',
        'buy-Latn': 'buy',
        'buy-SL': 'buy',
        'buz': 'buz',
        'buz-Latn-NG': 'buz',
        'buz-Latn': 'buz',
        'buz-NG': 'buz',
        'bva': 'bva',
        'bva-Latn-TD': 'bva',
        'bva-Latn': 'bva',
        'bva-TD': 'bva',
        'bvb': 'bvb',
        'bvb-Latn-GQ': 'bvb',
        'bvb-GQ': 'bvb',
        'bvb-Latn': 'bvb',
        'bvc': 'bvc',
        'bvc-Latn-SB': 'bvc',
        'bvc-Latn': 'bvc',
        'bvc-SB': 'bvc',
        'bvd': 'bvd',
        'bvd-Latn-SB': 'bvd',
        'bvd-Latn': 'bvd',
        'bvd-SB': 'bvd',
        'bve': 'bve',
        'bve-Latn-ID': 'bve',
        'bve-ID': 'bve',
        'bve-Latn': 'bve',
        'ms-bve': 'bve',
        'ms-bve-ID': 'bve',
        'bvf': 'bvf',
        'bvf-Latn-TD': 'bvf',
        'bvf-Latn': 'bvf',
        'bvf-TD': 'bvf',
        'bvg': 'bvg',
        'bvg-Latn-CM': 'bvg',
        'bvg-CM': 'bvg',
        'bvg-Latn': 'bvg',
        'bvh': 'bvh',
        'bvh-Latn-NG': 'bvh',
        'bvh-Latn': 'bvh',
        'bvh-NG': 'bvh',
        'bvi': 'bvi',
        'bvi-Latn-SS': 'bvi',
        'bvi-Latn': 'bvi',
        'bvi-SS': 'bvi',
        'bvj': 'bvj',
        'bvj-Latn-NG': 'bvj',
        'bvj-Latn': 'bvj',
        'bvj-NG': 'bvj',
        'bvk': 'bvk',
        'bvk-Latn-ID': 'bvk',
        'bvk-ID': 'bvk',
        'bvk-Latn': 'bvk',
        'bvl': 'bvl',
        'bvl-Zxxx-BO': 'bvl',
        'bvl-BO': 'bvl',
        'bvl-Zxxx': 'bvl',
        'sgn-bvl': 'bvl',
        'sgn-bvl-BO': 'bvl',
        'bvm': 'bvm',
        'bvm-Latn-CM': 'bvm',
        'bvm-CM': 'bvm',
        'bvm-Latn': 'bvm',
        'bvn': 'bvn',
        'bvn-Latn-PG': 'bvn',
        'bvn-Latn': 'bvn',
        'bvn-PG': 'bvn',
        'bvo': 'bvo',
        'bvo-Latn-TD': 'bvo',
        'bvo-Latn': 'bvo',
        'bvo-TD': 'bvo',
        'bvp': 'bvp',
        'bvp-Zyyy-CN': 'bvp',
        'bvp-CN': 'bvp',
        'bvp-Zyyy': 'bvp',
        'bvq': 'bvq',
        'bvq-Latn-CF': 'bvq',
        'bvq-CF': 'bvq',
        'bvq-Latn': 'bvq',
        'bvr': 'bvr',
        'bvr-Latn-AU': 'bvr',
        'bvr-AU': 'bvr',
        'bvr-Latn': 'bvr',
        'bvt': 'bvt',
        'bvt-Latn-ID': 'bvt',
        'bvt-ID': 'bvt',
        'bvt-Latn': 'bvt',
        'bvu': 'bvu',
        'bvu-Latn-ID': 'bvu',
        'bvu-ID': 'bvu',
        'bvu-Latn': 'bvu',
        'ms-bvu': 'bvu',
        'ms-bvu-ID': 'bvu',
        'bvv': 'bvv',
        'bvv-Latn-VE': 'bvv',
        'bvv-Latn': 'bvv',
        'bvv-VE': 'bvv',
        'bvw': 'bvw',
        'bvw-Latn-NG': 'bvw',
        'bvw-Latn': 'bvw',
        'bvw-NG': 'bvw',
        'bvx': 'bvx',
        'bvx-Latn-CG': 'bvx',
        'bvx-CG': 'bvx',
        'bvx-Latn': 'bvx',
        'bvy': 'bvy',
        'bvy-Latn-PH': 'bvy',
        'bvy-Latn': 'bvy',
        'bvy-PH': 'bvy',
        'bvz': 'bvz',
        'bvz-Latn-ID': 'bvz',
        'bvz-ID': 'bvz',
        'bvz-Latn': 'bvz',
        'bwa': 'bwa',
        'bwa-Latn-NC': 'bwa',
        'bwa-Latn': 'bwa',
        'bwa-NC': 'bwa',
        'bwb': 'bwb',
        'bwb-Latn-FJ': 'bwb',
        'bwb-FJ': 'bwb',
        'bwb-Latn': 'bwb',
        'bwc': 'bwc',
        'bwc-Latn-ZM': 'bwc',
        'bwc-Latn': 'bwc',
        'bwc-ZM': 'bwc',
        'bwd': 'bwd',
        'bwd-Latn-PG': 'bwd',
        'bwd-Latn': 'bwd',
        'bwd-PG': 'bwd',
        'bwe': 'bwe',
        'bwe-Mymr-MM': 'bwe',
        'bwe-MM': 'bwe',
        'bwe-Mymr': 'bwe',
        'bwe-Latn': 'bwe-Latn',
        'bwe-Latn-MM': 'bwe-Latn',
        'bwf': 'bwf',
        'bwf-Latn-PG': 'bwf',
        'bwf-Latn': 'bwf',
        'bwf-PG': 'bwf',
        'bwg': 'bwg',
        'bwg-Latn-MZ': 'bwg',
        'bwg-Latn': 'bwg',
        'bwg-MZ': 'bwg',
        'bwh': 'bwh',
        'bwh-Latn-CM': 'bwh',
        'bwh-CM': 'bwh',
        'bwh-Latn': 'bwh',
        'bwi': 'bwi',
        'bwi-Latn-VE': 'bwi',
        'bwi-Latn': 'bwi',
        'bwi-VE': 'bwi',
        'bwj': 'bwj',
        'bwj-Latn-BF': 'bwj',
        'bwj-BF': 'bwj',
        'bwj-Latn': 'bwj',
        'bwk': 'bwk',
        'bwk-Latn-PG': 'bwk',
        'bwk-Latn': 'bwk',
        'bwk-PG': 'bwk',
        'bwl': 'bwl',
        'bwl-Latn-CD': 'bwl',
        'bwl-CD': 'bwl',
        'bwl-Latn': 'bwl',
        'bwm': 'bwm',
        'bwm-Latn-PG': 'bwm',
        'bwm-Latn': 'bwm',
        'bwm-PG': 'bwm',
        'bwn': 'bwn',
        'bwn-Zyyy-CN': 'bwn',
        'bwn-CN': 'bwn',
        'bwn-Zyyy': 'bwn',
        'bwo': 'bwo',
        'bwo-Latn-ET': 'bwo',
        'bwo-ET': 'bwo',
        'bwo-Latn': 'bwo',
        'bwo-Ethi': 'bwo-Ethi',
        'bwo-Ethi-ET': 'bwo-Ethi',
        'bwp': 'bwp',
        'bwp-Latn-ID': 'bwp',
        'bwp-ID': 'bwp',
        'bwp-Latn': 'bwp',
        'bwq': 'bwq',
        'bwq-Latn-BF': 'bwq',
        'bwq-BF': 'bwq',
        'bwq-Latn': 'bwq',
        'bwr': 'bwr',
        'bwr-Latn-NG': 'bwr',
        'bwr-Latn': 'bwr',
        'bwr-NG': 'bwr',
        'bws': 'bws',
        'bws-Latn-CD': 'bws',
        'bws-CD': 'bws',
        'bws-Latn': 'bws',
        'bwt': 'bwt',
        'bwt-Latn-CM': 'bwt',
        'bwt-CM': 'bwt',
        'bwt-Latn': 'bwt',
        'bwu': 'bwu',
        'bwu-Latn-GH': 'bwu',
        'bwu-GH': 'bwu',
        'bwu-Latn': 'bwu',
        'bww': 'bww',
        'bww-Latn-CD': 'bww',
        'bww-CD': 'bww',
        'bww-Latn': 'bww',
        'bwx': 'bwx',
        'bwx-Latn-CN': 'bwx',
        'bwx-CN': 'bwx',
        'bwx-Latn': 'bwx',
        'bwy': 'bwy',
        'bwy-Latn-BF': 'bwy',
        'bwy-BF': 'bwy',
        'bwy-Latn': 'bwy',
        'bwz': 'bwz',
        'bwz-Latn-CG': 'bwz',
        'bwz-CG': 'bwz',
        'bwz-Latn': 'bwz',
        'bxa': 'bxa',
        'bxa-Latn-SB': 'bxa',
        'bxa-Latn': 'bxa',
        'bxa-SB': 'bxa',
        'bxb': 'bxb',
        'bxb-Latn-SS': 'bxb',
        'bxb-Latn': 'bxb',
        'bxb-SS': 'bxb',
        'bxc': 'bxc',
        'bxc-Latn-GQ': 'bxc',
        'bxc-GQ': 'bxc',
        'bxc-Latn': 'bxc',
        'bxd': 'bxd',
        'bxd-Zyyy-CN': 'bxd',
        'bxd-CN': 'bxd',
        'bxd-Zyyy': 'bxd',
        'bxe': 'bxe',
        'bxe-Zyyy-ET': 'bxe',
        'bxe-ET': 'bxe',
        'bxe-Zyyy': 'bxe',
        'bxf': 'bxf',
        'bxf-Latn-PG': 'bxf',
        'bxf-Latn': 'bxf',
        'bxf-PG': 'bxf',
        'bxg': 'bxg',
        'bxg-Latn-CD': 'bxg',
        'bxg-CD': 'bxg',
        'bxg-Latn': 'bxg',
        'bxh': 'bxh',
        'bxh-Latn-PG': 'bxh',
        'bxh-Latn': 'bxh',
        'bxh-PG': 'bxh',
        'bxi': 'bxi',
        'bxi-Latn-AU': 'bxi',
        'bxi-AU': 'bxi',
        'bxi-Latn': 'bxi',
        'bxj': 'bxj',
        'bxj-Latn-AU': 'bxj',
        'bxj-AU': 'bxj',
        'bxj-Latn': 'bxj',
        'bxl': 'bxl',
        'bxl-Latn-BF': 'bxl',
        'bxl-BF': 'bxl',
        'bxl-Latn': 'bxl',
        'bxm': 'bxm',
        'bxm-Cyrl-MN': 'bxm',
        'bxm-Cyrl': 'bxm',
        'bxm-MN': 'bxm',
        'bxm-Latn': 'bxm-Latn',
        'bxm-Latn-MN': 'bxm-Latn',
        'bxm-Mong': 'bxm-Mong',
        'bxm-Mong-MN': 'bxm-Mong',
        'bxn': 'bxn',
        'bxn-Latn-AU': 'bxn',
        'bxn-AU': 'bxn',
        'bxn-Latn': 'bxn',
        'bxo': 'bxo',
        'bxo-Latn-NG': 'bxo',
        'bxo-Latn': 'bxo',
        'bxo-NG': 'bxo',
        'bxp': 'bxp',
        'bxp-Latn-CM': 'bxp',
        'bxp-CM': 'bxp',
        'bxp-Latn': 'bxp',
        'bxq': 'bxq',
        'bxq-Latn-NG': 'bxq',
        'bxq-Latn': 'bxq',
        'bxq-NG': 'bxq',
        'bxs': 'bxs',
        'bxs-Latn-CM': 'bxs',
        'bxs-CM': 'bxs',
        'bxs-Latn': 'bxs',
        'bxu': 'bxu',
        'bxu-Zyyy-CN': 'bxu',
        'bxu-CN': 'bxu',
        'bxu-Zyyy': 'bxu',
        'bxv': 'bxv',
        'bxv-Latn-TD': 'bxv',
        'bxv-Latn': 'bxv',
        'bxv-TD': 'bxv',
        'bxw': 'bxw',
        'bxw-Latn-ML': 'bxw',
        'bxw-Latn': 'bxw',
        'bxw-ML': 'bxw',
        'bxz': 'bxz',
        'bxz-Latn-PG': 'bxz',
        'bxz-Latn': 'bxz',
        'bxz-PG': 'bxz',
        'bya': 'bya',
        'bya-Latn-PH': 'bya',
        'bya-Latn': 'bya',
        'bya-PH': 'bya',
        'byb': 'byb',
        'byb-Latn-CM': 'byb',
        'byb-CM': 'byb',
        'byb-Latn': 'byb',
        'byc': 'byc',
        'byc-Latn-NG': 'byc',
        'byc-Latn': 'byc',
        'byc-NG': 'byc',
        'byd': 'byd',
        'byd-Latn-ID': 'byd',
        'byd-ID': 'byd',
        'byd-Latn': 'byd',
        'bye': 'bye',
        'bye-Latn-PG': 'bye',
        'bye-Latn': 'bye',
        'bye-PG': 'bye',
        'byf': 'byf',
        'byf-Latn-NG': 'byf',
        'byf-Latn': 'byf',
        'byf-NG': 'byf',
        'byg': 'byg',
        'byg-Zyyy-SD': 'byg',
        'byg-SD': 'byg',
        'byg-Zyyy': 'byg',
        'byh': 'byh',
        'byh-Deva-NP': 'byh',
        'byh-Deva': 'byh',
        'byh-NP': 'byh',
        'byi': 'byi',
        'byi-Latn-CD': 'byi',
        'byi-CD': 'byi',
        'byi-Latn': 'byi',
        'byj': 'byj',
        'byj-Latn-NG': 'byj',
        'byj-Latn': 'byj',
        'byj-NG': 'byj',
        'byk': 'byk',
        'byk-Zyyy-CN': 'byk',
        'byk-CN': 'byk',
        'byk-Zyyy': 'byk',
        'byl': 'byl',
        'byl-Latn-ID': 'byl',
        'byl-ID': 'byl',
        'byl-Latn': 'byl',
        'bym': 'bym',
        'bym-Latn-AU': 'bym',
        'bym-AU': 'bym',
        'bym-Latn': 'bym',
        'byn': 'byn',
        'byn-Ethi-ER': 'byn',
        'byn-ER': 'byn',
        'byn-Ethi': 'byn',
        'byn-Latn': 'byn-Latn',
        'byn-Latn-ER': 'byn-Latn',
        'byo': 'byo',
        'byo-Zyyy-CN': 'byo',
        'byo-CN': 'byo',
        'byo-Zyyy': 'byo',
        'byp': 'byp',
        'byp-Latn-NG': 'byp',
        'byp-Latn': 'byp',
        'byp-NG': 'byp',
        'byq': 'byq',
        'byq-Zyyy-TW': 'byq',
        'byq-TW': 'byq',
        'byq-Zyyy': 'byq',
        'byr': 'byr',
        'byr-Latn-PG': 'byr',
        'byr-Latn': 'byr',
        'byr-PG': 'byr',
        'bys': 'bys',
        'bys-Latn-NG': 'bys',
        'bys-Latn': 'bys',
        'bys-NG': 'bys',
        'byt': 'byt',
        'byt-Zyyy-SD': 'byt',
        'byt-SD': 'byt',
        'byt-Zyyy': 'byt',
        'byv': 'byv',
        'byv-Latn-CM': 'byv',
        'byv-CM': 'byv',
        'byv-Latn': 'byv',
        'byw': 'byw',
        'byw-Deva-NP': 'byw',
        'byw-Deva': 'byw',
        'byw-NP': 'byw',
        'byx': 'byx',
        'byx-Latn-PG': 'byx',
        'byx-Latn': 'byx',
        'byx-PG': 'byx',
        'byz': 'byz',
        'byz-Latn-PG': 'byz',
        'byz-Latn': 'byz',
        'byz-PG': 'byz',
        'bza': 'bza',
        'bza-Latn-LR': 'bza',
        'bza-LR': 'bza',
        'bza-Latn': 'bza',
        'bzb': 'bzb',
        'bzb-Latn-ID': 'bzb',
        'bzb-ID': 'bzb',
        'bzb-Latn': 'bzb',
        'bzc': 'bzc',
        'bzc-Latn-MG': 'bzc',
        'bzc-Latn': 'bzc',
        'bzc-MG': 'bzc',
        'bzd': 'bzd',
        'bzd-Latn-CR': 'bzd',
        'bzd-CR': 'bzd',
        'bzd-Latn': 'bzd',
        'bze': 'bze',
        'bze-Latn-ML': 'bze',
        'bze-Latn': 'bze',
        'bze-ML': 'bze',
        'bze-Arab': 'bze-Arab',
        'bze-Arab-ML': 'bze-Arab',
        'bzf': 'bzf',
        'bzf-Latn-PG': 'bzf',
        'bzf-Latn': 'bzf',
        'bzf-PG': 'bzf',
        'bzg': 'bzg',
        'bzg-Zyyy-TW': 'bzg',
        'bzg-TW': 'bzg',
        'bzg-Zyyy': 'bzg',
        'bzh': 'bzh',
        'bzh-Latn-PG': 'bzh',
        'bzh-Latn': 'bzh',
        'bzh-PG': 'bzh',
        'bzi': 'bzi',
        'bzi-Thai-TH': 'bzi',
        'bzi-TH': 'bzi',
        'bzi-Thai': 'bzi',
        'bzj': 'bzj',
        'bzj-Latn-BZ': 'bzj',
        'bzj-BZ': 'bzj',
        'bzj-Latn': 'bzj',
        'bzk': 'bzk',
        'bzk-Latn-NI': 'bzk',
        'bzk-Latn': 'bzk',
        'bzk-NI': 'bzk',
        'bzl': 'bzl',
        'bzl-Latn-ID': 'bzl',
        'bzl-ID': 'bzl',
        'bzl-Latn': 'bzl',
        'bzm': 'bzm',
        'bzm-Latn-CD': 'bzm',
        'bzm-CD': 'bzm',
        'bzm-Latn': 'bzm',
        'bzn': 'bzn',
        'bzn-Latn-ID': 'bzn',
        'bzn-ID': 'bzn',
        'bzn-Latn': 'bzn',
        'bzo': 'bzo',
        'bzo-Latn-CD': 'bzo',
        'bzo-CD': 'bzo',
        'bzo-Latn': 'bzo',
        'bzp': 'bzp',
        'bzp-Latn-ID': 'bzp',
        'bzp-ID': 'bzp',
        'bzp-Latn': 'bzp',
        'bzq': 'bzq',
        'bzq-Latn-ID': 'bzq',
        'bzq-ID': 'bzq',
        'bzq-Latn': 'bzq',
        'bzr': 'bzr',
        'bzr-Latn-AU': 'bzr',
        'bzr-AU': 'bzr',
        'bzr-Latn': 'bzr',
        'bzs': 'bzs',
        'bzs-Zxxx-BR': 'bzs',
        'bzs-BR': 'bzs',
        'bzs-Zxxx': 'bzs',
        'sgn-bzs': 'bzs',
        'sgn-bzs-BR': 'bzs',
        'bzt': 'bzt',
        'bzt-Zyyy-001': 'bzt',
        'bzt-001': 'bzt',
        'bzt-Zyyy': 'bzt',
        'bzu': 'bzu',
        'bzu-Latn-ID': 'bzu',
        'bzu-ID': 'bzu',
        'bzu-Latn': 'bzu',
        'bzv': 'bzv',
        'bzv-Latn-CM': 'bzv',
        'bzv-CM': 'bzv',
        'bzv-Latn': 'bzv',
        'bzw': 'bzw',
        'bzw-Latn-NG': 'bzw',
        'bzw-Latn': 'bzw',
        'bzw-NG': 'bzw',
        'bzx': 'bzx',
        'bzx-Latn-ML': 'bzx',
        'bzx-Latn': 'bzx',
        'bzx-ML': 'bzx',
        'bzy': 'bzy',
        'bzy-Latn-NG': 'bzy',
        'bzy-Latn': 'bzy',
        'bzy-NG': 'bzy',
        'bzz': 'bzz',
        'bzz-Latn-NG': 'bzz',
        'bzz-Latn': 'bzz',
        'bzz-NG': 'bzz',
        'ca': 'ca',
        'ca-Latn-ES': 'ca',
        'ca-ES': 'ca',
        'ca-Latn': 'ca',
        'ca-FR': 'ca-FR',
        'ca-Latn-FR': 'ca-FR',
        'ca-valencia': 'ca-valencia',
        'ca-Latn-ES-valencia': 'ca-valencia',
        'ca-ES-valencia': 'ca-valencia',
        'ca-Latn-valencia': 'ca-valencia',
        'caa': 'caa',
        'caa-Latn-GT': 'caa',
        'caa-GT': 'caa',
        'caa-Latn': 'caa',
        'cab': 'cab',
        'cab-Latn-HN': 'cab',
        'cab-HN': 'cab',
        'cab-Latn': 'cab',
        'cac': 'cac',
        'cac-Latn-GT': 'cac',
        'cac-GT': 'cac',
        'cac-Latn': 'cac',
        'cad': 'cad',
        'cad-Latn-US': 'cad',
        'cad-Latn': 'cad',
        'cad-US': 'cad',
        'cae': 'cae',
        'cae-Latn-SN': 'cae',
        'cae-Latn': 'cae',
        'cae-SN': 'cae',
        'caf': 'caf',
        'caf-Latn-CA': 'caf',
        'caf-CA': 'caf',
        'caf-Latn': 'caf',
        'caf-Cans': 'caf-Cans',
        'caf-Cans-CA': 'caf-Cans',
        'cag': 'cag',
        'cag-Latn-PY': 'cag',
        'cag-Latn': 'cag',
        'cag-PY': 'cag',
        'cah': 'cah',
        'cah-Latn-PE': 'cah',
        'cah-Latn': 'cah',
        'cah-PE': 'cah',
        'caj': 'caj',
        'caj-Latn-AR': 'caj',
        'caj-AR': 'caj',
        'caj-Latn': 'caj',
        'cak': 'cak',
        'cak-Latn-GT': 'cak',
        'cak-GT': 'cak',
        'cak-Latn': 'cak',
        'cal': 'cal',
        'cal-Latn-MP': 'cal',
        'cal-Latn': 'cal',
        'cal-MP': 'cal',
        'cam': 'cam',
        'cam-Latn-NC': 'cam',
        'cam-Latn': 'cam',
        'cam-NC': 'cam',
        'can': 'can',
        'can-Latn-PG': 'can',
        'can-Latn': 'can',
        'can-PG': 'can',
        'cao': 'cao',
        'cao-Latn-BO': 'cao',
        'cao-BO': 'cao',
        'cao-Latn': 'cao',
        'cap': 'cap',
        'cap-Latn-BO': 'cap',
        'cap-BO': 'cap',
        'cap-Latn': 'cap',
        'caq': 'caq',
        'caq-Latn-IN': 'caq',
        'caq-IN': 'caq',
        'caq-Latn': 'caq',
        'car': 'car',
        'car-Latn-VE': 'car',
        'car-Latn': 'car',
        'car-VE': 'car',
        'cas': 'cas',
        'cas-Latn-BO': 'cas',
        'cas-BO': 'cas',
        'cas-Latn': 'cas',
        'cav': 'cav',
        'cav-Latn-BO': 'cav',
        'cav-BO': 'cav',
        'cav-Latn': 'cav',
        'caw': 'caw',
        'caw-Latn-BO': 'caw',
        'caw-BO': 'caw',
        'caw-Latn': 'caw',
        'cax': 'cax',
        'cax-Latn-BO': 'cax',
        'cax-BO': 'cax',
        'cax-Latn': 'cax',
        'xba': 'cax',
        'xba-BO': 'cax',
        'xba-Latn': 'cax',
        'xba-Latn-BO': 'cax',
        'cay': 'cay',
        'cay-Latn-CA': 'cay',
        'cay-CA': 'cay',
        'cay-Latn': 'cay',
        'caz': 'caz',
        'caz-Latn-BO': 'caz',
        'caz-BO': 'caz',
        'caz-Latn': 'caz',
        'cbb': 'cbb',
        'cbb-Latn-CO': 'cbb',
        'cbb-CO': 'cbb',
        'cbb-Latn': 'cbb',
        'cbc': 'cbc',
        'cbc-Latn-CO': 'cbc',
        'cbc-CO': 'cbc',
        'cbc-Latn': 'cbc',
        'cbd': 'cbd',
        'cbd-Latn-CO': 'cbd',
        'cbd-CO': 'cbd',
        'cbd-Latn': 'cbd',
        'cbg': 'cbg',
        'cbg-Latn-CO': 'cbg',
        'cbg-CO': 'cbg',
        'cbg-Latn': 'cbg',
        'cbi': 'cbi',
        'cbi-Latn-EC': 'cbi',
        'cbi-EC': 'cbi',
        'cbi-Latn': 'cbi',
        'cbj': 'cbj',
        'cbj-Latn-BJ': 'cbj',
        'cbj-BJ': 'cbj',
        'cbj-Latn': 'cbj',
        'cbk': 'cbk',
        'cbk-Latn-PH': 'cbk',
        'cbk-Latn': 'cbk',
        'cbk-PH': 'cbk',
        'cbk-Brai': 'cbk-Brai',
        'cbk-Brai-PH': 'cbk-Brai',
        'cbl': 'cbl',
        'cbl-Latn-MM': 'cbl',
        'cbl-Latn': 'cbl',
        'cbl-MM': 'cbl',
        'cbn': 'cbn',
        'cbn-Thai-TH': 'cbn',
        'cbn-TH': 'cbn',
        'cbn-Thai': 'cbn',
        'cbo': 'cbo',
        'cbo-Latn-NG': 'cbo',
        'cbo-Latn': 'cbo',
        'cbo-NG': 'cbo',
        'cbq': 'cbq',
        'cbq-Latn-NG': 'cbq',
        'cbq-Latn': 'cbq',
        'cbq-NG': 'cbq',
        'cbr': 'cbr',
        'cbr-Latn-PE': 'cbr',
        'cbr-Latn': 'cbr',
        'cbr-PE': 'cbr',
        'cbs': 'cbs',
        'cbs-Latn-PE': 'cbs',
        'cbs-Latn': 'cbs',
        'cbs-PE': 'cbs',
        'cbt': 'cbt',
        'cbt-Latn-PE': 'cbt',
        'cbt-Latn': 'cbt',
        'cbt-PE': 'cbt',
        'cbu': 'cbu',
        'cbu-Latn-PE': 'cbu',
        'cbu-Latn': 'cbu',
        'cbu-PE': 'cbu',
        'cbv': 'cbv',
        'cbv-Latn-CO': 'cbv',
        'cbv-CO': 'cbv',
        'cbv-Latn': 'cbv',
        'cbw': 'cbw',
        'cbw-Latn-PH': 'cbw',
        'cbw-Latn': 'cbw',
        'cbw-PH': 'cbw',
        'cby': 'cby',
        'cby-Latn-CO': 'cby',
        'cby-CO': 'cby',
        'cby-Latn': 'cby',
        'cca': 'cca',
        'cca-Latn-CO': 'cca',
        'cca-CO': 'cca',
        'cca-Latn': 'cca',
        'ccc': 'ccc',
        'ccc-Latn-PE': 'ccc',
        'ccc-Latn': 'ccc',
        'ccc-PE': 'ccc',
        'ccd': 'ccd',
        'ccd-Latn-BR': 'ccd',
        'ccd-BR': 'ccd',
        'ccd-Latn': 'ccd',
        'cce': 'cce',
        'cce-Latn-MZ': 'cce',
        'cce-Latn': 'cce',
        'cce-MZ': 'cce',
        'ccg': 'ccg',
        'ccg-Latn-NG': 'ccg',
        'ccg-Latn': 'ccg',
        'ccg-NG': 'ccg',
        'cch': 'cch',
        'cch-Latn-NG': 'cch',
        'cch-Latn': 'cch',
        'cch-NG': 'cch',
        'ccj': 'ccj',
        'ccj-Latn-GW': 'ccj',
        'ccj-GW': 'ccj',
        'ccj-Latn': 'ccj',
        'ccl': 'ccl',
        'ccl-Latn-TZ': 'ccl',
        'ccl-Latn': 'ccl',
        'ccl-TZ': 'ccl',
        'ccm': 'ccm',
        'ccm-Latn-MY': 'ccm',
        'ccm-Latn': 'ccm',
        'ccm-MY': 'ccm',
        'cco': 'cco',
        'cco-Latn-MX': 'cco',
        'cco-Latn': 'cco',
        'cco-MX': 'cco',
        'ccp': 'ccp',
        'ccp-Cakm-BD': 'ccp',
        'ccp-BD': 'ccp',
        'ccp-Cakm': 'ccp',
        'ccp-Beng': 'ccp-Beng',
        'ccp-Beng-IN': 'ccp-Beng',
        'ccp-IN': 'ccp-Beng',
        'ccp-Latn': 'ccp-Latn',
        'ccp-Latn-BD': 'ccp-Latn',
        'ccr': 'ccr',
        'ccr-Latn-SV': 'ccr',
        'ccr-Latn': 'ccr',
        'ccr-SV': 'ccr',
        'cda': 'cda',
        'cda-Zyyy-CN': 'cda',
        'cda-CN': 'cda',
        'cda-Zyyy': 'cda',
        'cde': 'cde',
        'cde-Telu-IN': 'cde',
        'cde-IN': 'cde',
        'cde-Telu': 'cde',
        'cdf': 'cdf',
        'cdf-Latn-IN': 'cdf',
        'cdf-IN': 'cdf',
        'cdf-Latn': 'cdf',
        'cdf-Beng': 'cdf-Beng',
        'cdf-Beng-IN': 'cdf-Beng',
        'cdg': 'cdg',
        'cdg-Zyyy-IN': 'cdg',
        'cdg-IN': 'cdg',
        'cdg-Zyyy': 'cdg',
        'cdh': 'cdh',
        'cdh-Deva-IN': 'cdh',
        'cdh-Deva': 'cdh',
        'cdh-IN': 'cdh',
        'cdh-Takr': 'cdh-Takr',
        'cdh-Takr-IN': 'cdh-Takr',
        'cdi': 'cdi',
        'cdi-Gujr-IN': 'cdi',
        'cdi-Gujr': 'cdi',
        'cdi-IN': 'cdi',
        'cdj': 'cdj',
        'cdj-Deva-IN': 'cdj',
        'cdj-Deva': 'cdj',
        'cdj-IN': 'cdj',
        'cdm': 'cdm',
        'cdm-Deva-NP': 'cdm',
        'cdm-Deva': 'cdm',
        'cdm-NP': 'cdm',
        'cdm-Latn': 'cdm-Latn',
        'cdm-Latn-NP': 'cdm-Latn',
        'cdn': 'cdn',
        'cdn-Zyyy-IN': 'cdn',
        'cdn-IN': 'cdn',
        'cdn-Zyyy': 'cdn',
        'cdo-Hans': 'cdo-Hans',
        'cdo-Hans-CN': 'cdo-Hans',
        'cdo-Hant': 'cdo-Hant',
        'cdo-Hant-CN': 'cdo-Hant',
        'cdo-Latn': 'cdo-Latn',
        'cdo-Latn-CN': 'cdo-Latn',
        'cdr': 'cdr',
        'cdr-Latn-NG': 'cdr',
        'cdr-Latn': 'cdr',
        'cdr-NG': 'cdr',
        'cds': 'cds',
        'cds-Zxxx-TD': 'cds',
        'cds-TD': 'cds',
        'cds-Zxxx': 'cds',
        'sgn-cds': 'cds',
        'sgn-cds-TD': 'cds',
        'cdy': 'cdy',
        'cdy-Zyyy-CN': 'cdy',
        'cdy-CN': 'cdy',
        'cdy-Zyyy': 'cdy',
        'cdz': 'cdz',
        'cdz-Beng-IN': 'cdz',
        'cdz-Beng': 'cdz',
        'cdz-IN': 'cdz',
        'ce': 'ce',
        'ce-Cyrl-RU': 'ce',
        'ce-Cyrl': 'ce',
        'ce-RU': 'ce',
        'ce-Arab': 'ce-Arab',
        'ce-Arab-RU': 'ce-Arab',
        'ce-Latn': 'ce-Latn',
        'ce-Latn-RU': 'ce-Latn',
        'cea': 'cea',
        'cea-Zyyy-US': 'cea',
        'cea-US': 'cea',
        'cea-Zyyy': 'cea',
        'ceb': 'ceb',
        'ceb-Latn-PH': 'ceb',
        'ceb-Latn': 'ceb',
        'ceb-PH': 'ceb',
        'ceb-Brai': 'ceb-Brai',
        'ceb-Brai-PH': 'ceb-Brai',
        'ceg': 'ceg',
        'ceg-Latn-PY': 'ceg',
        'ceg-Latn': 'ceg',
        'ceg-PY': 'ceg',
        'cek': 'cek',
        'cek-Latn-MM': 'cek',
        'cek-Latn': 'cek',
        'cek-MM': 'cek',
        'cek-x-asang': 'cek-x-asang',
        'cek-Latn-MM-x-asang': 'cek-x-asang',
        'cek-Latn-x-asang': 'cek-x-asang',
        'cek-MM-x-asang': 'cek-x-asang',
        'cek-x-hnise': 'cek-x-hnise',
        'cek-Latn-MM-x-hnise': 'cek-x-hnise',
        'cek-Latn-x-hnise': 'cek-x-hnise',
        'cek-MM-x-hnise': 'cek-x-hnise',
        'cek-x-kanise': 'cek-x-kanise',
        'cek-Latn-MM-x-kanise': 'cek-x-kanise',
        'cek-Latn-x-kanise': 'cek-x-kanise',
        'cek-MM-x-kanise': 'cek-x-kanise',
        'cek-x-khawngtu': 'cek-x-khawngtu',
        'cek-Latn-MM-x-khawngtu': 'cek-x-khawngtu',
        'cek-Latn-x-khawngtu': 'cek-x-khawngtu',
        'cek-MM-x-khawngtu': 'cek-x-khawngtu',
        'cek-x-khongtu': 'cek-x-khongtu',
        'cek-Latn-MM-x-khongtu': 'cek-x-khongtu',
        'cek-Latn-x-khongtu': 'cek-x-khongtu',
        'cek-MM-x-khongtu': 'cek-x-khongtu',
        'cek-x-lemi': 'cek-x-lemi',
        'cek-Latn-MM-x-lemi': 'cek-x-lemi',
        'cek-Latn-x-lemi': 'cek-x-lemi',
        'cek-MM-x-lemi': 'cek-x-lemi',
        'cek-x-likhy': 'cek-x-likhy',
        'cek-Latn-MM-x-likhy': 'cek-x-likhy',
        'cek-Latn-x-likhy': 'cek-x-likhy',
        'cek-MM-x-likhy': 'cek-x-likhy',
        'cek-x-rengcaa': 'cek-x-rengcaa',
        'cek-Latn-MM-x-rengcaa': 'cek-x-rengcaa',
        'cek-Latn-x-rengcaa': 'cek-x-rengcaa',
        'cek-MM-x-rengcaa': 'cek-x-rengcaa',
        'cek-x-taaw': 'cek-x-taaw',
        'cek-Latn-MM-x-taaw': 'cek-x-taaw',
        'cek-Latn-x-taaw': 'cek-x-taaw',
        'cek-MM-x-taaw': 'cek-x-taaw',
        'cen': 'cen',
        'cen-Latn-NG': 'cen',
        'cen-Latn': 'cen',
        'cen-NG': 'cen',
        'cet': 'cet',
        'cet-Latn-NG': 'cet',
        'cet-Latn': 'cet',
        'cet-NG': 'cet',
        'cey': 'cey',
        'cey-Latn-MM': 'cey',
        'cey-Latn': 'cey',
        'cey-MM': 'cey',
        'cfa': 'cfa',
        'cfa-Latn-NG': 'cfa',
        'cfa-Latn': 'cfa',
        'cfa-NG': 'cfa',
        'cfd': 'cfd',
        'cfd-Latn-NG': 'cfd',
        'cfd-Latn': 'cfd',
        'cfd-NG': 'cfd',
        'cfg': 'cfg',
        'cfg-Latn-NG': 'cfg',
        'cfg-Latn': 'cfg',
        'cfg-NG': 'cfg',
        'cfm': 'cfm',
        'cfm-Latn-MM': 'cfm',
        'cfm-Latn': 'cfm',
        'cfm-MM': 'cfm',
        'cfm-Beng': 'cfm-Beng',
        'cfm-Beng-IN': 'cfm-Beng',
        'cfm-IN': 'cfm-Beng',
        'cfm-Latn-x-khuals': 'cfm-Latn-x-khuals',
        'cfm-Latn-MM-x-khuals': 'cfm-Latn-x-khuals',
        'cfm-MM-x-khuals': 'cfm-Latn-x-khuals',
        'cfm-Latn-x-lente': 'cfm-Latn-x-lente',
        'cfm-Latn-MM-x-lente': 'cfm-Latn-x-lente',
        'cfm-MM-x-lente': 'cfm-Latn-x-lente',
        'cfm-Latn-x-zannia': 'cfm-Latn-x-zannia',
        'cfm-Latn-MM-x-zannia': 'cfm-Latn-x-zannia',
        'cfm-MM-x-zannia': 'cfm-Latn-x-zannia',
        'cga': 'cga',
        'cga-Latn-PG': 'cga',
        'cga-Latn': 'cga',
        'cga-PG': 'cga',
        'cgc': 'cgc',
        'cgc-Latn-PH': 'cgc',
        'cgc-Latn': 'cgc',
        'cgc-PH': 'cgc',
        'cgg': 'cgg',
        'cgg-Latn-UG': 'cgg',
        'cgg-Latn': 'cgg',
        'cgg-UG': 'cgg',
        'cgk': 'cgk',
        'cgk-Zyyy-BT': 'cgk',
        'cgk-BT': 'cgk',
        'cgk-Zyyy': 'cgk',
        'ch': 'ch',
        'ch-Latn-GU': 'ch',
        'ch-GU': 'ch',
        'ch-Latn': 'ch',
        'chb': 'chb',
        'chb-Latn-CO': 'chb',
        'chb-CO': 'chb',
        'chb-Latn': 'chb',
        'chc': 'chc',
        'chc-Zyyy-US': 'chc',
        'chc-US': 'chc',
        'chc-Zyyy': 'chc',
        'chd': 'chd',
        'chd-Latn-MX': 'chd',
        'chd-Latn': 'chd',
        'chd-MX': 'chd',
        'chf': 'chf',
        'chf-Latn-MX': 'chf',
        'chf-Latn': 'chf',
        'chf-MX': 'chf',
        'chg': 'chg',
        'chg-Zyyy-TM': 'chg',
        'chg-TM': 'chg',
        'chg-Zyyy': 'chg',
        'chh': 'chh',
        'chh-Latn-US': 'chh',
        'chh-Latn': 'chh',
        'chh-US': 'chh',
        'chj': 'chj',
        'chj-Latn-MX': 'chj',
        'chj-Latn': 'chj',
        'chj-MX': 'chj',
        'chk': 'chk',
        'chk-Latn-FM': 'chk',
        'chk-FM': 'chk',
        'chk-Latn': 'chk',
        'chl': 'chl',
        'chl-Latn-US': 'chl',
        'chl-Latn': 'chl',
        'chl-US': 'chl',
        'chm': 'chm',
        'chm-Cyrl-RU': 'chm',
        'chm-Cyrl': 'chm',
        'chm-RU': 'chm',
        'mhr': 'chm',
        'mhr-Cyrl': 'chm',
        'mhr-Cyrl-RU': 'chm',
        'mhr-RU': 'chm',
        'chm-Latn': 'chm-Latn',
        'chm-Latn-RU': 'chm-Latn',
        'mhr-Latn': 'chm-Latn',
        'mhr-Latn-RU': 'chm-Latn',
        'chn': 'chn',
        'chn-Latn-US': 'chn',
        'chn-Latn': 'chn',
        'chn-US': 'chn',
        'chn-Dupl': 'chn-Dupl',
        'chn-Dupl-US': 'chn-Dupl',
        'cho': 'cho',
        'cho-Latn-US': 'cho',
        'cho-Latn': 'cho',
        'cho-US': 'cho',
        'chp': 'chp',
        'chp-Latn-CA': 'chp',
        'chp-CA': 'chp',
        'chp-Latn': 'chp',
        'chp-Cans': 'chp-Cans',
        'chp-Cans-CA': 'chp-Cans',
        'chq': 'chq',
        'chq-Latn-MX': 'chq',
        'chq-Latn': 'chq',
        'chq-MX': 'chq',
        'chr': 'chr',
        'chr-Cher-US': 'chr',
        'chr-Cher': 'chr',
        'chr-US': 'chr',
        'chr-Latn': 'chr-Latn',
        'chr-Latn-US': 'chr-Latn',
        'cht': 'cht',
        'cht-Latn-PE': 'cht',
        'cht-Latn': 'cht',
        'cht-PE': 'cht',
        'chw': 'chw',
        'chw-Latn-MZ': 'chw',
        'chw-Latn': 'chw',
        'chw-MZ': 'chw',
        'chx': 'chx',
        'chx-Deva-NP': 'chx',
        'chx-Deva': 'chx',
        'chx-NP': 'chx',
        'chy': 'chy',
        'chy-Latn-US': 'chy',
        'chy-Latn': 'chy',
        'chy-US': 'chy',
        'chz': 'chz',
        'chz-Latn-MX': 'chz',
        'chz-Latn': 'chz',
        'chz-MX': 'chz',
        'cia': 'cia',
        'cia-Latn-ID': 'cia',
        'cia-ID': 'cia',
        'cia-Latn': 'cia',
        'cia-Arab': 'cia-Arab',
        'cia-Arab-ID': 'cia-Arab',
        'cia-Hang': 'cia-Hang',
        'cia-Hang-ID': 'cia-Hang',
        'cib': 'cib',
        'cib-Latn-BJ': 'cib',
        'cib-BJ': 'cib',
        'cib-Latn': 'cib',
        'cic': 'cic',
        'cic-Latn-US': 'cic',
        'cic-Latn': 'cic',
        'cic-US': 'cic',
        'cid': 'cid',
        'cid-Zyyy-US': 'cid',
        'cid-US': 'cid',
        'cid-Zyyy': 'cid',
        'cie': 'cie',
        'cie-Latn-NG': 'cie',
        'cie-Latn': 'cie',
        'cie-NG': 'cie',
        'cih': 'cih',
        'cih-Deva-IN': 'cih',
        'cih-Deva': 'cih',
        'cih-IN': 'cih',
        'cik': 'cik',
        'cik-Zyyy-IN': 'cik',
        'cik-IN': 'cik',
        'cik-Zyyy': 'cik',
        'cim': 'cim',
        'cim-Latn-IT': 'cim',
        'cim-IT': 'cim',
        'cim-Latn': 'cim',
        'cin': 'cin',
        'cin-Latn-BR': 'cin',
        'cin-BR': 'cin',
        'cin-Latn': 'cin',
        'cip': 'cip',
        'cip-Latn-MX': 'cip',