/* ============================================================
 * Author: M. Asselstine <asselsm@gmail.com>
 * Date  : 05-08-2005
 * Description : 
 * 
 * Copyright 2005 by M. Asselstine

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * ============================================================ */


#include <qtimer.h>
#include <klocale.h>
#include <kshortcut.h>
#include <kstdaction.h>
#include <kactioncollection.h>
 
#include "kflickrpart.h"
 
kflickrPart* kflickrPart::m_instance;

kflickrPart::kflickrPart(QWidget *parentWidget, const char *widgetName,
                          QObject *parent, const char *name )
    : KParts::ReadOnlyPart(parent, name)
    , m_widget(*(new kflickrWidget(parentWidget, widgetName)))
    , m_bandwidth(0)
    , m_listCount(0)
    , m_statusBar(*(new KParts::StatusBarExtension(this)))
{
    // we need an instance
    setInstance(kflickrPartFactory::instance());
    kflickrPart::Instance(this);

    // notify the part that this is our internal widget
    setWidget(&m_widget);
    
    // The big four actions
    new KAction(i18n("&Add"), "add", KShortcut("CTRL++"), &m_widget,
        SLOT(addPhotos()), actionCollection(), "add_photos");
    new KAction(i18n("&Remove"), "remove", KShortcut("CTRL+-"), &m_widget,
        SLOT(removePhotos()), actionCollection(), "remove_photos");
    new KAction(i18n("&Edit"), "edit", KShortcut("CTRL+e"), &m_widget,
        SLOT(onEditSelected()), actionCollection(), "edit_photos");
    new KAction(i18n("&Upload"), "up", KShortcut("CTRL+u"), &m_widget,
        SLOT(uploadPhotos()), actionCollection(), "upload_photos");
        
    // Host application signal connections
    connect(&m_widget, SIGNAL(photoCount(int)), SLOT(newPhotoCount(int)));
    connect(&m_widget, SIGNAL(bandwidthValue(const QString& )),
            SLOT(newBandwidthValue(const QString &))); 
        
    // set our XML-UI resource file
    setXMLFile("kflickrpart.rc");
    
    QTimer::singleShot(0, this, SLOT(setupStatusBar()));
}

kflickrPart::~kflickrPart()
{
}

kflickrPart* kflickrPart::Instance(kflickrPart* instance)
{
    if( instance != 0 )
    {
        m_instance = instance;
    }
    return m_instance;
}

void kflickrPart::setupStatusBar()
{
    m_bandwidth = new KStatusBarLabel("", 0, m_statusBar.statusBar());
    m_listCount = new KStatusBarLabel(i18n("# of Photos: %1").arg("0"), 1, m_statusBar.statusBar());
    m_statusBar.addStatusBarItem(m_bandwidth, 0, true);
    m_statusBar.addStatusBarItem(m_listCount, 0, true);
}

bool kflickrPart::openFile()
{
    m_widget.addPhoto(m_url);
    
    return true;
}

void kflickrPart::newBandwidthValue(const QString &val)
{
    if(m_bandwidth)
    {
        m_bandwidth->setText(i18n("Unused Upload Bandwidth: %1").arg(val));
    }
}

void kflickrPart::newPhotoCount(int val)
{
    if(m_listCount)
    {
        m_listCount->setText(i18n("# of Photos: %1").arg(val));
    }
}


// Factory code.
#include <klocale.h>
#include <kaboutdata.h>

KAboutData* kflickrPartFactory::s_about = 0L;
KInstance*  kflickrPartFactory::s_instance = 0L;

kflickrPartFactory::kflickrPartFactory()
    : KParts::Factory()
{
}

kflickrPartFactory::~kflickrPartFactory()
{
    delete s_instance;
    delete s_about;

    s_instance = 0L;
}

KParts::Part* kflickrPartFactory::createPartObject(
        QWidget *parentWidget, const char *widgetName,
        QObject *parent, const char *name,
        const char *, const QStringList &)
{
    // Create an instance of our Part
    return new kflickrPart( parentWidget, widgetName, parent, name );
}

KInstance* kflickrPartFactory::instance()
{
    if( !s_instance )
    {
        s_about = new KAboutData("kflickrpart", I18N_NOOP("kflickrPart"), "0.7");
        s_about->addAuthor("M. Asselstine", 0, "asselsm@gmail.com");
        s_instance = new KInstance(s_about);
    }
    return s_instance;
}

extern "C"
{
    void* init_libkflickrpart()
    {
	KGlobal::locale()->insertCatalogue("kflickr");
        return new kflickrPartFactory;
    }
};
