/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 * Copyright (C) 2004 Markus Brueffer <markus@brueffer.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#include "kftpmainactions.h"
#include <config.h>

#include "misc.h"
#include "kftpapi.h"
#include "kftpclientthread.h"
#include "kftpqueue.h"
#include "kftpbookmarks.h"
#include "configdialog.h"
#include "kftpsession.h"

#include "misc/config.h"

#include <kmainwindow.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kaboutapplication.h>
#include <kkeydialog.h>
#include <kedittoolbar.h>

using namespace KFTPGrabberBase;

KFTPMainActions::KFTPMainActions(QObject *parent, const char *name)
 : QObject(parent, name),
   m_configDialog(0L),
   m_closeApp(false)
{
  if (!parent->inherits("KMainWindow")) {
    qDebug("WARNING: KFTPMainAction should be created by KMainWindow only!");
    return;
  }
}

KActionCollection *KFTPMainActions::actionCollection()
{
  return KFTPAPI::getInstance()->mainWindow()->actionCollection();
}

KMainWindow *KFTPMainActions::mainWidget()
{
  return KFTPAPI::getInstance()->mainWindow();
}

void KFTPMainActions::initActions()
{
  // setup File menu
  m_fileConnectAction = new KAction(i18n("Quick &Connect..."), "connect_creating", KShortcut(), mainWidget(), SLOT(slotQuickConnect()), actionCollection(), "file_quick_connect");
  m_newSessionAction = new KActionMenu(i18n("&New Session"), "filenew", actionCollection(), "file_newsession");

  KAction *leftSide = new KAction(i18n("&Left Side"), KShortcut(), this, SLOT(slotNewSessionLeft()), actionCollection());
  KAction *rightSide = new KAction(i18n("&Right Side"), KShortcut(), this, SLOT(slotNewSessionRight()), actionCollection());
  m_newSessionAction->insert(leftSide);
  m_newSessionAction->insert(rightSide);
  m_newSessionAction->setStickyMenu(true);
  m_newSessionAction->setDelayed(false);
  KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection());

  // setup Settings menu
  //KStdAction::configureToolbars(this, SLOT(slotConfigureToolbars()), actionCollection());
  //KStdAction::keyBindings(this, SLOT(slotKeyBindings()), actionCollection());
  KStdAction::saveOptions(this, SLOT(slotSettingsSave()), actionCollection());
  KStdAction::preferences(this, SLOT(slotSettingsConfig()), actionCollection());
  mainWidget()->createStandardStatusBarAction();
  mainWidget()->setStandardToolBarMenuEnabled(true);

  // setup transfermode actions
  m_transModeAction = new KActionMenu(i18n("&Transfer Mode (Auto)"), "binary", actionCollection(), "transfermode");
  m_modeAscii = new KRadioAction(i18n("ASCII"), "ascii", KShortcut(), this, SLOT(slotModeAscii()), actionCollection());
  m_modeBinary = new KRadioAction(i18n("Binary"), "binary", KShortcut(), this, SLOT(slotModeBinary()), actionCollection());
  m_modeAuto = new KRadioAction(i18n("Auto"), KShortcut(), this, SLOT(slotModeAuto()), actionCollection());

  // Set grouping so only one action can be selected
  m_modeAscii->setExclusiveGroup("Transfer mode");
  m_modeBinary->setExclusiveGroup("Transfer mode");
  m_modeAuto->setExclusiveGroup("Transfer mode");

  // Insert the actions into the menu
  m_transModeAction->insert(m_modeAscii);
  m_transModeAction->insert(m_modeBinary);
  m_transModeAction->popupMenu()->insertSeparator();
  m_transModeAction->insert(m_modeAuto);
  m_transModeAction->setStickyMenu(true);
  m_transModeAction->setDelayed(false);

  updateActions();
}

void KFTPMainActions::updateActions()
{
}

void KFTPMainActions::slotModeAscii()
{
  m_transModeAction->setIcon("ascii");
  m_transModeAction->setText(i18n("&Transfer Mode (ASCII)"));
  KFTPCore::Config::self()->setGlobalMode('A');
}

void KFTPMainActions::slotModeBinary()
{
  m_transModeAction->setIcon("binary");
  m_transModeAction->setText(i18n("&Transfer Mode (Binary)"));
  KFTPCore::Config::self()->setGlobalMode('I');
}

void KFTPMainActions::slotModeAuto()
{
  m_transModeAction->setText(i18n("&Transfer Mode (Auto)"));
  KFTPCore::Config::self()->setGlobalMode('X');
}

void KFTPMainActions::slotFileQuit()
{
  m_closeApp = true;
  mainWidget()->close();
}

void KFTPMainActions::slotSettingsSave()
{
  KFTPCore::Config::self()->saveConfig();
}

void KFTPMainActions::slotSettingsConfig()
{
  if (!m_configDialog)
    m_configDialog = new KFTPWidgets::ConfigDialog(mainWidget());

  m_configDialog->prepareDialog();
  m_configDialog->exec();
}

void KFTPMainActions::slotNewSessionLeft()
{
  FTPSessionManager->spawnLocalSession(LEFT_SIDE, true);
}

void KFTPMainActions::slotNewSessionRight()
{
  FTPSessionManager->spawnLocalSession(RIGHT_SIDE, true);
}

void KFTPMainActions::slotKeyBindings()
{
  KKeyDialog::configure(actionCollection());
}

void KFTPMainActions::slotConfigureToolbars()
{
  KEditToolbar dlg(actionCollection());

  if (dlg.exec())
    mainWidget()->createGUI();
}

#include "kftpmainactions.moc"
