/*
 * This file is part of the KFTPGrabber project
 *
 * Copyright (C) 2003-2004 by the KFTPGrabber developers
 * Copyright (C) 2003-2004 Jernej Kos <kostko@jweb-network.net>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * is provided AS IS, WITHOUT ANY WARRANTY; without even the implied
 * warranty of MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, and
 * NON-INFRINGEMENT.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Steet, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations
 * including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * file(s) with this exception, you may extend this exception to your
 * version of the file(s), but you are not obligated to do so.  If you
 * do not wish to do so, delete this exception statement from your
 * version.  If you delete this exception statement from all source
 * files in the program, then also delete it here.
 */

#include <kpopupmenu.h>
#include <klocale.h>
#include <kio/jobclasses.h>
#include <kwin.h>

#include <qpainter.h>
#include <qtimer.h>

#include "kftpballoon.h"
#include "kftpgrabber.h"
#include "kftpsystemtray.h"
#include "kftpmainactions.h"
#include "kftpbookmarks.h"
#include "kftpqueue.h"
#include "misc.h"
#include "misc/config.h"

using namespace KFTPGrabberBase;

// For global usage
KFTPSystemTray *s_sysTray;

KFTPStatusMenuItem::KFTPStatusMenuItem()
  : QCustomMenuItem()
{
}

void KFTPStatusMenuItem::paint(QPainter *p, const QColorGroup&, bool, bool, int x, int y, int w, int h)
{
  QString p_transferStr = i18n("Transfer:");
  QString p_percStr;
  p_percStr.sprintf("%d %%", KFTPQueue::Manager::self()->getTransferPercentage());
  QString p_speedStr = i18n("Down: %1/s  Up: %1/s")
                            .arg(KIO::convertSize(KFTPQueue::Manager::self()->getDownloadSpeed()))
                            .arg(KIO::convertSize(KFTPQueue::Manager::self()->getUploadSpeed()));

  int p_trStrWidth = p->fontMetrics().size(AlignLeft | DontClip | ShowPrefix, p_transferStr).width();
  int p_trStrHeight = p->fontMetrics().size(AlignLeft | DontClip | ShowPrefix, p_transferStr).height();

  p->drawText(x, y + 2, w, h, AlignLeft | DontClip | ShowPrefix, p_transferStr);
  p->drawPixmap(x + p_trStrWidth + 5, y + 3, createProgressPixmap(KFTPQueue::Manager::self()->getTransferPercentage()));
  p->drawText(x + p_trStrWidth + 5 + 100 + 5, y + 2, w, h, AlignLeft | DontClip | ShowPrefix, p_percStr);

  QFont f = p->font();
  f.setBold(true);
  p->setFont(f);

  int p_spStrWidth = p->fontMetrics().size(AlignLeft | DontClip | ShowPrefix, p_speedStr).width();
  p->drawText((x + x + 150/2)-(p_spStrWidth/2), y + 2 + p_trStrHeight + 2, w, h, AlignLeft | DontClip | ShowPrefix, p_speedStr);
}

QSize KFTPStatusMenuItem::sizeHint()
{
  return QSize(150, 36);
}

KFTPSystemTray::KFTPSystemTray(KFTPMainActions *actions, KFTPGrabber *parent)
  : KSystemTray(parent), m_balloon(0)
{
  // Set icon and show it!
  setPixmap(loadToolbarPixmap("kftpgrabber"));
  
  if (KFTPCore::Config::showSystrayIcon())
    show();

  // Add some actions
  m_bookmarkMenu = new KActionMenu(i18n("Bookmarks"));
  slotUpdateBookmarks();

  // Let our bookmarks be up to date!
  connect(FTPBookmarkManager, SIGNAL(update()), this, SLOT(slotUpdateBookmarks()));
  
  actions->m_fileConnectAction->plug(contextMenu(), 1);
  m_bookmarkMenu->plug(contextMenu(), 1);
  contextMenu()->insertSeparator(1);

  KFTPStatusMenuItem *transInfo = new KFTPStatusMenuItem();
  contextMenu()->insertItem(loadSmallIcon("info"), transInfo, 0, 1);

  connect(this, SIGNAL(quitSelected()), actions, SLOT(slotFileQuit()));
}

KFTPSystemTray::~KFTPSystemTray()
{
  delete m_bookmarkMenu;
}

void KFTPSystemTray::slotUpdateBookmarks()
{
  // Re-create the bookmarks menu
  m_bookmarkMenu->popupMenu()->clear();
  FTPBookmarkManager->guiPopulateBookmarksMenu(m_bookmarkMenu);
}

void KFTPSystemTray::showBalloon(const QString &text)
{
  // Create a little modified Kopete balloon
  if (m_balloon) {
    m_balloon->hide();
    delete m_balloon;
  }
  
  m_balloon = new KFTPBalloon("<qt><nobr><b>KFTPGrabber:</b><br>"+text+"</nobr></qt>", "info");
  m_balloon->setAnchor(mapToGlobal(pos()));
  m_balloon->show();
  KWin::setOnAllDesktops(m_balloon->winId() , true);

  // Hide the balloon after 5 sec
  QTimer::singleShot(5000, this, SLOT(slotHideBalloon()));
}

void KFTPSystemTray::slotHideBalloon()
{
  m_balloon->hide();
}

#include "kftpsystemtray.moc"
