/***************************************************************************
 *   Copyright (C) 2007, 2008 by Marcel Hasler                             *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "configappearance.h"

#include <qlabel.h>
#include <qcheckbox.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qspinbox.h>

ConfigAppearance::ConfigAppearance(QWidget* parent, const char* name, WFlags fl)
	: ConfigAppearanceLayout(parent, name, fl)
{
}


ConfigAppearance::~ConfigAppearance()
{
}


void ConfigAppearance::setAnimatePopup(bool enabled)
{
	m_animatePopup->setChecked(enabled);

	m_animationDelayLabel->setEnabled(enabled);
	m_animationDelay->setEnabled(enabled);

	m_popupDirectionLabel->setEnabled(enabled);
	m_popupUp->setEnabled(enabled);
	m_popupDown->setEnabled(enabled);
}


#include "configappearance.moc"
