/***************************************************************************
 *   Copyright (C) 2007, 2008 by Marcel Hasler                             *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "confignotification.h"

#include <kiconloader.h>
#include <kfiledialog.h>
#include <klocale.h>

#include <qlabel.h>
#include <qcheckbox.h>
#include <qpushbutton.h>
#include <qlineedit.h>

ConfigNotification::ConfigNotification(QWidget* parent, const char* name, WFlags fl)
	: ConfigNotificationLayout(parent, name, fl)
{
	m_selectSoundFile->setPixmap(KGlobal::iconLoader()->loadIcon("fileopen",KIcon::Small,0,false));
	connect(m_selectSoundFile, SIGNAL(clicked()), this, SLOT(slotSelectSoundFile()));
}


ConfigNotification::~ConfigNotification()
{
}


void ConfigNotification::setSoundEnabled(bool enabled)
{
	m_enableSound->setChecked(enabled);
	m_fileToPlayLabel->setEnabled(enabled);
	m_fileToPlay->setEnabled(enabled);
	m_selectSoundFile->setEnabled(enabled);
}


void ConfigNotification::setLedEnabled(bool enabled)
{
	m_enableLed->setChecked(enabled);
	m_ledOnCommandLabel->setEnabled(enabled);
	m_ledOnCommand->setEnabled(enabled);
	m_ledOffCommandLabel->setEnabled(enabled);
	m_ledOffCommand->setEnabled(enabled);
}


// Private slots:
void ConfigNotification::slotSelectSoundFile()
{
	QString fileToPlay = KFileDialog::getOpenFileName(m_fileToPlay->text(), "*.wav *.ogg *.mp3", this, i18n("Select a file"));
	if (fileToPlay != QString::null)
	{
		if (QFile::exists(fileToPlay))
			m_fileToPlay->setText(fileToPlay);
	}
}


#include "confignotification.moc"
