/***************************************************************************
 *   Copyright (C) 2007, 2008 by Marcel Hasler                             *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "configurationdialog.h"
#include "configuration.h"
#include "iconpaths.h"
#include "wallet.h"

#include <qlayout.h>
#include <qframe.h>
#include <qlineedit.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <qradiobutton.h>
#include <qfile.h>

#include <kfiledialog.h>
#include <kiconloader.h>
#include <klocale.h>

ConfigurationDialog::ConfigurationDialog(QWidget *parent, const char *name, WFlags f)
	: KDialogBase(IconList, i18n("Preferences"), Ok|Apply|Cancel, Ok, parent, name, f)
{
	// Add general options page
	QFrame *frame = addPage(i18n("General"), i18n("General"), KGlobal::iconLoader()->loadIcon(ICON_RED,KIcon::Panel,0,false));
	QVBoxLayout *frameLayout = new QVBoxLayout(frame, 0, 0);
	m_configGeneralPage = new ConfigGeneral(frame);
	frameLayout->addWidget(m_configGeneralPage);

	// Add appearance options page
	frame = addPage(i18n("Appearance"), i18n("Appearance"), KGlobal::iconLoader()->loadIcon("looknfeel",KIcon::Panel,0,false));
	frameLayout = new QVBoxLayout(frame, 0, 0);
	m_configAppearancePage = new ConfigAppearance(frame);
	frameLayout->addWidget(m_configAppearancePage);

	// Add notification options page
	frame = addPage(i18n("Notification"), i18n("Notification"), KGlobal::iconLoader()->loadIcon("knotify",KIcon::Panel,0,false));
	frameLayout = new QVBoxLayout(frame, 0, 0);
	m_configNotificationPage = new ConfigNotification(frame);
	frameLayout->addWidget(m_configNotificationPage);

	// Add advanced options page
	frame = addPage(i18n("Advanced"), i18n("Advanced"), KGlobal::iconLoader()->loadIcon("configure",KIcon::Panel,0,false));
	frameLayout = new QVBoxLayout(frame, 0, 0);
	m_configAdvancedPage = new ConfigAdvanced(frame);
	frameLayout->addWidget(m_configAdvancedPage);

	this->enableButtonSeparator(true);
	this->resize(frameLayout->minimumSize());

	// Connect slots for ok/apply/cancel
	connect(this, SIGNAL(applyClicked()), this, SLOT(slotUpdateConfiguration()));
	connect(this, SIGNAL(okClicked()), this, SLOT(slotUpdateConfiguration()));
}


ConfigurationDialog::~ConfigurationDialog()
{
	if (m_configGeneralPage)
		delete m_configGeneralPage;

	if (m_configAppearancePage)
		delete m_configAppearancePage;

	if (m_configNotificationPage)
		delete m_configNotificationPage;

	if (m_configAdvancedPage)
		delete m_configAdvancedPage;
}


void ConfigurationDialog::show()
{
	// Fill in general page
	m_configGeneralPage->m_username->setText(Configuration().readEntry("Username"));
	m_configGeneralPage->m_password->setText(Configuration().readEntry("Password"));
	m_configGeneralPage->m_checkInterval->setValue(Configuration().readNumEntry("CheckInterval"));
	m_configGeneralPage->m_browserPath->setText(Configuration().readEntry("BrowserPath"));
	m_configGeneralPage->setSavePassword(Configuration().readBoolEntry("SavePassword"));

	if (Configuration().readEntry("PasswordMethod") == "File")
	{
		m_configGeneralPage->m_saveWallet->setChecked(false);
		m_configGeneralPage->m_saveFile->setChecked(true);
	}
	else
	{
		m_configGeneralPage->m_saveWallet->setChecked(true);
		m_configGeneralPage->m_saveFile->setChecked(false);
	}


	// Fill in appearance page
	m_configAppearancePage->m_horizontalOffset->setValue(Configuration().readNumEntry("HorizontalOffset"));
	m_configAppearancePage->m_verticalOffset->setValue(Configuration().readNumEntry("VerticalOffset"));
	m_configAppearancePage->m_popupTimeout->setValue(Configuration().readNumEntry("PopupTimeout"));
	m_configAppearancePage->setAnimatePopup(Configuration().readBoolEntry("PopupAnimated"));
	m_configAppearancePage->m_animationDelay->setValue(Configuration().readNumEntry("AnimationDelay"));
	m_configAppearancePage->m_numberOnSystray->setChecked(Configuration().readBoolEntry("NumberOnSystray"));

	if (Configuration().readEntry("PopupDirection") == "Down")
	{
		m_configAppearancePage->m_popupUp->setChecked(false);
		m_configAppearancePage->m_popupDown->setChecked(true);
	}
	else
	{
		m_configAppearancePage->m_popupUp->setChecked(true);
		m_configAppearancePage->m_popupDown->setChecked(false);
	}


	// Fill in notification page
	m_configNotificationPage->m_showPopup->setChecked(Configuration().readBoolEntry("ShowPopup"));
	m_configNotificationPage->setSoundEnabled(Configuration().readBoolEntry("SoundEnabled"));
	m_configNotificationPage->m_fileToPlay->setText(Configuration().readEntry("SoundFile"));
	m_configNotificationPage->setLedEnabled(Configuration().readBoolEntry("LedEnabled"));
	m_configNotificationPage->m_ledOnCommand->setText(Configuration().readEntry("LedOnCommand"));
	m_configNotificationPage->m_ledOffCommand->setText(Configuration().readEntry("LedOffCommand"));


	// Fill in advanced page
	m_configAdvancedPage->m_lockOnPrimaryScreen->setChecked(Configuration().readBoolEntry("LockOnPrimaryScreen"));
	m_configAdvancedPage->m_startAutomatically->setChecked(Configuration().readBoolEntry("Autostart"));
	m_configAdvancedPage->m_askQuit->setChecked(Configuration().readEntry("QuitDontAskAgain") != "yes");


	this->KDialogBase::show();
}


///////////////////
// Private slots //
///////////////////
void ConfigurationDialog::slotUpdateConfiguration()
{
	// Read from general page
	Configuration().writeEntry("Username", m_configGeneralPage->m_username->text());
	Configuration().writeEntry("Password", m_configGeneralPage->m_password->text());
	Configuration().writeEntry("CheckInterval", m_configGeneralPage->m_checkInterval->value());
	Configuration().writeEntry("BrowserPath", m_configGeneralPage->m_browserPath->text());

	if (m_configGeneralPage->m_savePassword->isChecked())
		Configuration().writeEntry("SavePassword", true);
	else
		Configuration().writeEntry("SavePassword", false);

	if (m_configGeneralPage->m_saveFile->isChecked())
		Configuration().writeEntry("PasswordMethod", QString("File"));
	else
		Configuration().writeEntry("PasswordMethod", QString("Wallet"));


	// Read from appearance page
	Configuration().writeEntry("HorizontalOffset", m_configAppearancePage->m_horizontalOffset->value());
	Configuration().writeEntry("VerticalOffset", m_configAppearancePage->m_verticalOffset->value());
	Configuration().writeEntry("PopupTimeout", m_configAppearancePage->m_popupTimeout->value());
	Configuration().writeEntry("PopupAnimated", m_configAppearancePage->m_animatePopup->isChecked());
	Configuration().writeEntry("AnimationDelay", m_configAppearancePage->m_animationDelay->value());
	Configuration().writeEntry("NumberOnSystray", m_configAppearancePage->m_numberOnSystray->isChecked());

	if (m_configAppearancePage->m_popupDown->isChecked())
		Configuration().writeEntry("PopupDirection", QString("Down"));
	else
		Configuration().writeEntry("PopupDirection", QString("Up"));


	// Read from notification page
	Configuration().writeEntry("ShowPopup", m_configNotificationPage->m_showPopup->isChecked());
	Configuration().writeEntry("SoundFile", m_configNotificationPage->m_fileToPlay->text());

	if (m_configNotificationPage->m_fileToPlay->text() == "")
		Configuration().writeEntry("SoundEnabled", false);
	else
		Configuration().writeEntry("SoundEnabled", m_configNotificationPage->m_enableSound->isChecked());

	Configuration().writeEntry("LedOnCommand", m_configNotificationPage->m_ledOnCommand->text());
	Configuration().writeEntry("LedOffCommand", m_configNotificationPage->m_ledOffCommand->text());

	if (m_configNotificationPage->m_ledOnCommand->text() == "" || m_configNotificationPage->m_ledOffCommand->text() == "")
		Configuration().writeEntry("LedEnabled", false);
	else
		Configuration().writeEntry("LedEnabled", m_configNotificationPage->m_enableLed->isChecked());


	// Read from advanced page
	Configuration().writeEntry("LockOnPrimaryScreen", m_configAdvancedPage->m_lockOnPrimaryScreen->isChecked());
	Configuration().writeEntry("Autostart", m_configAdvancedPage->m_startAutomatically->isChecked());

	if (m_configAdvancedPage->m_askQuit->isChecked())
		Configuration().writeEntry("QuitDontAskAgain", QString(""));
	else
		Configuration().writeEntry("QuitDontAskAgain", QString("yes"));


	// Save to disk
	Configuration().writeToDisk();
	emit configurationUpdated();
}


#include "configurationdialog.moc"
