/***************************************************************************
 *   Copyright (C) 2007-2009 by Marcel Hasler                              *
 *   mahasler@gmail.com                                                    *
 *                                                                         *
 *   This file is part of KGmailNotifier.                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation, either version 3 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the          *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program. If not, see <http://www.gnu.org/licenses/>.  *
 ***************************************************************************/

#include "wallet.h"

#include <iostream>
using namespace std;

static WId screenID = 1; // Is this appropriate?

// ------------------------------------------------------------------------------------------------------------------- //
//    Construction & Destruction                                                                                       //
// ------------------------------------------------------------------------------------------------------------------- //

Wallet::Wallet()
    : m_wallet(0),
      m_firstTimeOpen(true)
{
}

// ------------------------------------------------------------------------------------------------------------------- //

Wallet::~Wallet()
{
    if (m_wallet)
        delete m_wallet;
}


// ------------------------------------------------------------------------------------------------------------------- //
//    Public methods                                                                                                   //
// ------------------------------------------------------------------------------------------------------------------- //

void Wallet::writePassword(const QString& password)
{
    if (m_firstTimeOpen)
    {
        if (KWallet::Wallet::isOpen(KWallet::Wallet::NetworkWallet()))
            KWallet::Wallet::disconnectApplication(KWallet::Wallet::NetworkWallet(), "kgmailnotifier");

        m_firstTimeOpen = false;
    }

    if (!m_wallet)
        m_wallet = KWallet::Wallet::openWallet(KWallet::Wallet::NetworkWallet(), screenID);

    if (m_wallet)
    {
        connect(m_wallet, SIGNAL(walletClosed()), this, SLOT(slotWalletClosed()));

        if (!m_wallet->hasFolder("KGmailNotifier"))
            m_wallet->createFolder("KGmailNotifier");

        if (m_wallet->setFolder("KGmailNotifier"))
            m_wallet->writePassword("Password", password);

        KWallet::Wallet::closeWallet(KWallet::Wallet::NetworkWallet(), false);
    }
    else
        cerr << "In Wallet::writePassword(): Error: Couldn't connect to KWallet!" << endl;
}

// ------------------------------------------------------------------------------------------------------------------- //

QString Wallet::readPassword()
{
    if (m_firstTimeOpen)
    {
        if (KWallet::Wallet::isOpen(KWallet::Wallet::NetworkWallet()))
            KWallet::Wallet::disconnectApplication(KWallet::Wallet::NetworkWallet(), "kgmailnotifier");

        m_firstTimeOpen = false;
    }

    if (!m_wallet)
        m_wallet = KWallet::Wallet::openWallet(KWallet::Wallet::NetworkWallet(), screenID);

    if (m_wallet)
    {
        connect(m_wallet, SIGNAL(walletClosed()), this, SLOT(slotWalletClosed()));

        QString password;
        if (m_wallet->setFolder("KGmailNotifier"))
            m_wallet->readPassword("Password", password);
        else
            password = "";

        KWallet::Wallet::closeWallet(KWallet::Wallet::NetworkWallet(), false);

        return password;
    }
    else
    {
        cerr << "In Wallet::readPassword(): Error: Couldn't connect to KWallet!" << endl;
        return QString("");
    }
}

// ------------------------------------------------------------------------------------------------------------------- //

void Wallet::deletePassword()
{
    if (!m_wallet)
        m_wallet = KWallet::Wallet::openWallet(KWallet::Wallet::NetworkWallet(), screenID);

    if (m_wallet)
    {
        connect(m_wallet, SIGNAL(walletClosed()), this, SLOT(slotWalletClosed()));

        if (m_wallet->hasFolder("KGmailNotifier"))
            m_wallet->removeFolder("KGmailNotifier");

        KWallet::Wallet::closeWallet(KWallet::Wallet::NetworkWallet(), false);
    }
    else
        cerr << "In Wallet::deletePassword(): Error: Couldn't connect to KWallet!" << endl;
}


// ------------------------------------------------------------------------------------------------------------------- //
//    Private slots                                                                                                    //
// ------------------------------------------------------------------------------------------------------------------- //

void Wallet::slotWalletClosed()
{
    if (m_wallet)
    {
        delete m_wallet;
        m_wallet = 0;
    }
}

// ------------------------------------------------------------------------------------------------------------------- //

#include "wallet.moc"
