/***************************************************************************
 *   Copyright (C) 2008 by Konstantinos Smanis                             *
 *   kon.smanis@gmail.com                                                  *
 *                                                                         *
 *   This file is part of KGRUBEditor.                                     *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   51 Franklin Street, Fifth Floor                                       *
 *   Boston, MA 02110-1301, USA.                                          *
 ***************************************************************************/

#ifndef SPLASH_DELEGATE_H
#define SPLASH_DELEGATE_H

//Qt
#include <qstandarditemmodel.h>
#include <qabstractitemdelegate.h>

//KDE
namespace ThreadWeaver
{
class Job;
}

class SplashModel : public QAbstractListModel
{
Q_OBJECT
public:
	SplashModel( QObject *parent = 0 );

	virtual QVariant data( const QModelIndex &index, int role ) const;
	int indexOf( const QString &path ) const;
	virtual int rowCount( const QModelIndex &parent ) const;
public slots:
	void reload();
	void appendSplashImagePreview( ThreadWeaver::Job *job );
	void removeSplashImagePreview( const QString &path );
	void splashImageThumbPreviewsDone( ThreadWeaver::Job *job );
private:
	QMap<QString, QPixmap> m_splash;
};

class SplashDelegate : public QAbstractItemDelegate
{
public:
	SplashDelegate( QObject *parent = 0 );

	virtual void paint( QPainter *painter, const QStyleOptionViewItem &option, const QModelIndex &index ) const;
	virtual QSize sizeHint( const QStyleOptionViewItem &option, const QModelIndex &index ) const;
};

#endif
