/*
 * Multi-threaded player for audio+video. Based on 
 * spider_seek.c example from gst-plugins.
 */

#include <kde/gst/gstreamer.h>
#include <kde/gst/element.h>
#include <kde/gst/elementfactory.h>
#include <kde/gst/bin.h>
#include <kde/gst/pipeline.h>
#include <kde/gst/thread.h>

#include <qglobal.h>

using namespace KDE::GST;


/* eos will be called when the src element has an end of stream */
void eos(Element *, void *data) 
{
  Q_ASSERT(data != NULL);
  Thread *thread = (Thread*)data;
  qDebug("have eos, quitting\n");

  /* stop the bin */
  thread->setState(Element::STATE_NULL);

  GStreamer::mainQuit();
}

int main(int argc,char *argv[])
{
  Element *src, *decoder, *audiosink, *videosink, *a_queue, *v_queue;
  Thread *thread, *a_thread, *v_thread;

  GStreamer::init(&argc,&argv);

  if (argc != 2) {
    qDebug("\nusage: %s <filename>\n", argv[0]);
    qDebug("(note that the audio is played via OSS, so disable arts or use artsdsp)\n");
    return -1;
  }

  /* create a new thread to hold the elements */
  thread = new Thread("app");
  Q_ASSERT(thread != NULL);

  src = ElementFactory::make("filesrc", "src");
  Q_ASSERT(src != NULL);
  decoder = ElementFactory::make("spider", "decoder");
  Q_ASSERT(decoder != NULL);
  a_thread = new Thread("a_thread");
  a_queue = ElementFactory::make("queue", "a_queue");
  Q_ASSERT(a_queue != NULL);
  audiosink = ElementFactory::make("osssink", "a_sink");
  Q_ASSERT(audiosink != NULL);

  v_thread = new Thread("v_thread");
  v_queue = ElementFactory::make("queue", "v_queue");
  videosink = ElementFactory::make("xvideosink", "v_sink");
  Q_ASSERT(videosink != NULL);

  src->setString("location", argv[1]);
  src->registerEosCallback(eos, thread);

  thread->add(src, decoder);
  a_thread->add(a_queue, audiosink);
  v_thread->add(v_queue, videosink);
  thread->add(a_thread, v_thread);

  src->link(decoder);
  v_queue->link(videosink);
  decoder->link(v_queue);
  a_queue->link(audiosink);
  decoder->link(a_queue);

  /* start playing */
  thread->setState(Element::STATE_PLAYING);

  GStreamer::main();
  qDebug("done\n");

  delete thread;

  return 0;
}

