/*
 * Multi-threaded GUI player for audio+video. 
 * Demonstrates Qt event loop integration
 * and seeking.
 * Based on spider_seek.c example from gst-plugins.
 */

#ifndef GUISEEKER_H
#define GUISEEKER_H

#include <kde/gst/element.h>
#include <kde/gst/thread.h>

#include <qtimer.h>
#include <qpushbutton.h>
#include <qslider.h>
#include <qevent.h>
#include <qlayout.h>
#include <qapplication.h>
#include <qxembed.h>

using namespace KDE::GST;

const int UPDATE_INTERVAL = 500; /* update interval of the slider */

/**
 * To transport the xvideosink's size from Gst thread to Qt's event thread
 */
const int VideoSizeEventType = 781003;
class VideoSizeEvent : public QCustomEvent
{
	int m_width, m_height;
public:
	VideoSizeEvent(int w, int h) : 
		QCustomEvent(VideoSizeEventType),
		m_width(w),
		m_height(h)
	{};
	int width() { return m_width; }
	int height() { return m_height; }
};

class GuiSeeker : public QWidget 
{
	Q_OBJECT
	
	QApplication *m_app;
	QTimer m_timer;
	QSlider *m_slider;
	QBoxLayout *m_videoLayout;
	QXEmbed *m_xembed;
	Thread *m_pipeline;
	Element *m_audiosink;
	Element *m_videosink;
	unsigned long long m_duration;
	
	QPushButton *m_playButton;
	QPushButton *m_pauseButton;
	QPushButton *m_stopButton;

	static void haveXid(void *, int xid, GuiSeeker *cookie);
	static void haveSize(void *, int width, int height, void *cookie);
	virtual void customEvent(QCustomEvent *e);

public:
	GuiSeeker(QApplication*);
	~GuiSeeker();

	void makeSpiderPipeline(const QString &file);

private slots:
	void play();
	void pause();
	void stop();
	void seek();
	void updateSlider();
};

#endif
