/*
 * Helloworld example ported from the GStreamer sources:
 * Plays a mp3 file on the default OSS device.
 */

#include <kde/gst/gstreamer.h>
#include <kde/gst/element.h>
#include <kde/gst/elementfactory.h>
#include <kde/gst/bin.h>
#include <kde/gst/pipeline.h>

#include <qglobal.h>

using namespace KDE::GST;


int main (int argc, char *argv[]) 
{
	Pipeline *bin;
	Element *filesrc, *decoder, *osssink;
	
	GStreamer::init(&argc, &argv);
	
	if (argc != 2) {
		qDebug("\nusage: helloworld <mp3 file>\n");
		qDebug("(note that the file is played via OSS, so disable arts or use artsdsp)\n");
		return -1;
	}
	
	/* create a new bin to hold the elements */
	bin = new Pipeline("pipeline");
	
	/* create a disk reader */
	filesrc = ElementFactory::make("filesrc", "disk_source");
	Q_ASSERT(filesrc);
	filesrc->setString("location", argv[1]);
	
	/* now it's time to get the decoder */
	decoder = ElementFactory::make("mad", "decode");
	if (!decoder) {
		qDebug("could not find plugin \"mad\"");
		return -1;
	}
	/* and an audio sink */
	osssink = ElementFactory::make("osssink", "play_audio");
	Q_ASSERT(osssink);
	
	/* add objects to the main pipeline */
	bin->add(filesrc, decoder, osssink);
	
	/* connect the elements */
	filesrc->link(decoder);
	decoder->link(osssink);
	
	/* start playing */
	bin->setState(Element::STATE_PLAYING);
	
	while (bin->iterate());
	
	/* stop the bin */
	bin->setState(Element::STATE_NULL);
	
	return 0;
}

