/*
 * Based on Helloworld example from the GStreamer sources:
 * Plays an arbitrary audio file on the default OSS device using a thread.
 */

#include <kde/gst/gstreamer.h>
#include <kde/gst/element.h>
#include <kde/gst/elementfactory.h>
#include <kde/gst/bin.h>
#include <kde/gst/pipeline.h>
#include <kde/gst/thread.h>

#include <qglobal.h>

using namespace KDE::GST;


/* eos will be called when the src element has an end of stream */
void eos(Element *, void *data) 
{
  Q_ASSERT(data != NULL);
  Thread *thread = (Thread*)data;
  qDebug("have eos, quitting\n");

  /* stop the bin */
  thread->setState(Element::STATE_NULL);

  GStreamer::mainQuit();
}

int main(int argc,char *argv[])
{
  Element *filesrc, *osssink, *decoder;
  Thread *thread;

  GStreamer::init(&argc,&argv);

  if (argc != 2) {
    qDebug("\nusage: %s <filename>\n", argv[0]);
    qDebug("(note that the file is played via OSS, so disable arts or use artsdsp)\n");
    return -1;
  }

  /* create a new thread to hold the elements */
  thread = new Thread("thread");
  Q_ASSERT(thread != NULL);

  /* create a disk reader */
  filesrc = ElementFactory::make("filesrc", "disk_source");
  Q_ASSERT(filesrc != NULL);
  filesrc->setString("location", argv[1]);
  filesrc->registerEosCallback(eos, thread);

  /* the autoplugging element, */
  decoder = ElementFactory::make("spider", "decoder");
  if (!decoder) {
    qDebug("could not find plugin \"spider\"");
    return -1;
  }

  /* and an audio sink */
  osssink = ElementFactory::make("osssink", "play_audio");
  Q_ASSERT(osssink != NULL);
  
  thread->add(filesrc, decoder, osssink);
  filesrc->link(decoder, osssink);

  /* make it ready */
  thread->setState(Element::STATE_READY);
  
  /* start playing */
  thread->setState(Element::STATE_PLAYING);

  GStreamer::main();
  qDebug("done\n");

  delete thread;

  return 0;
}

