/*
 * Plays a video through two filters (EffecTV's agingTV and warpTV),
 * displayed using xvideosink.
 */

#include <kde/gst/gstreamer.h>
#include <kde/gst/element.h>
#include <kde/gst/elementfactory.h>
#include <kde/gst/pipeline.h>

#include <qglobal.h>

using namespace KDE::GST;


int main (int argc, char *argv[]) 
{
	Pipeline *bin;
	Element *filesrc, *decoder, *agingFilter, *warpFilter;
	Element *colorspaceConverter, *videosink;
	
	GStreamer::init(&argc, &argv);
	
	if (argc != 2) {
		qDebug("\nusage: videofilter <video file>\n");
		return -1;
	}

	/* create a new bin to hold the elements */
	bin = new Pipeline("pipeline");

	/* create a disk reader */
	filesrc = ElementFactory::make("filesrc", "disk_source");
	Q_ASSERT(filesrc);
	filesrc->setString("location", argv[1]);
	
	/* use spider as decoder */
	decoder = ElementFactory::make("spider", "decoder");
	Q_ASSERT(decoder);

	/* create video filter 1 */
	agingFilter = ElementFactory::make("agingTV", "aging_filter");
	Q_ASSERT(agingFilter);

	/* create video filter 2 */
	warpFilter = ElementFactory::make("warpTV", "warp_filter");
	Q_ASSERT(warpFilter);

	/* color space converter (EffecTV creates RGB images) */
	colorspaceConverter = ElementFactory::make("colorspace", "cconv");
	Q_ASSERT(colorspaceConverter);
	
	/* and a video sink */
	videosink = ElementFactory::make("xvideosink", "video_sink");
	Q_ASSERT(videosink);
	
	/* add objects to the main pipeline */
	bin->add(filesrc, decoder, agingFilter, warpFilter);
	bin->add(colorspaceConverter, videosink);
	
	/* connect the elements */
	filesrc->link(decoder, agingFilter, warpFilter,
		      colorspaceConverter, videosink);
	
	/* start playing */
	bin->setState(Element::STATE_PLAYING);
	
	while (bin->iterate());
	
	/* stop the bin */
	bin->setState(Element::STATE_NULL);
	
	return 0;
}

