/*
 *  Wrapper base class for GstCaps
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "caps.h"
#include "props.h"

extern "C" {
#include <gst/gst.h>
}

using namespace KDE::GST;


#define r() GST_CAPS(m_real)

Caps::Caps(void *real) :
	SimpleWrapper(real) {
}

Caps::~Caps() {
	if (m_real)
		gst_caps_destroy(GST_CAPS(m_real));
}

Caps::Caps(const QString &name, 
	   const QString &mime, 
	   Props *props) :
	SimpleWrapper(0) {
	m_real = gst_caps_new(name.latin1(),
			      mime.latin1(),
			      (GstProps*)props->realObject());
	addToMap();
}

Caps::Caps(const QString &name, 
	   const unsigned short id, 
	   Props *props) :
	SimpleWrapper(0) {
	m_real = gst_caps_new_id(name.latin1(),
				 id,
				 (GstProps*)props->realObject());
	addToMap();
}

Caps* Caps::wrap(void *real) {
	return (Caps*) SimpleWrapper::wrap(real);
}

Caps* Caps::ref() {
	return wrap(gst_caps_ref(r()));
}

Caps* Caps::unref() {
	return wrap(gst_caps_unref(r()));
}

Caps* Caps::copy() {
	return wrap(gst_caps_copy(r()));
}

Caps* Caps::copy1() {
	return wrap(gst_caps_copy_1(r()));
}

Caps* Caps::copyOnWrite() {
	return wrap(gst_caps_copy_on_write(r()));
}

Caps* Caps::chain(Caps *caps1,
		  Caps *caps2,
		  Caps *caps3,
		  Caps *caps4,
		  Caps *caps5) {
	if (!caps2)
		return Caps::wrap(gst_caps_chain(r(), 
					GST_CAPS(caps1->realObject())));
	else if (!caps3)
		return Caps::wrap(gst_caps_chain(r(), 
					GST_CAPS(caps1->realObject()),
					GST_CAPS(caps2->realObject())));
	else if (!caps4)
		return Caps::wrap(gst_caps_chain(r(), 
					GST_CAPS(caps1->realObject()),
					GST_CAPS(caps2->realObject()),
					GST_CAPS(caps3->realObject())));
	else if (!caps5)
		return Caps::wrap(gst_caps_chain(r(), 
					GST_CAPS(caps1->realObject()),
					GST_CAPS(caps2->realObject()),
					GST_CAPS(caps3->realObject()),
					GST_CAPS(caps4->realObject())));
	else
		return Caps::wrap(gst_caps_chain(r(), 
					GST_CAPS(caps1->realObject()),
					GST_CAPS(caps2->realObject()),
					GST_CAPS(caps3->realObject()),
					GST_CAPS(caps4->realObject()),
					GST_CAPS(caps5->realObject())));
}

Caps* Caps::append(Caps *capstoadd) {
	gst_caps_append(r(), GST_CAPS(capstoadd));
	return this;
}

Caps* Caps::prepend(Caps *capstoadd) {
	gst_caps_prepend(r(), GST_CAPS(capstoadd));
	return this;
}

void Caps::setName(const QString &name) {
	gst_caps_set_name(r(), name.latin1());
}

QString Caps::getName() {
	return QString(gst_caps_get_name(r()));
}

void Caps::setTypeId(unsigned short typeId) {
	gst_caps_set_type_id(r(), typeId);
}

unsigned short Caps::getTypeId() {
	return gst_caps_get_type_id(r());
}

void Caps::setMime(const QString &mime) {
	gst_caps_set_mime(r(), mime.latin1());
}

QString Caps::getMime() {
	return QString(gst_caps_get_mime(r()));
}

Caps* Caps::setProps(Props *props) {
	gst_caps_set_props(r(), (GstProps*)props->realObject());
	return this;
}

Props* Caps::props() {
	return Props::wrap(gst_caps_get_props(r()));
}

Caps* Caps::normalize() {
	return wrap(gst_caps_normalize(r()));
}

Caps* Caps::intersect(Caps *caps2) {
	return wrap(gst_caps_intersect(r(), GST_CAPS(caps2->m_real)));
}

Caps* Caps::getByName(const QString &name) {
	return wrap(gst_caps_get_by_name(r(), name.latin1()));
}
