/*
 *  Wrapper/interface class for GstData
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *  API Documentation
 *  Copyright (C) 1999,2000 Erik Walthinsen <omega@cse.ogi.edu>
 *                     2000 Wim Taymans <wtay@chello.be>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef KDE_GST_EVENT_H
#define KDE_GST_EVENT_H

#include <kde/gst//simplewrapper.h>


namespace KDE {
namespace GST {
	class Object;

	/**
	 * This abstract structure provides a common base for Buffer, 
	 * BufferPool and @ref Event (note that the KDE bindings only support Event). 
	 * It is the main data type that is passed along in a pipeline. Data provides 
	 * refcounting, freeing and copying for its child classes.
	 */

	class Data : public SimpleWrapper {
	private:
		void *reserved;
			
	public:
	  
		/**
		 * Copies the given @ref Data. This function will call the custom subclass
		 * copy function or return 0 if no function was provided by the subclass.
		 *
		 * @data: a #GstData to copy
		 * @return a copy of the data or 0 if the data cannot be copied. The refcount
		 * of the original buffer is not changed so you should unref it when you don't
		 * need it anymore.
		 */
		Data* copy (const Data *data);

		/**
		 * gst_data_copy_on_write:
		 * @data: a #GstData to copy
		 *
		 * Copies the given #GstData if the refcount is greater than 1 so that the
		 * #GstData object can be written to safely.
		 *
		 * Returns: a copy of the data if the refcount is > 1 or the buffer is 
		 * marked READONLY, data if the refcount == 1,
		 * or NULL if the data could not be copied. The refcount of the original buffer
		 * is decreased when a copy is made, so you are not supposed to use it after a
		 * call to this function.
		 */
		Data* copyOnWrite(Data *data);


			
	};
}
}

#endif
