/*
 *  Interface/wrapper for GStreamer GstDParam
 *  Copyright (C) 2003 Tim Jansen <tim@tjansen.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "dparam.h"
#include "element.h"


extern "C" {
#include <gst/gst.h>
#include <gst/control/control.h>
}

using namespace KDE::GST;
using namespace KDE::GST::DP;

#define r() GST_DPARAM(m_real)

// helper factory function for classMap. See used in gstreamer.cpp
Wrapper* DParam::wrapperFactory(void *real) {
	return new DParam(real);
}

DParam::DParam(void *real) :
	Object(real) {
}
DParam::~DParam() {
}

DParam* DParam::wrap(void *real) {
	return (DParam*) Object::wrap(real);
}

DParam::DParam(Type type) :
	Object(0) {
  
	GType gtype;
	switch (type) {
	case Float:
		gtype = G_TYPE_FLOAT;
		break;
	case Int:
		gtype = G_TYPE_INT;
		break;
	case Int64:
		gtype = G_TYPE_INT64;
		break;
	}

	m_real = gst_dparam_new(gtype);
	registerReal();
}

#include "dparam.moc"

