/*
 *  Interface/wrapper for GStreamer GstDParam
 *  Copyright (C) 2003 Tim Jansen <tim@tjansen.de>
 *  API Documentation
 *  Copyright (C) 2001 Steve Baker <stevebaker_org@yahoo.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef KDE_GST_DP_DPARAM_H
#define KDE_GST_DP_DPARAM_H

#include <kde/gst/object.h>


namespace KDE {
namespace GST {
namespace DP {

/**
 * @see DParamManager
 */
	class DParam : public KDE::GST::Object {
	Q_OBJECT
	private:
                friend class GStreamer;
                static Wrapper* wrapperFactory(void *real);
		void *reserved;
		
	public:

		/**
		 * The types that are supported by DParam
		 */
		enum Type {
			/// float value type
			Float,
			/// 32 bit integer type
			Int, 
			/// 64 bit integer type
			Int64
		};

/**
 * Creates a new DParam that wrapps the given GstDParam. 
 * Usually you really don't want to call this, use @ref #wrap instead.
 * You must not create a object of this class on the stack, always 
 * use new.
 * @param real the GstDParam to be wrapped
 */
	        DParam(void *real);
	        virtual ~DParam();

/**
 * Creates a new DParam that wrapps the given GstDParam. 
 * Unlike the DParam constructor this function also re-uses 
 * existing wrapper objects.
 *
 * @param real the GstDParam to be wrapped
 * @return the wrapped DParam
 */
		static DParam* wrap(void *real);

		
/**
 * Creates a new DParam. 
 *
 * @param type the type that this dparam will store
 */
		DParam(Type type);

	};
}
}
}

#endif
