/*
 *  Interface/wrapper for GStreamer GstDParamSmooth
 *  Copyright (C) 2003 Tim Jansen <tim@tjansen.de>
 *  API Documentation
 *  Copyright (C) 2001 Steve Baker <stevebaker_org@yahoo.co.uk>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef QGST_DP_DPARAMSMOOTH_H
#define QGST_DP_DPARAMSMOOTH_H

#include <kde/gst/dparam.h>


namespace KDE {
namespace GST {
namespace DP {

/**
 * @see DParamManager
 */
	class DParamSmooth : public DParam {
	Q_OBJECT
	private:
                friend class GStreamer;
                static Wrapper* wrapperFactory(void *real);
		void *reserved;
		
	public:

/**
 * Creates a new DParamSmooth that wrapps the given GstDParamSmooth. 
 * Usually you really don't want to call this, use @ref #wrap instead.
 * You must not create a object of this class on the stack, always 
 * use new.
 * @param real the GstDParamSmooth to be wrapped
 */
	        DParamSmooth(void *real);
	        virtual ~DParamSmooth();

/**
 * Creates a new DParamSmooth that wrapps the given GstDParamSmooth. 
 * Unlike the DParamSmooth constructor this function also re-uses 
 * existing wrapper objects.
 *
 * @param real the GstDParamSmooth to be wrapped
 * @return the wrapped DParamSmooth
 */
		static DParamSmooth* wrap(void *real);

		
/**
 * Creates a new DParamSmooth. 
 *
 * @param type the type that this dparam will store
 */
		DParamSmooth(Type type);

	};
}
}
}
#endif
