/*
 *  Wrapper/Interface class for GstEvent
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "event.h"
#include "object.h"

extern "C" {
#include <gst/gst.h>
}

using namespace KDE::GST;

#define r() GST_EVENT(m_real)

Event::Event(void *real) :
	SimpleWrapper(real) {
}

Event::~Event() {
	if (m_real)
		gst_event_unref(r());
}

Event* Event::wrap(void *real) {
	return (Event*) SimpleWrapper::wrap(real);
}

Event::Event(EventType type) :
	SimpleWrapper(0) {
	m_real = gst_event_new((GstEventType)type);
	addToMap();
}

Event::Event(SeekType type, long long offset) :
	SimpleWrapper(0) {
	m_real = gst_event_new_seek((GstSeekType)type, offset);
	addToMap();	
}

Event::Event(SeekType type, long long start, long long stop) :
	SimpleWrapper(0) {
	m_real = gst_event_new_segment_seek((GstSeekType)type, start, stop);
	addToMap();	
}

Event::Event(bool newMedia, 
	     Format format1,
	     Format format2,
	     Format format3,
	     Format format4,
	     Format format5) :
	SimpleWrapper(0) {
	m_real = gst_event_new_discontinuous(newMedia ? TRUE : FALSE,
					     (GstFormat)format1, 
					     (GstFormat)format2, 
					     (GstFormat)format3,
					     (GstFormat)format4, 
					     (GstFormat)format5);
	addToMap();	
}

Event* Event::copy() {
	return wrap(gst_event_copy(r()));
}

void Event::unref() {
	gst_event_unref(r());
}

Event *Event::ref() {
	return wrap(gst_event_ref(r()));
}

Event *Event::ref(int count) {
	return wrap(gst_event_ref_by_count(r(), count));
}

bool Event::discontGetValue(Format format, long long *value) {
	return gst_event_discont_get_value(r(), 
					   (GstFormat)format, 
					   value);
}

Event::EventType Event::type() {
	return (EventType) GST_EVENT_TYPE(r());
}

Object* Event::source() {
	return Object::wrap(GST_EVENT_SRC(r()));
}

unsigned long long Event::timestamp() {
	return GST_EVENT_TIMESTAMP(r());
}

Event::SeekType Event::seekType() {
	return (SeekType) GST_EVENT_SEEK_TYPE(r());
}

int Event::seekFormat() {
	return GST_EVENT_SEEK_FORMAT(r());
}

Event::SeekType Event::seekMethod() {
	return (SeekType) GST_EVENT_SEEK_METHOD(r());
}

Event::SeekType Event::seekFlags() {
	return (SeekType) GST_EVENT_SEEK_FLAGS(r());
}

long long Event::seekOffset() {
	return GST_EVENT_SEEK_OFFSET(r());
}

Event::SeekAccuracy Event::seekAccuracy() {
	return (SeekAccuracy) GST_EVENT_SEEK_ACCURACY(r());
}

