/*
 *  Helper functions for Qt<->GLib conversion
 *
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef KDE_GST_HELPER_H
#define KDE_GST_HELPER_H

#include "wrapper.h"
#include "simplewrapper.h"

#include <glib.h>
#include <qvaluevector.h>

#define CONVERT_GBOOL(x) ((x) ? true : false)
/*
template<Wrapper T>
QValueVector<T*> convertList(const GList *l) {
	GList *f = g_list_first(l);
	GList *last = g_list_last(l);

	QValueVector<T*> v(g_list_length(l));
	if (!l)
		return v;

	do {
		v.push_back(T::wrap(f->data));
		if (f == last)
			return v;
		f = g_list_next(f);
	} while (true);
}

template<SimpleWrapper T>
QValueVector<T*> convertList(const GList *l) {
	GList *f = g_list_first(l);
	GList *last = g_list_last(l);

	QValueVector<T*> v(g_list_length(l));
	if (!l)
		return v;

	do {
		v.push_back(T::wrap(f->data));
		if (f == last)
			return v;
		f = g_list_next(f);
	} while (true);
}
*/

template<class T>
QValueVector<T*> convertList(const GList *l) {
	const GList *f = g_list_first((GList*)l);
	const GList *last = g_list_last((GList*)l);

	QValueVector<T*> v(g_list_length((GList*)l));
	if (!l)
		return v;

	do {
		v.push_back(T::wrap(f->data));
	//		v.push_back(f->data);
		if (f == last)
			return v;
		f = g_list_next((GList*)f);
	} while (true);
}

#endif
