/*
 *  Interface/wrapper for GStreamer GstPadTemplate
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include "padtemplate.h"
#include "caps.h"

extern "C" {
#include <gst/gst.h>
}

using namespace KDE::GST;

#define r() GST_PAD_TEMPLATE(m_real)

// helper factory function for classMap. See used in gstreamer.cpp
Wrapper* PadTemplate::wrapperFactory(void *real) {
	return new PadTemplate(real);
}

PadTemplate::PadTemplate(void *real) :
	Object(real) {
}

PadTemplate::~PadTemplate() {
}

PadTemplate* PadTemplate::wrap(void *real) {
	return (PadTemplate*) Object::wrap(real);
}

/**
 * Creates a new padtemplate from the given arguments.
 *
 * @param nameTemplate the name template
 * @param direction the direction for the template
 * @param presence the presence of the pad
 * @param caps capabilities for the template
 */
PadTemplate::PadTemplate(const QString &nameTemplate,
			 Pad::Direction direction, 
			 Presence presence,
			 Caps *caps1,
			 Caps *caps2,
			 Caps *caps3,
			 Caps *caps4,
			 Caps *caps5) :
	Object(0) { 
#define ox(x) ((x) ? (GST_CAPS((x)->realObject())) : 0)
	m_real = gst_pad_template_new(nameTemplate.latin1(),
				      (GstPadDirection)direction, 
				      (GstPadPresence)presence,
				      ox(caps1),
				      ox(caps2),
				      ox(caps3),
				      ox(caps4),
				      ox(caps5),
				      0);
	registerReal();
#undef ox
}

/**
 * Get the capabilities of the padtemplate
 *
 * @return a Caps*
 */
Caps* PadTemplate::getCaps() {
	return Caps::wrap(gst_pad_template_get_caps(r()));
}

/**
 * Get the capability with the given name from this padtemplate.
 *
 * @param name the name of the capability to get
 * @return a capability or NULL if not found
 */
Caps* PadTemplate::getCapsByName(const QString &name) {
	return Caps::wrap(gst_pad_template_get_caps_by_name(r(), 
							    name.latin1()));
}

/**
 * Get the direction of the padtemplate.
 *
 * @return the direction
 */
Pad::Direction PadTemplate::direction() {
	return (Pad::Direction) GST_PAD_TEMPLATE_DIRECTION(r());
}

/**
 * Get the nametemplate of the padtemplate.
 *
 * @return the nametemplate
 */
QString PadTemplate::nameTemplate() {
	return QString(GST_PAD_TEMPLATE_NAME_TEMPLATE(r()));
}

/**
 * Get the presence of the padtemplate.
 *
 * @return the presence
 */
PadTemplate::Presence PadTemplate::presence() {
	return (Presence) GST_PAD_TEMPLATE_PRESENCE(r());
}

/**
 * (DISABLED BECAUSE OF A BUG in 0.6.0)
 * Check if the properties of the padtemplate are fixed.
 *
 * @return true if the padtemplate is fixed
 */
bool PadTemplate::isFixed() {
  // TODO: re-enable (disabled because of bug in 0.6.0)
  //	return GST_PAD_TEMPLATE_IS_FIXED(r());
  return false;
}

#include "padtemplate.moc"

