/*
 *  Interface/wrapper for GStreamer GstParse
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *  API Documentation
 *  Copyright (C) 1999,2000 Erik Walthinsen <omega@cse.ogi.edu>
 *                     2000 Wim Taymans <wtay@chello.be>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef KDE_GST_PARSE_H
#define KDE_GST_PARSE_H

#include <qstring.h>

namespace KDE {
namespace GST {

	class Bin;
/**
 * These functions allows you to create a pipeline from a command
 * line syntax description. The following example creates a simple
 * mp3 player.
 * <pre>
 *    Pipeline *pipeline;
 *    QString error;
 *    // create a pipeline to hold our elements
 *    pipeline = new Pipeline("launch");
 *    // build a pipeline
 *    pipeline = Parse::launch ("filesrc location=some.mp3 ! mad ! osssink",
 *				error);
 *    Q_ASSERT(pipeline);
 *
 *    // play the thing 
 *    pipelinesetState(Element::STATE_PLAYING);
 * 
 *    while (pipeline->iterate());
 * 
 *    pipeline->setState(Element::STATE_NULL);
 * </pre>
 *
 * Elements are separated with a !, properties are set with 
 * property=value, specific pads of an element are selected by replacing 
 * the ! with padname!.
 *
 * Elements can be added to a bin by embracing them with (). Threads
 * can be made with {}. 
 * 
 * @short Parses commandline syntax into a pipeline.
 */
	class Parse {
	private:
		void *reserved;
			
	public:
/**
 * Create a new pipeline based on command line syntax.
 * 
 * @param pipelineDescription the command line describing the pipeline
 * @param errorMsg the error message in case of a failure will be written
 *                 in this string
 * @return a new bin on success, NULL on failure. By default the bin is
 * a Pipeline, but it depends on the pipelineDescription.
 */
		static Bin *launch(const QString &pipelineDescription,
				   QString &errorMsg);

/**
 * Create a new pipeline based on command line syntax.
 *
 * @param argv null-terminated array of arguments
 * @param errorMsg the error message in case of a failure will be written
 *                 in this string
 * @return a new bin on success, NULL on failure. By default the bin is
 * a Pipeline, but it depends on argv.
 */
		static Bin *launchv(const char **argv, QString &errorMsg);
	};
}
}

#endif
