/*
 *  Interface/wrapper for GStreamer GstPIpeline
 *  Copyright (C) 2002 Tim Jansen <tim@tjansen.de>
 *  API Documentation
 *  Copyright (C) 1999,2000 Erik Walthinsen <omega@cse.ogi.edu>
 *                     2000 Wim Taymans <wtay@chello.be>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef KDE_GST_PIPELINE_H
#define KDE_GST_PIPELINE_H

#include <kde/gst//bin.h>

namespace KDE {
namespace GST {

/**
 * In almost all cases, you'll want to use a Pipeline when creating a
 * filter graph.  The Pipeline will manage all the scheduling issues,
 * including threading, as well as provide simple interfaces to common
 * functions, like 'Play'.
 * 
 * When you are done with the pipeline, use @ref #unref() to free its resources.
 *
 * @short Top-level bin with scheduling and pipeline management functionality.
 * @see Bin
 */
	class Pipeline : public Bin {
	Q_OBJECT
	private:
                friend class GStreamer;
                static Wrapper* wrapperFactory(void *real);
		void *reserved;
		
	public:

/**
 * Creates a new Pipeline that wrapps the given GstPipeline. Usually
 * you really don't want to call this, use @ref #wrap instead.
 * You must not create a object of this class on the stack, always 
 * use new.
 * @param real the GstPipeline to be wrapped
 */
	        Pipeline(void *real);
	        virtual ~Pipeline();

/**
 * Creates a new Pipeline that wrapps the given GstPipeline
 * If there is already a wrapper object it will be re-used. 
 *
 * @param real the GstPipeline to be wrapped
 * @return the wrapped Pipeline (or derivative)
 */
		static Pipeline* wrap(void *real);

/**
 * Create a new Pipeline with given name.
 *
 * @param name name of new Pipeline (or QString::null for auto naming)
 */
		Pipeline(const QString &name = QString::null);
	};
}
}

#endif
